function plot_norm_window_energy_box(case_ids, controller_ids, cases, norm_id, time_window)
for iC = 1:length(case_ids)
    data = zeros( ...
        size(cases.energy_window{case_ids(1), controller_ids(1)},1), ...
        length(controller_ids));

    for iiC = 1:length(controller_ids)
        % plot(cases.t(1:size(cases.energy_window{case_ids(iC), controller_ids(iiC)},1)), ...
        %     sum(cases.energy_window{case_ids(iC), controller_ids(iiC)},2) ./ ...
        %     sum(cases.energy_window{case_ids(iC), controller_ids(norm_id)},2), ...
        %     'LineWidth',1, ...
        %     'Color',cases.colors(controller_ids(iiC),:), ...
        %     'LineStyle',cases.line{controller_ids(iiC)})
        
        data(:,iiC) = sum(cases.energy_window{case_ids(iC), controller_ids(iiC)},2) ./ ...
            sum(cases.energy_window{case_ids(iC), controller_ids(norm_id)},2);
    end


    figure
    hold on
    boxplot(data,'Labels',cases.names(controller_ids))
    
    grid on
    %legend(cases.names(controller_ids),'Location','best')
    xlabel('Controller')
    ylabel(['Normalized Energy over ' num2str(time_window) ' s'])
    title(cases.case_names{case_ids(iC)})
end
end