function plot_norm_window_energy(case_ids, controller_ids, cases, norm_id, time_window)
for iC = 1:length(case_ids)
    figure
    hold on
    for iiC = 1:length(controller_ids)
        plot(cases.t(1:size(cases.energy_window{case_ids(iC), controller_ids(iiC)},1)), ...
            sum(cases.energy_window{case_ids(iC), controller_ids(iiC)},2) ./ ...
            sum(cases.energy_window{case_ids(iC), controller_ids(norm_id)},2), ...
            'LineWidth',1, ...
            'Color',cases.colors(controller_ids(iiC),:), ...
            'LineStyle',cases.line{controller_ids(iiC)})
    end
    grid on
    legend(cases.names(controller_ids),'Location','best')
    xlabel('Time in h')
    ylabel(['Normalized Energy over ' num2str(time_window) ' s'])
    title(cases.case_names{case_ids(iC)})
    xlim([cases.t(1), cases.t(end)])
end
end