function plot_misalignment_historgram(case_ids, controller_ids, cases)
for iC = 1:length(case_ids)
    figure
    hold on
    for iiC = 1:length(controller_ids)
        misalignment = ...
            - cases.yaw_ori{case_ids(iC), controller_ids(iiC)} + ...
            interp1(cases.dir_domain{case_ids(iC)}(:,1), ...
                cases.dir_domain{case_ids(iC)}(:,2), cases.t)';

        %histogram(misalignment(:),linspace(-50.5,50.5,102), ...
        histogram(misalignment(:),-50.5:1:50.5, ...
            'DisplayStyle','stairs','Normalization','cdf',...
            'EdgeColor',cases.colors(controller_ids(iiC),:), ...
            'LineStyle',cases.line{controller_ids(iiC)})

        % plot(cases.t, ...
        %     sum(cases.energy{case_ids(iC), controller_ids(iiC)},2) ./ ...
        %     sum(cases.energy{case_ids(iC), controller_ids(norm_id)},2), ...
        %     'LineWidth',1, ...
        %     'Color',cases.colors(controller_ids(iiC),:), ...
        %     'LineStyle',cases.line{controller_ids(iiC)})
    end
    grid on
    legend(cases.names(controller_ids),'Location','best')
    xlabel('Misalignment in deg')
    ylabel('Probability')
    title(cases.case_names{case_ids(iC)})
    xlim([-30,30])
end
end