function plot_final_energy_over_yaw_travel(case_ids, controller_ids, cases, norm_id)
for iC = 1:length(case_ids)
    legend_names = {};
    i_legend = 1;
    figure
    hold on
    for iiC = 1:length(controller_ids)
        scatter( ...
            cases.yaw_travel{case_ids(iC), controller_ids(iiC)}(end)/ ...
            cases.yaw_travel{case_ids(iC), controller_ids(norm_id)}(end), ...
            sum(cases.energy{case_ids(iC), controller_ids(iiC)}(end,:),2)/ ...
            sum(cases.energy{case_ids(iC), controller_ids(norm_id)}(end,:),2), ...
            100,cases.colors(controller_ids(iiC),:),"filled", ...
            cases.marker{controller_ids(iiC)})
        legend_names{i_legend} = cases.names{controller_ids(iiC)};
        i_legend = i_legend + 1;
        if sum(cases.links(controller_ids(iiC),:))>1
            indx = find(cases.links(controller_ids(iiC),:));
            for iL = 1:length(indx)
                if indx(iL) == iiC; continue; end 
                try
                    plot([ ...
                        cases.yaw_travel{case_ids(iC), controller_ids(iiC)}(end)/ ...
                        cases.yaw_travel{case_ids(iC), controller_ids(norm_id)}(end), ...
                        cases.yaw_travel{case_ids(iC), (indx(iL))}(end)/ ...
                        cases.yaw_travel{case_ids(iC), controller_ids(norm_id)}(end)], ...
                        [sum(cases.energy{case_ids(iC), controller_ids(iiC)}(end,:),2)/ ...
                        sum(cases.energy{case_ids(iC), controller_ids(norm_id)}(end,:),2) ...
                        sum(cases.energy{case_ids(iC), (indx(iL))}(end,:),2)/ ...
                        sum(cases.energy{case_ids(iC), controller_ids(norm_id)}(end,:),2)], ...
                        'Color',cases.colors(controller_ids(iiC),:), ...
                        'LineStyle',cases.line{controller_ids(iiC)}, ...
                        'LineWidth',1.5)

                    legend_names{i_legend} = '';
                    i_legend = i_legend + 1;
                catch
    
                end
            end
        end
    end
    grid on
    legend(legend_names,'Location','best')
    ylabel('Norm. Energy in MWh/MWh')
    xlabel('Norm. Yaw travel in deg/deg')
    title(cases.case_names{case_ids(iC)})
end
end