function cases = load_yaw(cases, case_ids, controller_ids)
%loads the power of the cases
cases.t = 31200:.5:42000;
for iC = 1:length(case_ids)
for iiC = 1:length(controller_ids)
    try
        switch case_ids(iC)
            case 1
                idx_load = ...
                    find(cases.HKN_00_to_03.types == controller_ids(iiC));
                yaw_data = readmatrix([cases.HKN_00_to_03.paths_to{idx_load}, ...
                    'nacYaw']);
            case 2
                idx_load = ...
                    find(cases.HKN_06_to_09.types == controller_ids(iiC));
                yaw_data = readmatrix([cases.HKN_06_to_09.paths_to{idx_load}, ...
                    'nacYaw']);
            case 3
                idx_load = ...
                    find(cases.HKN_12_to_15.types == controller_ids(iiC));
                yaw_data = readmatrix([cases.HKN_12_to_15.paths_to{idx_load}, ...
                    'nacYaw']);
            otherwise
                error("Case doesn't exist, only 1 to 3")
        end
        
    catch
        warning(['Loading of case ' num2str(case_ids(iC)) ...
            ', controller nr ' num2str(controller_ids(iiC)) ' failed.'])
        continue;
    end
    t_tmp = yaw_data(:,2);
    yaw_data = reshape(yaw_data(t_tmp>=31200,4) , 10, [])';

    if t_tmp(end)<42000
        warning(['Yaw data of case ' num2str(case_ids(iC)) ...
            ', controller nr ' num2str(controller_ids(iiC)) ' is ' ...
            num2str(42000 - t_tmp(end)) ... 
            ' s too short. Adding constant values for the remaining time.'])
        yaw_data = [yaw_data; repmat(yaw_data(end,:), ...
            length(cases.t) - length(t_tmp(t_tmp>=31200))/10,1)];
    end

    cases.yaw_ori{case_ids(iC), controller_ids(iiC)}    = yaw_data;
    cases.yaw_travel{case_ids(iC), controller_ids(iiC)} = ...
        [0;cumsum(sum(abs(diff(yaw_data)),2))];
    cases.yaw_travel_diff{case_ids(iC), controller_ids(iiC)} = ...
        [zeros(1,10); abs(diff(yaw_data))];

    % Calculate activations
    cases.yaw_activations{case_ids(iC), controller_ids(iiC)} = ...
        cumsum(...
        [false(1,10); diff(cases.yaw_travel_diff{case_ids(iC), controller_ids(iiC)})>0.01]);

end

end

