path2here = '/Users/marcusbecker/surfdrive/PhD_Surf/01_Research/01_FLORIDyn/02_Matlab/marcusbecker@hpc06.tudelft.net/Simulations/2024_CLC/10T_HKN_12_to_15_177deg/Results/';

case_folders = {
    'Case2024_08_23_11_39_08/', ...
    'Case2024_08_28_15_33_29/', ...
    'Case2024_09_03_22_57_56/', ...
    'Case2024_09_12_17_34_57/', ...
    'Case2024_09_24_03_24_33/Case2024_09_24_03_24_33/', ...
    'Case2024_10_02_20_20_53/'};

CLC_folder = 'Con_Optimization_groups/';

EnKF_folder = 'EnKF_Time/';

%% EnKF Timing
enkf_data_mean = zeros(6,3);
enkf_data_std  = zeros(6,3);

for iC = 2:length(case_folders)
    data = readmatrix([path2here case_folders{iC} EnKF_folder 'time_sim_com_cor.csv']);

    enkf_data_mean(iC, :) = mean(data(:,2:end));
    enkf_data_std(iC, :)  = std(data(:,2:end));
end


%% Control
data_mean = zeros(length(case_folders),10);
data_mean2many = zeros(length(case_folders),10);
data_mean_ok = zeros(length(case_folders),10);

data_col = [];
i_d = 1;

figure 
hold on
for iC = 1:length(case_folders)
    dirs = dir([path2here case_folders{iC} CLC_folder]);
    data    = -ones(length(dirs)-2,10);
    too_many = false(length(dirs)-2,1);
    
    

    for iD = 3:length(dirs)
        if contains(dirs(iD).name, 'time'); continue; end
        data_loaded = readmatrix([dirs(iD).folder filesep dirs(iD).name]);
        nT = 0;
        for iL = 1:size(data_loaded,1)
            data(iD-2,sum(data_loaded(iL,1:end-1))) = data_loaded(iL,end);
            nT = nT + sum(data_loaded(iL,1:end-1));
            data_col(i_d,1:2) = [sum(data_loaded(iL,1:end-1)), data_loaded(iL,end)];
            i_d = i_d + 1;
        end
        too_many(iD-2) = nT > 10;
    end

    plot(data_col(:,1), data_col(:,2),'.')
    empty_data = sum(data>0,2) == 0;
    data      = data(~empty_data, :);
    too_many  = too_many(~empty_data, :);

    % mean(data(too_many,:))
    % mean(data(~too_many,:))
    data_mean(iC,:)         = mean(data);
    data_mean2many(iC,:)    = mean(data(too_many,:));
    data_mean_ok(iC,:)      = mean(data(~too_many,:));
end

set(gca,'YScale','log')

grid on

%%
for iT = 1:6
    disp(iT)
    disp(mean(data_col(data_col(:,1)==iT,2)))
    disp(std(data_col(data_col(:,1)==iT,2)))
end