function cases = get_paths_and_types(local)
% Returns the paths to the turbine outputs and the types of controllers
% Path to case
path_12_to_15 = ['HKN_12_to_15h_data' filesep];

%% Case names & types
cases.names = cell(37,1);


% Types
% -------------------------------- Baseline
cases.names{1} =  'Baseline  2 deg 0.01 ki, no noise, 5s';       % 1 internal
cases.names{2} =  'Baseline  2 deg 0.09 ki, no noise, 5s';       % 2 off
cases.names{3} =  'Baseline  5 deg 0.02 ki, no noise, 5s';       % 3 off
cases.names{4} =  'Baseline 10 deg 0.09 ki, no noise, 5s';       % 4 off
cases.names{5} =  'Baseline  2 deg 0.01 ki, with noise, 60s';    % 5 internal
cases.names{6} =  'Baseline  4 deg 0.01 ki, with noise, 60s';    % 6 internal
% -------------------------------- LuT int
cases.names{11} =  'LuT int. 2 deg 0.01 ki, no noise, 5s';       % 11
cases.names{12} =  'LuT int. 4 deg 0.01 ki, no noise, 5s';       % 12
cases.names{15} =  'LuT int. 2 deg 0.01 ki, with noise, 60s';    % 15
cases.names{16} =  'LuT int. 4 deg 0.01 ki, with noise, 60s';    % 16
% -------------------------------- LuT off
cases.names{21} =  'LuT off 2 deg 0.01 ki, no noise, 5s';       % 21
cases.names{22} =  'LuT off 2 deg 0.09 ki, no noise, 5s';       % 22
cases.names{23} =  'LuT off 5 deg 0.02 ki, no noise, 5s';       % 23
cases.names{24} =  'LuT off 9 deg 0.09 ki, no noise, 5s';       % 24
% -------------------------------- CLC 2mr
cases.names{31} =  'CLC 2mr 100 ph, no noise, 60s';                % 31
cases.names{32} =  'CLC 2mr 200 ph, no noise, 60s';                % 32
cases.names{33} =  'CLC 2mr shifted no preview, no noise, 60s';    % 33
cases.names{34} =  'CLC 2mr shifted with preview, no noise, 60s';  % 34
cases.names{35} =  'CLC 2mr 100 ph, with noise, 60s';              % 35
cases.names{36} =  'CLC 2mr 200 ph, with noise, 60s';              % 36
cases.names{37} =  'CLC 2mr shifted no preview, with noise, 60s';  % 37
% --------------------------------

%% Markers
% -------------------------------- Baseline
cases.marker{1} =  'o';         % 1 internal
cases.marker{2} =  'v';         % 2 off
cases.marker{3} =  'v';         % 3 off
cases.marker{4} =  'v';         % 4 off
cases.marker{5} =  'diamond';   % 5 internal
cases.marker{6} =  'diamond';   % 5 internal
% -------------------------------- LuT int
cases.marker{11} =  'o';        % 11
cases.marker{12} =  'o';        % 12
cases.marker{15} =  'diamond';  % 15
cases.marker{16} =  'diamond';  % 16
% -------------------------------- LuT off
cases.marker{21} =  '^';        % 21
cases.marker{22} =  '^';        % 22
cases.marker{23} =  '^';        % 23
cases.marker{24} =  '^';        % 24
% -------------------------------- CLC 2mr
cases.marker{31} =  'o';        % 31
cases.marker{32} =  'o';        % 32
cases.marker{33} =  'o';        % 33
cases.marker{34} =  'o';        % 34
cases.marker{35} =  'diamond';  % 35
cases.marker{36} =  'diamond';  % 36
cases.marker{37} =  'diamond';  % 37


%% Case 3
if local
cases_12_to_15_to = {
    [path_12_to_15 'BL_2deg_noise_free/'], ...                              % 1 BL
    [path_12_to_15 'case12_to_15_off_db5deg_ki0-02_BL/'], ...               % 3
    [path_12_to_15 'CLC_shifted_noise_free/'], ...                          % 33 Case2024_08_23_11_39_08
    [path_12_to_15 'CLC_shifted_noise_free_with_preview/'], ...             % 34 Case2024_08_28_15_33_29
    [path_12_to_15 'CLC_1000s_ph_noise_free/'], ...                         % 32 Case2024_09_03_22_57_56
    [path_12_to_15 'CLC_1000s_ph_disturbed/'], ...                          % 36 Case2024_09_12_17_34_57
    [path_12_to_15 'CLC_500s_ph_disturbed/'], ...                           % 35 Case2024_09_18_09_00_54
    [path_12_to_15 'LuT_2deg_internal_noise_free/'], ...                    % 11
    [path_12_to_15 'LuT_4deg_internal_noise_free/'], ...                    % 12
    [path_12_to_15 'LuT_2deg_internal_disturbed/'], ...                     % 15 LuT_ki0.01_db_2_Direction_measurements_internal
    [path_12_to_15 'off_db2deg_ki0-01/'], ...                               % 21
    [path_12_to_15 'BL_2deg_disturbed/'], ...                               % 5  BL_ki0.01_db_2_Direction_measurements_internal
    [path_12_to_15 'CLC_shifted_disturbed/'], ...                           % 37 Case2024_09_24_03_24_33
    [path_12_to_15 'CLC_500s_noise_free/'], ...                             % 31 Case2024_10_02_20_20_53
    [path_12_to_15 'BL_4deg_disturbed/'], ...                               % 6  BL_ki0.01_db_4_Direction_measurements_internal
    [path_12_to_15 'LuT_4deg_internal_disturbed/']                          % 16 LuT_ki0.01_db_4_Direction_measurements_internal
    };

cases_12_to_15_pp = {[]};

types_12_to_15 = [1 3 33 34 32 36 35 11 12 15 21 5 37 31 6 16];


if length(types_12_to_15) ~= length(cases_12_to_15_to)
    error('Incomplete definition of 12 to 15h cases!')
end

%% Store in case dict
cases.HKN_12_to_15.paths_to = cases_12_to_15_to;
cases.HKN_12_to_15.types    = types_12_to_15;
cases.HKN_12_to_15.paths_pp = cases_12_to_15_pp;

cases.case_names = {'_', '_', 'HKN 12 to 15h'};

cases.colors = zeros(40,3);

% Colors
% -------------------------------- Baseline
cases.colors(1,:) = [0,0,0]; % 'Baseline  2 deg 0.01 ki, no noise, 5s';       % 1 internal
cases.colors(2,:) = [0.2253    0.2253    0.2253]; % 'Baseline  2 deg 0.09 ki, no noise, 5s';       % 2 off
cases.colors(3,:) = [0.4392    0.4392    0.4392]; % 'Baseline  5 deg 0.02 ki, no noise, 5s';       % 3 off
cases.colors(4,:) = [0.6438    0.6438    0.6438]; % 'Baseline 10 deg 0.09 ki, no noise, 5s';       % 4 off
cases.colors(5,:) = [0,0,0];                      % 'Baseline  2 deg 0.01 ki, with noise, 60s';    % 5 internal
cases.colors(6,:) = [.5,.5,.5];                   % 'Baseline  4 deg 0.01 ki, with noise, 60s';    % 6 internal
% -------------------------------- LuT int
cases.colors(11,:) = [0.4155    0.0037    0.1234]; %'LuT int. 2 deg 0.01 ki, no noise, 5s';       % 11
cases.colors(12,:) = [0.7949    0.2879    0.2601]; %'LuT int. 4 deg 0.01 ki, no noise, 5s';       % 12
cases.colors(15,:) = [0.4155    0.0037    0.1234]; %'LuT int. 2 deg 0.01 ki, with noise, 60s';    % 15
cases.colors(16,:) = [0.7949    0.2879    0.2601]; %'LuT int. 4 deg 0.01 ki, with noise, 60s';    % 16
% -------------------------------- LuT off
cases.colors(21,:) = [0.6519    0.0794    0.1613]; %'LuT off 2 deg 0.01 ki, no noise, 5s';       % 21
cases.colors(22,:) = [0.8992    0.5144    0.4080]; %'LuT off 2 deg 0.09 ki, no noise, 5s';       % 22
cases.colors(23,:) = [0.9889    0.8739    0.8062]; %'LuT off 5 deg 0.02 ki, no noise, 5s';       % 23
cases.colors(24,:) = [0.9691    0.9665    0.9649]; %'LuT off 9 deg 0.09 ki, no noise, 5s';       % 24
% -------------------------------- CLC 2mr
cases.colors(31,:) = [0.0196    0.1882    0.3804]; %'CLC 2mr 100 ph, no noise, 60s';                % 31
cases.colors(32,:) = [0.1284    0.3971    0.6687]; %'CLC 2mr 200 ph, no noise, 60s';                % 32
cases.colors(33,:) = [0.2610    0.5725    0.7627]; %'CLC 2mr shifted no preview, no noise, 60s';    % 33
cases.colors(34,:) = [0.8080    0.8921    0.9378]; %'CLC 2mr shifted with preview, no noise, 60s';  % 34
cases.colors(35,:) = [0.0196    0.1882    0.3804]; %'CLC 2mr 100 ph, with noise, 60s';              % 35
cases.colors(36,:) = [0.1284    0.3971    0.6687]; %'CLC 2mr 200 ph, with noise, 60s';              % 36
cases.colors(37,:) = [0.2610    0.5725    0.7627]; %'CLC 2mr shifted no preview, with noise, 60s';  % 37
% --------------------------------


%% Links
cases.links         = eye(37);
cases.links(1,5)    = 1;        % Baseline  2 deg 0.01 ki
cases.links(11,15)  = 1;
cases.links(12,16)  = 1;
cases.links(31,35)  = 1;
cases.links(32,36)  = 1;
cases.links(33,37)  = 1;

%% Line Types
% -------------------------------- Baseline
cases.line{1} =  '-';         % 1 internal
cases.line{2} =  '-';         % 2 off
cases.line{3} =  '-';         % 3 off
cases.line{4} =  '-';         % 4 off
cases.line{5} =  '-.';        % 5 internal
cases.line{6} =  '-.';        % 6 internal
% -------------------------------- LuT int
cases.line{11} =  '-';        % 11
cases.line{12} =  '-';        % 12
cases.line{15} =  '-.';       % 15
cases.line{16} =  '-.';       % 16
% -------------------------------- LuT off
cases.line{21} =  '-';        % 21
cases.line{22} =  '-';        % 22
cases.line{23} =  '-';        % 23
cases.line{24} =  '-';        % 24
% -------------------------------- CLC 2mr
cases.line{31} =  '-';        % 31
cases.line{32} =  '-';        % 32
cases.line{33} =  '-';        % 33
cases.line{34} =  '-';        % 34
cases.line{35} =  '-.';       % 35
cases.line{36} =  '-.';       % 36
cases.line{37} =  '-.';       % 37

%% Directions
cases.dir_domain{3} = readmatrix([path_12_to_15 'LESData/dir.csv']);
cases.dir_domain{3}(:,1) = (cases.dir_domain{3}(:,1) - 1200)/3600;

%% Layout
cases.layout_domain{3} = readmatrix([path_12_to_15 'LESData/layout_balanced.csv']);
end

