function final_energy_eff_bar_chart(case_ids, controller_ids, cases, norm_id)
for iC = 1:length(case_ids)
    legend_names = {};
    i_legend = 1;
    figure
    hold on
    for iiC = 1:length(controller_ids) % Go through all controllers
        % Calc efficiency over energy accumulated by all turbines
        eff = sum(cases.energy{case_ids(iC), controller_ids(iiC)}(end,:),2)/ ...
            sum(cases.energy{case_ids(iC), controller_ids(norm_id)}(end,:),2);
        col = cases.colors(controller_ids(iiC),:);

        eff = (eff - 1)*100;

        patch([-1, 1, 1, -1]*.25 + i_legend, [0, 0, eff, eff], col, 'EdgeColor', 'none')
        
        legend_names{i_legend} = cases.names{controller_ids(iiC)};
        i_legend = i_legend + 1;
        
    end
    grid on
    xticks(1:i_legend-1)
    xticklabels(legend_names)
    %legend(legend_names,'Location','best')
    ylabel('Norm. energy gain in %')
    xlabel('Strategy')
    title(cases.case_names{case_ids(iC)})
end
end