function energy_eff_bar_chart_turbine(case_ids, controller_ids, cases, norm_id)
for iC = 1:length(case_ids)
    figure
    hold on
    ene_bl  = cases.energy{case_ids(iC), controller_ids(norm_id)}(end,:);
    for iiC = 1:length(controller_ids) % Go through all controllers
        col = cases.colors(controller_ids(iiC),:);
        ene_con = cases.energy{case_ids(iC), controller_ids(iiC)}(end,:);
        
        ene_diff = ((ene_con - ene_bl)./sum(ene_bl))*100;

        offset_off = 0;
        for iT = 1:10
            patch([-1, 1, 1, -1]*.29 + iT, ...
                [0, 0, 1, 1]* ene_diff(iT) + offset_off, ...
                col, 'EdgeColor', 'none','FaceAlpha',.2)
            offset_off = offset_off + ene_diff(iT);
            if iT < 10
                plot([-.29 + iT, .29 + iT + 1], ...
                    [1,1]*offset_off,'LineWidth',2,'Color',col)
            end
        end
        
    end
    grid on
    xticks(1:10)
    xticklabels(0:9)
    %legend(legend_names,'Location','best')
    ylabel('Norm. energy gain in %')
    xlabel('Turbine')
    title(cases.case_names{case_ids(iC)})
    xlim([.5 10.5])


    figure
    nC = length(controller_ids)-1;
    hold on
    ene_bl  = cases.energy{case_ids(iC), controller_ids(norm_id)}(end,:);
    for iiC = 2:length(controller_ids) % Go through all controllers
        col = cases.colors(controller_ids(iiC),:);
        ene_con = cases.energy{case_ids(iC), controller_ids(iiC)}(end,:);
        
        ene_diff = ((ene_con - ene_bl)./sum(ene_bl))*100;
        w = .8/nC;
        for iT = 1:10
            patch( ...
                -nC/2*w + [0,1,1,0]*w + (iiC-2)*w + iT, ... %[-.5, .5, .5, -.5]/nC + (nC/2 - iiC)*1/nC + iT, ...
                [0, 0, 1, 1]* ene_diff(iT), ...
                col, 'EdgeColor', col,'FaceAlpha',.2)
        end
        
    end
    grid on
    xticks(1:10)
    xticklabels(0:9)
    %legend(legend_names,'Location','best')
    ylabel('Norm. energy gain in %')
    xlabel('Turbine')
    title(cases.case_names{case_ids(iC)})
    xlim([.5 10.5])
end
end