function cases = calculate_window_yaw_travel(cases, case_ids, controller_ids, time_window)
% Calulates the energy generated over a given time window
i_time = 1;
for iC = 1:length(case_ids)
for iiC = 1:length(controller_ids)
    yaw_travel_during_window = zeros(length(cases.t)-time_window/.5,10);
    while cases.t(i_time) + time_window <= cases.t(end)
        start_time = cases.t(i_time);
        yaw_travel_during_window(i_time,:) = sum(...
            cases.yaw_travel_diff{case_ids(iC), controller_ids(iiC)}(and((cases.t>=start_time), (cases.t<= (start_time + time_window))), :));
        i_time = i_time + 1;
    end
    
    cases.yaw_travel_window{case_ids(iC), controller_ids(iiC)} = ...
        yaw_travel_during_window;
    i_time = 1;
end
end

end

