function cases = calculate_window_energy(cases, case_ids, controller_ids, time_window)
% Calulates the energy generated over a given time window
i_time = 1;
for iC = 1:length(case_ids)
for iiC = 1:length(controller_ids)
    energy_during_window = zeros(length(cases.t)-time_window/.5,10);
    while cases.t(i_time) + time_window <= cases.t(end)
        start_time = cases.t(i_time);
        try
        energy_during_window(i_time,:) = sum(...
            cases.power{case_ids(iC), controller_ids(iiC)}(and((cases.t>=start_time), (cases.t<= (start_time + time_window))), :).*.5/3600);
        catch
            error(['Missing data from t_0=' num2str(start_time) ' s to ' ...
                num2str(start_time + time_window) ' s'])
        end
        i_time = i_time + 1;
    end
    
    cases.energy_window{case_ids(iC), controller_ids(iiC)} = ...
        energy_during_window;
    i_time = 1;
end
end

end

