
import numpy as np
import matplotlib.pyplot as plt
import matplotlib.ticker as ticker
import os.path as path
import os


basedir = os.path.dirname(os.path.realpath(__file__))  
StokesDrag = np.genfromtxt(basedir + "/rawdata" + "/StokesDragGridTestError.dat")
StokesRotating = np.genfromtxt(basedir + "/rawdata" + "/StokesRotationGridTestError.dat")
BaltussenDrag = np.genfromtxt(basedir + "/literature"+ "/baltussenSurfaceIntegralDrag.csv",delimiter=',')
BaltussenRotation = np.genfromtxt(basedir + "/literature" + "/BaltussenRotating.csv",delimiter=',')


f, axs = plt.subplots(1,1, figsize=(4,4))
f.subplots_adjust(wspace=.4, hspace=.1)

h = axs.loglog(2 * StokesDrag[:,0], 100 * abs(StokesDrag[:,1]), "o", fillstyle='left')
h = axs.loglog(2 * BaltussenDrag[:,0],  abs(BaltussenDrag[:,1]), "o", fillstyle='right')
h = axs.loglog([50, 100], [0.25, 0.125/2])

axs.legend(["This work", "Baltussen et al.", "2nd order"])
axs.set_xlabel(r"Grid resolution (D$_P$ / $\Delta$x)")
axs.set_ylabel(r"Error (%)")
axs.grid(True, which="both", ls="-")
axs.grid(which="minor", color="0.9")
axs.xaxis.set_major_formatter(ticker.StrMethodFormatter("{x:.0f}"))
axs.xaxis.set_major_formatter(ticker.StrMethodFormatter("{x:.0f}"))
axs.set_xticks([5,10,20, 50, 100, 200])

# axs.set_ylim(0.3, 2.4e3)
# axs.set_xlim(0.01, 3e6)
axs.set_title("Drag on sphere in Stokes regime")
f.savefig(os.path.dirname(os.path.realpath(__file__)) + '/StokesDrag.png', dpi=900, bbox_inches = 'tight')  # Increase dpi for higher resolution



f, axs = plt.subplots(1,1, figsize=(4,4))
f.subplots_adjust(wspace=.4, hspace=.1)

h = axs.loglog(2 * StokesRotating[:,0], 100 * abs(StokesRotating[:,1]), "o", fillstyle='left')
h = axs.loglog(2 * BaltussenRotation[:,0],  abs(BaltussenRotation[:,1]), "o", fillstyle='right')
h = axs.loglog([50, 100], [10, 5/2])

axs.legend(["This work", "Baltussen et al.", "2nd order"])
axs.set_xlabel(r"Grid resolution (D$_P$ / $\Delta$x)")
axs.set_ylabel(r"Error (%)")
axs.grid(True, which="both", ls="-")
axs.grid(which="minor", color="0.9")
axs.xaxis.set_major_formatter(ticker.StrMethodFormatter("{x:.0f}"))
axs.xaxis.set_major_formatter(ticker.StrMethodFormatter("{x:.0f}"))
axs.set_xticks([5,10,20, 50, 100, 200])
axs.set_yticks([.1,1,10])
axs.set_ylim([.08,22])

# axs.set_ylim(0.3, 2.4e3)
# axs.set_xlim(0.01, 3e6)
axs.set_title("Torque on rotating sphere in Stokes regime")
f.savefig(os.path.dirname(os.path.realpath(__file__)) + '/StokesTorque.png', dpi=900, bbox_inches = 'tight')  # Increase dpi for higher resolution



f, axs = plt.subplots(1,2, figsize=(9,4))
f.subplots_adjust(wspace=.4, hspace=.1)

h = axs[0].loglog(2 * StokesDrag[:,0], 100 * abs(StokesDrag[:,1]), "o", fillstyle='left')
h = axs[0].loglog(2 * BaltussenDrag[:,0],  abs(BaltussenDrag[:,1]), "o", fillstyle='right')
h = axs[0].loglog([50, 100], [0.25, 0.125/2])

axs[0].legend(["This work", "Baltussen et al.", "2nd order"])
axs[0].set_xlabel(r"Grid resolution (D$_P$ / $\Delta$x)")
axs[0].set_ylabel(r"Error (%)")
axs[0].grid(True, which="both", ls="-")
axs[0].grid(which="minor", color="0.9")
axs[0].xaxis.set_major_formatter(ticker.StrMethodFormatter("{x:.0f}"))
axs[0].xaxis.set_major_formatter(ticker.StrMethodFormatter("{x:.0f}"))
axs[0].set_xticks([5,10,20, 50, 100, 200])
axs[0].set_title("Drag on sphere in Stokes regime")

h = axs[1].loglog(2 * StokesRotating[:,0], 100 * abs(StokesRotating[:,1]), "o", fillstyle='left')
h = axs[1].loglog(2 * BaltussenRotation[:,0],  abs(BaltussenRotation[:,1]), "o", fillstyle='right')
h = axs[1].loglog([50, 100], [10, 5/2])

axs[1].legend(["This work", "Baltussen et al.", "2nd order"])
axs[1].set_xlabel(r"Grid resolution (D$_P$ / $\Delta$x)")
axs[1].set_ylabel(r"Error (%)")
axs[1].grid(True, which="both", ls="-")
axs[1].grid(which="minor", color="0.9")
axs[1].xaxis.set_major_formatter(ticker.StrMethodFormatter("{x:.0f}"))
axs[1].xaxis.set_major_formatter(ticker.StrMethodFormatter("{x:.0f}"))
axs[1].set_xticks([5,10,20, 50, 100, 200])
axs[1].set_yticks([.1,1,10])
axs[1].set_ylim([.08,22])

axs[1].set_title("Torque on rotating sphere in Stokes regime")
f.savefig(os.path.dirname(os.path.realpath(__file__)) + '/StokesTorqueAndDrag.png', dpi=900, bbox_inches = 'tight')  # Increase dpi for higher resolution