library(spatstat)
library(RandomFields)

n = 1000
events = data.frame()
events_sim_pp <- rpoispp(function(x,y) {exp(x+2*y)}, nsim=n)
for (i in 1:n){
  events_sim <- data.frame(events_sim_pp[[i]]$x,events_sim_pp[[i]]$y)
  events <- rbind(events, events_sim)
}
colnames(events) <- c('x','y')
plot(events$x, events$y)
events$zz = 1

#estimation using Poisson point processes
dummys = data.frame()
dummys_sim_pp <- rpoispp(30, nsim=n)
for (i in 1:n){
  dummys_sim <- data.frame(dummys_sim_pp[[i]]$x,dummys_sim_pp[[i]]$y)
  dummys <- rbind(dummys, dummys_sim)
}
colnames(dummys) <- c('x','y')
plot(dummys$x, dummys$y)
dummys$zz = 0
data <- rbind(events, dummys)
data$rho = 30
model1 <-glm(zz ~ x+y, offset = -log(rho), data = data, family = binomial(link = "logit"))

#estimation using Gaussian determinantal point processes
dummys = data.frame()
m <- dppGauss(lambda=30, alpha=0.1, d=2)
dummys_sim_pp <- simulate.dppm(m, nsim=n)
for (i in 1:n){
  dummys_sim <- data.frame(dummys_sim_pp[[i]]$x,dummys_sim_pp[[i]]$y)
  dummys <- rbind(dummys, dummys_sim)
}
colnames(dummys) <- c('x','y')
plot(dummys$x, dummys$y)
dummys$zz = 0
data <- rbind(events, dummys)
data$rho = 30
model2 <-glm(zz ~ x+y, offset = -log(rho), data = data, family = binomial(link = "logit"))

#approximate the variance
estimation1_sim_pp <- rpoispp(30, nsim=n)
m <- dppGauss(lambda=30, alpha=0.1, d=2)
estimation2_sim_pp <- simulate.dppm(m, nsim=n)

CI_LR_1 <- function( model=NULL, n=NULL)
{
  sigma <-  matrix( 0, nrow = 3, ncol = 3)
  for (k in 1:n){
    estimation1_sim <- data.frame(estimation1_sim_pp[[k]]$x,estimation1_sim_pp[[k]]$y)
    colnames(estimation1_sim) <- c('x','y')
    estimation1_sim$rho = 30
    odds_ratio = exp(predict(model, newdata=estimation1_sim))
    variables = data.frame(1, estimation1_sim$x, estimation1_sim$y)
    for ( i in 1:3 ){
      for (j in 1:3){
        term <- sum((odds_ratio/(1+odds_ratio)) * variables[,i] * variables[,j])
        sigma[i,j] = sigma[i,j] + term
      }
    }
  }
  variance <- solve(sigma)
  return( variance )
}
varianceM1 = CI_LR_1(model1, n)


CI_LR_2 <- function( model=NULL, n=NULL )
{
  sigma1 <-  matrix( 0, nrow = 3, ncol = 3)
  sigma2 <-  matrix( 0, nrow = 3, ncol = 3)
  for (k in 1:n){
    estimation1_sim <- data.frame(estimation1_sim_pp[[k]]$x,estimation1_sim_pp[[k]]$y)
    estimation2_sim <- data.frame(estimation2_sim_pp[[k]]$x,estimation2_sim_pp[[k]]$y)
    colnames(estimation1_sim) <- c('x','y')
    colnames(estimation2_sim) <- c('x','y')
    estimation1_sim$rho = 30
    estimation2_sim$rho = 30
    odds_ratio1 = exp(predict(model, newdata=estimation1_sim))
    odds_ratio2 = exp(predict(model, newdata=estimation2_sim))
    variables1 = data.frame(1, estimation1_sim$x, estimation1_sim$y)
    variables2 = data.frame(1, estimation2_sim$x, estimation2_sim$y)
    for ( i in 1:3 ){
      for (j in 1:3){
        term1 <- sum((odds_ratio1/(1+odds_ratio1)) * variables1[,i] * variables1[,j])
        sigma1[i,j] = sigma1[i,j] + term1
      }
    }
    for ( i in 1:3 ){
      for (j in 1:3){
        term1 <- sum((odds_ratio1/(1+odds_ratio1)) * variables1[,i] * variables1[,j])
        term2 <- sum((odds_ratio2/(1+odds_ratio2)) * variables2[,i])
        term3 <- sum((odds_ratio2/(1+odds_ratio2)) * variables2[,j])
        term4 <- sum((odds_ratio2/(1+odds_ratio2)) * (odds_ratio2/(1+odds_ratio2)) * variables2[,i] * variables2[,j])
        term5 <- sum((odds_ratio1/(1+odds_ratio1)) * variables1[,i])
        term6 <- sum((odds_ratio1/(1+odds_ratio1)) * variables1[,j])
        term7 <- sum((odds_ratio1/(1+odds_ratio1)) * (odds_ratio1/(1+odds_ratio1)) * variables1[,i] * variables1[,j])
        sigma2[i,j] = sigma2[i,j] + term1 + (term2 * term3 - term4) - (term5 * term6 - term7)
      }
    }
  }
  sigma1_i <- solve(sigma1)
  variance <- sigma1_i %*% sigma2 %*% t(sigma1_i)
  return( variance )
}
varianceM2 = CI_LR_2(model2, n)

varianceM1
varianceM2









