#Fig 1I glomerular comparison
# load packages
library(ggplot2)
library(ggpubr)
library(readxl)
library(car)

setwd("C:/Users/haver024/OneDrive - Wageningen University & Research/Documenten/Team/PhD/Qi/Thesis/5. Manuscript 4_Orco/Data & R-scripts/")

# import data"
develop<-read_xlsx("Orco_raw_data.xlsx",sheet = "glomeruli")

#setting factors
develop$Genotype<-factor(develop$Genotype,
                         levels=c("WT","KO"))

#testing for normality and equal variances
shapiro.test(develop$Glomeruli)
leveneTest(develop$Glomeruli~develop$Genotype)


#font set
windowsFonts(A="Times New Roman")

#painting
ggboxplot(develop, #dataset
          x = "Genotype", #x axis
          y = "Glomeruli", #y axis
          color="Genotype", #color by
          add = "jitter") + # add scatters
  ylim(5,18)+ #change range of y axis
  xlab("Genotype") + #change x axis annotation
  ylab("Glomeruli") + # change y axis annotation
  ggtitle("Development")+ # change the title of the figure
  theme(legend.position="right")+ #change the position of legend
  theme(text = element_text(family = "A"))+ #change fonts
  scale_color_manual(values=c('#fcbc86','#8ed8f8'))+ #change colors
  stat_compare_means(comparisons = list( c("WT", "KO")), #make comparisons
                     # label = "p.signif", method= "t.test"
                     #if statistic method was not indicated, the method will be Wilcoxon by default
                     method = "wilcox.test" # statistic test
  )


###################################################################
##Fig 2A/2B
lapply(c("pheatmap",
         "ggplot2",
         "ggpubr",
         "dplyr",
         "tidyr",
         "RColorBrewer",
         "wesanderson",
         "readxl",
         "rstatix",
         "tidyverse",
         "reshape2"), require, c = T)

#datasheet transformation longdata

a2 <-read.csv("Orco_eagdata_female.csv",header=T)
along <- a2 %>% gather(key ="Genotype",value ="Response","WT_1":"Orco_KO_17")
along1<-separate(along,Genotype,into = c("Genotype","Number"),sep = "_")
along2 <- along1 %>%select(Compounds,Genotype,Response) %>%
  mutate(eag=Response*100)


#normal distribution check

#shapiro test
shapirogroup <- along2 %>%
  group_by(Compounds,Genotype) %>%
  shapiro_test(eag)
#list where shapiro is significant, means not normal distribution
shapirons <-shapirogroup %>% #this did not work for me!
            filter(p<0.05)



#levene test
along2$eag <- as.numeric(along2$eag)
along2$Genotype <- as.factor(along2$Genotype)
levene <- along2 %>% 
  group_by(Compounds) %>% 
  levene_test(eag ~ Genotype)
levenens <- levene %>% 
  filter(p<0.05)

#statistics: t-test
ttest <- along2 %>% 
  group_by(Compounds) %>% t_test(eag~Genotype)
along2$Genotype <- as.factor(along2$Genotype)
ttest1 <- as.data.frame(ttest)
ttestns <- ttest %>% 
  filter(p<0.05)


#statistics: non-parametric test
kruskal <- along2 %>% 
  group_by(Compounds) %>% kruskal_test(eag~Genotype)



############## EAG heatmap #############

EAG_data <- read.csv("Orco_eagdata_female.csv",header=T, row.names=1) 
a <- as.data.frame(EAG_data,show_col_types = FALSE)
pos1 <- read.csv("Significance_female.csv",header=T, row.names=1)
pos <- as.data.frame(pos1,show_col_types = FALSE)


rownames(pos)=rownames(a)

pheatmap(a*100,clustering_distance_rows = "correlation",
         clustering_distance_cols= "correlation",
         cluster_cols=F,cluster_rows=F,
         annotation_row = pos,
       # legend_breaks = c(0,0.3,0.6), 
         legend_labels = c("0","0.2","0.4","0.6"),
         color = colorRampPalette(c("navy","yellow","red"))(100),
         fontsize=8,
         fontfamily="Times",
         border=FALSE,
         cellwidth=8, cellheight=8,
         gaps_col = c(15),
         annotation_legend = TRUE,
         display_numbers = FALSE,
         main = "EAG response of female Pieris brassicae")



##############################################################################
#Figure 2C mating comparison

# load packages
library(ggplot2)
library(ggpubr)
library(readxl)
library(car)

# import data
setwd("C:/Users/haver024/OneDrive - Wageningen University & Research/Documenten/Team/PhD/Qi/Thesis/5. Manuscript 4_Orco/Data & R-scripts/")
mating<-read_xlsx("Orco_raw_data.xlsx",sheet = "Spermatophores")

#setting factors
mating$Genotype<-factor(mating$Genotype,
                         levels=c("WT","KO"))

#testing for normality and equal variances
shapiro.test(mating$Spermatophores) #not normally distributed
leveneTest(mating$Spermatophores~mating$Genotype) #Varicances are not equal

#font set
windowsFonts(A="Times New Roman")  

#plotting
ggboxplot(mating, #dataset
          x = "Genotype", #x axis
          y = "Spermatophores", #y axis
          color="Genotype", #color by
          add = "jitter") + # add scatters
  ylim(-1,4)+ #change range of y axis
  xlab("Genotype") + #change x axis annotation
  ylab("Spermatophores") + # change y axis annotation
  ggtitle("Mating times")+ # change the title of the figure
  theme(legend.position="right")+ #change the position of legend
  theme(text = element_text(family = "A"))+ #change fonts
  scale_color_manual(values=c('#f9c385','#9fd9f6'))+ #change colors
  stat_compare_means(comparisons = list( c("WT", "KO")), #make comparisons
                     # label = "p.signif", method= "t.test"
                     #if statistic method was not indicated, the method will be Wilcoxon by default
                     #method = "t.test" # statistic test
                     method = "wilcox.test"
  )



####################################################################### 
#Fig 2D
library(ggplot2)
library(ggpubr)
library(readxl)
library(car)

# import data
setwd("C:/Users/haver024/OneDrive - Wageningen University & Research/Documenten/Team/PhD/Qi/Thesis/5. Manuscript 4_Orco/Data & R-scripts/")
Oviposition2<-read_xlsx("Orco_raw_data.xlsx",sheet = "Oviposition")

Oviposition2<-read.csv("clipboard", header=T, sep = "\t")

windowsFonts(A="Times New Roman")

Oviposition2 %>%
  mutate(Date=as.factor(Date)) %>% 
  group_by(Date,Genotype) %>%
  ggplot(aes(x = Date,y = Total_eggs,
             group=Genotype,color=Genotype)) + 
  scale_color_manual(values=c('#314895','#e99312'))+
  stat_summary(fun="mean",geom="point",size=3) +        
  stat_summary(fun="mean",geom="line") +  
  stat_summary(fun.data = "mean_se",geom = "errorbar",width=0.05)+
  theme_bw()+
  theme(panel.grid.major=element_blank(),
        panel.grid.minor=element_blank(),
        panel.background = element_blank(),
        legend.key=element_blank())+
  theme(text = element_text(family = "A")) #change fonts


##oviposition statistics
library(MASS)

#testing for normality and equal variances
shapiro.test(Oviposition2$Total_eggs) #not normally distributed
leveneTest(Oviposition2$Total_eggs~Oviposition2$Genotype) #Varicances are not equal

## negative binominal
model.nb <-glm.nb(Total_eggs~Genotype+Date, data = Oviposition2)
summary (model.nb)
anova(model.nb)
drop1(model.nb)
car::Anova(model.nb,type="II")



#Fig 3A,development comparison ################################################ 
# load packages
library(ggplot2)
library(ggpubr)
library(readxl)
library(car)

# import data
setwd("C:/Users/haver024/OneDrive - Wageningen University & Research/Documenten/Team/PhD/Qi/Thesis/5. Manuscript 4_Orco/Data & R-scripts/")
develop3A<-read_xlsx("Orco_raw_data.xlsx",sheet = "Development Plant")

#setting factors
develop3A$Genotype<-factor(develop3A$Genotype,
                         levels=c("WT","KO"))

#testing for normality and equal variances
shapiro.test(develop3A$Weight) #data is normally distributed
leveneTest(develop3A$Weight~develop3A$Genotype)#variances are equal

#font set
windowsFonts(A="Times New Roman")  

#plotting
ggboxplot(develop3A, #dataset
          x = "Genotype", #x axis
          y = "Weight", #y axis
          color="Genotype", #color by
          add = "jitter") + # add scatters
  ylim(0.35,0.55)+ #change range of y axis
  xlab("Genotype") + #change x axis annotation
  ylab("Weight (g)") + # change y axis annotation
  ggtitle("Development")+ # change the title of the figure
  theme(legend.position="right")+ #change the position of legend
  theme(text = element_text(family = "A"))+ #change fonts
  scale_color_manual(values=c('#f9c385','#9fd9f6'))+ #change colors
  stat_compare_means(comparisons = list( c("WT", "KO")), #make comparisons
                     # label = "p.signif", method= "t.test"
                     #if statistic method was not indicated, the method will be Wilcoson by default
                     method = "t.test" # statistic test
  )


################################################################################
### Fig 3B tomato vs cabbage vs paper ###

library(ggplot2)
library(reshape2)

# import data
setwd("C:/Users/haver024/OneDrive - Wageningen University & Research/Documenten/Team/PhD/Qi/Thesis/5. Manuscript 4_Orco/Data & R-scripts/")

##################### Cabbage vs. Tomato ##################### 
EthologyCT<-read_xlsx("Orco_raw_data.xlsx",sheet = "Discs_Tomato_Cabbage")

EthologyCT1=melt(EthologyCT)

head(EthologyCT1)

windowsFonts(A="Times New Roman")

ggplot(EthologyCT1, aes(
  x = factor(Genotype,levels = unique(Genotype)),  
  y = ifelse(variable == "cabbage.leaf.disc", value, -value),  
  fill = variable)) +
  geom_bar(stat = 'identity')+
  coord_flip()+
  geom_text( 
    aes(label=value,
        vjust = ifelse(variable == "cabbage.leaf.disc", 0, 0), # distance of labels to the bars vertically
        hjust = ifelse(variable == "cabbage.leaf.disc", 3, -1) # distance of labels to the bars horizontally
    ),
    size=10 # font size
  )+
  scale_y_continuous( 
    labels = abs, 
    expand = expansion(mult = c(0.1, 0.1)))+
  theme_bw()+
  theme(panel.grid=element_blank())+
  scale_fill_manual(values = c("#f39900","#72bc46"))+
  theme(text = element_text(family = "A")) #change fonts

chisq.test(EthologyCT[1,2:3])#KO- Tomato vs. Cabbage
chisq.test(EthologyCT[2,2:3])#WT- Tomato vs. Cabbage

##################### Cabbage vs. Paper##################### 
EthologyCP<-read_xlsx("Orco_raw_data.xlsx",sheet = "Discs_Cabbage_Paper")

EthologyCP1=melt(EthologyCP)

head(EthologyCP1)

windowsFonts(A="Times New Roman")

ggplot(EthologyCP1, aes(
  x = factor(Genotype,levels = unique(Genotype)),  
  y = ifelse(variable == "cabbage.leaf.disc", value, -value),  
  fill = variable)) +
  geom_bar(stat = 'identity')+
  coord_flip()+
  geom_text( 
    aes(label=value,
        vjust = ifelse(variable == "cabbage.leaf.disc", 0, 0), # distance of labels to the bars vertically
        hjust = ifelse(variable == "cabbage.leaf.disc", 4, -1) # distance of labels to the bars horizontally
    ),
    size=10 # font size
  )+
  scale_y_continuous( 
    labels = abs, 
    expand = expansion(mult = c(0.1, 0.1)))+
  theme_bw()+
  theme(panel.grid=element_blank())+
  scale_fill_manual(values = c("#9fa0a0","#72bc46"))+
  theme(text = element_text(family = "A")) #change fonts

chisq.test(EthologyCP[1,2:3])#KO- Paper vs. Cabbage
chisq.test(EthologyCP[2,2:3])#WT- Paper vs. Cabbage

######################  Tomato vs. Paper ##################### 
EthologyTP<-read_xlsx("Orco_raw_data.xlsx",sheet = "Discs_Tomato_Paper")

EthologyTP1=melt(EthologyTP)

head(EthologyTP1)

windowsFonts(A="Times New Roman")

ggplot(EthologyTP1, aes(
  x = factor(Genotype,levels = unique(Genotype)),  
  y = ifelse(variable == "tomato.leaf.disc", value, -value),  
  fill = variable)) +
  geom_bar(stat = 'identity')+
  coord_flip()+
  geom_text( 
    aes(label=value,
        vjust = ifelse(variable == "tomato.leaf.disc", 0, 0), # distance of labels to the bars vertically
        hjust = ifelse(variable == "tomato.leaf.disc", 5, -1) # distance of labels to the bars horizontally
    ),
    size=10 # font size
  )+
  scale_y_continuous( 
    labels = abs, 
    expand = expansion(mult = c(0.1, 0.1)))+
  theme_bw()+
  theme(panel.grid=element_blank())+
  scale_fill_manual(values = c("#9fa0a0","#f39900"))+
  theme(text = element_text(family = "A")) #change fonts

chisq.test(EthologyTP[1,2:3])#KO- Paper vs. Tomato
chisq.test(EthologyTP[2,2:3])#WT- Paper vs. Tomato

###############################################################################
### Fig 3C,D differently treated plants ###

library(ggplot2)
library(reshape2)

############## Healthy vs No plant#############
# import data
setwd("C:/Users/haver024/OneDrive - Wageningen University & Research/Documenten/Team/PhD/Qi/Thesis/5. Manuscript 4_Orco/Data & R-scripts/")
EthologyHN<-read_xlsx("Orco_raw_data.xlsx",sheet = "Y-tube_Healthy_No plant")

EthologyHN3=melt(EthologyHN)

head(EthologyHN3)

windowsFonts(A="Times New Roman")

ggplot(EthologyHN3, aes(
  x = factor(Genotype,levels = unique(Genotype)),  
  y = ifelse(variable == "healthy.plant", value, -value),  
  fill = variable)) +
  geom_bar(stat = 'identity')+
  coord_flip()+
  geom_text( 
    aes(label=value,
        vjust = ifelse(variable == "healthy.plant", 0, 0), # distance of labels to the bars vertically
        hjust = ifelse(variable == "healthy.plant", 5, -1) # distance of labels to the bars horizontally
    ),
    size=10 # font size
  )+
  scale_y_continuous( 
    labels = abs, 
    expand = expansion(mult = c(0.1, 0.1)))+
  theme_bw()+
  theme(panel.grid=element_blank())+
  scale_fill_manual(values = c("#9fa0a0","#72bc46"))+
  theme(text = element_text(family = "A")) #change fonts

chisq.test(EthologyHN[1,2:3])#WT- Healthy vs. No Plant
chisq.test(EthologyHN[2,2:3])#KO- Healthy vs. No Plant

#############Infested vs No plant#############
# import data
setwd("C:/Users/haver024/OneDrive - Wageningen University & Research/Documenten/Team/PhD/Qi/Thesis/5. Manuscript 4_Orco/Data & R-scripts/")
EthologyIN<-read_xlsx("Orco_raw_data.xlsx",sheet = "Y-tube_Infested_No plant")

EthologyIN3=melt(EthologyIN)

head(EthologyIN3)

windowsFonts(A="Times New Roman")

ggplot(EthologyIN3, aes(
  x = factor(Genotype,levels = unique(Genotype)),  
  y = ifelse(variable == "infested.plant", value, -value),  
  fill = variable)) +
  geom_bar(stat = 'identity')+
  coord_flip()+
  geom_text( 
    aes(label=value,
        vjust = ifelse(variable == "infested.plant", 0, 0), # distance of labels to the bars vertically
        hjust = ifelse(variable == "infested.plant", 4, -2) # distance of labels to the bars horizontally
    ),
    size=10 # font size
  )+
  scale_y_continuous( 
    labels = abs, 
    expand = expansion(mult = c(0.1, 0.1)))+
  theme_bw()+
  theme(panel.grid=element_blank())+
  scale_fill_manual(values = c("#9fa0a0","#006934"))+
  theme(text = element_text(family = "A")) #change fonts

chisq.test(EthologyIN[1,2:3])#WT- infested vs. No Plant
chisq.test(EthologyIN[2,2:3])#KO- infested vs. No Plant

#Infested vs No plant
# import data
setwd("C:/Users/haver024/OneDrive - Wageningen University & Research/Documenten/Team/PhD/Qi/Thesis/5. Manuscript 4_Orco/Data & R-scripts/")
EthologyWN<-read_xlsx("Orco_raw_data.xlsx",sheet = "Y-tube_Wasp_No wasps")

EthologyWN3=melt(EthologyWN)

head(EthologyWN3)

windowsFonts(A="Times New Roman")

ggplot(EthologyWN3, aes(
  x = factor(Genotype,levels = unique(Genotype)),  
  y = ifelse(variable == "wasps", value, -value),  
  fill = variable)) +
  geom_bar(stat = 'identity')+
  coord_flip()+
  geom_text( 
    aes(label=value,
        vjust = ifelse(variable == "wasps", 0, 0), # distance of labels to the bars vertically
        hjust = ifelse(variable == "wasps", 2, -2) # distance of labels to the bars horizontally
    ),
    size=10 # font size
  )+
  scale_y_continuous( 
    labels = abs, 
    expand = expansion(mult = c(0.1, 0.1)))+
  theme_bw()+
  theme(panel.grid=element_blank())+
  scale_fill_manual(values = c("#a40b5d","#006934"))+
  theme(text = element_text(family = "A")) #change fonts

chisq.test(EthologyWN[1,2:3])#WT- wasps vs. wasps-free
chisq.test(EthologyWN[2,2:3])#KO- wasps vs. wasps-free


############################################################################
#Fig 3E Development comparison

# load packages
library(ggplot2)
library(ggpubr)
library(readxl)
library(car)

# import data
setwd("C:/Users/haver024/OneDrive - Wageningen University & Research/Documenten/Team/PhD/Qi/Thesis/5. Manuscript 4_Orco/Data & R-scripts/")
develop3E<-read_xlsx("Orco_raw_data.xlsx",sheet = "Development Disarmed")

#setting factors
develop3E$Genotype<-factor(develop3E$Genotype,
                           levels=c("WT","KO"))

#testing for normality and equal variances
shapiro.test(develop3E$Weight) #data is normally distributed
leveneTest(develop3E$Weight~develop3E$Genotype)#variances are equal

#t test for comparison
t.test(develop3E$Weight~develop3E$Genotype, var.equal = T)


#font set
windowsFonts(A="Times New Roman")  

#painting
ggboxplot(develop3E, #dataset
          x = "Genotype", #x axis
          y = "Weight", #y axis
          color="Genotype", #color by
          add = "jitter") + # add scatters
  ylim(0.25,0.5)+ #change range of y axis
  xlab("Genotype") + #change x axis annotation
  ylab("Weight (g)") + # change y axis annotation
  ggtitle("Development under potential threat")+ # change the title of the figure
  theme(legend.position="right")+ #change the position of legend
  theme(text = element_text(family = "A"))+ #change fonts
  scale_color_manual(values=c('#f9c385','#9fd9f6'))+ #change colors
  stat_compare_means(comparisons = list( c("WT", "KO")), #make comparisons
                     label = "p.signif", method= "t.test" # p value has been calculated above using t-test
  )

############################################################################
#Fig 3F survival comparison

# load packages
library(ggplot2)
library(ggpubr)
library(readxl)
library(car)
library(glmmTMB)

# import data
setwd("C:/Users/haver024/OneDrive - Wageningen University & Research/Documenten/Team/PhD/Qi/Thesis/5. Manuscript 4_Orco/Data & R-scripts/")
survival<-read.csv("clipboard", sep = "\t", header=T)

read_xlsx("Orco_raw_data.xlsx",sheet = "Survival")

#setting factors
survival$Genotype<-factor(survival$Genotype,
                           levels=c("WT","KO"))

#testing for normality and equal variances
shapiro.test(survival$Survival) #data is normally distributed
leveneTest(survival$Survival~survival$Genotype)#variances are equal

#statistics:
modelglm <- glmmTMB(cbind(Survival,Dead)~ Genotype, 
                    family=betabinomial, data=survival )
summary(modelglm)
Anova(modelglm)

#font set
windowsFonts(A="Times New Roman")  

#painting
ggboxplot(survival, #dataset
          x = "Genotype", #x axis
          y = "Survival", #y axis
          color="Genotype", #color by
          add = "jitter") + # add scatters
  ylim(0,120)+ #change range of y axis
  xlab("Genotype") + #change x axis annotation
  ylab("Survival (%)") + # change y axis annotation
  ggtitle("Survival")+ # change the title of the figure
  theme(legend.position="right")+ #change the position of legend
  theme(text = element_text(family = "A"))+ #change fonts
  scale_color_manual(values=c('#f9c385','#9fd9f6')) #change colors





############################################################################
##Fig 4A/4B MetaboAnalyst exported

1.	mSet<-InitDataObjects("pktable", "stat", FALSE)
2.	mSet<-Read.TextData(mSet, "Replacing_with_your_file_path", "rowu", "disc");
3.	mSet<-SanityCheckData(mSet)
4.	mSet<-ReplaceMin(mSet);
5.	mSet<-SanityCheckData(mSet)
6.	mSet<-FilterVariable(mSet, "F", 25, "none", -1, "mean", 0)
7.	mSet<-PreparePrenormData(mSet)
8.	mSet<-Normalization(mSet, "NULL", "LogNorm", "AutoNorm", ratio=FALSE, ratioNum=20)
9.	mSet<-PlotNormSummary(mSet, "norm_0_", "png", 72, width=NA)
10.	mSet<-PlotSampleNormSummary(mSet, "snorm_0_", "png", 72, width=NA)
11.	mSet<-PCA.Anal(mSet)
12.	mSet<-PlotPCAPairSummary(mSet, "pca_pair_0_", "png", 72, width=NA, 5)
13.	mSet<-PlotPCAScree(mSet, "pca_scree_0_", "png", 72, width=NA, 5)
14.	mSet<-PlotPCA2DScore(mSet, "pca_score2d_0_", "png", 72, width=NA, 1,2,0.95,0,0, "na")
15.	mSet<-PlotPCALoading(mSet, "pca_loading_0_", "png", 72, width=NA, 1,2);
16.	mSet<-PlotPCABiplot(mSet, "pca_biplot_0_", "png", 72, width=NA, 1,2)
17.	mSet<-PlotPCA3DLoading(mSet, "pca_loading3d_0_", "json", 1,2,3)
18.	mSet<-PlotStaticHeatMap(mSet, "heatmap_1_", "png", 72, width=NA, "norm", "row", "euclidean", "ward.D","byr", 8,8, "overview", F, T, NULL, T, F, T, T, T)




############################################################################

##Fig 4D WT caterpillar behavioral preference

# Load the necessary libraries
library(ggplot2)

dataWT<-read.csv("clipboard", header = T, sep = "\t")

# sort x axis
dataWT$Chemical <- factor(dataWT$Chemical,
                          levels=c("2,3-Butanedione","3-Methylbutanal",
                                   "1-Methoxy-2-Propanol","1-Penten-3-ol",
                                   "Dimethyl disulfide","cis-2-Penten-1-ol",
                                   "cis-3-Hexen-1-ol","Hexanal","Pentanal",
                                   "trans-2-Hexanal","1-Hexanol",
                                   "cis-3-Hexenyl acetate","Benzyl cyanide",
                                   "trans-2-Hexen-1-ol","Linalool"))

# Create the barplot with error bars
ggplot(dataWT, aes(x = Chemical, y = Mean, fill = Zone)) +
  geom_bar(stat = "identity", position = "dodge") +
  geom_errorbar(aes(ymin = Mean - SE, ymax = Mean + SE),
                width = 0.2, position = position_dodge(0.9)) +
  labs(x = "Groups", y = "Mean Value", title = "WT caterpillar behavioral preference") +
  scale_fill_manual(values = c("Zone1" = "#0033FF", 
                               "Zone2" = "darkorange3")) +
  theme_minimal() +
  theme(panel.grid.major = element_blank(),  # Remove background grid
        panel.grid.minor = element_blank(),
        axis.text.x = element_text(angle = 45, hjust = 1),  # Rotate x-axis labels if needed
        axis.line = element_line(),  # Make axis lines visible
        axis.ticks = element_line(),  # Make ticks visible
        axis.text = element_text()) +  # Make tick labels visible
  scale_y_continuous(limits = c(0.0, 0.6), expand = expansion(add = c(0, 0))) #y axis limit

####################################################################################
####################################################################################

#Fig 4E KO caterpillar behavioral preference

# Load the necessary libraries
library(ggplot2)

# Load data
dataKO<-read.csv("clipboard", header = T, sep = "\t")

# sort x axis
dataKO$Chemical <- factor(dataKO$Chemical,
                          levels=c("2,3-Butanedione","3-Methylbutanal",
                                   "1-Methoxy-2-Propanol","1-Penten-3-ol",
                                   "Dimethyl disulfide","cis-2-Penten-1-ol",
                                   "cis-3-Hexen-1-ol","Hexanal","Pentanal",
                                   "trans-2-Hexanal","1-Hexanol",
                                   "cis-3-Hexenyl acetate","Benzyl cyanide",
                                   "trans-2-Hexen-1-ol","Linalool"))

# Create the barplot with error bars
ggplot(dataKO, aes(x = Chemical, y = Mean, fill = Zone)) +
  geom_bar(stat = "identity", position = "dodge") +
  geom_errorbar(aes(ymin = Mean - SE, ymax = Mean + SE),
                width = 0.2, position = position_dodge(0.9)) +
  labs(x = "Groups", y = "Mean Value", title = "Orco KO caterpillar behavioral preference") +
  scale_fill_manual(values = c("Zone1" = "#0033FF", 
                               "Zone2" = "darkorange3")) +
  theme_minimal() +
  theme(panel.grid.major = element_blank(),  # Remove background grid
        panel.grid.minor = element_blank(),
        axis.text.x = element_text(angle = 45, hjust = 1),  # Rotate x-axis labels if needed
        axis.line = element_line(),  # Make axis lines visible
        axis.ticks = element_line(),  # Make ticks visible
        axis.text = element_text()) +  # Make tick labels visible
  scale_y_continuous(limits = c(0.0, 0.6), expand = expansion(add = c(0, 0))) #y axis limit


################################################################################

#Figure S1 Hatching comparison


# load packages
library(ggplot2)
library(ggpubr)
library(readxl)
library(car)


# import data
hatchingS1<-read_xlsx("Orco_raw_data.xlsx",sheet = "FigS1Hatching")

#font set
windowsFonts(A="Times New Roman")  

#painting
ggboxplot(hatchingS1, #dataset
          x = "Genotype", #x axis
          y = "Hatching", #y axis
          color="Genotype", #color by
          add = "jitter") + # add scatters
  ylim(-10,120)+ #change range of y axis
  xlab("Genotype") + #change x axis annotation
  ylab("Hatching rate (%)") + # change y axis annotation
  ggtitle("Hatching rate")+ # change the title of the figure
  theme(legend.position="right")+ #change the position of legend
  theme(text = element_text(family = "A"))+ #change fonts
  scale_color_manual(values=c('#006600','#FF0033', '#FF0066'))+ #change colors
  stat_compare_means(comparisons = list( c("Wildtype", "Orco-/-_fert")), #make comparisons
                     # label = "p.signif", method= "t.test"
                     #if statistic method was not indicated, the method will be Wilcoson by default
                     #method = "t.test" # statistic test
  )+
  stat_compare_means(comparisons = list( c("Wildtype", "Orco-/-_unfert")), #make comparisons
                     # label = "p.signif", method= "t.test"
                     #if statistic method was not indicated, the method will be Wilcoson by default
                     #method = "t.test" # statistic test
  )+
  stat_compare_means(comparisons = list( c("Orco-/-_fert", "Orco-/-_unfert")), #make comparisons
                     # label = "p.signif", method= "t.test"
                     #if statistic method was not indicated, the method will be Wilcoson by default
                     #method = "t.test" # statistic test
  )


################################################################################

#Figure S2 Caterpillar development in Petri dish


# load packages
library(ggplot2)
library(ggpubr)
library(readxl)
library(car)

# import data
setwd("C:/Users/haver024/OneDrive - Wageningen University & Research/Documenten/Team/PhD/Qi/Thesis/5. Manuscript 4_Orco/Data & R-scripts/")
developS2<-read_xlsx("Orco_raw_data.xlsx",sheet = "FigS2CaterpillarInDish")

#setting factors
developS2$Genotype<-factor(developS2$Genotype,
                           levels=c("WT","KO"))

#testing for normality and equal variances
shapiro.test(developS2$LnWeight) #data is normally distributed
leveneTest(developS2$LnWeight~developS2$Genotype)#variances are equal


#font set
windowsFonts(A="Times New Roman")  

#painting
ggboxplot(developS2, #dataset
          x = "Genotype", #x axis
          y = "LnWeight", #y axis
          color="Genotype", #color by
          add = "jitter") + # add scatters
  ylim(0,-5)+ #change range of y axis
  xlab("Genotype") + #change x axis annotation
  ylab("LnCaterpillarWeight (g)") + # change y axis annotation
  ggtitle("Caterpillar development in Petri dish")+ # change the title of the figure
  theme(legend.position="right")+ #change the position of legend
  theme(text = element_text(family = "A"))+ #change fonts
  scale_color_manual(values=c('#f9c385','#9fd9f6'))+ #change colors
  stat_compare_means(comparisons = list( c("WT", "KO")), #make comparisons
                     label = "p.value", method= "wilcox.test" # p value has been calculated above using t-test
  )




