# README
* Dataset belonging to the article: 
Pelvis perturbations in various directions while standing in staggered stance elicit concurrent responses in both the sagittal and frontal plane
M. van Mierlo, J.A. Ormiston, M. Vlutters, E.H.F. van Asseldonk, H. van der Kooij

## Summary experiment pelvis perturbations during staggered stance
* Experiments performed between 24-02-2021 and 09-03-2021
* 10 participants were standing in staggered stance
* Perturbations were applied to the pelvis in 8 different directions

## Equipment
* Instrumented dual-belt treadmill
* MoCap: Qualisys 8 camera
* Moog actuators for perturbations
* Delsys Bagnoli EMG sensors

## Perturbations
* Applied while the participant was standing in staggered stance with the right foot leading
* Perturbations were applied in 8 different directions: Anterior (A), Anterior-lateral (AL), Lateral (L), Posterior-lateral (PL), Posterior (P), Posterior-medial (PM), Medial (M), Anterior-medial (AM) [M and L with respect to the right leading foot]
* Perturbations were applied with a magnitude of 3, 6, 9 and 12% of the participant's body weight
* Perturbations were only applied when the participant's centre of mass was within a certain target area in the middle to ensure a similar initial condition
* Each perturbation condition (direction & magnitude) was repeated 8x

## Included data files
* For each outcome measure a separate .csv file is added.
* Data is provided of each individual participant, averaged over the 8 repetitions within that participant
* The headers of the file indicate the participant number and the perturbation condition
* The perturbation condition consists of a perturbation direction (A, AL, L, PL, P, PM, M or AM) and a perturbation magnitude (for example PP1_APert3, is data of participant 1 and a perturbation applied in anterior direction with a magnitude of 3% of the participant's body weight)
* The datafile contains 4 seconds of data, the first second is unperturbed staggered stance. At timestamp 1 s a perturbation is given for a duration of 150 ms.
* The sample frequency is 128 Hz
* In case of missing data, NaN is presented
* Datafiles are provided of the following measures:
- ComAP [m]: position of the body's centre of mass in anteroposterior direction
- ComML [m]: position of the body's centre of mass in mediolateral direction
- CoPAP [m]: position of the centre of pressure in anteroposterior direction
- CoPML [m]: position of the centre of pressure in mediolateral direction
- SoleusL and SoleusR: normalized muscle activity of the left and right Soleus
- TibialisAnteriorL and TibialisAnteriorR: normalized muscle activity of the left and right Tibialis Anterior
- PeroneusLongusL and PeroneusLongusR: normalized muscle activity of the left and right Peroneus Longus 
- GluteusMaximusL and GluteusMaximusR: normalized muscle activity of the left and right Gluteus Maximus 
- AdductorMagnusL and AdductorMagnusR: normalized muscle activity of the left and right Adductor Magnus 
- GluteusMediusL and GluteusMediusR: normalized muscle activity of the left and right Gluteus Medius
- LumbarBending [Nm]: Bending moment of the lumbar joint
- LumbarExtension [Nm]: Extension moment of the lumbar joint
- HipAbAductionL and HipAbAductionR [Nm]: Abduction and adduction moment of the left and right hip
- AnkleInvEversionL and AnkleInvEversionR [Nm]: Inversion and eversion moment of the left and right ankle (positive is inversion)
- HipFlexExtensionL and HipFlexExtensionR [Nm]: Flexion and extension moment of the left and right hip (positive is flexion)
- KneeFlexExtensionL and KneeFlexExtensionR [Nm]: Flexion and extension moment of the left and right knee (positive is flexion)
- AnklePlantDorsiflexionL and AnklePlantDorsiflexionR [Nm]: Plantar and dorsiflexion moment of the left and right ankle (positive is dorsiflexion)