# -*- coding: utf-8 -*-
"""
Create the figures for:
   Katzin, D., Van Henten, E. J., Marcelis, L.F.M., & Van Mourik, S.
   A plea for open source greenhouse climate modelling. Acta Horticulturae 2024

This file created by David Katzin, Wageningen University & Research
March 2024
david.katzin@wur.nl

"""

import csv
import matplotlib.pyplot as plt

modelsFileName = '..\\Data\\Summary of review papers - published models.csv'
papersFileName = '..\\Data\\Web of science - published papers.csv'

# %% MATLAB's default colors (RGB values)
matlab_colors = [
    (0, 0.447, 0.741),  # Blue
    (0.85, 0.325, 0.098),  # Reddish
    (0.929, 0.694, 0.125),  # Yellow
    (0.494, 0.184, 0.556),  # Purple
    (0.466, 0.674, 0.188),  # Green
    (0.301, 0.745, 0.933),  # Light Blue
]

# %% Figure 1
# Read data from papers file
years = []
papers = []

with open(papersFileName, 'r') as csvFile:
    reader = csv.reader(csvFile)
    next(reader)  # Skip header row
    for row in reader:
        years.append(int(row[0]))
        papers.append(int(row[1]))

# Create a line graph
plt.figure(figsize=(20, 10))
plt.rcParams['font.family'] = 'Arial'
plt.rcParams['font.size'] = 30
plt.plot(years[1:-3], papers[1:-3], marker='o', linestyle='-', linewidth=3, markersize=20, color=matlab_colors[0],
         zorder=5)
plt.xlabel('Year')
plt.ylabel('Number of studies published')
plt.grid(True, alpha=0.5, zorder=0)
plt.xlim(1955.8, 2022.2)
plt.ylim(-1, 50)


# Adjust margins
plt.subplots_adjust(left=0.06, right=0.98, top=0.95, bottom=0.1)

# Save the graph
plt.savefig('..\\Figures\\papersPublished.png', dpi=300)

# %%
# Read data from models file
years = []
models = []

with open(modelsFileName, 'r') as csvFile:
    reader = csv.reader(csvFile)
    next(reader)  # Skip header row
    for row in reader:
        years.append(int(row[0]))
        models.append(int(row[1]))

yearLabels = [f'{x}-{x + 5}' for x in years]

# Create a line graph
plt.figure(figsize=(20, 10))
plt.bar(yearLabels[:-1], models[:-1], color=matlab_colors[0], edgecolor='black', zorder=3)
plt.xlabel('Years')
plt.ylabel('Number of models developed')
plt.grid(True, alpha=0.5, zorder=0)
plt.xlim((-0.5, 12.5))
plt.ylim((0, 60))
plt.xticks(rotation=30, ha='right')

# Adjust margins
plt.subplots_adjust(left=0.07, right=0.98, top=0.95, bottom=0.21)

# Save
plt.savefig('..\\Figures\\modelsPublished.png', dpi=300)

# Show the plots
plt.show()
