Data underlying the BSc thesis: Effect of Facial Realism on Presence in Collaborative Virtual Environments
==========================================================================================================

# Contents

## questionnaire.csv
Data from controlled experiment presence questionnaires.

For explanation of question contents, condition/treatment meanings, and precise experimental setup, please refer to the paper.

| column    | description                               | data type (and range) |
| :-------- | :---------------------------------------- | --------------------- |
| dyad_id   | identifier: experiment dyad               | `int`                 |
| person_id | identifier: person in a dyad              | `int: {1, 2}`         |
| order_id  | identifier: condition order               | `int: [1, 6]`         |
| treatment | identifier: condition/treatment           | `char: [A, C]`        |
| q1        | questionnaire answer: 7 point Likert-type | `int: [1, 7]`         |
| q2        | questionnaire answer: 7 point Likert-type | `int: [1, 7]`         |
| q3        | questionnaire answer: 7 point Likert-type | `int: [1, 7]`         |
| q4        | questionnaire answer: 7 point Likert-type | `int: [1, 7]`         |
| q5        | questionnaire answer: 7 point Likert-type | `int: [1, 7]`         |
| q6        | questionnaire answer: 7 point Likert-type | `int: [1, 7]`         |
| q7        | questionnaire answer: 7 point Likert-type | `int: [1, 7]`         |
| q8        | questionnaire answer: 7 point Likert-type | `int: [1, 7]`         |
| q9        | questionnaire answer: 7 point Likert-type | `int: [1, 7]`         |
| q10       | questionnaire answer: 7 point Likert-type | `int: [1, 7]`         |
| q11       | questionnaire answer: 7 point Likert-type | `int: [1, 7]`         |
| q12       | questionnaire answer: 7 point Likert-type | `int: [1, 7]`         |
| q13       | questionnaire answer: 7 point Likert-type | `int: [1, 7]`         |
| q14       | questionnaire answer: 7 point Likert-type | `int: [1, 7]`         |
| q15       | questionnaire answer: 7 point Likert-type | `int: [1, 7]`         |
| q16       | questionnaire answer: 7 point Likert-type | `int: [1, 7]`         |
| q17       | questionnaire answer: 7 point Likert-type | `int: [1, 7]`         |
|           | questionnaire answer: 7 point Likert-type | `int: [1, 7]`         |

## processed_data.csv
Contains all the columns from `questionnaire.csv`, with the following modifications and additions. This csv is obtained by running the provided data processing Python code in [this repository](https://github.com/JoshCode/thesis-vr-presence-2024).

| column                  | description                                 | data type (and range) |
| :---------------------- | :------------------------------------------ | --------------------- |
| sample_id               | identifier: row index                       | `int`                 |
| person_id               | identifier: unique person identifier        | `int`                 |
| order_id                | identifier: condition order                 | `int: [1, 6]`         |
| treatment_name          | description: name of `treatment` identifier | `string`              |
| physical_presence_score | calculated score: mean of q1-q5             | `float: [1, 7]`       |
| social_presence_score   | calculated score: mean of q6-q12            | `float: [1, 7]`       |
| self_presence_score     | calculated score: mean of q13-q17           | `float: [1, 7]`       |
| presence_score          | calculated score: mean of q1-q17            | `float: [1, 7]`       |


## experiment_times.csv
This file contains experiment logbook data, concerning time elapsed for every dyad in every condition.

| column             | description                                                  | data type (and range) |
| :----------------- | :----------------------------------------------------------- | --------------------- |
| sample_id          | identifier: row index                                        | `int`                 |
| dyad_id            | identifier: experiment dyad matching other data files        | `int`                 |
| treatment          | identifier: condition/treatment matching other data files    | `char: [A, C]`        |
| time_formatted_1   | time: formatted time of first part of the interaction        | `string: "mm:ss.ss"`  |
| time_formatted_2   | time: formatted time of second part of the interaction       | `string: "mm:ss.ss"`  |
| time_seconds_total | time: calculated time parsing and adding both previous times | `float`               |





