%QCRA MODEL 1
% QCRA M1 Human health risks - deerministic model
%Input data

Ef = 250/365; % days/year
Ed = 25; %years
Et = 8; %hrs
CF = 10E-06; %kg/m3
%IngR = 0.0658; %g/pers/day
IngR = 0.03;%g/pers/day
%IngR = mean of lognormal distibution; %g/pers/day
BW = 7.58E+01; %kg
AT = Ed*365; %days
%InhR = 0.8875; %m3/h
%InhR = 0.1296;
InhR_day = 3.189; %m3/day
InhR = 15.52/24; %m3/h
%InhR = prctile([3 2.9 3.12 3.18], 95)/24;
PEF = 1.36E+09; %m3/g
%SA = 5.7E+03; %cm2
%kp = 1; %100% In this equation the s1ault rate of 100% dermal absorption is assumed.
AT_carc = 70*365; %lifetime in days
SA_hand = 980; %cm2
SA_head= 1250; %cm2
Adh_hand = 2.76E-04; %g/cm2
Adh_face = 9.82E-05; %g/cm2
Ef_derm = 2; %ev/day

mass_product= 1000; %g
mass_reed = mass_product*12/100; %g
mass_Calcite = mass_product*58/100; %g
mass_UPR_polyester = mass_product*27/100; %g
mass_calcite_M3 = mass_product*60/100; %g
mass_UPR_M3 = mass_product*28/100; %g

% QCRA M1 Human health risks

%Calcite (Mined) - data from ICPMS analysis mg/kg
Al_Ca_det_M1 = 318;
Ba_Ca_det_M1=10.92;
Be_Ca_det_M1 = 0.0294;
B_Ca_det_M1 = 7.8;
Ca_Ca_det_M1 = 7358;
Co_Ca_det_M1 =0.272;
Fe_Ca_det_M1 = 636;
Li_Ca_det_M1 = 1.28;
Mg_Ca_det_M1 = 2052;
Mn_Ca_det_M1 = 36.3;
P_Ca_det_M1 = 1624;
K_Ca_det_M1 = 15174;
Na_Ca_det_M1 = 4785;
Ti_Ca_det_M1 = 0.38;
V_Ca_det_M1 = 0.909;
Zn_Ca_det_M1 = 57.4;
Cr_Ca_det_M1= 0.996;
Pb_Ca_det_M1= 2.72;
S_Ca_det_M1 = 1415;
Si_Ca_det_M1 = 1221;
Sr_Ca_det_M1 = 23.3;

%Reed results not contaminated based on ICPMS results

%Composition M1
Aluminium_det_M1 = 0.58* Al_Ca_det_M1;
Barium_det_M1 = 0.58*Ba_Ca_det_M1;
Beryllium_det_M1 = 0.58* Be_Ca_det_M1;
Boron_det_M1 = 0.58*B_Ca_det_M1;
Calcium_det_M1 =  0.58* Ca_Ca_det_M1;
Cobalt_det_M1 = 0.58*Co_Ca_det_M1;
Iron_det_M1 =  0.58* Fe_Ca_det_M1;
Litium_det_M1 = 0.58*Li_Ca_det_M1;
Magnesium_det_M1 =  0.58* Mg_Ca_det_M1;
Manganese_det_M1 = 0.58 * Mn_Ca_det_M1;
Phosphorus_det_M1 = 0.58* P_Ca_det_M1;
Potassium_det_M1 = 0.58* K_Ca_det_M1;
Sodium_det_M1 = 0.58* Na_Ca_det_M1;
Titanium_det_M1 =0.58* Ti_Ca_det_M1;
Vanadium_det_M1 =0.58*V_Ca_det_M1;
Zinc_det_M1 = 0.58 * Zn_Ca_det_M1;
Chromium_det_M1 =0.58* Cr_Ca_det_M1;
Lead_det_M1 = 0.58 * Pb_Ca_det_M1;
Sulfur_det_M1 = 0.58*S_Ca_det_M1;
Silicum_det_M1 = 0.58*Si_Ca_det_M1; 
Strontium_det_M1 = 0.58*Sr_Ca_det_M1;
Styrene_M1 = (mass_UPR_polyester*0.50*1000)./(mass_product./1000); %mg/kg materials - for M1 Styrene concentration in polyester resin = 50%

%Summary M1 contamination based on raw materials

M1_det =[Aluminium_det_M1; Barium_det_M1; Beryllium_det_M1; Boron_det_M1; Calcium_det_M1; Cobalt_det_M1; Iron_det_M1; Litium_det_M1; Magnesium_det_M1; Manganese_det_M1; Phosphorus_det_M1; Potassium_det_M1; Sodium_det_M1; Titanium_det_M1; Vanadium_det_M1; Zinc_det_M1; Chromium_det_M1; Lead_det_M1; Sulfur_det_M1; Silicum_det_M1; Strontium_det_M1; Styrene_M1]; 

%Exposure Assessment - Ingestion
M1_det_ing = [Aluminium_det_M1; Barium_det_M1; Beryllium_det_M1; Boron_det_M1; Cobalt_det_M1; Iron_det_M1; Litium_det_M1; Magnesium_det_M1; Manganese_det_M1; Phosphorus_det_M1; Sodium_det_M1; Titanium_det_M1; Vanadium_det_M1; Zinc_det_M1; Chromium_det_M1; Lead_det_M1; Strontium_det_M1; Styrene_M1];
DingM1_det = (IngR*(M1_det_ing./1000)*Ef*Ed)/(BW*AT);

RfD_ing_M1 = [1E00; 2E-01; 2E-03; 2E-01; 3E-04; 7E-01; 2E-03; 1.1E+01; 2.4E-02; 4.9E+01; 1.9E+01; 3E00; 5.04E-03; 3E-01; 3E-03; 4E-03; 6E-01; 2E-01];

%Risk Quotient - Ingestion 
RQ_Al_ing_M1_det = DingM1_det(1)/RfD_ing_M1(1);
RQ_Ba_ing_M1_det = DingM1_det(2)/RfD_ing_M1(2);
RQ_Be_ing_M1_det = DingM1_det(3)/RfD_ing_M1(3);
RQ_B_ing_M1_det  = DingM1_det(4)/RfD_ing_M1(4);
RQ_Co_ing_M1_det = DingM1_det(5)/RfD_ing_M1(5);
RQ_Fe_ing_M1_det = DingM1_det(6)/RfD_ing_M1(6);
RQ_Li_ing_M1_det = DingM1_det(7)/RfD_ing_M1(7);
RQ_Mg_ing_M1_det = DingM1_det(8)/RfD_ing_M1(8);
RQ_Mn_ing_M1_det = DingM1_det(9)/RfD_ing_M1(9);
RQ_P_ing_M1_det  = DingM1_det(10)/RfD_ing_M1(10);
RQ_Na_ing_M1_det = DingM1_det(11)/RfD_ing_M1(11);
RQ_Ti_ing_M1_det = DingM1_det(12)/RfD_ing_M1(12);
RQ_V_ing_M1_det  = DingM1_det(13)/RfD_ing_M1(13);
RQ_Zn_ing_M1_det = DingM1_det(14)/RfD_ing_M1(14);
RQ_Cr_ing_M1_det = DingM1_det(15)/RfD_ing_M1(15);
RQ_Pb_ing_M1_det = DingM1_det(16)/RfD_ing_M1(16);
RQ_Sr_ing_M1_det = DingM1_det(17)/RfD_ing_M1(17);
RQ_ing_Styrene_det_M1 = DingM1_det(18)/RfD_ing_M1(18);

RQ_ing_M1_det = [RQ_Al_ing_M1_det; RQ_Ba_ing_M1_det; RQ_Be_ing_M1_det; RQ_B_ing_M1_det; RQ_Co_ing_M1_det; RQ_Fe_ing_M1_det; RQ_Li_ing_M1_det; RQ_Mg_ing_M1_det; RQ_Mn_ing_M1_det; RQ_P_ing_M1_det; RQ_Na_ing_M1_det; RQ_Ti_ing_M1_det; RQ_V_ing_M1_det; RQ_Zn_ing_M1_det; RQ_Cr_ing_M1_det; RQ_Pb_ing_M1_det; RQ_Sr_ing_M1_det; RQ_ing_Styrene_det_M1];
RQ_tot_ing_M1 = sum(RQ_ing_M1_det);

%Risk Quotient - Inhalation
% Expsoure assessment - Inhalation
M1_inh_det = [Aluminium_det_M1; Barium_det_M1;Beryllium_det_M1; Boron_det_M1; Cobalt_det_M1; Magnesium_det_M1; Manganese_det_M1; Vanadium_det_M1; Chromium_det_M1; Silicum_det_M1; Styrene_M1];
DinhM1_det = (M1_inh_det* Et* Ed * Ef* InhR)/(PEF*AT*BW);

RfD_inh_M1 = [1.02E-03; 1.02E-04; 4.09E-06; 4.09E-03; 1.23E-06; 2.05E-02; 1.02E-05; 2.05E-05; 2.05E-05; 6.14E-04; 1.84E-01];
RfC_styrene = 0.9; %mg/m3
RfD_inh_styrene = (InhR_day* RfC_styrene) / BW;

RQ_Al_inh_M1_det = DinhM1_det(1)/RfD_inh_M1(1);
RQ_Ba_inh_M1_det = DinhM1_det(2)/RfD_inh_M1(2);
RQ_Be_inh_M1_det = DinhM1_det(3)/RfD_inh_M1(3);
RQ_B_inh_M1_det  = DinhM1_det(4)/RfD_inh_M1(4);
RQ_Co_inh_M1_det = DinhM1_det(5)/RfD_inh_M1(5);
RQ_Mg_inh_M1_det = DinhM1_det(6)/RfD_inh_M1(6);
RQ_Mn_inh_M1_det = DinhM1_det(7)/RfD_inh_M1(7);
RQ_V_inh_M1_det  = DinhM1_det(8)/RfD_inh_M1(8);
RQ_Cr_inh_M1_det = DinhM1_det(9)/RfD_inh_M1(9);
RQ_Si_inh_M1_det = DinhM1_det(10)/RfD_inh_M1(10);
RQ_inh_Styrene_det_M1 = DinhM1_det(11)/RfD_inh_M1(11);

RQ_inh_M1_det = [RQ_Al_inh_M1_det; RQ_Ba_inh_M1_det; RQ_Be_inh_M1_det; RQ_B_inh_M1_det; RQ_Co_inh_M1_det; RQ_Mg_inh_M1_det; RQ_Mn_inh_M1_det; RQ_V_inh_M1_det; RQ_Cr_inh_M1_det; RQ_Si_inh_M1_det; RQ_inh_Styrene_det_M1];
RQ_tot_inh_M1 = sum(RQ_inh_M1_det);

%Dermal exposure
M1_det_derm = [Aluminium_det_M1; Barium_det_M1; Beryllium_det_M1; Boron_det_M1; Cobalt_det_M1; Litium_det_M1; Magnesium_det_M1; Manganese_det_M1; Phosphorus_det_M1; Sodium_det_M1; Vanadium_det_M1; Zinc_det_M1; Chromium_det_M1; Strontium_det_M1; Styrene_M1];

DA_derm_face_det_M1 = ((M1_det_derm/1000).*Adh_face); %mg/cm2-d
DA_derm_hand_det_M1 = ((M1_det_derm/1000).*Adh_hand); %mg/cm2-d

ADD_derm_face_det_M1 = (DA_derm_face_det_M1*SA_head*Ef*Ed)/(AT*BW); % mg/kg-day
ADD_derm_hand_det_M1 = (DA_derm_hand_det_M1*SA_hand*Ef*Ed)/(AT*BW); % mg/kg-day

ADD_derm_M1_det = ADD_derm_face_det_M1 + ADD_derm_hand_det_M1;

RfD_derm_M1 = [1; 1.4E-02; 1.4E-05; 2E-01; 3E-04; 2E-03; 1.1E+01; 9.6E-04; 4.9E+01; 1.9E+01; 1.31E-04; 3E-01; 7.5E-05; 6E-01; 2E-01];

RQ_Al_derm_M1_det = ADD_derm_M1_det(1)/RfD_derm_M1(1);
RQ_Ba_derm_M1_det = ADD_derm_M1_det(2)/RfD_derm_M1(2);
RQ_Be_derm_M1_det = ADD_derm_M1_det(3)/RfD_derm_M1(3);
RQ_B_derm_M1_det  = ADD_derm_M1_det(4)/RfD_derm_M1(4);
RQ_Co_derm_M1_det = ADD_derm_M1_det(5)/RfD_derm_M1(5);
RQ_Li_derm_M1_det = ADD_derm_M1_det(6)/RfD_derm_M1(6);
RQ_Mg_derm_M1_det = ADD_derm_M1_det(7)/RfD_derm_M1(7);
RQ_Mn_derm_M1_det = ADD_derm_M1_det(8)/RfD_derm_M1(8);
RQ_P_derm_M1_det  = ADD_derm_M1_det(9)/RfD_derm_M1(9);
RQ_Na_derm_M1_det = ADD_derm_M1_det(10)/RfD_derm_M1(10);
RQ_V_derm_M1_det  = ADD_derm_M1_det(11)/RfD_derm_M1(11);
RQ_Zn_derm_M1_det = ADD_derm_M1_det(12)/RfD_derm_M1(12);
RQ_Cr_derm_M1_det = ADD_derm_M1_det(13)/RfD_derm_M1(13);
RQ_Sr_derm_M1_det = ADD_derm_M1_det(14)/RfD_derm_M1(14);
RQ_styrene_derm_M1_det = ADD_derm_M1_det(15)/RfD_derm_M1(15);

RQ_derm_M1_det =[RQ_Al_derm_M1_det; RQ_Ba_derm_M1_det; RQ_Be_derm_M1_det;RQ_B_derm_M1_det; RQ_Co_derm_M1_det; RQ_Li_derm_M1_det; RQ_Mg_derm_M1_det; RQ_Mn_derm_M1_det; RQ_P_derm_M1_det; RQ_Na_derm_M1_det; RQ_V_derm_M1_det; RQ_Zn_derm_M1_det; RQ_Cr_derm_M1_det; RQ_Sr_derm_M1_det; RQ_styrene_derm_M1_det];

RQ_tot_derm_M1 = sum(RQ_derm_M1_det);

%Risk Characterization

RI_Al_Det_M1 = RQ_Al_ing_M1_det + RQ_Al_inh_M1_det + RQ_Al_derm_M1_det;
RI_Ba_Det_M1 = RQ_Ba_ing_M1_det + RQ_Ba_inh_M1_det + RQ_Ba_derm_M1_det;
RI_Be_Det_M1 = RQ_Be_ing_M1_det + RQ_Be_inh_M1_det + RQ_Be_derm_M1_det;
RI_B_Det_M1  = RQ_B_ing_M1_det + RQ_B_inh_M1_det + RQ_B_derm_M1_det;
RI_Co_Det_M1 = RQ_Co_ing_M1_det + RQ_Co_inh_M1_det + RQ_Co_derm_M1_det;
RI_Fe_Det_M1 = RQ_Fe_ing_M1_det;
RI_Li_Det_M1 = RQ_Li_ing_M1_det + RQ_Li_derm_M1_det;
RI_Mg_Det_M1 = RQ_Mg_ing_M1_det + RQ_Mg_inh_M1_det + RQ_Mg_derm_M1_det;
RI_Mn_Det_M1 = RQ_Mn_ing_M1_det + RQ_Mn_inh_M1_det + RQ_Mn_derm_M1_det;
RI_P_Det_M1  = RQ_P_ing_M1_det + RQ_P_derm_M1_det;
RI_Na_Det_M1 = RQ_Na_ing_M1_det + RQ_Na_derm_M1_det;
RI_Ti_Det_M1 = RQ_Ti_ing_M1_det;
RI_V_Det_M1  = RQ_V_ing_M1_det  + RQ_V_inh_M1_det  + RQ_V_derm_M1_det;
RI_Zn_Det_M1 = RQ_Zn_ing_M1_det + RQ_Zn_derm_M1_det;
RI_Cr_Det_M1 = RQ_Cr_ing_M1_det + RQ_Cr_inh_M1_det + RQ_Cr_derm_M1_det;
RI_Pb_Det_M1 = RQ_Pb_ing_M1_det;
RI_Si_Det_M1 = RQ_Si_inh_M1_det;
RI_Sr_Det_M1 = RQ_Sr_ing_M1_det + RQ_Sr_derm_M1_det;
RI_Styrene_det_M1 = RQ_ing_Styrene_det_M1 + RQ_inh_Styrene_det_M1 + RQ_styrene_derm_M1_det;

RI_M1_det = [RI_Al_Det_M1; RI_Ba_Det_M1; RI_Be_Det_M1; RI_B_Det_M1; RI_Co_Det_M1; RI_Fe_Det_M1; RI_Li_Det_M1; RI_Mg_Det_M1; RI_Mn_Det_M1; RI_P_Det_M1; RI_Na_Det_M1; RI_Ti_Det_M1; RI_V_Det_M1; RI_Zn_Det_M1; RI_Cr_Det_M1; RI_Pb_Det_M1;RI_Si_Det_M1; RI_Sr_Det_M1; RI_Styrene_det_M1];

RItot_M1_det = sum(RI_M1_det);

figure
%plot(RI_M1_det);
bar(RI_M1_det);
%ylim([0 2]);
yline(1,'-','Threshold');
set(gca, 'YScale', 'log');
title("RI Material M1 - Determinisic approach");
xlabel("Metals");
ylabel("Risk Index");
xticks([1 2 3 4 5 6 7 8 9 10 11 12 13 14 15 16 17 18 19]);
xticklabels({"Al", "Ba", "Be", "B", "Co", "Fe", "Li", "Mg", "Mn", "P", "Na", "Ti", "V", "Zn", "Cr", "Pb", "Si","Sr", "Styrene"});
xlim([0 20]);

% QCRA M2 Human health risks

%Calcite (Mined) - data from ICPMS analysis - no literature data available
Al_Ca_det_M2 = 318;
Ba_Ca_det_M2=10.92;
Be_Ca_det_M2 = 0.0294;
B_Ca_det_M2 = 7.8;
Ca_Ca_det_M2 = 7358;
Co_Ca_det_M2 =0.272;
Fe_Ca_det_M2 = 636;
Li_Ca_det_M2 = 1.28;
Mg_Ca_det_M2 = 2052;
Mn_Ca_det_M2 = 36.3;
P_Ca_det_M2 = 1624;
K_Ca_det_M2 = 15174;
Na_Ca_det_M2 = 4785;
Ti_Ca_det_M2 = 0.38;
V_Ca_det_M2 = 0.909;
Zn_Ca_det_M2 = 57.4;
Cr_Ca_det_M2= 0.996;
Pb_Ca_det_M2= 2.72;
S_Ca_det_M2 = 1415;
Si_Ca_det_M2 = 1221;
Sr_Ca_det_M2 = 23.3;
%DW Calcite from lab analysis

Al_DWCa_det_M2 = 13.4;
Ba_DWCa_det_M2= 0.6;
Ca_DWCa_det_M2 = 173827;
Mg_DWCa_det_M2 = 547;
Mn_DWCa_det_M2 = 11.6;
K_DWCa_det_M2 = 30.2;
Na_DWCa_det_M2 = 24;
Sr_DWCa_det_M2 = 27.1;


% %Total Calcite M2 (mg/kg)
Aluminium_Ca_det_M2 = 0.5*Al_Ca_det_M2 + 0.5* Al_DWCa_det_M2;
Barium_Ca_det_M2 = 0.5* Ba_Ca_det_M2 + 0.5*Ba_DWCa_det_M2;
Beryllium_Ca_det_M2 = 0.5*Be_Ca_det_M2;
Boron_Ca_det_M2 = 0.5*B_Ca_det_M2;
Calcium_Ca_det_M2 = 0.5*Ca_Ca_det_M2 + 0.5*Ca_DWCa_det_M2;
Cobalt_Ca_det_M2 = 0.5*Co_Ca_det_M2;
Iron_Ca_det_M2 = 0.5*Fe_Ca_det_M2;
Litium_Ca_det_M2 = 0.5*Li_Ca_det_M2;
Magnesium_Ca_det_M2 = 0.5*Mg_Ca_det_M2 + 0.5*Mg_DWCa_det_M2;
Manganese_Ca_det_M2 = 0.5*Mn_Ca_det_M2 + 0.5*Mn_DWCa_det_M2;
Phosphorus_Ca_det_M2 = 0.5*P_Ca_det_M2;
Potassium_Ca_det_M2 = 0.5*K_Ca_det_M2 + 0.5*K_DWCa_det_M2;
Sodium_Ca_det_M2 = 0.5*Na_Ca_det_M2 + 0.5*Na_DWCa_det_M2;
Titanium_Ca_det_M2 = 0.5*Ti_Ca_det_M2;
Vanadium_Ca_det_M2 = 0.5*V_Ca_det_M2;
Zinc_Ca_det_M2 = 0.5*Zn_Ca_det_M2;
Chromium_Ca_det_M2 = 0.5* Cr_Ca_det_M2;
Lead_Ca_det_M2 = 0.5* Pb_Ca_det_M2;
Sulfur_Ca_det_M2 = 0.5*S_Ca_det_M2;
Silicum_Ca_det_M2 = 0.5* Si_Ca_det_M2;
Strontium_Ca_det_M2 = 0.5*Sr_Ca_det_M2 + 0.5*Sr_DWCa_det_M2;



%Composition M2 (mg/kg)
Aluminium_det_M2 = 0.58* Aluminium_Ca_det_M2;
Barium_det_M2 = 0.58*Barium_Ca_det_M2;
Beryllium_det_M2 = 0.58* Beryllium_Ca_det_M2;
Boron_det_M2 = 0.58*Boron_Ca_det_M2;
Calcium_det_M2 =  0.58 * Calcium_Ca_det_M2;
Cobalt_det_M2 = 0.58*Cobalt_Ca_det_M2;
Iron_det_M2 = 0.58* Iron_Ca_det_M2;
Litium_det_M2 = 0.58*Litium_Ca_det_M2;
Magnesium_det_M2 = 0.58* Magnesium_Ca_det_M2;
Manganese_det_M2 = 0.58 * Manganese_Ca_det_M2;
Phosphorus_det_M2 = 0.58* Phosphorus_Ca_det_M2;
Potassium_det_M2 = 0.58* Potassium_Ca_det_M2;
Sodium_det_M2 = 0.58* Sodium_Ca_det_M2;
Titanium_det_M2 = 0.58* Titanium_Ca_det_M2;
Vanadium_det_M2 = 0.58*Vanadium_Ca_det_M2;
Zinc_det_M2 = 00.58 * Zinc_Ca_det_M2;
Chromium_det_M2 = 0.58* Chromium_Ca_det_M2;
Lead_det_M2 = 0.58 * Lead_Ca_det_M2;
Sulfur_det_M2 = 0.58*Sulfur_Ca_det_M2;
Silicum_det_M2 = 0.58*Silicum_Ca_det_M2; 
Strontium_det_M2 = 0.58*Strontium_Ca_det_M2;
Styrene_M2 = (mass_UPR_polyester*0.35*1000)/(mass_product/1000); %g/kg materials


M2_det_M2 = [Aluminium_det_M2; Barium_det_M2; Beryllium_det_M2; Boron_det_M2; Calcium_det_M2; Cobalt_det_M2; Iron_det_M2; Litium_det_M2; Magnesium_det_M2; Manganese_det_M2; Phosphorus_det_M2; Potassium_det_M2; Sodium_det_M2; Titanium_det_M2; Vanadium_det_M2; Zinc_det_M2; Chromium_det_M2; Lead_det_M2; Sulfur_det_M2; Silicum_det_M2; Strontium_det_M2; Styrene_M2];
 
%Exposure Assessment - Ingestion

M2_det_ing = [Aluminium_det_M2; Barium_det_M2; Beryllium_det_M2; Boron_det_M2; Cobalt_det_M2; Iron_det_M2; Litium_det_M2; Magnesium_det_M2; Manganese_det_M2; Phosphorus_det_M2; Sodium_det_M2; Titanium_det_M2; Vanadium_det_M2; Zinc_det_M2; Chromium_det_M2; Lead_det_M2; Strontium_det_M2; Styrene_M2];
DingM2_det = (IngR*(M2_det_ing./1000)*Ef*Ed)/(BW*AT);

RfD_ing_M2 = [1E00; 2E-01; 2E-03; 2E-01; 3E-04; 7E-01; 2E-03; 1.1E+01; 2.4E-02; 4.9E+01; 1.9E+01; 3E00; 5.04E-03; 3E-01; 3E-03; 4E-03; 6E-01; 2E-01];

RQ_Al_ing_M2_det = DingM2_det(1)/RfD_ing_M2(1);
RQ_Ba_ing_M2_det = DingM2_det(2)/RfD_ing_M2(2);
RQ_Be_ing_M2_det = DingM2_det(3)/RfD_ing_M2(3);
RQ_B_ing_M2_det  = DingM2_det(4)/RfD_ing_M2(4);
RQ_Co_ing_M2_det = DingM2_det(5)/RfD_ing_M2(5);
RQ_Fe_ing_M2_det = DingM2_det(6)/RfD_ing_M2(6);
RQ_Li_ing_M2_det = DingM2_det(7)/RfD_ing_M2(7);
RQ_Mg_ing_M2_det = DingM2_det(8)/RfD_ing_M2(8);
RQ_Mn_ing_M2_det = DingM2_det(9)/RfD_ing_M2(9);
RQ_P_ing_M2_det  = DingM2_det(10)/RfD_ing_M2(10);
RQ_Na_ing_M2_det = DingM2_det(11)/RfD_ing_M2(11);
RQ_Ti_ing_M2_det = DingM2_det(12)/RfD_ing_M2(12);
RQ_V_ing_M2_det  = DingM2_det(13)/RfD_ing_M2(13);
RQ_Zn_ing_M2_det = DingM2_det(14)/RfD_ing_M2(14);
RQ_Cr_ing_M2_det = DingM2_det(15)/RfD_ing_M2(15);
RQ_Pb_ing_M2_det = DingM2_det(16)/RfD_ing_M2(16);
RQ_Sr_ing_M2_det = DingM2_det(17)/RfD_ing_M2(17);
RQ_ing_Styrene_det_M2 = DingM2_det(18)/RfD_ing_M2(18);

RQ_ing_M2_det = [RQ_Al_ing_M2_det; RQ_Ba_ing_M2_det; RQ_Be_ing_M2_det; RQ_B_ing_M2_det; RQ_Co_ing_M2_det;RQ_Fe_ing_M2_det; RQ_Li_ing_M2_det; RQ_Mg_ing_M2_det; RQ_Mn_ing_M2_det; RQ_P_ing_M2_det; RQ_Na_ing_M2_det; RQ_Ti_ing_M2_det; RQ_V_ing_M2_det; RQ_Zn_ing_M2_det; RQ_Cr_ing_M2_det; RQ_Pb_ing_M2_det; RQ_Sr_ing_M2_det; RQ_ing_Styrene_det_M2];

RQ_tot_ing_M2 = sum(RQ_ing_M2_det);

% Expsoure assessment - Inhalation

M2_inh_det = [Aluminium_det_M2; Barium_det_M2; Beryllium_det_M2; Boron_det_M2; Cobalt_det_M2; Magnesium_det_M2; Manganese_det_M2; Vanadium_det_M2; Chromium_det_M2; Silicum_det_M2; Styrene_M2];
DinhM2_det = (M2_inh_det* Et* Ed * Ef* InhR)/(PEF*AT*BW);
RfD_inh_M2 = [1.02E-03; 1.024E-04; 4.09E-06; 4.09E-03; 1.23E-06; 2.05E-02; 1.02E-05; 2.05E-05; 2.05E-05; 6.14E-04; 1.84E-01];

RQ_Al_inh_M2_det = DinhM2_det(1)/RfD_inh_M2(1);
RQ_Ba_inh_M2_det = DinhM2_det(2)/RfD_inh_M2(2);
RQ_Be_inh_M2_det = DinhM2_det(3)/RfD_inh_M2(3);
RQ_B_inh_M2_det  = DinhM2_det(4)/RfD_inh_M2(4);
RQ_Co_inh_M2_det = DinhM2_det(5)/RfD_inh_M2(5);
RQ_Mg_inh_M2_det = DinhM2_det(6)/RfD_inh_M2(6);
RQ_Mn_inh_M2_det = DinhM2_det(7)/RfD_inh_M2(7);
RQ_V_inh_M2_det  = DinhM2_det(8)/RfD_inh_M2(8);
RQ_Cr_inh_M2_det = DinhM2_det(9)/RfD_inh_M2(9);
RQ_Si_inh_M2_det = DinhM2_det(10)/RfD_inh_M2(10);
RQ_inh_Styrene_det_M2 = DinhM2_det(11)/RfD_inh_M2(11);

RQ_inh_M2_det = [RQ_Al_inh_M2_det; RQ_Ba_inh_M2_det; RQ_Be_inh_M2_det; RQ_B_inh_M2_det; RQ_Co_inh_M2_det; RQ_Mg_inh_M2_det; RQ_Mn_inh_M2_det; RQ_V_inh_M2_det; RQ_Cr_inh_M2_det; RQ_Si_inh_M2_det; RQ_inh_Styrene_det_M2];
RQ_tot_inh_M2 = sum(RQ_inh_M2_det);

%Dermal exposure
M2_det_derm = [Aluminium_det_M2; Barium_det_M2; Beryllium_det_M2; Boron_det_M2; Cobalt_det_M2; Litium_det_M2; Magnesium_det_M2; Manganese_det_M2; Phosphorus_det_M2; Sodium_det_M2; Vanadium_det_M2; Zinc_det_M2; Chromium_det_M2; Strontium_det_M2; Styrene_M2];

DA_derm_face_det_M2 = ((M2_det_derm/1000).*Adh_face); %mg/cm2-d
DA_derm_hand_det_M2 = ((M2_det_derm/1000).*Adh_hand); %mg/cm2-d

ADD_derm_face_det_M2 = (DA_derm_face_det_M2*SA_head*Ef*Ed)/(AT*BW); % mg/kg-day
ADD_derm_hand_det_M2 = (DA_derm_hand_det_M2*SA_hand*Ef*Ed)/(AT*BW); % mg/kg-day

ADD_derm_M2_det = ADD_derm_face_det_M2 + ADD_derm_hand_det_M2;


RfD_derm_M2 = [1; 1.4E-02; 1.4E-05; 2E-01; 3E-04; 2E-03; 1.1E+01; 9.6E-04; 4.9E+01; 1.9E+01; 1.31E-04; 3E-01; 7.5E-05; 6E-01; 2E-01];

RQ_Al_derm_M2_det = ADD_derm_M2_det(1)/RfD_derm_M2(1);
RQ_Ba_derm_M2_det = ADD_derm_M2_det(2)/RfD_derm_M2(2);
RQ_Be_derm_M2_det = ADD_derm_M2_det(3)/RfD_derm_M2(3);
RQ_B_derm_M2_det  = ADD_derm_M2_det(4)/RfD_derm_M2(4);
RQ_Co_derm_M2_det = ADD_derm_M2_det(5)/RfD_derm_M2(5);
RQ_Li_derm_M2_det = ADD_derm_M2_det(6)/RfD_derm_M2(6);
RQ_Mg_derm_M2_det = ADD_derm_M2_det(7)/RfD_derm_M2(7);
RQ_Mn_derm_M2_det = ADD_derm_M2_det(8)/RfD_derm_M2(8);
RQ_P_derm_M2_det  = ADD_derm_M2_det(9)/RfD_derm_M2(9);
RQ_Na_derm_M2_det = ADD_derm_M2_det(10)/RfD_derm_M2(10);
RQ_V_derm_M2_det  = ADD_derm_M2_det(11)/RfD_derm_M2(11);
RQ_Zn_derm_M2_det = ADD_derm_M2_det(12)/RfD_derm_M2(12);
RQ_Cr_derm_M2_det = ADD_derm_M2_det(13)/RfD_derm_M2(13);
RQ_Sr_derm_M2_det = ADD_derm_M2_det(14)/RfD_derm_M2(14);
RQ_styrene_derm_M2_det = ADD_derm_M2_det(15)/RfD_derm_M2(15);

RQ_derm_M2_det =[RQ_Al_derm_M2_det; RQ_Ba_derm_M2_det; RQ_Be_derm_M2_det;RQ_B_derm_M2_det; RQ_Co_derm_M2_det; RQ_Li_derm_M2_det; RQ_Mg_derm_M2_det; RQ_Mn_derm_M2_det; RQ_P_derm_M2_det; RQ_Na_derm_M2_det; RQ_V_derm_M2_det; RQ_Zn_derm_M2_det; RQ_Cr_derm_M2_det; RQ_Sr_derm_M2_det; RQ_styrene_derm_M2_det];

RQ_tot_derm_M2 = sum(RQ_derm_M2_det);

%Total no-cancer risk
RI_Al_Det_M2 = RQ_Al_ing_M2_det + RQ_Al_inh_M2_det + RQ_Al_derm_M2_det;
RI_Ba_Det_M2 = RQ_Ba_ing_M2_det + RQ_Ba_inh_M2_det + RQ_Ba_derm_M2_det;
RI_Be_Det_M2 = RQ_Be_ing_M2_det + RQ_Be_inh_M2_det + RQ_Be_derm_M2_det;
RI_B_Det_M2  = RQ_B_ing_M2_det + RQ_B_inh_M2_det + RQ_B_derm_M2_det;
RI_Co_Det_M2 = RQ_Co_ing_M2_det + RQ_Co_inh_M2_det + RQ_Co_derm_M2_det;
RI_Fe_Det_M2 = RQ_Fe_ing_M2_det;
RI_Li_Det_M2 = RQ_Li_ing_M2_det + RQ_Li_derm_M2_det;
RI_Mg_Det_M2 = RQ_Mg_ing_M2_det + RQ_Mg_inh_M2_det + RQ_Mg_derm_M2_det;
RI_Mn_Det_M2 = RQ_Mn_ing_M2_det + RQ_Mn_inh_M2_det + RQ_Mn_derm_M2_det;
RI_P_Det_M2  = RQ_P_ing_M2_det + RQ_P_derm_M2_det;
RI_Na_Det_M2 = RQ_Na_ing_M2_det + RQ_Na_derm_M2_det;
RI_Ti_Det_M2 = RQ_Ti_ing_M2_det;
RI_V_Det_M2  = RQ_V_ing_M2_det  + RQ_V_inh_M2_det  + RQ_V_derm_M2_det;
RI_Zn_Det_M2 = RQ_Zn_ing_M2_det + RQ_Zn_derm_M2_det;
RI_Cr_Det_M2 = RQ_Cr_ing_M2_det + RQ_Cr_inh_M2_det + RQ_Cr_derm_M2_det;
RI_Pb_Det_M2 = RQ_Pb_ing_M2_det;
RI_Si_Det_M2 = RQ_Si_inh_M2_det;
RI_Sr_Det_M2 = RQ_Sr_ing_M2_det + RQ_Sr_derm_M2_det;
RI_Styrene_det_M2 = RQ_ing_Styrene_det_M2 + RQ_inh_Styrene_det_M2 + RQ_styrene_derm_M2_det;

RI_M2_det = [RI_Al_Det_M2; RI_Ba_Det_M2; RI_Be_Det_M2; RI_B_Det_M2; RI_Co_Det_M2; RI_Fe_Det_M2; RI_Li_Det_M2; RI_Mg_Det_M2; RI_Mn_Det_M2; RI_P_Det_M2; RI_Na_Det_M2; RI_Ti_Det_M2; RI_V_Det_M2; RI_Zn_Det_M2; RI_Cr_Det_M2; RI_Pb_Det_M2;RI_Si_Det_M2; RI_Sr_Det_M2; RI_Styrene_det_M2];

RItot_M2_det = sum(RI_M2_det);

figure
%plot(RI_M1_det);
bar(RI_M2_det);
%ylim([0 2]);
yline(1,'-','Threshold');
set(gca, 'YScale', 'log');
title("RI Material M2 - Determinisic approach");
xlabel("Metals");
ylabel("Risk Index");
xticks([1 2 3 4 5 6 7 8 9 10 11 12 13 14 15 16 17 18 19]);
xticklabels({"Al", "Ba", "Be", "B", "Co", "Fe", "Li", "Mg", "Mn", "P", "Na", "Ti", "V", "Zn", "Cr", "Pb", "Si","Sr", "Styrene"});
xlim([0 20]);

% QCRA M3 Human health risks - deerministic model

% QCRA M3 Human health risks

%cellulose
Aluminium_Ce_det_M3 = 3.12;
Barium_Ce_det_M3 = 4.19;
Boron_Ce_det_M3 = 1.52;
Calcium_Ce_det_M3 = 6.98E+02;
Iron_Ce_det_M3 = 1.39E+01;
Magnesium_Ce_det_M3 = 3.83E+02;
Manganese_Ce_det_M3 = 2.78E+01;
Phosphorus_Ce_det_M3 = 1.76E+02;
Potassium_Ce_det_M3 = 9.71E+02;
Sodium_Ce_det_M3 = 6.15E+02;
Zinc_Ce_det_M3 = 2.11E+01;
Sulfur_Ce_det_M3 = 5.81E+02;
Silicum_Ce_det_M3 = 7.77E+02;
Strontium_Ce_det_M3 = 6;

%Calcite (Mined) - data from ICPMS analysis - no literature data available
Al_Ca_det_M3 = 318;
Ba_Ca_det_M3=10.92;
Be_Ca_det_M3 = 0.0294;
B_Ca_det_M3 = 7.8;
Ca_Ca_det_M3 = 7358;
Co_Ca_det_M3 =0.272;
Fe_Ca_det_M3 = 636;
Li_Ca_det_M3 = 1.28;
Mg_Ca_det_M3 = 2052;
Mn_Ca_det_M3 = 36.3;
P_Ca_det_M3 = 1624;
K_Ca_det_M3 = 15174;
Na_Ca_det_M3 = 4785;
Ti_Ca_det_M3 = 0.38;
V_Ca_det_M3 = 0.909;
Zn_Ca_det_M3 = 57.4;
Cr_Ca_det_M3= 0.996;
Pb_Ca_det_M3= 2.72;
S_Ca_det_M3 = 1415;
Si_Ca_det_M3 = 1221;
Sr_Ca_det_M3 = 23.3;

%DW Calcite from lab analysis
Al_DWCa_det_M3 = 13.4;
Ba_DWCa_det_M3= 0.6;
Ca_DWCa_det_M3 = 173827;
Mg_DWCa_det_M3 = 547;
Mn_DWCa_det_M3 = 11.6;
K_DWCa_det_M3 = 30.2;
Na_DWCa_det_M3 = 24;
Sr_DWCa_det_M3 = 27.1;


% %Total Calcite M3 (mg/kg)
Aluminium_Ca_det_M3 = 0.5*Al_Ca_det_M3 + 0.5* Al_DWCa_det_M3;
Barium_Ca_det_M3 = 0.5* Ba_Ca_det_M3 + 0.5*Ba_DWCa_det_M3;
Beryllium_Ca_det_M3 = 0.5*Be_Ca_det_M3;
Boron_Ca_det_M3 = 0.5*B_Ca_det_M3;
Calcium_Ca_det_M3 = 0.5*Ca_Ca_det_M3 + 0.5*Ca_DWCa_det_M3;
Cobalt_Ca_det_M3 = 0.5*Co_Ca_det_M3;
Iron_Ca_det_M3 = 0.5*Fe_Ca_det_M3;
Litium_Ca_det_M3 = 0.5*Li_Ca_det_M3;
Magnesium_Ca_det_M3 = 0.5*Mg_Ca_det_M3 + 0.5*Mg_DWCa_det_M3;
Manganese_Ca_det_M3 = 0.5*Mn_Ca_det_M3 + 0.5*Mn_DWCa_det_M3;
Phosphorus_Ca_det_M3 = 0.5*P_Ca_det_M3;
Potassium_Ca_det_M3 = 0.5*K_Ca_det_M3 + 0.5*K_DWCa_det_M3;
Sodium_Ca_det_M3 = 0.5*Na_Ca_det_M3 + 0.5*Na_DWCa_det_M3;
Titanium_Ca_det_M3 = 0.5*Ti_Ca_det_M3;
Vanadium_Ca_det_M3 = 0.5*V_Ca_det_M3;
Zinc_Ca_det_M3 = 0.5*Zn_Ca_det_M3;
Chromium_Ca_det_M3 = 0.5* Cr_Ca_det_M3;
Lead_Ca_det_M3 = 0.5* Pb_Ca_det_M3;
Sulfur_Ca_det_M3 = 0.5*S_Ca_det_M3;
Silicum_Ca_det_M3 = 0.5* Si_Ca_det_M3;
Strontium_Ca_det_M3 = 0.5*Sr_Ca_det_M3 + 0.5*Sr_DWCa_det_M3;

%Composition M3 (mg/kg)
Aluminium_det_M3 = 0.10*Aluminium_Ce_det_M3 + 0.60* Aluminium_Ca_det_M3;
Barium_det_M3 = 0.10*Barium_Ce_det_M3 + 0.60*Barium_Ca_det_M3;
Beryllium_det_M3 = 0.60* Beryllium_Ca_det_M3;
Boron_det_M3 = 0.10*Boron_Ce_det_M3 + 0.60*Boron_Ca_det_M3;
Calcium_det_M3 = 0.10*Calcium_Ce_det_M3 + 0.60 * Calcium_Ca_det_M3;
Cobalt_det_M3 = 0.60*Cobalt_Ca_det_M3;
Iron_det_M3 = 0.10*Iron_Ce_det_M3 + 0.60* Iron_Ca_det_M3;
Litium_det_M3 = 0.60*Litium_Ca_det_M3;
Magnesium_det_M3 = 0.10*Magnesium_Ce_det_M3 + 0.60* Magnesium_Ca_det_M3;
Manganese_det_M3 = 0.10 * Manganese_Ce_det_M3 + 0.60 * Manganese_Ca_det_M3;
Phosphorus_det_M3 = 0.10*Phosphorus_Ce_det_M3 + 0.60* Phosphorus_Ca_det_M3;
Potassium_det_M3 = 0.10*Potassium_Ce_det_M3 + 0.60* Potassium_Ca_det_M3;
Sodium_det_M3 = 0.10*Sodium_Ce_det_M3 + 0.60* Sodium_Ca_det_M3;
Titanium_det_M3 = 0.60* Titanium_Ca_det_M3;
Vanadium_det_M3 =0.60*Vanadium_Ca_det_M3;
Zinc_det_M3 = 0.10 * Zinc_Ce_det_M3 + 0.60 * Zinc_Ca_det_M3;
Chromium_det_M3 = 0.60* Chromium_Ca_det_M3;
Lead_det_M3 = 0.60 * Lead_Ca_det_M3;
Sulfur_det_M3 = 0.10*Sulfur_Ce_det_M3+ 0.60*Sulfur_Ca_det_M3;
Silicum_det_M3 = 0.10*Silicum_Ce_det_M3 + 0.60*Silicum_Ca_det_M3; 
Strontium_det_M3 = 0.10*Strontium_Ce_det_M3+ 0.60*Strontium_Ca_det_M3;
Styrene_M3 = (mass_UPR_M3*0.35*1000)/(mass_product/1000); %g/kg materials 

M3_det = [Aluminium_det_M3; Barium_det_M3; Beryllium_det_M3; Boron_det_M3; Calcium_det_M3; Cobalt_det_M3; Iron_det_M3; Litium_det_M3; Magnesium_det_M3; Manganese_det_M3; Phosphorus_det_M3; Potassium_det_M3; Sodium_det_M3; Titanium_det_M3; Vanadium_det_M3; Zinc_det_M3; Chromium_det_M3; Lead_det_M3; Sulfur_det_M3; Silicum_det_M3; Strontium_det_M3; Styrene_M3];

%Exposure Assessment - Ingestion
M3_det_ing = [Aluminium_det_M3; Barium_det_M3; Beryllium_det_M3; Boron_det_M3; Cobalt_det_M3; Iron_det_M3; Litium_det_M3; Magnesium_det_M3; Manganese_det_M3; Phosphorus_det_M3; Sodium_det_M3; Titanium_det_M3; Vanadium_det_M3; Zinc_det_M3; Chromium_det_M3; Lead_det_M3; Strontium_det_M3; Styrene_M3];
DingM3_det = (IngR*(M3_det_ing./1000)*Ef*Ed)/(BW*AT);

RfD_ing_M3 = [1E00; 2E-01; 2E-03; 2E-01; 3E-04; 7E-01; 2E-03; 1.1E+01; 2.4E-02; 4.9E+01; 1.9E+01; 3E00; 5.04E-03; 3E-01; 3E-03; 4E-03; 6E-01; 2E-01];

RQ_Al_ing_M3_det = DingM3_det(1)/RfD_ing_M3(1);
RQ_Ba_ing_M3_det = DingM3_det(2)/RfD_ing_M3(2);
RQ_Be_ing_M3_det = DingM3_det(3)/RfD_ing_M3(3);
RQ_B_ing_M3_det  = DingM3_det(4)/RfD_ing_M3(4);
RQ_Co_ing_M3_det = DingM3_det(5)/RfD_ing_M3(5);
RQ_Fe_ing_M3_det = DingM3_det(6)/RfD_ing_M3(6);
RQ_Li_ing_M3_det = DingM3_det(7)/RfD_ing_M3(7);
RQ_Mg_ing_M3_det = DingM3_det(8)/RfD_ing_M3(8);
RQ_Mn_ing_M3_det = DingM3_det(9)/RfD_ing_M3(9);
RQ_P_ing_M3_det  = DingM3_det(10)/RfD_ing_M3(10);
RQ_Na_ing_M3_det = DingM3_det(11)/RfD_ing_M3(11);
RQ_Ti_ing_M3_det = DingM3_det(12)/RfD_ing_M3(12);
RQ_V_ing_M3_det  = DingM3_det(13)/RfD_ing_M3(13);
RQ_Zn_ing_M3_det = DingM3_det(14)/RfD_ing_M3(14);
RQ_Cr_ing_M3_det = DingM3_det(15)/RfD_ing_M3(15);
RQ_Pb_ing_M3_det = DingM3_det(16)/RfD_ing_M3(16);
RQ_Sr_ing_M3_det = DingM3_det(17)/RfD_ing_M3(17);
RQ_ing_Styrene_det_M3 = DingM3_det(18)/RfD_ing_M3(18);

RQ_ing_M3_det = [RQ_Al_ing_M3_det; RQ_Ba_ing_M3_det; RQ_Be_ing_M3_det; RQ_B_ing_M3_det; RQ_Co_ing_M3_det;RQ_Fe_ing_M3_det; RQ_Li_ing_M3_det; RQ_Mg_ing_M3_det; RQ_Mn_ing_M3_det; RQ_P_ing_M3_det; RQ_Na_ing_M3_det; RQ_Ti_ing_M3_det; RQ_V_ing_M3_det; RQ_Zn_ing_M3_det; RQ_Cr_ing_M3_det; RQ_Pb_ing_M3_det; RQ_Sr_ing_M3_det; RQ_ing_Styrene_det_M3];

RQ_tot_ing_M3 = sum(RQ_ing_M3_det);

% Expsoure assessment - Inhalation
M3_inh_det = [Aluminium_det_M3; Barium_det_M3; Beryllium_det_M3; Boron_det_M3; Cobalt_det_M3; Magnesium_det_M3; Manganese_det_M3; Vanadium_det_M3; Chromium_det_M3; Silicum_det_M3; Styrene_M3];
DinhM3_det = (M3_inh_det* Et* Ed * Ef* InhR)/(PEF*AT*BW);
RfD_inh_M3 = [1.024E-03; 1.024E-04; 4.09E-06; 4.09E-03; 1.228E-06; 2.05E-02; 1.02E-05; 2.05E-05; 2.05E-05; 6.14E-04; 1.84E-01];

RQ_Al_inh_M3_det = DinhM3_det(1)/RfD_inh_M3(1);
RQ_Ba_inh_M3_det = DinhM3_det(2)/RfD_inh_M3(2);
RQ_Be_inh_M3_det = DinhM3_det(3)/RfD_inh_M3(3);
RQ_B_inh_M3_det  = DinhM3_det(4)/RfD_inh_M3(4);
RQ_Co_inh_M3_det = DinhM3_det(5)/RfD_inh_M3(5);
RQ_Mg_inh_M3_det = DinhM3_det(6)/RfD_inh_M3(6);
RQ_Mn_inh_M3_det = DinhM3_det(7)/RfD_inh_M3(7);
RQ_V_inh_M3_det  = DinhM3_det(8)/RfD_inh_M3(8);
RQ_Cr_inh_M3_det = DinhM3_det(9)/RfD_inh_M3(9);
RQ_Si_inh_M3_det = DinhM3_det(10)/RfD_inh_M3(10);
RQ_inh_Styrene_det_M3 = DinhM3_det(11)/RfD_inh_M3(11);

RQ_inh_M3_det = [RQ_Al_inh_M3_det; RQ_Ba_inh_M3_det; RQ_Be_inh_M3_det; RQ_B_inh_M3_det; RQ_Co_inh_M3_det; RQ_Mg_inh_M3_det; RQ_Mn_inh_M3_det; RQ_V_inh_M3_det; RQ_Cr_inh_M3_det; RQ_Si_inh_M3_det; RQ_inh_Styrene_det_M3];
RQ_tot_inh_M3 = sum(RQ_inh_M3_det);

%Dermal exposure
M3_det_derm = [Aluminium_det_M3; Barium_det_M3; Beryllium_det_M3; Boron_det_M3; Cobalt_det_M3; Litium_det_M3; Magnesium_det_M3; Manganese_det_M3; Phosphorus_det_M3; Sodium_det_M3; Vanadium_det_M3; Zinc_det_M3; Chromium_det_M3; Strontium_det_M3; Styrene_M3];

DA_derm_face_det_M3 = ((M3_det_derm/1000).*Adh_face); %mg/cM3-d
DA_derm_hand_det_M3 = ((M3_det_derm/1000).*Adh_hand); %mg/cM3-d

ADD_derm_face_det_M3 = (DA_derm_face_det_M3*SA_head*Ef*Ed)/(AT*BW); % mg/kg-day
ADD_derm_hand_det_M3 = (DA_derm_hand_det_M3*SA_hand*Ef*Ed)/(AT*BW); % mg/kg-day

ADD_derm_M3_det = ADD_derm_face_det_M3 + ADD_derm_hand_det_M3;


RfD_derm_M3 = [1.00E+00; 1.4E-02; 1.4E-05; 2E-01; 3E-04; 2E-03; 1.1E+01; 9.6E-04; 4.9E+01; 1.9E+01; 1.31E-04; 3E-01; 7.5E-05; 6E-01; 2E-01];

RQ_Al_derm_M3_det = ADD_derm_M3_det(1)/RfD_derm_M3(1);
RQ_Ba_derm_M3_det = ADD_derm_M3_det(2)/RfD_derm_M3(2);
RQ_Be_derm_M3_det = ADD_derm_M3_det(3)/RfD_derm_M3(3);
RQ_B_derm_M3_det  = ADD_derm_M3_det(4)/RfD_derm_M3(4);
RQ_Co_derm_M3_det = ADD_derm_M3_det(5)/RfD_derm_M3(5);
RQ_Li_derm_M3_det = ADD_derm_M3_det(6)/RfD_derm_M3(6);
RQ_Mg_derm_M3_det = ADD_derm_M3_det(7)/RfD_derm_M3(7);
RQ_Mn_derm_M3_det = ADD_derm_M3_det(8)/RfD_derm_M3(8);
RQ_P_derm_M3_det  = ADD_derm_M3_det(9)/RfD_derm_M3(9);
RQ_Na_derm_M3_det = ADD_derm_M3_det(10)/RfD_derm_M3(10);
RQ_V_derm_M3_det  = ADD_derm_M3_det(11)/RfD_derm_M3(11);
RQ_Zn_derm_M3_det = ADD_derm_M3_det(12)/RfD_derm_M3(12);
RQ_Cr_derm_M3_det = ADD_derm_M3_det(13)/RfD_derm_M3(13);
RQ_Sr_derm_M3_det = ADD_derm_M3_det(14)/RfD_derm_M3(14);
RQ_styrene_derm_M3_det = ADD_derm_M3_det(15)/RfD_derm_M3(15);

RQ_derm_M3_det =[RQ_Al_derm_M3_det; RQ_Ba_derm_M3_det; RQ_Be_derm_M3_det;RQ_B_derm_M3_det; RQ_Co_derm_M3_det; RQ_Li_derm_M3_det; RQ_Mg_derm_M3_det; RQ_Mn_derm_M3_det; RQ_P_derm_M3_det; RQ_Na_derm_M3_det; RQ_V_derm_M3_det; RQ_Zn_derm_M3_det; RQ_Cr_derm_M3_det; RQ_Sr_derm_M3_det; RQ_styrene_derm_M3_det];

RQ_tot_derm_M3 = sum(RQ_derm_M3_det);

%Total no-cancer risk
RI_Al_Det_M3 = RQ_Al_ing_M3_det + RQ_Al_inh_M3_det + RQ_Al_derm_M3_det;
RI_Ba_Det_M3 = RQ_Ba_ing_M3_det + RQ_Ba_inh_M3_det + RQ_Ba_derm_M3_det;
RI_Be_Det_M3 = RQ_Be_ing_M3_det + RQ_Be_inh_M3_det + RQ_Be_derm_M3_det;
RI_B_Det_M3  = RQ_B_ing_M3_det + RQ_B_inh_M3_det + RQ_B_derm_M3_det;
RI_Co_Det_M3 = RQ_Co_ing_M3_det + RQ_Co_inh_M3_det + RQ_Co_derm_M3_det;
RI_Fe_Det_M3 = RQ_Fe_ing_M3_det;
RI_Li_Det_M3 = RQ_Li_ing_M3_det + RQ_Li_derm_M3_det;
RI_Mg_Det_M3 = RQ_Mg_ing_M3_det + RQ_Mg_inh_M3_det + RQ_Mg_derm_M3_det;
RI_Mn_Det_M3 = RQ_Mn_ing_M3_det + RQ_Mn_inh_M3_det + RQ_Mn_derm_M3_det;
RI_P_Det_M3  = RQ_P_ing_M3_det + RQ_P_derm_M3_det;
RI_Na_Det_M3 = RQ_Na_ing_M3_det + RQ_Na_derm_M3_det;
RI_Ti_Det_M3 = RQ_Ti_ing_M3_det;
RI_V_Det_M3  = RQ_V_ing_M3_det  + RQ_V_inh_M3_det  + RQ_V_derm_M3_det;
RI_Zn_Det_M3 = RQ_Zn_ing_M3_det + RQ_Zn_derm_M3_det;
RI_Cr_Det_M3 = RQ_Cr_ing_M3_det + RQ_Cr_inh_M3_det + RQ_Cr_derm_M3_det;
RI_Pb_Det_M3 = RQ_Pb_ing_M3_det;
RI_Si_Det_M3 = RQ_Si_inh_M3_det;
RI_Sr_Det_M3 = RQ_Sr_ing_M3_det + RQ_Sr_derm_M3_det;
RI_Styrene_det_M3 = RQ_ing_Styrene_det_M3 + RQ_inh_Styrene_det_M3 + RQ_styrene_derm_M3_det;

RI_M3_det = [RI_Al_Det_M3; RI_Ba_Det_M3; RI_Be_Det_M3; RI_B_Det_M3; RI_Co_Det_M3; RI_Fe_Det_M3; RI_Li_Det_M3; RI_Mg_Det_M3; RI_Mn_Det_M3; RI_P_Det_M3; RI_Na_Det_M3; RI_Ti_Det_M3; RI_V_Det_M3; RI_Zn_Det_M3; RI_Cr_Det_M3; RI_Pb_Det_M3;RI_Si_Det_M3; RI_Sr_Det_M3; RI_Styrene_det_M3];

RItot_M3_det = sum(RI_M3_det);

figure
%plot(RI_M1_det);
bar(RI_M3_det);
%ylim([0 2]);
yline(1,'-','Threshold');
set(gca, 'YScale', 'log');
title("RI Material M3 - Determinisic approach");
xlabel("Metals");
ylabel("Risk Index");
xticks([1 2 3 4 5 6 7 8 9 10 11 12 13 14 15 16 17 18 19]);
xticklabels({"Al", "Ba", "Be", "B", "Co", "Fe", "Li", "Mg", "Mn", "P", "Na", "Ti", "V", "Zn", "Cr", "Pb", "Si","Sr", "Styrene"});
xlim([0 20]);

% QCRA M4 Human health risks

%Grass
Aluminium_G_M4_det = 410;
Barium_G_M4_det = 15.6;
Beryllium_G_M4_det = 0.0202;
Boron_G_M4_det = 1.56;
Calcium_G_M4_det = 31492;
Cobalt_G_M4_det = 0.247;
Copper_G_M4_det = 35.7;
Iron_G_M4_det = 1353;
Magnesium_G_M4_det = 305;
Manganese_G_M4_det = 30.9;
Molybdenum_G_M4_det = 0.406;
Phosphorus_G_M4_det = 1531;
Potassium_G_M4_det = 87.6;
Sodium_G_M4_det = 342;
Tin_G_M4_det = 1.67;
Titanium_G_M4_det = 4.29;
Vanadium_G_M4_det = 3.38;
Zinc_G_M4_det = 87.1;
Chromium_G_M4_det = 3.07;
Nickel_G_M4_det = 3.18;
Lead_G_M4_det = 12.9;
Bi_G_M4_det = 1.54;
Sulfur_G_M4_det = 1317;
Silicum_G_M4_det = 342;
Strontium_G_M4_det = 10.6;

%Biofiller
Al_filler_M4_det = 2.78;
Ba_filler_M4_det = 58.65;
Ca_filler_M4_det = 181331;
Mg_filler_M4_det = 1326;
Mn_filler_M4_det = 1.02;
P_filler_M4_det = 14.9;
K_filler_M4_det = 12.5;
Na_filler_M4_det = 443;
S_filler_M4_det = 280;
Sr_filler_M4_det = 615;

%M4 composition

Al_M4_det = 0.12*Aluminium_G_M4_det + 0.27* Al_filler_M4_det;
Ba_M4_det = 0.12*Barium_G_M4_det + 0.27* Ba_filler_M4_det;
Be_M4_det = 0.12* Beryllium_G_M4_det;
B_M4_det  = 0.12* Boron_G_M4_det;
Ca_M4_det = 0.12* Calcium_G_M4_det + 0.27* Ca_filler_M4_det;
Co_M4_det = 0.12* Cobalt_G_M4_det;
Cu_M4_det = 0.12* Copper_G_M4_det;
Fe_M4_det = 0.12* Iron_G_M4_det;
Mg_M4_det = 0.12* Magnesium_G_M4_det + 0.27 * Mg_filler_M4_det;
Mn_M4_det = 0.12* Manganese_G_M4_det + 0.27 * Mn_filler_M4_det;
Mo_M4_det = 0.12* Molybdenum_G_M4_det;
P_M4_det  = 0.12* Phosphorus_G_M4_det + 0.27 * P_filler_M4_det;
K_M4_det  = 0.12* Potassium_G_M4_det + 0.27 * K_filler_M4_det;
Na_M4_det = 0.12* Sodium_G_M4_det + 0.27 * Na_filler_M4_det;
Sn_M4_det = 0.12* Tin_G_M4_det;
Ti_M4_det = 0.12* Titanium_G_M4_det;
V_M4_det  = 0.12* Vanadium_G_M4_det;
Zn_M4_det = 0.12* Zinc_G_M4_det;
Cr_M4_det = 0.12* Chromium_G_M4_det;
Ni_M4_det = 0.12* Nickel_G_M4_det;
Pb_M4_det = 0.12* Lead_G_M4_det;
Bi_M4_det = 0.12* Bi_G_M4_det;
S_M4_det  = 0.12* Sulfur_G_M4_det + 0.27 * S_filler_M4_det;
Si_M4_det = 0.12* Silicum_G_M4_det;
Sr_M4_det = 0.12* Strontium_G_M4_det + 0.27 * Sr_filler_M4_det;
FA_M4_det = (0.01* 0.52*mass_product*1000)/(mass_product/1000);

M4_det = [Al_M4_det; Ba_M4_det; Be_M4_det; B_M4_det; Co_M4_det; Cu_M4_det; Fe_M4_det; Mg_M4_det; Mn_M4_det; Mo_M4_det; P_M4_det; Na_M4_det; Sn_M4_det; Ti_M4_det; V_M4_det; Zn_M4_det; Cr_M4_det; Ni_M4_det; Pb_M4_det; Bi_M4_det;S_M4_det; Si_M4_det; Sr_M4_det; FA_M4_det];


%Exposure Assessment - Ingestion
M4_ing_det = [Al_M4_det; Ba_M4_det; Be_M4_det; B_M4_det; Co_M4_det; Cu_M4_det; Fe_M4_det; Mg_M4_det; Mn_M4_det; Mo_M4_det; P_M4_det; Na_M4_det; Sn_M4_det; Ti_M4_det; V_M4_det; Zn_M4_det; Cr_M4_det; Ni_M4_det; Pb_M4_det; Sr_M4_det; FA_M4_det];
Ding_M4_det = (IngR*(M4_ing_det./1000)*Ef*Ed)/(BW*AT);
RfD_ing_M4 = [1E00; 2E-01; 2E-03; 2E-01; 3E-04; 4E-02; 7E-01; 1.1E+01; 2.4E-02; 5E-03; 4.9E+01; 1.9E+01; 6E-01; 3E00; 5.04E-03; 3E-01; 3E-03; 1.10E-02; 4E-03; 6E-01; 7.57E-04];

RQ_Al_ing_M4_det = Ding_M4_det(1)/RfD_ing_M4(1);
RQ_Ba_ing_M4_det = Ding_M4_det(2)/RfD_ing_M4(2);
RQ_Be_ing_M4_det = Ding_M4_det(3)/RfD_ing_M4(3);
RQ_B_ing_M4_det  = Ding_M4_det(4)/RfD_ing_M4(4);
RQ_Co_ing_M4_det = Ding_M4_det(5)/RfD_ing_M4(5);
RQ_Cu_ing_M4_det = Ding_M4_det(6)/RfD_ing_M4(6);
RQ_Fe_ing_M4_det = Ding_M4_det(7)/RfD_ing_M4(7);
RQ_Mg_ing_M4_det = Ding_M4_det(8)/RfD_ing_M4(8);
RQ_Mn_ing_M4_det = Ding_M4_det(9)/RfD_ing_M4(9);
RQ_Mo_ing_M4_det = Ding_M4_det(10)/RfD_ing_M4(10);
RQ_P_ing_M4_det  = Ding_M4_det(11)/RfD_ing_M4(11);
RQ_Na_ing_M4_det = Ding_M4_det(12)/RfD_ing_M4(12);
RQ_Sn_ing_M4_det = Ding_M4_det(13)/RfD_ing_M4(13);
RQ_Ti_ing_M4_det = Ding_M4_det(14)/RfD_ing_M4(14);
RQ_V_ing_M4_det  = Ding_M4_det(15)/RfD_ing_M4(15);
RQ_Zn_ing_M4_det = Ding_M4_det(16)/RfD_ing_M4(16);
RQ_Cr_ing_M4_det = Ding_M4_det(17)/RfD_ing_M4(17);
RQ_Ni_ing_M4_det = Ding_M4_det(18)/RfD_ing_M4(18);
RQ_Pb_ing_M4_det = Ding_M4_det(19)/RfD_ing_M4(19);
RQ_Sr_ing_M4_det = Ding_M4_det(20)/RfD_ing_M4(20);
RQ_ing_FA_det_M4 = Ding_M4_det(21)/RfD_ing_M4(21);

RQ_ing_M4_det = [RQ_Al_ing_M4_det; RQ_Ba_ing_M4_det; RQ_Be_ing_M4_det; RQ_B_ing_M4_det; RQ_Co_ing_M4_det; RQ_Cu_ing_M4_det; RQ_Fe_ing_M4_det; RQ_Mg_ing_M4_det; RQ_Mn_ing_M4_det; RQ_Mo_ing_M4_det; RQ_P_ing_M4_det; RQ_Na_ing_M4_det; RQ_Sn_ing_M4_det; RQ_Ti_ing_M4_det; RQ_V_ing_M4_det; RQ_Zn_ing_M4_det; RQ_Cr_ing_M4_det; RQ_Ni_ing_M4_det; RQ_Pb_ing_M4_det; RQ_Sr_ing_M4_det; RQ_ing_FA_det_M4];

RQ_tot_ing_M4 = sum(RQ_ing_M4_det);

%Exposure Assessment - Inhalation
M4_inh_det = [Al_M4_det; Ba_M4_det; Be_M4_det; B_M4_det; Co_M4_det; Cu_M4_det; Mg_M4_det; Mn_M4_det; Mo_M4_det; V_M4_det; Cr_M4_det; Ni_M4_det; Si_M4_det; FA_M4_det];
DinhM4_det = (M4_inh_det* Et* Ed * Ef* InhR)/(PEF*AT*BW);
RfD_inh_M4 = [1.024E-03; 1.024E-04; 4.09E-06; 4.09E-03; 1.228E-06; 4.50E-02; 2.05E-02; 1.02E-05; 4.09E-04; 2.05E-05; 2.05E-05; 2.87E-06; 6.14E-04; 1.247E-03];

RQ_Al_inh_M4_det = DinhM4_det(1)/RfD_inh_M4(1);
RQ_Ba_inh_M4_det = DinhM4_det(2)/RfD_inh_M4(2);
RQ_Be_inh_M4_det = DinhM4_det(3)/RfD_inh_M4(3);
RQ_B_inh_M4_det  = DinhM4_det(4)/RfD_inh_M4(4);
RQ_Co_inh_M4_det = DinhM4_det(5)/RfD_inh_M4(5);
RQ_Cu_inh_M4_det = DinhM4_det(6)/RfD_inh_M4(6);
RQ_Mg_inh_M4_det = DinhM4_det(7)/RfD_inh_M4(7);
RQ_Mn_inh_M4_det = DinhM4_det(8)/RfD_inh_M4(8);
RQ_Mo_inh_M4_det = DinhM4_det(9)/RfD_inh_M4(9);
RQ_V_inh_M4_det  = DinhM4_det(10)/RfD_inh_M4(10);
RQ_Cr_inh_M4_det = DinhM4_det(11)/RfD_inh_M4(11);
RQ_Ni_inh_M4_det = DinhM4_det(12)/RfD_inh_M4(12);
RQ_Si_inh_M4_det = DinhM4_det(13)/RfD_inh_M4(13);
RQ_inh_FA_det_M4 = DinhM4_det(14)/RfD_inh_M4(14);

RQ_inh_M4_det = [RQ_Al_inh_M4_det; RQ_Ba_inh_M4_det; RQ_Be_inh_M4_det; RQ_B_inh_M4_det; RQ_Co_inh_M4_det; RQ_Cu_inh_M4_det; RQ_Mg_inh_M4_det; RQ_Mn_inh_M4_det; RQ_Mo_inh_M4_det; RQ_V_inh_M4_det; RQ_Cr_inh_M4_det; RQ_Ni_inh_M4_det; RQ_Si_inh_M4_det; RQ_inh_FA_det_M4];

RQ_tot_inh_M4 = sum(RQ_inh_M4_det);

%Exposure Assessment - Dermal contact

M4_det_derm = [Al_M4_det; Ba_M4_det; Be_M4_det; B_M4_det; Co_M4_det; Cu_M4_det; Mg_M4_det; Mn_M4_det; Mo_M4_det; P_M4_det; Na_M4_det; Sn_M4_det; V_M4_det; Zn_M4_det; Cr_M4_det; Ni_M4_det; Sr_M4_det; FA_M4_det];

DA_derm_face_det_M4 = ((M4_det_derm/1000).*Adh_face); %mg/cM3-d
DA_derm_hand_det_M4 = ((M4_det_derm/1000).*Adh_hand); %mg/cM3-d

ADD_derm_face_det_M4 = (DA_derm_face_det_M4*SA_head*Ef*Ed)/(AT*BW); % mg/kg-day
ADD_derm_hand_det_M4 = (DA_derm_hand_det_M4*SA_hand*Ef*Ed)/(AT*BW); % mg/kg-day

ADD_derm_M4_det = ADD_derm_face_det_M4 + ADD_derm_hand_det_M4;


RfD_derm_M4 = [1.00E+00; 1.4E-02; 1.4E-05; 2E-01; 3E-04; 1.20E-02; 1.1E+01; 9.6E-04; 5E-03; 4.9E+01; 1.9E+01; 6E-01; 1.31E-04; 3E-01; 7.5E-05; 4.40E-04; 6E-01; 7.57E-04];

RQ_Al_derm_M4_det = ADD_derm_M4_det(1)/RfD_derm_M4(1);
RQ_Ba_derm_M4_det = ADD_derm_M4_det(2)/RfD_derm_M4(2);
RQ_Be_derm_M4_det = ADD_derm_M4_det(3)/RfD_derm_M4(3);
RQ_B_derm_M4_det  = ADD_derm_M4_det(4)/RfD_derm_M4(4);
RQ_Co_derm_M4_det = ADD_derm_M4_det(5)/RfD_derm_M4(5);
RQ_Cu_derm_M4_det = ADD_derm_M4_det(6)/RfD_derm_M4(6);
RQ_Mg_derm_M4_det = ADD_derm_M4_det(7)/RfD_derm_M4(7);
RQ_Mn_derm_M4_det = ADD_derm_M4_det(8)/RfD_derm_M4(8);
RQ_Mo_derm_M4_det = ADD_derm_M4_det(9)/RfD_derm_M4(9);
RQ_P_derm_M4_det  = ADD_derm_M4_det(10)/RfD_derm_M4(10);
RQ_Na_derm_M4_det = ADD_derm_M4_det(11)/RfD_derm_M4(11);
RQ_Sn_derm_M4_det = ADD_derm_M4_det(12)/RfD_derm_M4(12);
RQ_V_derm_M4_det  = ADD_derm_M4_det(13)/RfD_derm_M4(13);
RQ_Zn_derm_M4_det = ADD_derm_M4_det(14)/RfD_derm_M4(14);
RQ_Cr_derm_M4_det = ADD_derm_M4_det(15)/RfD_derm_M4(15);
RQ_Ni_derm_M4_det = ADD_derm_M4_det(16)/RfD_derm_M4(16);
RQ_Sr_derm_M4_det = ADD_derm_M4_det(17)/RfD_derm_M4(17);
RQ_FA_derm_M4_det = ADD_derm_M4_det(18)/RfD_derm_M4(18);

RQ_derm_M4_det =[RQ_Al_derm_M4_det; RQ_Ba_derm_M4_det; RQ_Be_derm_M4_det;RQ_B_derm_M4_det; RQ_Co_derm_M4_det; RQ_Cu_derm_M4_det; RQ_Mg_derm_M4_det; RQ_Mn_derm_M4_det; RQ_Mo_derm_M4_det; RQ_P_derm_M4_det; RQ_Na_derm_M4_det; RQ_Sn_derm_M4_det; RQ_V_derm_M4_det; RQ_Zn_derm_M4_det; RQ_Cr_derm_M4_det; RQ_Ni_derm_M4_det; RQ_Sr_derm_M4_det; RQ_FA_derm_M4_det];

RQ_tot_derm_M4 = sum(RQ_derm_M4_det);


%Risk characterization
RI_Al_Det_M4 = RQ_Al_ing_M4_det + RQ_Al_inh_M4_det + RQ_Al_derm_M4_det;
RI_Ba_Det_M4 = RQ_Ba_ing_M4_det + RQ_Ba_inh_M4_det + RQ_Ba_derm_M4_det;
RI_Be_Det_M4 = RQ_Be_ing_M4_det + RQ_Be_inh_M4_det + RQ_Be_derm_M4_det;
RI_B_Det_M4  = RQ_B_ing_M4_det + RQ_B_inh_M4_det + RQ_B_derm_M4_det;
RI_Co_Det_M4 = RQ_Co_ing_M4_det + RQ_Co_inh_M4_det + RQ_Co_derm_M4_det;
RI_Cu_Det_M4 = RQ_Cu_ing_M4_det + RQ_Cu_inh_M4_det + RQ_Cu_derm_M4_det;
RI_Fe_Det_M4 = RQ_Fe_ing_M4_det;
RI_Mg_Det_M4 = RQ_Mg_ing_M4_det + RQ_Mg_inh_M4_det + RQ_Mg_derm_M4_det;
RI_Mn_Det_M4 = RQ_Mn_ing_M4_det + RQ_Mn_inh_M4_det + RQ_Mn_derm_M4_det;
RI_Mo_Det_M4 = RQ_Mo_ing_M4_det + RQ_Mo_inh_M4_det + RQ_Mo_derm_M4_det;
RI_P_Det_M4  = RQ_P_ing_M4_det + RQ_P_derm_M4_det;
RI_Na_Det_M4 = RQ_Na_ing_M4_det + RQ_Na_derm_M4_det;
RI_Sn_Det_M4 = RQ_Sn_ing_M4_det + RQ_Sn_derm_M4_det;
RI_Ti_Det_M4 = RQ_Ti_ing_M4_det;
RI_V_Det_M4  = RQ_V_ing_M4_det  + RQ_V_inh_M4_det  + RQ_V_derm_M4_det;
RI_Zn_Det_M4 = RQ_Zn_ing_M4_det + RQ_Zn_derm_M4_det;
RI_Cr_Det_M4 = RQ_Cr_ing_M4_det + RQ_Cr_inh_M4_det + RQ_Cr_derm_M4_det;
RI_Ni_Det_M4 = RQ_Ni_ing_M4_det + RQ_Ni_inh_M4_det + RQ_Ni_derm_M4_det;
RI_Pb_Det_M4 = RQ_Pb_ing_M4_det;
RI_Si_Det_M4 = RQ_Si_inh_M4_det;
RI_Sr_Det_M4 = RQ_Sr_ing_M4_det + RQ_Sr_derm_M4_det;
RI_FA_det_M4 = RQ_ing_FA_det_M4 + RQ_inh_FA_det_M4 + RQ_FA_derm_M4_det;

RI_M4_det = [RI_Al_Det_M4; RI_Ba_Det_M4; RI_Be_Det_M4; RI_B_Det_M4; RI_Co_Det_M4; RI_Cu_Det_M4; RI_Fe_Det_M4; RI_Mg_Det_M4; RI_Mn_Det_M4; RI_Mo_Det_M4; RI_P_Det_M4; RI_Na_Det_M4; RI_Sn_Det_M4; RI_Ti_Det_M4; RI_V_Det_M4; RI_Zn_Det_M4; RI_Cr_Det_M4; RI_Ni_Det_M4; RI_Pb_Det_M4;RI_Si_Det_M4; RI_Sr_Det_M4; RI_FA_det_M4];

RItot_M4_det = sum(RI_M4_det);

figure
%plot(RI_M1_det);
bar(RI_M4_det);
%ylim([0 2]);
yline(1,'-','Threshold');
set(gca, 'YScale', 'log');
title("RI Material M4 - Determinisic approach");
xlabel("Metals");
ylabel("Risk Index");
xticks([1 2 3 4 5 6 7 8 9 10 11 12 13 14 15 16 17 18 19 20 21 22]);
xticklabels({"Al", "Ba", "Be", "B", "Co", "Cu", "Fe", "Mg", "Mn", "Mo", "P", "Na", "Sn", "Ti", "V", "Zn", "Cr", "Ni", "Pb", "Si", "Sr", "FA"});
xlim([0 23]);

