%Sensitivity s0
n=10000;

for i=1:n
    %Grass
    Si_G_M4_s0 = (342-0)*rand(n,1)+0;
    Al_G_M4_s0 = (410-0)*rand(n,1)+ 0;
    Fe_G_M4_s0 = (1353 - 0)*rand(n,1)+0;
    Ca_G_M4_s0 = (3149-0)*rand(n,1)+ 0;
    Mg_G_M4_s0 = (305-0)*rand(n,1)+0;
    Na_G_M4_s0 = (342-0)*rand(n,1)+0;
    Ti_G_M4_s0 = (4.29-0)*rand(n,1)+0;
    P_G_M4_s0  = (1531-0)*rand(n,1)+0;
    K_G_M4_s0  = (87.6-0)*rand(n,1)+0;
    Be_G_M4_s0 = (0.0202 -0)*rand(n,1)+0;
    Cr_G_M4_s0 = (3.07-0)*rand(n,1)+0;
    Co_G_M4_s0 = (0.247-0)*rand(n,1)+0;
    Cu_G_M4_s0 = (35.7-0)*rand(n,1)+0;
    Pb_G_M4_s0 = (12.9-0)*rand(n,1)+0;
    Mn_G_M4_s0 = (30.9-0)*rand(n,1)+0;
    Mo_G_M4_s0 = (0.406-0)*rand(n,1)+0;
    Ni_G_M4_s0 = (3.18 - 0)*rand(n,1)+0;
    V_G_M4_s0 = (3.38-0)*rand(n,1)+0;
    Zn_G_M4_s0 = (87.1-0)*rand(n,1)+0;
    Ba_G_M4_s0 = (15.6-0)*rand(n,1)+0;
    B_G_M4_s0 = (1.56-0)*rand(n,1)+0;
    Sn_G_M4_s0 = (1.67-0)*rand(n,1)+0;
    Bi_G_M4_s0 = (1.54-0)*rand(n,1)+0;
    S_G_M4_s0  = (1.317E+03-0)*rand(n,1)+0;
    Sr_G_M4_s0 = (10.6-0)*rand(n,1)+0;
    
    %biofiller
    
    Al_Ol_M4_s0 = (2.78-0)*rand(n,1)+0;
    Ca_Ol_M4_s0 = (181331-0)*rand(n,1)+0;
    Mg_Ol_M4_s0 = (1326 -0)*rand(n,1)+0;
    Na_Ol_M4_s0 = (443-0)*rand(n,1)+0;
    P_Ol_M4_s0  = (14.9-0)*rand(n,1)+0;
    K_Ol_M4_s0 = (12.5-0)*rand(n,1)+0;
    Mn_Ol_M4_s0 = (1.02-0)*rand(n,1)+0;
    Ba_Ol_M4_s0 = (58.65-0)*rand(n,1)+0;
    Sr_Ol_M4_s0 = (615-0)*rand(n,1)+0;
    
    %Composition M4
    Silicum_M4_s0 = 0.12*Si_G_M4_s0; 
    Aluminium_M4_s0 = 0.12*Al_G_M4_s0 + 0.27* Al_Ol_M4_s0;
    Iron_M4_s0 = 0.12*Fe_G_M4_s0;
    Calcium_M4_s0 = 0.12*Ca_G_M4_s0 + 0.27 * Ca_Ol_M4_s0;
    Magnesium_M4_s0 = 0.12*Mg_G_M4_s0 + 0.27* Mg_Ol_M4_s0;
    Sodium_M4_s0 = 0.12*Na_G_M4_s0 + 0.27* Na_Ol_M4_s0;
    Titanium_M4_s0 = 0.12*Ti_G_M4_s0;
    Phosphorus_M4_s0 = 0.12*P_G_M4_s0 + 0.27* P_Ol_M4_s0;
    Potassium_M4_s0 = 0.12*K_G_M4_s0 + 0.27* K_Ol_M4_s0;
    Beryllium_M4_s0 = 0.12*Be_G_M4_s0;
    Chromium_M4_s0 = 0.12*Cr_G_M4_s0;
    Cobalt_M4_s0 = 0.12* Co_G_M4_s0;
    Copper_M4_s0 = 0.12* Cu_G_M4_s0;
    Lead_M4_s0 = 0.12 * Pb_G_M4_s0;
    Manganese_M4_s0 = 0.12 * Mn_G_M4_s0 + 0.27 * Mn_Ol_M4_s0;
    Molybdenum_M4_s0 = 0.12 * Mo_G_M4_s0;
    Nickel_M4_s0 = 0.12 * Ni_G_M4_s0;
    Vanadium_M4_s0 = 0.12 * V_G_M4_s0;
    Zinc_M4_s0 = 0.12 * Zn_G_M4_s0;
    Barium_M4_s0 = 0.12*Ba_G_M4_s0 + 0.27*Ba_Ol_M4_s0;
    Boron_M4_s0 = 0.12*B_G_M4_s0;
    Tin_M4_s0 = 0.12*Sn_G_M4_s0;
    Bismuto_M4_s0 = 0.12* Bi_G_M4_s0;
    Sulfur_M4_s0 = 0.12*S_G_M4_s0;
    Strontium_M4_s0 = 0.12*Sr_G_M4_s0 + 0.27*Sr_Ol_M4_s0;
    
    NM4_s0 = [Silicum_M4_s0 Aluminium_M4_s0 Iron_M4_s0 Calcium_M4_s0 Magnesium_M4_s0 Sodium_M4_s0 Titanium_M4_s0 Phosphorus_M4_s0 Potassium_M4_s0 Beryllium_M4_s0 Chromium_M4_s0 Cobalt_M4_s0 Copper_M4_s0 Lead_M4_s0 Manganese_M4_s0 Molybdenum_M4_s0 Nickel_M4_s0 Vanadium_M4_s0 Zinc_M4_s0 Barium_M4_s0 Boron_M4_s0 Tin_M4_s0 Sulfur_M4_s0 Strontium_M4_s0];
    Furfuryl_Alchol_s0 = (5.20E+03-0)*rand(n,1)+0;
    
    %Ingestion exposure
    NM4_s0_ing = [Aluminium_M4_s0 Barium_M4_s0 Beryllium_M4_s0 Boron_M4_s0 Cobalt_M4_s0 Copper_M4_s0 Iron_M4_s0 Magnesium_M4_s0 Manganese_M4_s0 Molybdenum_M4_s0 Phosphorus_M4_s0 Sodium_M4_s0 Tin_M4_s0 Titanium_M4_s0 Vanadium_M4_s0 Zinc_M4_s0 Chromium_M4_s0 Nickel_M4_s0 Lead_M4_s0 Strontium_M4_s0 Furfuryl_Alchol_s0];
    
    DingNM4_s0 = ((NM4_s0_ing./1000).*IngR.*Ef.*Ed)./(BW.*AT);
    RfD_ing_NM4 = [1E00; 2E-01; 2E-03; 2E-01; 3E-04; 4E-02; 7E-01; 1.1E+01; 2.4E-02; 5E-03; 4.9E+01; 1.9E+01; 6E-01; 3E00; 5.04E-03; 3E-01; 3E-03; 1.10E-02; 4E-03; 6E-01; 7.57E-04];

    
    %Risk Quotient - Ingestion (Reed)
    RQ_Al_ing_M4_s0 = DingNM4_s0(:,1)./RfD_ing_NM4(1);
    RQ_Fe_ing_M4_s0 = DingNM4_s0(:,2)./RfD_ing_NM4(2);
    RQ_Mg_ing_M4_s0 = DingNM4_s0(:,3)./RfD_ing_NM4(3);
    RQ_Na_ing_M4_s0 = DingNM4_s0(:,4)./RfD_ing_NM4(4);
    RQ_Ti_ing_M4_s0 = DingNM4_s0(:,5)./RfD_ing_NM4(5);
    RQ_P_ing_M4_s0  = DingNM4_s0(:,6)./RfD_ing_NM4(6);
    RQ_Be_ing_M4_s0 = DingNM4_s0(:,7)./RfD_ing_NM4(7);
    RQ_Cr_ing_M4_s0 = DingNM4_s0(:,8)./RfD_ing_NM4(8);
    RQ_Co_ing_M4_s0 = DingNM4_s0(:,9)./RfD_ing_NM4(9);
    RQ_Cu_ing_M4_s0 = DingNM4_s0(:,10)./RfD_ing_NM4(10);
    RQ_Pb_ing_M4_s0 = DingNM4_s0(:,11)./RfD_ing_NM4(11);
    RQ_Mn_ing_M4_s0 = DingNM4_s0(:,12)./RfD_ing_NM4(12);
    RQ_Mo_ing_M4_s0 = DingNM4_s0(:,13)./RfD_ing_NM4(13);
    RQ_Ni_ing_M4_s0 = DingNM4_s0(:,14)./RfD_ing_NM4(14);
    RQ_V_ing_M4_s0  = DingNM4_s0(:,15)./RfD_ing_NM4(15);
    RQ_Zn_ing_M4_s0 = DingNM4_s0(:,16)./RfD_ing_NM4(16);
    RQ_Ba_ing_M4_s0 = DingNM4_s0(:,17)./RfD_ing_NM4(17);
    RQ_B_ing_M4_s0  = DingNM4_s0(:,18)./RfD_ing_NM4(18);
    RQ_Sn_ing_M4_s0 = DingNM4_s0(:,19)./RfD_ing_NM4(19);
    RQ_Sr_ing_M4_s0 = DingNM4_s0(:,20)./RfD_ing_NM4(20);
    RQ_FA_ing_M4_s0 = DingNM4_s0(:,21)./RfD_ing_NM4(21);
    
    
    RQ_ing_M4_s0 = [RQ_Al_ing_M4_s0 RQ_Fe_ing_M4_s0 RQ_Mg_ing_M4_s0 RQ_Na_ing_M4_s0 RQ_Ti_ing_M4_s0 RQ_P_ing_M4_s0 RQ_Be_ing_M4_s0 RQ_Cr_ing_M4_s0 RQ_Co_ing_M4_s0 RQ_Cu_ing_M4_s0 RQ_Pb_ing_M4_s0 RQ_Mn_ing_M4_s0 RQ_Mo_ing_M4_s0 RQ_Ni_ing_M4_s0 RQ_V_ing_M4_s0 RQ_Zn_ing_M4_s0 RQ_Ba_ing_M4_s0 RQ_B_ing_M4_s0 RQ_Sn_ing_M4_s0 RQ_Sr_ing_M4_s0 RQ_FA_ing_M4_s0];
    
    RQ_tot_ing_M4_s0 = sum(RQ_ing_M4_s0);
    %Exposure assessment: inhalation
   
   
    M4_inh_s0 = [Aluminium_M4_s0 Barium_M4_s0 Beryllium_M4_s0 Boron_M4_s0 Cobalt_M4_s0 Copper_M4_s0 Magnesium_M4_s0 Manganese_M4_s0 Molybdenum_M4_s0 Vanadium_M4_s0 Chromium_M4_s0 Nickel_M4_s0 Silicum_M4_s0 Furfuryl_Alchol_s0];
    DinhNM4_M4_s0 = (M4_inh_s0.*Et.*Ed.*Ef.*InhR)./(PEF.*AT.*BW);
    RfD_inh_NM4 = [1.024E-03; 1.024E-04; 4.09E-06; 4.09E-03; 1.228E-06; 4.50E-02; 2.05E-02; 1.02E-05; 4.09E-04; 2.05E-05; 2.05E-05; 2.87E-06; 6.14E-04; 1.247E-03];

    
    %%Risk Quotient - Inhalation 
    RQ_Si_inh_M4_s0 = DinhNM4_M4_s0(:,1)./RfD_inh_NM4(1);
    RQ_Al_inh_M4_s0 = DinhNM4_M4_s0(:,2)./RfD_inh_NM4(2);
    RQ_Mg_inh_M4_s0 = DinhNM4_M4_s0(:,3)./RfD_inh_NM4(3);
    RQ_Be_inh_M4_s0 = DinhNM4_M4_s0(:,4)./RfD_inh_NM4(4);
    RQ_Cr_inh_M4_s0 = DinhNM4_M4_s0(:,5)./RfD_inh_NM4(5);
    RQ_Co_inh_M4_s0 = DinhNM4_M4_s0(:,6)./RfD_inh_NM4(6);
    RQ_Cu_inh_M4_s0 = DinhNM4_M4_s0(:,7)./RfD_inh_NM4(7);
    RQ_Mn_inh_M4_s0 = DinhNM4_M4_s0(:,8)./RfD_inh_NM4(8);
    RQ_Mo_inh_M4_s0 = DinhNM4_M4_s0(:,9)./RfD_inh_NM4(9);
    RQ_Ni_inh_M4_s0 = DinhNM4_M4_s0(:,10)./RfD_inh_NM4(10);
    RQ_V_inh_M4_s0  = DinhNM4_M4_s0(:,11)./RfD_inh_NM4(11);
    RQ_Ba_inh_M4_s0 = DinhNM4_M4_s0(:,12)./RfD_inh_NM4(12);
    RQ_B_inh_M4_s0 = DinhNM4_M4_s0(:,13)./RfD_inh_NM4(13);
    RQ_inh_FA_M4_s0 = DinhNM4_M4_s0(:,14)./RfD_inh_NM4(14);
    
    
    %RQ_inh_M4 = [RQ_Si_inh_M4_s0 RQ_Al_inh_M4_s0 RQ_Fe_inh_M4_s0 RQ_Ca_inh_M4_s0 RQ_Mg_inh_M4_s0 RQ_Na_inh_M4_s0 RQ_Ti_inh_M4_s0 RQ_P_inh_M4_s0 RQ_K_inh_M4_s0 RQ_Sb_inh_M4_s0 RQ_As_inh_M4_s0 RQ_Be_inh_M4_s0 RQ_Cd_inh_M4_s0 RQ_Cr_inh_M4_s0 RQ_Co_inh_M4_s0 RQ_Cu_inh_M4_s0 RQ_Pb_inh_M4_s0 RQ_Mn_inh_M4_s0 RQ_Hg_inh_M4_s0 RQ_Mo_inh_M4_s0 RQ_Ni_inh_M4_s0 RQ_V_inh_M4_s0 RQ_Zn_inh_M4_s0 RQ_Ba_inh_M4_s0 RQ_B_inh_M4_s0 RQ_Li_inh_M4_s0 RQ_Ag_inh_M4_s0 RQ_Tl_inh_M4_s0 RQ_Sn_inh_M4_s0 RQ_Se_inh_M4_s0 RQ_Bi_inh_M4_s0 RQ_S_inh_M4_s0 RQ_Sr_inh_M4_s0 RQ_Te_inh_M4_s0 RQ_Zr_inh_M4_s0];
    %RQ_tot_inh_M4 = sum(RQ_inh_M4);
    
    %Dermal exposure
       
    M4_s0_derm = [Aluminium_M4_s0 Barium_M4_s0 Beryllium_M4_s0 Boron_M4_s0 Cobalt_M4_s0 Copper_M4_s0 Magnesium_M4_s0 Manganese_M4_s0 Molybdenum_M4_s0 Phosphorus_M4_s0 Sodium_M4_s0 Tin_M4_s0 Vanadium_M4_s0 Zinc_M4_s0 Chromium_M4_s0 Nickel_M4_s0 Strontium_M4_s0 Furfuryl_Alchol_s0];

    DA_derm_face_M4_s0 = ((M4_s0_derm./1000).*Adh_face); %g/cm2-ev
    DA_derm_hand_M4_s0 = ((M4_s0_derm./1000).*Adh_hand); %g/cm2-ev
    
    ADD_derm_face_M4_s0 = (DA_derm_face_M4_s0.*SA_head.*Ef.*Ed)./(AT.*BW); % mg/kg-day
    ADD_derm_hand_M4_s0 = (DA_derm_hand_M4_s0.*SA_hand.*Ef.*Ed)./(AT.*BW); % mg/kg-day
    
    ADD_derm_M4_s0 = ADD_derm_hand_M4_s0 + ADD_derm_face_M4_s0;
    
    
    RfD_derm_M4 = [1.00E+00; 1.4E-02; 1.4E-05; 2E-01; 3E-04; 1.20E-02; 1.1E+01; 9.6E-04; 5E-03; 4.9E+01; 1.9E+01; 6E-01; 1.31E-04; 3E-01; 7.5E-05; 4.40E-04; 6E-01; 7.57E-04];

    RQ_Al_derm_M4_s0 = ADD_derm_M4_s0(:,1)/RfD_derm_M4(1);
    RQ_Ba_derm_M4_s0 = ADD_derm_M4_s0(:,2)/RfD_derm_M4(2);
    RQ_Be_derm_M4_s0 = ADD_derm_M4_s0(:,3)/RfD_derm_M4(3);
    RQ_B_derm_M4_s0  = ADD_derm_M4_s0(:,4)/RfD_derm_M4(4);
    RQ_Co_derm_M4_s0 = ADD_derm_M4_s0(:,5)/RfD_derm_M4(5);
    RQ_Cu_derm_M4_s0 = ADD_derm_M4_s0(:,6)/RfD_derm_M4(6);
    RQ_Mg_derm_M4_s0 = ADD_derm_M4_s0(:,7)/RfD_derm_M4(7);
    RQ_Mn_derm_M4_s0 = ADD_derm_M4_s0(:,8)/RfD_derm_M4(8);
    RQ_Mo_derm_M4_s0 = ADD_derm_M4_s0(:,9)/RfD_derm_M4(9);
    RQ_P_derm_M4_s0  = ADD_derm_M4_s0(:,10)/RfD_derm_M4(10);
    RQ_Na_derm_M4_s0 = ADD_derm_M4_s0(:,11)/RfD_derm_M4(11);
    RQ_Sn_derm_M4_s0 = ADD_derm_M4_s0(:,12)/RfD_derm_M4(12);
    RQ_V_derm_M4_s0  = ADD_derm_M4_s0(:,13)/RfD_derm_M4(13);
    RQ_Zn_derm_M4_s0 = ADD_derm_M4_s0(:,14)/RfD_derm_M4(14);
    RQ_Cr_derm_M4_s0 = ADD_derm_M4_s0(:,15)/RfD_derm_M4(15);
    RQ_Ni_derm_M4_s0 = ADD_derm_M4_s0(:,16)/RfD_derm_M4(16);
    RQ_Sr_derm_M4_s0 = ADD_derm_M4_s0(:,17)/RfD_derm_M4(17);
    RQ_FA_derm_M4_s0 = ADD_derm_M4_s0(:,18)/RfD_derm_M4(18);

    
    %Risk Characterization
    
    RI_Si_M4_s0 = RQ_Si_inh_M4_s0;
    RI_Al_M4_s0 = RQ_Al_ing_M4_s0 + RQ_Al_inh_M4_s0 + RQ_Al_derm_M4_s0;
    RI_Fe_M4_s0 = RQ_Fe_ing_M4_s0;
    RI_Mg_M4_s0 = RQ_Mg_ing_M4_s0 + RQ_Mg_inh_M4_s0 + RQ_Mg_derm_M4_s0;
    RI_Na_M4_s0 = RQ_Na_ing_M4_s0 + RQ_Na_derm_M4_s0;
    RI_Ti_M4_s0 = RQ_Ti_ing_M4_s0;
    RI_P_M4_s0  = RQ_P_ing_M4_s0  + RQ_P_derm_M4_s0;
    RI_Be_M4_s0 = RQ_Be_ing_M4_s0 + RQ_Be_inh_M4_s0 + RQ_Be_derm_M4_s0;
    RI_Cr_M4_s0 = RQ_Cr_ing_M4_s0 + RQ_Cr_inh_M4_s0 + RQ_Cr_derm_M4_s0;
    RI_Co_M4_s0 = RQ_Co_ing_M4_s0 + RQ_Co_inh_M4_s0 + RQ_Co_derm_M4_s0;
    RI_Cu_M4_s0 = RQ_Cu_ing_M4_s0 + RQ_Cu_inh_M4_s0 + RQ_Cu_derm_M4_s0;
    RI_Pb_M4_s0 = RQ_Pb_ing_M4_s0;
    RI_Mn_M4_s0 = RQ_Mn_ing_M4_s0 + RQ_Mn_inh_M4_s0 + RQ_Mn_derm_M4_s0;
    RI_Mo_M4_s0 = RQ_Mo_ing_M4_s0 + RQ_Mo_inh_M4_s0 + RQ_Mo_derm_M4_s0;
    RI_Ni_M4_s0 = RQ_Ni_ing_M4_s0 + RQ_Ni_inh_M4_s0 + RQ_Ni_derm_M4_s0;
    RI_V_M4_s0  = RQ_V_ing_M4_s0  + RQ_V_inh_M4_s0  + RQ_V_derm_M4_s0;
    RI_Zn_M4_s0 = RQ_Zn_ing_M4_s0 + RQ_Zn_derm_M4_s0;
    RI_Ba_M4_s0 = RQ_Ba_ing_M4_s0 + RQ_Ba_inh_M4_s0 + RQ_Ba_derm_M4_s0;
    RI_B_M4_s0 = RQ_B_ing_M4_s0 + RQ_B_inh_M4_s0 + RQ_B_derm_M4_s0;
    RI_Sn_M4_s0 = RQ_Sn_ing_M4_s0 + RQ_Sn_derm_M4_s0;
    RI_Sr_M4_s0 = RQ_Sr_ing_M4_s0 + RQ_Sr_derm_M4_s0;
    RI_FA_M4_s0 = RQ_FA_ing_M4_s0 + RQ_inh_FA_M4_s0 + RQ_FA_derm_M4_s0;
    
    RI_NM4_s0 = [RI_Si_M4_s0 RI_Al_M4_s0 RI_Fe_M4_s0 RI_Mg_M4_s0 RI_Na_M4_s0 RI_Ti_M4_s0 RI_P_M4_s0 RI_Be_M4_s0 RI_Cr_M4_s0 RI_Co_M4_s0 RI_Cu_M4_s0 RI_Pb_M4_s0 RI_Mn_M4_s0 RI_Mo_M4_s0 RI_Ni_M4_s0 RI_V_M4_s0 RI_Zn_M4_s0 RI_Ba_M4_s0 RI_B_M4_s0 RI_Sn_M4_s0 RI_Sr_M4_s0 RI_FA_M4_s0];
    
    RItot_NM4_s0 = sum(RI_NM4_s0.');
end 
% %plot
% x=1:10000;
% boxplot(RI_NM4_s0);
% set(gca, 'YScale', 'log')
% ylim([0 2]);
% yline(1,'-','Threshold');
% title("RI Material 4 - Sesntivity 0 approach");
% xlabel("Chemicals");
% ylabel("Risk Index");
% xticks([1 2 3 4 5 6 7 8 9 10 11 12 13 14 15 16 17 18 19 20 21 22]);
% xticklabels({'Si','Al','Fe','Mg','Na','Ti','P','Be','Cr','Co','Cu','Pb','Mn','Mo','Ni','V','Zn','Ba' ,'B','Sn', 'Sr','Furfuryl Alchol'});
% xlim([0 23]);

% boxplot(RItot_NM4_s0);
% set(gca, 'YScale', 'log')
% ylim([0 2]);
% yline(1,'-','Threshold');
% title("RI Material 4 - Sesntivity 0 approach");
% xlabel("Material");
% ylabel("Risk Index");
% xticks(1);
% xticklabels({'Material 4'});
% xlim([0 2]);

%Sensitivity 1
n=10000;
for i =1:n
    v1 = 1.2;
    M4 = 30; %mg/day
    mu1 = log((M4.^2)./sqrt(v1+(M4.^2)));
    sigma1 = sqrt(log(v1./(M4.^2)+1));
    IngR_s1 = lognrnd(mu1,sigma1,n,1);
    %IngR_s1 = randn(n,1)*0.0012+IngR;
    %InhR_s1 = randn(n,1)*0.0051+InhR;

    v = 0.753;
    m = 1.55E+01;
    mu = log((m^2)/sqrt(v+m^2));
    sigma = sqrt(log(v/(m^2)+1));
    InhR_s1 = lognrnd(mu,sigma,n,1);

    %Adh_face_s1 = randn(n,1)*1.4500e-06+Adh_face;
    v_face = 24200;
    mu_face = log((SA_head^2)/sqrt(v_face+SA_head^2));
    sigma_face = sqrt(log(v_face/(SA_head^2)+1));
    SA_head_s1 = lognrnd(mu_face, sigma_face,n,1);

    v_hands = 16200;
    mu_hands = log((SA_hand^2)/sqrt(v_hands+SA_hand^2));
    sigma_hand = sqrt(log(v_hands/(SA_hand^2)+1));
    SA_hand_s1 = lognrnd(mu_hands, sigma_hand, n,1);

    %Adh_hand_s1 = randn(n,1)*9.6000e-06+Adh_hand;

    DingM4_s1 = ((IngR_s1./1000).* M4_ing_det'./1000*Ef*Ed)./(BW*AT);
    RfD_ing_M4 = [1E00; 2E-01; 2E-03; 2E-01; 3E-04; 7E-01; 2E-03; 1.1E+01; 2.4E-02; 4.9E+01; 1.9E+01; 3E00; 5.04E-03; 3E-01; 3E-03; 4E-03; 6E-01; 2E-01];

%Ding_Styrene_s1 = (IngR_s1.*(Styrene_M4/1000)*Ef*Ed)/(BW*AT);

%Risk Quotient - Ingestion 
RQ_Al_ing_M4_s1 = DingM4_s1(:,1)/RfD_ing_M4(1);
RQ_Ba_ing_M4_s1 = DingM4_s1(:,2)/RfD_ing_M4(2);
RQ_Be_ing_M4_s1 = DingM4_s1(:,3)/RfD_ing_M4(3);
RQ_B_ing_M4_s1  = DingM4_s1(:,4)/RfD_ing_M4(4);
RQ_Co_ing_M4_s1 = DingM4_s1(:,5)/RfD_ing_M4(5);
RQ_Fe_ing_M4_s1 = DingM4_s1(:,6)/RfD_ing_M4(6);
RQ_Li_ing_M4_s1 = DingM4_s1(:,7)/RfD_ing_M4(7);
RQ_Mg_ing_M4_s1 = DingM4_s1(:,8)/RfD_ing_M4(8);
RQ_Mn_ing_M4_s1 = DingM4_s1(:,9)/RfD_ing_M4(9);
RQ_P_ing_M4_s1  = DingM4_s1(:,10)/RfD_ing_M4(10);
RQ_Na_ing_M4_s1 = DingM4_s1(:,11)/RfD_ing_M4(11);
RQ_Ti_ing_M4_s1 = DingM4_s1(:,12)/RfD_ing_M4(12);
RQ_V_ing_M4_s1  = DingM4_s1(:,13)/RfD_ing_M4(13);
RQ_Zn_ing_M4_s1 = DingM4_s1(:,14)/RfD_ing_M4(14);
RQ_Cr_ing_M4_s1 = DingM4_s1(:,15)/RfD_ing_M4(15);
RQ_Pb_ing_M4_s1 = DingM4_s1(:,16)/RfD_ing_M4(16);
RQ_Sr_ing_M4_s1 = DingM4_s1(:,17)/RfD_ing_M4(17);
RQ_ing_Styrene_s1_M4 = DingM4_s1(:,18)/RfD_ing_M4(18);


%RQ_ing_M4_s1 = [RQ_Al_ing_M4_s1 RQ_Fe_ing_M4_s1 RQ_Mg_ing_M4_s1 RQ_Na_ing_M4_s1 RQ_Ti_ing_M4_s1 RQ_P_ing_M4_s1 RQ_Be_ing_M4_s1 RQ_Cr_ing_M4_s1 RQ_Co_ing_M4_s1 RQ_Pb_ing_M4_s1 RQ_Mn_ing_M4_s1 RQ_V_ing_M4_s1 RQ_Zn_ing_M4_s1 RQ_Ba_ing_M4_s1 RQ_B_ing_M4_s1 RQ_Li_ing_M4_s1 RQ_Sr_ing_M4_s1 RQ_ing_Styrene_s1];

%RQ_tot_ing_M4_s1 = sum(RQ_ing_M4_s1);
%Exposure assessment: inhalation

    DinhM4_s1 = (M4_inh_det'.* Et.* Ed.* Ef.*(InhR_s1./24))./(PEF.*AT.*BW);
    RfD_inh_M4 = [1.02E-03; 1.02E-04; 4.09E-06; 4.09E-03; 1.23E-06; 2.05E-02; 1.02E-05; 2.05E-05; 2.05E-05; 6.14E-04; 1.84E-01];

    
%Risk Quotient - Inhalation 
RQ_Al_inh_M4_s1 = DinhM4_s1(:,1)/RfD_inh_M4(1);
RQ_Ba_inh_M4_s1 = DinhM4_s1(:,2)/RfD_inh_M4(2);
RQ_Be_inh_M4_s1 = DinhM4_s1(:,3)/RfD_inh_M4(3);
RQ_B_inh_M4_s1  = DinhM4_s1(:,4)/RfD_inh_M4(4);
RQ_Co_inh_M4_s1 = DinhM4_s1(:,5)/RfD_inh_M4(5);
RQ_Mg_inh_M4_s1 = DinhM4_s1(:,6)/RfD_inh_M4(6);
RQ_Mn_inh_M4_s1 = DinhM4_s1(:,7)/RfD_inh_M4(7);
RQ_V_inh_M4_s1  = DinhM4_s1(:,8)/RfD_inh_M4(8);
RQ_Cr_inh_M4_s1 = DinhM4_s1(:,9)/RfD_inh_M4(9);
RQ_Si_inh_M4_s1 = DinhM4_s1(:,10)/RfD_inh_M4(10);
RQ_inh_Styrene_s1_M4 = DinhM4_s1(:,11)/RfD_inh_M4(11);


%RQ_inh_M4 = [RQ_Si_inh_M4_s1 RQ_Al_inh_M4_s1 RQ_Fe_inh_M4_s1 RQ_Ca_inh_M4_s1 RQ_Mg_inh_M4_s1 RQ_Na_inh_M4_s1 RQ_Ti_inh_M4_s1 RQ_P_inh_M4_s1 RQ_K_inh_M4_s1 RQ_Sb_inh_M4_s1 RQ_As_inh_M4_s1 RQ_Be_inh_M4_s1 RQ_Cd_inh_M4_s1 RQ_Cr_inh_M4_s1 RQ_Co_inh_M4_s1 RQ_Cu_inh_M4_s1 RQ_Pb_inh_M4_s1 RQ_Mn_inh_M4_s1 RQ_Hg_inh_M4_s1 RQ_Mo_inh_M4_s1 RQ_Ni_inh_M4_s1 RQ_V_inh_M4_s1 RQ_Zn_inh_M4_s1 RQ_Ba_inh_M4_s1 RQ_B_inh_M4_s1 RQ_Li_inh_M4_s1 RQ_Ag_inh_M4_s1 RQ_Tl_inh_M4_s1 RQ_Sn_inh_M4_s1 RQ_Se_inh_M4_s1 RQ_Bi_inh_M4_s1 RQ_S_inh_M4_s1 RQ_Sr_inh_M4_s1 RQ_Te_inh_M4_s1 RQ_Zr_inh_M4_s1 RQ_inh_Styrene_s1];
%RQ_tot_inh_M4 = sum(RQ_inh_M4);
%styrene exposure: assuming the exposure only via inhalation and calculated as an extimation of the maximum potential inhalation. 

%Dermal exposure
     
    DA_derm_face_det_M4 = ((M4_det_derm'./1000).*Adh_face); %g/cM4-ev
    DA_derm_hand_det_M4 = ((M4_det_derm'./1000).*Adh_hand); %g/cM4-ev
    
    ADD_derm_face_s1 = (DA_derm_face_det_M4.*SA_head_s1.*Ef.*Ed)./(AT.*BW); % mg/kg-day
    ADD_derm_hand_s1 = (DA_derm_hand_det_M4.*SA_hand_s1.*Ef.*Ed)./(AT.*BW); % mg/kg-day
    
    ADD_derm_M4_s1 = ADD_derm_hand_s1 + ADD_derm_face_s1;
    RfD_derm_M4 = [1; 1.4E-02; 1.4E-05; 2E-01; 3E-04; 2E-03; 1.1E+01; 9.6E-04; 4.9E+01; 1.9E+01; 1.31E-04; 3E-01; 7.5E-05; 6E-01; 2E-01];


RQ_Al_derm_M4_s1 = ADD_derm_M4_s1(:,1)/RfD_derm_M4(1);
RQ_Ba_derm_M4_s1 = ADD_derm_M4_s1(:,2)/RfD_derm_M4(2);
RQ_Be_derm_M4_s1 = ADD_derm_M4_s1(:,3)/RfD_derm_M4(3);
RQ_B_derm_M4_s1  = ADD_derm_M4_s1(:,4)/RfD_derm_M4(4);
RQ_Co_derm_M4_s1 = ADD_derm_M4_s1(:,5)/RfD_derm_M4(5);
RQ_Li_derm_M4_s1 = ADD_derm_M4_s1(:,6)/RfD_derm_M4(6);
RQ_Mg_derm_M4_s1 = ADD_derm_M4_s1(:,7)/RfD_derm_M4(7);
RQ_Mn_derm_M4_s1 = ADD_derm_M4_s1(:,8)/RfD_derm_M4(8);
RQ_P_derm_M4_s1  = ADD_derm_M4_s1(:,9)/RfD_derm_M4(9);
RQ_Na_derm_M4_s1 = ADD_derm_M4_s1(:,10)/RfD_derm_M4(10);
RQ_V_derm_M4_s1  = ADD_derm_M4_s1(:,11)/RfD_derm_M4(11);
RQ_Zn_derm_M4_s1 = ADD_derm_M4_s1(:,12)/RfD_derm_M4(12);
RQ_Cr_derm_M4_s1 = ADD_derm_M4_s1(:,13)/RfD_derm_M4(13);
RQ_Sr_derm_M4_s1 = ADD_derm_M4_s1(:,14)/RfD_derm_M4(14);
RQ_styrene_derm_M4_s1 = ADD_derm_M4_s1(:,15)/RfD_derm_M4(15);

%Risk Characterization

    RI_Si_M4_s1 = RQ_Si_inh_M4_s1;
    RI_Al_M4_s1 = RQ_Al_ing_M4_s1 + RQ_Al_inh_M4_s1 + RQ_Al_derm_M4_s1;
    RI_Fe_M4_s1 = RQ_Fe_ing_M4_s1;
    RI_Mg_M4_s1 = RQ_Mg_ing_M4_s1 + RQ_Mg_inh_M4_s1 + RQ_Mg_derm_M4_s1;
    RI_Na_M4_s1 = RQ_Na_ing_M4_s1 + RQ_Na_derm_M4_s1;
    RI_Ti_M4_s1 = RQ_Ti_ing_M4_s1;
    RI_P_M4_s1  = RQ_P_ing_M4_s1  + RQ_P_derm_M4_s1;
    RI_Be_M4_s1 = RQ_Be_ing_M4_s1 + RQ_Be_inh_M4_s1 + RQ_Be_derm_M4_s1;
    RI_Cr_M4_s1 = RQ_Cr_ing_M4_s1 + RQ_Cr_inh_M4_s1 + RQ_Cr_derm_M4_s1;
    RI_Co_M4_s1 = RQ_Co_ing_M4_s1 + RQ_Co_inh_M4_s1 + RQ_Co_derm_M4_s1;
    RI_Pb_M4_s1 = RQ_Pb_ing_M4_s1;
    RI_Mn_M4_s1 = RQ_Mn_ing_M4_s1 + RQ_Mn_inh_M4_s1 + RQ_Mn_derm_M4_s1;
    RI_V_M4_s1  = RQ_V_ing_M4_s1  + RQ_V_inh_M4_s1  + RQ_V_derm_M4_s1;
    RI_Zn_M4_s1 = RQ_Zn_ing_M4_s1 + RQ_Zn_derm_M4_s1;
    RI_Ba_M4_s1 = RQ_Ba_ing_M4_s1 + RQ_Ba_inh_M4_s1 + RQ_Ba_derm_M4_s1;
    RI_B_M4_s1 = RQ_B_ing_M4_s1 + RQ_B_inh_M4_s1 + RQ_B_derm_M4_s1;
    RI_Li_M4_s1 = RQ_Li_ing_M4_s1 + RQ_Li_derm_M4_s1;
    RI_Sr_M4_s1 = RQ_Sr_ing_M4_s1 + RQ_Sr_derm_M4_s1;
    RI_Styrene_M4_s1 = RQ_ing_Styrene_s1_M4 + RQ_inh_Styrene_s1_M4 + RQ_styrene_derm_M4_s1;
    
    RI_M4_s1 = [RI_Si_M4_s1 RI_Al_M4_s1 RI_Fe_M4_s1 RI_Mg_M4_s1 RI_Na_M4_s1 RI_Ti_M4_s1 RI_P_M4_s1 RI_Be_M4_s1 RI_Cr_M4_s1 RI_Co_M4_s1 RI_Pb_M4_s1 RI_Mn_M4_s1 RI_V_M4_s1 RI_Zn_M4_s1 RI_Ba_M4_s1 RI_B_M4_s1 RI_Li_M4_s1 RI_Sr_M4_s1 RI_Styrene_M4_s1];
   
    
    RItot_NM4_s1 = sum(RI_M4_s1.');
    
end 

    %test = [RItot_NM4_s0.' RItot_NM4_s1.'];
    % boxplot(RItot_NM4_s1);
    % %set(gca, 'YScale', 'log')
    % yline(1,'-','Threshold');
    % title("RI Material 1 - Sesntivity 1 approach");
    % xlabel("Material");
    % ylabel("Risk Index");
    % xticks(1)
    % xticklabels("Sensitivity 1 M4")
    %xticks([1 2 3 4 5 6 7 8 9 10 11 12 13 14 15 16 17 18 19]);
    %xticklabels({'Si','Al','Fe','Mg','Na','Ti','P','Be','Cr','Co','Pb','Mn','V','Zn','Ba' ,'B','Li', 'Sr','Styrene'});
    %xlim([0 20]);    
    %xticks([1 2 3 4 5 6 7 8 9 10 11 12 13 14 15 16 17 18 19]);
    %xticklabels({'Si','Al','Fe','Mg','Na','Ti','P','Be','Cr','Co','Pb','Mn','V','Zn','Ba' ,'B','Li', 'Sr','Styrene'});
    %xlim([0 20]);
    %legend('Si','Al','Fe','Ca','Mg','Na','Ti','P','K','Sb','As','Be','Cd','Cr','Co','Cu','Pb','Mn','Hg','Mo','Ni','V','Zn','Ba' ,'B','Li', 'Ag','Tl','Sn','Se','Bi','S','Sr','Te','Zr','Styrene');

%sensitivity 2
n=10000;
for i =1:n
    v_ef = 0.0274; 
    mu_ef = log(((6.85E-01)^2)./sqrt(v_ef+(6.85E-01)^2));
    sigma_ef = sqrt(log(v_ef./((6.85E-01)^2)+1));
    Ef_s2 = lognrnd(mu_ef, sigma_ef, n,1);
    
    DingM4_s2 = ((M4_ing_det'./1000).*IngR.*Ed.*Ef_s2)./(BW.*AT);
    RfD_ing_M4 = [1E00; 2E-01; 2E-03; 2E-01; 3E-04; 7E-01; 2E-03; 1.1E+01; 2.4E-02; 4.9E+01; 1.9E+01; 3E00; 5.04E-03; 3E-01; 3E-03; 4E-03; 6E-01; 2E-01];

%Ding_Styrene_s2 = (IngR_s2.*(Styrene_M4/1000)*Ef*Ed)/(BW*AT);

%Risk Quotient - Ingestion 
RQ_Al_ing_M4_s2 = DingM4_s2(:,1)/RfD_ing_M4(1);
RQ_Ba_ing_M4_s2 = DingM4_s2(:,2)/RfD_ing_M4(2);
RQ_Be_ing_M4_s2 = DingM4_s2(:,3)/RfD_ing_M4(3);
RQ_B_ing_M4_s2  = DingM4_s2(:,4)/RfD_ing_M4(4);
RQ_Co_ing_M4_s2 = DingM4_s2(:,5)/RfD_ing_M4(5);
RQ_Fe_ing_M4_s2 = DingM4_s2(:,6)/RfD_ing_M4(6);
RQ_Li_ing_M4_s2 = DingM4_s2(:,7)/RfD_ing_M4(7);
RQ_Mg_ing_M4_s2 = DingM4_s2(:,8)/RfD_ing_M4(8);
RQ_Mn_ing_M4_s2 = DingM4_s2(:,9)/RfD_ing_M4(9);
RQ_P_ing_M4_s2  = DingM4_s2(:,10)/RfD_ing_M4(10);
RQ_Na_ing_M4_s2 = DingM4_s2(:,11)/RfD_ing_M4(11);
RQ_Ti_ing_M4_s2 = DingM4_s2(:,12)/RfD_ing_M4(12);
RQ_V_ing_M4_s2  = DingM4_s2(:,13)/RfD_ing_M4(13);
RQ_Zn_ing_M4_s2 = DingM4_s2(:,14)/RfD_ing_M4(14);
RQ_Cr_ing_M4_s2 = DingM4_s2(:,15)/RfD_ing_M4(15);
RQ_Pb_ing_M4_s2 = DingM4_s2(:,16)/RfD_ing_M4(16);
RQ_Sr_ing_M4_s2 = DingM4_s2(:,17)/RfD_ing_M4(17);
RQ_ing_Styrene_s2_M4 = DingM4_s2(:,18)/RfD_ing_M4(18);


%RQ_ing_M4_s2 = [RQ_Al_ing_M4_s2 RQ_Fe_ing_M4_s2 RQ_Mg_ing_M4_s2 RQ_Na_ing_M4_s2 RQ_Ti_ing_M4_s2 RQ_P_ing_M4_s2 RQ_Sb_ing_M4_s2 RQ_Be_ing_M4_s2 RQ_Cr_ing_M4_s2 RQ_Co_ing_M4_s2 RQ_Cu_ing_M4_s2 RQ_Pb_ing_M4_s2 RQ_Mn_ing_M4_s2 RQ_Hg_ing_M4_s2 RQ_Mo_ing_M4_s2 RQ_Ni_ing_M4_s2 RQ_V_ing_M4_s2 RQ_Zn_ing_M4_s2 RQ_Ba_ing_M4_s2 RQ_B_ing_M4_s2 RQ_Li_ing_M4_s2 RQ_Sn_ing_M4_s2 RQ_Sr_ing_M4_s2 RQ_ing_Styrene_s2];

%RQ_tot_ing_M4_s2 = sum(RQ_ing_M4_s2);
%Exposure assessment: inhalation

    DinhM4_s2 = (M4_inh_det'.*Et.*Ed.*(Ef_s2).*InhR)./(PEF.*AT.*BW);
    RfD_inh_M4 = [1.02E-03; 1.02E-04; 4.09E-06; 4.09E-03; 1.23E-06; 2.05E-02; 1.02E-05; 2.05E-05; 2.05E-05; 6.14E-04; 1.84E-01];

%Risk Quotient - Inhalation 
RQ_Al_inh_M4_s2 = DinhM4_s2(:,1)/RfD_inh_M4(1);
RQ_Ba_inh_M4_s2 = DinhM4_s2(:,2)/RfD_inh_M4(2);
RQ_Be_inh_M4_s2 = DinhM4_s2(:,3)/RfD_inh_M4(3);
RQ_B_inh_M4_s2  = DinhM4_s2(:,4)/RfD_inh_M4(4);
RQ_Co_inh_M4_s2 = DinhM4_s2(:,5)/RfD_inh_M4(5);
RQ_Mg_inh_M4_s2 = DinhM4_s2(:,6)/RfD_inh_M4(6);
RQ_Mn_inh_M4_s2 = DinhM4_s2(:,7)/RfD_inh_M4(7);
RQ_V_inh_M4_s2  = DinhM4_s2(:,8)/RfD_inh_M4(8);
RQ_Cr_inh_M4_s2 = DinhM4_s2(:,9)/RfD_inh_M4(9);
RQ_Si_inh_M4_s2 = DinhM4_s2(:,10)/RfD_inh_M4(10);
RQ_inh_Styrene_s2_M4 = DinhM4_s2(:,11)/RfD_inh_M4(11);




    
   
%Dermal exposure
    DA_derm_face_det_M4 = ((M4_det_derm/1000).*Adh_face); %mg/cM3-d
    DA_derm_hand_det_M4 = ((M4_det_derm/1000).*Adh_hand); %mg/cM3-d
        
    ADD_derm_face_M4_s4 = (DA_derm_face_det_M4.*SA_head.*Ef_s2'.*Ed)./(AT.*BW); % mg/kg-day
    ADD_derm_hand_M4_s4 = (DA_derm_hand_det_M4.*SA_hand.*Ef_s2'.*Ed)./(AT.*BW); % mg/kg-day
    
    ADD_derm_M4_s2 = ADD_derm_face_M4_s4' + ADD_derm_hand_M4_s4';
    
    RfD_derm_M4 = [1; 1.4E-02; 1.4E-05; 2E-01; 3E-04; 2E-03; 1.1E+01; 9.6E-04; 4.9E+01; 1.9E+01; 1.31E-04; 3E-01; 7.5E-05; 6E-01; 2E-01];

RQ_Al_derm_M4_s2 = ADD_derm_M4_s2(:,1)/RfD_derm_M4(1);
RQ_Ba_derm_M4_s2 = ADD_derm_M4_s2(:,2)/RfD_derm_M4(2);
RQ_Be_derm_M4_s2 = ADD_derm_M4_s2(:,3)/RfD_derm_M4(3);
RQ_B_derm_M4_s2  = ADD_derm_M4_s2(:,4)/RfD_derm_M4(4);
RQ_Co_derm_M4_s2 = ADD_derm_M4_s2(:,5)/RfD_derm_M4(5);
RQ_Li_derm_M4_s2 = ADD_derm_M4_s2(:,6)/RfD_derm_M4(6);
RQ_Mg_derm_M4_s2 = ADD_derm_M4_s2(:,7)/RfD_derm_M4(7);
RQ_Mn_derm_M4_s2 = ADD_derm_M4_s2(:,8)/RfD_derm_M4(8);
RQ_P_derm_M4_s2  = ADD_derm_M4_s2(:,9)/RfD_derm_M4(9);
RQ_Na_derm_M4_s2 = ADD_derm_M4_s2(:,10)/RfD_derm_M4(10);
RQ_V_derm_M4_s2  = ADD_derm_M4_s2(:,11)/RfD_derm_M4(11);
RQ_Zn_derm_M4_s2 = ADD_derm_M4_s2(:,12)/RfD_derm_M4(12);
RQ_Cr_derm_M4_s2 = ADD_derm_M4_s2(:,13)/RfD_derm_M4(13);
RQ_Sr_derm_M4_s2 = ADD_derm_M4_s2(:,14)/RfD_derm_M4(14);
RQ_styrene_derm_M4_s2 = ADD_derm_M4_s2(:,15)/RfD_derm_M4(15);

%Risk Characterization

    RI_Si_M4_s2 = RQ_Si_inh_M4_s2;
    RI_Al_M4_s2 = RQ_Al_ing_M4_s2 + RQ_Al_inh_M4_s2 + RQ_Al_derm_M4_s2;
    RI_Fe_M4_s2 = RQ_Fe_ing_M4_s2;
    RI_Mg_M4_s2 = RQ_Mg_ing_M4_s2 + RQ_Mg_inh_M4_s2 + RQ_Mg_derm_M4_s2;
    RI_Na_M4_s2 = RQ_Na_ing_M4_s2 + RQ_Na_derm_M4_s2;
    RI_Ti_M4_s2 = RQ_Ti_ing_M4_s2;
    RI_P_M4_s2  = RQ_P_ing_M4_s2  + RQ_P_derm_M4_s2;
    RI_Be_M4_s2 = RQ_Be_ing_M4_s2 + RQ_Be_inh_M4_s2 + RQ_Be_derm_M4_s2;
    RI_Cr_M4_s2 = RQ_Cr_ing_M4_s2 + RQ_Cr_inh_M4_s2 + RQ_Cr_derm_M4_s2;
    RI_Co_M4_s2 = RQ_Co_ing_M4_s2 + RQ_Co_inh_M4_s2 + RQ_Co_derm_M4_s2;
    RI_Pb_M4_s2 = RQ_Pb_ing_M4_s2;
    RI_Mn_M4_s2 = RQ_Mn_ing_M4_s2 + RQ_Mn_inh_M4_s2 + RQ_Mn_derm_M4_s2;
    RI_V_M4_s2  = RQ_V_ing_M4_s2  + RQ_V_inh_M4_s2  + RQ_V_derm_M4_s2;
    RI_Zn_M4_s2 = RQ_Zn_ing_M4_s2 + RQ_Zn_derm_M4_s2;
    RI_Ba_M4_s2 = RQ_Ba_ing_M4_s2 + RQ_Ba_inh_M4_s2 + RQ_Ba_derm_M4_s2;
    RI_B_M4_s2 = RQ_B_ing_M4_s2 + RQ_B_inh_M4_s2 + RQ_B_derm_M4_s2;
    RI_Li_M4_s2 = RQ_Li_ing_M4_s2 + RQ_Li_derm_M4_s2;
    RI_Sr_M4_s2 = RQ_Sr_ing_M4_s2 + RQ_Sr_derm_M4_s2;
    RI_Styrene_M4_s2 = RQ_ing_Styrene_s2_M4 + RQ_inh_Styrene_s2_M4 + RQ_styrene_derm_M4_s2;
    
    RI_NM4_s2 = [RI_Si_M4_s2 RI_Al_M4_s2 RI_Fe_M4_s2 RI_Mg_M4_s2 RI_Na_M4_s2 RI_Ti_M4_s2 RI_P_M4_s2 RI_Be_M4_s2 RI_Cr_M4_s2 RI_Co_M4_s2 RI_Pb_M4_s2 RI_Mn_M4_s2 RI_V_M4_s2 RI_Zn_M4_s2 RI_Ba_M4_s2 RI_B_M4_s2 RI_Li_M4_s2 RI_Sr_M4_s2 RI_Styrene_M4_s2];

    
    RItot_NM4_s2 = sum(RI_NM4_s2');
end 

    % boxplot(RItot_NM4_s2);
    % set(gca, 'YScale', 'log')
    % yline(1,'-','Threshold');
    % title("RI Material 1 - Sesntivity 2 approach");
    % xlabel("Material");
    % ylabel("Risk Index");
    % xticks(1)
    % xticklabels("Sensitivity 2 M4")

    %Sensitiviy 3
for i =1:n
    
    v_bw = 35.28;
    mu_bw = log((BW^2)/sqrt(v_bw+BW^2));
    sigma_bw = sqrt(log(v_bw/(BW^2)+1));
    BW_s3 = lognrnd(mu_bw, sigma_bw, n,1);
    
    DingM4_s3 = ((M4_ing_det'./1000).*IngR.*Ed.*Ef)./(BW_s3.*AT);
    RfD_ing_M4 = [1E00; 2E-01; 2E-03; 2E-01; 3E-04; 7E-01; 2E-03; 1.1E+01; 2.4E-02; 4.9E+01; 1.9E+01; 3E00; 5.04E-03; 3E-01; 3E-03; 4E-03; 6E-01; 2E-01];



%Risk Quotient - Ingestion 
RQ_Al_ing_M4_s3 = DingM4_s3(:,1)/RfD_ing_M4(1);
RQ_Ba_ing_M4_s3 = DingM4_s3(:,2)/RfD_ing_M4(2);
RQ_Be_ing_M4_s3 = DingM4_s3(:,3)/RfD_ing_M4(3);
RQ_B_ing_M4_s3  = DingM4_s3(:,4)/RfD_ing_M4(4);
RQ_Co_ing_M4_s3 = DingM4_s3(:,5)/RfD_ing_M4(5);
RQ_Fe_ing_M4_s3 = DingM4_s3(:,6)/RfD_ing_M4(6);
RQ_Li_ing_M4_s3 = DingM4_s3(:,7)/RfD_ing_M4(7);
RQ_Mg_ing_M4_s3 = DingM4_s3(:,8)/RfD_ing_M4(8);
RQ_Mn_ing_M4_s3 = DingM4_s3(:,9)/RfD_ing_M4(9);
RQ_P_ing_M4_s3  = DingM4_s3(:,10)/RfD_ing_M4(10);
RQ_Na_ing_M4_s3 = DingM4_s3(:,11)/RfD_ing_M4(11);
RQ_Ti_ing_M4_s3 = DingM4_s3(:,12)/RfD_ing_M4(12);
RQ_V_ing_M4_s3  = DingM4_s3(:,13)/RfD_ing_M4(13);
RQ_Zn_ing_M4_s3 = DingM4_s3(:,14)/RfD_ing_M4(14);
RQ_Cr_ing_M4_s3 = DingM4_s3(:,15)/RfD_ing_M4(15);
RQ_Pb_ing_M4_s3 = DingM4_s3(:,16)/RfD_ing_M4(16);
RQ_Sr_ing_M4_s3 = DingM4_s3(:,17)/RfD_ing_M4(17);
RQ_ing_Styrene_s3_M4 = DingM4_s3(:,18)/RfD_ing_M4(18);

%Exposure assessment: inhalation

    DinhM4_s3 = (M4_inh_det'.*Et.*Ed.*Ef.*InhR)./(PEF.*AT.*BW_s3);
    RfD_inh_M4 = [1.02E-03; 1.02E-04; 4.09E-06; 4.09E-03; 1.23E-06; 2.05E-02; 1.02E-05; 2.05E-05; 2.05E-05; 6.14E-04; 1.84E-01];

%Risk Quotient - Inhalation 
RQ_Al_inh_M4_s3 = DinhM4_s3(:,1)/RfD_inh_M4(1);
RQ_Ba_inh_M4_s3 = DinhM4_s3(:,2)/RfD_inh_M4(2);
RQ_Be_inh_M4_s3 = DinhM4_s3(:,3)/RfD_inh_M4(3);
RQ_B_inh_M4_s3  = DinhM4_s3(:,4)/RfD_inh_M4(4);
RQ_Co_inh_M4_s3 = DinhM4_s3(:,5)/RfD_inh_M4(5);
RQ_Mg_inh_M4_s3 = DinhM4_s3(:,6)/RfD_inh_M4(6);
RQ_Mn_inh_M4_s3 = DinhM4_s3(:,7)/RfD_inh_M4(7);
RQ_V_inh_M4_s3  = DinhM4_s3(:,8)/RfD_inh_M4(8);
RQ_Cr_inh_M4_s3 = DinhM4_s3(:,9)/RfD_inh_M4(9);
RQ_Si_inh_M4_s3 = DinhM4_s3(:,10)/RfD_inh_M4(10);
RQ_inh_Styrene_s3_M4 = DinhM4_s3(:,11)/RfD_inh_M4(11);

%Dermal exposure
DA_derm_face_s3 = ((M4_det_derm./1000).*Adh_face); %g/cM4-ev
DA_derm_hand_s3 = ((M4_det_derm./1000).*Adh_hand); %g/cM4-ev
    
ADD_derm_face_M4_s3 = (DA_derm_face_s3*SA_head*Ef*Ed)/(AT*BW_s3); % mg/kg-day
ADD_derm_hand_M4_s3 = (DA_derm_hand_s3*SA_hand*Ef*Ed)/(AT*BW_s3); % mg/kg-day

ADD_derm_M4_s3 = ADD_derm_face_M4_s3' + ADD_derm_hand_M4_s3';

RfD_derm_M4 = [1; 1.4E-02; 1.4E-05; 2E-01; 3E-04; 2E-03; 1.1E+01; 9.6E-04; 4.9E+01; 1.9E+01; 1.31E-04; 3E-01; 7.5E-05; 6E-01; 2E-01];

RQ_Al_derm_M4_s3 = ADD_derm_M4_s3(:,1)/RfD_derm_M4(1);
RQ_Ba_derm_M4_s3 = ADD_derm_M4_s3(:,2)/RfD_derm_M4(2);
RQ_Be_derm_M4_s3 = ADD_derm_M4_s3(:,3)/RfD_derm_M4(3);
RQ_B_derm_M4_s3  = ADD_derm_M4_s3(:,4)/RfD_derm_M4(4);
RQ_Co_derm_M4_s3 = ADD_derm_M4_s3(:,5)/RfD_derm_M4(5);
RQ_Li_derm_M4_s3 = ADD_derm_M4_s3(:,6)/RfD_derm_M4(6);
RQ_Mg_derm_M4_s3 = ADD_derm_M4_s3(:,7)/RfD_derm_M4(7);
RQ_Mn_derm_M4_s3 = ADD_derm_M4_s3(:,8)/RfD_derm_M4(8);
RQ_P_derm_M4_s3  = ADD_derm_M4_s3(:,9)/RfD_derm_M4(9);
RQ_Na_derm_M4_s3 = ADD_derm_M4_s3(:,10)/RfD_derm_M4(10);
RQ_V_derm_M4_s3  = ADD_derm_M4_s3(:,11)/RfD_derm_M4(11);
RQ_Zn_derm_M4_s3 = ADD_derm_M4_s3(:,12)/RfD_derm_M4(12);
RQ_Cr_derm_M4_s3 = ADD_derm_M4_s3(:,13)/RfD_derm_M4(13);
RQ_Sr_derm_M4_s3 = ADD_derm_M4_s3(:,14)/RfD_derm_M4(14);
RQ_styrene_derm_M4_s3 = ADD_derm_M4_s3(:,15)/RfD_derm_M4(15);

%Risk Characterization

    RI_Si_M4_s3 = RQ_Si_inh_M4_s3;
    RI_Al_M4_s3 = RQ_Al_ing_M4_s3 + RQ_Al_inh_M4_s3 + RQ_Al_derm_M4_s3;
    RI_Fe_M4_s3 = RQ_Fe_ing_M4_s3;
    RI_Mg_M4_s3 = RQ_Mg_ing_M4_s3 + RQ_Mg_inh_M4_s3 + RQ_Mg_derm_M4_s3;
    RI_Na_M4_s3 = RQ_Na_ing_M4_s3 + RQ_Na_derm_M4_s3;
    RI_Ti_M4_s3 = RQ_Ti_ing_M4_s3;
    RI_P_M4_s3  = RQ_P_ing_M4_s3  + RQ_P_derm_M4_s3;
    RI_Be_M4_s3 = RQ_Be_ing_M4_s3 + RQ_Be_inh_M4_s3 + RQ_Be_derm_M4_s3;
    RI_Cr_M4_s3 = RQ_Cr_ing_M4_s3 + RQ_Cr_inh_M4_s3 + RQ_Cr_derm_M4_s3;
    RI_Co_M4_s3 = RQ_Co_ing_M4_s3 + RQ_Co_inh_M4_s3 + RQ_Co_derm_M4_s3;
    RI_Pb_M4_s3 = RQ_Pb_ing_M4_s3;
    RI_Mn_M4_s3 = RQ_Mn_ing_M4_s3 + RQ_Mn_inh_M4_s3 + RQ_Mn_derm_M4_s3;
    RI_V_M4_s3  = RQ_V_ing_M4_s3  + RQ_V_inh_M4_s3  + RQ_V_derm_M4_s3;
    RI_Zn_M4_s3 = RQ_Zn_ing_M4_s3 + RQ_Zn_derm_M4_s3;
    RI_Ba_M4_s3 = RQ_Ba_ing_M4_s3 + RQ_Ba_inh_M4_s3 + RQ_Ba_derm_M4_s3;
    RI_B_M4_s3 = RQ_B_ing_M4_s3 + RQ_B_inh_M4_s3 + RQ_B_derm_M4_s3;
    RI_Li_M4_s3 = RQ_Li_ing_M4_s3 + RQ_Li_derm_M4_s3;
    RI_Sr_M4_s3 = RQ_Sr_ing_M4_s3 + RQ_Sr_derm_M4_s3;
    RI_Styrene_M4_s3 = RQ_ing_Styrene_s3_M4 + RQ_inh_Styrene_s3_M4 + RQ_styrene_derm_M4_s3;
    
    RI_NM4_s3 = [RI_Si_M4_s3 RI_Al_M4_s3 RI_Fe_M4_s3 RI_Mg_M4_s3 RI_Na_M4_s3 RI_Ti_M4_s3 RI_P_M4_s3 RI_Be_M4_s3 RI_Cr_M4_s3 RI_Co_M4_s3 RI_Pb_M4_s3 RI_Mn_M4_s3 RI_V_M4_s3 RI_Zn_M4_s3 RI_Ba_M4_s3 RI_B_M4_s3 RI_Li_M4_s3 RI_Sr_M4_s3 RI_Styrene_M4_s3];

    
    RItot_NM4_s3 = sum(RI_NM4_s3');
end 


    % boxplot(RItot_NM4_s3);
    % set(gca, 'YScale', 'log')
    % ylim([0 2]);
    % yline(1,'-','Threshold');
    % title("RI Material 1 - Sesntivity 3 approach");
    % xlabel("Material");
    % ylabel("Risk Index");
    % xticks(1)
    % xticklabels("Sensitivity 3 M4")

    %sensitivity 4
n=10000;
for i = 1:n
    %DingNM4_s4 = (Ed.*(NM4_s0_ing./1000).*(IngR_s1./1000).*(Ef_s2./365))./(BW_s3.*AT);
    DingM4_s4 = ((NM4_s0_ing./1000).*(IngR_s1./1000).*Ef_s2.*Ed)./(BW_s3.*AT);
    RfD_ing_M4 = [1E00; 2E-01; 2E-03; 2E-01; 3E-04; 7E-01; 2E-03; 1.1E+01; 2.4E-02; 4.9E+01; 1.9E+01; 3E00; 5.04E-03; 3E-01; 3E-03; 4E-03; 6E-01; 2E-01];

    %Risk Quotient - Ingestion 
    RQ_Al_ing_M4_s4 = DingM4_s4(:,1)/RfD_ing_M4(1);
    RQ_Ba_ing_M4_s4 = DingM4_s4(:,2)/RfD_ing_M4(2);
    RQ_Be_ing_M4_s4 = DingM4_s4(:,3)/RfD_ing_M4(3);
    RQ_B_ing_M4_s4  = DingM4_s4(:,4)/RfD_ing_M4(4);
    RQ_Co_ing_M4_s4 = DingM4_s4(:,5)/RfD_ing_M4(5);
    RQ_Fe_ing_M4_s4 = DingM4_s4(:,6)/RfD_ing_M4(6);
    RQ_Li_ing_M4_s4 = DingM4_s4(:,7)/RfD_ing_M4(7);
    RQ_Mg_ing_M4_s4 = DingM4_s4(:,8)/RfD_ing_M4(8);
    RQ_Mn_ing_M4_s4 = DingM4_s4(:,9)/RfD_ing_M4(9);
    RQ_P_ing_M4_s4  = DingM4_s4(:,10)/RfD_ing_M4(10);
    RQ_Na_ing_M4_s4 = DingM4_s4(:,11)/RfD_ing_M4(11);
    RQ_Ti_ing_M4_s4 = DingM4_s4(:,12)/RfD_ing_M4(12);
    RQ_V_ing_M4_s4  = DingM4_s4(:,13)/RfD_ing_M4(13);
    RQ_Zn_ing_M4_s4 = DingM4_s4(:,14)/RfD_ing_M4(14);
    RQ_Cr_ing_M4_s4 = DingM4_s4(:,15)/RfD_ing_M4(15);
    RQ_Pb_ing_M4_s4 = DingM4_s4(:,16)/RfD_ing_M4(16);
    RQ_Sr_ing_M4_s4 = DingM4_s4(:,17)/RfD_ing_M4(17);
    RQ_ing_Styrene_s4_M4 = DingM4_s4(:,18)/RfD_ing_M4(18);


    %Exposure assessment: inhalation
    DinhM4_s4 = (M4_inh_s0.*Et.*Ed.*Ef_s2.*(InhR_s1./24))./(PEF.*AT.*BW_s3);
    RfD_inh_M4 = [1.02E-03; 1.02E-04; 4.09E-06; 4.09E-03; 1.23E-06; 2.05E-02; 1.02E-05; 2.05E-05; 2.05E-05; 6.14E-04; 1.84E-01];

%Risk Quotient - Inhalation 
    RQ_Al_inh_M4_s4 = DinhM4_s4(:,1)/RfD_inh_M4(1);
    RQ_Ba_inh_M4_s4 = DinhM4_s4(:,2)/RfD_inh_M4(2);
    RQ_Be_inh_M4_s4 = DinhM4_s4(:,3)/RfD_inh_M4(3);
    RQ_B_inh_M4_s4  = DinhM4_s4(:,4)/RfD_inh_M4(4);
    RQ_Co_inh_M4_s4 = DinhM4_s4(:,5)/RfD_inh_M4(5);
    RQ_Mg_inh_M4_s4 = DinhM4_s4(:,6)/RfD_inh_M4(6);
    RQ_Mn_inh_M4_s4 = DinhM4_s4(:,7)/RfD_inh_M4(7);
    RQ_V_inh_M4_s4  = DinhM4_s4(:,8)/RfD_inh_M4(8);
    RQ_Cr_inh_M4_s4 = DinhM4_s4(:,9)/RfD_inh_M4(9);
    RQ_Si_inh_M4_s4 = DinhM4_s4(:,10)/RfD_inh_M4(10);
    RQ_inh_Styrene_s4_M4 = DinhM4_s4(:,11)/RfD_inh_M4(11);



    %Dermal exposure
    
    ADD_derm_face_s4 = (DA_derm_face_M4_s0.*SA_head_s1.*Ef_s2.*Ed)./(AT.*BW_s3); % mg/kg-day
    ADD_derm_hand_s4 = (DA_derm_hand_M4_s0.*SA_hand_s1.*Ef_s2.*Ed)./(AT.*BW_s3); % mg/kg-day
    
    ADD_derm_M4_s4 = ADD_derm_hand_s4 + ADD_derm_face_s4;

    RfD_derm_M4 = [1; 1.4E-02; 1.4E-05; 2E-01; 3E-04; 2E-03; 1.1E+01; 9.6E-04; 4.9E+01; 1.9E+01; 1.31E-04; 3E-01; 7.5E-05; 6E-01; 2E-01];

    RQ_Al_derm_M4_s4 = ADD_derm_M4_s4(:,1)/RfD_derm_M4(1);
    RQ_Ba_derm_M4_s4 = ADD_derm_M4_s4(:,2)/RfD_derm_M4(2);
    RQ_Be_derm_M4_s4 = ADD_derm_M4_s4(:,3)/RfD_derm_M4(3);
    RQ_B_derm_M4_s4  = ADD_derm_M4_s4(:,4)/RfD_derm_M4(4);
    RQ_Co_derm_M4_s4 = ADD_derm_M4_s4(:,5)/RfD_derm_M4(5);
    RQ_Li_derm_M4_s4 = ADD_derm_M4_s4(:,6)/RfD_derm_M4(6);
    RQ_Mg_derm_M4_s4 = ADD_derm_M4_s4(:,7)/RfD_derm_M4(7);
    RQ_Mn_derm_M4_s4 = ADD_derm_M4_s4(:,8)/RfD_derm_M4(8);
    RQ_P_derm_M4_s4  = ADD_derm_M4_s4(:,9)/RfD_derm_M4(9);
    RQ_Na_derm_M4_s4 = ADD_derm_M4_s4(:,10)/RfD_derm_M4(10);
    RQ_V_derm_M4_s4  = ADD_derm_M4_s4(:,11)/RfD_derm_M4(11);
    RQ_Zn_derm_M4_s4 = ADD_derm_M4_s4(:,12)/RfD_derm_M4(12);
    RQ_Cr_derm_M4_s4 = ADD_derm_M4_s4(:,13)/RfD_derm_M4(13);
    RQ_Sr_derm_M4_s4 = ADD_derm_M4_s4(:,14)/RfD_derm_M4(14);
    RQ_styrene_derm_M4_s4 = ADD_derm_M4_s4(:,15)/RfD_derm_M4(15);

    %Risk Characterization

    RI_Si_M4_s4 = RQ_Si_inh_M4_s4;
    RI_Al_M4_s4 = RQ_Al_ing_M4_s4 + RQ_Al_inh_M4_s4 + RQ_Al_derm_M4_s4;
    RI_Fe_M4_s4 = RQ_Fe_ing_M4_s4;
    RI_Mg_M4_s4 = RQ_Mg_ing_M4_s4 + RQ_Mg_inh_M4_s4 + RQ_Mg_derm_M4_s4;
    RI_Na_M4_s4 = RQ_Na_ing_M4_s4 + RQ_Na_derm_M4_s4;
    RI_Ti_M4_s4 = RQ_Ti_ing_M4_s4;
    RI_P_M4_s4  = RQ_P_ing_M4_s4  + RQ_P_derm_M4_s4;
    RI_Be_M4_s4 = RQ_Be_ing_M4_s4 + RQ_Be_inh_M4_s4 + RQ_Be_derm_M4_s4;
    RI_Cr_M4_s4 = RQ_Cr_ing_M4_s4 + RQ_Cr_inh_M4_s4 + RQ_Cr_derm_M4_s4;
    RI_Co_M4_s4 = RQ_Co_ing_M4_s4 + RQ_Co_inh_M4_s4 + RQ_Co_derm_M4_s4;
    RI_Pb_M4_s4 = RQ_Pb_ing_M4_s4;
    RI_Mn_M4_s4 = RQ_Mn_ing_M4_s4 + RQ_Mn_inh_M4_s4 + RQ_Mn_derm_M4_s4;
    RI_V_M4_s4  = RQ_V_ing_M4_s4  + RQ_V_inh_M4_s4  + RQ_V_derm_M4_s4;
    RI_Zn_M4_s4 = RQ_Zn_ing_M4_s4 + RQ_Zn_derm_M4_s4;
    RI_Ba_M4_s4 = RQ_Ba_ing_M4_s4 + RQ_Ba_inh_M4_s4 + RQ_Ba_derm_M4_s4;
    RI_B_M4_s4 = RQ_B_ing_M4_s4 + RQ_B_inh_M4_s4 + RQ_B_derm_M4_s4;
    RI_Li_M4_s4 = RQ_Li_ing_M4_s4 + RQ_Li_derm_M4_s4;
    RI_Sr_M4_s4 = RQ_Sr_ing_M4_s4 + RQ_Sr_derm_M4_s4;
    RI_Styrene_M4_s4 = RQ_ing_Styrene_s4_M4 + RQ_inh_Styrene_s4_M4 + RQ_styrene_derm_M4_s4;
    
    RI_NM4_s4 = [RI_Si_M4_s4 RI_Al_M4_s4 RI_Fe_M4_s4 RI_Mg_M4_s4 RI_Na_M4_s4 RI_Ti_M4_s4 RI_P_M4_s4 RI_Be_M4_s4 RI_Cr_M4_s4 RI_Co_M4_s4 RI_Pb_M4_s4 RI_Mn_M4_s4 RI_V_M4_s4 RI_Zn_M4_s4 RI_Ba_M4_s4 RI_B_M4_s4 RI_Li_M4_s4 RI_Sr_M4_s4 RI_Styrene_M4_s4];

    
    RItot_NM4_s4 = sum(RI_NM4_s4.');

end 

    % boxplot(RItot_NM4_s4);
    % set(gca, 'YScale', 'log')
    % %ylim([0 2]);
    % yline(1,'-','Threshold')
    % title("RI Material 1 - Sesntivity 4 approach");
    % xlabel("Material");
    % ylabel("Risk Index");
    % xticks(1)
    % xticklabels("Sensitivity 4 M4")

   
