Ef = 6.85E-01;
Ed = 250;
Et = 8;
IngR = 3E-02;
BW = 7.58E+01;
AT = Ed*365;
InhR = 6.47E-01;
PEF = 1.36E+09;
CF = 1E-06;
SA_hand = 9.8E+02;
SA_face = 1.25E+03;
AF_hands = 2.76E-04;
AF_face = 9.82E-05;
AT_carc = 70*365;

mass = 1000;
m_polyester = mass*0.27;
m_UPR_M3 = mass*0.28;
mass_furan = mass*0.52;

%Sensitivity 0
n= 10000;
for i=1:n
Styrene_M3_s0 = (9.80E+04-0)*rand(n,1)+0;
    %cellulose
    Silicum_Ce_M3_s0 = (777-0)*rand(n,1)+75;
    Aluminium_Ce_M3_s0 = (3.12-0)*rand(n,1)+3.12;
    Iron_Ce_M3_s0 = (13.9-0)*rand(n,1)+13.9;
    Calcium_Ce_M3_s0 = (698-0)*rand(n,1)+0;
    Magnesium_Ce_M3_s0 = (383-0)*rand(n,1)+383;
    Sodium_Ce_M3_s0 = (615-0)*rand(n,1)+0;
    Phosphorus_Ce_M3_s0 =(176-0)*rand(n,1)+0;
    Potassium_Ce_M3_s0 = (971-0)*rand(n,1)+0; 
    Manganese_Ce_M3_s0 = (27.8-0)*rand(n,1)+20;
    Zinc_Ce_M3_s0 = (21.1-0)*rand(n,1)+21.1;
    Barium_Ce_M3_s0 = (4.19-0)*rand(n,1)+0;
    Boron_Ce_M3_s0 = (1.52-0)*rand(n,1)+1.52;
    Sulfur_Ce_M3_s0 = (581-0)*rand(n,1)+0;
    Strontium_Ce_M3_s0 = (6-0)*rand(n,1)+0;

    %Calcite
    Silicum_Ca_M3_s0 = (1.22E+03-0)*rand(n,1)+0;
    Aluminium_Ca_M3_s0 =(3.18E+02-0)*rand(n,1)+0;
    Iron_Ca_M3_s0 = (6.36E+02-0)*rand(n,1)+0;
    Calcium_Ca_M3_s0 = (7.36E+03-0)*rand(n,1)+0;
    Magnesium_Ca_M3_s0 = (2.05E+03-0)*rand(n,1)+0;
    Sodium_Ca_M3_s0 = (4.79E+03-0)*rand(n,1)+0;
    Titanium_Ca_M3_s0 = (0.38-0)*rand(n,1)+0;
    Phosphorus_Ca_M3_s0 = (1.62E+03-0)*rand(n,1)+0;
    Potassium_Ca_M3_s0 = (1.52E+04-0)*rand(n,1)+0;
    Beryllium_Ca_M3_s0 = (2.94E-02-0)*rand(n,1)+0;
    Chromium_Ca_M3_s0 = (9.96E-01-0)*rand(n,1)+0;
    Cobalt_Ca_M3_s0 = (0.2-0)*rand(n,1)+0;
    Lead_Ca_M3_s0 = (2.72-0)*rand(n,1)+0;
    Manganese_Ca_M3_s0 = (3.63E+01-0)*rand(n,1)+0;
    Vanadium_Ca_M3_s0 = (0.909-0)*rand(n,1)+0;
    Zinc_Ca_M3_s0 = (5.74E+01-0)*rand(n,1)+0;
    Barium_Ca_M3_s0 = (1.09E+01-0)*rand(n,1)+0;
    Boron_Ca_M3_s0 = (7.8-0)*rand(n,1)+0;
    Lithium_Ca_M3_s0 = (1.28-0)*rand(n,1)+0;
    Sulfur_Ca_M3_s0 = (1.42E+03-0)*rand(n,1)+0;
    Strontium_Ca_M3_s0 = (23.3-0)*rand(n,1)+0;

%DW Calcite
    Aluminium_DWCa_M3_s0 =(13.4-0)*rand(n,1)+0;
    Barium_DWCa_M3_s0 = (0.6-0)*rand(n,1)+0;
    Calcium_DWCa_M3_s0 = (173827-0)*rand(n,1)+0;
    Magnesium_DWCa_M3_s0 = (547-0)*rand(n,1)+0;
    Manganese_DWCa_M3_s0 = (11.6-0)*rand(n,1)+0;
    Potassium_DWCa_M3_s0 = (30.2-0)*rand(n,1)+0;
    Sodium_DWCa_M3_s0 = (24-0)*rand(n,1)+0;
    Strontium_DWCa_M3_s0 = (27.1-0)*rand(n,1)+0;


%NM3 composition

    Silicum_M3_s0 = 0.60.*Silicum_Ca_M3_s0 + 0.10* Silicum_Ce_M3_s0; 
    Aluminium_M3_s0 = 0.60.* Aluminium_Ca_M3_s0 + 0.10*Aluminium_Ce_M3_s0;
    Iron_M3_s0 = 0.60.*Iron_Ca_M3_s0 + 0.10*Iron_Ce_M3_s0;
    Calcium_M3_s0 =  0.60.*Cobalt_Ca_M3_s0 +0.10*Calcium_Ce_M3_s0;
    Magnesium_M3_s0 =0.60.*Magnesium_Ca_M3_s0+ 0.10* Manganese_Ce_M3_s0;
    Sodium_M3_s0 =  0.60.*Sodium_Ca_M3_s0 +0.10* Sodium_Ca_M3_s0;
    Titanium_M3_s0 =  0.60.*Titanium_Ca_M3_s0;
    Phosphorus_M3_s0 =  0.60.*Phosphorus_Ca_M3_s0 +0.10* Phosphorus_Ca_M3_s0;
    Potassium_M3_s0 = 0.60.*Potassium_Ca_M3_s0 +0.10* Potassium_Ce_M3_s0;
    Beryllium_M3_s0 = 0.60.*Beryllium_Ca_M3_s0;
    Chromium_M3_s0 = 0.60.*Chromium_Ca_M3_s0;
    Cobalt_M3_s0 = 0.60.*Cobalt_Ca_M3_s0;
    Lead_M3_s0 = 0.60.*Lead_Ca_M3_s0;
    Manganese_M3_s0 = 0.60.* Manganese_Ca_M3_s0 +0.10* Manganese_Ce_M3_s0;
    Vanadium_M3_s0 = 0.60.*Vanadium_Ca_M3_s0;
    Zinc_M3_s0 = 0.60.*Zinc_Ca_M3_s0 +0.10* Zinc_Ce_M3_s0;
    Barium_M3_s0= 0.60.*Barium_Ca_M3_s0 +0.10* Barium_Ce_M3_s0;
    Boron_M3_s0 = 0.60.*Boron_Ca_M3_s0 +0.10* Boron_Ce_M3_s0;
    Litium_M3_s0 = 0.60.*Lithium_Ca_M3_s0;
    Sulfur_M3_s0= 0.60.*Sulfur_Ca_M3_s0 +0.10* Sulfur_Ce_M3_s0;
    Strontium_M3_s0= 0.60.*Strontium_Ca_M3_s0 +0.10* Strontium_Ce_M3_s0;

    %Styrene_M3_s0 = randn(10000,1)*5.4E+03+Styrene_M3;
  
    NM3_M3_s0 = [Silicum_M3_s0 Aluminium_M3_s0 Iron_M3_s0 Calcium_M3_s0 Magnesium_M3_s0 Sodium_M3_s0 Titanium_M3_s0 Phosphorus_M3_s0 Potassium_M3_s0 Beryllium_M3_s0 Chromium_M3_s0 Cobalt_M3_s0 Lead_M3_s0 Manganese_M3_s0 Vanadium_M3_s0 Zinc_M3_s0 Barium_M3_s0 Boron_M3_s0 Litium_M3_s0 Sulfur_M3_s0 Strontium_M3_s0 Styrene_M3_s0];


%Exposure assessment - Ingestion 
    NM3_s0_ing = [Aluminium_M3_s0, Iron_M3_s0 Magnesium_M3_s0 Sodium_M3_s0 Titanium_M3_s0 Phosphorus_M3_s0 Beryllium_M3_s0 Chromium_M3_s0 Cobalt_M3_s0 Lead_M3_s0 Manganese_M3_s0 Vanadium_M3_s0 Zinc_M3_s0 Barium_M3_s0 Boron_M3_s0 Litium_M3_s0 Strontium_M3_s0 Styrene_M3_s0];
    DingNM3_M3_s0 = ((NM3_s0_ing./1000)*IngR*Ef*Ed)/(BW*AT);
    RfD_ing_NM3 = [1.00, 0.7, 11, 19, 3, 49, 2E-03, 3E-03, 3E-04, 4E-03, 2.4E-02, 5.04E-03, 3E-01, 2E-01, 2E-01, 2E-03, 6E-01, 2E-01];

%Risk Quotient - Ingestion (Reed)
    RQ_Al_ing_M3_s0 = DingNM3_M3_s0(:,1)./RfD_ing_NM3(1);
    RQ_Fe_ing_M3_s0 = DingNM3_M3_s0(:,2)./RfD_ing_NM3(2);
    RQ_Mg_ing_M3_s0 = DingNM3_M3_s0(:,3)./RfD_ing_NM3(3);
    RQ_Na_ing_M3_s0 = DingNM3_M3_s0(:,4)./RfD_ing_NM3(4);
    RQ_Ti_ing_M3_s0 = DingNM3_M3_s0(:,5)./RfD_ing_NM3(5);
    RQ_P_ing_M3_s0  = DingNM3_M3_s0(:,6)./RfD_ing_NM3(6);
    RQ_Be_ing_M3_s0 = DingNM3_M3_s0(:,7)./RfD_ing_NM3(7);
    RQ_Cr_ing_M3_s0 = DingNM3_M3_s0(:,8)./RfD_ing_NM3(8);
    RQ_Co_ing_M3_s0 = DingNM3_M3_s0(:,9)./RfD_ing_NM3(9);
    RQ_Pb_ing_M3_s0 = DingNM3_M3_s0(:,10)./RfD_ing_NM3(10);
    RQ_Mn_ing_M3_s0 = DingNM3_M3_s0(:,11)./RfD_ing_NM3(11);
    RQ_V_ing_M3_s0  = DingNM3_M3_s0(:,12)./RfD_ing_NM3(12);
    RQ_Zn_ing_M3_s0 = DingNM3_M3_s0(:,13)./RfD_ing_NM3(13);
    RQ_Ba_ing_M3_s0 = DingNM3_M3_s0(:,14)./RfD_ing_NM3(14);
    RQ_B_ing_M3_s0 = DingNM3_M3_s0(:,15)./RfD_ing_NM3(15);
    RQ_Li_ing_M3_s0 = DingNM3_M3_s0(:,16)./RfD_ing_NM3(16);
    RQ_Sr_ing_M3_s0 = DingNM3_M3_s0(:,17)./RfD_ing_NM3(17);
    RQ_ing_Styrene_M3_s0 = DingNM3_M3_s0(:,18)./RfD_ing_NM3(18);

%Exposure assessment: inhalation
    NM3_inh_s0 = [Silicum_M3_s0, Aluminium_M3_s0, Magnesium_M3_s0, Beryllium_M3_s0, Chromium_M3_s0, Cobalt_M3_s0, Manganese_M3_s0, Vanadium_M3_s0, Barium_M3_s0, Boron_M3_s0, Styrene_M3_s0];
    DinhNM3_M3_s0 = (NM3_inh_s0* Et* Ed * Ef* InhR)/(PEF*AT*BW);
    RfD_inh_NM3 = [6.14E-04; 1.02E-03; 2.05E-02; 4.1E-06; 2.05E-05; 1.23E-06; 1.02E-05; 2.05E-05; 1.02E-04; 4.1E-03; 1.84E-01];

   
%%Risk Quotient - Inhalation 
    RQ_Si_inh_M3_s0 = DinhNM3_M3_s0(:,1)./RfD_inh_NM3(1);
    RQ_Al_inh_M3_s0 = DinhNM3_M3_s0(:,2)./RfD_inh_NM3(2);
    RQ_Mg_inh_M3_s0 = DinhNM3_M3_s0(:,3)./RfD_inh_NM3(3);
    RQ_Be_inh_M3_s0 = DinhNM3_M3_s0(:,4)./RfD_inh_NM3(4);
    RQ_Cr_inh_M3_s0 = DinhNM3_M3_s0(:,5)./RfD_inh_NM3(5);
    RQ_Co_inh_M3_s0 = DinhNM3_M3_s0(:,6)./RfD_inh_NM3(6);
    RQ_Mn_inh_M3_s0 = DinhNM3_M3_s0(:,7)./RfD_inh_NM3(7);
    RQ_V_inh_M3_s0  = DinhNM3_M3_s0(:,8)./RfD_inh_NM3(8);
    RQ_Ba_inh_M3_s0 = DinhNM3_M3_s0(:,9)./RfD_inh_NM3(9);
    RQ_B_inh_M3_s0 = DinhNM3_M3_s0(:,10)./RfD_inh_NM3(10);
    RQ_inh_Styrene_M3_s0 = DinhNM3_M3_s0(:,11)./RfD_inh_NM3(11);


%RQ_inh_M3 = [RQ_Si_inh_M3_s0 RQ_Al_inh_M3_s0 RQ_Fe_inh_M3_s0 RQ_Ca_inh_M3_s0 RQ_Mg_inh_M3_s0 RQ_Na_inh_M3_s0 RQ_Ti_inh_M3_s0 RQ_P_inh_M3_s0 RQ_K_inh_M3_s0 RQ_Sb_inh_M3_s0 RQ_As_inh_M3_s0 RQ_Be_inh_M3_s0 RQ_Cd_inh_M3_s0 RQ_Cr_inh_M3_s0 RQ_Co_inh_M3_s0 RQ_Cu_inh_M3_s0 RQ_Pb_inh_M3_s0 RQ_Mn_inh_M3_s0 RQ_Hg_inh_M3_s0 RQ_Mo_inh_M3_s0 RQ_Ni_inh_M3_s0 RQ_V_inh_M3_s0 RQ_Zn_inh_M3_s0 RQ_Ba_inh_M3_s0 RQ_B_inh_M3_s0 RQ_Li_inh_M3_s0 RQ_Ag_inh_M3_s0 RQ_Tl_inh_M3_s0 RQ_Sn_inh_M3_s0 RQ_Se_inh_M3_s0 RQ_Bi_inh_M3_s0 RQ_S_inh_M3_s0 RQ_Sr_inh_M3_s0 RQ_Te_inh_M3_s0 RQ_Zr_inh_M3_s0 RQ_inh_Styrene_M3_s0];
%RQ_tot_inh_M3 = sum(RQ_inh_M3);
%styrene exposure: assuming the exposure only via inhalation and calculated as an extimation of the maximum potential inhalation. 

%Dermal exposure
    N0M3_derm_s0 =[Aluminium_M3_s0 Magnesium_M3_s0 Sodium_M3_s0 Phosphorus_M3_s0 Beryllium_M3_s0 Chromium_M3_s0 Cobalt_M3_s0 Lead_M3_s0 Manganese_M3_s0 Vanadium_M3_s0 Zinc_M3_s0 Barium_M3_s0 Boron_M3_s0 Litium_M3_s0 Strontium_M3_s0 Styrene_M3_s0];
    DA_derm_face_M3_s0 = ((N0M3_derm_s0./1000).*AF_face); %g/cM3-ev
    DA_derm_hand_M3_s0 = ((N0M3_derm_s0./1000).*AF_hands); %g/cM3-ev
   
    ADD_derm_face_M3_s0 = (DA_derm_face_M3_s0*SA_face*Ef*Ed)/(AT*BW); % mg/kg-day
    ADD_derm_hand_M3_s0 = (DA_derm_hand_M3_s0*SA_hand*Ef*Ed)/(AT*BW); % mg/kg-day

    ADD_derm_M3 = ADD_derm_hand_M3_s0 + ADD_derm_face_M3_s0;
    RfD_derm_M3 = [1.00; 11; 19; 49; 1.4E-05; 7.5E-05; 3E-04; 4E-03; 9.6E-04; 1.31E-04; 3E-01; 1.4E-02; 2E-01; 2E-03; 6E-01; 2E-01];


    RQ_Al_derm_M3_s0 = ADD_derm_M3(:,1)./RfD_derm_M3(1);
    RQ_Mg_derm_M3_s0 = ADD_derm_M3(:,2)./RfD_derm_M3(2);
    RQ_Na_derm_M3_s0 = ADD_derm_M3(:,3)./RfD_derm_M3(3);
    RQ_P_derm_M3_s0  = ADD_derm_M3(:,4)./RfD_derm_M3(4);
    RQ_Be_derm_M3_s0 = ADD_derm_M3(:,5)./RfD_derm_M3(5);
    RQ_Cr_derm_M3_s0 = ADD_derm_M3(:,6)./RfD_derm_M3(6);
    RQ_Co_derm_M3_s0 = ADD_derm_M3(:,7)./RfD_derm_M3(7);
    RQ_Pb_derm_M3_s0 = ADD_derm_M3(:,8)./RfD_derm_M3(8);
    RQ_Mn_derm_M3_s0 = ADD_derm_M3(:,9)./RfD_derm_M3(9);
    RQ_V_derm_M3_s0  = ADD_derm_M3(:,10)./RfD_derm_M3(10);
    RQ_Zn_derm_M3_s0 = ADD_derm_M3(:,11)./RfD_derm_M3(11);
    RQ_Ba_derm_M3_s0 = ADD_derm_M3(:,12)./RfD_derm_M3(12);
    RQ_B_derm_M3_s0 = ADD_derm_M3(:,13)./RfD_derm_M3(13);
    RQ_Li_derm_M3_s0 = ADD_derm_M3(:,14)./RfD_derm_M3(14);
    RQ_Sr_derm_M3_s0 = ADD_derm_M3(:,15)./RfD_derm_M3(15);
    RQ_styrene_derm_M3_s0 = ADD_derm_M3(:,16)./RfD_derm_M3(16);

%Risk Characterization

    RI_Si_M3_s0 = RQ_Si_inh_M3_s0;
    RI_Al_M3_s0 = RQ_Al_ing_M3_s0 + RQ_Al_inh_M3_s0 + RQ_Al_derm_M3_s0;
    RI_Fe_M3_s0 = RQ_Fe_ing_M3_s0;
    RI_Mg_M3_s0 = RQ_Mg_ing_M3_s0 + RQ_Mg_inh_M3_s0 + RQ_Mg_derm_M3_s0;
    RI_Na_M3_s0 = RQ_Na_ing_M3_s0 + RQ_Na_derm_M3_s0;
    RI_Ti_M3_s0 = RQ_Ti_ing_M3_s0;
    RI_P_M3_s0  = RQ_P_ing_M3_s0  + RQ_P_derm_M3_s0;
    RI_Be_M3_s0 = RQ_Be_ing_M3_s0 + RQ_Be_inh_M3_s0 + RQ_Be_derm_M3_s0;
    RI_Cr_M3_s0 = RQ_Cr_ing_M3_s0 + RQ_Cr_inh_M3_s0 + RQ_Cr_derm_M3_s0;
    RI_Co_M3_s0 = RQ_Co_ing_M3_s0 + RQ_Co_inh_M3_s0 + RQ_Co_derm_M3_s0;
    RI_Pb_M3_s0 = RQ_Pb_ing_M3_s0 + RQ_Pb_derm_M3_s0;
    RI_Mn_M3_s0 = RQ_Mn_ing_M3_s0 + RQ_Mn_inh_M3_s0 + RQ_Mn_derm_M3_s0;
    RI_V_M3_s0  = RQ_V_ing_M3_s0  + RQ_V_inh_M3_s0  + RQ_V_derm_M3_s0;
    RI_Zn_M3_s0 = RQ_Zn_ing_M3_s0 + RQ_Zn_derm_M3_s0;
    RI_Ba_M3_s0 = RQ_Ba_ing_M3_s0 + RQ_Ba_inh_M3_s0 + RQ_Ba_derm_M3_s0;
    RI_B_M3_s0 = RQ_B_ing_M3_s0 + RQ_B_inh_M3_s0 + RQ_B_derm_M3_s0;
    RI_Li_M3_s0 = RQ_Li_ing_M3_s0 + RQ_Li_derm_M3_s0;
    RI_Sr_M3_s0 = RQ_Sr_ing_M3_s0 + RQ_Sr_derm_M3_s0;
    RI_Styrene_M3_s0 = RQ_ing_Styrene_M3_s0 + RQ_inh_Styrene_M3_s0 + RQ_styrene_derm_M3_s0;
    
    RI_NM3_s0 = [RI_Si_M3_s0 RI_Al_M3_s0 RI_Fe_M3_s0 RI_Mg_M3_s0 RI_Na_M3_s0 RI_Ti_M3_s0 RI_P_M3_s0 RI_Be_M3_s0 RI_Cr_M3_s0 RI_Co_M3_s0 RI_Pb_M3_s0 RI_Mn_M3_s0 RI_V_M3_s0 RI_Zn_M3_s0 RI_Ba_M3_s0 RI_B_M3_s0 RI_Li_M3_s0 RI_Sr_M3_s0 RI_Styrene_M3_s0];
    
    RItot_NM3_s0 = sum(RI_NM3_s0.');
    
end 
    %RI_NM3_M3_s0 = [sum(RI_Si_M3_s0) sum(RI_Al_M3_s0) sum(RI_Fe_M3_s0) sum(RI_Ca_M3_s0) sum(RI_Mg_M3_s0) sum(RI_Na_M3_s0) sum(RI_Ti_M3_s0) sum(RI_P_M3_s0) sum(RI_K_M3_s0) sum(RI_Sb_M3_s0) sum(RI_As_M3_s0) sum(RI_Be_M3_s0) sum(RI_Cd_M3_s0) sum(RI_Cr_M3_s0) sum(RI_Co_M3_s0) sum(RI_Cu_M3_s0) sum(RI_Pb_M3_s0) sum(RI_Mn_M3_s0) sum(RI_Hg_M3_s0) sum(RI_Mo_M3_s0) sum(RI_Ni_M3_s0) sum(RI_V_M3_s0) sum(RI_Zn_M3_s0) sum(RI_Ba_M3_s0) sum(RI_B_M3_s0) sum(RI_Li_M3_s0) sum(RI_Ag_M3_s0) sum(RI_Tl_M3_s0) sum(RI_Sn_M3_s0) sum(RI_Se_M3_s0) sum(RI_Bi_M3_s0) sum(RI_S_M3_s0) sum(RI_Sr_M3_s0) sum(RI_Te_M3_s0) sum(RI_Zr_M3_s0) sum(RI_Styrene_M3_s0)];

% boxplot(RItot_NM3_s0)
% set(gca, 'YScale', 'log')
% ylim([0 2]);
% yline(1,'-','Threshold');
% title("RI Material 1 - Sesntivity 0 approach");
% xlabel("Material");
% ylabel("Risk Index");
% xticks(1)
% xticklabels("Sensitivity 0 M3")
%xticks([1 2 3 4 5 6 7 8 9 10 11 12 13 14 15 16 17 18 19]);
%xticklabels({'Si','Al','Fe','Mg','Na','Ti','P','Be','Cr','Co','Pb','Mn','V','Zn','Ba' ,'B','Li', 'Sr','Styrene'});
%xlim([0 20]);

%Sensitivity 1
n=10000;
for i =1:n
    v1 = 1.2;
    M3 = 30; %mg/day
    mu1 = log((M3.^2)./sqrt(v1+(M3.^2)));
    sigma1 = sqrt(log(v1./(M3.^2)+1));
    IngR_s1 = lognrnd(mu1,sigma1,n,1);
    %IngR_s1 = randn(n,1)*0.0012+IngR;
    %InhR_s1 = randn(n,1)*0.0051+InhR;

    v = 0.753;
    m = 1.55E+01;
    mu = log((m^2)/sqrt(v+m^2));
    sigma = sqrt(log(v/(m^2)+1));
    InhR_s1 = lognrnd(mu,sigma,n,1);

    %Adh_face_s1 = randn(n,1)*1.4500e-06+Adh_face;
    v_face = 24200;
    mu_face = log((SA_head^2)/sqrt(v_face+SA_head^2));
    sigma_face = sqrt(log(v_face/(SA_head^2)+1));
    SA_head_s1 = lognrnd(mu_face, sigma_face,n,1);

    v_hands = 16200;
    mu_hands = log((SA_hand^2)/sqrt(v_hands+SA_hand^2));
    sigma_hand = sqrt(log(v_hands/(SA_hand^2)+1));
    SA_hand_s1 = lognrnd(mu_hands, sigma_hand, n,1);

    %Adh_hand_s1 = randn(n,1)*9.6000e-06+Adh_hand;

    DingM3_s1 = ((IngR_s1./1000).* M3_det_ing'./1000*Ef*Ed)./(BW*AT);
    RfD_ing_M3 = [1E00; 2E-01; 2E-03; 2E-01; 3E-04; 7E-01; 2E-03; 1.1E+01; 2.4E-02; 4.9E+01; 1.9E+01; 3E00; 5.04E-03; 3E-01; 3E-03; 4E-03; 6E-01; 2E-01];

%Ding_Styrene_s1 = (IngR_s1.*(Styrene_M3/1000)*Ef*Ed)/(BW*AT);

%Risk Quotient - Ingestion 
RQ_Al_ing_M3_s1 = DingM3_s1(:,1)/RfD_ing_M3(1);
RQ_Ba_ing_M3_s1 = DingM3_s1(:,2)/RfD_ing_M3(2);
RQ_Be_ing_M3_s1 = DingM3_s1(:,3)/RfD_ing_M3(3);
RQ_B_ing_M3_s1  = DingM3_s1(:,4)/RfD_ing_M3(4);
RQ_Co_ing_M3_s1 = DingM3_s1(:,5)/RfD_ing_M3(5);
RQ_Fe_ing_M3_s1 = DingM3_s1(:,6)/RfD_ing_M3(6);
RQ_Li_ing_M3_s1 = DingM3_s1(:,7)/RfD_ing_M3(7);
RQ_Mg_ing_M3_s1 = DingM3_s1(:,8)/RfD_ing_M3(8);
RQ_Mn_ing_M3_s1 = DingM3_s1(:,9)/RfD_ing_M3(9);
RQ_P_ing_M3_s1  = DingM3_s1(:,10)/RfD_ing_M3(10);
RQ_Na_ing_M3_s1 = DingM3_s1(:,11)/RfD_ing_M3(11);
RQ_Ti_ing_M3_s1 = DingM3_s1(:,12)/RfD_ing_M3(12);
RQ_V_ing_M3_s1  = DingM3_s1(:,13)/RfD_ing_M3(13);
RQ_Zn_ing_M3_s1 = DingM3_s1(:,14)/RfD_ing_M3(14);
RQ_Cr_ing_M3_s1 = DingM3_s1(:,15)/RfD_ing_M3(15);
RQ_Pb_ing_M3_s1 = DingM3_s1(:,16)/RfD_ing_M3(16);
RQ_Sr_ing_M3_s1 = DingM3_s1(:,17)/RfD_ing_M3(17);
RQ_ing_Styrene_s1_M3 = DingM3_s1(:,18)/RfD_ing_M3(18);


%RQ_ing_M3_s1 = [RQ_Al_ing_M3_s1 RQ_Fe_ing_M3_s1 RQ_Mg_ing_M3_s1 RQ_Na_ing_M3_s1 RQ_Ti_ing_M3_s1 RQ_P_ing_M3_s1 RQ_Be_ing_M3_s1 RQ_Cr_ing_M3_s1 RQ_Co_ing_M3_s1 RQ_Pb_ing_M3_s1 RQ_Mn_ing_M3_s1 RQ_V_ing_M3_s1 RQ_Zn_ing_M3_s1 RQ_Ba_ing_M3_s1 RQ_B_ing_M3_s1 RQ_Li_ing_M3_s1 RQ_Sr_ing_M3_s1 RQ_ing_Styrene_s1];

%RQ_tot_ing_M3_s1 = sum(RQ_ing_M3_s1);
%Exposure assessment: inhalation

    DinhM3_s1 = (M3_inh_det'.* Et.* Ed.* Ef.*(InhR_s1./24))./(PEF.*AT.*BW);
    RfD_inh_M3 = [1.02E-03; 1.02E-04; 4.09E-06; 4.09E-03; 1.23E-06; 2.05E-02; 1.02E-05; 2.05E-05; 2.05E-05; 6.14E-04; 1.84E-01];

    
%Risk Quotient - Inhalation 
RQ_Al_inh_M3_s1 = DinhM3_s1(:,1)/RfD_inh_M3(1);
RQ_Ba_inh_M3_s1 = DinhM3_s1(:,2)/RfD_inh_M3(2);
RQ_Be_inh_M3_s1 = DinhM3_s1(:,3)/RfD_inh_M3(3);
RQ_B_inh_M3_s1  = DinhM3_s1(:,4)/RfD_inh_M3(4);
RQ_Co_inh_M3_s1 = DinhM3_s1(:,5)/RfD_inh_M3(5);
RQ_Mg_inh_M3_s1 = DinhM3_s1(:,6)/RfD_inh_M3(6);
RQ_Mn_inh_M3_s1 = DinhM3_s1(:,7)/RfD_inh_M3(7);
RQ_V_inh_M3_s1  = DinhM3_s1(:,8)/RfD_inh_M3(8);
RQ_Cr_inh_M3_s1 = DinhM3_s1(:,9)/RfD_inh_M3(9);
RQ_Si_inh_M3_s1 = DinhM3_s1(:,10)/RfD_inh_M3(10);
RQ_inh_Styrene_s1_M3 = DinhM3_s1(:,11)/RfD_inh_M3(11);


%RQ_inh_M3 = [RQ_Si_inh_M3_s1 RQ_Al_inh_M3_s1 RQ_Fe_inh_M3_s1 RQ_Ca_inh_M3_s1 RQ_Mg_inh_M3_s1 RQ_Na_inh_M3_s1 RQ_Ti_inh_M3_s1 RQ_P_inh_M3_s1 RQ_K_inh_M3_s1 RQ_Sb_inh_M3_s1 RQ_As_inh_M3_s1 RQ_Be_inh_M3_s1 RQ_Cd_inh_M3_s1 RQ_Cr_inh_M3_s1 RQ_Co_inh_M3_s1 RQ_Cu_inh_M3_s1 RQ_Pb_inh_M3_s1 RQ_Mn_inh_M3_s1 RQ_Hg_inh_M3_s1 RQ_Mo_inh_M3_s1 RQ_Ni_inh_M3_s1 RQ_V_inh_M3_s1 RQ_Zn_inh_M3_s1 RQ_Ba_inh_M3_s1 RQ_B_inh_M3_s1 RQ_Li_inh_M3_s1 RQ_Ag_inh_M3_s1 RQ_Tl_inh_M3_s1 RQ_Sn_inh_M3_s1 RQ_Se_inh_M3_s1 RQ_Bi_inh_M3_s1 RQ_S_inh_M3_s1 RQ_Sr_inh_M3_s1 RQ_Te_inh_M3_s1 RQ_Zr_inh_M3_s1 RQ_inh_Styrene_s1];
%RQ_tot_inh_M3 = sum(RQ_inh_M3);
%styrene exposure: assuming the exposure only via inhalation and calculated as an extimation of the maximum potential inhalation. 

%Dermal exposure
     
    DA_derm_face_s1 = ((M3_det_derm'./1000).*Adh_face); %g/cM3-ev
    DA_derm_hand_s1 = ((M3_det_derm'./1000).*Adh_hand); %g/cM3-ev
    
    ADD_derm_face_s1 = (DA_derm_face_s1.*SA_head_s1.*Ef.*Ed)./(AT.*BW); % mg/kg-day
    ADD_derm_hand_s1 = (DA_derm_hand_s1.*SA_hand_s1.*Ef.*Ed)./(AT.*BW); % mg/kg-day
    
    ADD_derm_M3_s1 = ADD_derm_hand_s1 + ADD_derm_face_s1;
    RfD_derm_M3 = [1; 1.4E-02; 1.4E-05; 2E-01; 3E-04; 2E-03; 1.1E+01; 9.6E-04; 4.9E+01; 1.9E+01; 1.31E-04; 3E-01; 7.5E-05; 6E-01; 2E-01];


RQ_Al_derm_M3_s1 = ADD_derm_M3_s1(:,1)/RfD_derm_M3(1);
RQ_Ba_derm_M3_s1 = ADD_derm_M3_s1(:,2)/RfD_derm_M3(2);
RQ_Be_derm_M3_s1 = ADD_derm_M3_s1(:,3)/RfD_derm_M3(3);
RQ_B_derm_M3_s1  = ADD_derm_M3_s1(:,4)/RfD_derm_M3(4);
RQ_Co_derm_M3_s1 = ADD_derm_M3_s1(:,5)/RfD_derm_M3(5);
RQ_Li_derm_M3_s1 = ADD_derm_M3_s1(:,6)/RfD_derm_M3(6);
RQ_Mg_derm_M3_s1 = ADD_derm_M3_s1(:,7)/RfD_derm_M3(7);
RQ_Mn_derm_M3_s1 = ADD_derm_M3_s1(:,8)/RfD_derm_M3(8);
RQ_P_derm_M3_s1  = ADD_derm_M3_s1(:,9)/RfD_derm_M3(9);
RQ_Na_derm_M3_s1 = ADD_derm_M3_s1(:,10)/RfD_derm_M3(10);
RQ_V_derm_M3_s1  = ADD_derm_M3_s1(:,11)/RfD_derm_M3(11);
RQ_Zn_derm_M3_s1 = ADD_derm_M3_s1(:,12)/RfD_derm_M3(12);
RQ_Cr_derm_M3_s1 = ADD_derm_M3_s1(:,13)/RfD_derm_M3(13);
RQ_Sr_derm_M3_s1 = ADD_derm_M3_s1(:,14)/RfD_derm_M3(14);
RQ_styrene_derm_M3_s1 = ADD_derm_M3_s1(:,15)/RfD_derm_M3(15);

%Risk Characterization

    RI_Si_M3_s1 = RQ_Si_inh_M3_s1;
    RI_Al_M3_s1 = RQ_Al_ing_M3_s1 + RQ_Al_inh_M3_s1 + RQ_Al_derm_M3_s1;
    RI_Fe_M3_s1 = RQ_Fe_ing_M3_s1;
    RI_Mg_M3_s1 = RQ_Mg_ing_M3_s1 + RQ_Mg_inh_M3_s1 + RQ_Mg_derm_M3_s1;
    RI_Na_M3_s1 = RQ_Na_ing_M3_s1 + RQ_Na_derm_M3_s1;
    RI_Ti_M3_s1 = RQ_Ti_ing_M3_s1;
    RI_P_M3_s1  = RQ_P_ing_M3_s1  + RQ_P_derm_M3_s1;
    RI_Be_M3_s1 = RQ_Be_ing_M3_s1 + RQ_Be_inh_M3_s1 + RQ_Be_derm_M3_s1;
    RI_Cr_M3_s1 = RQ_Cr_ing_M3_s1 + RQ_Cr_inh_M3_s1 + RQ_Cr_derm_M3_s1;
    RI_Co_M3_s1 = RQ_Co_ing_M3_s1 + RQ_Co_inh_M3_s1 + RQ_Co_derm_M3_s1;
    RI_Pb_M3_s1 = RQ_Pb_ing_M3_s1;
    RI_Mn_M3_s1 = RQ_Mn_ing_M3_s1 + RQ_Mn_inh_M3_s1 + RQ_Mn_derm_M3_s1;
    RI_V_M3_s1  = RQ_V_ing_M3_s1  + RQ_V_inh_M3_s1  + RQ_V_derm_M3_s1;
    RI_Zn_M3_s1 = RQ_Zn_ing_M3_s1 + RQ_Zn_derm_M3_s1;
    RI_Ba_M3_s1 = RQ_Ba_ing_M3_s1 + RQ_Ba_inh_M3_s1 + RQ_Ba_derm_M3_s1;
    RI_B_M3_s1 = RQ_B_ing_M3_s1 + RQ_B_inh_M3_s1 + RQ_B_derm_M3_s1;
    RI_Li_M3_s1 = RQ_Li_ing_M3_s1 + RQ_Li_derm_M3_s1;
    RI_Sr_M3_s1 = RQ_Sr_ing_M3_s1 + RQ_Sr_derm_M3_s1;
    RI_Styrene_M3_s1 = RQ_ing_Styrene_s1_M3 + RQ_inh_Styrene_s1_M3 + RQ_styrene_derm_M3_s1;
    
    RI_M3_s1 = [RI_Si_M3_s1 RI_Al_M3_s1 RI_Fe_M3_s1 RI_Mg_M3_s1 RI_Na_M3_s1 RI_Ti_M3_s1 RI_P_M3_s1 RI_Be_M3_s1 RI_Cr_M3_s1 RI_Co_M3_s1 RI_Pb_M3_s1 RI_Mn_M3_s1 RI_V_M3_s1 RI_Zn_M3_s1 RI_Ba_M3_s1 RI_B_M3_s1 RI_Li_M3_s1 RI_Sr_M3_s1 RI_Styrene_M3_s1];
   
    
    RItot_NM3_s1 = sum(RI_M3_s1.');
    
end 

    % %test = [RItot_NM3_s0.' RItot_NM3_s1.'];
    % boxplot(RItot_NM3_s1);
    % %set(gca, 'YScale', 'log')
    % yline(1,'-','Threshold');
    % title("RI Material 1 - Sesntivity 1 approach");
    % xlabel("Material");
    % ylabel("Risk Index");
    % xticks(1)
    % xticklabels("Sensitivity 1 M3")
    %xticks([1 2 3 4 5 6 7 8 9 10 11 12 13 14 15 16 17 18 19]);
    %xticklabels({'Si','Al','Fe','Mg','Na','Ti','P','Be','Cr','Co','Pb','Mn','V','Zn','Ba' ,'B','Li', 'Sr','Styrene'});
    %xlim([0 20]);    
    %xticks([1 2 3 4 5 6 7 8 9 10 11 12 13 14 15 16 17 18 19]);
    %xticklabels({'Si','Al','Fe','Mg','Na','Ti','P','Be','Cr','Co','Pb','Mn','V','Zn','Ba' ,'B','Li', 'Sr','Styrene'});
    %xlim([0 20]);
    %legend('Si','Al','Fe','Ca','Mg','Na','Ti','P','K','Sb','As','Be','Cd','Cr','Co','Cu','Pb','Mn','Hg','Mo','Ni','V','Zn','Ba' ,'B','Li', 'Ag','Tl','Sn','Se','Bi','S','Sr','Te','Zr','Styrene');

    %sensitivity 2
n=10000;
for i =1:n
    v_ef = 0.0274; 
    mu_ef = log(((6.85E-01)^2)./sqrt(v_ef+(6.85E-01)^2));
    sigma_ef = sqrt(log(v_ef./((6.85E-01)^2)+1));
    Ef_s2 = lognrnd(mu_ef, sigma_ef, n,1);
    
    DingM3_s2 = ((M3_det_ing'./1000).*IngR.*Ed.*Ef_s2)./(BW.*AT);
    RfD_ing_M3 = [1E00; 2E-01; 2E-03; 2E-01; 3E-04; 7E-01; 2E-03; 1.1E+01; 2.4E-02; 4.9E+01; 1.9E+01; 3E00; 5.04E-03; 3E-01; 3E-03; 4E-03; 6E-01; 2E-01];

%Ding_Styrene_s2 = (IngR_s2.*(Styrene_M3/1000)*Ef*Ed)/(BW*AT);

%Risk Quotient - Ingestion 
RQ_Al_ing_M3_s2 = DingM3_s2(:,1)/RfD_ing_M3(1);
RQ_Ba_ing_M3_s2 = DingM3_s2(:,2)/RfD_ing_M3(2);
RQ_Be_ing_M3_s2 = DingM3_s2(:,3)/RfD_ing_M3(3);
RQ_B_ing_M3_s2  = DingM3_s2(:,4)/RfD_ing_M3(4);
RQ_Co_ing_M3_s2 = DingM3_s2(:,5)/RfD_ing_M3(5);
RQ_Fe_ing_M3_s2 = DingM3_s2(:,6)/RfD_ing_M3(6);
RQ_Li_ing_M3_s2 = DingM3_s2(:,7)/RfD_ing_M3(7);
RQ_Mg_ing_M3_s2 = DingM3_s2(:,8)/RfD_ing_M3(8);
RQ_Mn_ing_M3_s2 = DingM3_s2(:,9)/RfD_ing_M3(9);
RQ_P_ing_M3_s2  = DingM3_s2(:,10)/RfD_ing_M3(10);
RQ_Na_ing_M3_s2 = DingM3_s2(:,11)/RfD_ing_M3(11);
RQ_Ti_ing_M3_s2 = DingM3_s2(:,12)/RfD_ing_M3(12);
RQ_V_ing_M3_s2  = DingM3_s2(:,13)/RfD_ing_M3(13);
RQ_Zn_ing_M3_s2 = DingM3_s2(:,14)/RfD_ing_M3(14);
RQ_Cr_ing_M3_s2 = DingM3_s2(:,15)/RfD_ing_M3(15);
RQ_Pb_ing_M3_s2 = DingM3_s2(:,16)/RfD_ing_M3(16);
RQ_Sr_ing_M3_s2 = DingM3_s2(:,17)/RfD_ing_M3(17);
RQ_ing_Styrene_s2_M3 = DingM3_s2(:,18)/RfD_ing_M3(18);


%RQ_ing_M3_s2 = [RQ_Al_ing_M3_s2 RQ_Fe_ing_M3_s2 RQ_Mg_ing_M3_s2 RQ_Na_ing_M3_s2 RQ_Ti_ing_M3_s2 RQ_P_ing_M3_s2 RQ_Sb_ing_M3_s2 RQ_Be_ing_M3_s2 RQ_Cr_ing_M3_s2 RQ_Co_ing_M3_s2 RQ_Cu_ing_M3_s2 RQ_Pb_ing_M3_s2 RQ_Mn_ing_M3_s2 RQ_Hg_ing_M3_s2 RQ_Mo_ing_M3_s2 RQ_Ni_ing_M3_s2 RQ_V_ing_M3_s2 RQ_Zn_ing_M3_s2 RQ_Ba_ing_M3_s2 RQ_B_ing_M3_s2 RQ_Li_ing_M3_s2 RQ_Sn_ing_M3_s2 RQ_Sr_ing_M3_s2 RQ_ing_Styrene_s2];

%RQ_tot_ing_M3_s2 = sum(RQ_ing_M3_s2);
%Exposure assessment: inhalation

    DinhM3_s2 = (M3_inh_det'.*Et.*Ed.*(Ef_s2).*InhR)./(PEF.*AT.*BW);
    RfD_inh_M3 = [1.02E-03; 1.02E-04; 4.09E-06; 4.09E-03; 1.23E-06; 2.05E-02; 1.02E-05; 2.05E-05; 2.05E-05; 6.14E-04; 1.84E-01];

%Risk Quotient - Inhalation 
RQ_Al_inh_M3_s2 = DinhM3_s2(:,1)/RfD_inh_M3(1);
RQ_Ba_inh_M3_s2 = DinhM3_s2(:,2)/RfD_inh_M3(2);
RQ_Be_inh_M3_s2 = DinhM3_s2(:,3)/RfD_inh_M3(3);
RQ_B_inh_M3_s2  = DinhM3_s2(:,4)/RfD_inh_M3(4);
RQ_Co_inh_M3_s2 = DinhM3_s2(:,5)/RfD_inh_M3(5);
RQ_Mg_inh_M3_s2 = DinhM3_s2(:,6)/RfD_inh_M3(6);
RQ_Mn_inh_M3_s2 = DinhM3_s2(:,7)/RfD_inh_M3(7);
RQ_V_inh_M3_s2  = DinhM3_s2(:,8)/RfD_inh_M3(8);
RQ_Cr_inh_M3_s2 = DinhM3_s2(:,9)/RfD_inh_M3(9);
RQ_Si_inh_M3_s2 = DinhM3_s2(:,10)/RfD_inh_M3(10);
RQ_inh_Styrene_s2_M3 = DinhM3_s2(:,11)/RfD_inh_M3(11);


%Dermal exposure
 DA_derm_face = ((M3_det_derm./1000).*Adh_face); %g/cM3-ev
 DA_derm_hand = ((M3_det_derm./1000).*Adh_hand); %g/cM3-ev
    
ADD_derm_face_M3_s2 = (DA_derm_face*SA_head*Ef_s2'*Ed)/(AT*BW); % mg/kg-day
ADD_derm_hand_M3_s2 = (DA_derm_hand*SA_hand*Ef_s2'*Ed)/(AT*BW); % mg/kg-day

ADD_derm_M3_s2 = ADD_derm_face_M3_s2' + ADD_derm_hand_M3_s2';

RfD_derm_M3 = [1; 1.4E-02; 1.4E-05; 2E-01; 3E-04; 2E-03; 1.1E+01; 9.6E-04; 4.9E+01; 1.9E+01; 1.31E-04; 3E-01; 7.5E-05; 6E-01; 2E-01];

RQ_Al_derm_M3_s2 = ADD_derm_M3_s2(:,1)/RfD_derm_M3(1);
RQ_Ba_derm_M3_s2 = ADD_derm_M3_s2(:,2)/RfD_derm_M3(2);
RQ_Be_derm_M3_s2 = ADD_derm_M3_s2(:,3)/RfD_derm_M3(3);
RQ_B_derm_M3_s2  = ADD_derm_M3_s2(:,4)/RfD_derm_M3(4);
RQ_Co_derm_M3_s2 = ADD_derm_M3_s2(:,5)/RfD_derm_M3(5);
RQ_Li_derm_M3_s2 = ADD_derm_M3_s2(:,6)/RfD_derm_M3(6);
RQ_Mg_derm_M3_s2 = ADD_derm_M3_s2(:,7)/RfD_derm_M3(7);
RQ_Mn_derm_M3_s2 = ADD_derm_M3_s2(:,8)/RfD_derm_M3(8);
RQ_P_derm_M3_s2  = ADD_derm_M3_s2(:,9)/RfD_derm_M3(9);
RQ_Na_derm_M3_s2 = ADD_derm_M3_s2(:,10)/RfD_derm_M3(10);
RQ_V_derm_M3_s2  = ADD_derm_M3_s2(:,11)/RfD_derm_M3(11);
RQ_Zn_derm_M3_s2 = ADD_derm_M3_s2(:,12)/RfD_derm_M3(12);
RQ_Cr_derm_M3_s2 = ADD_derm_M3_s2(:,13)/RfD_derm_M3(13);
RQ_Sr_derm_M3_s2 = ADD_derm_M3_s2(:,14)/RfD_derm_M3(14);
RQ_styrene_derm_M3_s2 = ADD_derm_M3_s2(:,15)/RfD_derm_M3(15);

%Risk Characterization

    RI_Si_M3_s2 = RQ_Si_inh_M3_s2;
    RI_Al_M3_s2 = RQ_Al_ing_M3_s2 + RQ_Al_inh_M3_s2 + RQ_Al_derm_M3_s2;
    RI_Fe_M3_s2 = RQ_Fe_ing_M3_s2;
    RI_Mg_M3_s2 = RQ_Mg_ing_M3_s2 + RQ_Mg_inh_M3_s2 + RQ_Mg_derm_M3_s2;
    RI_Na_M3_s2 = RQ_Na_ing_M3_s2 + RQ_Na_derm_M3_s2;
    RI_Ti_M3_s2 = RQ_Ti_ing_M3_s2;
    RI_P_M3_s2  = RQ_P_ing_M3_s2  + RQ_P_derm_M3_s2;
    RI_Be_M3_s2 = RQ_Be_ing_M3_s2 + RQ_Be_inh_M3_s2 + RQ_Be_derm_M3_s2;
    RI_Cr_M3_s2 = RQ_Cr_ing_M3_s2 + RQ_Cr_inh_M3_s2 + RQ_Cr_derm_M3_s2;
    RI_Co_M3_s2 = RQ_Co_ing_M3_s2 + RQ_Co_inh_M3_s2 + RQ_Co_derm_M3_s2;
    RI_Pb_M3_s2 = RQ_Pb_ing_M3_s2;
    RI_Mn_M3_s2 = RQ_Mn_ing_M3_s2 + RQ_Mn_inh_M3_s2 + RQ_Mn_derm_M3_s2;
    RI_V_M3_s2  = RQ_V_ing_M3_s2  + RQ_V_inh_M3_s2  + RQ_V_derm_M3_s2;
    RI_Zn_M3_s2 = RQ_Zn_ing_M3_s2 + RQ_Zn_derm_M3_s2;
    RI_Ba_M3_s2 = RQ_Ba_ing_M3_s2 + RQ_Ba_inh_M3_s2 + RQ_Ba_derm_M3_s2;
    RI_B_M3_s2 = RQ_B_ing_M3_s2 + RQ_B_inh_M3_s2 + RQ_B_derm_M3_s2;
    RI_Li_M3_s2 = RQ_Li_ing_M3_s2 + RQ_Li_derm_M3_s2;
    RI_Sr_M3_s2 = RQ_Sr_ing_M3_s2 + RQ_Sr_derm_M3_s2;
    RI_Styrene_M3_s2 = RQ_ing_Styrene_s2_M3 + RQ_inh_Styrene_s2_M3 + RQ_styrene_derm_M3_s2;
    
    RI_NM3_s2 = [RI_Si_M3_s2 RI_Al_M3_s2 RI_Fe_M3_s2 RI_Mg_M3_s2 RI_Na_M3_s2 RI_Ti_M3_s2 RI_P_M3_s2 RI_Be_M3_s2 RI_Cr_M3_s2 RI_Co_M3_s2 RI_Pb_M3_s2 RI_Mn_M3_s2 RI_V_M3_s2 RI_Zn_M3_s2 RI_Ba_M3_s2 RI_B_M3_s2 RI_Li_M3_s2 RI_Sr_M3_s2 RI_Styrene_M3_s2];

    
    RItot_NM3_s2 = sum(RI_NM3_s2');
end 

    % boxplot(RItot_NM3_s2);
    % set(gca, 'YScale', 'log')
    % yline(1,'-','Threshold');
    % title("RI Material 1 - Sesntivity 2 approach");
    % xlabel("Material");
    % ylabel("Risk Index");
    % xticks(1)
    % xticklabels("Sensitivity 2 M3")
  
    %Sensitiviy 3
for i =1:n
    
    v_bw = 35.28;
    mu_bw = log((BW^2)/sqrt(v_bw+BW^2));
    sigma_bw = sqrt(log(v_bw/(BW^2)+1));
    BW_s3 = lognrnd(mu_bw, sigma_bw, n,1);
    
    DingM3_s3 = ((M3_det_ing'./1000).*IngR.*Ed.*Ef)./(BW_s3.*AT);
    RfD_ing_M3 = [1E00; 2E-01; 2E-03; 2E-01; 3E-04; 7E-01; 2E-03; 1.1E+01; 2.4E-02; 4.9E+01; 1.9E+01; 3E00; 5.04E-03; 3E-01; 3E-03; 4E-03; 6E-01; 2E-01];



%Risk Quotient - Ingestion 
RQ_Al_ing_M3_s3 = DingM3_s3(:,1)/RfD_ing_M3(1);
RQ_Ba_ing_M3_s3 = DingM3_s3(:,2)/RfD_ing_M3(2);
RQ_Be_ing_M3_s3 = DingM3_s3(:,3)/RfD_ing_M3(3);
RQ_B_ing_M3_s3  = DingM3_s3(:,4)/RfD_ing_M3(4);
RQ_Co_ing_M3_s3 = DingM3_s3(:,5)/RfD_ing_M3(5);
RQ_Fe_ing_M3_s3 = DingM3_s3(:,6)/RfD_ing_M3(6);
RQ_Li_ing_M3_s3 = DingM3_s3(:,7)/RfD_ing_M3(7);
RQ_Mg_ing_M3_s3 = DingM3_s3(:,8)/RfD_ing_M3(8);
RQ_Mn_ing_M3_s3 = DingM3_s3(:,9)/RfD_ing_M3(9);
RQ_P_ing_M3_s3  = DingM3_s3(:,10)/RfD_ing_M3(10);
RQ_Na_ing_M3_s3 = DingM3_s3(:,11)/RfD_ing_M3(11);
RQ_Ti_ing_M3_s3 = DingM3_s3(:,12)/RfD_ing_M3(12);
RQ_V_ing_M3_s3  = DingM3_s3(:,13)/RfD_ing_M3(13);
RQ_Zn_ing_M3_s3 = DingM3_s3(:,14)/RfD_ing_M3(14);
RQ_Cr_ing_M3_s3 = DingM3_s3(:,15)/RfD_ing_M3(15);
RQ_Pb_ing_M3_s3 = DingM3_s3(:,16)/RfD_ing_M3(16);
RQ_Sr_ing_M3_s3 = DingM3_s3(:,17)/RfD_ing_M3(17);
RQ_ing_Styrene_s3_M3 = DingM3_s3(:,18)/RfD_ing_M3(18);

%Exposure assessment: inhalation

    DinhM3_s3 = (M3_inh_det'.*Et.*Ed.*Ef.*InhR)./(PEF.*AT.*BW_s3);
    RfD_inh_M3 = [1.02E-03; 1.02E-04; 4.09E-06; 4.09E-03; 1.23E-06; 2.05E-02; 1.02E-05; 2.05E-05; 2.05E-05; 6.14E-04; 1.84E-01];

%Risk Quotient - Inhalation 
RQ_Al_inh_M3_s3 = DinhM3_s3(:,1)/RfD_inh_M3(1);
RQ_Ba_inh_M3_s3 = DinhM3_s3(:,2)/RfD_inh_M3(2);
RQ_Be_inh_M3_s3 = DinhM3_s3(:,3)/RfD_inh_M3(3);
RQ_B_inh_M3_s3  = DinhM3_s3(:,4)/RfD_inh_M3(4);
RQ_Co_inh_M3_s3 = DinhM3_s3(:,5)/RfD_inh_M3(5);
RQ_Mg_inh_M3_s3 = DinhM3_s3(:,6)/RfD_inh_M3(6);
RQ_Mn_inh_M3_s3 = DinhM3_s3(:,7)/RfD_inh_M3(7);
RQ_V_inh_M3_s3  = DinhM3_s3(:,8)/RfD_inh_M3(8);
RQ_Cr_inh_M3_s3 = DinhM3_s3(:,9)/RfD_inh_M3(9);
RQ_Si_inh_M3_s3 = DinhM3_s3(:,10)/RfD_inh_M3(10);
RQ_inh_Styrene_s3_M3 = DinhM3_s3(:,11)/RfD_inh_M3(11);

%Dermal exposure
DA_derm_face_s3 = ((M3_det_derm./1000).*Adh_face); %g/cM3-ev
DA_derm_hand_s3 = ((M3_det_derm./1000).*Adh_hand); %g/cM3-ev
    
ADD_derm_face_M3_s3 = (DA_derm_face*SA_head*Ef*Ed)/(AT*BW_s3); % mg/kg-day
ADD_derm_hand_M3_s3 = (DA_derm_hand*SA_hand*Ef*Ed)/(AT*BW_s3); % mg/kg-day

ADD_derm_M3_s3 = ADD_derm_face_M3_s3' + ADD_derm_hand_M3_s3';

RfD_derm_M3 = [1; 1.4E-02; 1.4E-05; 2E-01; 3E-04; 2E-03; 1.1E+01; 9.6E-04; 4.9E+01; 1.9E+01; 1.31E-04; 3E-01; 7.5E-05; 6E-01; 2E-01];

RQ_Al_derm_M3_s3 = ADD_derm_M3_s3(:,1)/RfD_derm_M3(1);
RQ_Ba_derm_M3_s3 = ADD_derm_M3_s3(:,2)/RfD_derm_M3(2);
RQ_Be_derm_M3_s3 = ADD_derm_M3_s3(:,3)/RfD_derm_M3(3);
RQ_B_derm_M3_s3  = ADD_derm_M3_s3(:,4)/RfD_derm_M3(4);
RQ_Co_derm_M3_s3 = ADD_derm_M3_s3(:,5)/RfD_derm_M3(5);
RQ_Li_derm_M3_s3 = ADD_derm_M3_s3(:,6)/RfD_derm_M3(6);
RQ_Mg_derm_M3_s3 = ADD_derm_M3_s3(:,7)/RfD_derm_M3(7);
RQ_Mn_derm_M3_s3 = ADD_derm_M3_s3(:,8)/RfD_derm_M3(8);
RQ_P_derm_M3_s3  = ADD_derm_M3_s3(:,9)/RfD_derm_M3(9);
RQ_Na_derm_M3_s3 = ADD_derm_M3_s3(:,10)/RfD_derm_M3(10);
RQ_V_derm_M3_s3  = ADD_derm_M3_s3(:,11)/RfD_derm_M3(11);
RQ_Zn_derm_M3_s3 = ADD_derm_M3_s3(:,12)/RfD_derm_M3(12);
RQ_Cr_derm_M3_s3 = ADD_derm_M3_s3(:,13)/RfD_derm_M3(13);
RQ_Sr_derm_M3_s3 = ADD_derm_M3_s3(:,14)/RfD_derm_M3(14);
RQ_styrene_derm_M3_s3 = ADD_derm_M3_s3(:,15)/RfD_derm_M3(15);

%Risk Characterization

    RI_Si_M3_s3 = RQ_Si_inh_M3_s3;
    RI_Al_M3_s3 = RQ_Al_ing_M3_s3 + RQ_Al_inh_M3_s3 + RQ_Al_derm_M3_s3;
    RI_Fe_M3_s3 = RQ_Fe_ing_M3_s3;
    RI_Mg_M3_s3 = RQ_Mg_ing_M3_s3 + RQ_Mg_inh_M3_s3 + RQ_Mg_derm_M3_s3;
    RI_Na_M3_s3 = RQ_Na_ing_M3_s3 + RQ_Na_derm_M3_s3;
    RI_Ti_M3_s3 = RQ_Ti_ing_M3_s3;
    RI_P_M3_s3  = RQ_P_ing_M3_s3  + RQ_P_derm_M3_s3;
    RI_Be_M3_s3 = RQ_Be_ing_M3_s3 + RQ_Be_inh_M3_s3 + RQ_Be_derm_M3_s3;
    RI_Cr_M3_s3 = RQ_Cr_ing_M3_s3 + RQ_Cr_inh_M3_s3 + RQ_Cr_derm_M3_s3;
    RI_Co_M3_s3 = RQ_Co_ing_M3_s3 + RQ_Co_inh_M3_s3 + RQ_Co_derm_M3_s3;
    RI_Pb_M3_s3 = RQ_Pb_ing_M3_s3;
    RI_Mn_M3_s3 = RQ_Mn_ing_M3_s3 + RQ_Mn_inh_M3_s3 + RQ_Mn_derm_M3_s3;
    RI_V_M3_s3  = RQ_V_ing_M3_s3  + RQ_V_inh_M3_s3  + RQ_V_derm_M3_s3;
    RI_Zn_M3_s3 = RQ_Zn_ing_M3_s3 + RQ_Zn_derm_M3_s3;
    RI_Ba_M3_s3 = RQ_Ba_ing_M3_s3 + RQ_Ba_inh_M3_s3 + RQ_Ba_derm_M3_s3;
    RI_B_M3_s3 = RQ_B_ing_M3_s3 + RQ_B_inh_M3_s3 + RQ_B_derm_M3_s3;
    RI_Li_M3_s3 = RQ_Li_ing_M3_s3 + RQ_Li_derm_M3_s3;
    RI_Sr_M3_s3 = RQ_Sr_ing_M3_s3 + RQ_Sr_derm_M3_s3;
    RI_Styrene_M3_s3 = RQ_ing_Styrene_s3_M3 + RQ_inh_Styrene_s3_M3 + RQ_styrene_derm_M3_s3;
    
    RI_NM3_s3 = [RI_Si_M3_s3 RI_Al_M3_s3 RI_Fe_M3_s3 RI_Mg_M3_s3 RI_Na_M3_s3 RI_Ti_M3_s3 RI_P_M3_s3 RI_Be_M3_s3 RI_Cr_M3_s3 RI_Co_M3_s3 RI_Pb_M3_s3 RI_Mn_M3_s3 RI_V_M3_s3 RI_Zn_M3_s3 RI_Ba_M3_s3 RI_B_M3_s3 RI_Li_M3_s3 RI_Sr_M3_s3 RI_Styrene_M3_s3];

    
    RItot_NM3_s3 = sum(RI_NM3_s3');
end 


    % boxplot(RItot_NM3_s3);
    % set(gca, 'YScale', 'log')
    % ylim([0 2]);
    % yline(1,'-','Threshold');
    % title("RI Material 1 - Sesntivity 3 approach");
    % xlabel("Material");
    % ylabel("Risk Index");
    % xticks(1)
    % xticklabels("Sensitivity 3 M3")

    %sensitivity 4
n=10000;
for i = 1:n
    %DingNM3_s4 = (Ed.*(NM3_s0_ing./1000).*(IngR_s1./1000).*(Ef_s2./365))./(BW_s3.*AT);
    DingM3_s4 = ((NM3_s0_ing./1000).*(IngR_s1./1000).*Ef_s2.*Ed)./(BW_s3.*AT);
    RfD_ing_M3 = [1E00; 2E-01; 2E-03; 2E-01; 3E-04; 7E-01; 2E-03; 1.1E+01; 2.4E-02; 4.9E+01; 1.9E+01; 3E00; 5.04E-03; 3E-01; 3E-03; 4E-03; 6E-01; 2E-01];

    %Risk Quotient - Ingestion 
    RQ_Al_ing_M3_s4 = DingM3_s4(:,1)/RfD_ing_M3(1);
    RQ_Ba_ing_M3_s4 = DingM3_s4(:,2)/RfD_ing_M3(2);
    RQ_Be_ing_M3_s4 = DingM3_s4(:,3)/RfD_ing_M3(3);
    RQ_B_ing_M3_s4  = DingM3_s4(:,4)/RfD_ing_M3(4);
    RQ_Co_ing_M3_s4 = DingM3_s4(:,5)/RfD_ing_M3(5);
    RQ_Fe_ing_M3_s4 = DingM3_s4(:,6)/RfD_ing_M3(6);
    RQ_Li_ing_M3_s4 = DingM3_s4(:,7)/RfD_ing_M3(7);
    RQ_Mg_ing_M3_s4 = DingM3_s4(:,8)/RfD_ing_M3(8);
    RQ_Mn_ing_M3_s4 = DingM3_s4(:,9)/RfD_ing_M3(9);
    RQ_P_ing_M3_s4  = DingM3_s4(:,10)/RfD_ing_M3(10);
    RQ_Na_ing_M3_s4 = DingM3_s4(:,11)/RfD_ing_M3(11);
    RQ_Ti_ing_M3_s4 = DingM3_s4(:,12)/RfD_ing_M3(12);
    RQ_V_ing_M3_s4  = DingM3_s4(:,13)/RfD_ing_M3(13);
    RQ_Zn_ing_M3_s4 = DingM3_s4(:,14)/RfD_ing_M3(14);
    RQ_Cr_ing_M3_s4 = DingM3_s4(:,15)/RfD_ing_M3(15);
    RQ_Pb_ing_M3_s4 = DingM3_s4(:,16)/RfD_ing_M3(16);
    RQ_Sr_ing_M3_s4 = DingM3_s4(:,17)/RfD_ing_M3(17);
    RQ_ing_Styrene_s4_M3 = DingM3_s4(:,18)/RfD_ing_M3(18);


    %Exposure assessment: inhalation
    DinhM3_s4 = (NM3_inh_s0.*Et.*Ed.*Ef_s2.*(InhR_s1./24))./(PEF.*AT.*BW_s3);
    RfD_inh_M3 = [1.02E-03; 1.02E-04; 4.09E-06; 4.09E-03; 1.23E-06; 2.05E-02; 1.02E-05; 2.05E-05; 2.05E-05; 6.14E-04; 1.84E-01];

%Risk Quotient - Inhalation 
    RQ_Al_inh_M3_s4 = DinhM3_s4(:,1)/RfD_inh_M3(1);
    RQ_Ba_inh_M3_s4 = DinhM3_s4(:,2)/RfD_inh_M3(2);
    RQ_Be_inh_M3_s4 = DinhM3_s4(:,3)/RfD_inh_M3(3);
    RQ_B_inh_M3_s4  = DinhM3_s4(:,4)/RfD_inh_M3(4);
    RQ_Co_inh_M3_s4 = DinhM3_s4(:,5)/RfD_inh_M3(5);
    RQ_Mg_inh_M3_s4 = DinhM3_s4(:,6)/RfD_inh_M3(6);
    RQ_Mn_inh_M3_s4 = DinhM3_s4(:,7)/RfD_inh_M3(7);
    RQ_V_inh_M3_s4  = DinhM3_s4(:,8)/RfD_inh_M3(8);
    RQ_Cr_inh_M3_s4 = DinhM3_s4(:,9)/RfD_inh_M3(9);
    RQ_Si_inh_M3_s4 = DinhM3_s4(:,10)/RfD_inh_M3(10);
    RQ_inh_Styrene_s4_M3 = DinhM3_s4(:,11)/RfD_inh_M3(11);



    %Dermal exposure
    
    ADD_derm_face_s4 = (ADD_derm_face_M3_s0.*SA_head_s1.*Ef_s2.*Ed)./(AT.*BW_s3); % mg/kg-day
    ADD_derm_hand_s4 = (ADD_derm_hand_M3_s0.*SA_hand_s1.*Ef_s2.*Ed)./(AT.*BW_s3); % mg/kg-day
    
    ADD_derm_M3_s4 = ADD_derm_hand_s4 + ADD_derm_face_s4;

    RfD_derm_M3 = [1; 1.4E-02; 1.4E-05; 2E-01; 3E-04; 2E-03; 1.1E+01; 9.6E-04; 4.9E+01; 1.9E+01; 1.31E-04; 3E-01; 7.5E-05; 6E-01; 2E-01];

    RQ_Al_derm_M3_s4 = ADD_derm_M3_s4(:,1)/RfD_derm_M3(1);
    RQ_Ba_derm_M3_s4 = ADD_derm_M3_s4(:,2)/RfD_derm_M3(2);
    RQ_Be_derm_M3_s4 = ADD_derm_M3_s4(:,3)/RfD_derm_M3(3);
    RQ_B_derm_M3_s4  = ADD_derm_M3_s4(:,4)/RfD_derm_M3(4);
    RQ_Co_derm_M3_s4 = ADD_derm_M3_s4(:,5)/RfD_derm_M3(5);
    RQ_Li_derm_M3_s4 = ADD_derm_M3_s4(:,6)/RfD_derm_M3(6);
    RQ_Mg_derm_M3_s4 = ADD_derm_M3_s4(:,7)/RfD_derm_M3(7);
    RQ_Mn_derm_M3_s4 = ADD_derm_M3_s4(:,8)/RfD_derm_M3(8);
    RQ_P_derm_M3_s4  = ADD_derm_M3_s4(:,9)/RfD_derm_M3(9);
    RQ_Na_derm_M3_s4 = ADD_derm_M3_s4(:,10)/RfD_derm_M3(10);
    RQ_V_derm_M3_s4  = ADD_derm_M3_s4(:,11)/RfD_derm_M3(11);
    RQ_Zn_derm_M3_s4 = ADD_derm_M3_s4(:,12)/RfD_derm_M3(12);
    RQ_Cr_derm_M3_s4 = ADD_derm_M3_s4(:,13)/RfD_derm_M3(13);
    RQ_Sr_derm_M3_s4 = ADD_derm_M3_s4(:,14)/RfD_derm_M3(14);
    RQ_styrene_derm_M3_s4 = ADD_derm_M3_s4(:,15)/RfD_derm_M3(15);

    %Risk Characterization

    RI_Si_M3_s4 = RQ_Si_inh_M3_s4;
    RI_Al_M3_s4 = RQ_Al_ing_M3_s4 + RQ_Al_inh_M3_s4 + RQ_Al_derm_M3_s4;
    RI_Fe_M3_s4 = RQ_Fe_ing_M3_s4;
    RI_Mg_M3_s4 = RQ_Mg_ing_M3_s4 + RQ_Mg_inh_M3_s4 + RQ_Mg_derm_M3_s4;
    RI_Na_M3_s4 = RQ_Na_ing_M3_s4 + RQ_Na_derm_M3_s4;
    RI_Ti_M3_s4 = RQ_Ti_ing_M3_s4;
    RI_P_M3_s4  = RQ_P_ing_M3_s4  + RQ_P_derm_M3_s4;
    RI_Be_M3_s4 = RQ_Be_ing_M3_s4 + RQ_Be_inh_M3_s4 + RQ_Be_derm_M3_s4;
    RI_Cr_M3_s4 = RQ_Cr_ing_M3_s4 + RQ_Cr_inh_M3_s4 + RQ_Cr_derm_M3_s4;
    RI_Co_M3_s4 = RQ_Co_ing_M3_s4 + RQ_Co_inh_M3_s4 + RQ_Co_derm_M3_s4;
    RI_Pb_M3_s4 = RQ_Pb_ing_M3_s4;
    RI_Mn_M3_s4 = RQ_Mn_ing_M3_s4 + RQ_Mn_inh_M3_s4 + RQ_Mn_derm_M3_s4;
    RI_V_M3_s4  = RQ_V_ing_M3_s4  + RQ_V_inh_M3_s4  + RQ_V_derm_M3_s4;
    RI_Zn_M3_s4 = RQ_Zn_ing_M3_s4 + RQ_Zn_derm_M3_s4;
    RI_Ba_M3_s4 = RQ_Ba_ing_M3_s4 + RQ_Ba_inh_M3_s4 + RQ_Ba_derm_M3_s4;
    RI_B_M3_s4 = RQ_B_ing_M3_s4 + RQ_B_inh_M3_s4 + RQ_B_derm_M3_s4;
    RI_Li_M3_s4 = RQ_Li_ing_M3_s4 + RQ_Li_derm_M3_s4;
    RI_Sr_M3_s4 = RQ_Sr_ing_M3_s4 + RQ_Sr_derm_M3_s4;
    RI_Styrene_M3_s4 = RQ_ing_Styrene_s4_M3 + RQ_inh_Styrene_s4_M3 + RQ_styrene_derm_M3_s4;
    
    RI_NM3_s4 = [RI_Si_M3_s4 RI_Al_M3_s4 RI_Fe_M3_s4 RI_Mg_M3_s4 RI_Na_M3_s4 RI_Ti_M3_s4 RI_P_M3_s4 RI_Be_M3_s4 RI_Cr_M3_s4 RI_Co_M3_s4 RI_Pb_M3_s4 RI_Mn_M3_s4 RI_V_M3_s4 RI_Zn_M3_s4 RI_Ba_M3_s4 RI_B_M3_s4 RI_Li_M3_s4 RI_Sr_M3_s4 RI_Styrene_M3_s4];

    
    RItot_NM3_s4 = sum(RI_NM3_s4.');

end 

    boxplot(RItot_NM3_s4);
    set(gca, 'YScale', 'log')
    %ylim([0 2]);
    yline(1,'-','Threshold')
    title("RI Material 1 - Sesntivity 4 approach");
    xlabel("Material");
    ylabel("Risk Index");
    xticks(1)
    xticklabels("Sensitivity 4 M3")

   

