%QCRA MODEL 1
% QCRA NM3 Human health risks - deerministic model
%Input data


Ef = 250/365; % days/year
Ed = 25; %years
Et = 8; %hrs
CF = 10E-06; %kg/m3
%IngR = 0.0658; %g/pers/day
IngR = 0.03;%g/pers/day
%IngR = mean of lognormal distibution; %g/pers/day
BW = 7.58E+01; %kg
AT = Ed*365; %days
%InhR = 0.8875; %m3/h
%InhR = 0.1296;
InhR_day = 3.189; %m3/day
InhR = 15.52/24; %m3/h
%InhR = prctile([3 2.9 3.12 3.18], 95)/24;
PEF = 1.36E+09; %m3/g
%SA = 5.7E+03; %cm2
%kp = 1; %100% In this equation the s1ault rate of 100% dermal absorption is assumed.
AT_carc = 70*365; %lifetime in days
SA_hand = 980; %cm2
SA_head= 1250; %cm2
Adh_hand = 2.76E-04; %g/cm2
Adh_face = 9.82E-05; %g/cm2
Ef_derm = 2; %ev/day

mass_product= 1; %kg
mass_reed = mass_product*10/100; %g
mass_Calcite = mass_product*60/100; %kg
mass_UPR_polyester = mass_product*28/100; %g

Styrene_M3 = (mass_UPR_polyester*0.35*1000*1000)./(1); %mg/kg materials 

%Cellulose
%cellulose
Strontium_Ce_det_M3 = 6;
%Calcite

Be_Ca_det_M3 = 0.0294;
Cr_Ca_det_M3= 0.996;
Co_Ca_det_M3 =0.272;
Pb_Ca_det_M3= 2.72;
Sr_Ca_det_M3 = 23.3;

%DW calcite 

Be_DWCa_det_M3 = 0.01;
Co_DWCa_det_M3 = 0.2;
Sr_DWCa_det_M3 = 27.1;


%Total Calcite M3 (mg/kg)
Beryllium_Ca_det_M3 = 0.5*Be_Ca_det_M3 + 0.5* Be_DWCa_det_M3;
Chromium_Ca_det_M3 = 0.5* Cr_Ca_det_M3;
Cobalt_Ca_det_M3 = 0.5*Co_Ca_det_M3 + 0.5*Co_DWCa_det_M3;
Lead_Ca_det_M3 = 0.5* Pb_Ca_det_M3;
Strontium_Ca_det_M3 = 0.5*Sr_Ca_det_M3 + 0.5*Sr_DWCa_det_M3;

%Composition NM3 (mg/kg)

Beryllium_det_M3 = 0.60* Beryllium_Ca_det_M3;
Chromium_det_M3 = 0.60* Chromium_Ca_det_M3;
Cobalt_det_M3 = 0.60*Cobalt_Ca_det_M3;
Lead_det_M3 = 0.60 * Lead_Ca_det_M3;
Strontium_det_M3 = 0.10*Strontium_Ce_det_M3+ 0.60*Strontium_Ca_det_M3;

Styrene_M3 = (mass_UPR_polyester*0.35*1000)./(mass_product./1000); %mg/kg materials 

CR_NM3_det = [Beryllium_det_M3 Chromium_det_M3 Cobalt_det_M3 Lead_det_M3 Strontium_det_M3 Styrene_M3];

%Ingestion 
NM3_det_carc_ing = [Beryllium_det_M3 Chromium_det_M3 Lead_det_M3 Strontium_det_M3 Styrene_M3];

LADDingNM3_det = (IngR.*(NM3_det_carc_ing./1000).*Ef.*Ed)./(BW.*AT_carc);
SF_ing_M3 =[0.17; 5E-01; 8.5E-03; 8.9E-10; 1.3E-02]; %(mg/kg/d)-1


%Risk Quotient - Ingestion 
Carc_Be_ing_M3_det = LADDingNM3_det(1).*SF_ing_M3(1);
Carc_Cr_ing_M3_det = LADDingNM3_det(2).*SF_ing_M3(2);
Carc_Pb_ing_M3_det = LADDingNM3_det(3).*SF_ing_M3(3);
Carc_Sr_ing_M3_det = LADDingNM3_det(4).*SF_ing_M3(4);
Carc_Styrene_ing_M3_det = LADDingNM3_det(5).*SF_ing_M3(5);


Carc_ing_M3 = [Carc_Be_ing_M3_det Carc_Cr_ing_M3_det Carc_Pb_ing_M3_det Carc_Sr_ing_M3_det Carc_Styrene_ing_M3_det];
Carc_tot_ing_M3 = sum(Carc_ing_M3);

% Expsoure assessment - Inhalation
NM3_Carc_inh_M3 =[Chromium_det_M3 Cobalt_det_M3 Lead_det_M3 Strontium_det_M3];
LADDinhNM3_det = (NM3_Carc_inh_M3.*Et.*Ed.*Ef.*InhR)./(PEF.*AT_carc.*BW);

SF_inh_M3 =[41; 27; 0.042; 1.5E-09];

%%Risk Quotient - Inhalation 
Carc_Cr_inh_M3 = LADDinhNM3_det(1).*SF_inh_M3(1);
Carc_Co_inh_M3 = LADDinhNM3_det(2).*SF_inh_M3(2);
Carc_Pb_inh_M3 = LADDinhNM3_det(3).*SF_inh_M3(3);
Carc_Sr_inh_M3 = LADDinhNM3_det(4).*SF_inh_M3(4);

Carc_inh_M3 =[Carc_Cr_inh_M3 Carc_Co_inh_M3 Carc_Pb_inh_M3 Carc_Sr_inh_M3];
Carc_inh_M3_tot = sum(Carc_inh_M3);

%Dermal exposure
NM3_Carc_derm_M3 =[Beryllium_det_M3 Chromium_det_M3 Strontium_det_M3 Styrene_M3];

DA_derm_face_carc_det_M3 = ((NM3_Carc_derm_M3/1000).*Adh_face); %mg/cm2-d
DA_derm_hand_carc_det_M3 = ((NM3_Carc_derm_M3/1000).*Adh_hand); %mg/cm2-d

LADD_derm_face_det_M3 = (DA_derm_face_carc_det_M3.*SA_head.*Ef.*Ed)./(AT_carc.*BW); % mg/kg-day
LADD_derm_hand_det_M3 = (DA_derm_hand_carc_det_M3.*SA_hand.*Ef.*Ed)./(AT_carc.*BW); % mg/kg-day

LADD_derm_M3_det = LADD_derm_face_det_M3 + LADD_derm_hand_det_M3;

SF_derm_M3 =[2.43E+01; 2E+01; 8.9E-10; 1.3E-02];

Carc_Be_derm_M3_det = LADD_derm_M3_det(1).*SF_derm_M3(1);
Carc_Cr_derm_M3_det = LADD_derm_M3_det(2).*SF_derm_M3(2);
Carc_Sr_derm_M3_det = LADD_derm_M3_det(3).*SF_derm_M3(3);
Carc_Styrene_derm_M3_det = LADD_derm_M3_det(4).*SF_derm_M3(4);


Carc_derm_M3_det = [Carc_Be_derm_M3_det Carc_Cr_derm_M3_det Carc_Sr_derm_M3_det Carc_Styrene_derm_M3_det];
Carc_derm_M3_det_tot = sum(Carc_derm_M3_det);
%Risk Characterization

Carc_Be_Det_M3 = Carc_Be_ing_M3_det + Carc_Be_derm_M3_det;
Carc_Cr_Det_M3 = Carc_Cr_ing_M3_det + Carc_Cr_inh_M3 + Carc_Cr_derm_M3_det;
Carc_Co_Det_M3 = Carc_Co_inh_M3;
Carc_Pb_Det_M3 = Carc_Pb_ing_M3_det + Carc_Pb_inh_M3;
Carc_Sr_Det_M3 = Carc_Sr_ing_M3_det + Carc_Sr_inh_M3 + Carc_Sr_derm_M3_det;
Carc_Styrene_M3_det = Carc_Styrene_ing_M3_det + Carc_Styrene_derm_M3_det;

CR_NM3_det = [Carc_Be_Det_M3 Carc_Cr_Det_M3 Carc_Co_Det_M3 Carc_Pb_Det_M3 Carc_Sr_Det_M3 Carc_Styrene_M3_det];
CR_NM3_det_tot = sum(CR_NM3_det);
%plot(Carc_N8010_det);

% bar(CR_NM3_det,0.4);
% %ylim([0 1E-06]);
% set(gca, 'YScale', 'log')
% yline(1E-06,'-','Threshold');
% title("Carcinogenic RIsk Material 8010 - Determinisic approach");
% xlabel("Chemicals");
% ylabel("Carcinogenic Risk");
% xticks([1 2 3 4 5 6]);
% xticklabels({'Beryllium','Chromium','Cobalt','Lead','Strontium','Styrene'});
% xlim([0 7]);

%Sensitivity 0
%cellulose
n= 10000;

for i=1:n
    Strontium_Ce_M3_s0 = (6-0)*rand(n,1)+0;
    
    
      
    Beryllium_M3_s0 = (8.82E-03-0)*rand(n,1)+0;
    Chromium_M3_s0 = (2.99E-01-0)*rand(n,1)+0;
    Cobalt_M3_s0 = (8.16E-02-0)*rand(n,1)+0;
    Lead_M3_s0 = (8.16E-01-0)*rand(n,1)+0;
    Strontium_M3_s0= (1.57E+01-0)*rand(n,1)+0;
    
    %Styrene_M3_s0 = randn(10000,1)*5.4E+03+Styrene_M3;
    Styrene_M3_s0 = (9.80E+04-0)*rand(n,1)+0;
    
    %Ingestion exposure
    CR_ing_M3_s0 = [Beryllium_M3_s0 Chromium_M3_s0 Lead_M3_s0 Strontium_M3_s0 Styrene_M3_s0];
    LADD_ing_M3_S0 = ((CR_ing_M3_s0./1000).*IngR.*Ed.*Ef)./(BW.*AT_carc);
    
    Carc_Be_ing_M3_s0 = LADD_ing_M3_S0(:,1).*SF_ing_M3(1);
    Carc_Cr_ing_M3_s0 = LADD_ing_M3_S0(:,2).*SF_ing_M3(2);
    Carc_Pb_ing_M3_s0 = LADD_ing_M3_S0(:,3).*SF_ing_M3(3);
    Carc_Sr_ing_M3_s0 = LADD_ing_M3_S0(:,4).*SF_ing_M3(4);
    Carc_Styrene_ing_M3_s0 = LADD_ing_M3_S0(:,5).*SF_ing_M3(5);
    
    
    Carc_ing_M3_s0 = [Carc_Be_ing_M3_s0 Carc_Cr_ing_M3_s0  Carc_Pb_ing_M3_s0  Carc_Sr_ing_M3_s0 Carc_Styrene_ing_M3_s0];
    Carc_tot_ing_M3 = sum(Carc_ing_M3);
    
    % Expsoure assessment - Inhalation
    NM3_Carc_inh_M3_s0 =[Chromium_M3_s0 Cobalt_M3_s0 Lead_M3_s0 Strontium_M3_s0];
    LADDinhNM3_s0 = (NM3_Carc_inh_M3_s0.*Et.*Ed.*Ef*InhR)./(PEF.*AT_carc.*BW);
    
    
    %%Risk Quotient - Inhalation 
    Carc_Cr_inh_M3_s0 = LADDinhNM3_s0(:,1).*SF_inh_M3(1);
    Carc_Co_inh_M3_s0 = LADDinhNM3_s0(:,2).*SF_inh_M3(2);
    Carc_Pb_inh_M3_s0 = LADDinhNM3_s0(:,3).*SF_inh_M3(3);
    Carc_Sr_inh_M3_s0 = LADDinhNM3_s0(:,4).*SF_inh_M3(4);
    
    Carc_inh_M3_s0 =[Carc_Cr_inh_M3_s0 Carc_Co_inh_M3_s0 Carc_Pb_inh_M3_s0 Carc_Sr_inh_M3_s0];
    Carc_inh_M3_tot = sum(Carc_inh_M3_s0);
    
    %Dermal exposure
    NM3_Carc_derm_M3_s0 =[Beryllium_M3_s0 Chromium_M3_s0 Strontium_M3_s0 Styrene_M3_s0];
    
    DA_derm_face_carc_s0_M3 = ((NM3_Carc_derm_M3_s0/1000).*Adh_face); %mg/cm2-d
    DA_derm_hand_carc_s0_M3 = ((NM3_Carc_derm_M3_s0/1000).*Adh_hand); %mg/cm2-d
    
    LADD_derm_face_s0_M3 = (DA_derm_face_carc_s0_M3.*SA_head.*Ef*Ed)./(AT_carc.*BW); % mg/kg-day
    LADD_derm_hand_s0_M3 = (DA_derm_hand_carc_s0_M3.*SA_hand.*Ef.*Ed)./(AT_carc.*BW); % mg/kg-day
    
    LADD_derm_M3_s0 = LADD_derm_face_s0_M3 + LADD_derm_hand_s0_M3;
    
    
    Carc_Be_derm_M3_s0 = LADD_derm_M3_s0(:,1).*SF_derm_M3(1);
    Carc_Cr_derm_M3_s0 = LADD_derm_M3_s0(:,2).*SF_derm_M3(2);
    Carc_Sr_derm_M3_s0 = LADD_derm_M3_s0(:,3).*SF_derm_M3(3);
    Carc_Styrene_derm_M3_s0 = LADD_derm_M3_s0(:,4).*SF_derm_M3(4);
    
    
    Carc_derm_M3_s0 = [Carc_Be_derm_M3_s0 Carc_Cr_derm_M3_s0 Carc_Sr_derm_M3_s0 Carc_Styrene_derm_M3_s0];
    %Risk Characterization
    
    Carc_Be_s0_M3 = Carc_Be_ing_M3_s0 + Carc_Be_derm_M3_s0;
    Carc_Cr_s0_M3 = Carc_Cr_ing_M3_s0 + Carc_Cr_inh_M3 + Carc_Cr_derm_M3_s0;
    Carc_Co_s0_M3 = Carc_Co_inh_M3_s0;
    Carc_Pb_s0_M3 = Carc_Pb_ing_M3_s0 + Carc_Pb_inh_M3;
    Carc_Sr_s0_M3 = Carc_Sr_ing_M3_s0 + Carc_Sr_inh_M3 + Carc_Sr_derm_M3_s0;
    Carc_Styrene_M3_s0 = Carc_Styrene_ing_M3_s0 + Carc_Styrene_derm_M3_s0;
    
    Carc_NM3_s0 = [Carc_Be_s0_M3 Carc_Cr_s0_M3 Carc_Co_s0_M3 Carc_Pb_s0_M3 Carc_Sr_s0_M3 Carc_Styrene_M3_s0];
    
    Carc_tot_NM3_s0 = sum(Carc_NM3_s0.');
end 

% %plot(Carc_NM3_s0);
% boxplot(Carc_NM3_s0);
% set(gca, 'YScale', 'log')
% %ylim([0 2E-06]);
% yline(1E-06,'-','Threshold');
% title("Carcinogenic RIsk Material M3 - Sensitivity 0 approach");
% xlabel("Chemicals");
% ylabel("Carcinogenic Risk");
% xticks([1 2 3 4 5 6]);
% xticklabels({'Beryllium','Chromium','Cobalt','Lead','Strontium','Styrene'});
% xlim([0 7]);

% boxplot(Carc_tot_NM3_s0);
% set(gca, 'YScale', 'log')
% % %ylim([0 2E-06]);
% yline(1E-06,'-','Threshold');
% title("Carcinogenic RIsk Material 3 - Sensitivity 0 approach");
% xlabel("Material");
% ylabel("Carcinogenic Risk");
% xticks(1);
% xticklabels({'Material 3'});
% xlim([0 2]);

%Sensitivity model s1

for i =1:n
    v1 = 1.44;
    m1 = 30; %mg/day
    mu1 = log((m1.^2)./sqrt(v1+(m1.^2)));
    sigma1 = sqrt(log(v1./(m1.^2)+1));
    IngR_s1 = lognrnd(mu1,sigma1,n,1);
    %IngR_s1 = randn(n,1)*0.0012+IngR;
    %InhR_s1 = randn(n,1)*0.0051+InhR;

    v = 0.567;
    m = 15.52;
    mu = log((m^2)/sqrt(v+m^2));
    sigma = sqrt(log(v/(m^2)+1));
    InhR_s1 = lognrnd(mu,sigma,n,1);

    %Adh_face_s1 = randn(n,1)*1.4500e-06+Adh_face;
    v_face = 24200;
    mu_face = log((SA_head^2)/sqrt(v_face+SA_head^2));
    sigma_face = sqrt(log(v_face/(SA_head^2)+1));
    SA_head_s1 = lognrnd(mu_face, sigma_face,n,1);

    v_hands = 16200;
    mu_hands = log((SA_hand^2)/sqrt(v_hands+SA_hand^2));
    sigma_hand = sqrt(log(v_hands/(SA_hand^2)+1));
    SA_hand_s1 = lognrnd(mu_hands, sigma_hand, n,1);

    %Exposure Assessment - Ingestion
    NM3_det_carc_ing = [Beryllium_det_M3 Chromium_det_M3 Lead_det_M3 Strontium_det_M3 Styrene_M3];

    LADDingNM3_s1 = ((IngR_s1./1000).*(NM3_det_carc_ing./1000).*Ef.*Ed)./(BW.*AT_carc);
   
    SF_ing_M3 =[0.17; 5E-01; 8.5E-03; 8.9E-10; 1.3E-02]; %(mg/kg/d)-1

    
    %Risk Quotient - Ingestion 
    Carc_Be_ing_M3_s1 = LADDingNM3_s1(:,1).*SF_ing_M3(1);
    Carc_Cr_ing_M3_s1 = LADDingNM3_s1(:,2).*SF_ing_M3(2);
    Carc_Pb_ing_M3_s1 = LADDingNM3_s1(:,3).*SF_ing_M3(3);
    Carc_Sr_ing_M3_s1 = LADDingNM3_s1(:,4).*SF_ing_M3(4);
    Carc_Styrene_ing_M3_s1 = LADDingNM3_s1(:,5).*SF_ing_M3(5);
    
    
    Carc_ing_M3 = [Carc_Be_ing_M3_s1 Carc_Cr_ing_M3_s1 Carc_Pb_ing_M3_s1 Carc_Sr_ing_M3_s1 Carc_Styrene_ing_M3_s1];
    Carc_tot_ing_M3 = sum(Carc_ing_M3);
    
    % Expsoure assessment - Inhalation
    NM3_Carc_inh_M3 =[Chromium_det_M3 Cobalt_det_M3 Lead_det_M3 Strontium_det_M3];

    LADDinhNM3_s1 = (NM3_Carc_inh_M3.*Et.*Ed.*Ef.*(InhR_s1./24))./(PEF*AT_carc*BW);
    
    SF_inh_M3 =[41; 27; 0.042; 1.5E-09];

    
    %%Risk Quotient - Inhalation 
    Carc_Cr_inh_M3_s1 = LADDinhNM3_s1(:,1).*SF_inh_M3(1);
    Carc_Co_inh_M3_s1 = LADDinhNM3_s1(:,2).*SF_inh_M3(2);
    Carc_Pb_inh_M3_s1 = LADDinhNM3_s1(:,3).*SF_inh_M3(3);
    Carc_Sr_inh_M3_s1 = LADDinhNM3_s1(:,4).*SF_inh_M3(4);
    
    Carc_inh_M3 =[Carc_Cr_inh_M3_s1 Carc_Pb_inh_M3_s1 Carc_Co_inh_M3_s1 Carc_Sr_inh_M3_s1];
    Carc_inh_M3_tot = sum(Carc_inh_M3);
    
    %Dermal exposure
    NM3_Carc_derm_M3 =[Beryllium_det_M3 Chromium_det_M3 Strontium_det_M3 Styrene_M3];
    DA_derm_face_carc_M3_s1 = ((NM3_Carc_derm_M3./1000).*Adh_face); %mg/cm2-d
    DA_derm_hand_carc_M3_s1 = ((NM3_Carc_derm_M3./1000).*Adh_hand); %mg/cm2-d
    
    LADD_derm_face_M3_s1 = (DA_derm_face_carc_M3_s1.*SA_head_s1.*Ef.*Ed)./(AT_carc.*BW); % mg/kg-day
    LADD_derm_hand_M3_s1 = (DA_derm_hand_carc_M3_s1.*SA_hand_s1.*Ef.*Ed)./(AT_carc.*BW); % mg/kg-day
    
    LADD_derm_M3_s1 = LADD_derm_face_M3_s1 + LADD_derm_hand_M3_s1;
    
    SF_derm_M3 =[2.43E+01; 2E+01; 8.9E-10; 1.3E-02];

    Carc_Be_derm_M3_s1 = LADD_derm_M3_s1(:,1).*SF_derm_M3(1);
    Carc_Cr_derm_M3_s1 = LADD_derm_M3_s1(:,2).*SF_derm_M3(2);
    Carc_Sr_derm_M3_s1 = LADD_derm_M3_s1(:,3).*SF_derm_M3(3);
    Carc_Styrene_derm_M3_s1 = LADD_derm_M3_s1(:,4).*SF_derm_M3(4);
    
    
    Carc_derm_M3_s1 = [Carc_Be_derm_M3_s1 Carc_Cr_derm_M3_s1 Carc_Sr_derm_M3_s1 Carc_Styrene_derm_M3_s1];
    %Risk Characterization
    
    Carc_Be_M3_s1 = Carc_Be_ing_M3_s1 + Carc_Be_derm_M3_s1;
    Carc_Cr_M3_s1 = Carc_Cr_ing_M3_s1 + Carc_Cr_inh_M3_s1 + Carc_Cr_derm_M3_s1;
    Carc_Co_M3_s1 = Carc_Co_inh_M3_s1;
    Carc_Pb_M3_s1 = Carc_Pb_ing_M3_s1 + Carc_Pb_inh_M3_s1;
    Carc_Sr_M3_s1 = Carc_Sr_ing_M3_s1 + Carc_Sr_inh_M3_s1 + Carc_Sr_derm_M3_s1;
    Carc_Styrene_M3_s1 = Carc_Styrene_ing_M3_s1 + Carc_Styrene_derm_M3_s1;
    
    Carc_NM3_s1 = [Carc_Be_M3_s1 Carc_Cr_M3_s1 Carc_Co_M3_s1 Carc_Pb_M3_s1 Carc_Sr_M3_s1 Carc_Styrene_M3_s1];
    Carc_tot_NM3_s1 = sum(Carc_NM3_s1.');
end 
%     %plot(Carc_NM3_s0);
%     boxplot(Carc_NM3_s1);
%     set(gca, 'YScale', 'log')
%     %ylim([0 1E-06]);
%     yline(1E-06,'-','Threshold');
%     title("Carcinogenic RIsk Material M3 - Sensitivity 1 approach");
%     xlabel("Chemicals");
%     ylabel("Carcinogenic Risk");
%     xticks([1 2 3 4 5 6]);
%     xticklabels({'Beryllium','Chromium','Cobalt','Lead','Strontium','Styrene'});
%     xlim([0 7]);

% boxplot(Carc_tot_NM3_s1);
% set(gca, 'YScale', 'log')
% % %ylim([0 2E-06]);
% yline(1E-06,'-','Threshold');
% title("Carcinogenic RIsk Material 3 - Sensitivity 1 approach");
% xlabel("Material");
% ylabel("Carcinogenic Risk");
% xticks(1);
% xticklabels({'Material 3'});
% xlim([0 2]);

for i =1:n
    %Ef_s2 = randn(n,1)*0.0274+0.6849;
   % v_ef = 0.0313;
    v_ef = 11; 
    mu_ef = log((275^2)/sqrt(v_ef+275^2));
    sigma_ef = sqrt(log(v_ef/(275^2)+1));
    Ef_s2 = lognrnd(mu_ef, sigma_ef, n,1);

    %Ingestion Risk
    LADDingNM3_s2 = (IngR.*(NM3_det_carc_ing./1000).*(Ef_s2./365).*Ed)./(BW.*AT_carc);
    
    
    %Risk Quotient - Ingestion 
    Carc_Be_ing_M3_s2 = LADDingNM3_s2(:,1).*SF_ing_M3(1);
    Carc_Cr_ing_M3_s2 = LADDingNM3_s2(:,2).*SF_ing_M3(2);
    Carc_Pb_ing_M3_s2 = LADDingNM3_s2(:,3).*SF_ing_M3(3);
    Carc_Sr_ing_M3_s2 = LADDingNM3_s2(:,4).*SF_ing_M3(4);
    Carc_Styrene_ing_M3_s2 = LADDingNM3_s2(:,5).*SF_ing_M3(5);
    
    
    Carc_ing_M3_s2 = [Carc_Be_ing_M3_s2 Carc_Cr_ing_M3_s2 Carc_Pb_ing_M3_s2 Carc_Sr_ing_M3_s2 Carc_Styrene_ing_M3_s2];
    Carc_tot_ing_M3_s2 = sum(Carc_ing_M3);
    
    % Expsoure assessment - Inhalation
    LADDinhNM3_s2 = (NM3_Carc_inh_M3.*Et.*Ed.*(Ef_s2./365).*InhR)./(PEF.*AT_carc.*BW);
    
    
    %%Risk Quotient - Inhalation 
    Carc_Cr_inh_M3_s2 = LADDinhNM3_s2(:,1).*SF_inh_M3(1);
    Carc_Co_inh_M3_s2 = LADDinhNM3_s2(:,2).*SF_inh_M3(2);
    Carc_Pb_inh_M3_s2 = LADDinhNM3_s2(:,3).*SF_inh_M3(3);
    Carc_Sr_inh_M3_s2 = LADDinhNM3_s2(:,4).*SF_inh_M3(4);
    
    Carc_inh_M3_s2 =[Carc_Cr_inh_M3_s2 Carc_Co_inh_M3_s2 Carc_Pb_inh_M3_s2 Carc_Sr_inh_M3_s2];
    Carc_inh_M3_tot = sum(Carc_inh_M3);
    
    %Dermal exposure
    
    DA_derm_face_carc_M3_s2 = ((NM3_Carc_derm_M3/1000).*Adh_face); %mg/cm2-d
    DA_derm_hand_carc_M3_s2 = ((NM3_Carc_derm_M3/1000).*Adh_hand); %mg/cm2-d
    
    LADD_derm_face_det_M3_s2 = (DA_derm_face_carc_M3_s2*SA_head.*(Ef_s2./365)*Ed)./(AT_carc*BW); % mg/kg-day
    LADD_derm_hand_det_M3_s2 = (DA_derm_hand_carc_M3_s2*SA_hand.*(Ef_s2./365)*Ed)./(AT_carc*BW); % mg/kg-day
    
    LADD_derm_M3_s2 = LADD_derm_face_det_M3_s2 + LADD_derm_hand_det_M3_s2;
    
    Carc_Be_derm_M3_s2 = LADD_derm_M3_s2(:,1).*SF_derm_M3(1);
    Carc_Cr_derm_M3_s2 = LADD_derm_M3_s2(:,2).*SF_derm_M3(2);
    Carc_Sr_derm_M3_s2 = LADD_derm_M3_s2(:,3).*SF_derm_M3(3);
    Carc_Styrene_derm_M3_s2 = LADD_derm_M3_s2(:,4).*SF_derm_M3(4);
    
    
    Carc_derm_M3_s2 = [Carc_Be_derm_M3_s2 Carc_Cr_derm_M3_s2 Carc_Sr_derm_M3_s2 Carc_Styrene_derm_M3_s2];
    %Risk Characterization
    
    Carc_Be_M3_s2 = Carc_Be_ing_M3_s2 + Carc_Be_derm_M3_s2;
    Carc_Cr_M3_s2 = Carc_Cr_ing_M3_s2 + Carc_Cr_inh_M3_s2 + Carc_Cr_derm_M3_s2;
    Carc_Co_M3_s2 = Carc_Co_inh_M3_s2;
    Carc_Pb_M3_s2 = Carc_Pb_ing_M3_s2 + Carc_Pb_inh_M3_s2;
    Carc_Sr_M3_s2 = Carc_Sr_ing_M3_s2 + Carc_Sr_inh_M3_s2 + Carc_Sr_derm_M3_s2;
    Carc_Styrene_M3_s2 = Carc_Styrene_ing_M3_s2 + Carc_Styrene_derm_M3_s2;
    
    Carc_NM3_s2 = [Carc_Be_M3_s2 Carc_Cr_M3_s2 Carc_Co_M3_s2 Carc_Pb_M3_s2 Carc_Sr_M3_s2 Carc_Styrene_M3_s2];
    Carc_tot_NM3_s2 = sum(Carc_NM3_s2.');

end

% %plot(Carc_NM3_det);
% boxplot(Carc_NM3_s2);
% set(gca, 'YScale', 'log')
% %ylim([0 1E-06]);
% yline(1E-06,'-','Threshold');
% title("Carcinogenic RIsk Material M3 - Sensitivity 2 approach");
% xlabel("Chemicals");
% ylabel("Carcinogenic Risk");
% xticks([1 2 3 4 5 6]);
% xticklabels({'Beryllium','Chromium','Cobalt','Lead','Strontium','Styrene'});
% xlim([0 7]);

% boxplot(Carc_tot_NM3_s2);
% set(gca, 'YScale', 'log')
% %ylim([0 2E-06]);
% yline(1E-06,'-','Threshold');
% title("Carcinogenic RIsk Material 3 - Sensitivity 2 approach");
% xlabel("Material");
% ylabel("Carcinogenic Risk");
% xticks(1);
% xticklabels({'Material 3'});
% xlim([0 2]);

for i =1:n
    %Ef_s3 = randn(n,1)*0.0274+0.6849;
   % v_ef = 0.0313;
    v_bw = 35.28; 
    mu_bw = log((BW^2)/sqrt(v_bw+BW^2));
    sigma_bw = sqrt(log(v_bw/(BW^2)+1));
    BW_s3 = lognrnd(mu_bw, sigma_bw, n,1);

    %Ingestion Risk
    LADDingNM3_s3 = (IngR.*(NM3_det_carc_ing./1000).*Ef.*Ed)./(BW_s3.*AT_carc);
    
    
    %Risk Quotient - Ingestion 
    Carc_Be_ing_M3_s3 = LADDingNM3_s3(:,1).*SF_ing_M3(1);
    Carc_Cr_ing_M3_s3 = LADDingNM3_s3(:,2).*SF_ing_M3(2);
    Carc_Pb_ing_M3_s3 = LADDingNM3_s3(:,3).*SF_ing_M3(3);
    Carc_Sr_ing_M3_s3 = LADDingNM3_s3(:,4).*SF_ing_M3(4);
    Carc_Styrene_ing_M3_s3 = LADDingNM3_s3(:,5).*SF_ing_M3(5);
    
    
    Carc_ing_M3_s3 = [Carc_Be_ing_M3_s3 Carc_Cr_ing_M3_s3 Carc_Pb_ing_M3_s3 Carc_Sr_ing_M3_s3 Carc_Styrene_ing_M3_s3];
    Carc_tot_ing_M3_s3 = sum(Carc_ing_M3);
    
    % Expsoure assessment - Inhalation
    LADDinhNM3_s3 = (NM3_Carc_inh_M3.*Et.*Ed.*Ef.*InhR)./(PEF.*AT_carc.*BW_s3);
    
    
    %%Risk Quotient - Inhalation 
    Carc_Cr_inh_M3_s3 = LADDinhNM3_s3(:,1).*SF_inh_M3(1);
    Carc_Co_inh_M3_s3 = LADDinhNM3_s3(:,2).*SF_inh_M3(2);
    Carc_Pb_inh_M3_s3 = LADDinhNM3_s3(:,3).*SF_inh_M3(3);
    Carc_Sr_inh_M3_s3 = LADDinhNM3_s3(:,4).*SF_inh_M3(4);
    
    Carc_inh_M3_s3 =[Carc_Cr_inh_M3_s3 Carc_Co_inh_M3_s3 Carc_Pb_inh_M3_s3 Carc_Sr_inh_M3_s3];
    Carc_inh_M3_tot = sum(Carc_inh_M3);
    
    %Dermal exposure
    
    DA_derm_face_carc_M3_s3 = ((NM3_Carc_derm_M3/1000).*Adh_face); %mg/cm2-d
    DA_derm_hand_carc_M3_s3 = ((NM3_Carc_derm_M3/1000).*Adh_hand); %mg/cm2-d
    
    LADD_derm_face_det_M3_s3 = (DA_derm_face_carc_M3_s3*SA_head.*Ef.*Ed)./(AT_carc.*BW_s3); % mg/kg-day
    LADD_derm_hand_det_M3_s3 = (DA_derm_hand_carc_M3_s3*SA_hand.*Ef.*Ed)./(AT_carc.*BW_s3); % mg/kg-day
    
    LADD_derm_M3_s3 = LADD_derm_face_det_M3_s3 + LADD_derm_hand_det_M3_s3;
    
    Carc_Be_derm_M3_s3 = LADD_derm_M3_s3(:,1).*SF_derm_M3(1);
    Carc_Cr_derm_M3_s3 = LADD_derm_M3_s3(:,2).*SF_derm_M3(2);
    Carc_Sr_derm_M3_s3 = LADD_derm_M3_s3(:,3).*SF_derm_M3(3);
    Carc_Styrene_derm_M3_s3 = LADD_derm_M3_s3(:,4).*SF_derm_M3(4);
    
    
    Carc_derm_M3_s3 = [Carc_Be_derm_M3_s3 Carc_Cr_derm_M3_s3 Carc_Sr_derm_M3_s3 Carc_Styrene_derm_M3_s3];
    %Risk Characterization
    
    Carc_Be_M3_s3 = Carc_Be_ing_M3_s3 + Carc_Be_derm_M3_s3;
    Carc_Cr_M3_s3 = Carc_Cr_ing_M3_s3 + Carc_Cr_inh_M3_s3 + Carc_Cr_derm_M3_s3;
    Carc_Co_M3_s3 = Carc_Co_inh_M3_s3;
    Carc_Pb_M3_s3 = Carc_Pb_ing_M3_s3 + Carc_Pb_inh_M3_s3;
    Carc_Sr_M3_s3 = Carc_Sr_ing_M3_s3 + Carc_Sr_inh_M3_s3 + Carc_Sr_derm_M3_s3;
    Carc_Styrene_M3_s3 = Carc_Styrene_ing_M3_s3 + Carc_Styrene_derm_M3_s3;
    
    Carc_NM3_s3 = [Carc_Be_M3_s3 Carc_Cr_M3_s3 Carc_Co_M3_s3 Carc_Pb_M3_s3 Carc_Sr_M3_s3 Carc_Styrene_M3_s3];
    Carc_tot_NM3_s3 = sum(Carc_NM3_s3.');

end

% %plot(Carc_NM3_det);
% boxplot(Carc_NM3_s3);
% set(gca, 'YScale', 'log')
% %ylim([0 1E-06]);
% yline(1E-06,'-','Threshold');
% title("Carcinogenic RIsk Material M3 - Sensitivity 3 approach");
% xlabel("Chemicals");
% ylabel("Carcinogenic Risk");
% xticks([1 2 3 4 5 6]);
% xticklabels({'Beryllium','Chromium','Cobalt','Lead','Strontium','Styrene'});
% xlim([0 7]);


% boxplot(Carc_tot_NM3_s3);
% set(gca, 'YScale', 'log')
% %ylim([0 2E-06]);
% yline(1E-06,'-','Threshold');
% title("Carcinogenic RIsk Material 3 - Sensitivity 3 approach");
% xlabel("Material");
% ylabel("Carcinogenic Risk");
% xticks(1);
% xticklabels({'Material 3'});
% xlim([0 2]);

n=10000;
for i=1:n
    %Ingestion Risk
   CR_ing_M3_s0 = [Beryllium_M3_s0 Chromium_M3_s0 Lead_M3_s0 Strontium_M3_s0 Styrene_M3_s0];

   LADDingNM3_s4 = ((IngR_s1./1000).*(CR_ing_M3_s0./1000).*(Ef_s2./365).*Ed)./(BW_s3.*AT_carc);
    
    
    %Risk Quotient - Ingestion 
    Carc_Be_ing_M3_s4 = LADDingNM3_s4(:,1).*SF_ing_M3(1);
    Carc_Cr_ing_M3_s4 = LADDingNM3_s4(:,2).*SF_ing_M3(2);
    Carc_Pb_ing_M3_s4 = LADDingNM3_s4(:,3).*SF_ing_M3(3);
    Carc_Sr_ing_M3_s4 = LADDingNM3_s4(:,4).*SF_ing_M3(4);
    Carc_Styrene_ing_M3_s4 = LADDingNM3_s4(:,5).*SF_ing_M3(5);
    
    
    Carc_ing_M3_s4 = [Carc_Be_ing_M3_s4 Carc_Cr_ing_M3_s4 Carc_Pb_ing_M3_s4 Carc_Sr_ing_M3_s4 Carc_Styrene_ing_M3_s4];
    Carc_tot_ing_M3_s4 = sum(Carc_ing_M3);
    
    % Expsoure assessment - Inhalation
    NM3_Carc_inh_M3_s0 =[Chromium_M3_s0 Cobalt_M3_s0 Lead_M3_s0 Strontium_M3_s0];
    LADDinhNM3_s4 = (NM3_Carc_inh_M3_s0.*Et.*Ed.*(Ef_s2./365).*(InhR_s1./24))./(PEF.*AT_carc.*BW_s3);
    
    
    %%Risk Quotient - Inhalation 
    Carc_Cr_inh_M3_s4 = LADDinhNM3_s4(:,1).*SF_inh_M3(1);
    Carc_Co_inh_M3_s4 = LADDinhNM3_s4(:,2).*SF_inh_M3(2);
    Carc_Pb_inh_M3_s4 = LADDinhNM3_s4(:,3).*SF_inh_M3(3);
    Carc_Sr_inh_M3_s4 = LADDinhNM3_s4(:,4).*SF_inh_M3(4);
    
    Carc_inh_M3_s4 =[Carc_Cr_inh_M3_s4 Carc_Co_inh_M3_s4 Carc_Pb_inh_M3_s4 Carc_Sr_inh_M3_s4];
    Carc_inh_M3_tot = sum(Carc_inh_M3);
    
    %Dermal exposure
    NM3_Carc_derm_M3_s0 =[Beryllium_M3_s0 Chromium_M3_s0 Strontium_M3_s0 Styrene_M3_s0];

    DA_derm_face_carc_M3_s4 = ((NM3_Carc_derm_M3_s0./1000).*Adh_face); %mg/cm2-d
    DA_derm_hand_carc_M3_s4 = ((NM3_Carc_derm_M3_s0./1000).*Adh_hand); %mg/cm2-d
    
    LADD_derm_face_det_M3_s4 = (DA_derm_face_carc_M3_s4.*SA_head_s1.*(Ef_s2./365).*Ed)./(AT_carc.*BW_s3); % mg/kg-day
    LADD_derm_hand_det_M3_s4 = (DA_derm_hand_carc_M3_s4.*SA_hand_s1.*(Ef_s2./365).*Ed)./(AT_carc.*BW_s3); % mg/kg-day
    
    LADD_derm_M3_s4 = LADD_derm_face_det_M3_s4 + LADD_derm_hand_det_M3_s4;
    
    Carc_Be_derm_M3_s4 = LADD_derm_M3_s4(:,1).*SF_derm_M3(1);
    Carc_Cr_derm_M3_s4 = LADD_derm_M3_s4(:,2).*SF_derm_M3(2);
    Carc_Sr_derm_M3_s4 = LADD_derm_M3_s4(:,3).*SF_derm_M3(3);
    Carc_Styrene_derm_M3_s4 = LADD_derm_M3_s4(:,4).*SF_derm_M3(4);
    
    
    Carc_derm_M3_s4 = [Carc_Be_derm_M3_s4 Carc_Cr_derm_M3_s4 Carc_Sr_derm_M3_s4 Carc_Styrene_derm_M3_s4];
    %Risk Characterization
    
    Carc_Be_M3_s4 = Carc_Be_ing_M3_s4 + Carc_Be_derm_M3_s4;
    Carc_Cr_M3_s4 = Carc_Cr_ing_M3_s4 + Carc_Cr_inh_M3_s4 + Carc_Cr_derm_M3_s4;
    Carc_Co_M3_s4 = Carc_Co_inh_M3_s4;
    Carc_Pb_M3_s4 = Carc_Pb_ing_M3_s4 + Carc_Pb_inh_M3_s4;
    Carc_Sr_M3_s4 = Carc_Sr_ing_M3_s4 + Carc_Sr_inh_M3_s4 + Carc_Sr_derm_M3_s4;
    Carc_Styrene_M3_s4 = Carc_Styrene_ing_M3_s4 + Carc_Styrene_derm_M3_s4;
    
    Carc_NM3_s4 = [Carc_Be_M3_s4 Carc_Cr_M3_s4 Carc_Co_M3_s4 Carc_Pb_M3_s4 Carc_Sr_M3_s4 Carc_Styrene_M3_s4];
    Carc_tot_NM3_s4 = sum(Carc_NM3_s4.');

end

% %plot(Carc_NM3_det);
% boxplot(Carc_NM3_s4);
% set(gca, 'YScale', 'log')
% %ylim([0 1E-06]);
% yline(1E-06,'-','Threshold');
% title("Carcinogenic RIsk Material M3 - Sensitivity 4 approach");
% xlabel("Chemicals");
% ylabel("Carcinogenic Risk");
% xticks([1 2 3 4 5 6]);
% xticklabels({'Beryllium','Chromium','Cobalt','Lead','Strontium','Styrene'});
% xlim([0 7]);

boxplot(Carc_tot_NM3_s4);
set(gca, 'YScale', 'log')
%ylim([0 2E-06]);
yline(1E-06,'-','Threshold');
title("Carcinogenic RIsk Material 3 - Sensitivity 3 approach");
xlabel("Material");
ylabel("Carcinogenic Risk");
xticks(1);
xticklabels({'Material 3'});
xlim([0 2]);
