%QCRA MODEL 1
Ef = 250/365; % days/year
Ed = 25; %years
Et = 8; %hrs
CF = 10E-06; %kg/m3
%IngR = 0.0658; %g/pers/day
IngR = 0.03;%g/pers/day
%IngR = mean of lognormal distibution; %g/pers/day
BW = 7.58E+01; %kg
AT = Ed*365; %days
%InhR = 0.8875; %m3/h
%InhR = 0.1296;
InhR_day = 3.189; %m3/day
InhR = 15.52/24; %m3/h
%InhR = prctile([3 2.9 3.12 3.18], 95)/24;
PEF = 1.36E+09; %m3/g
%SA = 5.7E+03; %cm2
%kp = 1; %100% In this equation the s1ault rate of 100% dermal absorption is assumed.
AT_carc = 70*365; %lifetime in days
SA_hand = 980; %cm2
SA_head= 1250; %cm2
Adh_hand = 2.76E-04; %g/cm2
Adh_face = 9.82E-05; %g/cm2
Ef_derm = 2; %ev/day

mass_product= 1; %kg
mass_reed = mass_product*10/100; %g
mass_Calcite = mass_product*60/100; %kg
mass_UPR_polyester = mass_product*28/100; %g



%Carcinogenic risk - Default
%Exposure Assessment - Ingestion route
%List heavy metals carcinogenic effects: Arsenic, Cadmiun (inh), Chromium (IV) (inh), Nickel,Beryllium
%(inh),cobalt (?),  

%Composition NM4
Beryllium_det = 2.42E-03;
Chromium_det = 3.68E-01;
Cobalt_M4_det = 2.96E-02;
Lead_M4_det = 1.55E+00;
Nickel_det = 3.82E-01;
Strontium_M4_det = 1.67E+02;
Furfuryl_Alchol_det = 5.20E+03; %mg/kg
% Exposure assessment: Ingestion

NM4_carc_ing_det = [Beryllium_det Chromium_det Lead_M4_det Nickel_det Strontium_M4_det Furfuryl_Alchol_det];
LADD_ing_Det = ((NM4_carc_ing_det./1000).*IngR.*Et.*Ef)./(BW.*AT_carc);
SF_ing = [0.17; 0.5; 8.5E-03; 0.91; 8.9E-10; 1.31E-01];

%Risk Ingestion

CR_ing_Be_det = LADD_ing_Det(1).*SF_ing(1);
CR_ing_Cr_det = LADD_ing_Det(2).*SF_ing(2);
CR_ing_Pb_det = LADD_ing_Det(3).*SF_ing(3);
CR_ing_Ni_det = LADD_ing_Det(4).*SF_ing(4);
CR_ing_Sr_det = LADD_ing_Det(5).*SF_ing(5);
CR_ing_FA_det = LADD_ing_Det(6).*SF_ing(6);

CR_M4_ing_Det = [CR_ing_Be_det CR_ing_Cr_det CR_ing_Pb_det CR_ing_Ni_det CR_ing_Sr_det CR_ing_FA_det];
CR_M4_ing_Det_tot = sum(CR_M4_ing_Det);

%Exposure assessment: Inhalation
NM4_carc_inh_det = [Chromium_det Cobalt_M4_det Lead_M4_det Strontium_M4_det];

LADD_NM4_inh_det =(NM4_carc_inh_det.*InhR.*Ef.*Et)./(PEF.*BW.*AT_carc);

SF_inh_8020 = [41; 27; 0.042; 1.5E-09];

CR_inh_Cr_det = LADD_NM4_inh_det(1).*SF_inh_8020(1);
CR_inh_Co_det = LADD_NM4_inh_det(2).*SF_inh_8020(2);
CR_inh_Pb_det = LADD_NM4_inh_det(3).*SF_inh_8020(3);
CR_inh_Sr_det = LADD_NM4_inh_det(4).*SF_inh_8020(4);

CR_inh_M4_det = [CR_inh_Cr_det CR_inh_Co_det CR_ing_Pb_det CR_inh_Sr_det];
CR_inh_M4_det_tot = sum(CR_inh_M4_det);


%Dermal contact
NM4_derm_Det = [Beryllium_det Chromium_det Nickel_det Strontium_M4_det Furfuryl_Alchol_det];
DA_derm_face = ((NM4_derm_Det./1000).*Adh_face); %g/cm2-ev
DA_derm_hand = ((NM4_derm_Det./1000).*Adh_hand); %g/cm2-ev

LADD_derm_face = (DA_derm_face.*SA_head.*Ef.*Ed)./(AT_carc.*BW); % mg/kg-day
LADD_derm_hand = (DA_derm_hand.*SA_hand.*Ef.*Ed)./(AT_carc.*BW); % mg/kg-day

LADD_derm_M4_det = LADD_derm_face + LADD_derm_hand;

SF_derm =[2.43E+01; 20; 2.28E+01; 8.9E-10; 1.31E-01];

CR_derm_Be_det = LADD_derm_M4_det(1)*SF_derm(1);
CR_derm_Cr_det = LADD_derm_M4_det(2)*SF_derm(2);
CR_derm_Ni_det = LADD_derm_M4_det(3)*SF_derm(3);
CR_derm_Sr_det = LADD_derm_M4_det(4)*SF_derm(4);
CR_derm_FA_det = LADD_derm_M4_det(5)*SF_derm(5);

CR_derm_M4_det =[CR_derm_Be_det CR_derm_Cr_det CR_derm_Ni_det CR_derm_Sr_det CR_derm_FA_det];
CR_derm_M4_det_tot = sum(CR_derm_M4_det);

%Risk 
CR_Be_M4_det = CR_ing_Be_det + CR_derm_Be_det;
CR_Cr_M4_det = CR_ing_Cr_det + CR_inh_Cr_det + CR_derm_Cr_det;
CR_Co_M4_det = CR_inh_Co_det;
CR_Pb_M4_det = CR_ing_Pb_det + CR_inh_Pb_det;
CR_Ni_M4_det = CR_ing_Ni_det + CR_derm_Ni_det;
CR_Sr_M4_det = CR_ing_Sr_det + CR_inh_Sr_det + CR_derm_Sr_det;
CR_FA_M4_det = CR_ing_FA_det + CR_derm_FA_det;


CR_M4_Det = [CR_Be_M4_det CR_Cr_M4_det CR_Co_M4_det CR_Pb_M4_det CR_Ni_M4_det CR_Sr_M4_det CR_FA_M4_det];
CR_M4_Det_tot = sum(CR_M4_Det);

bar(CR_M4_Det,0.4);
set(gca, 'YScale', 'log')
ylim([0 2]);
yline(1E-06,'-','Threshold');
title("RI Material M4 - Determinisic approach");
xlabel("Chemicals");
ylabel("Carcinogenic Risk");
xticks([1 2 3 4 5 6 7]);
xticklabels(["Beryllium","Chromium","Cobalt","Lead","Nickel","Strontium","Furfuryl Alchol"]);
xlim([0 8]);

%Sensitivity s0
n=10000;

for i=1:n
     
    %Composition M4
    Beryllium_M4_s0 = (2.42E-03-0)*rand(n,1)+0;
    Chromium_M4_s0 = (3.68E-01-0)*rand(n,1)+0;
    Cobalt_M4_s0 = (2.96E-02-0)*rand(n,1)+0;
    Lead_M4_s0 = (1.55E+00-0)*rand(n,1)+0;
    Nickel_M4_s0 = (3.82E-01-0)*rand(n,1)+0;
    Strontium_M4_s0 = (1.67E+02-0)*rand(n,1)+0;
    
    Furfuryl_Alchol_s0 = (5.20E+03-0)*rand(n,1)+0;

    %Ingestion exposure
    NM4_carc_ing_s0 = [Beryllium_M4_s0 Chromium_M4_s0 Lead_M4_s0 Nickel_M4_s0 Strontium_M4_s0 Furfuryl_Alchol_s0];
    LADD_ing_s0 = ((NM4_carc_ing_s0./1000).*IngR.*Et.*Ef)./(BW.*AT_carc);
    SF_ing = [0.17; 0.5; 8.5E-03; 0.91; 8.9E-10; 1.31E-01];
    
    %Risk Ingestion
    
    CR_ing_Be_s0 = LADD_ing_s0(:,1).*SF_ing(1);
    CR_ing_Cr_s0 = LADD_ing_s0(:,2).*SF_ing(2);
    CR_ing_Pb_s0 = LADD_ing_s0(:,3).*SF_ing(3);
    CR_ing_Ni_s0 = LADD_ing_s0(:,4).*SF_ing(4);
    CR_ing_Sr_s0 = LADD_ing_s0(:,5).*SF_ing(5);
    CR_ing_FA_s0 = LADD_ing_s0(:,6).*SF_ing(6);

    %Exposure assessment: Inhalation
    NM4_carc_inh_s0 = [Chromium_M4_s0 Cobalt_M4_s0 Lead_M4_s0 Strontium_M4_s0];

    LADD_NM4_inh_s0 =(NM4_carc_inh_s0.*InhR.*Ef.*Et)./(PEF.*BW.*AT_carc);

    SF_inh_8020 = [41; 27; 0.042; 1.5E-09];

    CR_inh_Cr_s0 = LADD_NM4_inh_s0(:,1).*SF_inh_8020(1);
    CR_inh_Co_s0 = LADD_NM4_inh_s0(:,2).*SF_inh_8020(2);
    CR_inh_Pb_s0 = LADD_NM4_inh_s0(:,3).*SF_inh_8020(3);
    CR_inh_Sr_s0 = LADD_NM4_inh_s0(:,4).*SF_inh_8020(4);

%Dermal contact
    NM4_derm_s0 = [Beryllium_M4_s0 Chromium_M4_s0 Nickel_M4_s0 Strontium_M4_s0 Furfuryl_Alchol_s0];
    DA_derm_face_s0 = ((NM4_derm_s0./1000).*Adh_face); %g/cm2-ev
    DA_derm_hand_s0 = ((NM4_derm_s0./1000).*Adh_hand); %g/cm2-ev

    LADD_derm_face_s0 = (DA_derm_face_s0.*SA_head.*Ef.*Ed)./(AT_carc.*BW); % mg/kg-day
    LADD_derm_hand_s0 = (DA_derm_hand_s0.*SA_hand.*Ef.*Ed)./(AT_carc.*BW); % mg/kg-day

    LADD_derm_M4_s0 = LADD_derm_face_s0 + LADD_derm_hand_s0;

    SF_derm =[2.43E+01; 20; 2.28E+01; 8.9E-10; 1.31E-01];

    CR_derm_Be_s0 = LADD_derm_M4_s0(:,1)*SF_derm(1);
    CR_derm_Cr_s0 = LADD_derm_M4_s0(:,2)*SF_derm(2);
    CR_derm_Ni_s0 = LADD_derm_M4_s0(:,3)*SF_derm(3);
    CR_derm_Sr_s0 = LADD_derm_M4_s0(:,4)*SF_derm(4);
    CR_derm_FA_s0 = LADD_derm_M4_s0(:,5)*SF_derm(5);


    %Risk 
    CR_Be_M4_s0 = CR_ing_Be_s0 + CR_derm_Be_s0;
    CR_Cr_M4_s0 = CR_ing_Cr_s0 + CR_inh_Cr_s0 + CR_derm_Cr_s0;
    CR_Co_M4_s0 = CR_inh_Co_s0;
    CR_Pb_M4_s0 = CR_ing_Pb_s0 + CR_inh_Pb_s0;
    CR_Ni_M4_s0 = CR_ing_Ni_s0 + CR_derm_Ni_s0;
    CR_Sr_M4_s0 = CR_ing_Sr_s0 + CR_inh_Sr_s0 + CR_derm_Sr_s0;
    CR_FA_M4_s0 = CR_ing_FA_s0 + CR_derm_FA_s0;


    Cancer_M4_s0 = [CR_Be_M4_s0 CR_Cr_M4_s0 CR_Co_M4_s0 CR_Pb_M4_s0 CR_Ni_M4_s0 CR_Sr_M4_s0 CR_FA_M4_s0];
    CR_M4_s0_tot = sum(Cancer_M4_s0.');
end 
% x=1:10000;
% boxplot(CR_M4_s0);
% set(gca, 'YScale', 'log')
% ylim([0 2]);
% yline(1E-06,'-','Threshold');
% title("RI Material M4 - sensitivity s0 approach");
% xlabel("Chemicals");
% ylabel("Carcinogenic Risk");
% xticks([1 2 3 4 5 6 7]);
% xticklabels(["Beryllium","Chromium","Cobalt","Lead","Nickel","Strontium","Furfuryl Alchol"]);
% xlim([0 8]);

boxplot(CR_M4_s0_tot);
set(gca, 'YScale', 'log')
ylim([0 2]);
yline(1E-06,'-','Threshold');
title("Carcinogenic Risk Material 4 - sensitivity s0 approach");
xlabel("Material");
ylabel("Carcinogenic Risk");
xticks(1);
xticklabels("Material 4");
xlim([0 2]);

%QCRA MODEL 1
% QCRA NM4 Human health risks - deerministic model
%Input data
%Sensitivity model s1
for i =1:n
    v1 = 1.44;
    m1 = 30; %mg/day
    mu1 = log((m1.^2)./sqrt(v1+(m1.^2)));
    sigma1 = sqrt(log(v1./(m1.^2)+1));
    IngR_s1 = lognrnd(mu1,sigma1,n,1);
    %IngR_s1 = randn(n,1)*0.0012+IngR;
    %InhR_s1 = randn(n,1)*0.0051+InhR;

    v = 0.567;
    m = 15.52;
    mu = log((m^2)/sqrt(v+m^2));
    sigma = sqrt(log(v/(m^2)+1));
    InhR_s1 = lognrnd(mu,sigma,n,1);

    %Adh_face_s1 = randn(n,1)*1.4500e-06+Adh_face;
    v_face = 24200;
    mu_face = log((SA_head^2)/sqrt(v_face+SA_head^2));
    sigma_face = sqrt(log(v_face/(SA_head^2)+1));
    SA_head_s1 = lognrnd(mu_face, sigma_face,n,1);

    v_hands = 16200;
    mu_hands = log((SA_hand^2)/sqrt(v_hands+SA_hand^2));
    sigma_hand = sqrt(log(v_hands/(SA_hand^2)+1));
    SA_hand_s1 = lognrnd(mu_hands, sigma_hand, n,1);

    %Adh_hand_s1 = randn(n,1)*9.6000e-06+Adh_hand;


    % Exposure assessment: Ingestion

    NM4_carc_ing_det = [Beryllium_det Chromium_det Lead_M4_det Nickel_det Strontium_M4_det Furfuryl_Alchol_det];
    LADD_ing_s1 = ((NM4_carc_ing_det./1000).*(IngR_s1./1000).*Et.*Ef)./(BW.*AT_carc);
    SF_ing = [0.17; 0.5; 8.5E-03; 0.91; 8.9E-10; 1.31E-01];

%Risk Ingestion

    CR_ing_Be_s1 = LADD_ing_s1(:,1).*SF_ing(1);
    CR_ing_Cr_s1 = LADD_ing_s1(:,2).*SF_ing(2);
    CR_ing_Pb_s1 = LADD_ing_s1(:,3).*SF_ing(3);
    CR_ing_Ni_s1 = LADD_ing_s1(:,4).*SF_ing(4);
    CR_ing_Sr_s1 = LADD_ing_s1(:,5).*SF_ing(5);
    CR_ing_FA_s1 = LADD_ing_s1(:,6).*SF_ing(6);

    
%Exposure assessment: Inhalation
    NM4_carc_inh_det = [Chromium_det Cobalt_M4_det Lead_M4_det Strontium_M4_det];

    LADD_NM4_inh_s1 =(NM4_carc_inh_det.*(InhR_s1./24).*Ef.*Et)./(PEF.*BW.*AT_carc);

    SF_inh_8020 = [41; 27; 0.042; 1.5E-09];

    CR_inh_Cr_s1 = LADD_NM4_inh_s1(:,1).*SF_inh_8020(1);
    CR_inh_Co_s1 = LADD_NM4_inh_s1(:,2).*SF_inh_8020(2);
    CR_inh_Pb_s1 = LADD_NM4_inh_s1(:,3).*SF_inh_8020(3);
    CR_inh_Sr_s1 = LADD_NM4_inh_s1(:,4).*SF_inh_8020(4);

    %Dermal contact
    NM4_derm_Det = [Beryllium_det Chromium_det Nickel_det Strontium_M4_det Furfuryl_Alchol_det];
    CR_DA_derm_face_s1 = ((NM4_derm_Det./1000).*Adh_face); %g/cm2-ev
    CR_DA_derm_hand_1 = ((NM4_derm_Det./1000).*Adh_hand); %g/cm2-ev

    LADD_derm_face_s1 = (CR_DA_derm_face_s1.*SA_head_s1.*Ef.*Ed)./(AT_carc.*BW); % mg/kg-day
    LADD_derm_hand_s1 = (CR_DA_derm_hand_1.*SA_hand_s1.*Ef.*Ed)./(AT_carc.*BW); % mg/kg-day

    LADD_derm_M4_s1 = LADD_derm_face_s1 + LADD_derm_hand_s1;

    SF_derm =[2.43E+01; 20; 2.28E+01; 8.9E-10; 1.31E-01];

    CR_derm_Be_s1 = LADD_derm_M4_s1(:,1)*SF_derm(1);
    CR_derm_Cr_s1 = LADD_derm_M4_s1(:,2)*SF_derm(2);
    CR_derm_Ni_s1 = LADD_derm_M4_s1(:,3)*SF_derm(3);
    CR_derm_Sr_s1 = LADD_derm_M4_s1(:,4)*SF_derm(4);
    CR_derm_FA_s1 = LADD_derm_M4_s1(:,5)*SF_derm(5);


    %Risk 
    CR_Be_M4_s1 = CR_ing_Be_s1 + CR_derm_Be_s1;
    CR_Cr_M4_s1 = CR_ing_Cr_s1 + CR_inh_Cr_s1 + CR_derm_Cr_s1;
    CR_Co_M4_s1 = CR_inh_Co_s1;
    CR_Pb_M4_s1 = CR_ing_Pb_s1 + CR_inh_Pb_s1;
    CR_Ni_M4_s1 = CR_ing_Ni_s1 + CR_derm_Ni_s1;
    CR_Sr_M4_s1 = CR_ing_Sr_s1 + CR_inh_Sr_s1 + CR_derm_Sr_s1;
    CR_FA_M4_s1 = CR_ing_FA_s1 + CR_derm_FA_s1;


    Cancer_M4_s1 = [CR_Be_M4_s1 CR_Cr_M4_s1 CR_Co_M4_s1 CR_Pb_M4_s1 CR_Ni_M4_s1 CR_Sr_M4_s1 CR_FA_M4_s1];
    CR_M4_s1_tot = sum(Cancer_M4_s1.');
end 

% x = 1:10000;
% boxplot(CR_M4_s1)
% set(gca, 'YScale', 'log')
% %ylim([0 2]);
% yline(1E-06,'-','Threshold');
% title("RI Material M4 - sensitivity 1 approach");
% xlabel("Chemicals");
% ylabel("Carcinogenic Risk");
% xticks([1 2 3 4 5 6 7]);
% xticklabels(["Beryllium","Chromium","Cobalt","Lead","Nickel","Strontium","Furfuryl Alchol"]);
% xlim([0 8]);


boxplot(CR_M4_s1_tot);
set(gca, 'YScale', 'log')
ylim([0 2]);
yline(1E-06,'-','Threshold');
title("Carcinogenic Risk Material 4 - sensitivity s1 approach");
xlabel("Material");
ylabel("Carcinogenic Risk");
xticks(1);
xticklabels("Material 4");
xlim([0 2]);
%Sensitivity 2
for i =1:n
    v_ef = 11; 
    mu_ef = log((275^2)/sqrt(v_ef+275^2));
    sigma_ef = sqrt(log(v_ef/(275^2)+1));
    Ef_s2 = lognrnd(mu_ef, sigma_ef, n,1);
    
    %inegstion
    NM4_carc_ing_det = [Beryllium_det Chromium_det Lead_M4_det Nickel_det Strontium_M4_det Furfuryl_Alchol_det];
    LADD_ing_s2 = ((NM4_carc_ing_det./1000).*IngR.*Et.*(Ef_s2./365))./(BW.*AT_carc);
    SF_ing = [0.17; 0.5; 8.5E-03; 0.91; 8.9E-10; 1.31E-01];

%Risk Ingestion

    CR_ing_Be_s2 = LADD_ing_s2(:,1).*SF_ing(1);
    CR_ing_Cr_s2 = LADD_ing_s2(:,2).*SF_ing(2);
    CR_ing_Pb_s2 = LADD_ing_s2(:,3).*SF_ing(3);
    CR_ing_Ni_s2 = LADD_ing_s2(:,4).*SF_ing(4);
    CR_ing_Sr_s2 = LADD_ing_s2(:,5).*SF_ing(5);
    CR_ing_FA_s2 = LADD_ing_s2(:,6).*SF_ing(6);

    
%Exposure assessment: Inhalation
    NM4_carc_inh_det = [Chromium_det Cobalt_M4_det Lead_M4_det Strontium_M4_det];

    LADD_NM4_inh_s2 =(NM4_carc_inh_det.*InhR.*(Ef_s2./365).*Et)./(PEF.*BW.*AT_carc);

    SF_inh_8020 = [41; 27; 0.042; 1.5E-09];

    CR_inh_Cr_s2 = LADD_NM4_inh_s2(:,1).*SF_inh_8020(1);
    CR_inh_Co_s2 = LADD_NM4_inh_s2(:,2).*SF_inh_8020(2);
    CR_inh_Pb_s2 = LADD_NM4_inh_s2(:,3).*SF_inh_8020(3);
    CR_inh_Sr_s2 = LADD_NM4_inh_s2(:,4).*SF_inh_8020(4);

    %Dermal contact
    NM4_derm_Det = [Beryllium_det Chromium_det Nickel_det Strontium_M4_det Furfuryl_Alchol_det];
    DA_derm_face_s2 = ((NM4_derm_Det./1000).*Adh_face); %g/cm2-ev
    DA_derm_hand_s2 = ((NM4_derm_Det./1000).*Adh_hand); %g/cm2-ev

    LADD_derm_face_s2 = (DA_derm_face_s2.*SA_head.*(Ef_s2./365).*Ed)./(AT_carc.*BW); % mg/kg-day
    LADD_derm_hand_s2 = (DA_derm_hand_s2.*SA_hand.*(Ef_s2./365).*Ed)./(AT_carc.*BW); % mg/kg-day

    LADD_derm_M4_s2 = LADD_derm_face_s2 + LADD_derm_hand_s2;

    SF_derm =[2.43E+01; 20; 2.28E+01; 8.9E-10; 1.31E-01];

    CR_derm_Be_s2 = LADD_derm_M4_s2(:,1)*SF_derm(1);
    CR_derm_Cr_s2 = LADD_derm_M4_s2(:,2)*SF_derm(2);
    CR_derm_Ni_s2 = LADD_derm_M4_s2(:,3)*SF_derm(3);
    CR_derm_Sr_s2 = LADD_derm_M4_s2(:,4)*SF_derm(4);
    CR_derm_FA_s2 = LADD_derm_M4_s2(:,5)*SF_derm(5);


    %Risk 
    CR_Be_M4_s2 = CR_ing_Be_s2 + CR_derm_Be_s2;
    CR_Cr_M4_s2 = CR_ing_Cr_s2 + CR_inh_Cr_s2 + CR_derm_Cr_s2;
    CR_Co_M4_s2 = CR_inh_Co_s2;
    CR_Pb_M4_s2 = CR_ing_Pb_s2 + CR_inh_Pb_s2;
    CR_Ni_M4_s2 = CR_ing_Ni_s2 + CR_derm_Ni_s2;
    CR_Sr_M4_s2 = CR_ing_Sr_s2 + CR_inh_Sr_s2 + CR_derm_Sr_s2;
    CR_FA_M4_s2 = CR_ing_FA_s2 + CR_derm_FA_s2;


    Cancer_M4_s2 = [CR_Be_M4_s2 CR_Cr_M4_s2 CR_Co_M4_s2 CR_Pb_M4_s2 CR_Ni_M4_s2 CR_Sr_M4_s2 CR_FA_M4_s2];
    CR_M4_s2_tot = sum(Cancer_M4_s2.');
end 

% x = 1:10000;
% boxplot(CR_M4_s2)
% set(gca, 'YScale', 'log')
% %ylim([0 2]);
% yline(1E-06,'-','Threshold');
% title("RI Material M4 - sensitivity 2 approach");
% xlabel("Chemicals");
% ylabel("Carcinogenic Risk");
% xticks([1 2 3 4 5 6 7]);
% xticklabels(["Beryllium","Chromium","Cobalt","Lead","Nickel","Strontium","Furfuryl Alchol"]);
% xlim([0 8]);

boxplot(CR_M4_s2_tot);
set(gca, 'YScale', 'log')
%ylim([0 2]);
yline(1E-06,'-','Threshold');
title("Carcinogenic Risk Material 4 - sensitivity s2 approach");
xlabel("Materia 4");
ylabel("Carcinogenic Risk");
xticks(1);
xticklabels("Material 4");

%Sensitivity s3
for i =1:n
    
    v_bw = 35.28;
    mu_bw = log((BW^2)/sqrt(v_bw+BW^2));
    sigma_bw = sqrt(log(v_bw/(BW^2)+1));
    BW_s3 = lognrnd(mu_bw, sigma_bw, n,1);
    %inegstion
    NM4_carc_ing_det = [Beryllium_det Chromium_det Lead_M4_det Nickel_det Strontium_M4_det Furfuryl_Alchol_det];
    LADD_ing_s3 = ((NM4_carc_ing_det./1000).*IngR.*Et.*Ef)./(BW_s3.*AT_carc);
    SF_ing = [0.17; 0.5; 8.5E-03; 0.91; 8.9E-10; 1.31E-01];

%Risk Ingestion

    CR_ing_Be_s3 = LADD_ing_s3(:,1).*SF_ing(1);
    CR_ing_Cr_s3 = LADD_ing_s3(:,2).*SF_ing(2);
    CR_ing_Pb_s3 = LADD_ing_s3(:,3).*SF_ing(3);
    CR_ing_Ni_s3 = LADD_ing_s3(:,4).*SF_ing(4);
    CR_ing_Sr_s3 = LADD_ing_s3(:,5).*SF_ing(5);
    CR_ing_FA_s3 = LADD_ing_s3(:,6).*SF_ing(6);

    
%Exposure assessment: Inhalation
    NM4_carc_inh_det = [Chromium_det Cobalt_M4_det Lead_M4_det Strontium_M4_det];

    LADD_NM4_inh_s3 =(NM4_carc_inh_det.*InhR.*Ef.*Et)./(PEF.*BW_s3.*AT_carc);

    SF_inh_8020 = [41; 27; 0.042; 1.5E-09];

    CR_inh_Cr_s3 = LADD_NM4_inh_s3(:,1).*SF_inh_8020(1);
    CR_inh_Co_s3 = LADD_NM4_inh_s3(:,2).*SF_inh_8020(2);
    CR_inh_Pb_s3 = LADD_NM4_inh_s3(:,3).*SF_inh_8020(3);
    CR_inh_Sr_s3 = LADD_NM4_inh_s3(:,4).*SF_inh_8020(4);

    %Dermal contact
    NM4_derm_Det = [Beryllium_det Chromium_det Nickel_det Strontium_M4_det Furfuryl_Alchol_det];
    DA_derm_face_s3 = ((NM4_derm_Det./1000).*Adh_face); %g/cm2-ev
    DA_derm_hand_s3 = ((NM4_derm_Det./1000).*Adh_hand); %g/cm2-ev

    LADD_derm_face_s3 = (DA_derm_face_s3.*SA_head.*Ef.*Ed)./(AT_carc.*BW_s3); % mg/kg-day
    LADD_derm_hand_s3 = (DA_derm_hand_s3.*SA_hand.*Ef.*Ed)./(AT_carc.*BW_s3); % mg/kg-day

    LADD_derm_M4_s3 = LADD_derm_face_s3 + LADD_derm_hand_s3;

    SF_derm =[2.43E+01; 20; 2.28E+01; 8.9E-10; 1.31E-01];

    CR_derm_Be_s3 = LADD_derm_M4_s3(:,1)*SF_derm(1);
    CR_derm_Cr_s3 = LADD_derm_M4_s3(:,2)*SF_derm(2);
    CR_derm_Ni_s3 = LADD_derm_M4_s3(:,3)*SF_derm(3);
    CR_derm_Sr_s3 = LADD_derm_M4_s3(:,4)*SF_derm(4);
    CR_derm_FA_s3 = LADD_derm_M4_s3(:,5)*SF_derm(5);


    %Risk 
    CR_Be_M4_s3 = CR_ing_Be_s3 + CR_derm_Be_s3;
    CR_Cr_M4_s3 = CR_ing_Cr_s3 + CR_inh_Cr_s3 + CR_derm_Cr_s3;
    CR_Co_M4_s3 = CR_inh_Co_s3;
    CR_Pb_M4_s3 = CR_ing_Pb_s3 + CR_inh_Pb_s3;
    CR_Ni_M4_s3 = CR_ing_Ni_s3 + CR_derm_Ni_s3;
    CR_Sr_M4_s3 = CR_ing_Sr_s3 + CR_inh_Sr_s3 + CR_derm_Sr_s3;
    CR_FA_M4_s3 = CR_ing_FA_s3 + CR_derm_FA_s3;


    Cancer_M4_s3 = [CR_Be_M4_s3 CR_Cr_M4_s3 CR_Co_M4_s3 CR_Pb_M4_s3 CR_Ni_M4_s3 CR_Sr_M4_s3 CR_FA_M4_s3];
    CR_M4_s3_tot =sum(Cancer_M4_s3.');
end 

% x = 1:10000;
% boxplot(CR_M4_s3)
% set(gca, 'YScale', 'log')
% %ylim([0 2]);
% yline(1E-06,'-','Threshold');
% title("RI Material M4 - sensitivity 3 approach");
% xlabel("Chemicals");
% ylabel("Carcinogenic Risk");
% xticks([1 2 3 4 5 6 7]);
% xticklabels(["Beryllium","Chromium","Cobalt","Lead","Nickel","Strontium","Furfuryl Alchol"]);
% xlim([0 8]);

boxplot(CR_M4_s3_tot);
set(gca, 'YScale', 'log')
%ylim([0 2]);
yline(1E-06,'-','Threshold');
title("Carcinogenic Risk Material 4 - sensitivity s3 approach");
xlabel("Materia 4");
ylabel("Carcinogenic Risk");
xticks(1);
xticklabels("Material 4");

%Sensitivity s3
for i =1:n
    %inegstion
    NM4_carc_ing_s0 = [Beryllium_M4_s0 Chromium_M4_s0 Lead_M4_s0 Nickel_M4_s0 Strontium_M4_s0 Furfuryl_Alchol_s0];
    LADD_ing_s4 = ((NM4_carc_ing_s0./1000).*(IngR_s1./1000).*Et.*(Ef_s2./365))./(BW_s3.*AT_carc);
    SF_ing = [0.17; 0.5; 8.5E-03; 0.91; 8.9E-10; 1.31E-01];

%Risk Ingestion

    CR_ing_Be_s4 = LADD_ing_s4(:,1).*SF_ing(1);
    CR_ing_Cr_s4 = LADD_ing_s4(:,2).*SF_ing(2);
    CR_ing_Pb_s4 = LADD_ing_s4(:,3).*SF_ing(3);
    CR_ing_Ni_s4 = LADD_ing_s4(:,4).*SF_ing(4);
    CR_ing_Sr_s4 = LADD_ing_s4(:,5).*SF_ing(5);
    CR_ing_FA_s4 = LADD_ing_s4(:,6).*SF_ing(6);

    
%Exposure assessment: Inhalation
    NM4_carc_inh_s0 = [Chromium_M4_s0 Cobalt_M4_s0 Lead_M4_s0 Strontium_M4_s0];

    LADD_NM4_inh_s4 =(NM4_carc_inh_s0.*(InhR_s1./24).*(Ef_s2./265).*Et)./(PEF.*BW_s3.*AT_carc);

    SF_inh_8020 = [41; 27; 0.042; 1.5E-09];

    CR_inh_Cr_s4 = LADD_NM4_inh_s4(:,1).*SF_inh_8020(1);
    CR_inh_Co_s4 = LADD_NM4_inh_s4(:,2).*SF_inh_8020(2);
    CR_inh_Pb_s4 = LADD_NM4_inh_s4(:,3).*SF_inh_8020(3);
    CR_inh_Sr_s4 = LADD_NM4_inh_s4(:,4).*SF_inh_8020(4);

    %Dermal contact
    NM4_derm_s0 = [Beryllium_M4_s0 Chromium_M4_s0 Nickel_M4_s0 Strontium_M4_s0 Furfuryl_Alchol_s0];
    DA_derm_face_s4 = ((NM4_derm_s0./1000).*Adh_face); %g/cm2-ev
    DA_derm_hand_s4 = ((NM4_derm_s0./1000).*Adh_hand); %g/cm2-ev

    LADD_derm_face_s4 = (DA_derm_face_s4.*SA_head_s1.*(Ef_s2./365).*Ed)./(AT.*BW_s3); % mg/kg-day
    LADD_derm_hand_s4 = (DA_derm_hand_s4.*SA_hand_s1.*(Ef_s2./365).*Ed)./(AT.*BW_s3); % mg/kg-day

    LADD_derm_M4_s4 = LADD_derm_face_s4 + LADD_derm_hand_s4;

    SF_derm =[2.43E+01; 20; 2.28E+01; 8.9E-10; 1.31E-01];

    CR_derm_Be_s4 = LADD_derm_M4_s4(:,1)*SF_derm(1);
    CR_derm_Cr_s4 = LADD_derm_M4_s4(:,2)*SF_derm(2);
    CR_derm_Ni_s4 = LADD_derm_M4_s4(:,3)*SF_derm(3);
    CR_derm_Sr_s4 = LADD_derm_M4_s4(:,4)*SF_derm(4);
    CR_derm_FA_s4 = LADD_derm_M4_s4(:,5)*SF_derm(5);


    %Risk 
    CR_Be_M4_s4 = CR_ing_Be_s4 + CR_derm_Be_s4;
    CR_Cr_M4_s4 = CR_ing_Cr_s4 + CR_inh_Cr_s4 + CR_derm_Cr_s4;
    CR_Co_M4_s4 = CR_inh_Co_s4;
    CR_Pb_M4_s4 = CR_ing_Pb_s4 + CR_inh_Pb_s4;
    CR_Ni_M4_s4 = CR_ing_Ni_s4 + CR_derm_Ni_s4;
    CR_Sr_M4_s4 = CR_ing_Sr_s4 + CR_inh_Sr_s4 + CR_derm_Sr_s4;
    CR_FA_M4_s4 = CR_ing_FA_s4 + CR_derm_FA_s4;


    Cancer_M4_s4 = [CR_Be_M4_s4 CR_Cr_M4_s4 CR_Co_M4_s4 CR_Pb_M4_s4 CR_Ni_M4_s4 CR_Sr_M4_s4 CR_FA_M4_s4];
    CR_M4_s4_tot = sum(Cancer_M4_s4.');
end 

% x = 1:10000;
% boxplot(CR_M4_s4)
% set(gca, 'YScale', 'log')
% %ylim([0 2]);
% yline(1E-06,'-','Threshold');
% title("RI Material M4 - sensitivity 4 approach");
% xlabel("Chemicals");
% ylabel("Carcinogenic Risk");
% xticks([1 2 3 4 5 6 7]);
% xticklabels(["Beryllium","Chromium","Cobalt","Lead","Nickel","Strontium","Furfuryl Alchol"]);
% xlim([0 8]);


boxplot(CR_M4_s4_tot)
set(gca, 'YScale', 'log')
%ylim([0 2]);
yline(1E-06,'-','Threshold');
title("Carcinogenic Risk Material 4 - sensitivity s4 approach");
xlabel("Materia 4");
ylabel("Carcinogenic Risk");
xticks(1);
xticklabels("Material 4");