# MATLAB code from master thesis

_Frequency stability of graphene nonlinear resonators_
See http://resolver.tudelft.nl/uuid:96b47031-ff15-4057-ab33-1ac4863119be

## Introduction

These files contain code on three topics:
  1. Calculate the Allan Deviation with more control about the number of points calculated.
  1. Parse stream files from the Zurich Instruments UHF into `.mat` files, one per signal.
  1. Model and configuration files for the simulations.

## Allan Deviation
The file is located in the root of this structure and called `allandev.m`. The comments contain the information required to run it.

## UHFLIStreamParser
This directory contains a set of files to parse stream files into `.mat` files per signal. 
Main file is `UHFLIStreamParser.m`. The other files are helpers for this function or wrappers to select a batch of stream files to parse.

## Simulation
The simulation directory contains the Simulink model used in the master thesis: `PLL_duffing_with_thermal_noise_nonlinear_damping.slx`.
To run this, one needs to load parameters for the system. A start can be found in `graphene_drum_parameters.m`. 
A phase sweep can be executed by running `run_nonlinear_damping_experiments_in_simulations.m`. 
The other files in this directory are helper functions.

---
Author: Ties Verschuren (c) 2020 - MIT licence.