function parseMatchedDirectories(basedir, regex, varargin)
% basedir1, regex1, basedir2, regex2, ...
% Calls UHFLIStreamParser on all the directories that match the regex.
%
% Author: Ties Verschuren (c) 2020
    if mod(nargin, 2) ~= 0
        error('parseMatchedDirectories: expect an even number of input arguments, got %d', nargin);
    end
    
    for i = 1:(nargin/2)
        if i == 1
            dirs = matchDirs(basedir, regex);
        else
            dirs = matchDirs(varargin{2*(i-1) - 1}, varargin{2*(i-1)});
        end
        for j = 1:numel(dirs)
            UHFLIStreamParser(dirs{j});
        end
    end
end