function parseDirectory(sourceDir)
% Calls UHFLIStreamParser on all the files in the directory.
%
% Author: Ties Verschuren (c) 2020
    if  ~exist(sourceDir, 'dir')
        error('parseDirectory: directory "%s" does not exist.', sourceDir);
    end
    
    dirContents = dir(sourceDir);
    dirContents(ismember( {dirContents.name}, {'.', '..'})) = [];  %remove . and ..
    streams = dirContents([dirContents.isdir]);
    clear dirContents;
    fprintf('Found %d folders to parse...\n', numel(streams));
    
    for i = 1:numel(streams)
        streamPath = fullfile(sourceDir, streams(i).name);
        UHFLIStreamParser(streamPath, [streamPath '_parsed']);
    end
    fprintf('Done parsing streams\n');
end