function matchedDirPaths = matchDirs(baseDir, regex)

allContents = dir(baseDir);
allContents(ismember( {allContents.name}, {'.', '..'})) = [];  %remove . and ..
allDirs = allContents([allContents.isdir]);
clear dirContents;

matchList = regexp({allDirs.name}, regex, 'match');
% matchedIdx = find(~cellfun(@isempty, matchList));

matchedDirs = allDirs(~cellfun(@isempty, matchList));
clear allDirs matchList;% matchedIdx;

matchedDirPaths = cell(1, numel(matchedDirs));
for i = 1:numel(matchedDirs)
    matchedDirPaths{i} = fullfile(baseDir, matchedDirs(i).name);
end
