% Tests for getDataByPath
% Author: Ties Verschuren (c) 2020

% initilalize test data
clear s d;
s = struct('some', struct('path', struct('with', 'depth')), ...
    'indexed', [struct('path', 'index1'), struct('path', 'index2')]);

%% Test 1: requires enough arguments
try
    d = getDataByPath(s);
catch Err
    assert(strcmp(Err.identifier, 'UHFLIStreamParser:getDataByPath:invalidArgumentNumber'));
end
assert(~exist('d', 'var'));

%% Test 2: works for string paths
d = getDataByPath(s, 'some', 'path', 'with');
assert(strcmp(d, 'depth'));

%% Test 3: works for indexed paths
d = getDataByPath(s, 'indexed', '2', 'path');
assert(strcmp(d, 'index2'));

%% Test 4: throws error on non-existent path
clear d;
try
    d = getDataByPath(s, 'some', 'path', 'that', 'does', 'not', 'exists');
catch Err
    assert(strcmp(Err.identifier, 'UHFLIStreamParser:getDataByPath:pathDoesNotExist'));
end
assert(~exist('d', 'var'));