function data = getDataByPath(structVar, varargin)
% getDataByPath     Returns the data in structVar at the given path
%
%   INPUT
%       structVar   Struct from which the data will be read
%       varargin    The path. Supports structs and indexed structs
%
%   RETURNS         structVar.path if exists.
%
%   Example:
%       d = getDataByPath(obj, 'some', 'path'); 
%       Now d contains the value of obj.some.path
%
%   Author: Ties Verschuren (c) 2020

if nargin < 2
    error('UHFLIStreamParser:getDataByPath:invalidArgumentNumber', ...
        'Expect at least 2 arguments, 1 given.');
end

pathDepth = numel(varargin);
pathStr = 'structVar';

%% Build struct string: i.e. structVar.some.path or structVar.some(4).indexed.path

for i = 1:pathDepth
    [n, isNum] = str2num(varargin{i});
    if isNum && isreal(n) && n > 0 % numeric number, add between brackets.
    	pathStr = [pathStr '(' varargin{i} ')'];
    else
    	pathStr = [pathStr '.' varargin{i}];
    end
end

%% Fetch data at path

try 
    data = squeeze(eval(pathStr));
catch ME
%     disp(ME);
    error('UHFLIStreamParser:getDataByPath:pathDoesNotExist', ...
        'The given path %s does not exist on the argument passed as structVar', pathStr);
end
% done
end