function plotFreqPhaseGraph(freq, phase, labels, linespec)
%PLOTAMPFREQGRAPH Plots amplitude frequency figure
%   Author: Ties Verschuren (c) 2019

if (nargin < 4)
    linespec = cellfun(@(c) {'DisplayName', c}, labels, 'UniformOutput', false);
else
    for i = 1:numel(labels)
        linespec{i, :} = [linespec{i, :} {'DisplayName', labels{i}}];
    end
end

figure
hold on;
for i = 1:numel(labels)
    args = linespec{i};
    plot(freq(i,:), phase(i, :), args{:});
end
ylabel('phase (rad)');
xlabel('frequency (rad/s)');
legend('Location', 'northwest');
end

