function plotAmpPhaseGraph(amp, phase, labels, linespec)
%PLOTAMPFREQGRAPH Plots amplitude phase figure
%   Author: Ties Verschuren (c) 2019

if (nargin < 4)
    % Only labels is set
    linespec = cellfun(@(c) {'DisplayName', c}, labels, 'UniformOutput', false);
else
    for i = 1:numel(labels)
        linespec{i, :} = [linespec{i, :} {'DisplayName', labels{i}}];
    end
end

figure
hold on;
for i = 1:numel(labels)
    args = linespec{i};
    plot(phase(i, :), amp(i,:), args{:});
end

xlabel('phase (rad)')
ylabel('amplitude');
legend('Location', 'northwest');
end

