function plotAmpFreqGraph(amp, freq, labels, linespec)
%PLOTAMPFREQGRAPH Plots amplitude frequency figure
%   Author: Ties Verschuren (c) 2020

if (nargin < 4)
    linespec = cellfun(@(c) {'DisplayName', c}, labels, 'UniformOutput', false);
else
    for i = 1:numel(labels)
        linespec{i, :} = [linespec{i, :} {'DisplayName', labels{i}}];
    end
end

figure
hold on;
for i = 1:numel(labels)
    args = linespec{i};
    plot(freq(i, :), amp(i,:), args{:});
end
% if exist('backboneFreq', 'var') == 1 && exist('backboneAmp', 'var') == 1
%     plot(backboneFreq, backboneAmp, 'DisplayName', 'Backbone curve');
% end
xlabel('frequency (rad/s)');
ylabel('amplitude');
legend('Location', 'northwest');
end

