% Parameters for graphene nonlinear resonators
% For a Duffing resonator model with nonlinear damping xd*x^2
% Author: Ties Verschuren (c) 2020

% Paramters from linear part
Q = 175;
% set resonance frequency
omega_0 = 1;%2*pi*1;

fs = 100 * omega_0 / (2*pi);

% normalized values (suffix b from bar)
etab = 980;
cb = 1/Q;
kb = 1;
gammab = 9100;
Fb = 6e-5;


% omega_0 dependent variables
c = cb / omega_0;
eta = etab / omega_0;
k = kb / omega_0^2;
gamma = gammab / omega_0^2;
F = Fb / omega_0^2;
% eta = etab / omega_0;
% zeta = omega_0 * ldb;
% Gamma = gammab * omega_0^2;
% F = Fb * omega_0^2;

% initial values
omega_init = 0.99*omega_0; % rad/s
y0 = 0;


% controller values
K_p = omega_0 / 100;
K_i = K_p * omega_0 / (2*Q);
f_sa = 100e3; % Sampling rate of the demodulator (Hz)
% Decimation factor of extracted simulation data
DecN = ceil(9e6 / f_sa);

% Thermal and amplitude noise
Temp=300;
kb=1.38064852e-23;
wn = 9e6;
thermalNoise = 4*kb*Temp*k/wn/Q;
% emperical found value
amplitudeNoise = 1e-7;

