###################
# LISA numbers Chapter 2
##########################

rm(list=ls())
library(tidyverse)

# load private company microdat (not included in repository)
lisa2017 <- read_csv("datavisualization/data/proprietary/LISA2017.csv") 
buildings <- read_csv("datavisualization/data/proprietary/buildings2021NL.csv") |>
  mutate(Size_cat = fct_relevel(Size_cat,"S","M","L","XL","XXL"))

# define logistics sector SBI sector codes
logistics <- c("45111" , "45191" , "45311" , "45312" , "45401" , "46211" , "46212" , "46213" , "46214" ,
               "46215" , "46216" , "46217" , "46218" , "46219" , "4622" , "46231" , "46232" , "46241" , 
               "46242" , "46311" , "46312" , "4632" , "46331" , "46332" , "4634" , "4635" , "4636" , 
               "4637" , "46381" , "46382" , "46383" , "46384" ,  "46389" , "4639" , "46411" , "46412" , 
               "46421" , "46422" , "46423" , "46424" , "46425" , "46429" , "46431" , "46432" , "46433" ,
               "46434" , "46435" , "46436" , "46441" , "46442" , "4645" , "46461" , "46462" , "46471" ,
               "46472" , "46473" , "4648" , "46491" , "46492" , "46493" , "46494" , "46495" , "46496" ,
               "46497" , "46498" , "46499" , "4651" , "4652" , "4661" , "4662" , "4663" , "4664" , 
               "4665" , "4666" , "46681" , "46682" , "46691" , "46692" , "46693" , "46694" , "46695" , 
               "46696" , "46697" , "46699" , "46711" , "46712" , "46713" , "46721" , "46722" , "46723" ,
               "46731" , "46732" , "46733" , "46734" , "46735" , "46736" , "46737", "46738" , "46739" , 
               "46741" , "46742" , "46751" , "46752" , "46761" , "46762" , "46769" , "46771" , "46772" ,
               "46779" , "46901", "46902","47911","47912","47913", "47914","47915","47916","47918",
               "47919", "4920" , "4941",  "50201",  "50202", "50401" , "50402" , "50403" , "5121" , 
               "52101" , "52102" , "52109" , "5221" ,"5222" , "5223" , "52241" , "52242" , "52291" , 
               "52292", "5310", "53201","53202")

# Numbers LISA stated in Chapter 2
tot_jobs <- sum(lisa2017$BANEN) #8462563
logi_jobs <- sum(lisa2017$BANEN[lisa2017$SBI08 %in% logistics]) # 896912 logistics jobs
print(logi_jobs/tot_jobs) # 11% of jobs
DC_jobs <- sum(buildings$Jobs_logis[buildings$Constr_yea<2018])
print(DC_jobs/logi_jobs) #70% in logistics building on business terrain

jobs_split <- lisa2017 |> filter(SBI08 %in% logistics) |>
  summarise(man = sum(MANNEN), vrouw = sum(VROUWEN), manP = sum(MANP), vrouwP = sum(VROUWP)) |>
  mutate(manPERC = man/(man+vrouw), manP_PERC = manP/man, vrouwP_PERC = vrouwP/vrouw) 
# 73% man, parttime (>12h/wk) man 8%, women 18%
