# Author: Arsen Ekinci
# Adapted by Nadyne Aretz

import csv
import numpy as np
from numpy import genfromtxt, transpose, loadtxt
from sklearn.metrics import cohen_kappa_score


if __name__ == '__main__':

    # Opens the first csv file.
    file = open('first.csv', encoding="utf8")
    my_data = genfromtxt(file, delimiter=',')
    my_data_trimmed = []

    # Trims away text codes, only leaving hot-one encodings.
    # Every row is a response.
    for response in my_data[1:]:
        my_data_trimmed.append(response[10:])
    my_data_trimmed = transpose(my_data_trimmed)
    
    # Opens the second csv file.
    file = open('second.csv', encoding="utf8")
    double_data = genfromtxt(file, delimiter=',')
    text = loadtxt(file, delimiter=',')
    double_data_trimmed = []

    # Trims away text codes, only leaving hot-one encodings.
    # Every row is a response.
    for response in double_data[1:]:
        double_data_trimmed.append(response[7:])
    double_data_trimmed = transpose(double_data_trimmed)

    # Cohen's kappa scores for every individual code are added to the result array.
    results = []
    for i in range(len(double_data_trimmed)):
        results.append(round(cohen_kappa_score(my_data_trimmed[i], double_data_trimmed[i]), 2))

    # Prints name of codes with the corresponding Cohen's kappa value.
    csv2 = []
    with open('doublecoder.csv', 'r') as file2:
        reader = csv.reader(file2)
        for row in reader:
            csv2.append(row)
    for i in range(len(results)):
        print(str(csv2[0][7+i]) + ": " + str(results[i]))

    # Prints the average cohen's kappa score over all the codes.
    print("Average Cohen's Kappa: " + str(round(np.average(results), 2)))



