## heatmap plot
read.csv("influence_anonymized.csv") -> influence
library(ggplot2)
level_order <- c("EU","National gov.","Regional gov.","Local gov.","Semi-government",
                 "Developer","Investor","Logistic co.","Planner/Architect","Citizen")
plot.new()
ggplot(data = influence, aes(x = factor(name, level = level_order), y = reorder(stake, case))) +
      geom_tile(aes(fill = influence))+ theme_bw(base_size = 20) +
      scale_fill_gradient(
            low = "white",
            high = "black",
            space = "Lab",
            na.value = "red",
            guide = "colourbar",
            aesthetics = "fill",
            breaks=c(1,5),
            labels=c("none","dominant")
      )+
      labs(x= "type of actor", y="")
dev.copy(png,file="influence_heatmap.png",width=1500,height=600)
dev.off()