"""
Auction Framework

created: 02-03-2020
Sanne van Alebeek
"""

import numpy as np
import os
import openpyxl
import pandas as pd
import time
import operator
from copy import deepcopy
import random
import matplotlib.pyplot as plt
from collections import OrderedDict
import itertools
import scipy.cluster.hierarchy as sch
from scipy.spatial.distance import pdist, squareform

import alns_functions as alsn
import auction_functions as af
import alns_auction as aa


plt.close('all')
begin_auction = time.time()

random.seed(101)

T_timespan               = 480 # 8 hours

instance_name = '3_2_27.xlsx'


def intersection(lst1, lst2): 
    lst3 = [value for value in lst1 if value in lst2] 
    return lst3


############################################
### Read in the data from the excel file ###
############################################
node_idx,node_pd,node_FF,node_GH,node_type,node_weight,node_width,node_proc_time,node_et,node_lt,\
node_rev,sigma,Nf,Ng,pickup_nodes_info,delivery_nodes_info,pickup_nodes,delivery_nodes,requestGH,requestGH1,requestFF,shipment_FF_GH,\
distanceMatrix,timeMatrix,processing_time,elBounds,late_time_windows,L_trailer,cap_trailer,Nt,\
truck_OD_Time,Q_truck,q_nodes,lat_occupancy_shipments,idxFF,idxGH,idx_pickup_nodes,idx_delivery_nodes,nDocks,\
Nodes,Nodes1 = af.read_data(instance_name,T_timespan)


#########################
### Input values ALNS ###
#########################
# max ride time
maxRideTimeTruck    = 480
maxRideTimeShipment = 480

maxRideTime = []
maxRideTime.append(maxRideTimeTruck)
for i in range(0,sigma):
    maxRideTime.append(maxRideTimeShipment)
for i in range(0,sigma):
    maxRideTime.append(maxRideTimeShipment)
maxRideTime.append(maxRideTimeTruck)   

shipmentsToBePickedUp   = np.arange(1,sigma+1)
unDeliverableShipments  = []

alpha              = 100
cost_distance      = 1.69/1.60934*0.9 # [Euro/km]
cost_time          = 66.65/60*0.92        # [Euro/min] 
#cost_time          = 100
beta               = 0 #dist
gamma              = 1 #time
multiplier         = 10
w_TW               = 100
w_DC               = 100

##################################
### Phase 1: Request selection ###
##################################
begin_p1=time.time()

#% FF wants to keep at least
keepPercentage = [1/2,1/2,1/2,1/2,1/2]
#keepPercentage = [0,0,0,0,0]
#keepPercentage = [1,1/2,1/2,1/2,1/2]

min_overlap = 60
overlapMatrices, overlap, overlapNodes = af.overlap1(Nf,Ng,delivery_nodes,elBounds)

#Selection method 1: 
keepNodes,keepNodes1,poolNodes,poolNodes1,keepNodesFF,keepNodesFF1,poolPerGH,\
           poolPerGH1,summation,poolPerGHPerFF,poolPerFF = af.request_selection1(Nf,Ng,delivery_nodes,requestFF,keepPercentage,min_overlap,Nodes,Nodes1,elBounds,sigma,requestGH,requestGH1)

time_p1 = time.time() - begin_p1


#################################
### Phase 2: Request bundling ###
#################################
begin_p2=time.time()
#print('poolPerGHPerFF',poolPerGHPerFF)

bundles,bundles1,b_matrices = af.request_bundling1(poolPerGH,elBounds,sigma,poolPerGHPerFF,Nf,poolPerFF)

#plt.figure(figsize=(5, 3))
#plt.title("Dendrogram")
#dendrogram = sch.dendrogram(sch.linkage(squareform(b_matrices[1]), method  = "complete"))
print('bundles',bundles)
print('bundles1',bundles1)
#plt.show()

#Add these by hand to fix the ksi (gamma in Ganst).
##bundles.append([8])
##bundles.append([15])
##bundles.append([9, 10])
##bundles.append([16])
#bundles.remove([5,6,7,12,13,14,18,19,20])
time_p2 = time.time() - begin_p2



########################
### Phase 3: Bidding ###
########################

start_bidding = time.time()
#shipments  = list(np.arange(1,sigma+1))

# Set ALNS
# Number of shipments to be removed at every iteration
# q_min = np.min([int(np.round(sigma/2)),6])
q_min = 4
# Initial temperature
T = 120
cooling_coeff = 0.999
# Number of iterations
#n_iter = 1

routes_without = [0 for x in range(Nf)]
profit_without = [0 for x in range(Nf)]
rev_without = [0 for x in range(Nf)]
cost_without = [0 for x in range(Nf)]
timestamps_without = [0 for x in range(Nf)]
FF_without = [0 for x in range(Nf)]
GH_without = [0 for x in range(Nf)]

routes_with = [[0 for x in range(Nf)] for x in range(len(bundles))]
profit_with = [[0 for x in range(Nf)] for x in range(len(bundles))]
rev_with = [0 for x in range(len(bundles))]
cost_with = [[0 for x in range(Nf)] for x in range(len(bundles))]
timestamps_with = [[0 for x in range(Nf)] for x in range(len(bundles))]
FF_with = [[0 for x in range(Nf)] for x in range(len(bundles))]
GH_with = [[0 for x in range(Nf)] for x in range(len(bundles))]

# ind duurt in totaal: allowed time + beetje*Nf
# coop duurt in totaal: allowed time + beetje
# full duurt in totaal allowed time/Nf
# totaal wachten: allowed time * 2 + allowed time/Nf

#ART = allowed/Nf
# allowed = 3600 * Nf voor een uur ART ~
# allowed = 600 * Nf voor 10 min ART ~
allowed_time = 10 # total allowed run time in seconds for each A I F.
aantal_iter = len(bundles) * Nf + Nf
n_time = allowed_time/aantal_iter

shipment_list = []
T = 100
cooling_coeff = 0.00000001
n_iter = 200000
#n_time = 5 #seconds
n_time_keep = n_time
time_without = [0 for x in range(Nf)]


for i in range(Nf):
    begin_without = time.time()
    shipments = keepNodesFF[i]
    #print('shipments',shipments)
    if len(keepNodesFF[i]) == 0: # Has not happened yet.
        bla = 1
        print('bla',bla)
        routes_without[i], cost_without[i], timestamps_without[i],FF_without[i], GH_without[i] = [ [[]] , 0 , [[]] , [[]] , [[]] ] # These are not correct size or form.
    else:
        routes_without[i], cost_without[i], timestamps_without[i], FF_without[i], GH_without[i] = aa.alns_over(shipments,
            timeMatrix,elBounds,processing_time,maxRideTime,Nf,Ng,Nt,sigma,q_nodes,
            cap_trailer,pickup_nodes,distanceMatrix, maxRideTimeTruck,w_TW,w_DC,lat_occupancy_shipments,
            L_trailer,nDocks,alpha,beta,gamma,cost_distance,cost_time,node_rev,multiplier,shipment_FF_GH,Q_truck,
            q_min,T,cooling_coeff,n_iter,n_time)
        time_without[i] = time.time() - begin_without

total_time_without = sum(time_without)


T = 100
cooling_coeff = 0.000000001
n_iter = 1000000
#n_time = 5 #seconds
n_time_bundles = n_time
time_with = [[0 for x in range(Nf)] for x in range(len(bundles))]
for i in range(len(bundles)):
    for j in range(Nf):
        shipments = keepNodesFF[j] + bundles[i]
        shipment_list.append(bundles[i])
        print('shipments',shipments)
        print('i,j',i,j)
        print('len(bundles)',len(bundles))
        begin_with = time.time()
        routes_with[i][j], cost_with[i][j], timestamps_with[i][j], FF_with[i][j], GH_with[i][j] = aa.alns_over(shipments,timeMatrix,elBounds,processing_time,maxRideTime,Nf,Ng,Nt,sigma,q_nodes,
            cap_trailer,pickup_nodes,distanceMatrix, maxRideTimeTruck,w_TW,w_DC,lat_occupancy_shipments,
            L_trailer,nDocks,alpha,beta,gamma,cost_distance,cost_time,node_rev,multiplier,shipment_FF_GH,Q_truck,
            q_min,T,cooling_coeff,n_iter,n_time)
        #print('profit_with',profit_with)
        time_with[i][j] = time.time() - begin_with

total_time_with = 0
for i in range(len(time_with)):
    total_time_with += sum(time_with[i])


#for j in range(Nf):
#    for k in range(len(keepNodesFF[j])):
#        rev_without[j] += node_rev[keepNodesFF[j][k]-1][0]


#for i in range(len(bundles)):
#    for k in range(len(bundles[i])):
#        rev_with[i] += node_rev[bundles[i][k]-1][0]

rev_ff = [0 for x in range(Nf)]
for j in range(Nf):
    for k in range(len(requestFF[j])):
        rev_ff[j] += node_rev[requestFF[j][k]-1][0]

for j in range(Nf):
    profit_without[j] = rev_ff[j] - cost_without[j]
    for i in range(len(bundles)):
        profit_with[i][j] = rev_ff[j] - cost_with[i][j]

marginal_profit = [[0 for x in range(Nf)] for x in range(len(bundles))]

for i in range(len(bundles)):
    for j in range(Nf):
        marginal_profit[i][j] = cost_without[j] - cost_with[i][j]

print('marg31',marginal_profit[3][1])
end_bidding = time.time()
total_time_bidding = end_bidding-start_bidding
print('total_time_bidding',total_time_bidding)

####################
### Phase 4: WDP ###
####################
begin_p4=time.time()
constraints = []
#Determine which bundle goes to which GH
#WDP, overlaps = af.WDP_hard(Nf,bundles,marginal_profit,poolNodes,timestamps_with,routes_with,node_GH,Ng,sigma,keepNodesFF,nDocks,FF_with,GH_with,routes_without,timestamps_without,FF_without,GH_without)
WDP, overlaps, sol_k = af.WDP_soft(Nf,bundles,marginal_profit,poolNodes,timestamps_with,routes_with,node_GH,Ng,sigma,keepNodesFF,nDocks,FF_with,GH_with,routes_without,timestamps_without,FF_without,GH_without,constraints)
#WDP = af.WDP_no_cap(Nf,bundles,marginal_profit,poolNodes,timestamps_with,routes_with,node_GH,Ng,sigma,keepNodesFF)


nodes_final = [[] for x in range(Nf)]
routes_final = [[] for x in range(Nf)]
profit_final = [0 for x in range(Nf)]
timestamps_final = [0 for x in range(Nf)]
FF_final = [0 for x in range(Nf)]
GH_final = [0 for x in range(Nf)]
routes_check1 = []
timestamps_check1 = []
FF_check1 = []
GH_check1 = []
for i in range(Nf):
    for j in range(len(WDP)):
        if WDP[j][1] == i:
            win_bundle = WDP[j][0]
            if win_bundle < len(bundles):
                win_requests = bundles[win_bundle]
                nodes_final[i] = keepNodesFF[i] + win_requests
                routes_final[i] = routes_with[win_bundle][i]
                profit_final[i] = profit_with[win_bundle][i]
                timestamps_final[i] = timestamps_with[win_bundle][i]
                FF_final[i] = FF_with[win_bundle][i]
                GH_final[i] = GH_with[win_bundle][i]
            else:
                nodes_final[i] = keepNodesFF[i]
                routes_final[i] = routes_without[i]
                profit_final[i] = profit_without[i]
                timestamps_final[i] = timestamps_without[i]
                FF_final[i] = FF_without[i]
                GH_final[i] = GH_without[i]
            

for i in range(Nf):
    for j in range(len(routes_final[i])):
        routes_check1.append(routes_final[i][j])
        timestamps_check1.append(timestamps_final[i][j])
        FF_check1.append(FF_final[i][j])
        GH_check1.append(GH_final[i][j])

routes_check = deepcopy(routes_check1)
timestamps_check = deepcopy(timestamps_check1)
FF_check = deepcopy(FF_check1)
GH_check = deepcopy(GH_check1)


dockCapacityViolation, arrDepGH, numberOfTrucksPerGH = alsn.dock_capacity_violation(routes_check,timestamps_check,
                                                                                    FF_check,GH_check,Nf,Ng,nDocks)
# Enige wat we hieruit nodig hebben is de totale travel times.
#Die gerbuiken we om achteraf te berekenen hoeveel travel time
#erbij is gekomen door het shiften van de timestamps om DC te resolven
cost_initial = [0 for x in range(Nf)]
allDistances_initial = [0 for x in range(Nf)]
allTravelTimes_initial = [0 for x in range(Nf)]
offLoadedShipments_initial = [0 for x in range(Nf)]
TW_violation = 0
DC_violation = 0
for i in range(Nf):
    sigmaS = len(nodes_final[i])
    cost_initial[i], allDistances_initial[i], allTravelTimes_initial[i], offLoadedShipments_initial[i] = alsn.cost_weakly_infeasible_solution(alpha,beta,gamma,cost_distance,cost_time,
                        routes_final[i],timestamps_final[i],distanceMatrix,sigma,TW_violation,DC_violation,w_TW,w_DC,node_rev,sigmaS)

if len(dockCapacityViolation) == 0:
    print('Dock capacity violation: NO', len(dockCapacityViolation))
    print('Continue to calculation of J, phi and ksi')

    
else:
    print('Dock capacity violation: YES', len(dockCapacityViolation))
    print('Start solving dock capacity violation')
    t=0
    new_dockCapacityViolation = deepcopy(dockCapacityViolation)
    constraints = sol_k
    while len(new_dockCapacityViolation) > 0 and t < 15:
#distace berekenen van routes en timestamps check?
        cost_initial = [0 for x in range(Nf)]
        allDistances_initial = [0 for x in range(Nf)]
        allTravelTimes_initial = [0 for x in range(Nf)]
        offLoadedShipments_initial = [0 for x in range(Nf)]
        TW_violation = 0
        DC_violation = 0
        for i in range(Nf):
            sigmaS = len(nodes_final[i])
            cost_initial[i], allDistances_initial[i], allTravelTimes_initial[i], offLoadedShipments_initial[i] = alsn.cost_weakly_infeasible_solution(alpha,beta,gamma,cost_distance,cost_time,
                                routes_final[i],timestamps_final[i],distanceMatrix,sigma,TW_violation,DC_violation,w_TW,w_DC,node_rev,sigmaS)    
        print('t',t)
        print('new_dockCapacityViolation',new_dockCapacityViolation)
        t += 1
        new_routes,new_routes_timestamps,new_dockCapacityViolation,arrDepGH,new_numberOfTrucksPerGH = alsn.dock_capacity_violation_resolver(routes_check,
                                        timestamps_check,timeMatrix,elBounds,processing_time,maxRideTime,
                                         new_dockCapacityViolation,arrDepGH,FF_check,GH_check,Nf,Ng,nDocks)

        #new_dockCapacityViolation, arrDepGH, numberOfTrucksPerGH = alsn.dock_capacity_violation(new_routes,new_routes_timestamps,
        #                                                                                    FF_check,GH_check,Nf,Ng,nDocks)
        #print('1',new_routes)
        #new_routes_timestamps
        #print('new_dockCapacityViolation',new_dockCapacityViolation)

        if len(new_dockCapacityViolation) > 0:
            print('====================')
            print('Not possible to solve dock capacity with shifting timestamps')
            print('So no feasible dock allocation with this bundle to carrier assignment')
            print('Add this b to c as constraint to WDP')
            print('====================')
            
            WDP, overlaps, sol_k = af.WDP_soft(Nf,bundles,marginal_profit,poolNodes,timestamps_with,routes_with,node_GH,Ng,sigma,keepNodesFF,nDocks,FF_with,GH_with,routes_without,timestamps_without,FF_without,GH_without,constraints)
            for i in range(len(sol_k)):
                constraints.append(sol_k[i])

            nodes_final = [keepNodesFF[x] for x in range(Nf)]
            routes_final = [routes_without[x] for x in range(Nf)]
            profit_final = [0 for x in range(Nf)]
            timestamps_final = [0 for x in range(Nf)]
            FF_final = [0 for x in range(Nf)]
            GH_final = [0 for x in range(Nf)]
            routes_check1 = []
            timestamps_check1 = []
            FF_check1 = []
            GH_check1 = []

            # You should change the routes and TS to new routes and timestamps??????
            
            for i in range(Nf):
                for j in range(len(WDP)):
                    if WDP[j][1] == i:
                        win_bundle = WDP[j][0]
                        if win_bundle < len(bundles):
                            win_requests = bundles[win_bundle]
                            nodes_final[i] = keepNodesFF[i] + win_requests
                            routes_final[i] = routes_with[win_bundle][i]
                            profit_final[i] = profit_with[win_bundle][i]
                            timestamps_final[i] = timestamps_with[win_bundle][i]
                            FF_final[i] = FF_with[win_bundle][i]
                            GH_final[i] = GH_with[win_bundle][i]
                        else:
                            nodes_final[i] = keepNodesFF[i]
                            routes_final[i] = routes_without[i]
                            profit_final[i] = profit_without[i]
                            timestamps_final[i] = timestamps_without[i]
                            FF_final[i] = FF_without[i]
                            GH_final[i] = GH_without[i]
                

            for i in range(Nf):
                for j in range(len(routes_final[i])):
                    routes_check1.append(routes_final[i][j])
                    timestamps_check1.append(timestamps_final[i][j])
                    FF_check1.append(FF_final[i][j])
                    GH_check1.append(GH_final[i][j])

            routes_check = deepcopy(routes_check1)
            timestamps_check = deepcopy(timestamps_check1)
            FF_check = deepcopy(FF_check1)
            GH_check = deepcopy(GH_check1)

            new_dockCapacityViolation, arrDepGH, numberOfTrucksPerGH = alsn.dock_capacity_violation(routes_check,timestamps_check,
                                                                                            FF_check,GH_check,Nf,Ng,nDocks)
            print('Hier ook maar kijken naar de dock cap viol:',new_dockCapacityViolation)
            print('is die hier ooit 0? Dan moeten we hieronder ook de phi en ksi uitrekenen')
            print('als DC hier 0 is dan continue to calc of J phi and ksi')
            
        else:
            print('====================')
            print('Feasible dock allocation found')
            print('YAY')
            print('====================')
            #print('2',new_routes)

            routes_final
            #print('routes_final',routes_final)
            nodes_final
            FF_final
            GH_final
            temp_timestamps_final = [[] for x in range(Nf)]
            #print('new_routes_timestamps',new_routes_timestamps)
            #new_timestamps = [ [] for x in range(Nf)]

            for i in range(Nf):
                for j in range(len(timestamps_final[i])):
                    #print('new_routes_timestamps[0]',new_routes_timestamps[0])
                    temp_timestamps_final[i].append(new_routes_timestamps[0])
                    new_routes_timestamps.pop(0)
            
            timestamps_final = deepcopy(temp_timestamps_final)
            #print('3',new_routes)
            #print('4',routes_final)

time_p4 = time.time() - begin_p4
###################################
### Phase 5: Revenue allocation ###
###################################
begin_p5=time.time()
rev_final = [0 for x in range(Nf)]
for i in range(Nf):
    for j in range(len(nodes_final[i])):
        rev_final[i] += node_rev[nodes_final[i][j]-1][0]

cost_final = [0 for x in range(Nf)]
J = [0 for x in range(Nf)]
allDistances_final = [0 for x in range(Nf)]
allTravelTimes_final = [0 for x in range(Nf)]
offLoadedShipments_final = [0 for x in range(Nf)]
TW_violation = 0
DC_violation = 0
for i in range(Nf):
    sigmaS = len(nodes_final[i])
    cost_final[i], allDistances_final[i], allTravelTimes_final[i], offLoadedShipments_final[i] = alsn.cost_weakly_infeasible_solution(alpha,beta,gamma,cost_distance,cost_time,
                            routes_final[i],timestamps_final[i],distanceMatrix,sigma,TW_violation,DC_violation,w_TW,w_DC,node_rev,sigmaS)
    J[i] = rev_ff[i] - cost_final[i]

cost_by_shift = [0 for x in range(Nf)]
for i in range(Nf):
    cost_by_shift[i] = cost_time*(sum(allTravelTimes_final[i]) - sum(allTravelTimes_initial[i]))

phi_abs = [0 for x in range(Nf)]
phi = [0 for x in range(Nf)]
for i in range(Nf):
    for j in range(len(WDP)):
        if WDP[j][1] == i:
            win_bundle = WDP[j][0]
            phi_abs[i] = abs(marginal_profit[win_bundle][i] - cost_by_shift[i])
            phi[i] = marginal_profit[win_bundle][i] - cost_by_shift[i]

#phi = [0 for x in range(Nf)]
#for i in range(Nf):
#    phi[i] = J[i] - profit_without[i]
#    #phi_abs[i] = abs(J[i] - profit_without[i])

empty_bundles = [[] for x in range(Nf)]
set_of_bundles = bundles + empty_bundles
    
ksi = [0 for x in range(Nf)]
ksi_abs = [0 for x in range(Nf)]
for i in range(Nf):
    #for j in range(len(WDP)):
        #print('i,j',i,j)
        #intersection van de bundle en requestFF. dat is een bundle. de marg profit van die bundle is je gamma i
    #ksi_bundle = [value for value in requestFF[i] if value not in nodes_final[i]]
    ksi_bundle = poolPerFF[i]
        #intersection(set_of_bundles[WDP[j][0]],requestFF[i])
    #print('ksi_bundle',ksi_bundle)
    if len(ksi_bundle) != 0:
        if ksi_bundle in bundles:
            index = bundles.index(ksi_bundle)
            ksi[i] = marginal_profit[index][i]
            ksi_abs[i] = abs(marginal_profit[index][i])
            #[24.677062900534047, 36.37022133316974, 15.122503803306245]
        else:
            print('Help, we did not have the right bundles and now this bundle does not have a ksi value!!!')
            #Bereken marginal profit voor ksi_bundle voor FF i
            #shipments = keepNodesFF[i] + ksi_bundle
            #print('shipments',shipments)
            #bla1, profit_with3 ,bla2, bla3, bla4 = aa.alns_over(shipments,timeMatrix,elBounds,processing_time,maxRideTime,Nf,Ng,Nt,sigma,q_nodes,
            #cap_trailer,pickup_nodes,distanceMatrix, maxRideTimeTruck,w_TW,w_DC,lat_occupancy_shipments,
            #L_trailer,nDocks,alpha,beta,gamma,cost_distance,cost_time,node_rev,multiplier,shipment_FF_GH,Q_truck,
            #q_min,T,cooling_coeff,n_iter)
            #ksi[i] = profit_with3 - profit_without[i]


#phi_sum = sum(phi)
#ksi_sum = sum(ksi)
#extra_profit = phi_sum - ksi_sum
#compensation_ff = ksi

#extra_profit_ff = [0 for x in range(Nf)]
#total_share_ff = [0 for x in range(Nf)]
#for i in range(Nf):
#    extra_profit_ff[i] = (extra_profit/2)*((phi[i]/phi_sum)+(ksi[i]/ksi_sum))
#    total_share_ff[i] = extra_profit_ff[i]+compensation_ff[i]

#print('phi2',phi)
#print('ksi2',ksi)
#print('routes_final2',routes_final)

#J_after = [0 for x in range(Nf)]
#for i in range(Nf):
#    J_after[i] = J[i] - phi[i] +total_share_ff[i]

end_auction = time.time()
duration_auction = end_auction - begin_auction
print('duration_auction',duration_auction)

phi_sum_abs = max(sum(phi_abs),0.001)
ksi_sum_abs = max(sum(ksi_abs),0.001)
extra_profit_abs = ksi_sum_abs - phi_sum_abs
#compensation_ff_abs = ksi_abs

#extra_profit_ff_abs = [0 for x in range(Nf)]
#total_share_ff_abs = [0 for x in range(Nf)]
#for i in range(Nf):
#    extra_profit_ff_abs[i] = (extra_profit_abs/2)*((phi_abs[i]/phi_sum_abs)+(ksi_abs[i]/ksi_sum_abs))
#    total_share_ff_abs[i] = extra_profit_ff_abs[i]+compensation_ff_abs[i]

#J_after_abs = [0 for x in range(Nf)]
#for i in range(Nf):
#    J_after_abs[i] = J[i] - phi_abs[i] +total_share_ff_abs[i]




bespaar =  [0 for x in range(Nf)]
bespaar2 =  [0 for x in range(Nf)]
compensation = [0 for x in range(Nf)]
compensation2 = [0 for x in range(Nf)]
for i in range(Nf):
    bespaar[i] = ksi_abs[i]-phi_abs[i]
    bespaar2[i] = phi[i] - ksi[i]
    #bespaar[i] = -100 * (ksi_abs[i]-phi_abs[i])
    compensation[i] = -min(0,bespaar[i])
    compensation2[i] = -min(0,bespaar2[i])

ind_cost = [0 for x in range(Nf)]
for i in range(Nf):
    for j in range(len(bundles)):
        if bundles[j] == poolPerFF[i]:
            ind_cost[i] = cost_with[j][i]


extra_new = sum(bespaar) #+ sum(compensation)
extra_new2 = sum(bespaar2)
extra_new_ff = [0 for x in range(Nf)]
total_share_new_ff = [0 for x in range(Nf)]
pay_to_cp = [0 for x in range(Nf)]
J_after_new = [0 for x in range(Nf)]
J_after_new1 = [0 for x in range(Nf)]
J_after_new2 = [0 for x in range(Nf)]
J_after_new3 = [0 for x in range(Nf)]
better_tov_ind = [0 for x in range(Nf)]
pay_to_cp_difference = [0 for x in range(Nf)]

for i in range(Nf):
    pay_to_cp[i] = max(0,bespaar2[i])
    extra_new_ff[i] = extra_new2/2 *( (phi_abs[i]/phi_sum_abs) + (ksi_abs[i]/ksi_sum_abs))
    total_share_new_ff[i] = extra_new_ff[i] + compensation2[i]
    better_tov_ind[i] = total_share_new_ff[i] + bespaar2[i] - pay_to_cp[i]
    pay_to_cp_difference[i] = pay_to_cp[i] - total_share_new_ff[i]
    
    #J_after_new2[i] = ind_J[i] + total_share_new_ff[i] + bespaar[i] - pay_to_cp[i]
    #J_after_new[i] = J[i] - phi_abs[i] +total_share_new_ff[i]
    #J_after_new1[i] = rev_ff[i] + total_share_new_ff[i] - max(0,bespaar[i]) - cost_final[i]
    J_after_new3[i] = rev_ff[i] + total_share_new_ff[i] + bespaar2[i] - pay_to_cp[i] - ind_cost[i]



time_p5 = time.time() - begin_p5

total_time_auction = time_p1/Nf + time_p2 + total_time_bidding/Nf + time_p4 + time_p5

########################
### Get KPIs auction ###
########################
# rev_final maak je hierboven al!
#rev_final = [0 for x in range(Nf)]
#for i in range(Nf):
#    for j in range(len(nodes_final[i])):
#        rev_final[i] += node_rev[nodes_final[i][j]-1][0]

#cost_final = [0 for x in range(Nf)]
#for i in range(Nf):
#    cost_final[i] = rev_final[i] - J[i]

weight_final = [0 for x in range(Nf)]
for i in range(Nf):
    for j in range(len(nodes_final[i])):
        weight_final[i] += node_weight[nodes_final[i][j]-1][0]

width_final = [0 for x in range(Nf)]
for i in range(Nf):
    for j in range(len(nodes_final[i])):
        width_final[i] += node_width[nodes_final[i][j]-1][0]

cost_per_kg = [0 for x in range(Nf)]
for i in range(Nf):
    cost_per_kg[i] = cost_final[i]/weight_final[i]

waiting_time_final = [0 for x in range(Nf)]
for i in range(Nf):
    for j in range(len(routes_final[i])):
        for k in range(len(routes_final[i][j])):
            waiting_time_final[i] += timestamps_final[i][j][k][2]-(timestamps_final[i][j][k][0]+timestamps_final[i][j][k][1])

number_trucks_final = [0 for x in range(Nf)]
load_factor_weight = [0 for x in range(Nf)]
for i in range(Nf):
    number_trucks_final[i] = len(routes_final[i])
    total_cap_trucks = number_trucks_final[i] * cap_trailer
    load_factor_weight[i] = weight_final[i]/total_cap_trucks

load_factor_width = [0 for x in range(Nf)]
for i in range(Nf):
    number_trucks = len(routes_final[i])
    total_cap_trucks = number_trucks * L_trailer
    load_factor_width[i] = width_final[i]/total_cap_trucks

movements = [0 for x in range(Nf)]
for i in range(Nf):
    for j in range(len(FF_final[i])):
            movements[i] += len(np.unique(FF_final[i][j])) + len(np.unique(GH_final[i][j])) + 1

number_of_GH_visited = [0 for x in range(Nf)]
for i in range(Nf):
    for j in range(len(GH_final[i])):
            number_of_GH_visited[i] += len(np.unique(GH_final[i][j]))

###########################
### INDIVIDUAL PLANNING ###
###########################

#individual_profit = [0 for x in range(Nf)]
individual_cost = [0 for x in range(Nf)]
individual_routes = [0 for x in range(Nf)]
individual_timestamps = [0 for x in range(Nf)]
individual_FF = [0 for x in range(Nf)]
individual_GH = [0 for x in range(Nf)]


#####################
T = 100
cooling_coeff = 0.000000001
n_iter = 1000000
n_time = total_time_auction
time_ind = [0 for x in range(Nf)]
for i in range(Nf):
    shipments = requestFF[i]
    print('shipments',shipments)
    begin_ind = time.time()
    individual_routes[i], individual_cost[i], individual_timestamps[i], individual_FF[i], individual_GH[i] = aa.alns_over(shipments,timeMatrix,elBounds,processing_time,maxRideTime,Nf,Ng,Nt,sigma,q_nodes,
        cap_trailer,pickup_nodes,distanceMatrix, maxRideTimeTruck,w_TW,w_DC,lat_occupancy_shipments,
        L_trailer,nDocks,alpha,beta,gamma,cost_distance,cost_time,node_rev,multiplier,shipment_FF_GH,Q_truck,
        q_min,T,cooling_coeff,n_iter,n_time)
    #print('profit_with',profit_with)
    time_ind[i] = time.time() - begin_ind
###########################



##for i in range(Nf):
##    for j in range(len(bundles)):
##        if bundles[j] == poolPerFF[i]:
##            individual_profit[i] = profit_with[j][i]
##            individual_routes[i] = routes_with[j][i]
##            individual_timestamps[i] = timestamps_with[j][i]
##            individual_FF[i] = FF_with[j][i]
##            individual_GH[i] = GH_with[j][i]

#get J individual scenario not taking DC violations into account.
ind_J = [0 for x in range(Nf)]
ind_J2 = [0 for x in range(Nf)]
ind_cost = [0 for x in range(Nf)]
rev_ind = [0 for x in range(Nf)]
for i in range(Nf):
    for j in range(len(requestFF[i])):
        rev_ind[i] += node_rev[requestFF[i][j]-1][0]

ind_allDistances = [0 for x in range(Nf)]
ind_allTravelTimes = [0 for x in range(Nf)]
ind_offLoadedShipments = [0 for x in range(Nf)]
TW_violation = 0
DC_violation = 0
for i in range(Nf):
    sigmaS = len(requestFF[i])
    ind_cost[i], ind_allDistances[i], ind_allTravelTimes[i], ind_offLoadedShipments[i] = alsn.cost_weakly_infeasible_solution(alpha,beta,gamma,cost_distance,cost_time,
                            individual_routes[i],individual_timestamps[i],distanceMatrix,sigma,TW_violation,DC_violation,w_TW,w_DC,node_rev,sigmaS)
    ind_J[i] = rev_ind[i]-ind_cost[i]
    ind_J2[i] = rev_ind[i] - individual_cost[i]
    #J_after_new2[i] = ind_J[i] + total_share_new_ff[i] + bespaar[i] - pay_to_cp[i]
    #Deze klopt dan niet meer omdat ind_J beter is geworden.

ind_routes_check1 = []
ind_timestamps_check1 = []
ind_FF_check1 = []
ind_GH_check1 = []

for i in range(Nf):
    for j in range(len(individual_routes[i])):
        ind_routes_check1.append(individual_routes[i][j])
        ind_timestamps_check1.append(individual_timestamps[i][j])
        ind_FF_check1.append(individual_FF[i][j])
        ind_GH_check1.append(individual_GH[i][j])



individual_routes_check = deepcopy(ind_routes_check1)
individual_timestamps_check = deepcopy(ind_timestamps_check1)
individual_FF_check = deepcopy(ind_FF_check1)
individual_GH_check = deepcopy(ind_GH_check1)

#check DC violations in individual scenario
individual_dockCapacityViolation, individual_arrDepGH, individual_numberOfTrucksPerGH = alsn.dock_capacity_violation(individual_routes_check,individual_timestamps_check,
                                                                                            individual_FF_check,individual_GH_check,Nf,Ng,nDocks)

# solve DC violations in individual scenario
ind_routes_dc,ind_routes_timestamps_dc,ind_dockCapacityViolation_dc,ind_arrDepGH_dc,ind_numberOfTrucksPerGH_dc = alsn.dock_capacity_violation_resolver_only(individual_routes_check,
                                        individual_timestamps_check,timeMatrix,elBounds,processing_time,maxRideTime,
                                         individual_dockCapacityViolation,individual_arrDepGH,individual_FF_check,individual_GH_check,Nf,Ng,nDocks)

temp_ind_timestamps = [[] for x in range(Nf)]
for i in range(Nf):
    for j in range(len(individual_timestamps[i])):
        #print('new_routes_timestamps[0]',new_routes_timestamps[0])
        temp_ind_timestamps[i].append(ind_routes_timestamps_dc[0])
        ind_routes_timestamps_dc.pop(0)

ind_timestamps_after_solve_DC = deepcopy(temp_ind_timestamps)

#get J individual scenario taking DC violations into account.
ind_J_dc = [0 for x in range(Nf)]
ind_cost_dc = [0 for x in range(Nf)]
ind_allDistances_dc = [0 for x in range(Nf)]
ind_allTravelTimes_dc = [0 for x in range(Nf)]
ind_offLoadedShipments_dc = [0 for x in range(Nf)]
TW_violation = 0
DC_violation = 0
for i in range(Nf):
    sigmaS = len(requestFF[i])
    ind_cost_dc[i], ind_allDistances_dc[i], ind_allTravelTimes_dc[i], ind_offLoadedShipments_dc[i] = alsn.cost_weakly_infeasible_solution(alpha,beta,gamma,cost_distance,cost_time,
                            individual_routes[i],ind_timestamps_after_solve_DC[i],distanceMatrix,sigma,TW_violation,DC_violation,w_TW,w_DC,node_rev,sigmaS)
    ind_J_dc[i] = rev_ind[i] - ind_cost_dc[i]


####################
### Get kpis ind ###
####################

# Heb je hierboven al uitgerekend
ind_rev = rev_ind
#rev_ind = [0 for x in range(Nf)]
#for i in range(Nf):
#    for j in range(len(requestFF[i])):
#        rev_ind[i] += node_rev[requestFF[i][j]-1][0]

cost_ind = ind_cost
cost_ind_dc = ind_cost_dc
#cost_ind = [0 for x in range(Nf)]
#for i in range(Nf):
#    cost_ind[i] = rev_ind[i] - ind_J[i]

weight_ind = [0 for x in range(Nf)]
for i in range(Nf):
    for j in range(len(requestFF[i])):
        weight_ind[i] += node_weight[requestFF[i][j]-1][0]

width_ind = [0 for x in range(Nf)]
for i in range(Nf):
    for j in range(len(requestFF[i])):
        width_ind[i] += node_width[requestFF[i][j]-1][0]

cost_per_kg_ind = [0 for x in range(Nf)]
for i in range(Nf):
    cost_per_kg_ind[i] = cost_ind[i]/weight_ind[i]

waiting_time_ind = [0 for x in range(Nf)]
for i in range(Nf):
    for j in range(len(individual_routes[i])):
        for k in range(len(individual_routes[i][j])):
            waiting_time_ind[i] += ind_timestamps_after_solve_DC[i][j][k][2]-(ind_timestamps_after_solve_DC[i][j][k][0]+ind_timestamps_after_solve_DC[i][j][k][1])

waiting_time_ind_no_dc = [0 for x in range(Nf)]
for i in range(Nf):
    for j in range(len(individual_routes[i])):
        for k in range(len(individual_routes[i][j])):
            waiting_time_ind_no_dc[i] += individual_timestamps[i][j][k][2]-(individual_timestamps[i][j][k][0]+individual_timestamps[i][j][k][1])

number_trucks_ind = [0 for x in range(Nf)]
load_factor_weight_ind = [0 for x in range(Nf)]
for i in range(Nf):
    number_trucks_ind[i] = len(individual_routes[i])
    total_cap_trucks = number_trucks_ind[i] * cap_trailer
    load_factor_weight_ind[i] = weight_ind[i]/total_cap_trucks

load_factor_width_ind = [0 for x in range(Nf)]
for i in range(Nf):
    number_trucks = len(individual_routes[i])
    total_cap_trucks = number_trucks * L_trailer
    load_factor_width_ind[i] = width_ind[i]/total_cap_trucks

movements_ind = [0 for x in range(Nf)]
for i in range(Nf):
    for j in range(len(individual_FF[i])):
            movements_ind[i] += len(np.unique(individual_FF[i][j])) + len(np.unique(individual_GH[i][j])) + 1

number_of_GH_visited_ind = [0 for x in range(Nf)]
for i in range(Nf):
    for j in range(len(individual_GH[i])):
            number_of_GH_visited_ind[i] += len(np.unique(individual_GH[i][j]))


###################
### Full collab ###
###################

#total_time_auction = time_p1 + time_p2 + total_time_bidding + time_p4 + time_p5
n_time = total_time_auction

shipments1 = list(range(1,sigma+1))
full_collab_routes, full_collab_cost, full_collab_timestamps, full_collab_FF, full_collab_GH = aa.alns_over(shipments1,timeMatrix,elBounds,processing_time,maxRideTime,
                                                                                            Nf,Ng,Nt,sigma,q_nodes, cap_trailer,pickup_nodes,distanceMatrix, maxRideTimeTruck,
                                                                                        w_TW,w_DC,lat_occupancy_shipments, L_trailer,nDocks,alpha,beta,gamma,cost_distance,
                                                                                        cost_time,node_rev,multiplier,shipment_FF_GH,Q_truck, q_min,T,cooling_coeff,n_iter,n_time)

sigmaS = sigma
full_collab_cost2, full_collab_allDistances, full_collab_allTravelTimes, full_collab_offLoadedShipments = alsn.cost_weakly_infeasible_solution(alpha,beta,gamma,cost_distance,cost_time,
                            full_collab_routes,full_collab_timestamps,distanceMatrix,sigma,TW_violation,DC_violation,w_TW,w_DC,node_rev,sigmaS)

full_collab_profit = sum(ind_rev) - full_collab_cost

full_collab_dockCapacityViolation, full_collab_arrDepGH, full_collab_numberOfTrucksPerGH = alsn.dock_capacity_violation(full_collab_routes,full_collab_timestamps,
                                                                                            full_collab_FF,full_collab_GH,Nf,Ng,nDocks)

###############
weight_full_collab = 0
for i in range(sigma):
        weight_full_collab += node_weight[i][0]

width_full_collab = 0
for i in range(sigma):
    width_full_collab += node_width[i][0]

cost_per_kg_full_collab = full_collab_cost/weight_full_collab

waiting_time_full_collab = 0
for j in range(len(full_collab_routes)):
    for k in range(len(full_collab_routes[j])):
        waiting_time_full_collab += full_collab_timestamps[j][k][2]-(full_collab_timestamps[j][k][0]+full_collab_timestamps[j][k][1])

number_trucks_full = len(full_collab_routes)
total_cap_trucks = number_trucks_full * cap_trailer
load_factor_weight_full_collab = weight_full_collab/total_cap_trucks


total_cap_trucks = number_trucks_full * L_trailer
load_factor_width_full_collab = width_full_collab/total_cap_trucks

movements_full_collab = 0
for j in range(len(full_collab_FF)):
        movements_full_collab += len(np.unique(full_collab_FF[j])) + len(np.unique(full_collab_GH[j])) + 1

number_of_GH_visited_full_collab = 0
for j in range(len(full_collab_GH)):
        number_of_GH_visited_full_collab += len(np.unique(full_collab_GH[j]))


##############################
### Write results to excel ###
##############################

##cwd = os.getcwd()
##results_name = 'results_' +  instance_name[:-5] + '_%d'%(allowed_time)  + '.xlsx'
##writer = pd.ExcelWriter(os.path.join(cwd,results_name), engine='xlsxwriter')
##
##full_Pr = full_collab_profit
##full_Di = sum(full_collab_allDistances)
##full_LFwe =  load_factor_weight_full_collab 
##full_LFwi = load_factor_width_full_collab
##full_WT = waiting_time_full_collab
##full_Tr = number_trucks_full
##full_TrGH = number_of_GH_visited_full_collab
##full_TT = sum(full_collab_allTravelTimes)
##
##totals_full = [0,full_Pr,full_Di,full_LFwe,full_LFwi,full_WT,full_Tr,full_TrGH,full_TT]
##total_results_index = ['total_results_below','Pr','Di','LFwe','LFwi','WT','Tr','TrGH','TrTi']
##
###full_results = np.array([[0]]*20)
##full_results = np.array([full_collab_routes,full_collab_cost,full_collab_timestamps,full_collab_FF,full_collab_GH,
##                         full_collab_cost2,full_collab_allDistances,full_collab_allTravelTimes,full_collab_offLoadedShipments,
##                         full_collab_profit,full_collab_dockCapacityViolation, full_collab_arrDepGH,
##                         full_collab_numberOfTrucksPerGH,cost_per_kg_full_collab,waiting_time_full_collab,
##                         load_factor_weight_full_collab, load_factor_width_full_collab, movements_full_collab,
##                         number_of_GH_visited_full_collab,number_trucks_full])
##df_full = pd.DataFrame(full_results)
##df_full.index = ['routes','cost','TS','FF','GH','cost2','D','TT','offLoaded','profit','DC_viol',
##                   'arrDepGH','#T@GH', 'cost_per_kg','waiting', 'LF_we', 'LF_wi', '#move', '#GHarr','#T']
##
###ind_results = np.array([[0]]*20)
##ind_results = np.array([individual_routes,individual_cost,individual_timestamps,individual_FF,
##                        individual_GH,ind_cost,ind_allDistances,ind_allTravelTimes,ind_offLoadedShipments,
##                        ind_J,individual_dockCapacityViolation,individual_arrDepGH,individual_numberOfTrucksPerGH,
##                        '-',waiting_time_ind_no_dc, '-', '-', '-', '-','-'])
##
##df_ind = pd.DataFrame(ind_results)
##df_ind.index = ['routes','cost','TS','FF','GH','cost2','D','TT','offLoaded','profit','DC_viol',
##                   'arrDepGH','#T@GH', 'cost_per_kg','waiting', 'LF_we', 'LF_wi', '#move', '#GHarr','#T']
##
##
##dc_Pr = sum(ind_J_dc)
##dc_Di = 0
##for i in range(Nf):
##    dc_Di += sum(ind_allDistances_dc[i])
##dc_LFwe =  sum(load_factor_weight_ind)/len(load_factor_weight_ind)
##dc_LFwi = sum(load_factor_width_ind)/len(load_factor_width_ind)
##dc_WT = sum(waiting_time_ind)
##dc_Tr = sum(number_trucks_ind)
##dc_TrGH = sum(number_of_GH_visited_ind)
##dc_TT  = 0
##for i in range(Nf):
##    dc_TT += sum(ind_allTravelTimes_dc[i])
##
##totals_ind_dc = [0,dc_Pr,dc_Di,dc_LFwe,dc_LFwi,dc_WT,dc_Tr,dc_TrGH,dc_TT]
##
###ind_dc_results = np.array([[0]]*20)
##ind_dc_results = np.array([ind_routes_dc,ind_cost_dc,ind_timestamps_after_solve_DC,individual_FF,
##                        individual_GH,ind_cost_dc,ind_allDistances_dc,ind_allTravelTimes_dc,ind_offLoadedShipments_dc,
##                        ind_J_dc,ind_dockCapacityViolation_dc,ind_arrDepGH_dc,ind_numberOfTrucksPerGH_dc,
##                        cost_per_kg_ind,waiting_time_ind, load_factor_weight_ind,load_factor_width_ind, movements_ind, number_of_GH_visited_ind,number_trucks_ind])
##df_ind_dc = pd.DataFrame(ind_dc_results)
##df_ind_dc.index = ['routes','cost','TS','FF','GH','cost2','D','TT','offLoaded','profit','DC_viol',
##                   'arrDepGH','#T@GH', 'cost_per_kg','waiting', 'LF_we', 'LF_wi', '#move', '#GHarr','#T']
##
##
##
##A_Pr = sum(J_after_new3)
##A_Di = 0
##for i in range(Nf):
##    A_Di += sum(allDistances_final[i])
##A_LFwe =  sum(load_factor_weight)/len(load_factor_weight)
##A_LFwi = sum(load_factor_width)/len(load_factor_width)
##A_WT = sum(waiting_time_final)
##A_Tr = sum(number_trucks_final)
##A_TrGH = sum(number_of_GH_visited)
##A_TT  = 0
##for i in range(Nf):
##    A_TT += sum(allTravelTimes_final[i])
##
##totals_A = [0,A_Pr,A_Di,A_LFwe,A_LFwi,A_WT,A_Tr,A_TrGH,A_TT]
##
##
###auction_results = np.array([[0]]*32)
##auction_results = np.array([routes_final,cost_final,timestamps_final,FF_final,GH_final,'-',allDistances_final,allTravelTimes_final,offLoadedShipments_final,J,phi_abs,phi,
##                      ksi_abs,ksi,bespaar,bespaar2,extra_new2,pay_to_cp,extra_new_ff,compensation2,
##                     total_share_new_ff,J_after_new3,new_dockCapacityViolation,arrDepGH,new_numberOfTrucksPerGH, cost_per_kg,waiting_time_final, load_factor_weight, load_factor_width,
##                           movements, number_of_GH_visited,number_trucks_final])
##df_auction = pd.DataFrame(auction_results)
##df_auction.index = ['routes','cost','TS','FF','GH','cost2','D','TT','offLoaded','J','phi_abs','phi',
##                      'ksi_abs','ksi','bespaar','bespaar2','extra_new2','paytocp','extranewff','comp',
##                      'tot_share','J_after','DC_viol',
##                   'arrDepGH','#T@GH', 'cost_per_kg','waiting', 'LF_we', 'LF_wi', '#move', '#GHarr','#T']
##
##info = np.array([n_time_keep, n_time_bundles, total_time_auction])
##df_info = pd.DataFrame(info)
##df_info.index = ['keep', 'bundles', 'total']
##
###test1 = np.array([individual_cost, ind_J, individual_timestamps])
###df_test1 = pd.DataFrame(test1)
###df_test1.index = ['cost','profit','TS']
##
##
##data = {'ind_dc':totals_ind_dc,
##        'auction':totals_A,
##        'full':totals_full}
##df_data = pd.DataFrame(data)
##df_data.index  = ['total_results_below','Pr','Di','LFwe','LFwi','WT','Tr','TrGH','TrTi']
##
##
##df_info.to_excel(writer,sheet_name='Info',index=True)
##df_data.to_excel(writer,sheet_name='total_results',index=True)
##
##df_full.to_excel(writer,sheet_name='Full',index=True) 
##df_ind.to_excel(writer,sheet_name='ind',index=True)
##df_ind_dc.to_excel(writer,sheet_name='ind_dc',index=True)
##df_auction.to_excel(writer,sheet_name='auction',index=True)
###df_test1.to_excel(writer,sheet_name='test1',index=True) 
##
##
##writer.save()

















