# -*- coding: utf-8 -*-
"""
Created on Mon Dec 30 21:41:15 2019

@author: abombelli
Adjusted by S van Alebeek
"""

import numpy as np
import os
import openpyxl
import pandas as pd
import time
import operator
from copy import deepcopy
import random
import matplotlib.pyplot as plt
from collections import OrderedDict

random.seed(5)

# Get path to current folder
cwd = os.getcwd()

for n_inst in range(1):

    Nf     = 3         # number of FFs
    Ng     = 3         # number of GHs
    Nf_max = 5         # max number of FFs
    Ng_max = 5         # max number of GHs
    n_min  = 2         # min. number of ULDs per FF-GH pair
    n_max  = 7         # max. number of ULDs per FF-GH pair
    
    idx_FF = sorted(random.sample(list(np.arange(1,Nf_max+1)),Nf))
    idx_GH = sorted(random.sample(list(np.arange(1,Ng_max+1)),Ng))
    
    # Time matrix between warehouses
    df                = pd.read_excel(os.path.join(cwd,'dist_matrix_warehouses.xlsx'),sheet_name='Sheet1',header=None)
    distanceMatrix    = df.values
    averageSpeed      = 35 # [km/h]
    dockingTime       = 2  # [min]
    dockingTimeMatrix = dockingTime*np.ones([int(Nf_max+Ng_max+2),int(Nf_max+Ng_max+2)])
    np.fill_diagonal(dockingTimeMatrix,0)
    dockingTimeMatrix[:,int(len(dockingTimeMatrix))-1] = 0
    dockingTimeMatrix[int(len(dockingTimeMatrix))-1,:] = 0
    travelTimeMatrix = np.divide(distanceMatrix,averageSpeed)*60+dockingTimeMatrix # *60 used to transform travel time from hours to minutes
    
    container_percentage = 0.5
    container_weight_mu  = 1000
    container_weight_std = 200
    container_weight_max = 1500
    pallet_weight_mu     = 2800
    pallet_weight_std    = 400
    pallet_weight_max    = 4600
    
    container_proc_time_min  = 2
    container_proc_time_mode = 4
    container_proc_time_max  = 7
    pallet_proc_time_min     = 4
    pallet_proc_time_mode    = 7
    pallet_proc_time_max     = 10
    
    container_width = 1.54 # [m]
    pallet_width    = 3.18 # [m]
    
    T_timespan               = 480 # 8 hours
    min_early_time_pickup    = 50
    max_early_time_pickup    = 120  
    delta_pickup_delivery    = 30
    min_late_time_delivery   = 200
    #max_late_time_delivery   = 350
    max_late_time_delivery   = 480 
    
    perc_tw = 0.5
    
    pickup_nodes_block = []
    cont          = 1
    for i in range(0,Nf):
        for j in range(0,Ng):
            for k in range(0,np.random.randint(n_min,n_max)):
                this_ULD_idx = cont
                w            = random.random()
                
                if w < container_percentage:
                    this_ULD_type = 0
                else:
                    this_ULD_type = 1
                    
                if this_ULD_type == 0:
                    this_ULD_weight    = np.min([np.random.normal(container_weight_mu,container_weight_std),container_weight_max])
                    this_ULD_proc_time = np.random.triangular(container_proc_time_min,container_proc_time_mode,container_proc_time_max)
                    this_ULD_width     = container_width
                else:
                    this_ULD_weight = np.min([np.random.normal(pallet_weight_mu,pallet_weight_std),pallet_weight_max])
                    this_ULD_proc_time = np.random.triangular(pallet_proc_time_min,pallet_proc_time_mode,pallet_proc_time_max)
                    this_ULD_width     = pallet_width
                    
                this_row = [cont,0,i+1,idx_FF[i],j+1,idx_GH[j],this_ULD_type,this_ULD_weight,this_ULD_width,this_ULD_proc_time]
                pickup_nodes_block.append(this_row)
                cont     += 1
                
    pickup_nodes_block = np.array(pickup_nodes_block)
    sigma         = int(len(pickup_nodes_block[:,0]))
    
    
    n_tw                       = int(np.round(perc_tw*len(pickup_nodes_block[:,0])))
    all_tw                     = []

    
    number_of_del_sets = 0
    if sigma/Ng < 10:
        number_of_del_sets = 2
    elif sigma/Ng < 15:
        number_of_del_sets = 3
    elif sigma/Ng < 20:
        number_of_del_sets = 4
    elif sigma/Ng < 30:
        number_of_del_sets = 5
    else:
        number_of_del_sets = 6

    del_sets = list(range(240,480,int(240/number_of_del_sets)))
    del_sets_set = [0 for x in range(Ng)]
    for j in range(Ng):
        a = random.randrange(0,50,10)
        del_sets_set[j] = [x - a for x in del_sets]

        
    #Add revenue for requests
    revenue = np.zeros((sigma*2,1))
    for i in range(sigma*2):
        revenue[i] = random.randrange(20,31,1)
    #print(revenue)
    
    # Add time-windows for pickup
    idx_ULD_time_window_pickup = sorted(random.sample(list(np.arange(1,len(pickup_nodes_block[:,0]))),n_tw))
    for i in range(0,int(len(pickup_nodes_block[:,0]))):
        if i in idx_ULD_time_window_pickup:
            this_early_time_pickup = min_early_time_pickup + (max_early_time_pickup-min_early_time_pickup)*random.random()
            all_tw.append([this_early_time_pickup,T_timespan])
        else:
            all_tw.append([0,T_timespan])
            
##    # Add time-windows for delivery
##    idx_ULD_time_window_delivery = sorted(random.sample(list(np.arange(1,len(pickup_nodes_block[:,0]))),n_tw))
##    for i in range(0,int(len(pickup_nodes_block[:,0]))):
##        if i in idx_ULD_time_window_delivery:
##            if all_tw[i][0] == 0:
##                this_late_time_delivery = min_late_time_delivery + (max_late_time_delivery-min_late_time_delivery)*random.random()
##            else:
##                this_late_time_delivery = np.max([min_late_time_delivery+(max_late_time_delivery-min_late_time_delivery)*random.random(),
##                        all_tw[i][0]+travelTimeMatrix[int(pickup_nodes_block[i][3])][int(pickup_nodes_block[i][5]+Nf)]+delta_pickup_delivery])
##            #this_early_time_pickup = min_early_time_pickup + (max_early_time_pickup-min_early_time_pickup)*random.random()
##            #all_tw.append([this_early_time_pickup,this_late_time_delivery])
##            all_tw.append([max(0,this_late_time_delivery-180),this_late_time_delivery])
##        else:
##            timytime = T_timespan - 240 + 120*random.random()
##            all_tw.append([timytime,T_timespan])

### Sanne
    # Add time-windows for delivery
    idx_ULD_time_window_delivery = sorted(random.sample(list(np.arange(1,len(pickup_nodes_block[:,0]))),n_tw))
    for i in range(0,int(len(pickup_nodes_block[:,0]))):
        if i in idx_ULD_time_window_delivery:
            for j in range(Ng):
                if pickup_nodes_block[i][4] == j+1:
                    this_late_time_delivery = random.choice(del_sets_set[j])
                else:
                    print(i,'ao')
            all_tw.append([max(0,this_late_time_delivery-180),this_late_time_delivery])
        else:
            #timytime = T_timespan - 240 + 120*random.random()
            all_tw.append([T_timespan-180,T_timespan])
            
##    # Add time-windows for delivery
##    idx_ULD_time_window_delivery = sorted(random.sample(list(np.arange(1,len(pickup_nodes_block[:,0]))),n_tw))
##    for i in range(0,int(len(pickup_nodes_block[:,0]))):
##        if i in idx_ULD_time_window_delivery:
##            if all_tw[i][0] == 0:
##                this_late_time_delivery = min_late_time_delivery + (max_late_time_delivery-min_late_time_delivery)*random.random()
##            else:
##                this_late_time_delivery = np.max([min_late_time_delivery+(max_late_time_delivery-min_late_time_delivery)*random.random(),
##                        all_tw[i][0]+travelTimeMatrix[int(pickup_nodes_block[i][3])][int(pickup_nodes_block[i][5]+Nf)]+delta_pickup_delivery])
##            this_early_time_pickup = min_early_time_pickup + (max_early_time_pickup-min_early_time_pickup)*random.random()
##            all_tw.append([this_early_time_pickup,this_late_time_delivery])
##            #all_tw.append([0,this_late_time_delivery])
##        else:
##            all_tw.append([0,T_timespan])
##
##    # Add time-windows for delivery
##    idx_ULD_time_window_delivery = sorted(random.sample(list(np.arange(1,len(pickup_nodes_block[:,0]))),n_tw))
##    for i in range(0,int(len(pickup_nodes_block[:,0]))):
##        if i in idx_ULD_time_window_delivery:
##            all_tw.append([0,240])
##            #if all_tw[i][0] == 0:
##            #    this_late_time_delivery = min_late_time_delivery + (max_late_time_delivery-min_late_time_delivery)*random.random()
##            #else:
##            #    this_late_time_delivery = np.max([min_late_time_delivery+(max_late_time_delivery-min_late_time_delivery)*random.random(),
##            #            all_tw[i][0]+travelTimeMatrix[int(pickup_nodes_block[i][3])][int(pickup_nodes_block[i][5]+Nf)]+delta_pickup_delivery])
##            #this_early_time_pickup = min_early_time_pickup + (max_early_time_pickup-min_early_time_pickup)*random.random()
##            #all_tw.append([this_early_time_pickup,this_late_time_delivery])
##            #all_tw.append([0,this_late_time_delivery])
##        #else:
##            #all_tw.append([0,T_timespan])
    
    # Data for delivery nodes to complete the instance file
    delivery_nodes_idx        = np.arange(sigma+1,2*sigma+1).reshape(-1,1) # delivery nodes IDs range from sigma+1 to 2*sigma
    delivery_nodes_identifier = np.ones([sigma,1])
    delivery_nodes_weight     = np.zeros([sigma,1])
    
    delivery_block = np.hstack([delivery_nodes_idx,delivery_nodes_identifier,pickup_nodes_block[:,2:8],delivery_nodes_weight,pickup_nodes_block[:,9:10]]) 
    
    pickup_delivery_block = np.vstack([pickup_nodes_block,delivery_block])
    
    full_instance         = np.hstack([pickup_delivery_block,all_tw])

    #print(sigma)
    #print(full_instance.shape)
    full_instance = np.append(full_instance, revenue, axis=1)
    #print(full_instance.shape)
    
    
    df_full_instance = pd.DataFrame(full_instance)
    df_full_instance.columns = ['node_idx','node_type','FF','FF_idx','GH','GH_idx',
                                'ULD_type','ULD_weight','ULD_width','ULD_proc_time','early_time','late_time','revenue']
    # Fix this one, ROws and columns are the same and are the unionof the two. For GH add Nf
    rows_this_instance    = [0]+idx_FF+(np.array(idx_GH)+Nf).tolist()+[len(distanceMatrix)-1]  
    distance_matrix_this_instance = distanceMatrix[np.ix_(rows_this_instance,rows_this_instance)] 
    df_full_instance_distance_matrix = pd.DataFrame(distance_matrix_this_instance) 
    
    writer = pd.ExcelWriter(os.path.join(cwd,'Sanne_%d_%d_%d_%d_%.1f.xlsx'%(n_inst+1,Nf,Ng,sigma,perc_tw)),
                            engine='xlsxwriter')
    df_full_instance.to_excel(writer,sheet_name='sheet_1',index=False) 
    df_full_instance_distance_matrix.to_excel(writer,sheet_name='sheet_2',index=False,header=False)
    writer.save()
    


   
    


                
            
            
            
            
            
            

