"""
Based on ALNS by A. Bombelli

created: 02-03-2020
Sanne van Alebeek
"""


import math
import numpy as np
import os
import openpyxl
import pandas as pd
import time
import operator
from copy import deepcopy
import random
import matplotlib.pyplot as plt
from collections import OrderedDict
import itertools
#import alns_functions_sanne as alsn
import scipy.cluster.hierarchy as sch
from scipy.spatial.distance import pdist, squareform
import pulp
from pulp import *
import alns_functions as alsn


def read_data(instance_name,T_timespan):
    # path to current folder
    cwd = os.getcwd()

    # Load data for this instance
    ULDs_data                 = pd.read_excel(os.path.join(cwd,instance_name),sheet_name='sheet_1')
    df                        = pd.read_excel(os.path.join(cwd,instance_name),sheet_name='sheet_2',header=None)
    distance_warehouse_matrix = df.values
    #print('d',distance_warehouse_matrix)
    # Node info
    node_idx       = ULDs_data['node_idx'].values.reshape(-1,1)
    node_pd        = ULDs_data['node_type'].values.reshape(-1,1)
    node_FF        = ULDs_data['FF'].values.reshape(-1,1)
    node_GH        = ULDs_data['GH'].values.reshape(-1,1)
    node_type      = ULDs_data['ULD_type'].values.reshape(-1,1)
    node_weight    = ULDs_data['ULD_weight'].values.reshape(-1,1)
    node_width     = ULDs_data['ULD_width'].values.reshape(-1,1)
    node_proc_time = ULDs_data['ULD_proc_time'].values.reshape(-1,1)
    node_et        = ULDs_data['early_time'].values.reshape(-1,1)
    node_lt        = ULDs_data['late_time'].values.reshape(-1,1)
    node_rev       = ULDs_data['revenue'].values.reshape(-1,1)
    
    # Determine number of ULDs
    sigma = int(len(node_idx)/2)
    # Determine number of FF
    Nf = np.max(node_FF)
    # Determine number of GH
    Ng = np.max(node_GH)

    pickup_nodes_info = np.hstack([node_idx[:int(sigma)],node_pd[:int(sigma)],
                                    node_FF[:int(sigma)],node_GH[:int(sigma)],
                                    node_type[:int(sigma)],node_weight[:int(sigma)],
                                    node_proc_time[:int(sigma)],node_et[:int(sigma)],
                                    node_lt[:int(sigma)],node_width[:int(sigma)]])

    delivery_nodes_info = np.hstack([node_idx[int(sigma):],node_pd[int(sigma):],
                                    node_FF[int(sigma):],node_GH[int(sigma):],
                                    node_type[int(sigma):],node_weight[int(sigma):],
                                    node_proc_time[int(sigma):],node_et[int(sigma):],
                                    node_lt[int(sigma):],node_width[int(sigma):]])

    Nodes = list(range(1,sigma+1))
    Nodes1 = list(range(sigma+1,2*sigma+1))
    
    pickup_nodes = [[[] for x in range(Ng)] for x in range(Nf)]
    delivery_nodes = [[[] for x in range(Ng)] for x in range(Nf)]

    for i in range(0,Nf):
        for j in range(0,Ng):
            pickup_nodes[i][j] = (np.intersect1d(np.where(pickup_nodes_info[:,2]==i+1)[0],np.where(pickup_nodes_info[:,3]==j+1)[0])+1).tolist()

    for i in range(0,Nf):
        for j in range(0,Ng):
           delivery_nodes[i][j] = (np.intersect1d(np.where(delivery_nodes_info[:,3]==j+1)[0],np.where(delivery_nodes_info[:,2]==i+1)[0])+1+sigma).tolist()

    requestGH = [] # To which GH do the request belong? For all GH make a list with the requests.
    for i in range(0,Ng):
        requestGH.append(list(np.where(delivery_nodes_info[:,3]==i+1)[0]+1))

    requestGH1 = [] # To which GH do the request belong? For all GH make a list with the requests.
    for i in range(0,Ng):
        requestGH1.append(list(np.where(delivery_nodes_info[:,3]==i+1)[0]+1+sigma))

    requestFF = []
    for i in range(0,Nf):
        requestFF.append(list(np.where(delivery_nodes_info[:,2]==i+1)[0]+1))
    
    shipment_FF_GH = {}
    for i in range(0,sigma):
        shipment_FF_GH[str(i+1)]=[int(node_FF[i][0]-1),int(node_GH[i][0]-1)]

    #######################
    ### DISTANCE MATRIX ###
    #######################    
    distance_mat_delivery_pickup = np.zeros([sigma,sigma])

    distance_vec_Od_pickup_nodes = np.zeros([sigma])
    for i in range(0,sigma):
        thisFF             = np.int(pickup_nodes_info[i][2])
        distance_vec_Od_pickup_nodes[i] = distance_warehouse_matrix[0][thisFF]
        
    distance_vec_delivery_nodes_Dd = np.zeros([sigma,1])
    for i in range(0,sigma):
        thisGH = np.int(delivery_nodes_info[i][3])
        distance_vec_delivery_nodes_Dd[i] = distance_warehouse_matrix[0][Nf+thisGH]
        
    distance_mat_pickup_pickup   = np.zeros([sigma,sigma])
    for i in range(0,sigma-1):
        for j in range(i+1,sigma):
            first_node_FF  = np.int(pickup_nodes_info[i][2])
            second_node_FF = np.int(pickup_nodes_info[j][2])
            distance_mat_pickup_pickup[i][j] = distance_warehouse_matrix[first_node_FF][second_node_FF]
    distance_mat_pickup_pickup = distance_mat_pickup_pickup+distance_mat_pickup_pickup.transpose()

    distance_mat_delivery_delivery   = np.zeros([sigma,sigma])
    for i in range(0,sigma-1):
        for j in range(i+1,sigma):
            first_node_GH  = np.int(delivery_nodes_info[i][3])
            second_node_GH = np.int(delivery_nodes_info[j][3])
            distance_mat_delivery_delivery[i][j] = distance_warehouse_matrix[first_node_GH+Nf][second_node_GH+Nf]
    distance_mat_delivery_delivery = distance_mat_delivery_delivery+distance_mat_delivery_delivery.transpose()

    distance_mat_pickup_delivery = np.eye(sigma)
    for i in range(0,sigma):
        this_node_FF = np.int(pickup_nodes_info[i][2])
        this_node_GH = np.int(delivery_nodes_info[i][3])
        distance_mat_pickup_delivery[i][i] = distance_warehouse_matrix[this_node_FF][this_node_GH+Nf]

    # Assembling the full distance matrix
    dummy0         = np.hstack([[0],distance_vec_Od_pickup_nodes,np.zeros([sigma]),[0]])
    dummy1         = np.hstack([np.zeros([sigma,1]),distance_mat_pickup_pickup,distance_mat_pickup_delivery,np.zeros([sigma,1])])
    dummy2         = np.hstack([np.zeros([sigma,1]),distance_mat_delivery_pickup,distance_mat_delivery_delivery,distance_vec_delivery_nodes_Dd])
    dummy3         = np.zeros([2*sigma+2])
    distanceMatrix = np.vstack([dummy0,dummy1,dummy2,dummy3])
    #print('0',dummy0)
    #print('1',dummy1)
    #print('2',dummy2)
    #print('3',dummy3)

    
    #print('distanceMatrix',distanceMatrix[2])
    ###################
    ### TIME MATRIX ###
    ###################
    #distanceMatrix = distance_warehouse_matrix
    averageSpeed     = 35 # [km/h]
    dockingTime      = 2  # [min]
    travelTimeMatrix = np.divide(distanceMatrix,averageSpeed)*60 # *60 used to transform travel time from hours to minutes

    docking_mat_delivery_pickup = np.zeros([sigma,sigma])

    docking_vec_Od_pickup = np.zeros([sigma])
    for i in range(0,sigma):
        docking_vec_Od_pickup[i] = dockingTime

    docking_vec_delivery_Dd = np.zeros([sigma])
    for i in range(0,sigma):
        docking_vec_delivery_Dd[i] = 0
        
    docking_mat_pickup_pickup   = np.zeros([sigma,sigma])
    for i in range(0,sigma-1):
        for j in range(i+1,sigma):
            first_node_FF  = np.int(pickup_nodes_info[i][2])
            second_node_FF = np.int(pickup_nodes_info[j][2])
            if first_node_FF==second_node_FF:
                docking_mat_pickup_pickup[i][j] = 0
            else:
                docking_mat_pickup_pickup[i][j] = dockingTime
    docking_mat_pickup_pickup = docking_mat_pickup_pickup+docking_mat_pickup_pickup.transpose()

    docking_mat_delivery_delivery   = np.zeros([sigma,sigma])
    for i in range(0,sigma-1):
        for j in range(i+1,sigma):
            first_node_GH  = np.int(delivery_nodes_info[i][3])
            second_node_GH = np.int(delivery_nodes_info[j][3])
            if first_node_GH==second_node_GH:
                docking_mat_delivery_delivery[i][j] = 0
            else:
                docking_mat_delivery_delivery[i][j] = dockingTime
            
    docking_mat_delivery_delivery = docking_mat_delivery_delivery+docking_mat_delivery_delivery.transpose()

    #print('dock',docking_mat_delivery_delivery)
    docking_mat_pickup_delivery = np.eye(sigma)*dockingTime

    # Assembling the full timeMatrix
    dummy0  = np.hstack([[0],docking_vec_Od_pickup,np.zeros([sigma]),[0]])
    dummy1  = np.hstack([np.zeros([sigma,1]),docking_mat_pickup_pickup,docking_mat_pickup_delivery,np.zeros([sigma,1])])
    dummy2  = np.hstack([np.zeros([sigma,1]),docking_mat_delivery_pickup,docking_mat_delivery_delivery,np.zeros([sigma,1])])
    dummy3  = np.zeros([2*sigma+2])
    dockingTimeMatrix = np.vstack([dummy0,dummy1,dummy2,dummy3])




    #dockingTimeMatrix = np.zeros([Nf+Ng+2,Nf+Ng+2])
    #for i in range(Nf+Ng+2):
    #    for j in range(Nf+Ng+2):
    #        if i!=j and i!=0 and j!=0:
    #            dockingTimeMatrix[i][j] = 2

    
    timeMatrix = travelTimeMatrix+dockingTimeMatrix


    #print('d',dockingTimeMatrix)
    #print('t',travelTimeMatrix[1])
    #print('timeMatrix',timeMatrix[0])

    ########################
    ### PROCESSING TIMES ###
    ########################
    processing_time = []
    for i in range(0,2*sigma+1):
        if i == 0:
            processing_time.append(0)
        elif i<sigma+1:
            processing_time.append(pickup_nodes_info[i-1][6])
        else:
            processing_time.append(delivery_nodes_info[i-sigma-1][6])
    processing_time.append(0)
            
    ####################
    ### TIME-WINDOWS ###
    ####################
    elBoundsOriginDepot      = [0,T_timespan]
    elBoundsDestinationDepot = [0,T_timespan]
    elBounds = []
    for i in range(0,2*sigma+2):
        if i==0:
            elBounds.append(elBoundsOriginDepot)
        elif i<sigma+1:
            ei = pickup_nodes_info[i-1][7]
            li = pickup_nodes_info[i-1][8]
            elBounds.append([ei,li])
        elif i<2*sigma+1:
            ei = delivery_nodes_info[i-sigma-1][7]
            li = delivery_nodes_info[i-sigma-1][8]
            elBounds.append([ei,li])
        else:
            elBounds.append(elBoundsDestinationDepot)
           
    late_time_windows = np.array(elBounds)[:,1].tolist()
           
    ############################################
    ### WEIGHT VECTOR FOR TRUCK MAX CAPACITY ###
    ############################################
    # Determine estimate of minimum number of trucks required
    L_trailer      = 13.6  # [m]
    cap_trailer    = 10000 # [kg]
    overall_weight = np.sum(pickup_nodes_info[:,5])
    overall_width  = np.sum(pickup_nodes_info[:,9])
    # Adding an extra truck to be conservative
    Nt             = int(np.max([np.ceil(overall_weight/cap_trailer),np.ceil(overall_width/L_trailer)]))
    # Trucks upper bound start/end service time
    truck_OD_Time = []
    for i in range(0,Nt):
        truck_OD_Time.append([T_timespan,T_timespan])

    Q_truck = []
    for i in range(0,Nt):
        Q_truck.append(cap_trailer)         

    q_nodes = []
    for i in range(0,sigma):
        q_nodes.append(pickup_nodes_info[i][5])
        
    # List of lengths of all shipments
    lat_occupancy_shipments = pickup_nodes_info[:,9].tolist()
            
    #################################
    ### Indices used in the model ###
    #################################
    idxFF                  = np.arange(1,Nf+1).tolist()
    idxGH                  = np.arange(1,Ng+1).tolist()
    idx_pickup_nodes       = np.arange(1,sigma+1).tolist()
    idx_delivery_nodes     = np.arange(sigma+1,2*sigma+1).tolist()

    ##################################
    ### Number of docks in each GH ###
    ##################################
    if instance_name[0] == 'S' or instance_name[0] == 'M':
        nDocks = np.ones(Ng)
    else:
        nDocks = 2*np.ones(Ng)
    nDocks = nDocks.astype(int).tolist()

    return node_idx,node_pd,node_FF,node_GH,node_type,node_weight,node_width,node_proc_time,node_et,node_lt,\
           node_rev,sigma,Nf,Ng,pickup_nodes_info,delivery_nodes_info,pickup_nodes,delivery_nodes,requestGH,requestGH1,requestFF,shipment_FF_GH,\
           distanceMatrix,timeMatrix,processing_time,elBounds,late_time_windows,L_trailer,cap_trailer,Nt,\
           truck_OD_Time,Q_truck,q_nodes,lat_occupancy_shipments,idxFF,idxGH,idx_pickup_nodes,idx_delivery_nodes,\
           nDocks,Nodes,Nodes1

    #return node_idx,node_pd,node_FF,node_GH,node_type,node_weight,node_width,node_proc_time,node_et,node_lt,\
    #       node_rev,sigma,Nf,Ng,pickup_nodes_info,delivery_nodes_info,pickup_nodes,delivery_nodes,requestGH,requestGH1,requestFF,shipment_FF_GH,\
    #       distance_warehouse_matrix,   timeMatrix,processing_time,elBounds,late_time_windows,L_trailer,cap_trailer,Nt,\
    #       truck_OD_Time,Q_truck,q_nodes,lat_occupancy_shipments,idxFF,idxGH,idx_pickup_nodes,idx_delivery_nodes,\
    #       nDocks,Nodes,Nodes1

def overlap1(Nf,Ng,delivery_nodes,elBounds):
    overlapMatrices = []
    overlap = []
    overlapNodes = []
    timeWindows = []
    for i in range(0,Nf):
        over = []
        for j in range(0,Ng):
            amountTW = len(delivery_nodes[i][j]) # number of TW for this FF for the first GH.
            overlapMatrix = np.zeros([amountTW,amountTW])
            #print('amountTW',amountTW)
            #print('overlapMatrix',overlapMatrix)
            TW = []
            for k in range(0,amountTW):
                #print('node',exportPickupNodes[i][j][k])
                TW.append(elBounds[delivery_nodes[i][j][k]])
            #print('TW',TW)
            for m in range(amountTW):
                #print("tw m", TW[m])
                count = 0
                for n in range(amountTW):
                    #print("TW n", TW[n])
                    minmax = max(0, min(TW[m][1],TW[n][1]) - max(TW[m][0],TW[n][0]))
                    if m==n:
                        minmax = 0
                    #print("minmax",minmax)
                    overlapMatrix[m][n] = minmax
                    count = count + minmax
                timeWindows.append(TW[m])
                #print("count", count)
                over.append(count)
                #print('over',over)
                overlapNodes.append(count)
                #print("overlapNodes",overlapNodes)
            #print('overlapMatrix',overlapMatrix)
            overlapMatrices.append(overlapMatrix)
        overlap.append(over)
        #print("overlap",overlap)      
    #print("overlapNodes",overlapNodes)
    #print("overlap",overlap)
    return overlapMatrices, overlap, overlapNodes

def intersection(lst1, lst2): 
    lst3 = [value for value in lst1 if value in lst2] 
    return lst3

def request_selection1(Nf,Ng,delivery_nodes,requestFF,keepPercentage,min_overlap,Nodes,Nodes1,elBounds,sigma,requestGH,requestGH1):
    # Sorting the overlap for all FF. The time windows with most overlap are kept by the FF.
    # Sorting on requests per GH not single requests.
    # If there is a request at a FF with low (min_overlap) overlap
    # with other requests, this is put in the pool first.
    #Call overlap function
    overlapMatrices, overlap, overlapNodes = overlap1(Nf,Ng,delivery_nodes,elBounds)
    
    summation = []
    amountRequestFF = []
    for i in range(0,Nf):
        amountRequestFF.append(len(requestFF[i]))
        summation1 = [] 
        for j in range(0,Ng):
            summ = 0
            for k in range(len(delivery_nodes[i][j])):
               #print('overlapNodes',overlapNodes)
               #print('hierrrrr',overlapNodes[delivery_nodes[i][j][k]-sigma-1])
               summ = summ + overlapNodes[delivery_nodes[i][j][k]-sigma-1]
               #print('summ',summ)
            summ = summ/2
            summation1.append(summ)
        summation.append(summation1)
    #print('summation', summation)
    # summation is sum of all total overlaps at a GH. divided by 2 because
    # every overlap is counted twice: overlap between 1,2 and 2,1

    
    thresKeepFF = [math.ceil(a*b) for a,b in zip(keepPercentage,amountRequestFF)]
    #print('thresKeepFF',thresKeepFF)
    keepNodes1 = []
    keepNodesFF1 = []
    for i in range(Nf):
        if keepPercentage[i] == 0:
            print('The FF puts everything into the pool', i)
        else:
            indices = [j for j, x in enumerate(summation[i]) if x == max(summation[i])]
            #print('indices',indices)
            keepFF = []
            for k in range(len(indices)):
                for l in range(len(delivery_nodes[i][indices[k]])):
                    keepFF.append(delivery_nodes[i][indices[k]][l])
                    #print('blaaa',(delivery_nodes[i],summation[i],i,k,l))
                #print('keepFF',keepFF)
                b = 0
                if keepPercentage[i] != 1:
                    remove = []
                    for p in range(len(keepFF)):
                        if overlapNodes[keepFF[p]-sigma-1] < min_overlap:
                            remove.append(keepFF[p])
                    for q in range(len(remove)):
                        keepFF.remove(remove[q])
                while len(keepFF) < thresKeepFF[i] and b < len(delivery_nodes[i]):
                    b += 1
                    #print('b',b)
                    #print('we need more nodes')
                    #print('summation[i]', summation[i])
                    maxi= max(summation[i])
                    for m in range(len(summation[i])):
                        #print('max',maxi)
                        if summation[i][m] == maxi:
                            summation[i][m] = -1
                    #summation[i].remove(max(summation[i]))
                    #print('new summation[i]', summation[i])
                    indices = [j for j, x in enumerate(summation[i]) if x == max(summation[i])]
                    #print('new indices',indices)
                    #We nee to add more nodes.
                    for k in range(len(indices)):
                        for l in range(len(delivery_nodes[i][indices[k]])):
                            keepFF.append(delivery_nodes[i][indices[k]][l])
                            #print('blaaa',(exportDeliveryNodes[i],summation[i],i,k,l))
                            #print('keepFF2',keepFF)
                    # Delete node with less than min_overlap minutes of overlap at GH
                    print('keep2',keepFF)
                    if keepPercentage[i] != 1:
                        remove = []
                        for p in range(len(keepFF)):
                            if overlapNodes[keepFF[p]-sigma-1] < min_overlap:
                                remove.append(keepFF[p])
                        for q in range(len(remove)):
                            keepFF.remove(remove[q])
                        print('keep3',keepFF)
            for n in range(len(keepFF)):
                keepNodes1.append(keepFF[n])      
            keepNodesFF1.append(keepFF)
    #print(keepNodes1)

    keepNodes1 = list(set(keepNodes1))
    for i in range(Nf):
        keepNodesFF1[i] = list(set(keepNodesFF1[i]))
     
    #print('keepNodes',keepNodes)
    poolNodes1 = list(set(Nodes1).difference(keepNodes1))
    poolNodes = [x - sigma for x in poolNodes1]
    keepNodes = [x - sigma for x in keepNodes1]

    #Sort the poolNodes over the GH.
    poolPerGH = []
    for i in range(0,Ng):
        poolPerGH.append(intersection(poolNodes,requestGH[i]))
    #print('poolPerGH', poolPerGH)

    poolPerFF = []
    for i in range(0,Nf):
        poolPerFF.append(intersection(poolNodes,requestFF[i]))

    poolPerGHPerFF = []
    for i in range(len(poolPerGH)):
        for j in range(Nf):
            poolPerGHPerFF.append(intersection(poolPerGH[i],requestFF[j]))

    #Sort the poolNodes over the GH.
    poolPerGH1 = []
    for i in range(0,Ng):
        poolPerGH1.append(intersection(poolNodes1,requestGH1[i]))
    #print('poolPerGH1', poolPerGH1)

    keepNodesFF = []
    for i in range(0,Nf):
       keepNodesFF.append(intersection(keepNodes,requestFF[i]))

    return keepNodes,keepNodes1,poolNodes,poolNodes1,keepNodesFF,keepNodesFF1,poolPerGH,\
           poolPerGH1,summation,poolPerGHPerFF,poolPerFF


def make_pool_matrices(poolPerGH,elBounds,sigma):
    #Make the overlap matrix per GH
    poolMatrices = []
    for i in range(0,len(poolPerGH)):
        poolWindow = []
        for j in poolPerGH[i]:
            poolWindow.append(elBounds[j+sigma])          
        #print('poolWindow', poolWindow)
        poolMatrix = np.zeros((len(poolPerGH[i]),len(poolPerGH[i])))
        #if i == 1:
            #poolWindow = [[0.0, 200], [0.0, 224], [200, 480], [300.0, 480.0], [280, 480]]
        for m in range(len(poolPerGH[i])):
            #print("tw m", TW[m])
            for n in range(len(poolPerGH[i])):
                #print("TW n", TW[n])
                minmax = max(0, min(poolWindow[m][1],poolWindow[n][1]) - max(poolWindow[m][0],poolWindow[n][0]))
                if m==n:
                    minmax = 0
                #print("minmax",minmax)
                poolMatrix[m][n] = minmax
        poolMatrices.append(poolMatrix)
        #print(poolMatrix)
    return poolMatrices #TW overlap matrix per GH.

def makeCluster(nodes,cl):
    clusters = [ [] for i in range(max(cl))]
    #print('clusters',clusters)
    for i in range(len(nodes)):
        clusters[cl[i]-1].append(nodes[i])
        #print('cl[i]',cl[i])
        #print('nodes[i]',nodes[i])
    #print('clusters',clusters)
    return clusters

def request_bundling1(poolPerGH,elBounds,sigma,poolPerGHPerFF,Nf,poolPerFF):
    #poolPerGHPerFF =  [[], [8, 9, 10], [15, 16], [5, 6, 7], [], []]
    poolMatrices = make_pool_matrices(poolPerGH,elBounds,sigma)
    bundles = []
    b_matrices = []
    for i in range(len(poolMatrices)):
        a = poolMatrices[i]
        #print('a',a)
        maxMatrix = np.max(a)
        #b = np.divide(1, a , out=0.1*np.ones_like(a), where = a!=0) #1/matrix values
        #b = np.subtract(maxMatrix+0.01*maxMatrix,a) #max minus matrix entry with small extra
        b = np.subtract(maxMatrix,a) #max minus matrix entry
        b_matrices.append(b)
        np.fill_diagonal(b,0)
        #print('b',b)
        for q in range(2,Nf):
            #print('q',q)
            cl1 = sch.fcluster((sch.linkage(squareform(b), method  = "complete")),q, criterion='maxclust')
            #print('cl1',cl1)
            cake = makeCluster(poolPerGH[i],cl1)
            #print('cake1',cake)
            for j in range(len(cake)):
                if cake[j] not in bundles:
                    bundles.append(cake[j])
                else:
                    haha = 1
##        for l in range(1,5):
##            print('l',l)
##            dis = (1/l)*maxMatrix
##            cl2 = sch.fcluster((sch.linkage(squareform(b), method  = "complete")),dis, criterion='maxclust')
##            print('cl2',cl2)
##            cake = makeCluster(poolPerGH[i],cl2)
##            print('cake2',cake)
##            for j in range(len(cake)):
##                if cake[j] not in bundles:
##                    bundles.append(cake[j])
        #print('i',i)
        #print('clusters maxclust',cl1)
        #print('clusters dist',cl2)
    #print('bundles', bundles)
    #Add all poolPerGH into the bundles.
    for i in range(len(poolPerGH)):
        if poolPerGH[i] not in bundles:
            bundles.append(poolPerGH[i])

    for i in range(len(poolPerFF)):
        if poolPerFF[i] not in bundles:
            bundles.append(poolPerFF[i])
            
    for i in range(len(poolPerGHPerFF)):
        #print('poolPerGHPerFF[i]',poolPerGHPerFF[i])
        #print('false',poolPerGHPerFF[i]== 'FALSE')
        #print('not in bundles',poolPerGHPerFF[i] not in bundles)
        if len(poolPerGHPerFF[i]) != 0 and poolPerGHPerFF[i] not in bundles:
            bundles.append(poolPerGHPerFF[i])

    if len(poolPerGH) > 2:
        for i in range(len(poolPerGH)):
            for j in range(len(poolPerGH)):
                if i<j and poolPerGH[i]+poolPerGH[j] not in bundles:
                    bundles.append(poolPerGH[i]+poolPerGH[j])

    bundles1 = [[] for x in range(len(bundles))]
    for i in range(len(bundles)):
        for j in range(len(bundles[i])):
            bundles1[i].append(bundles[i][j]+sigma)
                       
    return bundles, bundles1, b_matrices

def is_overlap(timestamp1,timestamp2):
    if timestamp1[1] == timestamp2[1]:
        minmax = max(0, min(timestamp1[0][1],timestamp2[0][1]) - max(timestamp1[0][0],timestamp2[0][0]))
        if minmax == 0:
            overlap_TF = 0 #'False'
        else:
            overlap_TF = 1 #'TRUE'
    else:
        overlap_TF = 0 #'False'
    return overlap_TF

def WDP_hard(Nf,bundles,marginal_profit,poolNodes,timestamps_with,routes_with,
             node_GH,Ng,sigma,keepNodesFF,Nd,FF_with,GH_with,routes_without,timestamps_without,FF_without,GH_without):
 
    begin = time.time()
    overlaps = [[[[0 for x in range(len(bundles)+Nf)]for x in range(len(bundles)+Nf)] for x in range(Nf)] for x in range(Nf)]#for x in range(Ng)]
    #print('overlaps',overlaps)
    for i in range(Nf):
        for j in range(Nf):
            for k in range(len(bundles)+Nf):
                for l in range(len(bundles)+Nf):
                    if i!=j and k!=l:
                        #print('========================================')
                        #print('i,j,k,l',i,j,k,l)
                        if k>=len(bundles) and l>=len(bundles):
                            routes = routes_without[i] + routes_without[j]
                            routes_timeStamps = timestamps_without[i] + timestamps_without[j]
                            FFSequence = FF_without[i] + FF_without[j]
                            GHSequence = GH_without[i] + GH_without[j]
                        elif k>=len(bundles):
                            routes = routes_without[i] + routes_with[l][j]
                            routes_timeStamps = timestamps_without[i] + timestamps_with[l][j]
                            FFSequence = FF_without[i] + FF_with[l][j]
                            GHSequence = GH_without[i] + GH_with[l][j]
                        elif l>=len(bundles):
                            routes = routes_with[k][i] + routes_without[j]
                            routes_timeStamps = timestamps_with[k][i] + timestamps_without[j]
                            FFSequence = FF_with[k][i] + FF_without[j]
                            GHSequence = GH_with[k][i] + GH_without[j]
                        else:
                            routes = routes_with[k][i] + routes_with[l][j]
                            routes_timeStamps = timestamps_with[k][i] + timestamps_with[l][j]
                            FFSequence = FF_with[k][i] + FF_with[l][j]
                            GHSequence = GH_with[k][i] + GH_with[l][j]
                        #print('routes',routes)
                        #print('routes_timeStamps',routes_timeStamps)
                        #print('FFSequence',FFSequence)
                        #print('GHSequence',GHSequence)
                        dockCapacityViolation, arrDepGH, numberOfTrucksPerGH = alsn.dock_capacity_violation(routes,routes_timeStamps,FFSequence,GHSequence,Nf,Ng,Nd)
                        overlaps[i][j][k][l] = len(dockCapacityViolation)
                                
    print('overlaps',overlaps)

    end = time.time()
    #print('time',end-begin)

    set_of_ff = list(np.arange(0,Nf))
    amount_of_bundles = len(bundles) + Nf

    set_of_gh = list(np.arange(0,Ng))
    
    set_of_req = poolNodes
    amount_of_req = len(poolNodes)

    empty_bundles = [[] for x in range(Nf)]
    set_of_bundles = bundles + empty_bundles
    bundle_numbers = list(np.arange(0,amount_of_bundles))

    for i in range(Nf):
        marginal_profit.append([0 for x in range(Nf)])

    bids = marginal_profit
    
    Q = [[1 for x in range(Nf)] for y in range(amount_of_bundles)]
    W = [[0 for x in range(amount_of_req)] for y in range(amount_of_bundles)]

    for i in range(amount_of_bundles):
        for j in range(amount_of_req):
            for k in range(len(set_of_bundles[i])):
                #print('i,j,k',i,j,k)
                if set_of_bundles[i][k] == poolNodes[j]:
                    W[i][j] = 1

    #time how long it takes to generate the MILP
    start_time = time.time()

    #Generate the Variables
    prob =  pulp.LpProblem("Winner_determination", pulp.LpMaximize)
    v_bc = LpVariable.dicts("Bundle_to_carrier", [(b,c) for b in bundle_numbers for c in set_of_ff], 0, 1, LpBinary)

    #Objective
    prob += lpSum(bids[b][c]*v_bc[(b,c)] for b in bundle_numbers for c in set_of_ff)

    #Constraints
    for c in set_of_ff:
        prob += lpSum(v_bc[(b,c)] for b in bundle_numbers) == 1
    for b in bundle_numbers:
         prob += lpSum(v_bc[(b,c)] for c in set_of_ff) <=1
    for b in bundle_numbers:
         for c in set_of_ff:
             prob += v_bc[(b,c)] <= Q[b][c]
    #for g in set_of_gh:
    for b in bundle_numbers:
        for x in bundle_numbers:
            for c in set_of_ff:
                for y in set_of_ff:
                    if overlaps[c][y][b][x] >= 1:
                        prob += v_bc[(b,c)] + v_bc[(x,y)] <= 1

    for r in range(len(set_of_req)):
         prob += lpSum(v_bc[(b,c)]*W[b][r] for b in bundle_numbers for c in set_of_ff) == 1


    #end gen time start solve time      
    gen_time = time.time() - start_time
    start_time = time.time()

    print('prob',prob) 
    #Call the right solver
    #prob.solve(pulp.PULP_CBC_CMD(maxSeconds=300, msg=1))
    #prob.solve(solvers.CPLEX_CMD(timelimit=100))
    #prob.solve(solvers.CPLEX_CMD(options=["set mip tolerances mipgap 0.005"]))
    #prob.solve(solvers.GUROBI_CMD())
    prob.solve(solvers.CPLEX_CMD())

    #End solve time
    solve_time = time.time() - start_time


    #print the status and the objective
    print("Status:", LpStatus[prob.status])
    print("Objective = ", value(prob.objective))
    #print(v_bc)

    solution = []
    for b in bundle_numbers:
        for c in set_of_ff:
                if v_bc[(b,c)].varValue == 1:
                    solution.append([b,c])
    print("solution",solution)

    return solution, overlaps


def WDP_soft(Nf,bundles,marginal_profit,poolNodes,timestamps_with,routes_with,
             node_GH,Ng,sigma,keepNodesFF,Nd,FF_with,GH_with,routes_without,
             timestamps_without,FF_without,GH_without, constraints):
    print('constraints',constraints)
    begin = time.time()
    overlaps = [[[[0 for x in range(len(bundles)+Nf)]for x in range(len(bundles)+Nf)] for x in range(Nf)] for x in range(Nf)]#for x in range(Ng)]
    #print('overlaps',overlaps)
    for i in range(Nf):
        for j in range(Nf):
            for k in range(len(bundles)+Nf):
                for l in range(len(bundles)+Nf):
                    if i!=j and k!=l:
                        #print('========================================')
                        #print('i,j,k,l',i,j,k,l)
                        if k>=len(bundles) and l>=len(bundles):
                            routes = routes_without[i] + routes_without[j]
                            routes_timeStamps = timestamps_without[i] + timestamps_without[j]
                            FFSequence = FF_without[i] + FF_without[j]
                            GHSequence = GH_without[i] + GH_without[j]
                        elif k>=len(bundles):
                            routes = routes_without[i] + routes_with[l][j]
                            routes_timeStamps = timestamps_without[i] + timestamps_with[l][j]
                            FFSequence = FF_without[i] + FF_with[l][j]
                            GHSequence = GH_without[i] + GH_with[l][j]
                        elif l>=len(bundles):
                            routes = routes_with[k][i] + routes_without[j]
                            routes_timeStamps = timestamps_with[k][i] + timestamps_without[j]
                            FFSequence = FF_with[k][i] + FF_without[j]
                            GHSequence = GH_with[k][i] + GH_without[j]
                        else:
                            routes = routes_with[k][i] + routes_with[l][j]
                            routes_timeStamps = timestamps_with[k][i] + timestamps_with[l][j]
                            FFSequence = FF_with[k][i] + FF_with[l][j]
                            GHSequence = GH_with[k][i] + GH_with[l][j]
                        #print('routes',routes)
                        #print('routes_timeStamps',routes_timeStamps)
                        #print('FFSequence',FFSequence)
                        #print('GHSequence',GHSequence)
                        dockCapacityViolation, arrDepGH, numberOfTrucksPerGH = alsn.dock_capacity_violation(routes,routes_timeStamps,FFSequence,GHSequence,Nf,Ng,Nd)
                        overlaps[i][j][k][l] = len(dockCapacityViolation)
                                
    #print('overlaps',overlaps)
   

    end = time.time()
    #print('time',end-begin)


    set_of_ff = list(np.arange(0,Nf))
    amount_of_bundles = len(bundles) + Nf

    set_of_gh = list(np.arange(0,Ng))
    
    set_of_req = poolNodes
    amount_of_req = len(poolNodes)

    empty_bundles = [[] for x in range(Nf)]
    set_of_bundles = bundles + empty_bundles
    bundle_numbers = list(np.arange(0,amount_of_bundles))
    #print('set_of_bundles',set_of_bundles)
    
    for i in range(Nf):
        marginal_profit.append([0 for x in range(Nf)])
    bids = marginal_profit
    
    Q = [[1 for x in range(Nf)] for y in range(amount_of_bundles)]
    W = [[0 for x in range(amount_of_req)] for y in range(amount_of_bundles)]

    for i in range(amount_of_bundles):
        for j in range(amount_of_req):
            for k in range(len(set_of_bundles[i])):
                #print('i,j,k',i,j,k)
                if set_of_bundles[i][k] == poolNodes[j]:
                    W[i][j] = 1

    #time how long it takes to generate the MILP
    start_time = time.time()

    #Generate the Variables
    prob =  pulp.LpProblem("Winner_determination", pulp.LpMaximize)
    v_bc = LpVariable.dicts("Bundle_to_carrier", [(b,c) for b in bundle_numbers for c in set_of_ff], 0, 1, LpBinary)
    k = LpVariable.dicts("Overlap_compensation", [(b,x,c,y) for b in bundle_numbers for x in bundle_numbers for c in set_of_ff for y in set_of_ff], 0, 100)

    #Objective
    prob += lpSum(bids[b][c]*v_bc[(b,c)] for b in bundle_numbers for c in set_of_ff) - 10 * lpSum(k[(b,x,c,y)]for b in bundle_numbers for x in bundle_numbers for c in set_of_ff for y in set_of_ff)

    #Constraints
    for c in set_of_ff:
        prob += lpSum(v_bc[(b,c)] for b in bundle_numbers) == 1
    for b in bundle_numbers:
         prob += lpSum(v_bc[(b,c)] for c in set_of_ff) <=1
    for b in bundle_numbers:
         for c in set_of_ff:
             prob += v_bc[(b,c)] <= Q[b][c]
    #for g in set_of_gh:
    for b in bundle_numbers:
        for x in bundle_numbers:
            for c in set_of_ff:
                for y in set_of_ff:
                    if overlaps[c][y][b][x] >= 1:
                        prob += (v_bc[(b,c)] + v_bc[(x,y)]) * (overlaps[c][y][b][x]) - k[(b,x,c,y)] <= overlaps[c][y][b][x]  
    #prob += (v_bc[(0,0)] + v_bc[(1,2)])*2 - k[(0,1,0,2)] <= 2
    #prob += v_bc[(1,2)] + v_bc[(2,1)] <= 1
    for m in range(len(constraints)):
        prob += v_bc[(constraints[m][0],constraints[m][2])] + v_bc[(constraints[m][1],constraints[m][3])] <= 1
    
    for r in range(len(set_of_req)):
         prob += lpSum(v_bc[(b,c)]*W[b][r] for b in bundle_numbers for c in set_of_ff) == 1


    #end gen time start solve time      
    gen_time = time.time() - start_time
    start_time = time.time()

    print('prob',prob) 
    #Call the right solver
    #prob.solve(pulp.PULP_CBC_CMD(maxSeconds=300, msg=1))
    #prob.solve(solvers.CPLEX_CMD(timelimit=100))
    #prob.solve(solvers.CPLEX_CMD(options=["set mip tolerances mipgap 0.005"]))
    #prob.solve(solvers.GUROBI_CMD())
    prob.solve(solvers.CPLEX_CMD())

    #End solve time
    solve_time = time.time() - start_time


    #print the status and the objective
    print("Status:", LpStatus[prob.status])
    print("Objective = ", value(prob.objective))
    #print(v_bc)

    solution = []
    for b in bundle_numbers:
        for c in set_of_ff:
                if v_bc[(b,c)].varValue == 1:
                    solution.append([b,c])
    print("solution",solution)
    
    sol_k = []
    k_value = []
    for b in bundle_numbers:
        for x in bundle_numbers:
            for c in set_of_ff:
                for y in set_of_ff:
                    if k[(b,x,c,y)].varValue >= 1:
                        sol_k.append([b,x,c,y])
                        k_value.append(k[(b,x,c,y)].varValue)
    print("sol_k",sol_k)
    print('k_value',k_value)
    
    return solution, overlaps, sol_k
    


def WDP_no_cap(Nf,bundles,marginal_profit,poolNodes,timestamps_with,routes_with,node_GH,Ng,sigma,keepNodesFF):

    set_of_ff = list(np.arange(0,Nf))
    amount_of_bundles = len(bundles)

    set_of_gh = list(np.arange(0,Ng))
    
    set_of_req = poolNodes
    amount_of_req = len(poolNodes)
    
    set_of_bundles = bundles
    bundle_numbers = list(np.arange(0,amount_of_bundles))
    bids = marginal_profit

    Q = [[1 for x in range(Nf)] for y in range(amount_of_bundles)]
    W = [[0 for x in range(amount_of_req)] for y in range(amount_of_bundles)]

    for i in range(amount_of_bundles):
        for j in range(amount_of_req):
            for k in range(len(bundles[i])):
                if bundles[i][k] == poolNodes[j]:
                    W[i][j] = 1

    #time how long it takes to generate the MILP
    start_time = time.time()

    #Generate the Variables
    prob =  pulp.LpProblem("Winner_determination", pulp.LpMaximize)
    v_bc = LpVariable.dicts("Bundle_to_carrier", [(b,c) for b in bundle_numbers for c in set_of_ff], 0, 1, LpBinary)

    #Objective
    prob += lpSum(bids[b][c]*v_bc[(b,c)] for b in bundle_numbers for c in set_of_ff)

    #Constraints
    for c in set_of_ff:
        prob += lpSum(v_bc[(b,c)] for b in bundle_numbers) <= 1
    for b in bundle_numbers:
         prob += lpSum(v_bc[(b,c)] for c in set_of_ff) <=1
    for b in bundle_numbers:
         for c in set_of_ff:
             prob += v_bc[(b,c)] <= Q[b][c]
    for r in range(len(set_of_req)):
         prob += lpSum(v_bc[(b,c)]*W[b][r] for b in bundle_numbers for c in set_of_ff) == 1


    #end gen time start solve time      
    gen_time = time.time() - start_time
    start_time = time.time()

    print('prob',prob) 
    #Call the right solver
    #prob.solve(pulp.PULP_CBC_CMD(maxSeconds=300, msg=1))
    #prob.solve(solvers.CPLEX_CMD(timelimit=100))
    #prob.solve(solvers.CPLEX_CMD(options=["set mip tolerances mipgap 0.005"]))
    #prob.solve(solvers.GUROBI_CMD())
    prob.solve(solvers.CPLEX_CMD())

    #End solve time
    solve_time = time.time() - start_time


    #print the status and the objective
    print("Status:", LpStatus[prob.status])
    print("Objective = ", value(prob.objective))
    #print(v_bc)

    solution = []
    for b in bundle_numbers:
        for c in set_of_ff:
                if v_bc[(b,c)].varValue == 1:
                    solution.append([b,c])
    print("solution",solution)

    return solution


















