# -*- coding: utf-8 -*-
"""
Created on Tue May 07 23:02:51 2019

@author: abombelli

Adjusted by: S van Alebeek
"""

import numpy as np
import os
import openpyxl
import pandas as pd
import time
import operator
from copy import deepcopy
import random
from collections import OrderedDict
import itertools


def initialSolutionGreedy(updatedUnassignedShipments,
                       timeMatrix,elBoundsExport,processingTimeExport,maxRideTime,Nf,Ng,sigma,WeightE,
                       QTruck,exportPickupNodes,Nd,lTAll,distanceMatrix,
                       maxRideTimeTruck,wFF,wGH,wW,wTW,wDC,wL,lat_occupancy_shipments,L_trailer,node_rev):

    allShipmentsAssigned = 0
    initialSolution      = []
    cont                 = 0
    
    # Cycle until all shipments have been assigned
    while allShipmentsAssigned != 1:
        
        print('Building new route')
        
        # Build a new empty route (or better, a route that starts at the
        # origin depot and ends at the destination depot)
        thisRouteMod = [0,int(2*sigma+1)]
        exitCond     = 0
        
        # Keep building the route until there is at least a feasible 
        # insertion point 
        while exitCond != 1:
            
            potentialShipment   = []
            potentialRoutes     = []
            potentialRoutesCost = []
            # Cycling over all the remaining unassigned shipments
            for cont in range(0,len(updatedUnassignedShipments)):
                
                thisShipment             = updatedUnassignedShipments[cont]
                thisShipmentDeliverySide = updatedUnassignedShipments[cont]+sigma
                
                
                # First step: the route is empty and thus there is only one 
                # possibility to insert the current shipment
                if int(len(thisRouteMod)) == 2:
                    nPositions = 1
                    # Cycling over all the potential insertion locations
                    for j in range(0,nPositions):
                        if j == 0:
                            thisRouteWithAddedShipments = (thisRouteMod[0:j+1] + [thisShipment] +
                                                           thisRouteMod[1:int(len(thisRouteMod)-1)] +
                                                           [thisShipmentDeliverySide] + 
                                                           [thisRouteMod[len(thisRouteMod)-1]])
                        elif j == nPositions:
                            thisRouteWithAddedShipments = (thisRouteMod[0:j+1] + [thisShipment] +
                                                       [thisShipmentDeliverySide] +
                                                       thisRouteMod[int(len(thisRouteMod)/2):int(len(thisRouteMod)-1)])
                        else:
                            thisRouteWithAddedShipments = (thisRouteMod[0:j+1] + [thisShipment] +
                                                   thisRouteMod[j+1:len(thisRouteMod)-j-1] +
                                                   [thisShipmentDeliverySide] + 
                                                   thisRouteMod[len(thisRouteMod)-j-1:len(thisRouteMod)])
                        
                        feasThisRoute = computeRouteFeasibility(thisRouteWithAddedShipments,sigma,Nf,Ng,exportPickupNodes,WeightE,QTruck[0],timeMatrix,
                                                     elBoundsExport,processingTimeExport,maxRideTime,lat_occupancy_shipments,L_trailer)
                        
    
                        
                        if feasThisRoute[0] == 1:
                            
                            # Assembling full set of routes
                            fullSetofRoutes = []
                            for ii in range(0,len(initialSolution)):
                                fullSetofRoutes.append(initialSolution[ii])
                            fullSetofRoutes.append(thisRouteWithAddedShipments)
                            
                            depArrMatrix = []
                            for jj in range(0,len(fullSetofRoutes)):
                                
                                thisVarMatrix = cordeauLaporteProcedure(fullSetofRoutes[jj],
                                    timeMatrix,elBoundsExport,processingTimeExport,maxRideTime)
                                
                                depArrMatrix.append(thisVarMatrix)
                            
                            (isGHSequenceFeasible, isFFSequenceFeasible, 
             isSolutionWeightFeasible, isTWFeasible, isDCFeasible, isSolutionLengthFeasible,
             FFViolation, GHViolation, weightViolation, TWViolation, DCViolation, lengthViolation,
             SAnewsolution, timeStampsSAfeas,FFSequence,GHSequence) = checkFeasibilityNew(fullSetofRoutes,
                                                                              depArrMatrix,lTAll,Nf,Ng,sigma,WeightE,QTruck,
                                                                              exportPickupNodes,processingTimeExport,Nd,lat_occupancy_shipments,L_trailer)
                            
                            
            
                            (JThisAlt, allDistances, allTravelTimes, offLoadedShipments) = costSolutionNew(fullSetofRoutes,
                                                                                    depArrMatrix,distanceMatrix,sigma,
                                                                                    FFViolation,GHViolation,weightViolation,TWViolation,DCViolation,
                                                                                    wFF,wGH,wW,wTW,wDC,wL,lat_occupancy_shipments,L_trailer,lengthViolation,node_rev,sigmaS)
                            
                            potentialShipment.append(thisShipment)
                            potentialRoutes.append(thisRouteWithAddedShipments)
                            potentialRoutesCost.append(JThisAlt)
                
                # Otherwise, the number of possible insertion points is the 
                # current number of shipments in the route + 1
                else:
                
                    nShipmentsThisRouteMod = len(thisRouteMod[1:int(len(thisRouteMod)/2)])
                    nPositions             = nShipmentsThisRouteMod+1
                    # Cycling over all the potential insertion locations
                    for j in range(0,nPositions):
                        if j == 0:
                                thisRouteWithAddedShipments = (thisRouteMod[0:j+1] + [thisShipment] +
                                                           thisRouteMod[1:int(len(thisRouteMod)-1)] +
                                                           [thisShipmentDeliverySide] + 
                                                           [thisRouteMod[len(thisRouteMod)-1]])
                        elif j == nPositions:
                            thisRouteWithAddedShipments = (thisRouteMod[0:j+1] + [thisShipment] +
                                                       [thisShipmentDeliverySide] +
                                                       thisRouteMod[int(len(thisRouteMod)/2):int(len(thisRouteMod)-1)])
                        else:
                            thisRouteWithAddedShipments = (thisRouteMod[0:j+1] + [thisShipment] +
                                                   thisRouteMod[j+1:len(thisRouteMod)-j-1] +
                                                   [thisShipmentDeliverySide] + 
                                                   thisRouteMod[len(thisRouteMod)-j-1:len(thisRouteMod)])
                        
                        feasThisRoute = computeRouteFeasibility(thisRouteWithAddedShipments,sigma,Nf,Ng,exportPickupNodes,WeightE,QTruck[0],timeMatrix,
                                                     elBoundsExport,processingTimeExport,maxRideTime,lat_occupancy_shipments,L_trailer)
                        
    
                        
                        if feasThisRoute[0] == 1:
                            
                            # Assembling full set of routes
                            fullSetofRoutes = []
                            for ii in range(0,len(initialSolution)):
                                fullSetofRoutes.append(initialSolution[ii])
                            fullSetofRoutes.append(thisRouteWithAddedShipments)
                            
                            depArrMatrix = []
                            for jj in range(0,len(fullSetofRoutes)):
                                
                                thisVarMatrix = cordeauLaporteProcedure(fullSetofRoutes[jj],
                                    timeMatrix,elBoundsExport,processingTimeExport,maxRideTime)
                                
                                depArrMatrix.append(thisVarMatrix)
                            
                            (isGHSequenceFeasible, isFFSequenceFeasible, 
             isSolutionWeightFeasible, isTWFeasible, isDCFeasible, isSolutionLengthFeasible,
             FFViolation, GHViolation, weightViolation, TWViolation, DCViolation, lengthViolation,
             SAnewsolution, timeStampsSAfeas,FFSequence,GHSequence) = checkFeasibilityNew(fullSetofRoutes,
                                                                              depArrMatrix,lTAll,Nf,Ng,sigma,WeightE,QTruck,
                                                                              exportPickupNodes,processingTimeExport,Nd,lat_occupancy_shipments,L_trailer)
                            
                            
            
                            (JThisAlt, allDistances, allTravelTimes, offLoadedShipments) = costSolutionNew(fullSetofRoutes,
                                                                                    depArrMatrix,distanceMatrix,sigma,
                                                                                    FFViolation,GHViolation,weightViolation,TWViolation,DCViolation,
                                                                                    wFF,wGH,wW,wTW,wDC,wL,lat_occupancy_shipments,L_trailer,lengthViolation,node_rev,sigmaS)
                            
                            potentialShipment.append(thisShipment)
                            potentialRoutes.append(thisRouteWithAddedShipments)
                            potentialRoutesCost.append(JThisAlt)
            
        
            if len(potentialRoutes) == 0:
                
                exitCond = 1
                initialSolution.append(thisRouteMod)

                
            else:
                idxBestRoute = np.argsort(np.array(potentialRoutesCost))[0]
                thisShipment = potentialShipment[int(idxBestRoute)]
                
                # Remove assigned shipment from list of unassigned shipments
                idxThisShipment = np.where(np.array(updatedUnassignedShipments)==thisShipment)[0][0]
                updatedUnassignedShipments.pop(idxThisShipment)
                
                # Update newly created route
                #thisRouteMod = deepcopy(potentialRoutes[int(idxBestRoute)])
                thisRouteMod = potentialRoutes[int(idxBestRoute)]
                
                #print(thisRouteMod) 
                
            if int(len(updatedUnassignedShipments)) == 0:
                allShipmentsAssigned = 1
                
            cont +=1
                
    return initialSolution



























################################################
def dockCapacityv2(SAnewsolution,routesArrDepmatrix,FFSequence,GHSequence,
                 Nf,Ng,Nd):
    #calculate the dock capacity constraint    
    arrDepGH         = []
    trucksVisitsToGH = [[] for i in range(0,Ng)]
        
    for i in range(0,len(SAnewsolution)):
        thisArrDepGH            = []
        thisSAsolution          = SAnewsolution[i]
        thisGHSequence          = GHSequence[i]
        timeStampsThisRouteHeur = routesArrDepmatrix[i]
        for idxGH in range(0,Ng):
            idxDelThisGh = np.where(np.array(thisGHSequence)==idxGH)[0]
            if len(idxDelThisGh) != 0:
                firstIdx        = idxDelThisGh[0]
                lastIdx         = idxDelThisGh[-1]
                arrivalThisGH   = timeStampsThisRouteHeur[int(len(thisSAsolution)/2+firstIdx),2]
                departureThisGH = timeStampsThisRouteHeur[int(len(thisSAsolution)/2+lastIdx),3]
                firstNode       = thisSAsolution[int(len(thisSAsolution)/2+firstIdx)]
                lastNode        = thisSAsolution[int(len(thisSAsolution)/2+lastIdx)]
                thisArrDepGH.append([arrivalThisGH,departureThisGH,firstNode,lastNode])
                trucksVisitsToGH[idxGH].append(i)
            else:
                thisArrDepGH.append([0,0])
        arrDepGH.append(thisArrDepGH)
        
    timeIntervalsPerGH  = [[] for i in range(0,Ng)]
    numberOfTrucksPerGH = [[] for i in range(0,Ng)]
    IDOfTrucksPerGH     = [[] for i in range(0,Ng)]
    
    for i in range(0,Ng):
        trucksVisitsThisGH   = trucksVisitsToGH[i]
        timeStampsThisGH     = []
        numberOfTrucksThisGH = []
        IDOfTrucksThisGH     = []
        
        for j in range(0,len(trucksVisitsThisGH)):
            timeStampsThisGH.append(arrDepGH[trucksVisitsThisGH[j]][i][0])
            timeStampsThisGH.append(arrDepGH[trucksVisitsThisGH[j]][i][1])
        timeStampsThisGH = np.unique(timeStampsThisGH).tolist()
        timeIntervalsPerGH[i] = timeStampsThisGH
        
        numberOfTrucksThisGH = []
        IDOfTrucksThisGH     = []
        
        for j in range(0,len(timeStampsThisGH)-1):
            lbThisTimeInterval = timeStampsThisGH[j]
            ubThisTimeInterval = timeStampsThisGH[j+1]
            
            numberOfTrucksThisInterval = 0
            IDTrucksThisInterval       = []
            
            for k in range(0,len(trucksVisitsThisGH)):
                if (arrDepGH[trucksVisitsThisGH[k]][i][0] <= lbThisTimeInterval and
                    arrDepGH[trucksVisitsThisGH[k]][i][1] >= ubThisTimeInterval):
                    
                    numberOfTrucksThisInterval += 1
                    IDTrucksThisInterval.append(trucksVisitsThisGH[k])
                        
            numberOfTrucksThisGH.append(numberOfTrucksThisInterval)
            IDOfTrucksThisGH.append(IDTrucksThisInterval)
            
        numberOfTrucksPerGH[i] = numberOfTrucksThisGH
        IDOfTrucksPerGH[i]     = IDOfTrucksThisGH        
        dockCapacityViolation = []
     
    for i in range(0,Ng):
        for j in range(0,len(numberOfTrucksPerGH[i])):
            if numberOfTrucksPerGH[i][j]>Nd[i]:
                timeInterval        = [timeIntervalsPerGH[i][j],timeIntervalsPerGH[i][j+1]]
                trucksInvolved      = IDOfTrucksPerGH[i][j]
                GHCapacityViolation = i
                dockCapacityViolation.append([timeInterval,trucksInvolved,GHCapacityViolation])
    
    startTimeDockCapViol = []
    for i in range(0,len(dockCapacityViolation)):
        startTimeDockCapViol.append(dockCapacityViolation[i][0][0])

    return dockCapacityViolation, arrDepGH, numberOfTrucksPerGH

################################################

def routeCharacteristics(r,timeMatrix,elMatrix,processingTime,maxRideTime):
    
    # Five columns are A, W, B, D, P
    varMatrix = np.zeros([len(r),5])
    varMatrix[0][0] = 0
    varMatrix[0][1] = 0
    varMatrix[0][2] = elMatrix[0][0]
    varMatrix[0][3] = elMatrix[0][0]
    varMatrix[0][4] = 0
    for i in range(1,len(r)):
        thisNode        = int(r[i])
        varMatrix[i][0] = varMatrix[i-1][3]+timeMatrix[r[i-1],thisNode]
        varMatrix[i][1] = np.max([elMatrix[thisNode][0]-varMatrix[i][0],0])
        varMatrix[i][2] = varMatrix[i][0]+varMatrix[i][1]
        varMatrix[i][3] = varMatrix[i][2]+processingTime[thisNode]
        varMatrix[i][4] = maxRideTime[thisNode] 
        
    return varMatrix

def checkFeasibilityNew(SAnewsolution,timeMatrix,lTAll,Nf,Ng,sigma,WeightE,QTruck,
               exportPickupNodes,processingTimeExport,Nd,lat_occupancy_shipments,L_trailer):
    
    # Determine feasibility of FF sequence
    FFSequence = []
    for i in range(0,len(SAnewsolution)):
        thisFFSequence=[]
        for idxPickup in range(1,int(len(SAnewsolution[i])/2)+1):
            for idxFF in range(0,Nf):
                for idxGH in range(0,Ng):
                    if SAnewsolution[i][idxPickup] in exportPickupNodes[idxFF][idxGH]:
                        thisFFSequence.append(idxFF)                            
        FFSequence.append(thisFFSequence)

    isFFSequenceFeasible = 1
    FFViolation          = 0
    for i in range(0,len(FFSequence)):
        thisFFSequence = FFSequence[i]
        for idxFF in range(0,Nf):
            idxPickupThisFF = np.where(np.array(thisFFSequence)==idxFF)[0] 
            diff         = []
            for zz in range(0,len(idxPickupThisFF)-1):
                diff.append(idxPickupThisFF[zz+1]-idxPickupThisFF[zz])
            if len(np.where(np.array(diff)!=1)[0]) != 0:
                isFFSequenceFeasible = 0
                FFViolation          = 5000
                break

    # Determine feasibility of GH sequence
    GHSequence = []
    for i in range(0,len(SAnewsolution)):
        thisGHSequence = []
        for idxDel in range(int((len(SAnewsolution[i])/2)),int(len(SAnewsolution[i]))):
            for idxFF in range(0,Nf):
                for idxGH in range(0,Ng):
                    if SAnewsolution[i][idxDel]-sigma in exportPickupNodes[idxFF][idxGH]:
                        thisGHSequence.append(idxGH)
        GHSequence.append(thisGHSequence)    

    isGHSequenceFeasible = 1
    GHViolation          = 0
    for i in range(0,len(GHSequence)):        
        thisGHSequence = GHSequence[i]
        for idxGH in range(0,Ng):
            idxDelThisGh = np.where(np.array(thisGHSequence)==idxGH)[0]
            diff         = []
            for zz in range(0,len(idxDelThisGh)-1):
                diff.append(idxDelThisGh[zz+1]-idxDelThisGh[zz])                
            if len(np.where(np.array(diff)!=1)[0]) != 0:
                isGHSequenceFeasible = 0
                GHViolation          = 5000
                break

    
    # Check maximum weight of each route
    isSolutionWeightFeasible = 1 
    weightViolation          = 0
    for i in range(0,len(SAnewsolution)):
        weightThisRoute      = 0
        pickupNodesThisRoute = SAnewsolution[i][1:int(len(SAnewsolution[i])/2)]
        for j in range(0,len(pickupNodesThisRoute)):
            weightThisRoute += WeightE[pickupNodesThisRoute[j]-1]
        if weightThisRoute > QTruck[0]:
            isSolutionWeightFeasible = 0
            weightViolation          += weightThisRoute - QTruck[0]
    
    # Check if trailer overall length is exceeded
    isSolutionLengthFeasible = 1 
    lengthViolation          = 0
    for i in range(0,len(SAnewsolution)):
        lengthThisRoute      = 0
        pickupNodesThisRoute = SAnewsolution[i][1:int(len(SAnewsolution[i])/2)]
        for j in range(0,len(pickupNodesThisRoute)):
            lengthThisRoute += lat_occupancy_shipments[pickupNodesThisRoute[j]-1]
        if lengthThisRoute > L_trailer:
            isSolutionWeightFeasible = 0
            lengthViolation          += lengthThisRoute - L_trailer
        
    # Check route feasibility    
    timeStampsSAfeas =[]    
    for i in range (0,len(SAnewsolution)):
        
        arrivalTimeSAfeas         = []
        departureTimeSAfeas       = []
        for j in range (0,len(SAnewsolution[i])):
            
            
            
            thisArrivalTime   = timeMatrix[i][j,2]
            thisDepartureTime = timeMatrix[i][j,3]
            arrivalTimeSAfeas.append(thisArrivalTime)
            departureTimeSAfeas.append(thisDepartureTime)
    
        timeStampsSAfeas.append([arrivalTimeSAfeas,departureTimeSAfeas])
    
    routesFeasTW = []
    TWViolation  = 0
    # Cycle over different routes
    for i in range(0,len(timeStampsSAfeas)):        
        feasSAnewsolution = []
        arrivalTimeSAfeas = timeStampsSAfeas[i][0]
        for j in range(0,len(arrivalTimeSAfeas)):
            if arrivalTimeSAfeas[j]>lTAll[SAnewsolution[i][j]]:
                feasSAnewsolution.append(0)
                TWViolation += arrivalTimeSAfeas[j]-lTAll[SAnewsolution[i][j]]
            else:
                feasSAnewsolution.append(1) 
        # If in the current route all time windows are satisfied, the 
        # associated element in the routesFeasTW vector is set equal to 1
        if len(np.where(np.array(feasSAnewsolution)==0)[0]) == 0:
            routesFeasTW.append(1)
        else:
            routesFeasTW.append(0)
    
    isTWFeasible = 0
    if len(np.where(np.array(routesFeasTW)==0)[0]) == 0: 
        isTWFeasible = 1
        
    # Check dock capacity feasibility 
    isDCFeasible     = 1
    arrDepGH         = []
    trucksVisitsToGH = [[] for i in range(0,Ng)]
        
    for i in range(0,len(SAnewsolution)):
        thisArrDepGH            = []
        thisSAsolution          = SAnewsolution[i]
        thisGHSequence          = GHSequence[i]
        timeStampsThisRouteHeur = timeStampsSAfeas[i]
        for idxGH in range(0,Ng):
            idxDelThisGh = np.where(np.array(thisGHSequence)==idxGH)[0]
            if len(idxDelThisGh) != 0:
                firstIdx        = idxDelThisGh[0]
                lastIdx         = idxDelThisGh[-1]
                arrivalThisGH   = timeStampsThisRouteHeur[0][int(len(thisSAsolution)/2+firstIdx)]
                departureThisGH = timeStampsThisRouteHeur[1][int(len(thisSAsolution)/2+lastIdx)]
                thisArrDepGH.append([arrivalThisGH,departureThisGH])
                trucksVisitsToGH[idxGH].append(i)
            else:
                thisArrDepGH.append([0,0])
        arrDepGH.append(thisArrDepGH)
        
    timeIntervalsPerGH  = [[] for i in range(0,Ng)]
    numberOfTrucksPerGH = [[] for i in range(0,Ng)]
    IDOfTrucksPerGH     = [[] for i in range(0,Ng)]
    
    for i in range(0,Ng):
        trucksVisitsThisGH   = trucksVisitsToGH[i]
        timeStampsThisGH     = []
        numberOfTrucksThisGH = []
        IDOfTrucksThisGH     = []
        
        for j in range(0,len(trucksVisitsThisGH)):
            timeStampsThisGH.append(arrDepGH[trucksVisitsThisGH[j]][i][0])
            timeStampsThisGH.append(arrDepGH[trucksVisitsThisGH[j]][i][1])
        timeStampsThisGH = np.unique(timeStampsThisGH).tolist()
        timeIntervalsPerGH[i] = timeStampsThisGH
        
        numberOfTrucksThisGH = []
        IDOfTrucksThisGH     = []
        
        for j in range(0,len(timeStampsThisGH)-1):
            lbThisTimeInterval = timeStampsThisGH[j]
            ubThisTimeInterval = timeStampsThisGH[j+1]
            
            numberOfTrucksThisInterval = 0
            IDTrucksThisInterval       = []
            
            for k in range(0,len(trucksVisitsThisGH)):
                if (arrDepGH[trucksVisitsThisGH[k]][i][0] <= lbThisTimeInterval and
                    arrDepGH[trucksVisitsThisGH[k]][i][1] >= ubThisTimeInterval):
                    
                    numberOfTrucksThisInterval += 1
                    IDTrucksThisInterval.append(trucksVisitsThisGH[k])
                        
            numberOfTrucksThisGH.append(numberOfTrucksThisInterval)
            IDOfTrucksThisGH.append(IDTrucksThisInterval)
            
        numberOfTrucksPerGH[i] = numberOfTrucksThisGH
        IDOfTrucksPerGH[i]     = IDOfTrucksThisGH        
        dockCapacityViolation = []
     
    for i in range(0,Ng):
        for j in range(0,len(numberOfTrucksPerGH[i])):
            if numberOfTrucksPerGH[i][j]>Nd[i]:
                timeInterval        = [timeIntervalsPerGH[i][j],timeIntervalsPerGH[i][j+1]]
                trucksInvolved      = IDOfTrucksPerGH[i][j]
                GHCapacityViolation = i
                dockCapacityViolation.append([timeInterval,trucksInvolved,GHCapacityViolation])
    
    
    DCViolation          = 0
    
    if len(dockCapacityViolation) != 0:
        isDCFeasible = 0
        for i in range(0,len(dockCapacityViolation)):
            DCViolation += dockCapacityViolation[i][0][1]-dockCapacityViolation[i][0][0]
            
    
    return  (isGHSequenceFeasible, isFFSequenceFeasible, 
             isSolutionWeightFeasible, isTWFeasible, isDCFeasible, isSolutionLengthFeasible,
             FFViolation, GHViolation, weightViolation, TWViolation, DCViolation, lengthViolation,
             SAnewsolution, timeStampsSAfeas,FFSequence,GHSequence)

###############################################        

def LuDessoukySlack(route,timeMatrix,earlyTime,lateTime):
    YVec = []
    for i in range(0,len(route)):
        thisNode = route[len(route)-1-i]
        if i == 0:
            thisY = lateTime[thisNode]-np.max([timeMatrix[len(route)-1-i][0],earlyTime[thisNode]])
        else:
            thisY = np.min([lateTime[thisNode]-np.max([timeMatrix[len(route)-1-i][0],earlyTime[thisNode]]),
                            YVec[i-1]+timeMatrix[len(route)-i][1]])
        YVec.append(thisY)   
        
    YVec = np.flipud(np.array(YVec))
    
    slack = []
    for i in range(0,len(route)):
        #slack.append(YVec[i]+timeMatrix[i][1])
        slack.append(YVec[i])
        
        
    return slack

def computeRouteFeasibility(r,sigma,Nf,Ng,exportPickupNodes,weightShipments,QTruck,timeMatrix,
                                         elMatrix,processingTime,maxRideTime,lat_occupancy_shipments,
                                         L_trailer):
    # Determine feasibility of FF sequence
    thisFFSequence=[]
    for idxPickup in range(1,int(len(r)/2)+1):
        for idxFF in range(0,Nf):
            for idxGH in range(0,Ng):
                if r[idxPickup] in exportPickupNodes[idxFF][idxGH]:
                    thisFFSequence.append(idxFF)                            


    isFFSequenceFeasible = 1
    for idxFF in range(0,Nf):
        idxPickupThisFF = np.where(np.array(thisFFSequence)==idxFF)[0] 
        diff            = []
        for zz in range(0,len(idxPickupThisFF)-1):
            diff.append(idxPickupThisFF[zz+1]-idxPickupThisFF[zz])
        if len(np.where(np.array(diff)!=1)[0]) != 0:
            isFFSequenceFeasible = 0
            break

    # Determine feasibility of GH sequence
    thisGHSequence = []
    for idxDel in range(int((len(r)/2)),int(len(r))):
        for idxFF in range(0,Nf):
            for idxGH in range(0,Ng):
                if r[idxDel]-sigma in exportPickupNodes[idxFF][idxGH]:
                    thisGHSequence.append(idxGH)  

    isGHSequenceFeasible = 1
    for idxGH in range(0,Ng):
        idxDelThisGh = np.where(np.array(thisGHSequence)==idxGH)[0]
        diff         = []
        for zz in range(0,len(idxDelThisGh)-1):
            diff.append(idxDelThisGh[zz+1]-idxDelThisGh[zz])                
        if len(np.where(np.array(diff)!=1)[0]) != 0:
            isGHSequenceFeasible = 0
            break
    
    # Check maximum weight of each route
    isSolutionWeightFeasible = 1 
    weightThisRoute      = 0
    pickupNodesThisRoute = r[1:int(len(r)/2)]
    for jj in range(0,len(pickupNodesThisRoute)):
        weightThisRoute += weightShipments[pickupNodesThisRoute[jj]-1]
    if weightThisRoute > QTruck:
        isSolutionWeightFeasible = 0
        
    # Check maximum length of shipments in trailer for each route
    isSolutionLengthFeasible = 1 
    lengthThisRoute      = 0
    pickupNodesThisRoute = r[1:int(len(r)/2)]
    for jj in range(0,len(pickupNodesThisRoute)):
        lengthThisRoute += lat_occupancy_shipments[pickupNodesThisRoute[jj]-1]
    if lengthThisRoute > L_trailer:
        isSolutionLengthFeasible = 0
        
    

    
    timeStampsMatrix = routeCharacteristics(r,timeMatrix,
                                         elMatrix,processingTime,maxRideTime)
    isTWFeasible = 1
    for j in range(0,len(r)):
        if timeStampsMatrix[j][2]>elMatrix[r[j]][1]:
            isTWFeasible = 0
            break
    
    slack = computeForwardSlack3(r,
                         timeStampsMatrix,elMatrix,
                         processingTime,maxRideTime)
    
    if (isFFSequenceFeasible*isGHSequenceFeasible*
                isSolutionWeightFeasible*isTWFeasible*isSolutionLengthFeasible) == 1:
        thisRouteFeas = 1
    else:
        thisRouteFeas = 0
        
    return [thisRouteFeas,slack]

def computeFFGH(allRoutes,sigma,Nf,Ng,exportPickupNodes):
    
    allFF = []
    allGH = []
    
    for i in range(0,len(allRoutes)):
        
        r = allRoutes[i]
    
        thisFFSequence=[]
        for idxPickup in range(1,int(len(r)/2)+1):
            for idxFF in range(0,Nf):
                for idxGH in range(0,Ng):
                    if r[idxPickup] in exportPickupNodes[idxFF][idxGH]:
                        thisFFSequence.append(idxFF)   
        thisGHSequence = []
        for idxDel in range(int((len(r)/2)),int(len(r))):
            for idxFF in range(0,Nf):
                for idxGH in range(0,Ng):
                    if r[idxDel]-sigma in exportPickupNodes[idxFF][idxGH]:
                        thisGHSequence.append(idxGH)
                        
        allFF.append(thisFFSequence)
        allGH.append(thisGHSequence)
        
    return [allFF, allGH]

def computeForwardSlack3(r,varMatrix,elMatrix,processingTime,maxRideTime):
    forwardSlackVector = []
    for i in range(0,len(r)):
        Fivec    = []
        for j in range(i,len(r)):
           thisNode = int(r[j])
           if j<len(r)/2:
               if j==i:
                   thisFi = (np.max([0,np.min([elMatrix[thisNode][1]
                   -varMatrix[j][2],maxRideTime[thisNode]])]))
               else:
                   thisFi = (np.sum(varMatrix[i+1:j+1,1])+np.max([0,np.min([elMatrix[thisNode][1]
                   -varMatrix[j][2],maxRideTime[thisNode]])]))
           else:
               if j==i:
                   thisFi = (np.max([0,np.min([elMatrix[thisNode][1]-varMatrix[j][2],maxRideTime[thisNode]-(varMatrix[j][3]-varMatrix[len(r)-j-1][2])])]))
               else:
                   thisFi = (np.sum(varMatrix[i+1:j+1,1])+
                             np.max([0,np.min([elMatrix[thisNode][1]-varMatrix[j][2],
                             maxRideTime[thisNode]-(varMatrix[j][3]-varMatrix[len(r)-j-1][2])])]))

           Fivec.append(thisFi)
        forwardSlackVector.append(np.min(np.array(Fivec)))
        
    return forwardSlackVector

###############################################################################
# The checkInitialFeasibility function assesses whether a new solution is 
# feasible with respect to
# (1) FF and GH sequence
# (2) weight capacity
# (3) TW-optimal time-stamps (i.e., visiting each node as soon as possible
#   even if this is non-optimal for route duration)    
# In fact, if the new solution does not satisfy these requirements, nothing can 
# be done to improve the quality of the solution. We can consider the
# aforementioned constraints are "hard-constraints" in the sense that they 
# define a binary check: the new solution is either feasible or infeasible.
# On the other hand, a candidate solution that satisfies (1), (2), (3),
# can be feasible or infeasible w.r.t. TW and dock capacity violations
# depending on how routes are temporally shifted to resolve dock capacity
# violations      
def checkInitialFeasibility(SAnewsolution,timeMatrix,Nf,Ng,sigma,WeightE,QTruck,
               exportPickupNodes,processingTimeExport,elMatrix,maxRideTime):
    
    # Determine feasibility of FF sequence
    FFSequence = []
    for i in range(0,len(SAnewsolution)):
        thisFFSequence=[]
        for idxPickup in range(1,int(len(SAnewsolution[i])/2)+1):
            for idxFF in range(0,Nf):
                for idxGH in range(0,Ng):
                    if SAnewsolution[i][idxPickup] in exportPickupNodes[idxFF][idxGH]:
                        thisFFSequence.append(idxFF)                            
        FFSequence.append(thisFFSequence)

    isFFSequenceFeasible = 1
    for i in range(0,len(FFSequence)):
        thisFFSequence = FFSequence[i]
        for idxFF in range(0,Nf):
            idxPickupThisFF = np.where(np.array(thisFFSequence)==idxFF)[0] 
            diff         = []
            for zz in range(0,len(idxPickupThisFF)-1):
                diff.append(idxPickupThisFF[zz+1]-idxPickupThisFF[zz])
            if len(np.where(np.array(diff)!=1)[0]) != 0:
                isFFSequenceFeasible = 0
                break

    # Determine feasibility of GH sequence
    GHSequence = []
    for i in range(0,len(SAnewsolution)):
        thisGHSequence = []
        for idxDel in range(int((len(SAnewsolution[i])/2)),int(len(SAnewsolution[i]))):
            for idxFF in range(0,Nf):
                for idxGH in range(0,Ng):
                    if SAnewsolution[i][idxDel]-sigma in exportPickupNodes[idxFF][idxGH]:
                        thisGHSequence.append(idxGH)
        GHSequence.append(thisGHSequence)    

    isGHSequenceFeasible = 1
    for i in range(0,len(GHSequence)):        
        thisGHSequence = GHSequence[i]
        for idxGH in range(0,Ng):
            idxDelThisGh = np.where(np.array(thisGHSequence)==idxGH)[0]
            diff         = []
            for zz in range(0,len(idxDelThisGh)-1):
                diff.append(idxDelThisGh[zz+1]-idxDelThisGh[zz])                
            if len(np.where(np.array(diff)!=1)[0]) != 0:
                isGHSequenceFeasible = 0
                break

    # Check maximum weight of each route
    isSolutionWeightFeasible = 1 
    for i in range(0,len(SAnewsolution)):
        weightThisRoute      = 0
        pickupNodesThisRoute = SAnewsolution[i][1:int(len(SAnewsolution[i])/2)]
        for j in range(0,len(pickupNodesThisRoute)):
            weightThisRoute += WeightE[pickupNodesThisRoute[j]-1]
        if weightThisRoute > QTruck[0]:
            isSolutionWeightFeasible = 0
            
    # Check route feasibility    
    optimalTWMatrix =[]    
    for i in range (0,len(SAnewsolution)):
        optimalTWMatrix.append(routeCharacteristics(SAnewsolution[i],timeMatrix,elMatrix,processingTimeExport,maxRideTime))

    isSolutionOptimalTWFeasible = 1 
    # Cycle over different routes
    for i in range(0,len(optimalTWMatrix)):        
        for j in range(0,len(optimalTWMatrix[i][:,2])):
            if optimalTWMatrix[i][j,2]>elMatrix[SAnewsolution[i][j]][1]:
                isSolutionOptimalTWFeasible = 0
                break

    isFeasible = isFFSequenceFeasible*isGHSequenceFeasible*isSolutionWeightFeasible*isSolutionOptimalTWFeasible
   
            
    
    return isFeasible

###############################################
    
def costSolutionNew(SAnewsolution,timeStampsSAfeas,distanceMatrix,sigma,
                 FFViolation,GHViolation,weightViolation,TWViolation,DCViolation,
                 wFF,wGH,wW,wTW,wDC,wL,lat_occupancy_shipments,L_trailer,lengthViolation,node_rev,sigmaS):
    
    alpha              = 50
    costPerKm          = 1.69/1.60934*0.9 # [Euro/km]
    costPerMin         = 58/60*0.9        # [Euro/min] 
    totalDistance      = 0
    totalTime          = 0
    loadedShipments    = 0
    offLoadedShipments = 0
    allDistances       = []
    allTravelTimes     = []
    beta               = 1
    gamma              = 0.1


    allRoutesRev = 0
    for i in range(0,len(SAnewsolution)):
        thisRoute                = SAnewsolution[i]
        loadedShipmentsThisRoute = len(thisRoute[1:int(len(thisRoute)/2)])
        distanceThisRoute        = 0
        for j in range(0,len(thisRoute)-1):
            distanceThisRoute += distanceMatrix[thisRoute[j]][thisRoute[j+1]]
        timeThisRoute   = timeStampsSAfeas[i][len(timeStampsSAfeas[i])-1,3]-timeStampsSAfeas[i][0,3]
        totalDistance   += distanceThisRoute
        totalTime       += timeThisRoute
        loadedShipments += loadedShipmentsThisRoute
        allDistances.append(distanceThisRoute)
        allTravelTimes.append(timeThisRoute)
        
   # Revenue added by Sanne
        #print('node_rev',node_rev)
        #print('thisRoute', thisRoute)
        routeRev = 0
        for k in range(1,int(len(thisRoute)/2)):
            #print('k',k)
            #print('thisRoute[k]', thisRoute[k])
            routeRev += node_rev[thisRoute[k]-1][0]
            #print('rev',node_rev[thisRoute[k]-1][0])
        allRoutesRev += routeRev
        
    offLoadedShipments = sigmaS-loadedShipments

    #-routerev added by Sanne
    J = (alpha*offLoadedShipments+beta*costPerKm*totalDistance+gamma*costPerMin*totalTime+
         wFF*FFViolation+wGH*GHViolation+wW*weightViolation+wTW*TWViolation+
         wDC*DCViolation+wL*lengthViolation-allRoutesRev)
    
    return J, allDistances, allTravelTimes, offLoadedShipments

def randomRemoval(allRoutesHeuristics,q):
    
    routesModified   = deepcopy(allRoutesHeuristics)
    nRoutes          = len(routesModified)
    removedShipments = []
    
    cont         = 0
    max_len_flag = 0
    while cont < q and max_len_flag == 0:
        
        # Pick route where to eliminate a shipment
        routeIdxSelected           = random.randint(0,nRoutes-1)
        
        # We want the length of the route to be at least 6, which means that at 
        # least 2 shipments are present. We do not want to select a route
        # with a single shipment, because otherwise we would create an empty route
        if int(len(routesModified[routeIdxSelected])) > 6:
            # Determine how many shipments are there in current route
            nShipmentsRouteSelected = int(len(routesModified[routeIdxSelected][1:
                                      int(len(routesModified[routeIdxSelected])/2)]))
            shipmentIdxSelected     = random.randint(1,nShipmentsRouteSelected)
            thisShipment            = routesModified[routeIdxSelected][shipmentIdxSelected]
            
            # First shipment in the route
            if shipmentIdxSelected == 1: 
                routesModified[routeIdxSelected] = ([routesModified[routeIdxSelected][0]] +
                                               routesModified[routeIdxSelected][2:int(len(routesModified[routeIdxSelected]))-2] +
                                               [routesModified[routeIdxSelected][int(len(routesModified[routeIdxSelected]))-1]]) 
            # Last shipment in the route
            elif shipmentIdxSelected == nShipmentsRouteSelected:
                routesModified[routeIdxSelected] = (routesModified[routeIdxSelected][0:int(len(routesModified[routeIdxSelected])/2)-1]+
                                                    routesModified[routeIdxSelected][int(len(routesModified[routeIdxSelected])/2)+1:int(len(routesModified[routeIdxSelected]))])
            # Shipment is in an intermediate position
            else:
                routesModified[routeIdxSelected] = (routesModified[routeIdxSelected][0:shipmentIdxSelected]+
                                                    routesModified[routeIdxSelected][shipmentIdxSelected+1:int(len(routesModified[routeIdxSelected]))-1-shipmentIdxSelected]+
                                                    routesModified[routeIdxSelected][int(len(routesModified[routeIdxSelected]))-shipmentIdxSelected:int(len(routesModified[routeIdxSelected]))])
            

            removedShipments.append(thisShipment)
            cont += 1
        
        max_len_route = 0
        for i in range(0,int(len(routesModified))):
            if int(len(routesModified[i])) > max_len_route:
                max_len_route = int(len(routesModified[i]))
        if max_len_route <= 6:
            max_len_flag = 1
    
    return routesModified,removedShipments

def worstRemoval(allRoutesHeuristics,q,timeMatrix,elBoundsExport,
                 processingTimeExport,maxRideTime,Nf,Ng,sigma,WeightE,
                 QTruck,exportPickupNodes,Nd,lTAll,distanceMatrix,
                 wFF,wGH,wW,wTW,wDC,wL,lat_occupancy_shipments,L_trailer,node_rev,sigmaS):
    
    # Compute cost function of current best solution
    routesArrDepMatrixInit = []
    for ii in range(0,len(allRoutesHeuristics)):
        routesArrDepMatrixInit.append(routeCharacteristics(allRoutesHeuristics[ii],
                                              timeMatrix,elBoundsExport,processingTimeExport,maxRideTime))
    
    (isGHSequenceFeasible, isFFSequenceFeasible, 
             isSolutionWeightFeasible, isTWFeasible, isDCFeasible, isSolutionLengthFeasible,
             FFViolation, GHViolation, weightViolation, TWViolation, DCViolation, lengthViolation,
             SAnewsolution, timeStampsSAfeas,FFSequence,GHSequence) = checkFeasibilityNew(
                     allRoutesHeuristics,routesArrDepMatrixInit,lTAll,Nf,Ng,sigma,WeightE,QTruck,
             exportPickupNodes,processingTimeExport,Nd,lat_occupancy_shipments,L_trailer)
            
    (J, allDistances, allTravelTimes, offLoadedShipments) = costSolutionNew(allRoutesHeuristics,
                      routesArrDepMatrixInit,distanceMatrix,sigma,
                      FFViolation,GHViolation,weightViolation,TWViolation,DCViolation,
                      wFF,wGH,wW,wTW,wDC,wL,lat_occupancy_shipments,L_trailer,lengthViolation,node_rev,sigmaS)
    
    
    routeIdx         = []
    shipmentRemoved  = []
    cost             = []
    
    for i in range(0,int(len(allRoutesHeuristics))):
        
        nShipmentsRouteSelected = len(allRoutesHeuristics[i][1:
                                      int(len(allRoutesHeuristics[i])/2)])
        for j in range(1,nShipmentsRouteSelected+1):
            routesModified      = deepcopy(allRoutesHeuristics)
            shipmentIdxSelected = j
            thisShipment        = routesModified[i][shipmentIdxSelected]
            
            # First shipment in the route
            if shipmentIdxSelected == 1: 
                routesModified[i] = ([routesModified[i][0]] +
                                               routesModified[i][2:len(routesModified[i])-2] +
                                               [routesModified[i][len(routesModified[i])-1]]) 
            # Last shipment in the route
            elif shipmentIdxSelected == nShipmentsRouteSelected:
                routesModified[i] = (routesModified[i][0:int(len(routesModified[i])/2)-1]+
                                                    routesModified[i][int(len(routesModified[i])/2+1):int(len(routesModified[i]))])
            # Shipment is in an intermediate position
            else:
                routesModified[i] = (routesModified[i][0:shipmentIdxSelected]+
                                                    routesModified[i][shipmentIdxSelected+1:len(routesModified[i])-1-shipmentIdxSelected]+
                                                    routesModified[i][len(routesModified[i])-shipmentIdxSelected:len(routesModified[i])])
            
            routesArrDepmatrix = []
            for ii in range(0,len(routesModified)):
                routesArrDepmatrix.append(routeCharacteristics(routesModified[ii],
                                                      timeMatrix,elBoundsExport,processingTimeExport,maxRideTime))

            
            (isGHSequenceFeasibleIn, isFFSequenceFeasibleIn, 
             isSolutionWeightFeasibleIn, isTWFeasibleIn, isDCFeasibleIn, isSolutionLengthFeasibleIn,
             FFViolationIn, GHViolationIn, weightViolationIn, TWViolationIn, DCViolationIn, lengthViolationIn,
             SAnewsolutionIn, timeStampsSAfeasIn,FFSequenceIn,GHSequenceIn) = checkFeasibilityNew(
                     routesModified,routesArrDepmatrix,lTAll,Nf,Ng,sigma,WeightE,QTruck,
             exportPickupNodes,processingTimeExport,Nd,lat_occupancy_shipments,L_trailer)
            
            (JIn, allDistancesIn, allTravelTimesIn, offLoadedShipmentsIn) = costSolutionNew(routesModified,
                              routesArrDepmatrix,distanceMatrix,sigma-1,
                              FFViolationIn,GHViolationIn,weightViolationIn,TWViolationIn,DCViolationIn,
                              wFF,wGH,wW,wTW,wDC,wL,lat_occupancy_shipments,L_trailer,lengthViolation,node_rev,sigmaS)
            
            routeIdx.append(i)
            shipmentRemoved.append(thisShipment)
            cost.append(J-JIn)
            
            #print str(i) + '-' + str(thisShipment)
            #print str(TWViolationIn) + '-' + str(DCViolationIn)
            #print JIn
            #print '%%%%%%%%%%%%%%%%%%'
            
    costSrt         = sorted(cost, reverse=True)
    CostSrtOrig     = deepcopy(costSrt)
    idxCostSrt      = sorted(range(len(cost)), key=lambda k: cost[k], reverse=True)
    shipmentsSrt    = []
    routeIdxSrt     = []
    for i in range(0,len(shipmentRemoved)):
        shipmentsSrt.append(shipmentRemoved[idxCostSrt[i]])
        routeIdxSrt.append(routeIdx[idxCostSrt[i]])
    
    p = 10
    
    costEliminated          = []
    shipmentEliminated      = []
    routeShipmentEliminated = []
    
    while q>0:
        y                = random.random()
        indexToEliminate = int(np.round(y**p*(len(costSrt)-1)))
        costEliminated.append(costSrt[indexToEliminate])
        shipmentEliminated.append(shipmentsSrt[indexToEliminate])
        routeShipmentEliminated.append(routeIdxSrt[indexToEliminate])
        
        costSrt.pop(indexToEliminate)
        shipmentsSrt.pop(indexToEliminate)
        routeIdxSrt.pop(indexToEliminate)
        
        q -= 1
        
    # Compute reduced routes (i.e., routes without the shipments removed
    # by the worstRemoval technique)
    routesModified   = deepcopy(allRoutesHeuristics)
    
    for i in range(0,len(shipmentEliminated)):
        thisShipment        = shipmentEliminated[i]
        thisRoute           = routeShipmentEliminated[i]
        shipmentIdxSelected = np.where(np.array(routesModified[thisRoute])==thisShipment)[0][0]
        nShipmentsRouteSelected = int(len(routesModified[thisRoute][1:int(len(routesModified[thisRoute])/2)]))
        
        # First shipment in the route
        if shipmentIdxSelected == 1: 
            routesModified[thisRoute] = ([routesModified[thisRoute][0]] +
                                           routesModified[thisRoute][2:len(routesModified[thisRoute])-2] +
                                           [routesModified[thisRoute][len(routesModified[thisRoute])-1]]) 
        # Last shipment in the route
        elif shipmentIdxSelected == nShipmentsRouteSelected:
            routesModified[thisRoute] = (routesModified[thisRoute][0:int(len(routesModified[thisRoute])/2-1)]+
                                                routesModified[thisRoute][int(len(routesModified[thisRoute])/2+1):
                                                    int(len(routesModified[thisRoute]))])
        # Shipment is in an intermediate position
        else:
            routesModified[thisRoute] = (routesModified[thisRoute][0:shipmentIdxSelected]+
                                         routesModified[thisRoute][shipmentIdxSelected+1:
                                         len(routesModified[thisRoute])-1-shipmentIdxSelected]+
                                         routesModified[thisRoute][len(routesModified[thisRoute])-shipmentIdxSelected:len(routesModified[thisRoute])])

    return routeIdx,shipmentRemoved,CostSrtOrig,costEliminated,shipmentEliminated,routeShipmentEliminated,routesModified

      
#####################################

def shawRemoval(allRoutesHeuristics,q,timeMatrix,elBoundsExport,
                processingTimeExport,maxRideTime,Nf,Ng,sigma,WeightE,
                QTruck,exportPickupNodes,Nd,distanceMatrix,maxRideTimeTruck):

    routesArrDepmatrix = []
    for i in range(0,int(len(allRoutesHeuristics))):
        routesArrDepmatrix.append(cordeauLaporteProcedure(allRoutesHeuristics[i],timeMatrix,elBoundsExport,processingTimeExport,maxRideTime))

    # Compute slack vector for each route
    forwardSlackAllRoutes = []
    for i in range(0,len(allRoutesHeuristics)):
        forwardSlackVector = computeForwardSlack3(allRoutesHeuristics[i],
                             routesArrDepmatrix[i],elBoundsExport,
                             processingTimeExport,maxRideTime)
        forwardSlackAllRoutes.append(forwardSlackVector)
    
    # Identify all shipments part of the current solution
    shipmentsThisSolution = []
    routeIdxThisShipment  = []
    for i in range(0,len(allRoutesHeuristics)):
        for j in range(1,int(len(allRoutesHeuristics[i])/2)):
            shipmentsThisSolution.append(allRoutesHeuristics[i][j])
            routeIdxThisShipment.append(i)
    
    # Normalization constants
    maxDistance = np.max(distanceMatrix)
    maxTime     = maxRideTimeTruck
    maxWeight   = QTruck[0]
    
    # Weights
    alpha = 1
    beta  = 1
    gamma = 1
    delta = 1
    
    # Assembling matrix where element (i,j) is the relatedness between
    # shipments i and j
    relatednessMatrix = np.zeros([int(len(shipmentsThisSolution)),int(len(shipmentsThisSolution))])
    for i in range(0,int(len(shipmentsThisSolution)-1)):
        firstShipment           = shipmentsThisSolution[i]
        routeIdxFirstShipment   = routeIdxThisShipment[i]
        posFirstShipmentInRoute = np.where(np.array(allRoutesHeuristics[routeIdxFirstShipment])==firstShipment)[0][0]
        posFirstShipDelInRoute  = len(allRoutesHeuristics[routeIdxFirstShipment])-posFirstShipmentInRoute-1
        for j in range(i+1,len(shipmentsThisSolution)):
            secondShipment           = shipmentsThisSolution[j]
            routeIdxSecondShipment   = routeIdxThisShipment[j]
            posSecondShipmentInRoute = np.where(np.array(allRoutesHeuristics[routeIdxSecondShipment])==secondShipment)[0][0]
            posSecondShipDelInRoute  = len(allRoutesHeuristics[routeIdxSecondShipment])-posSecondShipmentInRoute-1
            
            dPickup           = distanceMatrix[firstShipment][secondShipment]
            dDelivery         = distanceMatrix[firstShipment+sigma][secondShipment+sigma]
            timeDiffPickup    = np.abs(routesArrDepmatrix[routeIdxFirstShipment][posFirstShipmentInRoute,3]-
                             routesArrDepmatrix[routeIdxSecondShipment][posSecondShipmentInRoute,3])
            timeDiffDelivery  = np.abs(routesArrDepmatrix[routeIdxFirstShipment][posFirstShipDelInRoute,3]-
                             routesArrDepmatrix[routeIdxSecondShipment][posSecondShipDelInRoute,3])
            weightDiff        = np.abs(WeightE[firstShipment-1]-WeightE[secondShipment-1])
            slackDiffPickup   = np.abs(forwardSlackAllRoutes[routeIdxFirstShipment][posFirstShipmentInRoute]-
                                       forwardSlackAllRoutes[routeIdxSecondShipment][posSecondShipmentInRoute])
            slackDiffDelivery = np.abs(forwardSlackAllRoutes[routeIdxFirstShipment][posFirstShipDelInRoute]-
                                       forwardSlackAllRoutes[routeIdxSecondShipment][posSecondShipDelInRoute])
            

            relatednessMatrix[i][j] = (alpha*(dPickup+dDelivery)/maxDistance+
                                       beta*(timeDiffPickup+timeDiffDelivery)/maxTime+
                                       gamma*weightDiff/maxWeight+
                                       delta*(slackDiffPickup+slackDiffDelivery)/maxTime)
    
    # Fill in lower triangular part of the matrix
    relatednessMatrix = relatednessMatrix + np.transpose(relatednessMatrix)    
    # Assign a very high value to diagonal elements (so that we cannot
    # pair a shipment with itself)
    M                          = 50
    row,col                    = np.diag_indices(relatednessMatrix.shape[0])
    relatednessMatrix[row,col] = M*np.ones([len(shipmentsThisSolution)])
    # Initialize set of shipments to be removed
    D = []
    # Randomly pick a request to be removed
    idxShipmentToBeRemoved = random.randint(0,len(shipmentsThisSolution)-1)
    D.append(shipmentsThisSolution[idxShipmentToBeRemoved])
    
    p = 10
    while len(D)<q:
        # Randomly pick a shipment among the ones already stored in D
        idxInD              = random.randint(0,len(D)-1)
        thisShipment        = D[idxInD]
        # Find index of shipment in relatedness matrix
        positionInRelMatrix = np.where(np.array(shipmentsThisSolution)==thisShipment)[0][0]
        # Sort associated row of relatedness matrix (we are sorting the indices)
        idxRowSorted = np.argsort(relatednessMatrix[positionInRelMatrix])
        
        newShipmentToRemove = 1
        while newShipmentToRemove == 1:
            y                    = random.random()
            idxToAdd             = int(np.round(y**p*(len(shipmentsThisSolution)-1)))
            potentialNewShipment = shipmentsThisSolution[idxRowSorted[idxToAdd]]
            
            if potentialNewShipment not in D:
                D.append(potentialNewShipment)
                newShipmentToRemove = 0
    
    # Compute reduced routes (i.e., routes without the shipments removed
    # by the Shaw removal technique)
    routesModified   = deepcopy(allRoutesHeuristics)
    
    for i in range(0,len(D)):
        thisShipment        = D[i]
        
        for j in range(0,len(allRoutesHeuristics)):
            if thisShipment in allRoutesHeuristics[j]:
                thisRoute = j
                break
                
        shipmentIdxSelected = np.where(np.array(routesModified[thisRoute])==thisShipment)[0][0]
        
        nShipmentsRouteSelected = int(len(routesModified[thisRoute][1:
                                      int(len(routesModified[thisRoute])/2)]))
        
        # First shipment in the route
        if shipmentIdxSelected == 1: 
            routesModified[thisRoute] = ([routesModified[thisRoute][0]] +
                                           routesModified[thisRoute][2:len(routesModified[thisRoute])-2] +
                                           [routesModified[thisRoute][len(routesModified[thisRoute])-1]]) 
        # Last shipment in the route
        elif shipmentIdxSelected == nShipmentsRouteSelected:
            routesModified[thisRoute] = (routesModified[thisRoute][0:int(len(routesModified[thisRoute])/2-1)]+
                                                routesModified[thisRoute][int(len(routesModified[thisRoute])/2+1):
                                                    int(len(routesModified[thisRoute]))])
        # Shipment is in an intermediate position
        else:
            routesModified[thisRoute] = (routesModified[thisRoute][0:shipmentIdxSelected]+
                                         routesModified[thisRoute][shipmentIdxSelected+1:
                                         int(len(routesModified[thisRoute]))-1-shipmentIdxSelected]+
                                         routesModified[thisRoute][int(len(routesModified[thisRoute]))-shipmentIdxSelected:int(len(routesModified[thisRoute]))])
        
        
    
    return relatednessMatrix,D,shipmentsThisSolution,routesModified

def shortestRouteRemoval(allRoutesHeuristics):
    #########################################################################
    ### Identify shortest route, identify OD of shipments and if they are ###
    ### clustered, insert them into other routes such that FF, GH, weight ###
    ### constraints are satisfied                                         ###
    #########################################################################
    routeHeurLength = []
    for i in range(0,len(allRoutesHeuristics)):
        # Determine length of current route
        routeHeurLength.append(len(allRoutesHeuristics[i]))
    
    # Identify route with minimum length
    indexRoute, lenRoute = min(enumerate(routeHeurLength), key=operator.itemgetter(1))
    
    removedShipments = []
    for i in range(1,int(len(allRoutesHeuristics[indexRoute])/2)):
        removedShipments.append(allRoutesHeuristics[indexRoute][i])       
    
    routesModified = []
    for i in range(0,int(len(allRoutesHeuristics))):
        if i != indexRoute:
            routesModified.append(allRoutesHeuristics[i])
            
    return routesModified,removedShipments 
    
###############################################################################
def cordeauLaporteProcedure(r,timeMatrix,elMatrix,processingTime,maxRideTime):
    # STEP 1 + STEP 2
    varMatrix = routeCharacteristics(r,timeMatrix,elMatrix,processingTime,maxRideTime)
    
    # STEP 3
    # We are computing F0, thus we need to span the whole list of nodes
    slackVector = forward_slack_computation(r,varMatrix,elMatrix,processingTime,maxRideTime)
    # STEP 4
    D0              = elMatrix[0][0] + np.min([slackVector[0],np.sum(varMatrix[1:len(r)-1,1])])
    varMatrix[0][3] = D0
    
    for j in range(1,len(r)):
        thisNode        = int(r[j])
        varMatrix[j][0] = varMatrix[j-1][3]+timeMatrix[r[j-1]][thisNode]
        varMatrix[j][1] = np.max([elMatrix[thisNode][0]-varMatrix[j][0],0])
        varMatrix[j][2] = varMatrix[j][0]+varMatrix[j][1]
        varMatrix[j][3] = varMatrix[j][2]+processingTime[thisNode]
        varMatrix[j][4] = maxRideTime[thisNode]
    # STEP 5: update A, W, B, D for each vertex i in the route
    # STEP 6 + STEP 7
    # Spanning pickup nodes
    for i in range(1,int(len(r)/2)):
        # (a) Compute Fj
        thisNode    = r[i]
        slackVector = computeForwardSlack3(r,varMatrix,elMatrix,processingTime,maxRideTime)
        Fi          = slackVector[i]
        # (b) Update Bj and Dj
        varMatrix[i][2] = varMatrix[i][2]+np.min([Fi,np.sum(varMatrix[i+1:len(r)-1,1])])
        varMatrix[i][3] = varMatrix[i][2]+processingTime[thisNode]
        # (c) Update varMatrix for all vertices after the current one
        for j in range(i+1,len(r)):
            thisNode        = int(r[j])
            varMatrix[j][0] = varMatrix[j-1][3]+timeMatrix[r[j-1]][thisNode]
            varMatrix[j][1] = np.max([elMatrix[thisNode][0]-varMatrix[j][0],0])
            varMatrix[j][2] = varMatrix[j][0]+varMatrix[j][1]
            varMatrix[j][3] = varMatrix[j][2]+processingTime[thisNode]
            varMatrix[j][4] = maxRideTime[thisNode]
            
    return varMatrix 

###############################################################################

def basicGreedyInsertion(routesAfterShipmentRemoval,updatedUnassignedShipments,
                       timeMatrix,elBoundsExport,processingTimeExport,maxRideTime,Nf,Ng,sigma,WeightE,
                       QTruck,exportPickupNodes,Nd,lTAll,distanceMatrix,
                       routesArrDepmatrix,maxRideTimeTruck,wFF,wGH,wW,wTW,wDC,wL,lat_occupancy_shipments,L_trailer,node_rev):
    
    # modRoutesBasicGreedy has at most q rows. In each row we store the i-th
    # shipment that was added to the initial set of routes, the index of the
    # route where the shipment was added, and the modified route. Note that
    # there are AT MOST q rows because there could be cases where less than q
    # feasible insertions are possible
    modRoutesBasicGreedy = []
    # routesBeforeChanges is the set of routes before changes are applied.
    # It is stored for comparison/debugging purposes
    routesBeforeChanges  = deepcopy(routesAfterShipmentRemoval)
    
    # exit condition
    condExit = 0
    
    # updatedRoutes is the set of updated routes once the while cycle is over
    updatedRoutes = None
    
    # Main cycle. Stay in the cycle until either ther are no more feasible 
    # insertions, or all unassigned shipments have been assigned
    while condExit != 1 and len(updatedUnassignedShipments)>0:
        
        
        #######################################################################
        ### Compute cost of current solution: start
        #######################################################################
        # At each iteration, we need the cost of the updated solution
        # to be compared with all the possible feasible modified routes
        
        #########################################
        ### Compute time-stamps of all routes ###
        #########################################
        depArrMatrix = []
        for i in range(0,len(routesAfterShipmentRemoval)): 
            depArrMatrix.append(cordeauLaporteProcedure(routesAfterShipmentRemoval[i],
                                timeMatrix,elBoundsExport,processingTimeExport,maxRideTime))
        
        
        #################################################
        ### Compute cost function of current solution ###
        #################################################
        (isGHSequenceFeasible, isFFSequenceFeasible, 
             isSolutionWeightFeasible, isTWFeasible, isDCFeasible, isSolutionLengthFeasible,
             FFViolation, GHViolation, weightViolation, TWViolation, DCViolation, lengthViolation,
             SAnewsolution, timeStampsSAfeas,FFSequence,GHSequence) = checkFeasibilityNew(routesAfterShipmentRemoval,
                                                                          depArrMatrix,lTAll,Nf,Ng,sigma,WeightE,QTruck,
                                                                          exportPickupNodes,processingTimeExport,Nd,lat_occupancy_shipments,L_trailer)
        
        (J, allDistances, allTravelTimes, offLoadedShipments) = costSolutionNew(routesAfterShipmentRemoval,depArrMatrix,distanceMatrix,sigma,
                     FFViolation,GHViolation,weightViolation,TWViolation,DCViolation,
                     wFF,wGH,wW,wTW,wDC,wL,lat_occupancy_shipments,L_trailer,lengthViolation,node_rev,sigmaS)
        
        #######################################################################
        ### Compute cost of current solution: end
        #######################################################################
        
        
        shipmentRoutePairs = []
        possibleAlternatives = []
        
        # We cycle over all unassigned shipments. For each shipment, we look
        # for the route (and position in the route) such that the overall increase
        # in cost function is minimum
        for cont in range(0,len(updatedUnassignedShipments)):
            # Selected shipment index (pickup side)
            thisShipment             = updatedUnassignedShipments[cont]
            # Selected shipment index (delivery side)
            thisShipmentDeliverySide = updatedUnassignedShipments[cont]+sigma
            
            # Given the current shipment, scan all routes
            for i in range(0,len(routesAfterShipmentRemoval)):
                thisRouteMod           = routesAfterShipmentRemoval[i]
                # Check how many shipments are there in the current route.
                # The number of possible insertion points in number of 
                # shipments + 1
                nShipmentsThisRouteMod = len(thisRouteMod[1:int(len(thisRouteMod)/2)])
                nPositions             = nShipmentsThisRouteMod+1
                for j in range(0,nPositions):
                    if j == 0:
                        thisRouteWithAddedShipments = (thisRouteMod[0:j+1] + [thisShipment] +
                                                   thisRouteMod[1:int(len(thisRouteMod)-1)] +
                                                   [thisShipmentDeliverySide] + 
                                                   [thisRouteMod[len(thisRouteMod)-1]])
                    elif j == nPositions:
                        thisRouteWithAddedShipments = (thisRouteMod[0:j+1] + [thisShipment] +
                                                   [thisShipmentDeliverySide] +
                                                   thisRouteMod[int(len(thisRouteMod)/2):int(len(thisRouteMod)-1)])
                    else:
                        thisRouteWithAddedShipments = (thisRouteMod[0:j+1] + [thisShipment] +
                                               thisRouteMod[j+1:len(thisRouteMod)-j-1] +
                                               [thisShipmentDeliverySide] + 
                                               thisRouteMod[len(thisRouteMod)-j-1:len(thisRouteMod)])
                            
                    
                    # Check if current route is feasible
                    feasThisRoute = computeRouteFeasibility(thisRouteWithAddedShipments,sigma,Nf,Ng,exportPickupNodes,WeightE,QTruck[0],timeMatrix,
                                                 elBoundsExport,processingTimeExport,maxRideTime,lat_occupancy_shipments,L_trailer)
                    
                    
                    # If it is feasible, compute cost
                    if feasThisRoute[0] == 1:
                        
                        # Assemble route set with current modified route 
                        fullSetofRoutes = []
                        for ii in range(0,len(routesAfterShipmentRemoval)):
                            if ii==i:
                                fullSetofRoutes.append(thisRouteWithAddedShipments)
                            else:
                                fullSetofRoutes.append(routesAfterShipmentRemoval[ii])
                        
                        depArrMatrix = []
                        for jj in range(0,len(fullSetofRoutes)):
                            
                            thisRouteTimeMatrix = cordeauLaporteProcedure(fullSetofRoutes[jj],
                                timeMatrix,elBoundsExport,processingTimeExport,maxRideTime)
                            
                            depArrMatrix.append(thisRouteTimeMatrix)
                        
                        (isGHSequenceFeasible, isFFSequenceFeasible, 
             isSolutionWeightFeasible, isTWFeasible, isDCFeasible, isSolutionLengthFeasible,
             FFViolation, GHViolation, weightViolation, TWViolation, DCViolation, lengthViolation,
             SAnewsolution, timeStampsSAfeas,FFSequence,GHSequence) = checkFeasibilityNew(fullSetofRoutes,
                                                                          depArrMatrix,lTAll,Nf,Ng,sigma,WeightE,QTruck,
                                                                          exportPickupNodes,processingTimeExport,Nd,lat_occupancy_shipments,L_trailer)
                        
                        
        
                        (JThisAlt, allDistances, allTravelTimes, offLoadedShipments) = costSolutionNew(fullSetofRoutes,
                                                                                depArrMatrix,distanceMatrix,sigma,
                                                                                FFViolation,GHViolation,weightViolation,TWViolation,DCViolation,
                                                                                wFF,wGH,wW,wTW,wDC,wL,lat_occupancy_shipments,L_trailer,lengthViolation.node_rev,sigmaS)
                        
                        possibleAlternatives.append([thisRouteWithAddedShipments,feasThisRoute[1],i,JThisAlt-J])
                        shipmentRoutePairs.append([thisShipment,thisRouteWithAddedShipments,fullSetofRoutes,JThisAlt-J])
        
        if len(shipmentRoutePairs) == 0:
            condExit = 1
            
        else:
            
        
            # Determine modification to current route set that minimizes the
            # increase in cost function (note: the cost function could actually
            # decrease because we might be solving, unintentionally, a dock
            # capacity violation)
            deltaCost = []                
            for i in range(0,len(shipmentRoutePairs)):
                deltaCost.append(shipmentRoutePairs[i][3])
            

            # Sort deltaCost by increasing order, find index idxDeltaCostSrt
            # in deltaCost vector where deltaCost is minimum
            # idxDeltaCostSrt[0], i.e., the first index of the sorted list,
            # is the index such that the associated deltaCost is minimum
            idxDeltaCostSrt   = sorted(range(len(deltaCost)), key=lambda k: deltaCost[k], reverse=False)   

            # Determine best shipment to add, as long as the index of the 
            # route that was modified and the modified route
            bestShipmentToAdd = shipmentRoutePairs[idxDeltaCostSrt[0]][0]
            idxModifiedRoute  = possibleAlternatives[idxDeltaCostSrt[0]][2]
            modifiedRoute     = shipmentRoutePairs[idxDeltaCostSrt[0]][1]
            
            # Update set of routes
            updatedRoutes = []
            for i in range(0,len(routesBeforeChanges)):
                if i!= idxModifiedRoute:
                    updatedRoutes.append(routesAfterShipmentRemoval[i])
                else:
                    updatedRoutes.append(modifiedRoute)
            
            # Update routesAfterShipmentRemoval list, and eliminate
            # recently assigned shipment from list of unassigned shipments
            routesAfterShipmentRemoval = deepcopy(updatedRoutes)
            idxAddedShipment           = np.where(np.array(updatedUnassignedShipments)==bestShipmentToAdd)[0][0]
            updatedUnassignedShipments.pop(idxAddedShipment)
            
            # Append to modRoutesBasicGreedy list the information of 
            # current added shipment
            modRoutesBasicGreedy.append([bestShipmentToAdd,idxModifiedRoute,modifiedRoute])
            
    
    # If updatedRoutes is None, it means that no insertion has been 
    # carried out in the while. The updated routes are thus the original
    # routes, since ho change has been carried out
    if updatedRoutes is None:
        updatedRoutes = deepcopy(routesBeforeChanges)
            
    
    return modRoutesBasicGreedy,updatedRoutes,updatedUnassignedShipments

###############################################################################

def regretHeuristicInsertion(routesAfterShipmentRemoval,updatedUnassignedShipments,K,
                       timeMatrix,elBoundsExport,processingTimeExport,maxRideTime,Nf,Ng,sigma,WeightE,
                       QTruck,exportPickupNodes,Nd,lTAll,distanceMatrix,
                       routesArrDepmatrix,maxRideTimeTruck,wFF,wGH,wW,wTW,wDC,wL,lat_occupancy_shipments,L_trailer,node_rev):
    
    routesOriginal = deepcopy(routesAfterShipmentRemoval)
    routesModified = deepcopy(routesAfterShipmentRemoval)
    
    
    condExit = 0
    
    
    while condExit != 1 and len(updatedUnassignedShipments)>0:
    
        #########################################
        ### Compute time-stamps of all routes ###
        #########################################
        depArrMatrix = []
        for i in range(0,len(routesModified)):
            depArrMatrix.append(cordeauLaporteProcedure(routesModified[i],
                                timeMatrix,elBoundsExport,processingTimeExport,maxRideTime))
        
        
        #################################################
        ### Compute cost function of current solution ###
        #################################################
        (isGHSequenceFeasible, isFFSequenceFeasible, 
             isSolutionWeightFeasible, isTWFeasible, isDCFeasible, isSolutionLengthFeasible,
             FFViolation, GHViolation, weightViolation, TWViolation, DCViolation, lengthViolation,
             SAnewsolution, timeStampsSAfeas,FFSequence,GHSequence) = checkFeasibilityNew(routesModified,
                                                                          depArrMatrix,lTAll,Nf,Ng,sigma,WeightE,QTruck,
                                                                          exportPickupNodes,processingTimeExport,Nd,lat_occupancy_shipments,L_trailer)
        
        (J, allDistances, allTravelTimes, offLoadedShipments) = costSolutionNew(routesModified,depArrMatrix,distanceMatrix,sigma,
                     FFViolation,GHViolation,weightViolation,TWViolation,DCViolation,
                     wFF,wGH,wW,wTW,wDC,wL,lat_occupancy_shipments,L_trailer,lengthViolation,node_rev,sigmaS)
        
        shipmentRoutePairs = []
        possibleAlternatives = []
        
        # We cycle over all unassigned shipments. For each shipment, we look
        # for the route (and position in the route) such that the overall increase
        # in cost function is minimum
        for cont in range(0,len(updatedUnassignedShipments)):
            thisShipment             = updatedUnassignedShipments[cont]
            thisShipmentDeliverySide = updatedUnassignedShipments[cont]+sigma
            
            
            for i in range(0,len(routesModified)):
                thisRouteMod           = routesModified[i]
                nShipmentsThisRouteMod = len(thisRouteMod[1:int(len(thisRouteMod)/2)])
                nPositions             = nShipmentsThisRouteMod+1
                for j in range(0,nPositions):
                    if j == 0:
                        thisRouteWithAddedShipments = (thisRouteMod[0:j+1] + [thisShipment] +
                                                   thisRouteMod[1:int(len(thisRouteMod)-1)] +
                                                   [thisShipmentDeliverySide] + 
                                                   [thisRouteMod[len(thisRouteMod)-1]])
                    elif j == nPositions:
                        thisRouteWithAddedShipments = (thisRouteMod[0:j+1] + [thisShipment] +
                                                   [thisShipmentDeliverySide] +
                                                   thisRouteMod[int(len(thisRouteMod)/2):int(len(thisRouteMod)-1)])
                    else:
                        thisRouteWithAddedShipments = (thisRouteMod[0:j+1] + [thisShipment] +
                                               thisRouteMod[j+1:len(thisRouteMod)-j-1] +
                                               [thisShipmentDeliverySide] + 
                                               thisRouteMod[len(thisRouteMod)-j-1:len(thisRouteMod)])
                    
                    feasThisRoute = computeRouteFeasibility(thisRouteWithAddedShipments,sigma,Nf,Ng,exportPickupNodes,WeightE,QTruck[0],timeMatrix,
                                                 elBoundsExport,processingTimeExport,maxRideTime,lat_occupancy_shipments,L_trailer)
                    
                    
                            
                    
                    if feasThisRoute[0] == 1:
                        
                        fullSetofRoutes = []
                        for ii in range(0,len(routesModified)):
                            if ii==i:
                                fullSetofRoutes.append(thisRouteWithAddedShipments)
                            else:
                                fullSetofRoutes.append(routesModified[ii])
                        
                        depArrMatrix = []
                        for jj in range(0,len(fullSetofRoutes)):
                            
                            thisVarMatrix = cordeauLaporteProcedure(fullSetofRoutes[jj],
                                timeMatrix,elBoundsExport,processingTimeExport,maxRideTime)
                            
                            depArrMatrix.append(thisVarMatrix)
                        
                        (isGHSequenceFeasible, isFFSequenceFeasible, 
             isSolutionWeightFeasible, isTWFeasible, isDCFeasible, isSolutionLengthFeasible,
             FFViolation, GHViolation, weightViolation, TWViolation, DCViolation, lengthViolation,
             SAnewsolution, timeStampsSAfeas,FFSequence,GHSequence) = checkFeasibilityNew(fullSetofRoutes,
                                                                          depArrMatrix,lTAll,Nf,Ng,sigma,WeightE,QTruck,
                                                                          exportPickupNodes,processingTimeExport,Nd,lat_occupancy_shipments,L_trailer)
                        
                        
        
                        (JThisAlt, allDistances, allTravelTimes, offLoadedShipments) = costSolutionNew(fullSetofRoutes,
                                                                                depArrMatrix,distanceMatrix,sigma,
                                                                                FFViolation,GHViolation,weightViolation,TWViolation,DCViolation,
                                                                                wFF,wGH,wW,wTW,wDC,wL,lat_occupancy_shipments,L_trailer,lengthViolation,node_rev,sigmaS)
                        
                        possibleAlternatives.append([thisRouteWithAddedShipments,feasThisRoute[1],i,JThisAlt-J])
                        shipmentRoutePairs.append([thisShipment,thisRouteWithAddedShipments,fullSetofRoutes,JThisAlt-J])
        
        if len(possibleAlternatives) == 0:
            condExit = 1
        else:
                        
            # For each shipment, check in how many routes it was inserted
            listAllShipments     = []
            listAllRoutes        = []
            listAllCosts         = []
            listAllUpdatedRoutes = []
            
           # print possibleAlternatives
            
            for i in range(0,len(possibleAlternatives)):
                listAllShipments.append(shipmentRoutePairs[i][0])
                listAllRoutes.append(possibleAlternatives[i][2])
                listAllCosts.append(shipmentRoutePairs[i][3])
                listAllUpdatedRoutes.append(shipmentRoutePairs[i][1])
            
            # Matrix with as many rows as the number of unassigned shipments.
            # The two columns store, respectively, the shipment number
            # and the number of routes where the shipment can be feasibily
            # inserted
            shipmentNumberRoutes = np.zeros([len(updatedUnassignedShipments),2])
            for i in range(0,len(updatedUnassignedShipments)):
                thisShipment          = updatedUnassignedShipments[i]
                idxThisShipment       = np.where(np.array(listAllShipments)==thisShipment)[0]
                routesThisShipment    = list(np.unique(np.array(listAllRoutes)[idxThisShipment]))
                shipmentNumberRoutes[i,0] = int(thisShipment)
                shipmentNumberRoutes[i,1] = len(routesThisShipment)
                
            #print shipmentNumberRoutes
            
            lessThanKShipment       = []
            lessThanKRoutesShipment = []
            for i in range(0,len(updatedUnassignedShipments)):
                if shipmentNumberRoutes[i][1]>=1 and shipmentNumberRoutes[i][1]<K:
                    #print 'Shipment ' + str(shipmentNumberRoutes[i][0]) + ' appears in fewer routes than K'
                    lessThanKShipment.append(int(shipmentNumberRoutes[i][0]))
                    lessThanKRoutesShipment.append(shipmentNumberRoutes[i][1])
            
            #print lessThanKShipment
            
            if len(lessThanKShipment)>0:
                
                #print 'We are in less than K case'
                
                #print '%%%%%%%%%%%%%%%%%%%%%%'
                #print 'Some shipments can only be inserted in less than K routes!'
                #print '%%%%%%%%%%%%%%%%%%%%%%'
                
                minNumberOfRoutes = []
                for j in range(0,len(lessThanKShipment)):
                    minNumberOfRoutes.append(lessThanKRoutesShipment[j])
                
                minRoutes            = np.min(np.array(minNumberOfRoutes))
                idxShipmentMinRoutes = np.where(np.array(minNumberOfRoutes)==minRoutes)[0]
                shipmentsMinRoutes   = list(np.array(lessThanKShipment)[idxShipmentMinRoutes])
                
                #print minRoutes
                #print idxShipmentMinRoutes
                #print shipmentsMinRoutes
                
                deltaCost          = []
                deltaCostRoutes    = []
                deltaCostIdxRoutes = []
                # Cycling over the shipments that were assigned to the 
                # minimum number of routes
                for j in range(0,len(shipmentsMinRoutes)):
                    thisShipment          = shipmentsMinRoutes[j]
                    idxThisShipment       = np.where(np.array(listAllShipments)==thisShipment)[0]
                    routesThisShipment    = list(np.unique(np.array(listAllRoutes)[idxThisShipment]))
                    
                    #print '%%%%%%%%%%%%%%%%'
                    #print thisShipment
                    #print idxThisShipment
                    #print routesThisShipment
                    #print '%%%%%%%%%%%%%%%%'
                    
                    deltaCostThisShipment          = []
                    deltaCostRoutesThisShipment    = []
                    deltaCostIdxRoutesThisShipment = []
                    
                    # Cycling over the routes where this shipment appears
                    for jj in range(0,len(routesThisShipment)):
                        idxThisShipmentThisRoute     = np.intersect1d(np.where(np.array(listAllShipments)==thisShipment),
                                                                  np.where(np.array(listAllRoutes)==routesThisShipment[jj]))
                        
                        #print '#########'
                        #print idxThisShipmentThisRoute
                        #print np.array(listAllCosts)[idxThisShipmentThisRoute]
                        
                        minCostThisShipmentThisRoute = np.min(np.array(listAllCosts)[idxThisShipmentThisRoute])
                        
                        #print minCostThisShipmentThisRoute
                        #print '#########'
                        
                        
                        deltaCostThisShipment.append(minCostThisShipmentThisRoute)
                        deltaCostRoutesThisShipment.append(listAllUpdatedRoutes[idxThisShipmentThisRoute[np.where(np.array(listAllCosts)[idxThisShipmentThisRoute]==minCostThisShipmentThisRoute)[0][0]]])
                        deltaCostIdxRoutesThisShipment.append(routesThisShipment[jj])
                    # Sorting deltaCosts in descending order and computing
                    # their difference
                    thisDeltaCost             = 0
                    deltaCostThisShipmentSrt  = sorted(deltaCostThisShipment,reverse=False)
                    #print 'Printing deltaCostThisShipmentSrt: '
                    #print deltaCostThisShipmentSrt
                    for jj in range(0,len(deltaCostThisShipmentSrt)-1):
                        thisDeltaCost += deltaCostThisShipmentSrt[jj+1]-deltaCostThisShipmentSrt[0]
                    
                    deltaCost.append(thisDeltaCost)
                    deltaCostRoutes.append(deltaCostRoutesThisShipment[np.argsort(deltaCostThisShipment)[0]])
                    deltaCostIdxRoutes.append(deltaCostIdxRoutesThisShipment[np.argsort(deltaCostThisShipment)[0]])
                    
                    
                    #deltaCost.append(np.min(np.array(deltaCostThisShipment)))
                    #print 'Shipment ' + str(thisShipment)
                    #print deltaCostThisShipment
                
                #print lessThanKShipment
                #print deltaCost
                #print deltaCostRoutes
                
                idx                       = np.argsort(deltaCost)[-1]
                thisAddedShipment         = shipmentsMinRoutes[idx]
                thisAddedShipmentRoute    = deltaCostRoutes[idx]
                thisAddedShipmentIdxRoute = deltaCostIdxRoutes[idx]
                
                #print 'Printing modified route: START'
                #print thisAddedShipment         
                #print thisAddedShipmentRoute
                #print 'Printing modified route: END'
                #print thisAddedShipmentIdxRoute
                
                # Update list of unassigned shipments
                updatedUnassignedShipments.pop(np.where(np.array(updatedUnassignedShipments)==thisAddedShipment)[0][0])
                
                # Update routes
                for jj in range(0,len(routesModified)):
                    if jj == thisAddedShipmentIdxRoute:
                        routesModified[jj] = thisAddedShipmentRoute
                        
                #print routesModified
                        
                    
            else:
                #print 'We are in K case'
                
                #print '%%%%%%%%%%%%%%%%%%%%%%'
                #print 'All shipments can be inserted in at least K routes!'
                #print '%%%%%%%%%%%%%%%%%%%%%%'
                
                KShipment       = []
                KRoutesShipment = []
                for i in range(0,len(updatedUnassignedShipments)):
                    if shipmentNumberRoutes[i][1]>=K:
                        #print 'Shipment ' + str(shipmentNumberRoutes[i][0]) + ' appears in fewer routes than K'
                        KShipment.append(int(shipmentNumberRoutes[i][0]))
                        KRoutesShipment.append(shipmentNumberRoutes[i][1])
                
                #print KShipment
                #print KRoutesShipment
                
                #print 'KShipment display: '
                #print KShipment
                
                if len(KShipment)>0:
                    
                    deltaCost          = []
                    deltaCostRoutes    = []
                    deltaCostIdxRoutes = []
                    for j in range(0,len(KShipment)):
                        thisShipment          = KShipment[j]
                        idxThisShipment       = np.where(np.array(listAllShipments)==thisShipment)[0]
                        routesThisShipment    = list(np.unique(np.array(listAllRoutes)[idxThisShipment]))
                        deltaCostThisShipment          = []
                        deltaCostRoutesThisShipment    = []
                        deltaCostIdxRoutesThisShipment = []
                        for jj in range(0,len(routesThisShipment)):
                            idxThisShipmentThisRoute     = np.intersect1d(np.where(np.array(listAllShipments)==thisShipment),
                                                                      np.where(np.array(listAllRoutes)==routesThisShipment[jj]))
                            minCostThisShipmentThisRoute = np.min(np.array(listAllCosts)[idxThisShipmentThisRoute])
                            
                            
                            deltaCostThisShipment.append(minCostThisShipmentThisRoute)
                            deltaCostRoutesThisShipment.append(listAllUpdatedRoutes[idxThisShipmentThisRoute[np.where(np.array(listAllCosts)[idxThisShipmentThisRoute]==minCostThisShipmentThisRoute)[0][0]]])
                            deltaCostIdxRoutesThisShipment.append(routesThisShipment[jj])
                        
                        #print '%%% Begin This Shipment %%%'
                        #print thisShipment
                        #print deltaCostThisShipment
                        #print deltaCostRoutesThisShipment
                        #print deltaCostIdxRoutesThisShipment
                        #print '%%%%%%%%%%%%%%%%%%%%%%%%'
                        
                        # Sorting deltaCosts in descending order and computing
                        # their difference
                        thisDeltaCost             = 0
                        deltaCostThisShipmentSrt  = sorted(deltaCostThisShipment,reverse=False)
                        #print 'Printing deltaCostThisShipmentSrt: '
                        #print deltaCostThisShipmentSrt
                        for jj in range(0,K-1):
                            thisDeltaCost += deltaCostThisShipmentSrt[jj+1]-deltaCostThisShipmentSrt[0]
                        
                        #print thisShipment
                        #print deltaCostThisShipmentSrt
                        
                        deltaCost.append(thisDeltaCost)
                        deltaCostRoutes.append(deltaCostRoutesThisShipment[np.argsort(deltaCostThisShipment)[0]])
                        deltaCostIdxRoutes.append(deltaCostIdxRoutesThisShipment[np.argsort(deltaCostThisShipment)[0]])
                    
        
                    
                    idx                       = np.argsort(deltaCost)[-1]
                    thisAddedShipment         = KShipment[idx]
                    thisAddedShipmentRoute    = deltaCostRoutes[idx]
                    thisAddedShipmentIdxRoute = deltaCostIdxRoutes[idx]
                    
                    #print 'Printing modified route: START'
                    #print thisAddedShipment         
                    #print thisAddedShipmentRoute
                    #print 'Printing modified route: END'
                    #print thisAddedShipment         
                    #print thisAddedShipmentRoute
                    #print thisAddedShipmentIdxRoute
                    
                    # Update list of unassigned shipments
                    updatedUnassignedShipments.pop(np.where(np.array(updatedUnassignedShipments)==thisAddedShipment)[0][0])
                    
                    # Update routes
                    for jj in range(0,len(routesModified)):
                        if jj == thisAddedShipmentIdxRoute:
                            routesModified[jj] = thisAddedShipmentRoute
            
            #print '%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%'            
            #print '%%% Current added shipment is: '
            #print thisAddedShipment
            #print '%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%' 
     
      
    return routesOriginal,routesModified,updatedUnassignedShipments

###############################################################################
### Creating an extra route that is composed by as many unassigned 
### shipments as possible. To construct the route, we use a greedy 
### heuristic that sequentially adds the shipment that increases the least
### the cost function
###############################################################################
def newRouteCreationInsertion(originalRoutes,updatedUnassignedShipments,
                       timeMatrix,elBoundsExport,processingTimeExport,
                       maxRideTime,Nf,Ng,sigma,WeightE,
                       QTruck,exportPickupNodes,Nd,lTAll,distanceMatrix,
                       routesArrDepmatrix,maxRideTimeTruck,wFF,wGH,wW,wTW,wDC,wL,lat_occupancy_shipments,L_trailer,node_rev):

    initialRoute = [0,int(2*sigma+1)]
    thisRouteMod = deepcopy(initialRoute)
    
    exitCond = 0
    while exitCond != 1 and len(updatedUnassignedShipments)>0:
        
        potentialShipment   = []
        potentialRoutes     = []
        potentialRoutesCost = []
        # Cycling over all the remaining unassigned shipments
        for cont in range(0,len(updatedUnassignedShipments)):
            
            thisShipment             = updatedUnassignedShipments[cont]
            thisShipmentDeliverySide = updatedUnassignedShipments[cont]+sigma
            
            # First step: the route is empty and thus there is only one 
            # possibility to insert the current shipment
            if int(len(thisRouteMod)) == 2:
                nPositions = 1
                # Cycling over all the potential insertion locations
                for j in range(0,nPositions):
                    if j == 0:
                        thisRouteWithAddedShipments = (thisRouteMod[0:j+1] + [thisShipment] +
                                                       thisRouteMod[1:int(len(thisRouteMod)-1)] +
                                                       [thisShipmentDeliverySide] + 
                                                       [thisRouteMod[len(thisRouteMod)-1]])
                    elif j == nPositions:
                        thisRouteWithAddedShipments = (thisRouteMod[0:j+1] + [thisShipment] +
                                                   [thisShipmentDeliverySide] +
                                                   thisRouteMod[int(len(thisRouteMod)/2):int(len(thisRouteMod)-1)])
                    else:
                        thisRouteWithAddedShipments = (thisRouteMod[0:j+1] + [thisShipment] +
                                               thisRouteMod[j+1:len(thisRouteMod)-j-1] +
                                               [thisShipmentDeliverySide] + 
                                               thisRouteMod[len(thisRouteMod)-j-1:len(thisRouteMod)])
                    
                    feasThisRoute = computeRouteFeasibility(thisRouteWithAddedShipments,sigma,Nf,Ng,exportPickupNodes,WeightE,QTruck[0],timeMatrix,
                                                 elBoundsExport,processingTimeExport,maxRideTime,lat_occupancy_shipments,L_trailer)
                    
                    # Assembling full set of routes
                    fullSetofRoutes = []
                    for ii in range(0,len(originalRoutes)):
                        fullSetofRoutes.append(originalRoutes[ii])
                    fullSetofRoutes.append(thisRouteWithAddedShipments)
                    
                    if feasThisRoute[0] == 1:
                        
                        depArrMatrix = []
                        for jj in range(0,len(fullSetofRoutes)):
                            
                            thisVarMatrix = cordeauLaporteProcedure(fullSetofRoutes[jj],
                                timeMatrix,elBoundsExport,processingTimeExport,maxRideTime)
                            
                            depArrMatrix.append(thisVarMatrix)
                        
                        (isGHSequenceFeasible, isFFSequenceFeasible, 
             isSolutionWeightFeasible, isTWFeasible, isDCFeasible, isSolutionLengthFeasible,
             FFViolation, GHViolation, weightViolation, TWViolation, DCViolation, lengthViolation,
             SAnewsolution, timeStampsSAfeas,FFSequence,GHSequence) = checkFeasibilityNew(fullSetofRoutes,
                                                                          depArrMatrix,lTAll,Nf,Ng,sigma,WeightE,QTruck,
                                                                          exportPickupNodes,processingTimeExport,Nd,lat_occupancy_shipments,L_trailer)
                        
                        
        
                        (JThisAlt, allDistances, allTravelTimes, offLoadedShipments) = costSolutionNew(fullSetofRoutes,
                                                                                depArrMatrix,distanceMatrix,sigma,
                                                                                FFViolation,GHViolation,weightViolation,TWViolation,DCViolation,
                                                                                wFF,wGH,wW,wTW,wDC,wL,lat_occupancy_shipments,L_trailer,lengthViolation,node_rev,sigmaS)
                        
                        potentialShipment.append(thisShipment)
                        potentialRoutes.append(thisRouteWithAddedShipments)
                        potentialRoutesCost.append(JThisAlt)
            
            # Otherwise, the number of possible insertion points is the 
            # current number of shipments in the route + 1
            else:
            
                nShipmentsThisRouteMod = len(thisRouteMod[1:int(len(thisRouteMod)/2)])
                nPositions             = nShipmentsThisRouteMod+1
                # Cycling over all the potential insertion locations
                for j in range(0,nPositions):
                    if j == 0:
                            thisRouteWithAddedShipments = (thisRouteMod[0:j+1] + [thisShipment] +
                                                       thisRouteMod[1:int(len(thisRouteMod)-1)] +
                                                       [thisShipmentDeliverySide] + 
                                                       [thisRouteMod[len(thisRouteMod)-1]])
                    elif j == nPositions:
                        thisRouteWithAddedShipments = (thisRouteMod[0:j+1] + [thisShipment] +
                                                   [thisShipmentDeliverySide] +
                                                   thisRouteMod[int(len(thisRouteMod)/2):int(len(thisRouteMod)-1)])
                    else:
                        thisRouteWithAddedShipments = (thisRouteMod[0:j+1] + [thisShipment] +
                                               thisRouteMod[j+1:len(thisRouteMod)-j-1] +
                                               [thisShipmentDeliverySide] + 
                                               thisRouteMod[len(thisRouteMod)-j-1:len(thisRouteMod)])
                    
                    feasThisRoute = computeRouteFeasibility(thisRouteWithAddedShipments,sigma,Nf,Ng,exportPickupNodes,WeightE,QTruck[0],timeMatrix,
                                                 elBoundsExport,processingTimeExport,maxRideTime,lat_occupancy_shipments,L_trailer)
                    
                    # Assembling full set of routes
                    fullSetofRoutes = []
                    for ii in range(0,len(originalRoutes)):
                        fullSetofRoutes.append(originalRoutes[ii])
                    fullSetofRoutes.append(thisRouteWithAddedShipments)
                    
                    if feasThisRoute[0] == 1:
                        
                        depArrMatrix = []
                        for jj in range(0,len(fullSetofRoutes)):
                            
                            thisVarMatrix = cordeauLaporteProcedure(fullSetofRoutes[jj],
                                timeMatrix,elBoundsExport,processingTimeExport,maxRideTime)
                            
                            depArrMatrix.append(thisVarMatrix)
                        
                        (isGHSequenceFeasible, isFFSequenceFeasible, 
             isSolutionWeightFeasible, isTWFeasible, isDCFeasible, isSolutionLengthFeasible,
             FFViolation, GHViolation, weightViolation, TWViolation, DCViolation, lengthViolation,
             SAnewsolution, timeStampsSAfeas,FFSequence,GHSequence) = checkFeasibilityNew(fullSetofRoutes,
                                                                          depArrMatrix,lTAll,Nf,Ng,sigma,WeightE,QTruck,
                                                                          exportPickupNodes,processingTimeExport,Nd,lat_occupancy_shipments,L_trailer)
                        
                        
        
                        (JThisAlt, allDistances, allTravelTimes, offLoadedShipments) = costSolutionNew(fullSetofRoutes,
                                                                                depArrMatrix,distanceMatrix,sigma,
                                                                                FFViolation,GHViolation,weightViolation,TWViolation,DCViolation,
                                                                                wFF,wGH,wW,wTW,wDC,wL,lat_occupancy_shipments,L_trailer,lengthViolation,node_rev,sigmaS)
                        
                        potentialShipment.append(thisShipment)
                        potentialRoutes.append(thisRouteWithAddedShipments)
                        potentialRoutesCost.append(JThisAlt)
                    
                
        if len(potentialRoutes) == 0:
            exitCond = 1
            break
        else:
            idxBestRoute = np.argsort(np.array(potentialRoutesCost))[0]
            thisShipment = potentialShipment[int(idxBestRoute)]
            
            # Remove assigned shipment from list of unassigned shipments
            idxThisShipment = np.where(np.array(updatedUnassignedShipments)==thisShipment)[0][0]
            updatedUnassignedShipments.pop(idxThisShipment)
            
            # Update newly created route
            thisRouteMod = deepcopy(potentialRoutes[int(idxBestRoute)])
            
            #print thisRouteMod
            
    
    newSetOfRoutes = deepcopy(originalRoutes)
    newSetOfRoutes.append(thisRouteMod)    
            
            
        
        
    return thisRouteMod,newSetOfRoutes,updatedUnassignedShipments

################################
def dockOccupancy(SAnewsolution,routesArrDepmatrix,FFSequence,GHSequence,
                 Nf,Ng,Nd):
    
    arrDepGH         = []
    trucksVisitsToGH = [[] for i in range(0,Ng)]
        
    for i in range(0,len(SAnewsolution)):
        thisArrDepGH            = []
        thisSAsolution          = SAnewsolution[i]
        thisGHSequence          = GHSequence[i]
        timeStampsThisRouteHeur = routesArrDepmatrix[i]
        for idxGH in range(0,Ng):
            idxDelThisGh = np.where(np.array(thisGHSequence)==idxGH)[0]
            if len(idxDelThisGh) != 0:
                firstIdx        = idxDelThisGh[0]
                lastIdx         = idxDelThisGh[-1]
                arrivalThisGH   = timeStampsThisRouteHeur[int(len(thisSAsolution)/2+firstIdx),2]
                departureThisGH = timeStampsThisRouteHeur[int(len(thisSAsolution)/2+lastIdx),3]
                firstNode       = thisSAsolution[int(len(thisSAsolution)/2+firstIdx)]
                lastNode        = thisSAsolution[int(len(thisSAsolution)/2+lastIdx)]
                thisArrDepGH.append([arrivalThisGH,departureThisGH,firstNode,lastNode])
                trucksVisitsToGH[idxGH].append(i)
            else:
                thisArrDepGH.append([0,0])
        arrDepGH.append(thisArrDepGH)
        
    timeIntervalsPerGH  = [[] for i in range(0,Ng)]
    numberOfTrucksPerGH = [[] for i in range(0,Ng)]
    IDOfTrucksPerGH     = [[] for i in range(0,Ng)]
    
    for i in range(0,Ng):
        trucksVisitsThisGH   = trucksVisitsToGH[i]
        timeStampsThisGH     = []
        numberOfTrucksThisGH = []
        IDOfTrucksThisGH     = []
        
        for j in range(0,len(trucksVisitsThisGH)):
            timeStampsThisGH.append(arrDepGH[trucksVisitsThisGH[j]][i][0])
            timeStampsThisGH.append(arrDepGH[trucksVisitsThisGH[j]][i][1])
        timeStampsThisGH = np.unique(timeStampsThisGH).tolist()
        timeIntervalsPerGH[i] = timeStampsThisGH
        
        numberOfTrucksThisGH = []
        IDOfTrucksThisGH     = []
        
        for j in range(0,len(timeStampsThisGH)-1):
            lbThisTimeInterval = timeStampsThisGH[j]
            ubThisTimeInterval = timeStampsThisGH[j+1]
            
            numberOfTrucksThisInterval = 0
            IDTrucksThisInterval       = []
            
            for k in range(0,len(trucksVisitsThisGH)):
                if (arrDepGH[trucksVisitsThisGH[k]][i][0] <= lbThisTimeInterval and
                    arrDepGH[trucksVisitsThisGH[k]][i][1] >= ubThisTimeInterval):
                    
                    numberOfTrucksThisInterval += 1
                    IDTrucksThisInterval.append(trucksVisitsThisGH[k])
                        
            numberOfTrucksThisGH.append(numberOfTrucksThisInterval)
            IDOfTrucksThisGH.append(IDTrucksThisInterval)
            
        numberOfTrucksPerGH[i] = numberOfTrucksThisGH
        IDOfTrucksPerGH[i]     = IDOfTrucksThisGH        
        dockCapacityViolation = []
     
    for i in range(0,Ng):
        for j in range(0,len(numberOfTrucksPerGH[i])):
            if numberOfTrucksPerGH[i][j]>Nd[i]:
                timeInterval        = [timeIntervalsPerGH[i][j],timeIntervalsPerGH[i][j+1]]
                trucksInvolved      = IDOfTrucksPerGH[i][j]
                GHCapacityViolation = i
                dockCapacityViolation.append([timeInterval,trucksInvolved,GHCapacityViolation])


    return dockCapacityViolation, arrDepGH, numberOfTrucksPerGH, IDOfTrucksPerGH, timeIntervalsPerGH         


def time_violation_computation(routes,routes_timeStamps,elBounds):
    TWViolation  = 0
    # Cycle over different routes
    for i in range(0,int(len(routes))):
        for j in range(0,int(len(routes_timeStamps[i]))):
            TWViolation += np.max([0,routes_timeStamps[i][j,0]-elBounds[routes[i][j]][1]])
            
    return TWViolation








def forward_slack_computation(r,varMatrix,elMatrix,processingTime,maxRideTime):
    forwardSlackVector = []
    for i in range(0,len(r)):
        Fivec    = []
        for j in range(i,len(r)):
           thisNode = int(r[j])
           if j<len(r)/2:
               if j==i:
                   thisFi = (np.max([0,np.min([elMatrix[thisNode][1]
                   -varMatrix[j][2],maxRideTime[thisNode]])]))
               else:
                   thisFi = (np.sum(varMatrix[i+1:j+1,1])+np.max([0,np.min([elMatrix[thisNode][1]
                   -varMatrix[j][2],maxRideTime[thisNode]])]))
           else:
               if j==i:
                   thisFi = (np.max([0,np.min([elMatrix[thisNode][1]-varMatrix[j][2],maxRideTime[thisNode]-(varMatrix[j][3]-varMatrix[len(r)-j-1][2])])]))
               else:
                   thisFi = (np.sum(varMatrix[i+1:j+1,1])+
                             np.max([0,np.min([elMatrix[thisNode][1]-varMatrix[j][2],
                             maxRideTime[thisNode]-(varMatrix[j][3]-varMatrix[len(r)-j-1][2])])]))

           Fivec.append(thisFi)
        forwardSlackVector.append(np.min(np.array(Fivec)))
        
    return forwardSlackVector


def routes_time_stamps(routes,time_matrix,el_bounds,
                           processing_time,max_ride_time):
    routes_timeStamps = []
    for i in range (0,len(routes)):
        routes_timeStamps.append(cordeauLaporteProcedure(routes[i],time_matrix,el_bounds,
                           processing_time,max_ride_time))
        
    return routes_timeStamps

def route_time_stamps(route,time_matrix,el_bounds,
                           processing_time,max_ride_time):
    route_timeStamps = cordeauLaporteProcedure(route,time_matrix,el_bounds,
                           processing_time,max_ride_time)
        
    return route_timeStamps

def strong_infeasibility(routes,distanceMatrix,time_matrix,routes_timeStamps,sigma,Nf,Ng,pickup_nodes,el_bounds,
                       processing_time,max_ride_time,q_nodes,truck_weight_capacity,
                       L_trailer,lat_occupancy_shipments,nDocks):
    # First, check if the solution is strongly infeasible
    # Determine feasibility of FF sequence
    FFSequence = []
    for i in range(0,len(routes)):
        thisFFSequence=[]
        for idxPickup in range(1,int(len(routes[i])/2)+1):
            for idxFF in range(0,Nf):
                for idxGH in range(0,Ng):
                    if routes[i][idxPickup] in pickup_nodes[idxFF][idxGH]:
                        thisFFSequence.append(idxFF)                            
        FFSequence.append(thisFFSequence)

    isFFSequenceFeasible = 1
    for i in range(0,len(FFSequence)):
        thisFFSequence = FFSequence[i]
        for idxFF in range(0,Nf):
            idxPickupThisFF = np.where(np.array(thisFFSequence)==idxFF)[0] 
            diff         = []
            for zz in range(0,len(idxPickupThisFF)-1):
                diff.append(idxPickupThisFF[zz+1]-idxPickupThisFF[zz])
            if len(np.where(np.array(diff)!=1)[0]) != 0:
                isFFSequenceFeasible = 0
                break

    # Determine feasibility of GH sequence
    GHSequence = []
    for i in range(0,len(routes)):
        thisGHSequence = []
        for idxDel in range(int((len(routes[i])/2)),int(len(routes[i]))):
            for idxFF in range(0,Nf):
                for idxGH in range(0,Ng):
                    if routes[i][idxDel]-sigma in pickup_nodes[idxFF][idxGH]:
                        thisGHSequence.append(idxGH)
        GHSequence.append(thisGHSequence)    

    isGHSequenceFeasible = 1
    for i in range(0,len(GHSequence)):        
        thisGHSequence = GHSequence[i]
        for idxGH in range(0,Ng):
            idxDelThisGh = np.where(np.array(thisGHSequence)==idxGH)[0]
            diff         = []
            for zz in range(0,len(idxDelThisGh)-1):
                diff.append(idxDelThisGh[zz+1]-idxDelThisGh[zz])                
            if len(np.where(np.array(diff)!=1)[0]) != 0:
                isGHSequenceFeasible = 0
                break

    
    # Check maximum weight of each route
    isSolutionWeightFeasible = 1 
    for i in range(0,len(routes)):
        weightThisRoute      = 0
        pickupNodesThisRoute = routes[i][1:int(len(routes[i])/2)]
        for j in range(0,len(pickupNodesThisRoute)):
            weightThisRoute += q_nodes[pickupNodesThisRoute[j]-1]
        if weightThisRoute > truck_weight_capacity:
            isSolutionWeightFeasible = 0
    
    # Check if trailer overall length is exceeded
    isSolutionLengthFeasible = 1 
    for i in range(0,len(routes)):
        lengthThisRoute      = 0
        pickupNodesThisRoute = routes[i][1:int(len(routes[i])/2)]
        for j in range(0,len(pickupNodesThisRoute)):
            lengthThisRoute += lat_occupancy_shipments[pickupNodesThisRoute[j]-1]
        if lengthThisRoute > L_trailer:
            isSolutionWeightFeasible = 0
            
    # Check time window feasibility
    is_TW_feasible = 1
    routes_time_matrix = []
    for i in range (0,len(routes)):
        routes_time_matrix.append(cordeauLaporteProcedure(routes[i],time_matrix,el_bounds,
                           processing_time,max_ride_time))

    # Cycle over different routes
    for i in range (0,len(routes)): 
        for j in range(0,len(routes[i])):
            if routes_time_matrix[i][j,2]>el_bounds[routes[i][j]][1]:
                is_TW_feasible = 0
                break
    
    # Solution is strongly infeasible. No time shifting recovery action
    # can be taken to make the solution feasible
    if (isGHSequenceFeasible*isFFSequenceFeasible*isSolutionWeightFeasible
          *isSolutionLengthFeasible*is_TW_feasible) == 0:
        strongly_infeasible = 1
    else:
        strongly_infeasible = 0
        
    return strongly_infeasible, FFSequence, GHSequence

def single_route_strong_infeasibility(route,distanceMatrix,time_matrix,sigma,Nf,Ng,pickup_nodes,el_bounds,
                       processing_time,max_ride_time,q_nodes,truck_weight_capacity,
                       L_trailer,lat_occupancy_shipments,nDocks):
    # First, check if the solution is strongly infeasible
    # Determine feasibility of FF sequence
    thisFFSequence = []
    for idxPickup in range(1,int(len(route)/2)+1):
            for idxFF in range(0,Nf):
                for idxGH in range(0,Ng):
                    if route[idxPickup] in pickup_nodes[idxFF][idxGH]:
                        thisFFSequence.append(idxFF) 

    isFFSequenceFeasible = 1
    for idxFF in range(0,Nf):
        idxPickupThisFF = np.where(np.array(thisFFSequence)==idxFF)[0] 
        diff         = []
        for zz in range(0,len(idxPickupThisFF)-1):
            diff.append(idxPickupThisFF[zz+1]-idxPickupThisFF[zz])
        if len(np.where(np.array(diff)!=1)[0]) != 0:
            isFFSequenceFeasible = 0
            break

    # Determine feasibility of GH sequence
    thisGHSequence = []
    for idxDel in range(int((len(route)/2)),int(len(route))):
        for idxFF in range(0,Nf):
            for idxGH in range(0,Ng):
                if route[idxDel]-sigma in pickup_nodes[idxFF][idxGH]:
                    thisGHSequence.append(idxGH)    

    isGHSequenceFeasible = 1
    for idxGH in range(0,Ng):
        idxDelThisGh = np.where(np.array(thisGHSequence)==idxGH)[0]
        diff         = []
        for zz in range(0,len(idxDelThisGh)-1):
            diff.append(idxDelThisGh[zz+1]-idxDelThisGh[zz])                
        if len(np.where(np.array(diff)!=1)[0]) != 0:
            isGHSequenceFeasible = 0
            break

    
    # Check maximum weight of each route
    isSolutionWeightFeasible = 1 
    weightThisRoute      = 0
    pickupNodesThisRoute = route[1:int(len(route)/2)]
    for j in range(0,len(pickupNodesThisRoute)):
        weightThisRoute += q_nodes[pickupNodesThisRoute[j]-1]
    if weightThisRoute > truck_weight_capacity:
        isSolutionWeightFeasible = 0
    
    # Check if trailer overall length is exceeded
    isSolutionLengthFeasible = 1 
    lengthThisRoute      = 0
    pickupNodesThisRoute = route[1:int(len(route)/2)]
    for j in range(0,len(pickupNodesThisRoute)):
        lengthThisRoute += lat_occupancy_shipments[pickupNodesThisRoute[j]-1]
    if lengthThisRoute > L_trailer:
        isSolutionWeightFeasible = 0
        
    # Check time window feasibility
    is_TW_feasible = 1
    routes_time_matrix = cordeauLaporteProcedure(route,time_matrix,el_bounds,
                           processing_time,max_ride_time)

    for j in range(0,len(route)):
        if routes_time_matrix[j,2]>el_bounds[route[j]][1]:
            is_TW_feasible = 0
            break
    
    # Solution is strongly infeasible. No time shifting recovery action
    # can be taken to make the solution feasible
    if (isGHSequenceFeasible*isFFSequenceFeasible*isSolutionWeightFeasible
          *isSolutionLengthFeasible*is_TW_feasible) == 0:
        strongly_infeasible = 1
    else:
        strongly_infeasible = 0
        
    return strongly_infeasible

def cost_strongly_infeasible_solution(alpha,beta,gamma,multiplier,cost_distance,cost_time,
                                      routes,routes_timeStamps,distanceMatrix,sigma,node_rev,sigmaS):
    
    
    totalDistance      = 0
    totalTime          = 0
    loadedShipments    = 0
    offLoadedShipments = 0
    allDistances       = []
    allTravelTimes     = []
    
    allRoutesRev = 0
    for i in range(0,len(routes)):
        thisRoute                = routes[i]
        loadedShipmentsThisRoute = len(thisRoute[1:int(len(thisRoute)/2)])
        distanceThisRoute        = 0
        for j in range(0,len(thisRoute)-1):
            distanceThisRoute += distanceMatrix[thisRoute[j]][thisRoute[j+1]]
        timeThisRoute   = routes_timeStamps[i][len(routes_timeStamps[i])-1,3]-routes_timeStamps[i][0,3]
        totalDistance   += distanceThisRoute
        totalTime       += timeThisRoute
        loadedShipments += loadedShipmentsThisRoute
        allDistances.append(distanceThisRoute)
        allTravelTimes.append(timeThisRoute)

        # Revenue added by Sanne
        #print('node_rev',node_rev)
        #print('thisRoute', thisRoute)
        routeRev = 0
        for k in range(1,int(len(thisRoute)/2)):
            #print('k',k)
            #print('thisRoute[k]', thisRoute[k])
            routeRev += node_rev[thisRoute[k]-1][0]
            #print('rev',node_rev[thisRoute[k]-1][0])
        allRoutesRev += routeRev
       
    offLoadedShipments = sigmaS-loadedShipments
    
    J = multiplier*(alpha*offLoadedShipments+beta*cost_distance*totalDistance+gamma*cost_time*totalTime-allRoutesRev)
    
    return J, allDistances, allTravelTimes, offLoadedShipments



def cost_weakly_infeasible_solution(alpha,beta,gamma,cost_distance,cost_time,
                                      routes,routes_timeStamps,distanceMatrix,sigma,TW_violation,DC_violation,w_TW,w_DC,node_rev,sigmaS):
    
    
    totalDistance      = 0
    totalTime          = 0
    loadedShipments    = 0
    offLoadedShipments = 0
    allDistances       = []
    allTravelTimes     = []
    
    allRoutesRev = 0
    for i in range(0,len(routes)):
        thisRoute                = routes[i]
        loadedShipmentsThisRoute = len(thisRoute[1:int(len(thisRoute)/2)])
        distanceThisRoute        = 0
        for j in range(0,int(len(thisRoute)-1)):
            distanceThisRoute += distanceMatrix[thisRoute[j]][thisRoute[j+1]]
        timeThisRoute   = routes_timeStamps[i][int(len(routes_timeStamps[i])-1),3]-routes_timeStamps[i][0,3]
        totalDistance   += distanceThisRoute
        totalTime       += timeThisRoute
        loadedShipments += loadedShipmentsThisRoute
        allDistances.append(distanceThisRoute)
        allTravelTimes.append(timeThisRoute)
        #print('timeThisRoute',timeThisRoute)
        # Revenue added by Sanne
        #print('node_rev',node_rev)
        #print('thisRoute', thisRoute)
        routeRev = 0
        for k in range(1,int(len(thisRoute)/2)):
            #print('k',k)
            #print('thisRoute[k]', thisRoute[k])
            routeRev += node_rev[thisRoute[k]-1][0]
            #print('rev',node_rev[thisRoute[k]-1][0])
        allRoutesRev += routeRev
    #print('totalTime',totalTime)    
    offLoadedShipments = sigmaS-loadedShipments

    #print('total_distance, *cost',totalDistance, cost_distance*totalDistance)
    #print('total_time, *cost',totalTime, cost_time*totalTime)
    J = (alpha*offLoadedShipments+beta*cost_distance*totalDistance+gamma*cost_time*totalTime
         +w_TW*cost_time*TW_violation+w_DC*cost_time*DC_violation)#-allRoutesRev)
    
    return J, allDistances, allTravelTimes, offLoadedShipments

    
def dock_capacity_violation(routes,routes_timeStamps,FFSequence,GHSequence,
                 Nf,Ng,Nd):
    
    #calculate the dock capacity constraint    
    arrDepGH         = []
    trucksVisitsToGH = [[] for i in range(0,Ng)]
        
    for i in range(0,len(routes)):
        thisArrDepGH            = []
        this_route              = routes[i]
        thisGHSequence          = GHSequence[i]
        timeStampsThisRouteHeur = routes_timeStamps[i]
        
        #print(this_route)
        #print(timeStampsThisRouteHeur)
        #print(thisGHSequence)
        
        for idxGH in range(0,Ng):
            idxDelThisGh = np.where(np.array(thisGHSequence)==idxGH)[0]
            
            #print(idxDelThisGh)
            
            if len(idxDelThisGh) != 0:
                firstIdx        = idxDelThisGh[0]
                lastIdx         = idxDelThisGh[-1] 
                arrivalThisGH   = timeStampsThisRouteHeur[int(len(this_route)/2+firstIdx),2]
                departureThisGH = timeStampsThisRouteHeur[int(len(this_route)/2+lastIdx),3]
                firstNode       = this_route[int(len(this_route)/2+firstIdx)]
                lastNode        = this_route[int(len(this_route)/2+lastIdx)]
                thisArrDepGH.append([arrivalThisGH,departureThisGH,firstNode,lastNode])
                trucksVisitsToGH[idxGH].append(i)
            else:
                thisArrDepGH.append([0,0])
        arrDepGH.append(thisArrDepGH)
        
    timeIntervalsPerGH  = [[] for i in range(0,Ng)]
    numberOfTrucksPerGH = [[] for i in range(0,Ng)]
    IDOfTrucksPerGH     = [[] for i in range(0,Ng)]
    
    for i in range(0,Ng):
        trucksVisitsThisGH   = trucksVisitsToGH[i]
        timeStampsThisGH     = []
        numberOfTrucksThisGH = []
        IDOfTrucksThisGH     = []
        
        for j in range(0,len(trucksVisitsThisGH)):
            timeStampsThisGH.append(arrDepGH[trucksVisitsThisGH[j]][i][0])
            timeStampsThisGH.append(arrDepGH[trucksVisitsThisGH[j]][i][1])
        timeStampsThisGH = np.unique(timeStampsThisGH).tolist()
        timeIntervalsPerGH[i] = timeStampsThisGH
        
        numberOfTrucksThisGH = []
        IDOfTrucksThisGH     = []
        
        for j in range(0,len(timeStampsThisGH)-1):
            lbThisTimeInterval = timeStampsThisGH[j]
            ubThisTimeInterval = timeStampsThisGH[j+1]
            
            numberOfTrucksThisInterval = 0
            IDTrucksThisInterval       = []
            
            for k in range(0,len(trucksVisitsThisGH)):
                if (arrDepGH[trucksVisitsThisGH[k]][i][0] <= lbThisTimeInterval and
                    arrDepGH[trucksVisitsThisGH[k]][i][1] >= ubThisTimeInterval):
                    
                    numberOfTrucksThisInterval += 1
                    IDTrucksThisInterval.append(trucksVisitsThisGH[k])
                        
            numberOfTrucksThisGH.append(numberOfTrucksThisInterval)
            IDOfTrucksThisGH.append(IDTrucksThisInterval)
            
        numberOfTrucksPerGH[i] = numberOfTrucksThisGH
        IDOfTrucksPerGH[i]     = IDOfTrucksThisGH        
        dockCapacityViolation = []
     
    for i in range(0,Ng):
        for j in range(0,len(numberOfTrucksPerGH[i])):
            if numberOfTrucksPerGH[i][j]>Nd[i]:
                timeInterval        = [timeIntervalsPerGH[i][j],timeIntervalsPerGH[i][j+1]]
                trucksInvolved      = IDOfTrucksPerGH[i][j]
                GHCapacityViolation = i
                dockCapacityViolation.append([timeInterval,trucksInvolved,GHCapacityViolation])
    
    startTimeDockCapViol = []
    for i in range(0,len(dockCapacityViolation)):
        startTimeDockCapViol.append(dockCapacityViolation[i][0][0])

    return dockCapacityViolation, arrDepGH, numberOfTrucksPerGH



###
###
def dock_capacity_violation_resolver_only(routes,routes_timeStamps,timeMatrix,elBounds,processing_time,maxRideTime,
                                     dockCapacityViolation,arrDepGH,FFSequence,GHSequence,Nf,Ng,nDocks):
    numberOfTrucksPerGH = [[] for i in range(0,Ng)]
    forwardSlackAllRoutes = []
    for i in range(0,len(routes)):
        forwardSlackAllRoutes.append(forward_slack_computation(routes[i],routes_timeStamps[i],elBounds,processing_time,maxRideTime))
    
    allTimeShifts         = []
    maxAllowedTWViolation = 100
    
    cont = 0
    while len(dockCapacityViolation)!=0 and cont<=50:
        
        startTimeDockCapViol = []
        for i in range(0,len(dockCapacityViolation)):
            startTimeDockCapViol.append(dockCapacityViolation[i][0][0])
        
        # Find first dock capacity violation
        index, value = min(enumerate(startTimeDockCapViol), key=operator.itemgetter(1))
        
        #print 'First violation occurs at ' + str(value) + ' minute in GH ' + str(dockCapacityViolation2[index][2])
        
        # ID of GH where this violation occurs
        thisGHIdx     = dockCapacityViolation[index][2]
        # Identify which trucks cause the violation 
        arrivalTimesGH   = []
        departureTimesGH = []
        firstNodeGH      = []
        for i in range(0,len(dockCapacityViolation[index][1])):
            arrivalTimesGH.append(arrDepGH[dockCapacityViolation[index][1][i]][thisGHIdx][0])
            departureTimesGH.append(arrDepGH[dockCapacityViolation[index][1][i]][thisGHIdx][1])
            firstNodeGH.append(arrDepGH[dockCapacityViolation[index][1][i]][thisGHIdx][2])
        # For each truck involved in the capacity violation, compute
        # the quantity max(Slack-Shift,0), which quantifies the slack left
        # if that truck is delayed to alleviate the dock capacity violation.
        # We in fact decide to delay the truck for which the difference between
        # the slack and the necessary shift, i.e., the residual slack, is maximum.
        # This means that the truck we delay is the one where the effect of the
        # delay is "smaller", in the sense that the residual slack is still the largest
        slackMinusShift = []
        shiftRoutes     = []
        idxNodeRoutes   = []
        for i in range(0,len(dockCapacityViolation[index][1])):
            idxNodeInRoute = np.where(np.array(routes[dockCapacityViolation[index][1][i]])==firstNodeGH[i])[0][0]
            idxNodeRoutes.append(idxNodeInRoute)
            
            indexArrTruck = dockCapacityViolation[index][1][i]
            idxOtherRoutesInCongestedGH = [item for item in dockCapacityViolation[index][1] if item not in [indexArrTruck]]
            
            # Store the departure time of all the other trucks docked at this GH
            otherTrucksDepartureTime = []
            for j in range(0,len(idxOtherRoutesInCongestedGH)):
                otherTrucksDepartureTime.append(arrDepGH[idxOtherRoutesInCongestedGH[j]][thisGHIdx][1])
            
            # Compute time-shift for current truck (how many minutes the truck
            # must be pushed back to solve dock capacity violation)
            timeShift = np.min(np.array(otherTrucksDepartureTime))-arrDepGH[indexArrTruck][thisGHIdx][0]

            shiftRoutes.append(timeShift)
            
            # Compute slack minus time-shift. if the difference is negative, set it to 0.
            # A slack minus time-shift = 0 means that applying the associated time-shift
            # will increase the time-window violation in the current route
            slackMinusShift.append(np.max([0,forwardSlackAllRoutes[dockCapacityViolation[index][1][i]][idxNodeInRoute]-
                               timeShift]))
        #print 'SlackMinusShift vector is :'
        #print slackMinusShift
        # Determine truck to be delayed and update its time variable matrix.
        # The truck to be delayed is the one where slackMinusShift is max
        indexTruck, slackMinusShiftTruck = max(enumerate(slackMinusShift), key=operator.itemgetter(1))
        
        #if slackMinusShiftTruck>0:
        if 1==1:
            
            truckIdx          = dockCapacityViolation[index][1][indexTruck]
            thisTimeShift     = shiftRoutes[indexTruck]
            idxNodeApplyShift = idxNodeRoutes[indexTruck]
            allTimeShifts.append(thisTimeShift)
            
            routes_timeStamps[truckIdx][idxNodeApplyShift][2] += thisTimeShift
            routes_timeStamps[truckIdx][idxNodeApplyShift][3] += thisTimeShift
            #routes_timeStamps[truckIdx][idxNodeApplyShift][1]  = np.max([routes_timeStamps[truckIdx][idxNodeApplyShift][2]-
            #                                                             routes_timeStamps[truckIdx][idxNodeApplyShift][0],0])
            
            # For all nodes from the first node of the ground
            # handler where the violation has been resolved onwards, shift
            # time forward (note that the time-shift could be different w.r.t.
            # the time-shift of the nodes before)
            for j in range(idxNodeApplyShift+1,len(routes_timeStamps[truckIdx])):
                thisNode        = int(routes[truckIdx][j])
                
                routes_timeStamps[truckIdx][j][0] = routes_timeStamps[truckIdx][j-1][3]+timeMatrix[routes[truckIdx][j-1]][thisNode]
                routes_timeStamps[truckIdx][j][1] = np.max([elBounds[thisNode][0]-routes_timeStamps[truckIdx][j][0],0])
                routes_timeStamps[truckIdx][j][2] = routes_timeStamps[truckIdx][j][0]+routes_timeStamps[truckIdx][j][1]
                routes_timeStamps[truckIdx][j][3] = routes_timeStamps[truckIdx][j][2]+processing_time[thisNode]
                routes_timeStamps[truckIdx][j][4] = maxRideTime[thisNode-1]
             
            # Re-compute dock-capacity violations
            dockCapacityViolation,arrDepGH,numberOfTrucksPerGH = dock_capacity_violation(routes,
                                                                    routes_timeStamps,FFSequence,GHSequence,
                                                                    Nf,Ng,nDocks)
            TWViolation = time_violation_computation(routes,routes_timeStamps,elBounds)
            
            print('TWViolation',TWViolation)
            #print('routes_timeStamps',routes_timeStamps)
            # Note 1: the code should be slightly changed so that, if TW>0, we output
            # the solution prior to the last change. In fact, if we break che code here,
            # now what we obtain is a solution where TW have been violated
            # Note 2: we assume that initially TWViolation=0, otherwise the code would break 
            # immediately. An alternative is to determine the initial TW
            # TWInitial, and break the code if TWCurrent > TWInitial (i.e.,
            # we keep modifying a solution tat does not satify time-windows as long as 
            # we are not increasing the TW violation)
            #break

            if TWViolation > maxAllowedTWViolation:
                break
    
            cont += 1
            
            # If there are no more dock capacity violations, break the code
            if len(dockCapacityViolation) == 0:
                pass
                print('All dock capacity violations were resolved!!!')
            
            #print '%%%%%%%%%%%%%%%%%%%%'
            #print '%%%%%%%%%%%%%%%%%%%%' 
            #print '%%%%%%%%%%%%%%%%%%%%'
        
        # We cannot delay any of the trucks involved without worsening the
        # TW violation
        else:
            print('%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%')
            print('%%% Stop: we would increase TW violation otherwise %%%')
            print('%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%')
            
            break

    return routes,routes_timeStamps,dockCapacityViolation,arrDepGH,numberOfTrucksPerGH 


###
###


def dock_capacity_violation_resolver(routes,routes_timeStamps,timeMatrix,elBounds,processing_time,maxRideTime,
                                     dockCapacityViolation,arrDepGH,FFSequence,GHSequence,Nf,Ng,nDocks):
    numberOfTrucksPerGH = [[] for i in range(0,Ng)]
    forwardSlackAllRoutes = []
    for i in range(0,len(routes)):
        forwardSlackAllRoutes.append(forward_slack_computation(routes[i],routes_timeStamps[i],elBounds,processing_time,maxRideTime))
    
    allTimeShifts         = []
    maxAllowedTWViolation = 100
    
    cont = 0
    while len(dockCapacityViolation)!=0 and cont<=50:
        
        startTimeDockCapViol = []
        for i in range(0,len(dockCapacityViolation)):
            startTimeDockCapViol.append(dockCapacityViolation[i][0][0])
        
        # Find first dock capacity violation
        index, value = min(enumerate(startTimeDockCapViol), key=operator.itemgetter(1))
        
        #print 'First violation occurs at ' + str(value) + ' minute in GH ' + str(dockCapacityViolation2[index][2])
        
        # ID of GH where this violation occurs
        thisGHIdx     = dockCapacityViolation[index][2]
        # Identify which trucks cause the violation 
        arrivalTimesGH   = []
        departureTimesGH = []
        firstNodeGH      = []
        for i in range(0,len(dockCapacityViolation[index][1])):
            arrivalTimesGH.append(arrDepGH[dockCapacityViolation[index][1][i]][thisGHIdx][0])
            departureTimesGH.append(arrDepGH[dockCapacityViolation[index][1][i]][thisGHIdx][1])
            firstNodeGH.append(arrDepGH[dockCapacityViolation[index][1][i]][thisGHIdx][2])
        # For each truck involved in the capacity violation, compute
        # the quantity max(Slack-Shift,0), which quantifies the slack left
        # if that truck is delayed to alleviate the dock capacity violation.
        # We in fact decide to delay the truck for which the difference between
        # the slack and the necessary shift, i.e., the residual slack, is maximum.
        # This means that the truck we delay is the one where the effect of the
        # delay is "smaller", in the sense that the residual slack is still the largest
        slackMinusShift = []
        shiftRoutes     = []
        idxNodeRoutes   = []
        for i in range(0,len(dockCapacityViolation[index][1])):
            idxNodeInRoute = np.where(np.array(routes[dockCapacityViolation[index][1][i]])==firstNodeGH[i])[0][0]
            idxNodeRoutes.append(idxNodeInRoute)
            
            indexArrTruck = dockCapacityViolation[index][1][i]
            idxOtherRoutesInCongestedGH = [item for item in dockCapacityViolation[index][1] if item not in [indexArrTruck]]
            
            # Store the departure time of all the other trucks docked at this GH
            otherTrucksDepartureTime = []
            for j in range(0,len(idxOtherRoutesInCongestedGH)):
                otherTrucksDepartureTime.append(arrDepGH[idxOtherRoutesInCongestedGH[j]][thisGHIdx][1])
            
            # Compute time-shift for current truck (how many minutes the truck
            # must be pushed back to solve dock capacity violation)
            timeShift = np.min(np.array(otherTrucksDepartureTime))-arrDepGH[indexArrTruck][thisGHIdx][0]

            shiftRoutes.append(timeShift)
            
            # Compute slack minus time-shift. if the difference is negative, set it to 0.
            # A slack minus time-shift = 0 means that applying the associated time-shift
            # will increase the time-window violation in the current route
            slackMinusShift.append(np.max([0,forwardSlackAllRoutes[dockCapacityViolation[index][1][i]][idxNodeInRoute]-
                               timeShift]))
        #print 'SlackMinusShift vector is :'
        #print slackMinusShift
        # Determine truck to be delayed and update its time variable matrix.
        # The truck to be delayed is the one where slackMinusShift is max
        indexTruck, slackMinusShiftTruck = max(enumerate(slackMinusShift), key=operator.itemgetter(1))
        
        if slackMinusShiftTruck>0:
            
            truckIdx          = dockCapacityViolation[index][1][indexTruck]
            thisTimeShift     = shiftRoutes[indexTruck]
            idxNodeApplyShift = idxNodeRoutes[indexTruck]
            allTimeShifts.append(thisTimeShift)
            
            routes_timeStamps[truckIdx][idxNodeApplyShift][2] += thisTimeShift
            routes_timeStamps[truckIdx][idxNodeApplyShift][3] += thisTimeShift
            #routes_timeStamps[truckIdx][idxNodeApplyShift][1]  = np.max([routes_timeStamps[truckIdx][idxNodeApplyShift][2]-
            #                                                             routes_timeStamps[truckIdx][idxNodeApplyShift][0],0])
            
            # For all nodes from the first node of the ground
            # handler where the violation has been resolved onwards, shift
            # time forward (note that the time-shift could be different w.r.t.
            # the time-shift of the nodes before)
            for j in range(idxNodeApplyShift+1,len(routes_timeStamps[truckIdx])):
                thisNode        = int(routes[truckIdx][j])
                
                routes_timeStamps[truckIdx][j][0] = routes_timeStamps[truckIdx][j-1][3]+timeMatrix[routes[truckIdx][j-1]][thisNode]
                routes_timeStamps[truckIdx][j][1] = np.max([elBounds[thisNode][0]-routes_timeStamps[truckIdx][j][0],0])
                routes_timeStamps[truckIdx][j][2] = routes_timeStamps[truckIdx][j][0]+routes_timeStamps[truckIdx][j][1]
                routes_timeStamps[truckIdx][j][3] = routes_timeStamps[truckIdx][j][2]+processing_time[thisNode]
                routes_timeStamps[truckIdx][j][4] = maxRideTime[thisNode-1]
             
            # Re-compute dock-capacity violations
            dockCapacityViolation,arrDepGH,numberOfTrucksPerGH = dock_capacity_violation(routes,
                                                                    routes_timeStamps,FFSequence,GHSequence,
                                                                    Nf,Ng,nDocks)
            TWViolation = time_violation_computation(routes,routes_timeStamps,elBounds)
            

            
            # Note 1: the code should be slightly changed so that, if TW>0, we output
            # the solution prior to the last change. In fact, if we break che code here,
            # now what we obtain is a solution where TW have been violated
            # Note 2: we assume that initially TWViolation=0, otherwise the code would break 
            # immediately. An alternative is to determine the initial TW
            # TWInitial, and break the code if TWCurrent > TWInitial (i.e.,
            # we keep modifying a solution tat does not satify time-windows as long as 
            # we are not increasing the TW violation)
            if TWViolation > maxAllowedTWViolation:
                break
    
            cont += 1
            
            # If there are no more dock capacity violations, break the code
            if len(dockCapacityViolation) == 0:
                pass
                print('All dock capacity violations were resolved!!!')
            
            #print '%%%%%%%%%%%%%%%%%%%%'
            #print '%%%%%%%%%%%%%%%%%%%%' 
            #print '%%%%%%%%%%%%%%%%%%%%'
        
        # We cannot delay any of the trucks involved without worsening the
        # TW violation
        else:
            print('%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%')
            print('%%% Stop: we would increase TW violation otherwise %%%')
            print('%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%')
            
            break
    
    ############################################################
    ### Route overall transportation time reduction routine  ###
    ############################################################
    # Detect where we have possible delays, i.e., where A[j]+W[j]<B[j], which 
    # means that we introduced an additional delay in the route because of a
    # dock capacity violation
    possibleUnnecessaryDelays = []
    for i in range(0,len(routes_timeStamps)):
        thisGHSequence    = GHSequence[i]
        uniqueGHSequence  = list(OrderedDict.fromkeys(thisGHSequence))
        thisTimeVarMatrix = routes_timeStamps[i]
        for j in range(int(len(thisTimeVarMatrix)/2),int(len(thisTimeVarMatrix))):
            if thisTimeVarMatrix[j,2]>thisTimeVarMatrix[j,0]+thisTimeVarMatrix[j,1]:
                
                # Determine if it is the first, second, third GH visited and
                # if the node where service is delayed is the first, second,
                # third in the GH (it should always be the first one, since
                # if we delay the service because a dock is not available, we
                # are affecting the service time of the first shipment in the
                # current GH)
                
                idxGH                  = np.where(np.array(uniqueGHSequence)==thisGHSequence[j-int(len(thisTimeVarMatrix)/2)])[0][0]
                idxFirstShipmentThisGH = np.where(np.array(thisGHSequence)==thisGHSequence[j-int(len(thisTimeVarMatrix)/2)])[0][0]
                idxShipmentInGH        = j-int(len(thisTimeVarMatrix)/2)-idxFirstShipmentThisGH
                
                # If shipment is the first one in current GH
                if idxShipmentInGH == 0:
                    possibleUnnecessaryDelays.append([i,thisGHSequence[j-int(len(thisTimeVarMatrix)/2)],idxGH,idxShipmentInGH,
                               thisTimeVarMatrix[j,2]-(thisTimeVarMatrix[j,0]+thisTimeVarMatrix[j,1]),                 
                               thisTimeVarMatrix[j,0],thisTimeVarMatrix[j,1],
                               thisTimeVarMatrix[j,2],thisTimeVarMatrix[j,3],j])
    
    # Sort the cases where A[j]+W[j]<B[j] by increasing value of time          
    startServiceTime = []
    for i in range(0,len(possibleUnnecessaryDelays)):            
        startServiceTime.append(possibleUnnecessaryDelays[i][5])
    
    idxStartServiceTimeSrt = sorted(range(len(startServiceTime)), key=lambda k: startServiceTime[k], reverse=False)
    
    
    # Try to shift forward departure time of trucks that were delayed at the
    # ground handler side (if possible), to reduce the overall transportation time
    for cont in range(0,len(possibleUnnecessaryDelays)):
        
        dockA,dockB,dockC,dockD,dockE = dockOccupancy(routes,routes_timeStamps,FFSequence,GHSequence,
                         Nf,Ng,nDocks)
        
        
        idxFirst = idxStartServiceTimeSrt[cont]
            
        firstDelayRoute         = possibleUnnecessaryDelays[idxFirst][0] 
        firstDelayIdxGH         = possibleUnnecessaryDelays[idxFirst][2]
        firstDelayExtraTime     = possibleUnnecessaryDelays[idxFirst][4]
        positionShipmentInRoute = possibleUnnecessaryDelays[idxFirst][9] 
        
        # If the ground handler is the first one visited, we do not need to check
        # what happens in previous ground handlers. We compare how much we would 
        # need to delay the departure, with the minimum slack before visiting the 
        # current ground handler. The minimum value between the two values is used
        # to shift the route forward in time
        if firstDelayIdxGH == 0:
            forwardSlack    = forward_slack_computation(routes[firstDelayRoute],routes_timeStamps[firstDelayRoute],
                                                   elBounds,processing_time,maxRideTime)
            minSlack        = np.min(np.array(forwardSlack[0:positionShipmentInRoute+1]))
            admissibleShift = np.min([minSlack,firstDelayExtraTime])
            
            routes_timeStamps[firstDelayRoute][0][2] += admissibleShift
            routes_timeStamps[firstDelayRoute][0][3] += admissibleShift
            for j in range(1,positionShipmentInRoute):
                thisNode        = int(routes[firstDelayRoute][j])
                routes_timeStamps[firstDelayRoute][j][0] = routes_timeStamps[firstDelayRoute][j-1][3]+timeMatrix[routes[firstDelayRoute][j-1]][thisNode]
                routes_timeStamps[firstDelayRoute][j][1] = np.max([elBounds[thisNode][0]-routes_timeStamps[firstDelayRoute][j][0],0])
                routes_timeStamps[firstDelayRoute][j][2] = routes_timeStamps[firstDelayRoute][j][0]+routes_timeStamps[firstDelayRoute][j][1]
                routes_timeStamps[firstDelayRoute][j][3] = routes_timeStamps[firstDelayRoute][j][2]+processing_time[thisNode]
                routes_timeStamps[firstDelayRoute][j][4] = maxRideTime[thisNode] 
            thisNode = int(routes[firstDelayRoute][positionShipmentInRoute])
            #timeVarMatrixRoutes[firstDelayRoute][positionShipmentInRoute][0] = timeVarMatrixRoutes[firstDelayRoute][j-1][3]+timeMatrix[newSetOfRoutes[firstDelayRoute][positionShipmentInRoute-1]][newSetOfRoutes[firstDelayRoute][positionShipmentInRoute]]    
            routes_timeStamps[firstDelayRoute][positionShipmentInRoute][0] += admissibleShift
        # Otherwise, we also need to verify what happens in the previous ground
        # handlers that are visited to avoid the creation of new unplanned
        # dock capacity violations upstream
        else:
            thisGHSequence    = GHSequence[firstDelayRoute]
            uniqueGHSequence  = list(OrderedDict.fromkeys(thisGHSequence))
            maxDelayPreviousGHs = []
            for ii in range(0,firstDelayIdxGH):
                thisGH             = uniqueGHSequence[ii]
                idxThisRouteThisGH = []
                for jj in range(0,len(dockD[thisGH])):
                    if firstDelayRoute in dockD[thisGH][jj]:
                        idxThisRouteThisGH.append(jj)
                lastIdx = idxThisRouteThisGH[-1]
                finalServiceTime = dockE[thisGH][lastIdx+1]
                firstPotentialIndex = lastIdx+1
                while firstPotentialIndex<len(dockD[thisGH])-1:
                    if len(dockD[thisGH][firstPotentialIndex]) <= nDocks[thisGH]-1:
                        firstPotentialIndex += 1
                    else:
                        break
                maxDelayPreviousGHs.append(dockE[thisGH][firstPotentialIndex]-finalServiceTime)
            
            maxAdmissibleDelayPreviousGH = np.min(maxDelayPreviousGHs)
            
            forwardSlack    = forward_slack_computation(routes[firstDelayRoute],routes_timeStamps[firstDelayRoute],
                                                   elBounds,processing_time,maxRideTime)
            minSlack        = forwardSlack[0]
            
            admissibleShift = np.min([minSlack,firstDelayExtraTime,maxAdmissibleDelayPreviousGH])
            
            routes_timeStamps[firstDelayRoute][0][2] += admissibleShift
            routes_timeStamps[firstDelayRoute][0][3] += admissibleShift
            for j in range(1,positionShipmentInRoute):
                thisNode        = int(routes[firstDelayRoute][j])
                routes_timeStamps[firstDelayRoute][j][0] = routes_timeStamps[firstDelayRoute][j-1][3]+timeMatrix[routes[firstDelayRoute][j-1]][thisNode]
                routes_timeStamps[firstDelayRoute][j][1] = np.max([elBounds[thisNode][0]-routes_timeStamps[firstDelayRoute][j][0],0])
                routes_timeStamps[firstDelayRoute][j][2] = routes_timeStamps[firstDelayRoute][j][0]+routes_timeStamps[firstDelayRoute][j][1]
                routes_timeStamps[firstDelayRoute][j][3] = routes_timeStamps[firstDelayRoute][j][2]+processing_time[thisNode]
                routes_timeStamps[firstDelayRoute][j][4] = maxRideTime[thisNode] 
            thisNode = int(routes[firstDelayRoute][positionShipmentInRoute])
            #timeVarMatrixRoutes[firstDelayRoute][positionShipmentInRoute][0] = timeVarMatrixRoutes[firstDelayRoute][j-1][3]+timeMatrix[newSetOfRoutes[firstDelayRoute][positionShipmentInRoute-1]][newSetOfRoutes[firstDelayRoute][positionShipmentInRoute]]    
            routes_timeStamps[firstDelayRoute][positionShipmentInRoute][0] += admissibleShift    

    return routes,routes_timeStamps,dockCapacityViolation,arrDepGH,numberOfTrucksPerGH 

def dock_violation_computation(dockCapacityViolation):
    
    DC_violation = 0
    for i in range(0,int(len(dockCapacityViolation))):
        DC_violation += (dockCapacityViolation[i][0][1]-dockCapacityViolation[i][0][0])
        
    return DC_violation





def create_new_route(routes,strong_infeas_routes_before_insertion,FFSequence,GHSequence,
                          unassigned_shipments,sigma,routes_timeStamps,timeMatrix,elBounds,
                          processing_time,maxRideTime,distanceMatrix,Nf,Ng,pickup_nodes,q_nodes,cap_trailer,
                          L_trailer,lat_occupancy_shipments,nDocks,alpha,beta,gamma,multiplier,cost_distance,cost_time,
                          w_TW,w_DC,node_rev,sigmaS):
    
    cond_exit = False
    unassigned_shipments_copy = deepcopy(unassigned_shipments)
    
    new_route       = [0,int(2*sigma+1)]

    while cond_exit is False and len(unassigned_shipments_copy)>0:
            
        J_list      = []
        all_info    = []
        n_positions = len(new_route[1:int(len(new_route)/2)])+1
        
        for i in range(0,int(len(unassigned_shipments_copy))):
            

            for k in range(0,n_positions):
                
                new_route            = add_shipment_to_route(new_route,unassigned_shipments_copy[i],k,n_positions,sigma)
                new_route_timeStamps = route_time_stamps(new_route,timeMatrix,elBounds,
                                       processing_time,maxRideTime)
                new_route_FF         = single_route_compute_FF_sequence(new_route,pickup_nodes,Nf,Ng,sigma)
                new_route_GH         = single_route_compute_GH_sequence(new_route,pickup_nodes,Nf,Ng,sigma)
                
                is_route_strongly_infeasible = single_route_strong_infeasibility(new_route,distanceMatrix,timeMatrix,sigma,Nf,Ng,pickup_nodes,elBounds,
                                                                                 processing_time,maxRideTime,q_nodes,cap_trailer,
                                                                                 L_trailer,lat_occupancy_shipments,nDocks)
                if is_route_strongly_infeasible:
                    pass
                else:
                    
                    orig_routes     = deepcopy(routes)
                    orig_timeStamps = deepcopy(routes_timeStamps)
                    orig_FF         = deepcopy(FFSequence)
                    orig_GH         = deepcopy(GHSequence)
                    orig_routes.append(new_route)
                    orig_timeStamps.append(new_route_timeStamps)
                    orig_FF.append(new_route_FF)
                    orig_GH.append(new_route_GH)
                    
                    dockCapacityViolation, arrDepGH, numberOfTrucksPerGH = dock_capacity_violation(orig_routes,orig_timeStamps,orig_FF,
                                                                                                   orig_GH,Nf,Ng,nDocks)
                    TW_violation = 0
                    DC_violation = dock_violation_computation(dockCapacityViolation)
                
                    J            = cost_weakly_infeasible_solution(alpha,beta,gamma,cost_distance,cost_time,
                                                  orig_routes,orig_timeStamps,distanceMatrix,sigma,TW_violation,DC_violation,w_TW,w_DC,node_rev,sigmaS)
                    
                    J_list.append(J[0])
                    all_info.append([J[0],deepcopy(new_route),unassigned_shipments_copy[i],deepcopy(orig_timeStamps),
                                     deepcopy(orig_FF),deepcopy(orig_GH)])
                    
                    del orig_routes,orig_timeStamps,orig_FF,orig_GH
                    
                new_route = remove_shipment_from_route(new_route,unassigned_shipments_copy[i],k,n_positions,sigma)
                

        # Determine what is the best insertion
        if len(J_list) > 0:
            
            idx_J                = np.argmin(J_list)
            # Update info of modified route
            new_route                        = all_info[idx_J][1]
            unassigned_shipments_copy.remove(all_info[idx_J][2])
            
            
            
            
        else:
            cond_exit = True
            
    modified_routes     = deepcopy(routes)
    modified_timeStamps = deepcopy(routes_timeStamps)
    modified_FF         = deepcopy(FFSequence)
    modified_GH         = deepcopy(GHSequence)
    
    if len(new_route) > 2:
        modified_routes.append(new_route)
        modified_timeStamps.append(route_time_stamps(new_route,timeMatrix,elBounds,
                                       processing_time,maxRideTime))
        modified_FF.append(single_route_compute_FF_sequence(new_route,pickup_nodes,Nf,Ng,sigma))
        modified_GH.append(single_route_compute_GH_sequence(new_route,pickup_nodes,Nf,Ng,sigma))

        
            
    
        
    
    
    return modified_routes, modified_timeStamps, modified_FF, modified_GH, unassigned_shipments_copy    




def greedy_insertion(init_routes,strong_infeas_routes_before_insertion,init_FFSequence,init_GHSequence,
                          unassigned_shipments,sigma,init_routes_timeStamps,timeMatrix,elBounds,
                          processing_time,maxRideTime,distanceMatrix,Nf,Ng,pickup_nodes,q_nodes,cap_trailer,
                          L_trailer,lat_occupancy_shipments,nDocks,alpha,beta,gamma,multiplier,cost_distance,cost_time,
                          w_TW,w_DC,node_rev,sigmaS):
    
    routes                    = deepcopy(init_routes)
    routes_timeStamps         = deepcopy(init_routes_timeStamps)
    FFSequence                = deepcopy(init_FFSequence)
    GHSequence                = deepcopy(init_GHSequence)
    cond_exit                 = False
    unassigned_shipments_copy = deepcopy(unassigned_shipments)
    
    weight_routes = []
    for i in range(0,int(len(routes))):
        weight_this_route = 0
        for j in range(1,int(len(routes[i])/2)):
            weight_this_route += q_nodes[routes[i][j]-1]
        weight_routes.append(weight_this_route)
    
    lat_occupancy_routes = []
    for i in range(0,int(len(routes))):
        lat_occupancy_this_route = 0
        for j in range(1,int(len(routes[i])/2)):
            lat_occupancy_this_route += lat_occupancy_shipments[routes[i][j]-1]
        lat_occupancy_routes.append(weight_this_route)

    

    while cond_exit is False and len(unassigned_shipments_copy)>0:
            
        J_list   = []
        all_info = []
        for i in range(0,int(len(unassigned_shipments_copy))):
            for j in range(0,int(len(routes))):
                
                #if 1==1:
                if (q_nodes[unassigned_shipments_copy[i]-1] <= cap_trailer-weight_routes[j]
                    and lat_occupancy_shipments[unassigned_shipments_copy[i]-1] <= L_trailer-lat_occupancy_routes[j]): 
                
                    n_positions  = len(routes[j][1:int(len(routes[j])/2)])+1
                    # If current route is strongly infeasible, it will still be
                    # strongly infeasible if we add a shipment
                    if strong_infeas_routes_before_insertion[j] == 1:
                        pass
                    else:
                        for k in range(0,n_positions):
                            print('Focusing on position %i'%(k))
                            routes[j] = add_shipment_to_route(routes[j],unassigned_shipments_copy[i],k,n_positions,sigma)
                            thisFFSequence = single_route_compute_FF_sequence(routes[j],pickup_nodes,Nf,Ng,sigma)
                            FFSequence[j] = thisFFSequence
                            thisGHSequence = single_route_compute_GH_sequence(routes[j],pickup_nodes,Nf,Ng,sigma)
                            GHSequence[j] = thisGHSequence
                            routes_timeStamps[j] = route_time_stamps(routes[j],timeMatrix,elBounds,
                               processing_time,maxRideTime)
                            
                            is_route_strongly_infeasible = single_route_strong_infeasibility(routes[j],distanceMatrix,timeMatrix,sigma,Nf,Ng,pickup_nodes,elBounds,
                                                                                             processing_time,maxRideTime,q_nodes,cap_trailer,
                                                                                             L_trailer,lat_occupancy_shipments,nDocks)
                            if is_route_strongly_infeasible:
                                pass
                                #J = cost_strongly_infeasible_solution(alpha,beta,gamma,multiplier,cost_distance,cost_time,
                                #                              routes,routes_timeStamps,distanceMatrix,sigma)
                            else:
                                dockCapacityViolation, arrDepGH, numberOfTrucksPerGH = dock_capacity_violation(routes,routes_timeStamps,FFSequence,GHSequence,
                                                                                   Nf,Ng,nDocks)
                                #TW_violation = time_violation_computation(routes,routes_timeStamps,elBounds)
                                TW_violation = 0
                                DC_violation = dock_violation_computation(dockCapacityViolation)
                            
                                J            = cost_weakly_infeasible_solution(alpha,beta,gamma,cost_distance,cost_time,
                                                              routes,routes_timeStamps,distanceMatrix,sigma,TW_violation,DC_violation,w_TW,w_DC,node_rev,sigmaS)
                            
                                J_list.append(J[0])
                                all_info.append([J[0],j,deepcopy(routes[j]),unassigned_shipments_copy[i],deepcopy(routes_timeStamps[j]),deepcopy(FFSequence[j]),deepcopy(GHSequence[j])])
                            
                            routes[j] = remove_shipment_from_route(routes[j],unassigned_shipments_copy[i],k,n_positions,sigma)
                            thisFFSequence = single_route_compute_FF_sequence(routes[j],pickup_nodes,Nf,Ng,sigma)
                            FFSequence[j] = thisFFSequence
                            thisGHSequence = single_route_compute_GH_sequence(routes[j],pickup_nodes,Nf,Ng,sigma)
                            GHSequence[j] = thisGHSequence
                            routes_timeStamps[j] = route_time_stamps(routes[j],timeMatrix,elBounds,
                               processing_time,maxRideTime)
        # Determine what is the best insertion
        if len(J_list) > 0:
            
            idx_J                = np.argmin(J_list)
            route_idx            = all_info[idx_J][1]
            # Update info of modified route
            routes[route_idx]               = all_info[idx_J][2]
            routes_timeStamps[route_idx]    = all_info[idx_J][4]
            FFSequence[route_idx]           = all_info[idx_J][5]
            GHSequence[route_idx]           = all_info[idx_J][6]
            weight_routes[route_idx]        += q_nodes[all_info[idx_J][3]-1]
            lat_occupancy_routes[route_idx] += lat_occupancy_shipments[[idx_J][3]-1]
            
            unassigned_shipments_copy.remove(all_info[idx_J][3])
                
        else:
            cond_exit = True
    
    return routes, routes_timeStamps, FFSequence, GHSequence, unassigned_shipments_copy        


def tabu_greedy_insertion(init_routes,strong_infeas_routes_before_insertion,init_FFSequence,init_GHSequence,
                          unassigned_shipments,last_known_route_shipments,sigma,init_routes_timeStamps,timeMatrix,elBounds,
                          processing_time,maxRideTime,distanceMatrix,Nf,Ng,pickup_nodes,q_nodes,cap_trailer,
                          L_trailer,lat_occupancy_shipments,nDocks,alpha,beta,gamma,multiplier,cost_distance,cost_time,
                          w_TW,w_DC,node_rev,sigmaS):
    
    routes                    = deepcopy(init_routes)
    routes_timeStamps         = deepcopy(init_routes_timeStamps)
    FFSequence                = deepcopy(init_FFSequence)
    GHSequence                = deepcopy(init_GHSequence)
    cond_exit                 = False
    unassigned_shipments_copy = deepcopy(unassigned_shipments)
    
    weight_routes = []
    for i in range(0,int(len(routes))):
        weight_this_route = 0
        for j in range(1,int(len(routes[i])/2)):
            weight_this_route += q_nodes[routes[i][j]-1]
        weight_routes.append(weight_this_route)
    
    lat_occupancy_routes = []
    for i in range(0,int(len(routes))):
        lat_occupancy_this_route = 0
        for j in range(1,int(len(routes[i])/2)):
            lat_occupancy_this_route += lat_occupancy_shipments[routes[i][j]-1]
        lat_occupancy_routes.append(weight_this_route)
    
    # For each of them, detect what is the last route they were part
    # of and make it tabu
    tabu_idx = []
    for unassigned_shipment in unassigned_shipments_copy:
        last_known_route = last_known_route_shipments[str(unassigned_shipment)]
        # If a last known route exists
        if len(last_known_route) > 0:
            n_matches = []
            for route in routes:
                n_matches.append(len([i for i in route if i in set(last_known_route)]))
            tabu_idx.append(np.argmax(n_matches))
       # Otherwise, assign len(routes) as the "fake" tabu index value
        else:
            tabu_idx.append(int(len(routes)))
    

    while cond_exit is False and len(unassigned_shipments_copy)>0:
            
        J_list   = []
        all_info = []        
        for i in range(0,int(len(unassigned_shipments_copy))):
            for j in range(0,int(len(routes))):
                # If route is not tabu, try all insertion points
                if (j != tabu_idx[i] and q_nodes[unassigned_shipments_copy[i]-1] <= cap_trailer-weight_routes[j]
                    and lat_occupancy_shipments[unassigned_shipments_copy[i]-1] <= L_trailer-lat_occupancy_routes[j]):   
                    n_positions  = len(routes[j][1:int(len(routes[j])/2)])+1
                    # If current route is strongly infeasible, it will still be
                    # strongly infeasible if we add a shipment
                    if strong_infeas_routes_before_insertion[j] == 1:
                        pass
                    else:
                        for k in range(0,n_positions):
                            routes[j] = add_shipment_to_route(routes[j],unassigned_shipments_copy[i],k,n_positions,sigma)
                            FFSequence[j] = single_route_compute_FF_sequence(routes[j],pickup_nodes,Nf,Ng,sigma)
                            GHSequence[j] = single_route_compute_GH_sequence(routes[j],pickup_nodes,Nf,Ng,sigma)
                            routes_timeStamps[j] = route_time_stamps(routes[j],timeMatrix,elBounds,
                               processing_time,maxRideTime)
                            
                            is_route_strongly_infeasible = single_route_strong_infeasibility(routes[j],distanceMatrix,timeMatrix,sigma,Nf,Ng,pickup_nodes,elBounds,
                                                                                             processing_time,maxRideTime,q_nodes,cap_trailer,
                                                                                             L_trailer,lat_occupancy_shipments,nDocks)
                            if is_route_strongly_infeasible:
                                pass
                            else:
                                dockCapacityViolation, arrDepGH, numberOfTrucksPerGH = dock_capacity_violation(routes,routes_timeStamps,FFSequence,GHSequence,
                                                                                   Nf,Ng,nDocks)
                                TW_violation = 0
                                DC_violation = dock_violation_computation(dockCapacityViolation)
                            
                                J            = cost_weakly_infeasible_solution(alpha,beta,gamma,cost_distance,cost_time,
                                                              routes,routes_timeStamps,distanceMatrix,sigma,TW_violation,DC_violation,w_TW,w_DC,node_rev,sigmaS)
                            
                                J_list.append(J[0])
                                all_info.append([J[0],j,deepcopy(routes[j]),unassigned_shipments_copy[i],deepcopy(routes_timeStamps[j]),deepcopy(FFSequence[j]),deepcopy(GHSequence[j])])
                            
                            routes[j] = remove_shipment_from_route(routes[j],unassigned_shipments_copy[i],k,n_positions,sigma)
                            thisFFSequence = single_route_compute_FF_sequence(routes[j],pickup_nodes,Nf,Ng,sigma)
                            FFSequence[j] = thisFFSequence
                            thisGHSequence = single_route_compute_GH_sequence(routes[j],pickup_nodes,Nf,Ng,sigma)
                            GHSequence[j] = thisGHSequence
                            routes_timeStamps[j] = route_time_stamps(routes[j],timeMatrix,elBounds,
                               processing_time,maxRideTime)
        
        # Determine what is the best insertion
        if len(J_list) > 0:
            
            idx_J                = np.argmin(J_list)
            route_idx            = all_info[idx_J][1]
            # Update info of modified route
            routes[route_idx]               = all_info[idx_J][2]
            routes_timeStamps[route_idx]    = all_info[idx_J][4]
            FFSequence[route_idx]           = all_info[idx_J][5]
            GHSequence[route_idx]           = all_info[idx_J][6]
            weight_routes[route_idx]        += q_nodes[all_info[idx_J][3]-1]
            lat_occupancy_routes[route_idx] += lat_occupancy_shipments[[idx_J][3]-1]
            
            unassigned_shipments_copy.remove(all_info[idx_J][3])
                
        else:
            cond_exit = True
    
    return routes, routes_timeStamps, FFSequence, GHSequence, unassigned_shipments_copy  





   
def add_shipment_to_route(route,shipment,position,n_positions,sigma):
    
    if position == 0:
        mod_route = ([route[0]] + [shipment] +
                                           route[1:int(len(route)-1)] +
                                           [shipment+sigma] + 
                                           [route[len(route)-1]])
    elif position == n_positions:
            mod_route = (route[0:position+1] + [shipment] +
                                       [shipment+sigma] +
                                       route[int(len(route)/2):int(len(route))])
    else:
            mod_route = (route[0:position+1] + [shipment] +
                                   route[position+1:len(route)-position-1] +
                                   [shipment+sigma] + 
                                   route[len(route)-position-1:len(route)])

    return mod_route

def remove_shipment_from_route(route,shipment,position,n_shipments_current_route,sigma):
    
    if position == 0:
        mod_route = ([route[0]] + route[2:int(len(route)-2)] + 
                                           [route[len(route)-1]])
    elif position == n_shipments_current_route-1:
            mod_route = (route[0:int(len(route)/2-1)] + 
                                       route[int(len(route)/2+1):int(len(route))])
    else:
            mod_route = (route[0:position+1]  +
                                   route[position+2:len(route)-position-2] +
                                   route[len(route)-position-1:len(route)])

    return mod_route


def two_regret_insertion(cost_before_insertion,init_routes,strong_infeas_routes_before_insertion,init_FFSequence,init_GHSequence,
                                    current_unassigned_shipments,sigma,init_routes_timeStamps,timeMatrix,elBounds,
                          processing_time,maxRideTime,distanceMatrix,Nf,Ng,pickup_nodes,q_nodes,cap_trailer,
                        L_trailer,lat_occupancy_shipments,nDocks,alpha,beta,gamma,multiplier,cost_distance,cost_time,w_TW,w_DC,node_rev,sigmaS):
    
    routes                    = deepcopy(init_routes)
    routes_timeStamps         = deepcopy(init_routes_timeStamps)
    FFSequence                = deepcopy(init_FFSequence)
    GHSequence                = deepcopy(init_GHSequence)
    
    exit_cond                 = 0
    unassigned_shipments_copy = deepcopy(current_unassigned_shipments)
    
    weight_routes = []
    for i in range(0,int(len(routes))):
        weight_this_route = 0
        for j in range(1,int(len(routes[i])/2)):
            weight_this_route += q_nodes[routes[i][j]-1]
        weight_routes.append(weight_this_route)
    
    lat_occupancy_routes = []
    for i in range(0,int(len(routes))):
        lat_occupancy_this_route = 0
        for j in range(1,int(len(routes[i])/2)):
            lat_occupancy_this_route += lat_occupancy_shipments[routes[i][j]-1]
        lat_occupancy_routes.append(weight_this_route)
    
    while exit_cond != 1 and len(unassigned_shipments_copy) != 0:
    
        # For each unassigned shipment, check all the possible insertion points in
        # all routes and compute the increase in cost
        delta_J_struct = []
        delta_J_array  = [] 
        for i in range(0,int(len(unassigned_shipments_copy))):
            for j in range(0,int(len(routes))):
                
                #if (q_nodes[unassigned_shipments_copy[i]-1] <= cap_trailer-weight_routes[j]
                #    and lat_occupancy_shipments[unassigned_shipments_copy[i]-1] <= L_trailer-lat_occupancy_routes[j]): 
                if 1==1:
                    
                    
                    n_positions  = len(routes[j][1:int(len(routes[j])/2)])+1
                    # If current route is strongly infeasible, it will still be
                    # strongly infeasible if we add a shipment
                    if strong_infeas_routes_before_insertion[j] == 1:
                        pass
                    else:
                        for k in range(0,n_positions):
                            routes[j]            = add_shipment_to_route(routes[j],unassigned_shipments_copy[i],k,n_positions,sigma)
                            routes_timeStamps[j] = route_time_stamps(routes[j],timeMatrix,elBounds,
                               processing_time,maxRideTime)
                            FFSequence[j] = single_route_compute_FF_sequence(routes[j],pickup_nodes,Nf,Ng,sigma)
                            GHSequence[j] = single_route_compute_GH_sequence(routes[j],pickup_nodes,Nf,Ng,sigma)
                            is_route_strongly_infeasible = single_route_strong_infeasibility(routes[j],distanceMatrix,timeMatrix,sigma,Nf,Ng,pickup_nodes,elBounds,
                                                                                             processing_time,maxRideTime,q_nodes,cap_trailer,
                                                                                             L_trailer,lat_occupancy_shipments,nDocks)
                            if is_route_strongly_infeasible:
                                
                                pass
                               
                                
                            else:
                                dockCapacityViolation, arrDepGH, numberOfTrucksPerGH = dock_capacity_violation(routes,routes_timeStamps,FFSequence,GHSequence,
                                                                                   Nf,Ng,nDocks)
                                TW_violation = 0
                                DC_violation = dock_violation_computation(dockCapacityViolation)
                            
                                J            = cost_weakly_infeasible_solution(alpha,beta,gamma,cost_distance,cost_time,
                                                              routes,routes_timeStamps,distanceMatrix,sigma,TW_violation,DC_violation,w_TW,w_DC,node_rev,sigmaS)
                                
                                
                                delta_J_struct.append([unassigned_shipments_copy[i],j,J[0]-cost_before_insertion,deepcopy(routes[j]),deepcopy(routes_timeStamps)])
                                delta_J_array.append([unassigned_shipments_copy[i],j,J[0]-cost_before_insertion])
                            
                            routes[j] = remove_shipment_from_route(routes[j],unassigned_shipments_copy[i],k,n_positions,sigma)
                            routes_timeStamps[j] = route_time_stamps(routes[j],timeMatrix,elBounds,
                               processing_time,maxRideTime)
                            FFSequence[j] = single_route_compute_FF_sequence(routes[j],pickup_nodes,Nf,Ng,sigma)
                            GHSequence[j] = single_route_compute_GH_sequence(routes[j],pickup_nodes,Nf,Ng,sigma)
        
        delta_J_array = np.array(delta_J_array)
        best_J_all_shipments_one_regret = []
        best_J_all_shipments_two_regret = []
        
        if len(delta_J_array) == 0:
            exit_cond = 1
        else:
            for i in range(0,int(len(unassigned_shipments_copy))):
                idx_this_shipment      = np.where(delta_J_array[:,0]==unassigned_shipments_copy[i])[0]
                
                if len(idx_this_shipment) == 0:
                    pass
                else:
                    routes_this_shipment = np.unique(delta_J_array[idx_this_shipment,1]) 
                    if len(routes_this_shipment) == 1:
                        best_J_this_route_this_shipment = []
                        for j in range(0,int(len(routes_this_shipment))):
                            this_route_idx = routes_this_shipment[j]
                            idx_this_shipment_this_route = ((delta_J_array[:,0]==unassigned_shipments_copy[i]) & (delta_J_array[:,1]==this_route_idx))
                            idx_this_shipment_this_route = np.array(np.where(idx_this_shipment_this_route)[0])
                            
                            best_value     = np.min(delta_J_array[idx_this_shipment_this_route,2])
                            best_J_this_route_this_shipment.append([unassigned_shipments_copy[i],this_route_idx,best_value,
                                                                    idx_this_shipment_this_route[np.argmin(delta_J_array[idx_this_shipment_this_route,2])]])
                        best_J_this_route_this_shipment = np.array(best_J_this_route_this_shipment)
                        sorted_idx_this_shipment        = np.argsort(best_J_this_route_this_shipment[:,2])
                        delta_f1                        = best_J_this_route_this_shipment[sorted_idx_this_shipment[0],2]
                        best_J_all_shipments_one_regret.append([unassigned_shipments_copy[i],delta_f1,
                                                     best_J_this_route_this_shipment[sorted_idx_this_shipment[0],2],
                                                     best_J_this_route_this_shipment[sorted_idx_this_shipment[0],3],
                                                     best_J_this_route_this_shipment[sorted_idx_this_shipment[0],1]])
                    else:
                        best_J_this_route_this_shipment = []
                        for j in range(0,int(len(routes_this_shipment))):
                            this_route_idx = routes_this_shipment[j]
                            idx_this_shipment_this_route = ((delta_J_array[:,0]==unassigned_shipments_copy[i]) & (delta_J_array[:,1]==this_route_idx))
                            idx_this_shipment_this_route = np.array(np.where(idx_this_shipment_this_route)[0])
                            
                            best_value     = np.min(delta_J_array[idx_this_shipment_this_route,2])
                            best_J_this_route_this_shipment.append([unassigned_shipments_copy[i],this_route_idx,best_value,
                                                                    idx_this_shipment_this_route[np.argmin(delta_J_array[idx_this_shipment_this_route,2])]])
                        best_J_this_route_this_shipment = np.array(best_J_this_route_this_shipment)
                        sorted_idx_this_shipment        = np.argsort(best_J_this_route_this_shipment[:,2])
                        delta_f2_minus_delta_f1         = (best_J_this_route_this_shipment[sorted_idx_this_shipment[1],2]-
                                                           best_J_this_route_this_shipment[sorted_idx_this_shipment[0],2])
                        best_J_all_shipments_two_regret.append([unassigned_shipments_copy[i],delta_f2_minus_delta_f1,
                                                     best_J_this_route_this_shipment[sorted_idx_this_shipment[1],2],
                                                     best_J_this_route_this_shipment[sorted_idx_this_shipment[0],2],
                                                     best_J_this_route_this_shipment[sorted_idx_this_shipment[0],3],
                                                     best_J_this_route_this_shipment[sorted_idx_this_shipment[0],1]])
            
            # No more possible insertion points        
            if len(best_J_all_shipments_one_regret)==0 and len(best_J_all_shipments_two_regret)==0:
                exit_cond = 1
            else:
                if len(best_J_all_shipments_one_regret) > 0:
                    best_J_all_shipments_one_regret = np.array(best_J_all_shipments_one_regret)
                    idx_best_shipment   = np.argmax(best_J_all_shipments_one_regret[:,1])
                    best_shipment       = int(best_J_all_shipments_one_regret[idx_best_shipment,0])
                    idx_route_to_modify = int(best_J_all_shipments_one_regret[idx_best_shipment,4])
                    modified_route      = delta_J_struct[int(best_J_all_shipments_one_regret[idx_best_shipment,3])][3]
                    # modified_timeStamps = delta_J_struct[int(best_J_all_shipments_one_regret[idx_best_shipment,3])][4]
                else:
                    best_J_all_shipments_two_regret = np.array(best_J_all_shipments_two_regret)
                    idx_best_shipment   = np.argmax(best_J_all_shipments_two_regret[:,1])
                    best_shipment       = int(best_J_all_shipments_two_regret[idx_best_shipment,0])
                    idx_route_to_modify = int(best_J_all_shipments_two_regret[idx_best_shipment,5])
                    modified_route      = delta_J_struct[int(best_J_all_shipments_two_regret[idx_best_shipment,4])][3] 
                    # modified_timeStamps = delta_J_struct[int(best_J_all_shipments_two_regret[idx_best_shipment,4])][4]
                
                unassigned_shipments_copy.remove(best_shipment)
            
                #print(best_shipment)
                #print(idx_route_to_modify)
                #print(modified_route)
                #print(modified_timeStamps)
                #print(routes)
                #print(routes_timeStamps)    
                
                # Update route and time stamps
                routes[idx_route_to_modify]                   = modified_route
                weight_routes[idx_route_to_modify]            += q_nodes[best_shipment-1]
                lat_occupancy_routes[idx_route_to_modify]     += lat_occupancy_shipments[best_shipment-1]
                # routes_timeStamps[idx_route_to_modify] = modified_timeStamps[idx_route_to_modify]
                #print(routes)
                #print(routes_timeStamps)
            
                
                
                #print(best_shipment)
                #print(idx_route_to_modify)
                #print(modified_route)
                #print(modified_timeStamps)
                #print('%%%%%%%%%%%%%%%')
    
    modified_routes_timeStamps = []
    modified_routes_FF         = []
    modified_routes_GH         = []
    
    #print('%%%%%%%%%%%%%%%%%%%%%%%%%%')
    #print(routes)
    #print('%%%%%%%%%%%%%%%%%%%%%%%%%%')
    
    for i in range(0,int(len(routes))):
        modified_routes_timeStamps.append(cordeauLaporteProcedure(routes[i],timeMatrix,elBounds,processing_time,maxRideTime))
        modified_routes_FF.append(single_route_compute_FF_sequence(routes[i],pickup_nodes,Nf,Ng,sigma))
        modified_routes_GH.append(single_route_compute_GH_sequence(routes[i],pickup_nodes,Nf,Ng,sigma))
    
    return routes, modified_routes_timeStamps, modified_routes_FF, modified_routes_GH, unassigned_shipments_copy            
    #return delta_J_struct, delta_J_array, best_J_all_shipments_two_regret, routes, routes_timeStamps, unassigned_shipments_copy


def FF_GH_local_search(routes,FFSequence,GHSequence,unassigned_shipments,shipment_FF_GH,
                       sigma,routes_timeStamps,timeMatrix,elBounds,
                          processing_time,maxRideTime,distanceMatrix,Nf,Ng,pickup_nodes,q_nodes,cap_trailer,
                        L_trailer,lat_occupancy_shipments,nDocks,alpha,beta,gamma,multiplier,cost_distance,cost_time,w_TW,w_DC):
    
    modified_routes            = deepcopy(routes)
    modified_routes_timeStamps = deepcopy(routes_timeStamps)
    modified_FFSequence        = deepcopy(FFSequence)
    modified_GHSequence        = deepcopy(GHSequence)
    
    print(modified_routes)
    
    current_unassigned_shipments = deepcopy(unassigned_shipments)
    
    
        
    exit_cond = 0
        
    while exit_cond != 1 and len(current_unassigned_shipments)>0:
        
        # For each unassigned shipment, compute (late_delivery - early_pickup),
        # i.e., the available time-span between pickup and delivery. Focus first 
        # on the shipment with the lowest availale time-span
        available_ts = []
        for i in range(0,int(len(current_unassigned_shipments))):
            available_ts.append(elBounds[current_unassigned_shipments[i]+sigma][1]-elBounds[current_unassigned_shipments[i]][0])
        
        #print('Available ts')
        #print(available_ts)
        
        #print(current_unassigned_shipments)
        #print(np.argmin(available_ts))
        #print('')
        
        this_unassigned_shipment = current_unassigned_shipments[np.argmin(available_ts)]
        
        this_unassigned_shipment_FF = shipment_FF_GH[str(this_unassigned_shipment)][0]
        this_unassigned_shipment_GH = shipment_FF_GH[str(this_unassigned_shipment)][1]
        nodes_same_FF_same_GH       = list(set(pickup_nodes[this_unassigned_shipment_FF][this_unassigned_shipment_GH]) - set([this_unassigned_shipment]))
        
        #print(nodes_same_FF_same_GH)
        
        shipments_to_check = set(nodes_same_FF_same_GH)
        
        similar_shipments_in_route   = []
        n_similar_shipments_in_route = []
        for j in range(0,int(len(modified_routes))):
            #d = {k:v for v,k in enumerate(routes[j])}
            #print(d)
            #positions = [routes[j].index(c) for c in nodes_same_FF_same_GH]
            
            idx_occurrences    = [i for i, e in enumerate(modified_routes[j]) if e in shipments_to_check]
            similar_shipments_in_route.append(idx_occurrences)
            n_similar_shipments_in_route.append(len(idx_occurrences))
            #s = set(routes[j])
            #temp3 = [x for x in nodes_same_FF_same_GH if x in s]
            #print(idx_occurrences)
        #print('%%%%%%%%%%%%%')
            
        #print(similar_shipments_in_route)
        #print(n_similar_shipments_in_route)
        
        # Find route with highest number of similar shipments
        idx_most_similar_route = np.argmax(n_similar_shipments_in_route)
        idx_shipments_in_route = similar_shipments_in_route[idx_most_similar_route]
        
        #print('Focusing on shipment %i'%(this_unassigned_shipment))
        #print(modified_routes[idx_most_similar_route])
        
        #print('Idx shipment')
        #print(idx_shipments_in_route)
        
        #print(idx_most_similar_route)
        
        #########################################################
        ### Building new route that will include the shipment ###
        #########################################################
        
        # Start with origin depot
        new_route = [0]
        # Pickup nodes
        pickup_nodes_this_route   = []
        delivery_nodes_this_route = []
        for j in range(0,int(len(idx_shipments_in_route))):
            this_pickup_node = modified_routes[idx_most_similar_route][idx_shipments_in_route[j]]
            new_route.append(this_pickup_node)
            pickup_nodes_this_route.append(this_pickup_node)
            delivery_nodes_this_route.append(this_pickup_node+sigma)
        #print(pickup_nodes_this_route)
        #print(delivery_nodes_this_route)
        # Delivery nodes and destination depot
        delivery_nodes_this_route = delivery_nodes_this_route[::-1]
        new_route += delivery_nodes_this_route
        new_route.append(2*sigma+1)
        
        #print(new_route)
        
        ####################################################################
        ### Update routes by splitting the route where we want to insert ###
        ### the new shipment in two parts                                ###
        ####################################################################
        
        #print(modified_routes)
        #print(modified_routes[idx_most_similar_route])
        #print('')
        
        for j in range(0,int(len(pickup_nodes_this_route))):
            modified_routes[idx_most_similar_route].remove(pickup_nodes_this_route[j])
            #print(modified_routes[idx_most_similar_route])
        for j in range(0,int(len(delivery_nodes_this_route))):
            modified_routes[idx_most_similar_route].remove(delivery_nodes_this_route[j])
            #print(modified_routes[idx_most_similar_route])
            
        modified_routes.append(new_route)
        
        modified_routes_timeStamps[idx_most_similar_route] = route_time_stamps(modified_routes[idx_most_similar_route],timeMatrix,
                                                                               elBounds,processing_time,maxRideTime)
        modified_routes_timeStamps.append(route_time_stamps(modified_routes[-1],timeMatrix,
                                                                               elBounds,processing_time,maxRideTime))
        #print(modified_routes)
        #print(modified_routes_timeStamps)
        
        ######################################################################
        ### Modify FF and GH sequence of the reduced route and of the newly
        ### created routes
        ######################################################################
        
        thisFFSequence=[]
        for idxPickup in range(1,int(len(modified_routes[idx_most_similar_route])/2)+1):
            for idxFF in range(0,Nf):
                for idxGH in range(0,Ng):
                    if modified_routes[idx_most_similar_route][idxPickup] in pickup_nodes[idxFF][idxGH]:
                        thisFFSequence.append(idxFF)
        modified_FFSequence[idx_most_similar_route] = thisFFSequence
        thisGHSequence = []
        for idxDel in range(int((len(modified_routes[idx_most_similar_route])/2)),int(len(modified_routes[idx_most_similar_route]))):
            for idxFF in range(0,Nf):
                for idxGH in range(0,Ng):
                    if modified_routes[idx_most_similar_route][idxDel]-sigma in pickup_nodes[idxFF][idxGH]:
                        thisGHSequence.append(idxGH)
        modified_GHSequence[idx_most_similar_route] = thisGHSequence
        
        thisFFSequence=[]
        for idxPickup in range(1,int(len(modified_routes[-1])/2)+1):
            for idxFF in range(0,Nf):
                for idxGH in range(0,Ng):
                    if modified_routes[-1][idxPickup] in pickup_nodes[idxFF][idxGH]:
                        thisFFSequence.append(idxFF)
        modified_FFSequence.append(thisFFSequence)
        thisGHSequence = []
        for idxDel in range(int((len(modified_routes[-1])/2)),int(len(modified_routes[-1]))):
            for idxFF in range(0,Nf):
                for idxGH in range(0,Ng):
                    if modified_routes[-1][idxDel]-sigma in pickup_nodes[idxFF][idxGH]:
                        thisGHSequence.append(idxGH)
        modified_GHSequence.append(thisGHSequence)
        
        
        J_struct = []
        ###################################################
        ## Now insert the shipment in its best location ###
        ###################################################
        n_positions  = len(new_route[1:int(len(new_route)/2)+1])
        for k in range(0,n_positions):
            modified_routes[-1] = add_shipment_to_route(modified_routes[-1],this_unassigned_shipment,k,n_positions,sigma)
            thisFFSequence=[]
            for idxPickup in range(1,int(len(modified_routes[-1])/2)+1):
                for idxFF in range(0,Nf):
                    for idxGH in range(0,Ng):
                        if modified_routes[-1][idxPickup] in pickup_nodes[idxFF][idxGH]:
                            thisFFSequence.append(idxFF)
            modified_FFSequence[-1] = thisFFSequence
            thisGHSequence = []
            for idxDel in range(int((len(modified_routes[-1])/2)),int(len(modified_routes[-1]))):
                for idxFF in range(0,Nf):
                    for idxGH in range(0,Ng):
                        if modified_routes[-1][idxDel]-sigma in pickup_nodes[idxFF][idxGH]:
                            thisGHSequence.append(idxGH)
            modified_GHSequence[-1] = thisGHSequence
            modified_routes_timeStamps[-1] = route_time_stamps(modified_routes[-1],timeMatrix,elBounds,
                processing_time,maxRideTime)
            
            is_route_strongly_infeasible = single_route_strong_infeasibility(modified_routes[-1],distanceMatrix,timeMatrix,
                                                                             sigma,Nf,Ng,pickup_nodes,elBounds,
                                                                             processing_time,maxRideTime,q_nodes,cap_trailer,
                                                                             L_trailer,lat_occupancy_shipments,nDocks)
            if is_route_strongly_infeasible:
                #J = cost_strongly_infeasible_solution(alpha,beta,gamma,multiplier,cost_distance,cost_time,
                #                              routes,routes_timeStamps,distanceMatrix,sigma)
                
                pass
               
                
            else:
                #print(modified_routes)
                #print(len(modified_routes))
                #print(len(modified_routes_timeStamps))
                #print(len(modified_FFSequence))
                #print(len(modified_GHSequence))
                dockCapacityViolation, arrDepGH, numberOfTrucksPerGH = dock_capacity_violation(modified_routes,modified_routes_timeStamps,modified_FFSequence
                                                                    ,modified_GHSequence,Nf,Ng,nDocks)
                #TW_violation = time_violation_computation(routes,routes_timeStamps,elBounds)
                TW_violation = 0
                DC_violation = dock_violation_computation(dockCapacityViolation)
            
                J            = cost_weakly_infeasible_solution(alpha,beta,gamma,cost_distance,cost_time,
                                              modified_routes,modified_routes_timeStamps,distanceMatrix,sigma,TW_violation,DC_violation,w_TW,w_DC,node_rev,sigmaS)
                
                J_struct.append([J,deepcopy(modified_routes),deepcopy(modified_routes_timeStamps),
                                deepcopy(modified_FFSequence),deepcopy(modified_GHSequence)])
                
            modified_routes[-1] = remove_shipment_from_route(modified_routes[-1],this_unassigned_shipment,k,n_positions,sigma)
            thisFFSequence=[]
            print(modified_routes)
            for idxPickup in range(1,int(len(modified_routes[-1])/2)+1):
                for idxFF in range(0,Nf):
                    for idxGH in range(0,Ng):
                        if modified_routes[j][idxPickup] in pickup_nodes[idxFF][idxGH]:
                            thisFFSequence.append(idxFF)
            modified_FFSequence[-1] = thisFFSequence
            thisGHSequence = []
            for idxDel in range(int((len(modified_routes[-1])/2)),int(len(modified_routes[-1]))):
                for idxFF in range(0,Nf):
                    for idxGH in range(0,Ng):
                        if modified_routes[-1][idxDel]-sigma in pickup_nodes[idxFF][idxGH]:
                            thisGHSequence.append(idxGH)
            modified_GHSequence[-1] = thisGHSequence
            modified_routes_timeStamps[-1] = route_time_stamps(modified_routes[-1],timeMatrix,elBounds,
               processing_time,maxRideTime)
        
        if len(J_struct) != 0:
            # Find modified set of routes with minimum cost
            all_J = []
            for j in range(0,int(len(J_struct))):
                all_J.append(J_struct[j][0][0])
                
            #print(all_J)
            
            idx_best_solution = np.argmin(all_J)
            best_solution     = J_struct[idx_best_solution]
            
            modified_routes            = best_solution[1]
            modified_routes_timeStamps = best_solution[2]
            modified_FFSequence        = best_solution[3]
            modified_GHSequence        = best_solution[4]
            
            current_unassigned_shipments.remove(this_unassigned_shipment)
            
        else:
            exit_cond = 1
    
    return modified_routes, modified_routes_timeStamps, modified_FFSequence, modified_GHSequence, current_unassigned_shipments

def single_route_compute_FF_sequence(r,pickup_nodes,Nf,Ng,sigma):
    FF_sequence = []
    for idxPickup in range(1,int(len(r)/2)+1):
        for idxFF in range(0,Nf):
            for idxGH in range(0,Ng):
                if r[idxPickup] in pickup_nodes[idxFF][idxGH]:
                    FF_sequence.append(idxFF)
                    
    return FF_sequence

def single_route_compute_GH_sequence(r,pickup_nodes,Nf,Ng,sigma):
    GH_sequence = []
    for idxDel in range(int((len(r)/2)),int(len(r))):
        for idxFF in range(0,Nf):
            for idxGH in range(0,Ng):
                if r[idxDel]-sigma in pickup_nodes[idxFF][idxGH]:
                    GH_sequence.append(idxGH)
                    
    return GH_sequence
    


def route_combination_v2(a,b,c,d,distanceMatrix,time_matrix,
                      sigma,Nf,Ng,pickup_nodes,el_bounds,processing_time,max_ride_time,q_nodes, 
                      truck_weight_capacity,L_trailer,lat_occupancy_shipments,nDocks):
    
    orig_routes     = deepcopy(a)
    orig_timeStamps = deepcopy(b) 
    orig_FFSequence = deepcopy(c)
    orig_GHSequence = deepcopy(d)
    
    orig_weight_routes = []
    for i in range(0,int(len(orig_routes))):
        weight_this_route = 0
        for j in range(1,int(len(orig_routes[i])/2)):
            weight_this_route += q_nodes[orig_routes[i][j]-1]
        orig_weight_routes.append(weight_this_route)
    
    orig_routes_lat_occ = []
    for i in range(0,int(len(orig_routes))):
        lat_occupancy_this_route = 0
        for j in range(1,int(len(orig_routes[i])/2)):
            lat_occupancy_this_route += lat_occupancy_shipments[orig_routes[i][j]-1]
        orig_routes_lat_occ.append(weight_this_route)
    
    exit_cond = 0
    
    while exit_cond != 1:
        
        n_routes = int(len(orig_routes))
    
        combination_list   = []
        poss_plus_slack    = []
        combination_matrix = np.ones([n_routes,n_routes])
        
        for i in range(0,n_routes):
            for j in range(0,n_routes):
                if j != i:
                    
                    if (orig_weight_routes[i]+orig_weight_routes[j] <= truck_weight_capacity
                        and orig_routes_lat_occ[i]+orig_routes_lat_occ[j] <= L_trailer):
                    
                        this_combined_route = (orig_routes[j][0:int(len(orig_routes[j])/2)]+
                                               orig_routes[i][1:int(len(orig_routes[i])-1)]+
                                               orig_routes[j][int(len(orig_routes[j])/2):int(len(orig_routes[j]))])
                        
                        
                        combination_is_not_possible = single_route_strong_infeasibility(this_combined_route,
                                                                                         distanceMatrix, 
                                                                                         time_matrix,
                                                                                         sigma, 
                                                                                         Nf, 
                                                                                         Ng, 
                                                                                         pickup_nodes, 
                                                                                         el_bounds, 
                                                                                         processing_time, 
                                                                                         max_ride_time, 
                                                                                         q_nodes, 
                                                                                         truck_weight_capacity, 
                                                                                         L_trailer, 
                                                                                         lat_occupancy_shipments, 
                                                                                         nDocks)
                    
                            
                        combination_matrix[j,i]   = combination_is_not_possible
                        varMatrix                 = route_time_stamps(this_combined_route,time_matrix,el_bounds,processing_time,max_ride_time)
                        slack_combined_route      = forward_slack_computation(this_combined_route,varMatrix,el_bounds,processing_time,max_ride_time)[0]
                        
                        combination_list.append([i,j,orig_routes[i],orig_routes[j],this_combined_route,combination_is_not_possible,slack_combined_route])
                        poss_plus_slack.append([combination_is_not_possible,slack_combined_route])
                    
        poss_plus_slack = np.array(poss_plus_slack)
        
        if len(poss_plus_slack) > 0:
        
            # find indices of feasible combinations
            idx_poss = np.where(poss_plus_slack[:,0]==0)[0]
            
            if len(idx_poss) > 0:
            
                # max slack feasible combinations
                best_idx = np.argmax(poss_plus_slack[idx_poss,1])
                
                #######################
                ### Modify solution
                #######################
                first_route_idx           = combination_list[idx_poss[best_idx]][0]
                second_route_idx          = combination_list[idx_poss[best_idx]][1]
                combined_route            = combination_list[idx_poss[best_idx]][4]
                combined_route_timeStamps = cordeauLaporteProcedure(combined_route,time_matrix,el_bounds,processing_time,max_ride_time)
                
                modified_routes            = []
                modified_routes_timeStamps = []
                modified_routes_FF         = []
                modified_routes_GH         = []
                modified_routes_weight     = []
                modified_routes_lat_occ    = []
                for i in range(0,int(len(orig_routes))):
                    if i != first_route_idx and i != second_route_idx:
                        modified_routes.append(orig_routes[i])
                        modified_routes_timeStamps.append(orig_timeStamps[i])
                        modified_routes_FF.append(orig_FFSequence[i])
                        modified_routes_GH.append(orig_GHSequence[i])
                        modified_routes_weight.append(orig_weight_routes[i])
                        modified_routes_lat_occ.append(orig_routes_lat_occ[i])
                        
                modified_routes.append(combined_route)
                modified_routes_timeStamps.append(combined_route_timeStamps)
                modified_routes_FF.append(single_route_compute_FF_sequence(combined_route,pickup_nodes,Nf,Ng,sigma))
                modified_routes_GH.append(single_route_compute_GH_sequence(combined_route,pickup_nodes,Nf,Ng,sigma))
                modified_routes_weight.append(orig_weight_routes[first_route_idx]+orig_weight_routes[second_route_idx])
                modified_routes_lat_occ.append(orig_routes_lat_occ[first_route_idx]+orig_routes_lat_occ[second_route_idx])
                
                orig_routes             = deepcopy(modified_routes)
                orig_timeStamps         = deepcopy(modified_routes_timeStamps)
                orig_FFSequence         = deepcopy(modified_routes_FF)
                orig_GHSequence         = deepcopy(modified_routes_GH)
                orig_weight_routes      = deepcopy(modified_routes_weight)
                orig_routes_lat_occ     = deepcopy(modified_routes_lat_occ)
                
            else:
                
                #print('No more route reductions are possible!')
                
                modified_routes            = deepcopy(orig_routes)
                modified_routes_timeStamps = deepcopy(orig_timeStamps)
                modified_routes_FF         = deepcopy(orig_FFSequence)
                modified_routes_GH         = deepcopy(orig_GHSequence)
                
                exit_cond = 1
                
        else:
            modified_routes            = deepcopy(orig_routes)
            modified_routes_timeStamps = deepcopy(orig_timeStamps)
            modified_routes_FF         = deepcopy(orig_FFSequence)
            modified_routes_GH         = deepcopy(orig_GHSequence)
            exit_cond = 1
    
    return modified_routes, modified_routes_timeStamps, modified_routes_FF, modified_routes_GH, combination_list, combination_matrix,   


#########################
#########################
### REMOVAL FUNCTIONS ###
#########################
#########################    

#########################################################################
### Function that randomly removes q shipments from the set of routes ###
#########################################################################
def random_removal(routes,sigma,q,time_matrix,el_bounds,processing_time,max_ride_time,
                   pickup_nodes,Nf,Ng,last_known_route_shipments):
    
    routes_modified   = deepcopy(routes)
    removed_shipments = []
    
    cont         = 0
    max_len_flag = 0
    while cont < q and max_len_flag == 0:
        
        # Determine number of remaining routes
        nRoutes          = len(routes_modified)
        # Pick route where to eliminate a shipment
        idx_route_selected           = random.randint(0,nRoutes-1)
        

        n_shipments_in_route    = int(len(routes_modified[idx_route_selected][1:
                                      int(len(routes_modified[idx_route_selected])/2)]))
        
        # If there are at least two shipments in the route, randomly
        # remove one
        if n_shipments_in_route >=2:
            idx_shipment_selected               = random.randint(1,n_shipments_in_route)
            this_shipment                       = routes_modified[idx_route_selected][idx_shipment_selected]
            routes_modified[idx_route_selected] = remove_shipment_from_route(routes_modified[idx_route_selected],this_shipment,idx_shipment_selected-1,n_shipments_in_route,sigma)
        # Otherwise, if there is only one shipment, eliminate the route
        else:
            this_shipment = routes_modified[idx_route_selected][1]
            routes_modified.pop(idx_route_selected)
            
        last_known_route_shipments[str(this_shipment)] = routes[idx_route_selected]
            
        removed_shipments.append(this_shipment)
        cont += 1
        
    # For each route, determine time-stamps, sequence of FF and
    # sequence of GH
    modified_routes_timeStamps = []
    modified_routes_FF         = []
    modified_routes_GH         = []
    for i in range(0,int(len(routes_modified))):
        modified_routes_timeStamps.append(cordeauLaporteProcedure(routes_modified[i],time_matrix,el_bounds,processing_time,max_ride_time))
        modified_routes_FF.append(single_route_compute_FF_sequence(routes_modified[i],pickup_nodes,Nf,Ng,sigma))
        modified_routes_GH.append(single_route_compute_GH_sequence(routes_modified[i],pickup_nodes,Nf,Ng,sigma))
        
        
        
        

    
    return routes_modified,modified_routes_timeStamps,modified_routes_FF,modified_routes_GH,removed_shipments,last_known_route_shipments    

######################################################################
### Function that removes q shipments from the set of routes using ###
### the Shaw removal approach                                      ###
######################################################################
def shaw_removal(p,allRoutesHeuristics,q,routes_timeStamps,time_matrix,el_bounds,
                processing_time,max_ride_TIME,Nf,Ng,sigma,q_nodes,
                QTruck,pickup_nodes,Nd,distanceMatrix,maxRideTimeTruck,max_ride_time,last_known_route_shipments):


    # Compute slack vector for each route
    forwardSlackAllRoutes = []
    for i in range(0,len(allRoutesHeuristics)):
        forwardSlackVector = forward_slack_computation(allRoutesHeuristics[i],
                             routes_timeStamps[i],el_bounds,
                             processing_time,max_ride_time)
        forwardSlackAllRoutes.append(forwardSlackVector)
    
    # Identify all shipments part of the current solution
    shipmentsThisSolution = []
    routeIdxThisShipment  = []
    for i in range(0,len(allRoutesHeuristics)):
        for j in range(1,int(len(allRoutesHeuristics[i])/2)):
            shipmentsThisSolution.append(allRoutesHeuristics[i][j])
            routeIdxThisShipment.append(i)
    
    # Normalization constants
    maxDistance = np.max(distanceMatrix)
    maxTime     = maxRideTimeTruck
    maxWeight   = QTruck[0]
    
    # Weights
    alpha = 1
    beta  = 1
    gamma = 1
    delta = 1
    
    # Assembling matrix where element (i,j) is the relatedness between
    # shipments i and j
    relatednessMatrix = np.zeros([int(len(shipmentsThisSolution)),int(len(shipmentsThisSolution))])
    for i in range(0,int(len(shipmentsThisSolution)-1)):
        firstShipment           = shipmentsThisSolution[i]
        routeIdxFirstShipment   = routeIdxThisShipment[i]
        posFirstShipmentInRoute = np.where(np.array(allRoutesHeuristics[routeIdxFirstShipment])==firstShipment)[0][0]
        posFirstShipDelInRoute  = len(allRoutesHeuristics[routeIdxFirstShipment])-posFirstShipmentInRoute-1
        for j in range(i+1,len(shipmentsThisSolution)):
            secondShipment           = shipmentsThisSolution[j]
            routeIdxSecondShipment   = routeIdxThisShipment[j]
            posSecondShipmentInRoute = np.where(np.array(allRoutesHeuristics[routeIdxSecondShipment])==secondShipment)[0][0]
            posSecondShipDelInRoute  = len(allRoutesHeuristics[routeIdxSecondShipment])-posSecondShipmentInRoute-1
            
            dPickup           = distanceMatrix[firstShipment][secondShipment]
            dDelivery         = distanceMatrix[firstShipment+sigma][secondShipment+sigma]
            timeDiffPickup    = np.abs(routes_timeStamps[routeIdxFirstShipment][posFirstShipmentInRoute,3]-
                             routes_timeStamps[routeIdxSecondShipment][posSecondShipmentInRoute,3])
            timeDiffDelivery  = np.abs(routes_timeStamps[routeIdxFirstShipment][posFirstShipDelInRoute,3]-
                             routes_timeStamps[routeIdxSecondShipment][posSecondShipDelInRoute,3])
            weightDiff        = np.abs(q_nodes[firstShipment-1]-q_nodes[secondShipment-1])
            slackDiffPickup   = np.abs(forwardSlackAllRoutes[routeIdxFirstShipment][posFirstShipmentInRoute]-
                                       forwardSlackAllRoutes[routeIdxSecondShipment][posSecondShipmentInRoute])
            slackDiffDelivery = np.abs(forwardSlackAllRoutes[routeIdxFirstShipment][posFirstShipDelInRoute]-
                                       forwardSlackAllRoutes[routeIdxSecondShipment][posSecondShipDelInRoute])
            

            relatednessMatrix[i][j] = (alpha*(dPickup+dDelivery)/maxDistance+
                                       beta*(timeDiffPickup+timeDiffDelivery)/maxTime+
                                       gamma*weightDiff/maxWeight+
                                       delta*(slackDiffPickup+slackDiffDelivery)/maxTime)
    
    # Fill in lower triangular part of the matrix
    relatednessMatrix = relatednessMatrix + np.transpose(relatednessMatrix)    
    # Assign a very high value to diagonal elements (so that we cannot
    # pair a shipment with itself)
    M                          = 50
    row,col                    = np.diag_indices(relatednessMatrix.shape[0])
    relatednessMatrix[row,col] = M*np.ones([len(shipmentsThisSolution)])
    # Initialize set of shipments to be removed
    D = []
    # Randomly pick a request to be removed
    idxShipmentToBeRemoved = random.randint(0,len(shipmentsThisSolution)-1)
    D.append(shipmentsThisSolution[idxShipmentToBeRemoved])
    
    while len(D)<q:
        # Randomly pick a shipment among the ones already stored in D
        idxInD              = random.randint(0,len(D)-1)
        thisShipment        = D[idxInD]
        # Find index of shipment in relatedness matrix
        positionInRelMatrix = np.where(np.array(shipmentsThisSolution)==thisShipment)[0][0]
        # Sort associated row of relatedness matrix (we are sorting the indices)
        idxRowSorted = np.argsort(relatednessMatrix[positionInRelMatrix])
        
        newShipmentToRemove = 1
        while newShipmentToRemove == 1:
            y                    = random.random()
            idxToAdd             = int(np.round(y**p*(len(shipmentsThisSolution)-1)))
            potentialNewShipment = shipmentsThisSolution[idxRowSorted[idxToAdd]]
            
            if potentialNewShipment not in D:
                D.append(potentialNewShipment)
                newShipmentToRemove = 0
    
    # Compute reduced routes (i.e., routes without the shipments removed
    # by the Shaw removal technique)
    routes_modified   = deepcopy(allRoutesHeuristics)
    
    for i in range(0,len(D)):
        
        # Find index of route the current shipment to be removed belongs to
        for j in range(0,len(routes_modified)):
            if D[i] in routes_modified[j]:
                idx_route_selected = j
                break
                
        idx_shipment_selected     = np.where(np.array(routes_modified[idx_route_selected])==D[i])[0][0]
        n_shipments_in_route      = int(len(routes_modified[idx_route_selected][1:
                                      int(len(routes_modified[idx_route_selected])/2)]))
        
        # If there are at least two shipments in the route, remove
        # the intended shipment
        if n_shipments_in_route >=2:
            this_shipment                       = routes_modified[idx_route_selected][idx_shipment_selected]
            routes_modified[idx_route_selected] = remove_shipment_from_route(routes_modified[idx_route_selected],this_shipment,idx_shipment_selected-1,n_shipments_in_route,sigma)
        # Otherwise, if there is only one shipment, eliminate the route
        else:
            this_shipment = routes_modified[idx_route_selected][1]
            routes_modified.pop(idx_route_selected)    
            
        last_known_route_shipments[str(this_shipment)] = allRoutesHeuristics[idx_route_selected]
            
    # For each route, determine time-stamps, sequence of FF and
    # sequence of GH
    modified_routes_timeStamps = []
    modified_routes_FF         = []
    modified_routes_GH         = []
    for i in range(0,int(len(routes_modified))):
        modified_routes_timeStamps.append(cordeauLaporteProcedure(routes_modified[i],time_matrix,el_bounds,processing_time,max_ride_time))
        modified_routes_FF.append(single_route_compute_FF_sequence(routes_modified[i],pickup_nodes,Nf,Ng,sigma))
        modified_routes_GH.append(single_route_compute_GH_sequence(routes_modified[i],pickup_nodes,Nf,Ng,sigma))
        
    
    return routes_modified,modified_routes_timeStamps,modified_routes_FF,modified_routes_GH,D,last_known_route_shipments

######################################################################
### Function that removes q shipments from the set of routes using ###
### the worst removal approach                                     ###
######################################################################
def worst_removal(p,routes,q,routes_timeStamps,distanceMatrix,timeMatrix,elBounds,
                  processing_time,maxRideTime,cost_distance,cost_time,beta,gamma,
                  sigma,pickup_nodes,Nf,Ng,last_known_route_shipments,sigmaS):
    
    # First, compute only distance-related and time-related costs of the 
    # current solution. In fact, removing a shipment does not increase
    # a time window violation
    
    totalDistance      = 0
    totalTime          = 0
    allDistances       = []
    allTravelTimes     = []
    
    
    for i in range(0,len(routes)):
        thisRoute                = routes[i]
        distanceThisRoute        = 0
        for j in range(0,len(thisRoute)-1):
            distanceThisRoute += distanceMatrix[thisRoute[j]][thisRoute[j+1]]
        timeThisRoute   = routes_timeStamps[i][len(routes_timeStamps[i])-1,3]-routes_timeStamps[i][0,3]
        totalDistance   += distanceThisRoute
        totalTime       += timeThisRoute
        allDistances.append(distanceThisRoute)
        allTravelTimes.append(timeThisRoute)
    
    J_reference = beta*cost_distance*totalDistance+gamma*cost_time*totalTime
    
    # Now, for each route and each shipment, compute the cost of the solution
    # where the considered shipment is removed
    delta_J               = []
    route_this_delta_J    = []
    shipment_this_delta_J = []
    all_info              = []
    
    for i in range(0,len(routes)):
        n_shipments_in_route      = int(len(routes[i][1:
                                      int(len(routes[i])/2)]))
        for j in range(1,int(len(routes[i])/2)):
            


            route_modified = remove_shipment_from_route(routes[i],routes[i][j],j-1,n_shipments_in_route,sigma)


    
            routes_modified = []
            for k in range(0,len(routes)):
                if k != i:
                    routes_modified.append(routes[k])
                else:
                    routes_modified.append(route_modified)
            
          
            # Compute time stamps
            routes_modified_timeStamps = routes_time_stamps(routes_modified,timeMatrix,elBounds,
                           processing_time,maxRideTime)
            
            totalDistanceMod  = 0
            totalTimeMod      = 0
            allDistancesMod   = []
            allTravelTimesMod = []
            
            for k in range(0,len(routes_modified)):
                thisRoute                = routes_modified[k]
                distanceThisRoute        = 0
                for kk in range(0,len(thisRoute)-1):
                    distanceThisRoute += distanceMatrix[thisRoute[kk]][thisRoute[kk+1]]
                timeThisRoute   = routes_modified_timeStamps[k][len(routes_modified_timeStamps[k])-1,3]-routes_modified_timeStamps[k][0,3]
                totalDistanceMod   += distanceThisRoute
                totalTimeMod       += timeThisRoute
                allDistancesMod.append(distanceThisRoute)
                allTravelTimesMod.append(timeThisRoute)
                
            J_mod = beta*cost_distance*totalDistanceMod+gamma*cost_time*totalTimeMod
            
            all_info.append([i,routes[i][j],J_reference-J_mod])
            
            delta_J.append(J_reference-J_mod)
            route_this_delta_J.append(i)
            shipment_this_delta_J.append(routes[i][j])
    

          
    costSrt         = sorted(delta_J, reverse=True)
    idxCostSrt      = sorted(range(len(delta_J)), key=lambda k: delta_J[k], reverse=True)
    shipmentsSrt    = []
    routeIdxSrt     = []
    for i in range(0,int(len(idxCostSrt))):
        shipmentsSrt.append(shipment_this_delta_J[idxCostSrt[i]])
        routeIdxSrt.append(route_this_delta_J[idxCostSrt[i]])
    
    costEliminated          = []
    shipmentEliminated      = []
    routeShipmentEliminated = []
    
    while q>0:
        y                = random.random()
        indexToEliminate = int(np.round(y**p*(len(costSrt)-1)))
        costEliminated.append(costSrt[indexToEliminate])
        shipmentEliminated.append(shipmentsSrt[indexToEliminate])
        routeShipmentEliminated.append(routeIdxSrt[indexToEliminate])
        
        last_known_route_shipments[str(shipmentsSrt[indexToEliminate])] = routes[routeIdxSrt[indexToEliminate]]
        
        costSrt.pop(indexToEliminate)
        shipmentsSrt.pop(indexToEliminate)
        routeIdxSrt.pop(indexToEliminate)
        
        
        
        q -= 1
        
    # Compute reduced routes (i.e., routes without the shipments removed
    # by the worstRemoval technique)
    routesModified   = deepcopy(routes)
    
    for i in range(0,len(shipmentEliminated)):
        thisShipment            = shipmentEliminated[i]
        thisRoute               = routeShipmentEliminated[i]
        shipmentIdxSelected     = np.where(np.array(routesModified[thisRoute])==thisShipment)[0][0]
        nShipmentsRouteSelected = int(len(routesModified[thisRoute][1:int(len(routesModified[thisRoute])/2)]))
        
        
        routesModified[thisRoute] = remove_shipment_from_route(routesModified[thisRoute],thisShipment,shipmentIdxSelected-1,
                                                               nShipmentsRouteSelected,sigma)
        
    # Assemble all routes. Append current route only if longer than 2 
    # elements (otherwise, it would mean the route only has the 
    # origin and destination depot)
    routes_worst_removal = []
    for i in range(0,int(len(routesModified))):
        if int(len(routesModified[i])) > 2:
            routes_worst_removal.append(routesModified[i])
            
    # For each route, determine time-stamps, sequence of FF and
    # sequence of GH
    modified_routes_timeStamps = []
    modified_routes_FF         = []
    modified_routes_GH         = []
    for i in range(0,int(len(routes_worst_removal))):
        modified_routes_timeStamps.append(cordeauLaporteProcedure(routes_worst_removal[i],timeMatrix,elBounds,processing_time,maxRideTime))
        modified_routes_FF.append(single_route_compute_FF_sequence(routes_worst_removal[i],pickup_nodes,Nf,Ng,sigma))
        modified_routes_GH.append(single_route_compute_GH_sequence(routes_worst_removal[i],pickup_nodes,Nf,Ng,sigma))
        

                    
    return routes_worst_removal,modified_routes_timeStamps,modified_routes_FF,modified_routes_GH,shipmentEliminated,last_known_route_shipments

#######################################################################
### Function that removes the shortest route from the set of routes ###                                   
#######################################################################
def shortest_route_removal(routes,routes_timeStamps,pickup_nodes,Nf,Ng,sigma,last_known_route_shipments):
    
    routes_length = []
    for i in range(0,len(routes)):
        # Determine length of current route
        routes_length.append(len(routes[i]))
    
    # Identify route with minimum length
    idx_route = min(enumerate(routes_length), key=operator.itemgetter(1))[0]
    
    removed_shipments = routes[idx_route][1:int(len(routes[idx_route])/2)]
    
    for i in range(0,int(len(removed_shipments))):
        last_known_route_shipments[str(removed_shipments[i])] = routes[idx_route]
    
    modified_routes            = []
    modified_routes_timeStamps = []
    modified_routes_FF         = []
    modified_routes_GH         = []
    for i in range(0,int(len(routes))):
        if i != idx_route:
            modified_routes.append(routes[i])
            modified_routes_timeStamps.append(routes_timeStamps[i])
            modified_routes_FF.append(single_route_compute_FF_sequence(routes[i],pickup_nodes,Nf,Ng,sigma))
            modified_routes_GH.append(single_route_compute_GH_sequence(routes[i],pickup_nodes,Nf,Ng,sigma))
    
    return modified_routes,modified_routes_timeStamps,modified_routes_FF,modified_routes_GH,removed_shipments,last_known_route_shipments    

############################################################
### Function that removes q shipments choosing them from ###
### randomly chosen FF-GH  pairs                         ### 
############################################################

## Old version 
##def FF_GH_removal(routes,q,timeMatrix,elBounds,
##                  processing_time,maxRideTime,
##                  sigma,pickup_nodes,Nf,Ng,last_known_route_shipments):
##    
##    modified_routes = deepcopy(routes)
##    
##    cont            = 0
##    idx_FF_GH       = 0
##    all_FF_GH_pairs = list(itertools.product(list(np.arange(0,Nf)),list(np.arange(0,Ng))))
##    random.shuffle(all_FF_GH_pairs)
##    
##    removed_shipments = []
##    while cont < q:
##        
##        this_FF              = all_FF_GH_pairs[idx_FF_GH][0]
##        this_GH              = all_FF_GH_pairs[idx_FF_GH][1]
##        shipments_this_FF_GH = pickup_nodes[this_FF][this_GH]
##        random.shuffle(shipments_this_FF_GH)
##        
##        for j in range(0,int(len(shipments_this_FF_GH))):
##            this_shipment = shipments_this_FF_GH[j]
##            for k in range(0,int(len(modified_routes))):
##               if this_shipment in modified_routes[k]:
##                   removed_shipments.append(this_shipment)
##                   last_known_route_shipments[str(this_shipment)] = routes[k]
##                   # remove pickup and delivery node
##                   modified_routes[k].remove(this_shipment)
##                   modified_routes[k].remove(this_shipment+sigma)
##                   cont += 1
##                   # If route is empty, remove route
##                   if len(modified_routes[k]) == 2:
##                       modified_routes.pop(k)
##                       
##                   break
##            if cont == q:
##                break
##       
##        idx_FF_GH += 1
##        
##    # Compute timeStamps, FF and GH sequence for reduced routes
##    modified_routes_timeStamps = []
##    modified_routes_FF         = []
##    modified_routes_GH         = []
##    for i in range(0,int(len(modified_routes))):
##        modified_routes_timeStamps.append(cordeauLaporteProcedure(modified_routes[i],timeMatrix,elBounds,processing_time,maxRideTime))
##        modified_routes_FF.append(single_route_compute_FF_sequence(modified_routes[i],pickup_nodes,Nf,Ng,sigma))
##        modified_routes_GH.append(single_route_compute_GH_sequence(modified_routes[i],pickup_nodes,Nf,Ng,sigma))
##        
##    return modified_routes,modified_routes_timeStamps,modified_routes_FF,modified_routes_GH,removed_shipments,last_known_route_shipments   
##
#new version
def FF_GH_removal(routes,q,timeMatrix,elBounds,
                  processing_time,maxRideTime,
                  sigma,pickup_nodes,Nf,Ng,last_known_route_shipments):
    
    original_routes = deepcopy(routes)
    modified_routes = deepcopy(routes)
    
    cont            = 0
    idx_FF_GH       = 0
    all_FF_GH_pairs = list(itertools.product(list(np.arange(0,Nf)),list(np.arange(0,Ng))))
    random.shuffle(all_FF_GH_pairs)
    
    removed_shipments = []
    while cont < q:
        
        this_FF              = all_FF_GH_pairs[idx_FF_GH][0]
        this_GH              = all_FF_GH_pairs[idx_FF_GH][1]
        shipments_this_FF_GH = deepcopy(pickup_nodes[this_FF][this_GH])
        random.shuffle(shipments_this_FF_GH)
        
        #print('Removing shipments:')
        #print(shipments_this_FF_GH)
        
        for j in range(0,int(len(shipments_this_FF_GH))):
            this_shipment = shipments_this_FF_GH[j]
            #print('Removing shipment:')
            #print(this_shipment)
            route_found = False
            # Find index of route where this shipment belongs to
            for k in range(0,int(len(modified_routes))):
                if this_shipment in modified_routes[k]:
                    idx_route   = k
                    route_found = True
                    break
            # If shipment is part of a route, remove the shipment
            if route_found:
                removed_shipments.append(this_shipment)
                last_known_route_shipments[str(this_shipment)] = original_routes[idx_route]
                # remove pickup and delivery node
                modified_routes[idx_route].remove(this_shipment)
                modified_routes[idx_route].remove(this_shipment+sigma)
                cont += 1
                # If route is empty, remove route
                if len(modified_routes[k]) == 2:
                    modified_routes.remove(modified_routes[idx_route])
                
                # If we removed as many shipments as necessary, exit the while cycle
                if cont == q:
                    break
       
        # If we are done with the current FF-GH pair and still need to
        # remove some shipments, go to the next FF-GH pair        
        idx_FF_GH += 1
                
        
    # Compute timeStamps, FF and GH sequence for reduced routes
    modified_routes_timeStamps = []
    modified_routes_FF         = []
    modified_routes_GH         = []
    for i in range(0,int(len(modified_routes))):
        modified_routes_timeStamps.append(cordeauLaporteProcedure(modified_routes[i],timeMatrix,elBounds,processing_time,maxRideTime))
        modified_routes_FF.append(single_route_compute_FF_sequence(modified_routes[i],pickup_nodes,Nf,Ng,sigma))
        modified_routes_GH.append(single_route_compute_GH_sequence(modified_routes[i],pickup_nodes,Nf,Ng,sigma))
        
    return modified_routes,modified_routes_timeStamps,modified_routes_FF,modified_routes_GH,removed_shipments,last_known_route_shipments   
        



        
def FF_GH_local_search_v2(routes,FFSequence,GHSequence,unassigned_shipments,shipment_FF_GH,
                       sigma,routes_timeStamps,timeMatrix,elBounds,
                          processing_time,maxRideTime,distanceMatrix,Nf,Ng,pickup_nodes,q_nodes,cap_trailer,
                        L_trailer,lat_occupancy_shipments,nDocks,alpha,beta,gamma,multiplier,cost_distance,cost_time,w_TW,w_DC,node_rev,sigmaS):
    
    modified_routes            = deepcopy(routes)
    modified_routes_timeStamps = deepcopy(routes_timeStamps)
    modified_FFSequence        = deepcopy(FFSequence)
    modified_GHSequence        = deepcopy(GHSequence)
    
    current_unassigned_shipments = deepcopy(unassigned_shipments)
    
    exit_cond = 0
        
    while exit_cond != 1 and len(current_unassigned_shipments)>0:
        
        #print('Current unassigned shipments are:')
        #print(current_unassigned_shipments)
        
        # For each unassigned shipment, compute (late_delivery - early_pickup),
        # i.e., the available time-span between pickup and delivery. Focus first 
        # on the shipment with the lowest availale time-span
        available_ts = []
        for i in range(0,int(len(current_unassigned_shipments))):
            available_ts.append(elBounds[current_unassigned_shipments[i]+sigma][1]-elBounds[current_unassigned_shipments[i]][0])
        
        this_unassigned_shipment    = current_unassigned_shipments[np.argmin(available_ts)]
        this_unassigned_shipment_FF = shipment_FF_GH[str(this_unassigned_shipment)][0]
        this_unassigned_shipment_GH = shipment_FF_GH[str(this_unassigned_shipment)][1]
        nodes_same_FF_same_GH       = list(set(pickup_nodes[this_unassigned_shipment_FF][this_unassigned_shipment_GH]) - set([this_unassigned_shipment]))
        shipments_to_check          = set(nodes_same_FF_same_GH)
        
        similar_shipments_in_route   = []
        n_similar_shipments_in_route = []
        for j in range(0,int(len(modified_routes))):
            
            idx_occurrences    = [i for i, e in enumerate(modified_routes[j]) if e in shipments_to_check]
            similar_shipments_in_route.append(idx_occurrences)
            n_similar_shipments_in_route.append(len(idx_occurrences))
        
        idx_most_similar_route = np.argmax(n_similar_shipments_in_route)
        idx_shipments_in_route = similar_shipments_in_route[idx_most_similar_route]
        
        # If the most similar routes only contains shipments going from the
        # required FF to the required GH, there is no need to split the route
        if len(idx_shipments_in_route) == len(modified_routes[idx_most_similar_route][1:int(len(modified_routes[idx_most_similar_route])/2)]):
            J_struct = []
            ###################################################
            ## Now insert the shipment in its best location ###
            ###################################################
            n_positions  = len(modified_routes[idx_most_similar_route][1:int(len(modified_routes[idx_most_similar_route])/2)+1])
            for k in range(0,n_positions):
                modified_routes[idx_most_similar_route]     = add_shipment_to_route(modified_routes[idx_most_similar_route],this_unassigned_shipment,k,n_positions,sigma)
                modified_routes_timeStamps[idx_most_similar_route] = route_time_stamps(modified_routes[idx_most_similar_route],timeMatrix,elBounds,
                    processing_time,maxRideTime)
                modified_FFSequence[idx_most_similar_route] = single_route_compute_FF_sequence(modified_routes[idx_most_similar_route],
                                                                                               pickup_nodes,Nf,Ng,sigma)
                modified_GHSequence[idx_most_similar_route] = single_route_compute_GH_sequence(modified_routes[idx_most_similar_route],
                                                                                               pickup_nodes,Nf,Ng,sigma)
                
                
                is_route_strongly_infeasible = single_route_strong_infeasibility(modified_routes[idx_most_similar_route],distanceMatrix,timeMatrix,
                                                                                 sigma,Nf,Ng,pickup_nodes,elBounds,
                                                                                 processing_time,maxRideTime,q_nodes,cap_trailer,
                                                                                 L_trailer,lat_occupancy_shipments,nDocks)
                if is_route_strongly_infeasible:
                    pass
                else:
                    dockCapacityViolation, arrDepGH, numberOfTrucksPerGH = dock_capacity_violation(modified_routes,modified_routes_timeStamps,modified_FFSequence
                                                                        ,modified_GHSequence,Nf,Ng,nDocks)
                    TW_violation = 0
                    DC_violation = dock_violation_computation(dockCapacityViolation)
                
                    J            = cost_weakly_infeasible_solution(alpha,beta,gamma,cost_distance,cost_time,
                                                  modified_routes,modified_routes_timeStamps,distanceMatrix,sigma,TW_violation,DC_violation,w_TW,w_DC,node_rev,sigmaS)
                    
                    J_struct.append([J,deepcopy(modified_routes),deepcopy(modified_routes_timeStamps),
                                    deepcopy(modified_FFSequence),deepcopy(modified_GHSequence)])
                modified_routes[idx_most_similar_route]     = remove_shipment_from_route(modified_routes[idx_most_similar_route],this_unassigned_shipment,k,n_positions,sigma)
                modified_routes_timeStamps[idx_most_similar_route] = route_time_stamps(modified_routes[idx_most_similar_route],timeMatrix,elBounds,
                    processing_time,maxRideTime)
                modified_FFSequence[idx_most_similar_route] = single_route_compute_FF_sequence(modified_routes[idx_most_similar_route],
                                                                                               pickup_nodes,Nf,Ng,sigma)
                modified_GHSequence[idx_most_similar_route] = single_route_compute_GH_sequence(modified_routes[idx_most_similar_route],
                                                                                               pickup_nodes,Nf,Ng,sigma)
            if len(J_struct) != 0:
                # Find modified set of routes with minimum cost
                all_J = []
                for j in range(0,int(len(J_struct))):
                    all_J.append(J_struct[j][0][0])
                    
                #print(all_J)
                
                idx_best_solution = np.argmin(all_J)
                best_solution     = J_struct[idx_best_solution]
                
                #print('Before change:')
                #print(modified_routes)
                
                modified_routes            = best_solution[1]
                modified_routes_timeStamps = best_solution[2]
                modified_FFSequence        = best_solution[3]
                modified_GHSequence        = best_solution[4]
                
                #print('After change:')
                #print(modified_routes)
                
                #print('Current unassigned shipments before assignment:')
                #print(current_unassigned_shipments)
                #print('Shipment we want to remove:')
                #print(this_unassigned_shipment)
                
                current_unassigned_shipments.remove(this_unassigned_shipment)
                
                #print('Current unassigned shipments after assignment:')
                #print(current_unassigned_shipments)
                
            else:
                exit_cond = 1
        else:
            #########################################################
            ### Building new route that will include the shipment ###
            #########################################################
            
            # Start with origin depot
            new_route = [0]
            # Pickup nodes
            pickup_nodes_this_route   = []
            delivery_nodes_this_route = []
            for j in range(0,int(len(idx_shipments_in_route))):
                this_pickup_node = modified_routes[idx_most_similar_route][idx_shipments_in_route[j]]
                new_route.append(this_pickup_node)
                pickup_nodes_this_route.append(this_pickup_node)
                delivery_nodes_this_route.append(this_pickup_node+sigma)
            # Delivery nodes and destination depot
            delivery_nodes_this_route = delivery_nodes_this_route[::-1]
            new_route += delivery_nodes_this_route
            new_route.append(2*sigma+1)
            
            #print(new_route)
            
            ####################################################################
            ### Update routes by splitting the route where we want to insert ###
            ### the new shipment in two parts                                ###
            ####################################################################
            
            #print(modified_routes)
            #print(modified_routes[idx_most_similar_route])
            #print('')
            
            for j in range(0,int(len(pickup_nodes_this_route))):
                modified_routes[idx_most_similar_route].remove(pickup_nodes_this_route[j])
                #print(modified_routes[idx_most_similar_route])
            for j in range(0,int(len(delivery_nodes_this_route))):
                modified_routes[idx_most_similar_route].remove(delivery_nodes_this_route[j])
                #print(modified_routes[idx_most_similar_route])
                
            modified_routes.append(new_route)
            
            modified_routes_timeStamps[idx_most_similar_route] = route_time_stamps(modified_routes[idx_most_similar_route],timeMatrix,
                                                                                   elBounds,processing_time,maxRideTime)
            modified_routes_timeStamps.append(route_time_stamps(modified_routes[-1],timeMatrix,
                                                                                   elBounds,processing_time,maxRideTime))
            #print(modified_routes)
            #print(modified_routes_timeStamps)
            
            ######################################################################
            ### Modify FF and GH sequence of the reduced route and of the newly
            ### created routes
            ######################################################################
            
            
            modified_FFSequence[idx_most_similar_route] = single_route_compute_FF_sequence(modified_routes[idx_most_similar_route],
                                                                                               pickup_nodes,Nf,Ng,sigma)
            modified_GHSequence[idx_most_similar_route] = single_route_compute_GH_sequence(modified_routes[idx_most_similar_route],
                                                                                               pickup_nodes,Nf,Ng,sigma)
            
            thisFFSequence=[]
            for idxPickup in range(1,int(len(modified_routes[-1])/2)+1):
                for idxFF in range(0,Nf):
                    for idxGH in range(0,Ng):
                        if modified_routes[-1][idxPickup] in pickup_nodes[idxFF][idxGH]:
                            thisFFSequence.append(idxFF)
            modified_FFSequence.append(single_route_compute_FF_sequence(modified_routes[-1],
                                       pickup_nodes,Nf,Ng,sigma))
            modified_GHSequence.append(single_route_compute_GH_sequence(modified_routes[-1],
                                       pickup_nodes,Nf,Ng,sigma))
            
            
            J_struct = []
            ###################################################
            ## Now insert the shipment in its best location ###
            ###################################################
            n_positions  = len(new_route[1:int(len(new_route)/2)+1])
            for k in range(0,n_positions):
                modified_routes[-1] = add_shipment_to_route(modified_routes[-1],this_unassigned_shipment,k,n_positions,sigma)
                modified_routes_timeStamps[-1] = route_time_stamps(modified_routes[-1],timeMatrix,elBounds,
                    processing_time,maxRideTime)
                modified_FFSequence[-1] = single_route_compute_FF_sequence(modified_routes[-1],
                                       pickup_nodes,Nf,Ng,sigma)
                modified_GHSequence[-1] = single_route_compute_GH_sequence(modified_routes[-1],
                                       pickup_nodes,Nf,Ng,sigma)
                
                
                is_route_strongly_infeasible = single_route_strong_infeasibility(modified_routes[-1],distanceMatrix,timeMatrix,
                                                                                 sigma,Nf,Ng,pickup_nodes,elBounds,
                                                                                 processing_time,maxRideTime,q_nodes,cap_trailer,
                                                                                 L_trailer,lat_occupancy_shipments,nDocks)
                if is_route_strongly_infeasible:
                    pass
                   
                    
                else:
                    dockCapacityViolation, arrDepGH, numberOfTrucksPerGH = dock_capacity_violation(modified_routes,modified_routes_timeStamps,modified_FFSequence
                                                                        ,modified_GHSequence,Nf,Ng,nDocks)
                    TW_violation = 0
                    DC_violation = dock_violation_computation(dockCapacityViolation)
                
                    J            = cost_weakly_infeasible_solution(alpha,beta,gamma,cost_distance,cost_time,
                                                  modified_routes,modified_routes_timeStamps,distanceMatrix,sigma,TW_violation,DC_violation,w_TW,w_DC,node_rev,sigmaS)
                    
                    J_struct.append([J,deepcopy(modified_routes),deepcopy(modified_routes_timeStamps),
                                    deepcopy(modified_FFSequence),deepcopy(modified_GHSequence)])
                    
                modified_routes[-1] = remove_shipment_from_route(modified_routes[-1],this_unassigned_shipment,k,n_positions,sigma)
                modified_routes_timeStamps[-1] = route_time_stamps(modified_routes[-1],timeMatrix,elBounds,
                    processing_time,maxRideTime)
                modified_FFSequence[-1] = single_route_compute_FF_sequence(modified_routes[-1],
                                       pickup_nodes,Nf,Ng,sigma)
                modified_GHSequence[-1] = single_route_compute_GH_sequence(modified_routes[-1],
                                       pickup_nodes,Nf,Ng,sigma)
            
            if len(J_struct) != 0:
                # Find modified set of routes with minimum cost
                all_J = []
                for j in range(0,int(len(J_struct))):
                    all_J.append(J_struct[j][0][0])
                    
                #print(all_J)
                
                idx_best_solution = np.argmin(all_J)
                best_solution     = J_struct[idx_best_solution]
                
                modified_routes            = best_solution[1]
                modified_routes_timeStamps = best_solution[2]
                modified_FFSequence        = best_solution[3]
                modified_GHSequence        = best_solution[4]
                
                current_unassigned_shipments.remove(this_unassigned_shipment)
                
            else:
                exit_cond = 1
    
    return modified_routes, modified_routes_timeStamps, modified_FFSequence, modified_GHSequence, current_unassigned_shipments           

def dock_capacity_violation_resolver_v2(routes,routes_timeStamps,timeMatrix,elBounds,processing_time,maxRideTime,
                                     dockCapacityViolation,arrDepGH,FFSequence,GHSequence,Nf,Ng,nDocks):
    
    forwardSlackAllRoutes = []
    for i in range(0,len(routes)):
        forwardSlackAllRoutes.append(forward_slack_computation(routes[i],routes_timeStamps[i],elBounds,processing_time,maxRideTime))
    
    allTimeShifts         = []
    maxAllowedTWViolation = 100
    
    cont = 0
    while len(dockCapacityViolation)!=0 and cont<=50:
        
        startTimeDockCapViol = []
        for i in range(0,len(dockCapacityViolation)):
            startTimeDockCapViol.append(dockCapacityViolation[i][0][0])
        
        # Find first dock capacity violation
        index, value = min(enumerate(startTimeDockCapViol), key=operator.itemgetter(1))
        
        #print 'First violation occurs at ' + str(value) + ' minute in GH ' + str(dockCapacityViolation2[index][2])
        
        # ID of GH where this violation occurs
        thisGHIdx     = dockCapacityViolation[index][2]
        # Identify which trucks cause the violation 
        arrivalTimesGH   = []
        departureTimesGH = []
        firstNodeGH      = []
        for i in range(0,len(dockCapacityViolation[index][1])):
            arrivalTimesGH.append(arrDepGH[dockCapacityViolation[index][1][i]][thisGHIdx][0])
            departureTimesGH.append(arrDepGH[dockCapacityViolation[index][1][i]][thisGHIdx][1])
            firstNodeGH.append(arrDepGH[dockCapacityViolation[index][1][i]][thisGHIdx][2])
        # For each truck involved in the capacity violation, compute
        # the quantity max(Slack-Shift,0), which quantifies the slack left
        # if that truck is delayed to alleviate the dock capacity violation.
        # We in fact decide to delay the truck for which the difference between
        # the slack and the necessary shift, i.e., the residual slack, is maximum.
        # This means that the truck we delay is the one where the effect of the
        # delay is "smaller", in the sense that the residual slack is still the largest
        slackMinusShift = []
        shiftRoutes     = []
        idxNodeRoutes   = []
        arr_truck       = []
        for i in range(0,len(dockCapacityViolation[index][1])):
            idxNodeInRoute = np.where(np.array(routes[dockCapacityViolation[index][1][i]])==firstNodeGH[i])[0][0]
            idxNodeRoutes.append(idxNodeInRoute)
            
            indexArrTruck = dockCapacityViolation[index][1][i]
            idxOtherRoutesInCongestedGH = [item for item in dockCapacityViolation[index][1] if item not in [indexArrTruck]]
            
            # Store the departure time of all the other trucks docked at this GH
            otherTrucksDepartureTime = []
            for j in range(0,len(idxOtherRoutesInCongestedGH)):
                otherTrucksDepartureTime.append(arrDepGH[idxOtherRoutesInCongestedGH[j]][thisGHIdx][1])
            
            # Compute time-shift for current truck (how many minutes the truck
            # must be pushed back to solve dock capacity violation)
            timeShift = np.min(np.array(otherTrucksDepartureTime))-arrDepGH[indexArrTruck][thisGHIdx][0]

            shiftRoutes.append(timeShift)
            
            # Compute slack minus time-shift. if the difference is negative, set it to 0.
            # A slack minus time-shift = 0 means that applying the associated time-shift
            # will increase the time-window violation in the current route
            slackMinusShift.append(np.max([0,forwardSlackAllRoutes[dockCapacityViolation[index][1][i]][idxNodeInRoute]-
                               timeShift]))
            arr_truck.append(arrDepGH[indexArrTruck][thisGHIdx][0])
        #print 'SlackMinusShift vector is :'
        #print slackMinusShift
        # Determine truck to be delayed and update its time variable matrix.
        # The truck to be delayed is the one where slackMinusShift is max
        #indexTruck, slackMinusShiftTruck = max(enumerate(slackMinusShift), key=operator.itemgetter(1))
        indexTruck           = np.argmin(arr_truck)
        slackMinusShiftTruck = slackMinusShift[indexTruck]
        
        if slackMinusShiftTruck>0:
            
            truckIdx          = dockCapacityViolation[index][1][indexTruck]
            thisTimeShift     = shiftRoutes[indexTruck]
            idxNodeApplyShift = idxNodeRoutes[indexTruck]
            allTimeShifts.append(thisTimeShift)
            
            routes_timeStamps[truckIdx][idxNodeApplyShift][2] += thisTimeShift
            routes_timeStamps[truckIdx][idxNodeApplyShift][3] += thisTimeShift
            #routes_timeStamps[truckIdx][idxNodeApplyShift][1]  = np.max([routes_timeStamps[truckIdx][idxNodeApplyShift][2]-
            #                                                             routes_timeStamps[truckIdx][idxNodeApplyShift][0],0])
            
            # For all nodes from the first node of the ground
            # handler where the violation has been resolved onwards, shift
            # time forward (note that the time-shift could be different w.r.t.
            # the time-shift of the nodes before)
            for j in range(idxNodeApplyShift+1,len(routes_timeStamps[truckIdx])):
                thisNode        = int(routes[truckIdx][j])
                
                routes_timeStamps[truckIdx][j][0] = routes_timeStamps[truckIdx][j-1][3]+timeMatrix[routes[truckIdx][j-1]][thisNode]
                routes_timeStamps[truckIdx][j][1] = np.max([elBounds[thisNode][0]-routes_timeStamps[truckIdx][j][0],0])
                routes_timeStamps[truckIdx][j][2] = routes_timeStamps[truckIdx][j][0]+routes_timeStamps[truckIdx][j][1]
                routes_timeStamps[truckIdx][j][3] = routes_timeStamps[truckIdx][j][2]+processing_time[thisNode]
                routes_timeStamps[truckIdx][j][4] = maxRideTime[thisNode-1]
             
            # Re-compute dock-capacity violations
            dockCapacityViolation,arrDepGH,numberOfTrucksPerGH = dock_capacity_violation(routes,
                                                                    routes_timeStamps,FFSequence,GHSequence,
                                                                    Nf,Ng,nDocks)
            
            TWViolation = time_violation_computation(routes,routes_timeStamps,elBounds)
            

            
            # Note 1: the code should be slightly changed so that, if TW>0, we output
            # the solution prior to the last change. In fact, if we break che code here,
            # now what we obtain is a solution where TW have been violated
            # Note 2: we assume that initially TWViolation=0, otherwise the code would break 
            # immediately. An alternative is to determine the initial TW
            # TWInitial, and break the code if TWCurrent > TWInitial (i.e.,
            # we keep modifying a solution tat does not satify time-windows as long as 
            # we are not increasing the TW violation)
            if TWViolation > maxAllowedTWViolation:
                break
    
            cont += 1
            
            # If there are no more dock capacity violations, break the code
            if len(dockCapacityViolation) == 0:
                pass
                #print('All dock capacity violations were resolved!!!')
            
            #print '%%%%%%%%%%%%%%%%%%%%'
            #print '%%%%%%%%%%%%%%%%%%%%' 
            #print '%%%%%%%%%%%%%%%%%%%%'
        
        # We cannot delay any of the trucks involved without worsening the
        # TW violation
        else:
            #print '%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%'
            #print '%%% Stop: we would increase TW violation otherwise %%%'
            #print '%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%'
            
            break
    
    ############################################################
    ### Route overall transportation time reduction routine  ###
    ############################################################
    # Detect where we have possible delays, i.e., where A[j]+W[j]<B[j], which 
    # means that we introduced an additional delay in the route because of a
    # dock capacity violation
    possibleUnnecessaryDelays = []
    for i in range(0,len(routes_timeStamps)):
        thisGHSequence    = GHSequence[i]
        uniqueGHSequence  = list(OrderedDict.fromkeys(thisGHSequence))
        thisTimeVarMatrix = routes_timeStamps[i]
        for j in range(int(len(thisTimeVarMatrix)/2),int(len(thisTimeVarMatrix))):
            if thisTimeVarMatrix[j,2]>thisTimeVarMatrix[j,0]+thisTimeVarMatrix[j,1]:
                
                # Determine if it is the first, second, third GH visited and
                # if the node where service is delayed is the first, second,
                # third in the GH (it should always be the first one, since
                # if we delay the service because a dock is not available, we
                # are affecting the service time of the first shipment in the
                # current GH)
                
                idxGH                  = np.where(np.array(uniqueGHSequence)==thisGHSequence[j-int(len(thisTimeVarMatrix)/2)])[0][0]
                idxFirstShipmentThisGH = np.where(np.array(thisGHSequence)==thisGHSequence[j-int(len(thisTimeVarMatrix)/2)])[0][0]
                idxShipmentInGH        = j-int(len(thisTimeVarMatrix)/2)-idxFirstShipmentThisGH
                
                # If shipment is the first one in current GH
                if idxShipmentInGH == 0:
                    possibleUnnecessaryDelays.append([i,thisGHSequence[j-int(len(thisTimeVarMatrix)/2)],idxGH,idxShipmentInGH,
                               thisTimeVarMatrix[j,2]-(thisTimeVarMatrix[j,0]+thisTimeVarMatrix[j,1]),                 
                               thisTimeVarMatrix[j,0],thisTimeVarMatrix[j,1],
                               thisTimeVarMatrix[j,2],thisTimeVarMatrix[j,3],j])
    
    # Sort the cases where A[j]+W[j]<B[j] by increasing value of time          
    startServiceTime = []
    for i in range(0,len(possibleUnnecessaryDelays)):            
        startServiceTime.append(possibleUnnecessaryDelays[i][5])
    
    idxStartServiceTimeSrt = sorted(range(len(startServiceTime)), key=lambda k: startServiceTime[k], reverse=False)
    
    
    # Try to shift forward departure time of trucks that were delayed at the
    # ground handler side (if possible), to reduce the overall transportation time
    for cont in range(0,len(possibleUnnecessaryDelays)):
        
        dockA,dockB,dockC,dockD,dockE = dockOccupancy(routes,routes_timeStamps,FFSequence,GHSequence,
                         Nf,Ng,nDocks)
        
        
        idxFirst = idxStartServiceTimeSrt[cont]
            
        firstDelayRoute         = possibleUnnecessaryDelays[idxFirst][0] 
        firstDelayIdxGH         = possibleUnnecessaryDelays[idxFirst][2]
        firstDelayExtraTime     = possibleUnnecessaryDelays[idxFirst][4]
        positionShipmentInRoute = possibleUnnecessaryDelays[idxFirst][9] 
        
        # If the ground handler is the first one visited, we do not need to check
        # what happens in previous ground handlers. We compare how much we would 
        # need to delay the departure, with the minimum slack before visiting the 
        # current ground handler. The minimum value between the two values is used
        # to shift the route forward in time
        if firstDelayIdxGH == 0:
            forwardSlack    = forward_slack_computation(routes[firstDelayRoute],routes_timeStamps[firstDelayRoute],
                                                   elBounds,processing_time,maxRideTime)
            minSlack        = np.min(np.array(forwardSlack[0:positionShipmentInRoute+1]))
            admissibleShift = np.min([minSlack,firstDelayExtraTime])
            
            routes_timeStamps[firstDelayRoute][0][2] += admissibleShift
            routes_timeStamps[firstDelayRoute][0][3] += admissibleShift
            for j in range(1,positionShipmentInRoute):
                thisNode        = int(routes[firstDelayRoute][j])
                routes_timeStamps[firstDelayRoute][j][0] = routes_timeStamps[firstDelayRoute][j-1][3]+timeMatrix[routes[firstDelayRoute][j-1]][thisNode]
                routes_timeStamps[firstDelayRoute][j][1] = np.max([elBounds[thisNode][0]-routes_timeStamps[firstDelayRoute][j][0],0])
                routes_timeStamps[firstDelayRoute][j][2] = routes_timeStamps[firstDelayRoute][j][0]+routes_timeStamps[firstDelayRoute][j][1]
                routes_timeStamps[firstDelayRoute][j][3] = routes_timeStamps[firstDelayRoute][j][2]+processing_time[thisNode]
                routes_timeStamps[firstDelayRoute][j][4] = maxRideTime[thisNode] 
            thisNode = int(routes[firstDelayRoute][positionShipmentInRoute])
            #timeVarMatrixRoutes[firstDelayRoute][positionShipmentInRoute][0] = timeVarMatrixRoutes[firstDelayRoute][j-1][3]+timeMatrix[newSetOfRoutes[firstDelayRoute][positionShipmentInRoute-1]][newSetOfRoutes[firstDelayRoute][positionShipmentInRoute]]    
            routes_timeStamps[firstDelayRoute][positionShipmentInRoute][0] += admissibleShift
        # Otherwise, we also need to verify what happens in the previous ground
        # handlers that are visited to avoid the creation of new unplanned
        # dock capacity violations upstream
        else:
            thisGHSequence    = GHSequence[firstDelayRoute]
            uniqueGHSequence  = list(OrderedDict.fromkeys(thisGHSequence))
            maxDelayPreviousGHs = []
            for ii in range(0,firstDelayIdxGH):
                thisGH             = uniqueGHSequence[ii]
                idxThisRouteThisGH = []
                for jj in range(0,len(dockD[thisGH])):
                    if firstDelayRoute in dockD[thisGH][jj]:
                        idxThisRouteThisGH.append(jj)
                lastIdx = idxThisRouteThisGH[-1]
                finalServiceTime = dockE[thisGH][lastIdx+1]
                firstPotentialIndex = lastIdx+1
                while firstPotentialIndex<len(dockD[thisGH])-1:
                    if len(dockD[thisGH][firstPotentialIndex]) <= nDocks[thisGH]-1:
                        firstPotentialIndex += 1
                    else:
                        break
                maxDelayPreviousGHs.append(dockE[thisGH][firstPotentialIndex]-finalServiceTime)
            
            maxAdmissibleDelayPreviousGH = np.min(maxDelayPreviousGHs)
            
            forwardSlack    = forward_slack_computation(routes[firstDelayRoute],routes_timeStamps[firstDelayRoute],
                                                   elBounds,processing_time,maxRideTime)
            minSlack        = forwardSlack[0]
            
            admissibleShift = np.min([minSlack,firstDelayExtraTime,maxAdmissibleDelayPreviousGH])
            
            routes_timeStamps[firstDelayRoute][0][2] += admissibleShift
            routes_timeStamps[firstDelayRoute][0][3] += admissibleShift
            for j in range(1,positionShipmentInRoute):
                thisNode        = int(routes[firstDelayRoute][j])
                routes_timeStamps[firstDelayRoute][j][0] = routes_timeStamps[firstDelayRoute][j-1][3]+timeMatrix[routes[firstDelayRoute][j-1]][thisNode]
                routes_timeStamps[firstDelayRoute][j][1] = np.max([elBounds[thisNode][0]-routes_timeStamps[firstDelayRoute][j][0],0])
                routes_timeStamps[firstDelayRoute][j][2] = routes_timeStamps[firstDelayRoute][j][0]+routes_timeStamps[firstDelayRoute][j][1]
                routes_timeStamps[firstDelayRoute][j][3] = routes_timeStamps[firstDelayRoute][j][2]+processing_time[thisNode]
                routes_timeStamps[firstDelayRoute][j][4] = maxRideTime[thisNode] 
            thisNode = int(routes[firstDelayRoute][positionShipmentInRoute])
            #timeVarMatrixRoutes[firstDelayRoute][positionShipmentInRoute][0] = timeVarMatrixRoutes[firstDelayRoute][j-1][3]+timeMatrix[newSetOfRoutes[firstDelayRoute][positionShipmentInRoute-1]][newSetOfRoutes[firstDelayRoute][positionShipmentInRoute]]    
            routes_timeStamps[firstDelayRoute][positionShipmentInRoute][0] += admissibleShift    


    return routes,routes_timeStamps,dockCapacityViolation,arrDepGH,numberOfTrucksPerGH

def initial_solution_greedy_algorithm(updatedUnassignedShipments,
                       timeMatrix,elBounds,processing_time,maxRideTime,Nf,Ng,sigma,q_nodes,
                       cap_trailer,pickup_nodes,distanceMatrix,
                       maxRideTimeTruck,w_TW,w_DC,lat_occupancy_shipments,L_trailer,
                       nDocks,alpha,beta,gamma,cost_distance,cost_time,node_rev,sigmaS):

    unassigned_shipments_copy          = deepcopy(updatedUnassignedShipments)
    initial_solution_routes            = []
    initial_solution_routes_timeStamps = []
    initial_solution_routes_FF         = []
    initial_solution_routes_GH         = []
    
    # Cycle until all shipments have been assigned
    while len(unassigned_shipments_copy) != 0:
        
        # Build a new empty route (or better, a route that starts at the
        # origin depot and ends at the destination depot)
        new_route = [0,int(2*sigma+1)]
        
        initial_solution_routes.append(new_route)
        initial_solution_routes_timeStamps.append(np.empty([2,5]))
        initial_solution_routes_FF.append([0])
        initial_solution_routes_GH.append([0])
        
        cond_exit         = False
        # Initialize weight and length of current route
        this_route_weight = 0
        this_route_length = 0
        
        # Keep building the route until there is at least a feasible 
        # insertion point 
        while cond_exit is False:
            
            J_list   = []
            all_info = []
            # Cycling over all the remaining unassigned shipments
            for i in range(0,len(unassigned_shipments_copy)):
                
                thisShipment             = unassigned_shipments_copy[i]
                
                # If this shipment can fit both in terms of weight and 
                # length, try the insertion
                if (q_nodes[thisShipment-1]<=cap_trailer-this_route_weight and
                    lat_occupancy_shipments[thisShipment-1]<=L_trailer-this_route_length):
                    
                    n_positions  = len(initial_solution_routes[-1][1:int(len(initial_solution_routes[-1])/2)])+1
                    
                    for k in range(0,n_positions):
                        initial_solution_routes[-1] = add_shipment_to_route(initial_solution_routes[-1],unassigned_shipments_copy[i],k,n_positions,sigma)
                        thisFFSequence = single_route_compute_FF_sequence(initial_solution_routes[-1],pickup_nodes,Nf,Ng,sigma)
                        thisGHSequence = single_route_compute_GH_sequence(initial_solution_routes[-1],pickup_nodes,Nf,Ng,sigma)
                        initial_solution_routes_timeStamps[-1] = route_time_stamps(initial_solution_routes[-1],timeMatrix,elBounds,
                           processing_time,maxRideTime)
                        initial_solution_routes_FF[-1] = thisFFSequence
                        initial_solution_routes_GH[-1] = thisGHSequence
                        
                        
                        is_route_strongly_infeasible = single_route_strong_infeasibility(initial_solution_routes[-1],distanceMatrix,timeMatrix,sigma,Nf,Ng,pickup_nodes,elBounds,
                                                                                         processing_time,maxRideTime,q_nodes,cap_trailer,
                                                                                         L_trailer,lat_occupancy_shipments,nDocks)
                        if is_route_strongly_infeasible:
                            pass
                        else:
                            dockCapacityViolation, arrDepGH, numberOfTrucksPerGH = dock_capacity_violation(initial_solution_routes,initial_solution_routes_timeStamps,
                                                                                                           initial_solution_routes_FF,initial_solution_routes_GH,
                                                                               Nf,Ng,nDocks)
                            TW_violation = 0
                            DC_violation = dock_violation_computation(dockCapacityViolation)
                        
                            J            = cost_weakly_infeasible_solution(alpha,beta,gamma,cost_distance,cost_time,
                                                          initial_solution_routes,initial_solution_routes_timeStamps,distanceMatrix,sigma,TW_violation,DC_violation,w_TW,w_DC,node_rev,sigmaS)
                        
                            J_list.append(J[0])
                            all_info.append([J[0],deepcopy(initial_solution_routes),unassigned_shipments_copy[i],deepcopy(initial_solution_routes_timeStamps),
                                             deepcopy(initial_solution_routes_FF),deepcopy(initial_solution_routes_GH)])
                        
                        initial_solution_routes[-1] = remove_shipment_from_route(initial_solution_routes[-1],unassigned_shipments_copy[i],k,n_positions,sigma)
                        thisFFSequence = single_route_compute_FF_sequence(initial_solution_routes[-1],pickup_nodes,Nf,Ng,sigma)
                        thisGHSequence = single_route_compute_GH_sequence(initial_solution_routes[-1],pickup_nodes,Nf,Ng,sigma)
                        initial_solution_routes_timeStamps[-1] = route_time_stamps(initial_solution_routes[-1],timeMatrix,elBounds,
                           processing_time,maxRideTime)
                        initial_solution_routes_FF[-1] = thisFFSequence
                        initial_solution_routes_GH[-1] = thisGHSequence
                        
            # Determine what is the best insertion
            if len(J_list) > 0:
                
                idx_J                = np.argmin(J_list)
                # Update info of modified route
                initial_solution_routes            = all_info[idx_J][1]
                initial_solution_routes_timeStamps = all_info[idx_J][3]
                initial_solution_routes_FF         = all_info[idx_J][4]
                initial_solution_routes_GH         = all_info[idx_J][5]
                this_route_weight                  += q_nodes[all_info[idx_J][2]-1]
                this_route_length                  += lat_occupancy_shipments[all_info[idx_J][2]-1]
                unassigned_shipments_copy.remove(all_info[idx_J][2])
                
                
                    
            else:
                cond_exit = True
            
    return initial_solution_routes 
                    





























