# -*- coding: utf-8 -*-
"""
Created on Wed Feb 19 15:59:29 2020

@author: abombelli

Adjusted by: S van Alebeek
"""

import numpy as np
import os
import openpyxl
import pandas as pd
import time
import operator
from copy import deepcopy
import random
import matplotlib.pyplot as plt
from collections import OrderedDict
import itertools
import alns_functions as alsn


def alns_over(shipments,timeMatrix,elBounds,processing_time,maxRideTime,Nf,Ng,Nt,sigma,q_nodes,
        cap_trailer,pickup_nodes,distanceMatrix, maxRideTimeTruck,w_TW,w_DC,lat_occupancy_shipments,
        L_trailer,nDocks,alpha,beta,gamma,cost_distance,cost_time,node_rev,multiplier,shipment_FF_GH,
        Q_truck,q_min,T,cooling_coeff,n_iter,n_time):

    setup_time_begin = time.time()
    q_min = min(4,max(len(shipments)-2,1))
    sigmaS = len(shipments)
    unassigned_shipments = deepcopy(shipments)
    all_shipments = deepcopy(shipments)
    
    ###############################
    ### INITIAL SOLUTION: start ###
    ###############################
    routes = alsn.initial_solution_greedy_algorithm(unassigned_shipments,
                       timeMatrix,elBounds,processing_time,maxRideTime,Nf,Ng,sigma,q_nodes,
                       cap_trailer,pickup_nodes,distanceMatrix,
                       maxRideTimeTruck,w_TW,w_DC,lat_occupancy_shipments,L_trailer,
                       nDocks,alpha,beta,gamma,cost_distance,cost_time,node_rev,sigmaS)  

    # Determine current unassigned shipments
    current_assigned_shipments = []
    for i in range(0,len(routes)):
        for j in range(1,int(len(routes[i])/2)):
            current_assigned_shipments.append(routes[i][j])
    s = set(current_assigned_shipments)
    current_unassigned_shipments = [x for x in all_shipments if x not in s]

    # Dictionary with the last known route a shipment was part of. Used 
    # for tabu moves
    last_known_route_shipments = dict()
    for i in range(0,int(len(unassigned_shipments))):
        last_known_route_shipments[str(i+1)] = []

    routes_timeStamps = alsn.routes_time_stamps(routes,timeMatrix,elBounds,
                               processing_time,maxRideTime)

    ##############################################################################
    ### Determine objective function: start
    ##############################################################################
    is_current_solution_strongly_infeasible, FFSequence, GHSequence = alsn.strong_infeasibility(routes,distanceMatrix,timeMatrix,routes_timeStamps,sigma,Nf,Ng,pickup_nodes,elBounds,
                           processing_time,maxRideTime,q_nodes,cap_trailer,
                           L_trailer,lat_occupancy_shipments,nDocks)

    if is_current_solution_strongly_infeasible:
        # Current solution is strongly infeasible. The cost associated with such
        # solution is set to a high value
        J_initial = alsn.cost_strongly_infeasible_solution(alpha,beta,gamma,multiplier,cost_distance,cost_time,
                                          routes,routes_timeStamps,distanceMatrix,sigma,node_rev,sigmaS)
    else:
        # Solution is not strongly infeasible. Dock capacity violations must be 
        # checked and resolved (if possible)
        dockCapacityViolation, arrDepGH, numberOfTrucksPerGH = alsn.dock_capacity_violation(routes,routes_timeStamps,FFSequence,GHSequence,
                                                              Nf,Ng,nDocks)
        
        # At least a dock violation occurs
        if len(dockCapacityViolation) != 0:
            routes,routes_timeStamps,dockCapacityViolation,arrDepGH,numberOfTrucksPerGH = alsn.dock_capacity_violation_resolver(routes,routes_timeStamps,timeMatrix,elBounds,processing_time,maxRideTime,
                                         dockCapacityViolation,arrDepGH,FFSequence,GHSequence,Nf,Ng,nDocks)
        
        # Determine time window violation (if any) and dock capacity 
        # violation (if any) and compute objective function
        TW_violation = alsn.time_violation_computation(routes,routes_timeStamps,elBounds)
        DC_violation = alsn.dock_violation_computation(dockCapacityViolation)
        
        J_initial            = alsn.cost_weakly_infeasible_solution(alpha,beta,gamma,cost_distance,cost_time,
                                          routes,routes_timeStamps,distanceMatrix,sigma,TW_violation,DC_violation,w_TW,w_DC,node_rev,sigmaS)

    #%%

    ##############################################
    ### Initializing best and current solution ###
    ##############################################    
    best_J                    = deepcopy(J_initial[0])
    best_routes               = deepcopy(routes)
    best_routes_timeStamps    = deepcopy(routes_timeStamps)
    best_routes_FF            = deepcopy(FFSequence)
    best_routes_GH            = deepcopy(GHSequence)
    current_J                 = deepcopy(J_initial[0])
    current_routes            = deepcopy(routes)
    current_routes_timeStamps = deepcopy(routes_timeStamps)

    ##############################################################################
    ### Determine objective function: end
    ##############################################################################    

    #############################
    ### INITIAL SOLUTION: end ###
    #############################

    n_removals                = 5
    n_insertions              = 4
    #n_insertions              = 6
    weights_removal   = np.ones(n_removals)/n_removals 
    weights_insertion = np.ones(n_insertions)/n_insertions
    p = 10
    cont = 0

    best_solution_evolution_J    = []
    current_solution_evolution_J = []

    print('initial routes',current_routes)

    setup_time = time.time() - setup_time_begin
    over_time = 0
    while (cont < n_iter and (over_time + setup_time) < n_time):# and T >= 0.1):
        begin_time = time.time()
        print('%%%%%%%%%%%%%%%%%%%%%%%%')
        print('Iteration %i'%(cont+1))
        #print('current routes before remove', current_routes)
        removal_cumsum          = np.cumsum(weights_removal)
        insertion_cumsum        = np.cumsum(weights_insertion)
        random_number_removal   = np.sum(weights_removal)*random.random()
        random_number_insertion = np.sum(weights_insertion)*random.random()
        idx_removal_move        = np.where(removal_cumsum>random.random())[0][0]
        idx_insertion_move      = np.where(insertion_cumsum>random.random())[0][0]
        #idx_insertion_move      = 2

        shipments_in_current_route = len(shipments) - len(current_unassigned_shipments)
        q = np.max([q_min,int(np.round(len(current_unassigned_shipments))/2)])
        #print('q',q)
        if shipments_in_current_route <= q:
            q = shipments_in_current_route
        #print('q_after',q)
            
        if idx_removal_move == 0:
            print('random')
            output_removal = alsn.random_removal(current_routes, sigma, q, timeMatrix, elBounds, processing_time,
                                           maxRideTime, pickup_nodes, Nf, Ng, last_known_route_shipments)
        elif idx_removal_move == 1:
            print('Shaw')
            output_removal = alsn.shaw_removal(p,current_routes,q,current_routes_timeStamps,timeMatrix,elBounds,
                     processing_time,maxRideTime,Nf,Ng,sigma,q_nodes,
                     Q_truck,pickup_nodes,nDocks,distanceMatrix,maxRideTimeTruck,maxRideTime,last_known_route_shipments)
        elif idx_removal_move == 2:
        #else:
            print('worst')
            output_removal = alsn.worst_removal(p,current_routes,q,current_routes_timeStamps,distanceMatrix,timeMatrix,
                           elBounds,processing_time,maxRideTime,cost_distance,cost_time,beta,gamma,
                           sigma,pickup_nodes,Nf,Ng,last_known_route_shipments,sigmaS)
        elif idx_removal_move == 3:
            if len(current_routes) > 1:
            #print(current_routes)
                print('shortest route')
                output_removal = alsn.shortest_route_removal(current_routes,current_routes_timeStamps,pickup_nodes,Nf,Ng,sigma,last_known_route_shipments)
            else:
                print('random')
                output_removal = alsn.random_removal(current_routes, sigma, q, timeMatrix, elBounds, processing_time,
                                           maxRideTime, pickup_nodes, Nf, Ng, last_known_route_shipments)
        else:
            print('FF-GH')
            output_removal = alsn.FF_GH_removal(current_routes,q,timeMatrix,elBounds,
                      processing_time,maxRideTime,
                      sigma,pickup_nodes,Nf,Ng,last_known_route_shipments)

        #print('Recap length lists after removal: start')
        #print(len(output_removal[0]))
        #print(len(output_removal[1]))
        #print(len(output_removal[2]))
        #print(len(output_removal[3]))
        #print('Recap length lists after removal: end')
            
        ########################################
        ### Compute cost after removal phase ###
        ########################################
        
        is_current_solution_strongly_infeasible, FFSequence, GHSequence = alsn.strong_infeasibility(output_removal[0],distanceMatrix,timeMatrix,output_removal[1],sigma,Nf,Ng,pickup_nodes,elBounds,
                                processing_time,maxRideTime,q_nodes,cap_trailer,
                                L_trailer,lat_occupancy_shipments,nDocks)
        
        if is_current_solution_strongly_infeasible:
            # Current solution is strongly infeasible. The cost associated with such
            # solution is set to a high value
            J = alsn.cost_strongly_infeasible_solution(alpha,beta,gamma,multiplier,cost_distance,cost_time,
                                              output_removal[0],output_removal[1],distanceMatrix,sigma,node_rev,sigmaS)
            routes_after_removal_mod            = deepcopy(output_removal[0])
            routes_timeStamps_after_removal_mod = deepcopy(output_removal[1])
        else:
            # Solution is not strongly infeasible. Dock capacity violations must be 
            # checked and resolved (if possible)
            dockCapacityViolation, arrDepGH, numberOfTrucksPerGH = alsn.dock_capacity_violation(output_removal[0],output_removal[1],output_removal[2],output_removal[3],
                                                                  Nf,Ng,nDocks)
            
            # At least a dock violation occurs
            if len(dockCapacityViolation) != 0:
                routes_after_removal_mod,routes_timeStamps_after_removal_mod,dockCapacityViolation,arrDepGH,numberOfTrucksPerGH = alsn.dock_capacity_violation_resolver(output_removal[0],output_removal[1],timeMatrix,elBounds,processing_time,maxRideTime,
                                              dockCapacityViolation,arrDepGH,output_removal[2],output_removal[3],Nf,Ng,nDocks)
            else:
                routes_after_removal_mod            = deepcopy(output_removal[0])
                routes_timeStamps_after_removal_mod = deepcopy(output_removal[1])
            
            # Determine time window violation (if any) and dock capacity 
            # violation (if any) and compute objective function
            TW_violation = alsn.time_violation_computation(routes_after_removal_mod,routes_timeStamps_after_removal_mod,elBounds)
            DC_violation = alsn.dock_violation_computation(dockCapacityViolation)
            
            J            = alsn.cost_weakly_infeasible_solution(alpha,beta,gamma,cost_distance,cost_time,
                                              routes_after_removal_mod,routes_timeStamps_after_removal_mod,distanceMatrix,sigma,TW_violation,DC_violation,w_TW,w_DC,node_rev,sigmaS)
        
            
                
        cost_function_after_removal = J[0]
        current_unassigned_shipments = current_unassigned_shipments+output_removal[4]
        
        initial_routes = deepcopy(routes_after_removal_mod)
        strong_infeas_routes_before_insertion = []
        for i in range(0,int(len(initial_routes))):
            is_this_route_strongly_inf = alsn.single_route_strong_infeasibility(initial_routes[i],
                                distanceMatrix,timeMatrix,sigma,Nf,Ng,pickup_nodes,elBounds,
                                processing_time,maxRideTime,q_nodes,cap_trailer,
                                L_trailer,lat_occupancy_shipments,nDocks)
            strong_infeas_routes_before_insertion.append(is_this_route_strongly_inf)
        
        #print('Recap length lists after removal+intermediate step: start')
        #print(len(routes_after_removal_mod))
        #print(len(routes_timeStamps_after_removal_mod))
        #print(len(output_removal[2]))
        #print(len(output_removal[3]))
        #print('Recap length lists after removal+intermediate step: end')
        
        #print('current routes after remove before insert', routes_after_removal_mod)

        start_time = time.time()
        # If there are no routes, routes list is empty, we need to create a new route list.
        #So we choose insertion 'addition of route'.
        if len(routes_after_removal_mod) ==0:
            print('addition of route')
            output_insertion = alsn.create_new_route(routes_after_removal_mod,strong_infeas_routes_before_insertion,output_removal[2],output_removal[3],
                                         current_unassigned_shipments,sigma,routes_timeStamps_after_removal_mod,timeMatrix,elBounds,
                               processing_time,maxRideTime,distanceMatrix,Nf,Ng,pickup_nodes,q_nodes,cap_trailer,
                             L_trailer,lat_occupancy_shipments,nDocks,alpha,beta,gamma,multiplier,cost_distance,cost_time,w_TW,w_DC,node_rev,sigmaS)
        else:
            if idx_insertion_move == 0:
                print('greedy')
                output_insertion = alsn.greedy_insertion(routes_after_removal_mod,strong_infeas_routes_before_insertion,output_removal[2],output_removal[3],
                                              current_unassigned_shipments,sigma,routes_timeStamps_after_removal_mod,timeMatrix,elBounds,
                                    processing_time,maxRideTime,distanceMatrix,Nf,Ng,pickup_nodes,q_nodes,cap_trailer,
                                  L_trailer,lat_occupancy_shipments,nDocks,alpha,beta,gamma,multiplier,cost_distance,cost_time,w_TW,w_DC,node_rev,sigmaS)
            elif idx_insertion_move == 1:
                print('tabu greedy')
                output_insertion = alsn.tabu_greedy_insertion(routes_after_removal_mod,strong_infeas_routes_before_insertion,output_removal[2],output_removal[3],
                                              current_unassigned_shipments,output_removal[5],sigma,routes_timeStamps_after_removal_mod,timeMatrix,elBounds,
                                    processing_time,maxRideTime,distanceMatrix,Nf,Ng,pickup_nodes,q_nodes,cap_trailer,
                                  L_trailer,lat_occupancy_shipments,nDocks,alpha,beta,gamma,multiplier,cost_distance,cost_time,w_TW,w_DC,node_rev,sigmaS)
            elif idx_insertion_move == 2: # or idx_insertion_move == 3 or idx_insertion_move == 4:
                print('2-regret')
                output_insertion = alsn.two_regret_insertion(J[0],routes_after_removal_mod,strong_infeas_routes_before_insertion,output_removal[2],output_removal[3],
                                             current_unassigned_shipments,sigma,routes_timeStamps_after_removal_mod,timeMatrix,elBounds,
                                   processing_time,maxRideTime,distanceMatrix,Nf,Ng,pickup_nodes,q_nodes,cap_trailer,
                                 L_trailer,lat_occupancy_shipments,nDocks,alpha,beta,gamma,multiplier,cost_distance,cost_time,w_TW,w_DC,node_rev,sigmaS)
            else:
                print('addition of route')
                output_insertion = alsn.create_new_route(routes_after_removal_mod,strong_infeas_routes_before_insertion,output_removal[2],output_removal[3],
                                             current_unassigned_shipments,sigma,routes_timeStamps_after_removal_mod,timeMatrix,elBounds,
                                   processing_time,maxRideTime,distanceMatrix,Nf,Ng,pickup_nodes,q_nodes,cap_trailer,
                                 L_trailer,lat_occupancy_shipments,nDocks,alpha,beta,gamma,multiplier,cost_distance,cost_time,w_TW,w_DC,node_rev,sigmaS)
        
        end_time = time.time()
        #print('Elapsed time for insertion: %f seconds' %(end_time-start_time))
        
        ########################################################################
        ### Check that the sequence of pickup and delivery nodes follows the ###
        ### LIFO structure                                                   ###
        ########################################################################
        #print('Checking routes are assembled correctly: start')
        #print(output_insertion[0])
        #for i in range(0,int(len(output_insertion[0]))):
        #    n_shipments = int(len(output_insertion[0][i][1:int(len(output_insertion[0][i])/2)]))
        #    for j in range(0,n_shipments):
        #        this_diff = output_insertion[0][i][len(output_insertion[0][i])-2-j]-output_insertion[0][i][j+1]
        #        print(this_diff)
        #print('Checking routes are assembled correctly: end')
        
        unassigned_shipments_after_insertion = output_insertion[4]
        
        #print('End insertion phase')
        
        #print('Recap length lists after insertion: start')
        #print(len(output_insertion[0]))
        #print(len(output_insertion[1]))
        #print(len(output_insertion[2]))
        #print(len(output_insertion[3]))
        #loaded_shipment = 0
        #for i in range(0,int(len(output_insertion[0]))):
        #    loaded_shipment += int(len(output_insertion[0][i][1:int(len(output_insertion[0][i])/2)]))
        #print('Unloaded shipments: %i'%(sigma-loaded_shipment))
        #print('Unloaded shipments: %i'%(int(len(output_insertion[4]))))
        #print('Recap length lists after insertion: end')
        
        #####################################################
        ### Compute cost of solution after insertion move ###
        #####################################################
        
        strong_infeas_routes_after_insertion = []
        for i in range(0,int(len(output_insertion[0]))):
            is_this_route_strongly_inf = alsn.single_route_strong_infeasibility(output_insertion[0][i],
                                distanceMatrix,timeMatrix,sigma,Nf,Ng,pickup_nodes,elBounds,
                                processing_time,maxRideTime,q_nodes,cap_trailer,
                                L_trailer,lat_occupancy_shipments,nDocks)
            strong_infeas_routes_after_insertion.append(is_this_route_strongly_inf)
            
        is_current_solution_strongly_infeasible, FFSequence, GHSequence = alsn.strong_infeasibility(output_insertion[0],distanceMatrix,timeMatrix,
                                                                                                    output_insertion[1],sigma,Nf,Ng,pickup_nodes,elBounds,
                                processing_time,maxRideTime,q_nodes,cap_trailer,
                                L_trailer,lat_occupancy_shipments,nDocks)
        
        
        if is_current_solution_strongly_infeasible:
            # Current solution is strongly infeasible. The cost associated with such
            # solution is set to a high value
            J = alsn.cost_strongly_infeasible_solution(alpha,beta,gamma,multiplier,cost_distance,cost_time,
                                              output_insertion[0],output_insertion[1],distanceMatrix,sigma,node_rev,sigmaS)
            routes_after_insertion_mod            = deepcopy(output_insertion[0])
            routes_timeStamps_after_insertion_mod = deepcopy(output_insertion[1])  
        else:
            # Solution is not strongly infeasible. Dock capacity violations must be 
            # checked and resolved (if possible)
            dockCapacityViolation, arrDepGH, numberOfTrucksPerGH = alsn.dock_capacity_violation(output_insertion[0],output_insertion[1],
                                                                                                output_insertion[2],output_insertion[3],
                                                                                                Nf,Ng,nDocks)
                                                                                                
            
            # At least a dock violation occurs
            if len(dockCapacityViolation) != 0:
                routes_after_insertion_mod,routes_timeStamps_after_insertion_mod,dockCapacityViolation,arrDepGH,numberOfTrucksPerGH = alsn.dock_capacity_violation_resolver(output_insertion[0],output_insertion[1],
                                                                                                                                    timeMatrix,elBounds,processing_time,maxRideTime,
                                                                                                                                    dockCapacityViolation,arrDepGH,output_insertion[2],output_insertion[3],Nf,Ng,nDocks)
            else:
                routes_after_insertion_mod            = deepcopy(output_insertion[0])
                routes_timeStamps_after_insertion_mod = deepcopy(output_insertion[1])    
           
            # Determine time window violation (if any) and dock capacity 
            # violation (if any) and compute objective function
            TW_violation = alsn.time_violation_computation(routes_after_insertion_mod,routes_timeStamps_after_insertion_mod,elBounds)
            DC_violation = alsn.dock_violation_computation(dockCapacityViolation)
            
            J_after_insertion            = alsn.cost_weakly_infeasible_solution(alpha,beta,gamma,cost_distance,cost_time,
                                              routes_after_insertion_mod,routes_timeStamps_after_insertion_mod,distanceMatrix,sigma,TW_violation,DC_violation,w_TW,w_DC,node_rev,sigmaS)
            
        # If after the insertion there are still some unassigned shipments,
        # perform an improvement move to re-insert them
        if len(output_insertion[4]) != 0:    
        

            routes_FF_GH_ls,routes_timeStamps_FF_GH_ls,FF_sequence_FF_GH_ls,GH_sequence_FF_GH_ls,unassigned_shipments_FF_GH_ls = alsn.FF_GH_local_search_v2(routes_after_insertion_mod,output_insertion[2],output_insertion[3],
                                                                                                                                 unassigned_shipments_after_insertion,shipment_FF_GH,
                                                                                                                                 sigma,routes_timeStamps_after_insertion_mod,timeMatrix,elBounds,
                                                                                                                                 processing_time,maxRideTime,distanceMatrix,Nf,Ng,pickup_nodes,q_nodes,cap_trailer,
                                                                                                                                 L_trailer,lat_occupancy_shipments,nDocks,alpha,beta,gamma,multiplier,cost_distance,cost_time,w_TW,w_DC,node_rev,sigmaS)


        
            orig_routes     = deepcopy(routes_FF_GH_ls)
            orig_timeStamps = deepcopy(routes_timeStamps_FF_GH_ls)
            orig_FFSequence = deepcopy(FF_sequence_FF_GH_ls)
            orig_GHSequence = deepcopy(GH_sequence_FF_GH_ls)
            
        else:
            
            orig_routes     = deepcopy(routes_after_insertion_mod)
            orig_timeStamps = deepcopy(routes_timeStamps_after_insertion_mod)
            orig_FFSequence = deepcopy(output_insertion[2])
            orig_GHSequence = deepcopy(output_insertion[3])

           
        start_time = time.time()
        X = alsn.route_combination_v2(orig_routes,orig_timeStamps,orig_FFSequence,orig_GHSequence,distanceMatrix,timeMatrix,
                              sigma,Nf,Ng,pickup_nodes,elBounds,processing_time,maxRideTime,q_nodes, 
                              cap_trailer,L_trailer,lat_occupancy_shipments,nDocks)
        end_time = time.time()
        #print('Elapsed time for route merging: %f seconds' %(end_time-start_time))
        
        
        loaded_shipment = 0
        for i in range(0,int(len(X[0]))):
            loaded_shipment += int(len(X[0][i][1:int(len(X[0][i])/2)]))
        print('Unloaded shipments: %i'%(sigmaS-loaded_shipment))

        
        dockCapacityViolation, arrDepGH, numberOfTrucksPerGH = alsn.dock_capacity_violation(X[0],X[1],
                                                                X[2],X[3],
                                                                Nf,Ng,nDocks)

        #print('routes',X[0])
        #print('routes_timeStamps',X[1])
        #print('FFSequence',X[2])
        #print('GHSequence',X[3])
            
        # At least a dock violation occurs
        if len(dockCapacityViolation) != 0:
            final_routes,final_routes_timeStamps,dockCapacityViolation,arrDepGH,numberOfTrucksPerGH = alsn.dock_capacity_violation_resolver(X[0],X[1],timeMatrix,elBounds,processing_time,maxRideTime,
                                          dockCapacityViolation,arrDepGH,X[2],X[3],Nf,Ng,nDocks)
        else:
            final_routes            = deepcopy(X[0])
            final_routes_timeStamps = deepcopy(X[1]) 
            
        # Determine time window violation (if any) and dock capacity 
        # violation (if any) and compute objective function
        TW_violation = alsn.time_violation_computation(X[0],X[1],elBounds)
        DC_violation = alsn.dock_violation_computation(dockCapacityViolation)
        
        J_final            = alsn.cost_weakly_infeasible_solution(alpha,beta,gamma,cost_distance,cost_time,
                                          final_routes,final_routes_timeStamps,distanceMatrix,sigma,TW_violation,DC_violation,w_TW,w_DC,node_rev,sigmaS)
        
        print('Current solution is: %f'%(J_final[0]))
        print('Current routes :',final_routes)
        current_solution_evolution_J.append(J_final[0])
        
        # A new best solution was found
        if J_final[0] < best_J:
            best_J                       = deepcopy(J_final[0])
            best_routes                  = deepcopy(final_routes)
            best_routes_timeStamps       = deepcopy(final_routes_timeStamps)
            best_routes_FF               = deepcopy(orig_FFSequence)
            best_routes_GH               = deepcopy(orig_GHSequence)
            current_J                    = deepcopy(J_final[0])
            current_routes               = deepcopy(final_routes)
            current_routes_timeStamps    = deepcopy(final_routes_timeStamps)
            current_routes_FF            = deepcopy(orig_FFSequence)
            current_routes_GH            = deepcopy(orig_GHSequence)
        # A new best solution was not found
        else:
            # The new solution is better than the solution we started from
            if J_final[0] < current_J:
                current_J                    = deepcopy(J_final[0])
                current_routes               = deepcopy(final_routes)
                current_routes_timeStamps    = deepcopy(final_routes_timeStamps)
                current_routes_FF            = deepcopy(orig_FFSequence)
                current_routes_GH            = deepcopy(orig_GHSequence)
            # New solution is worse than where we started, we accept it or not
            # as the new current solution using the cooling scheduling
            # probability
            else:
                worse_sol_time = over_time + time.time() - begin_time
                selection_probability = np.exp((current_J-J_final[0])/(max((n_time-worse_sol_time),0.0001)))
                #selection_probability = 0
                print('current_J,J_final[0]',current_J,J_final[0])
                print('n_time,worse_sol_time',n_time,worse_sol_time)
                if random.random() < selection_probability:
                    print('selection_probability',selection_probability)
                    print('choose worse solution')
                    current_J                    = deepcopy(J_final[0])
                    current_routes               = deepcopy(final_routes)
                    current_routes_timeStamps    = deepcopy(final_routes_timeStamps)
                    current_routes_FF            = deepcopy(orig_FFSequence)
                    current_routes_GH            = deepcopy(orig_GHSequence)
                else:
                    pass
                
        best_solution_evolution_J.append(best_J)        
        # Update list of unassigned shipments
        current_assigned_shipments = []
        for i in range(0,len(current_routes)):
            for j in range(1,int(len(current_routes[i])/2)):
                current_assigned_shipments.append(current_routes[i][j])
        s = set(current_assigned_shipments)
        current_unassigned_shipments = [x for x in all_shipments if x not in s]
        print('Initial solution is: %f'%(J_initial[0]))
        print('Best solution is: %f'%(best_J))
        print('best routes:', best_routes)
        print('')
        
        cont += 1
        T = cooling_coeff*T
        over_time += time.time() - begin_time
    #fig, ax = plt.subplots()
    #ax.plot(np.arange(0,len(best_solution_evolution_J)),best_solution_evolution_J,color='r',linewidth=2)
    #ax.plot(np.arange(0,len(best_solution_evolution_J)),current_solution_evolution_J,color='b',linewidth=2)
    #plt.xlabel('Iterations', fontsize=16)
    #plt.ylabel('Objective function', fontsize=16)
        
    #ax.grid(True)
    #plt.show()
    #print('best_routes_timeStamps',best_routes_timeStamps)
    return best_routes, best_J , best_routes_timeStamps, best_routes_FF, best_routes_GH
