%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% Author:   Jelle Snieder
% Date:     30-4-2024
% 
% Script to import and plot LED spectrum
% 
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

clearvars
close all
clc

% parameters
wavelengths = 400:1:700; % [nm] desired wavelength range for mapping and interpolation
gaussian    = 5;         % [-] smoothing parameter

% load data LED spectrum
filename_LED    = '20240425_led_spectrum_v1.xlsx';
dataRaw         = readmatrix(filename_LED);
dataRaw         = rmmissing(dataRaw);
wavelengths_LED = dataRaw(:,1);
spectrum_LED    = dataRaw(:,2);
spectrum_LED  = normalize(spectrum_LED,'range');

figure(1)
hold on
plot(wavelengths_LED,spectrum_LED)

% map on desired wavelength range, smooth and normalize
spectrum_LED  = interpolate(wavelengths_LED, spectrum_LED, wavelengths);
spectrum_LED  = smoothdata(spectrum_LED, 'gaussian',gaussian);
spectrum_LED  = normalize(spectrum_LED,'range');

figure(1)
hold on
plot(wavelengths,spectrum_LED)
grid on
xlabel('Wavelength (nm)')
ylabel('Normalized intensity (-)')

save('dataset_LED_spectrum','spectrum_LED')



%% functions
function [signalNew] = interpolate(wavelengthsOld, signalOld, wavelengths)
    
    % add zeros in front, if neccessary.
    n1 = round(min(wavelengthsOld))-min(wavelengths); % number of wavelengths to be added in front
    wavelengthsFront = min(wavelengths):1:(min(wavelengths)+n1-1);
    wavelengthsNew = [wavelengthsFront'; wavelengthsOld];
    vectorZeros = zeros(n1,1);
    signalNew = [vectorZeros; signalOld];

    % add zeros in the end, if necessary.
    n2 = max(wavelengths)-round(max(wavelengthsNew)); % number of wavelengths to be added in the end
    wavelengthsEnd = (max(wavelengths)-n2+1):1:(max(wavelengths));
    wavelengthsNew = [wavelengthsNew; wavelengthsEnd'];
    vectorZeros = zeros(n2,1); 
    signalNew = [signalNew; vectorZeros];

    % interpolate at desrired wavelength range
    signalNew = interp1(wavelengthsNew, signalNew, wavelengths)'; 

end



