# GreenspacePerception

These notebooks allow to collect spatial data, specifically NDVI (#1), OpenStreetMap (#2) and Google Street View metadata (#3); to sample a subset of places (#4) and conduct the quantitative analysis to research how well NDVI and OpenStreetMap data capture what people visually perceive as being urban greenspaces (#5-7). These notebooks were used in complementation by data collection through a crowdsourcing questionnaire to collect people's perceptions of places presented in Google Street View imagery. The quantitative analysis was followed up by a qualitative analysis, of which the codebook is added to this repository as well as an .xlsx file. 

This code was developed for three cities in Europe: Barcelona, Rotterdam, and Gothenburg, but can be adapted to fit other geographical contexts. 

<p align="center">
    <img src="https://github.com/rflteeuwen/GreenspacePerception/blob/main/figures/discussion.png" width="50%">
</p>

## Using GreenspacePerception?

If you use GreenspacePerception in your work, please cite the journal paper.

**Citation info:** Roos Teeuwen, Vasileios Milias, Alessandro Bozzon, and Achilleas Psyllidis. How well do NDVI and OpenStreetMap data capture people’s visual perceptions of urban greenspace? Landscape and Urban Planning (in press). 2024. https://doi.org/10.1016/j.landurbplan.2024.105009

Shield: [![CC BY 4.0][cc-by-shield]][cc-by]

This work is licensed under a
[Creative Commons Attribution 4.0 International License][cc-by].

[![CC BY 4.0][cc-by-image]][cc-by]

[cc-by]: http://creativecommons.org/licenses/by/4.0/
[cc-by-image]: https://i.creativecommons.org/l/by/4.0/88x31.png
[cc-by-shield]: https://img.shields.io/badge/License-CC%20BY%204.0-lightgrey.svg

**Abstract:** The study of urban greenspaces typically relies on three types of data: people’s subjective perceptions collected via questionnaires, vegetation indices derived from satellite imagery, such as the Normalized Difference Vegetation Index (NDVI), and Land Use or Land Cover maps, such as OpenStreetMap (OSM). Data on people’s perceptions are essential when researching human activities, yet they scale poorly. NDVI and OSM data, on the other hand, are freely available worldwide, thus valuable for assessing cities at scale or prioritizing locations for interventions. However, it is unclear how effectively NDVI and OSM data capture people’s visual perceptions of urban greenspaces. In this work, we collect people’s visual perceptions of public spaces in three major European cities through crowdsourcing, quantitatively compare them to NDVI and OSM data, and qualitatively investigate disparities. We found that NDVI moderately correlates with perceived greenness and that not only OSM greenspaces but also pocket parks and play spaces are often considered green. Furthermore, we found that people’s perceptions correspond best to OSM data in small radius distances and NDVI data in larger radius distances and that combining NDVI and OSM data can improve identification of places in OSM that are commonly considered green. Our qualitative analysis revealed that configuration and variety of vegetation, and presence of other natural or built-up features, influence people’s perceptions of greenspace. With our findings we aim to help researchers and practitioners make more informed decisions when collecting greenspace data for their specific context, ultimately contributing to green urban environments that reflect people’s perspectives.

**Keywords:** Urban greenspace; Visual perception; OpenStreetMap; NDVI; Crowdsourcing
