# Greencode Project Dataset

This dataset contains results of the numerical analysis of the combustion of lean methane-air with flue gas recirculation (FGR) intended for ultra low NOx applications, Hydrogen rich simulations and MILD conditions using a CSP-based reduced mechanism. The included files are outlined below:

## Data Files

### `CSP_reduced_mech.dat`

The resulting reduced mechanism details for methane-air combustion for the implemented CSP algorithm

### `ANSYS_FLUENT.h5`

2D axisymmetric simulation results from Ansys Fluent containing pressure, density, temperature and mass fractions data for three separate combustion modeling approaches:

- **EDC (Eddy Dissipation Concept)** - Using detailed chemistry
- **FGM (Flamelet Generated Manifolds)** - Using simplified chemistry
- **CSP Greencode Proposal** - Using reduced chemistry

### `CANTERA_OUTPUT.dat`

Output from a one-dimensional flame propagation simulation using Cantera chemical kinetics software.

### `CSP_PREMIX_OUTPUT.dat`

Results from a modified premix simulation that incorporates the CSP Greencode logic for flame propagation analysis.

### `DNN_source_terms.keras`

Saved Keras model containing the architecture and trained weights for a multi-layer perceptron (MLP) neural network. This model predicts chemical source terms based on:

- **Input**: Species mass concentrations and temperature (54,)
- **Output**: Chemical source terms for combustion reactions (53,)

## Usage

This dataset is intended for:

- Comparative analysis of different combustion modeling approaches
- Validation of proposed machine learning model for combustion chemistry
- Research in computational combustion and chemical kinetics

## Acknowledgements

Provided by University of Twente and Mateq Process B.V.
PhD. A. Ghasemi
Dr. Ir. M.A.F. Derksen
Dr. Ir. J.B.W. Kok

The authors would like to acknowledge the funding of this research by Top Sector Energy, TKI Nieuw Gas under the Greencode project number TKITOETKI 2021-H2-09.
