%{
Created in 2022
@author: Konstantina Kolovou Kouri
%}

close all
clc

% defining the time array
sample_t = 1/100000000;
sample_t_interval = 1/10000; % interval = 1 pwm pulse
t = (0:sample_t:100e-6);
interval_duration = 0:sample_t_interval:100e-6; %used for the PWM pulses

% defining the v_max levels (for 4bit resolution -> 16 evenly distributed v_max)
% v_max = [0.5625 1.125 1.6875 2.25 2.8125 3.375 3.9375 4.5 5.0625 5.625 6.1875 6.75 7.3125 7.875 8.4375 9];

% defining the different i_max amplitudes, e.g. 100e-6
i_max = [250e-6 500e-6 750e-6 1e-3 1.25e-3 1.5e-3 1.75e-3 2e-3 2.25e-3 2.5e-3 2.75e-3 3e-3 3.25e-3 3.5e-3 3.75e-3 4e-3];
% i_max = [250e-6 4e-3];

% interchange between multiple levels for fig 1&2, and one level for fig 3
max_v_levels = [3 4 5 6 7];
% max_v_levels = [7];


% defining a wave of interest
%%% half-sine
    f = 5e3;
    % wave = i_max*sin(2*pi*f*t);
%%% triangular
    % wave = triangularPulse(t(1,1),t(1,end),t)*i_max;
%%% gaussian
    gaus = @(x,mu,sig,amp,vo)amp*exp(-(((x-mu).^2)/(2*sig.^2)))+vo;
    mu = t(1,((length(t)-1)/2));
    sig = 0.000015;
    vo = 0;
    % wave = gaus(t,sig,i_max);
%%% rectangular
    pulse = zeros(1, length(t));
    pulse_max = zeros(1, length(t));
    % pulse(1,:) = i_max;
    % pulse(1,1) = 0;
    % pulse(1, length(pulse)) = 0;
    % wave = pulse;   
    

% initiating arrays
charge = zeros(1, length(t));
voltage = zeros(1, length(t));
voltage_global = zeros(1, length(t));
powerWithout = zeros(1, length(t));
powerWith = zeros(1, length(t));
powerWithConst = zeros(1, length(t));
powerWithAdapt = zeros(1, length(t));
energyWithout = zeros(1, length(t));
energyWith = zeros(1, length(t));
energyWithConst = zeros(1, length(t));
energyWithAdapt = zeros(1, length(t));
energy_saving_adapt_to_const = zeros(length(max_v_levels), length(i_max));


% value for R_s and C_dl, e.g. 150e3 & 20e-6
R = 1e3;
C = 10e-6;
ratio_RC = R*C;


% iterate over different max_v_levels
for m = 1:length(max_v_levels)
    
    % iterate over different i_max
    for k = 1:length(i_max)

        % for a rectangular pulse
%         pulse(1,:) = i_max(k);
%         pulse(1,1) = 0;
%         pulse(1, length(pulse)) = 0;
%         wave = pulse;
%         pulse_max(1,:) = i_max(end);
%         pulse_max(1,1) = 0;
%         pulse_max(1, length(pulse_max)) = 0;
%         wave_max = pulse_max;
        
        % for a half-sine wave
         wave = i_max(k)*sin(2*pi*f*t);
         wave_max = i_max(end)*sin(2*pi*f*t);
        
        % for a triangular wave
%        wave = triangularPulse(t(1,1),t(1,end),t)*i_max(k);
%        wave_max = triangularPulse(t(1,1),t(1,end),t)*i_max(end);
        
        % for a gaussian wave
%         wave = gaus(t,mu,sig,i_max(k),vo);
%         wave_max = gaus(t,mu,sig,i_max(end),vo);    
        

        for i = 2:length(t)
            charge(m,i) = trapz(t(1:i),wave(1:i));   % Charge: integral of I over t
            voltage(m,i) = wave(1,i)*R + charge(m,i)/C;   % V over the ETI: V over the R-component (R*instant current) + V that builds up over Cdl
    %         voltage(m,i) = (wave(1,i) + charge(m,i)/ratio_RC);   % R ignored
            voltage_global(m,i) = wave_max(1,i)*R + charge(m,i)/C;

            powerWithout(m,i) = wave(1,i) * wave(1,i) *R;   % P delivered to the load with a resistive load aka "without" the capcitive component of the ETI
            powerWith(m,i) = wave(1,i)*voltage(m,i);   % P delivered to the load with a resistive-capacitive load aka "with" the capcitive component of the ETI
        end

        % introduced a global maxV, so that the steps in the supply rails are calculated based on the max amplitude and divided accordingly
        max_voltage_global = max(voltage_global(m,:));   % max voltage over the ETI for the maximum current (with resitive-capacitive load)
        max_voltage = max(voltage(m,:));   % max voltage over the ETI for the current of the iteration (with resitive-capacitive load)

        % defining stairs with RC-load
        v_levels = linspace(0, max_voltage_global, max_v_levels(1,m));   % defining the voltage levels of the adaptive supply
        stairs = interp1(v_levels,v_levels,voltage(m,:),'next','extrap');
        
        % defining stairs with simple R-load
        v_levels_without = linspace(0, max(wave(1,:)*R), max_v_levels(1,m));
        stairs_without = interp1(v_levels_without,v_levels_without,wave(1,:)*R,'next','extrap');


        % P from the supply
        for i = 1:length(t)
            powerWithConst(m,i) = wave(1,i)*max_voltage_global;   
            powerWithAdapt(m,i) = wave(1,i)*stairs(1,i);   
        end

        for i = 2:length(t)
            energyWithout(m,i) = trapz(t(1:i),powerWithout(m,1:i));
            energyWith(m,i) = trapz(t(1:i),powerWith(m,1:i));
            energyWithConst(m,i) = trapz(t(1:i),powerWithConst(m,1:i));
            energyWithAdapt(m,i) = trapz(t(1:i),powerWithAdapt(m,1:i));
        end

        
        energy_saving_adapt_to_const(m,k) = (1-(energyWithAdapt(m,end)/energyWithConst(m,end)))*100;
        
    end
end

%to quantify energy savings
powerWithConst_value = trapz(t(1:end),powerWithConst(1,1:end));
powerWithAdapt_value = trapz(t(1:end),powerWithAdapt(1,1:end));
power_saved_value = powerWithConst_value - powerWithAdapt_value;

figure(1);
hold on
grid on
t = t*1e6;
t2 = [t, fliplr(t)];
inBetween_losses = [powerWith*1e3, fliplr(powerWithAdapt*1e3)];
plot4 = fill(t2, inBetween_losses, [0.85 0.85 0.85], 'LineStyle','none');
inBetween_savings = [powerWithConst*1e3, fliplr(powerWithAdapt*1e3)];
plot5 = fill(t2, inBetween_savings, [0.2824 0.8784 0.1333], 'LineStyle','none'); %0.4667 0.6745 0.1882
% plot(t,powerWithout,'LineWidth',6.0)
plot1 = plot(t,powerWith*1e3,'color',[0.0588 1 1],'LineWidth',7.0);
plot2 = plot(t,powerWithConst*1e3,':','color',[1.0000 0.0745 0.6510],'LineWidth',7.0);
plot3 = plot(t,powerWithAdapt*1e3,'-.','color',[0.6350, 0.0780, 0.1840],'LineWidth',7.0);
xlabel('time (\mus)')
ylabel('power (mW)')
leg = legend([plot1 plot2 plot3 plot4 plot5],{'P ideal supply','P constant supply','P adaptive supply','P loss','P savings'},'Location','northeast');
set(gca,'FontSize',40)

% add last values to voltage and stairs array 
voltage_rest = zeros(1,301);
voltage_rest(1,:) = voltage(1,end);
voltage = [voltage voltage_rest];
stairs_rest = zeros(1,301);
stairs_rest(1,:) = stairs(1,end);
stairs = [stairs stairs_rest];
t_rest = (100:t(1,2)-t(1,1):103);
t = [t t_rest];
conv_supply = zeros(1, length(t));
conv_supply(1,:) = max(voltage);
conv_supply(1,1) = 0;
conv_supply(1, length(t)) = 0;

figure(2);
hold on
grid on
t3 = [t, fliplr(t)];
inBetween_losses = [voltage, fliplr(stairs)];
plot9 = fill(t3, inBetween_losses, [0.85 0.85 0.85], 'LineStyle','none');
inBetween_savings = [conv_supply, fliplr(stairs)];
plot10 = fill(t3, inBetween_savings, [0.2824 0.8784 0.1333], 'LineStyle','none'); %0.4667 0.6745 0.1882
plot6 = plot(t,voltage,'color',[0.0588 1 1],'LineWidth',7.0);
plot7 = plot(t,conv_supply,':','color',[1.0000 0.0745 0.6510],'LineWidth',7.0);
plot8 = plot(t,stairs,'-.','color',[0.6350, 0.0780, 0.1840],'LineWidth',7.0);
xlabel('time (\mus)')
ylabel('magnitude (V)')
xlim([0 103])
leg = legend([plot6 plot7 plot8 plot9 plot10],{'V over ETI','V constant supply','V adaptive supply','loss','savings'},'Location','northeast');
leg.ItemTokenSize = [40,28];
set(gca,'FontSize',40)

figure(3);
hold on
grid on
plot(i_max*1e3,energy_saving_adapt_to_const(1,:),'-o','LineWidth',7.0)
plot(i_max*1e3,energy_saving_adapt_to_const(2,:),'-h','LineWidth',7.0)
plot(i_max*1e3,energy_saving_adapt_to_const(3,:),'-d','LineWidth',7.0)
plot(i_max*1e3,energy_saving_adapt_to_const(4,:),'-^','LineWidth',7.0)
plot(i_max*1e3,energy_saving_adapt_to_const(5,:),'-s','LineWidth',7.0)
xlabel('amplitude (mA)')
ylabel('energy savings (in %)')
set(gca,'FontSize',40)
leg = legend({'2 DDC outputs','3 DDC outputs','4 DDC outputs','5 DDC outputs','6 DDC outputs'},'Location','northeast');
leg.ItemTokenSize = [40,28];

