import pandas as pd
import matplotlib.pyplot as plt
import gower
from scipy.cluster.hierarchy import dendrogram, linkage
from scipy.spatial.distance import squareform

# [to do ]Data inladen
bestandspad = r'C:\Users\Data_Governance.xlsx'

data=pd.read_excel(bestandspad)
print(data.columns.tolist())

# [to do] Variabelen inladen
data_clustering = data[['Var 1', 'Var 2', 'Var 3', 'Var 4', 'Var 5', 'Var 6', 'Var 7', 'Var 8', 'Var 9', 'Var 10']]

#Labels
labels = data['naam'].values

# Afstandsmatrix
data_clustering = data_clustering.astype(float)

dist_matrix = gower.gower_matrix(data_clustering)

dist_matrix_df = pd.DataFrame(dist_matrix, columns=data_clustering.index, index=data_clustering.index)

print(dist_matrix_df)
condensed_dist_matrix = squareform(dist_matrix, checks=False)

# Hiërarchisch clusteren
Z = linkage(condensed_dist_matrix, method='complete')

#dendogram
plt.figure(figsize=(10, 7))
dendrogram(Z, labels=labels)
plt.xticks(rotation=45, ha="right") # Schuine labels (45 graden)
plt.title('Hiërarchisch Clusteren (Met Headers)')
plt.xlabel('Index')
plt.ylabel('Distance')
plt.show()
