__includes
[;variable names
 "globals.nls"
 "chargepoints-own.nls"
 "admins-own.nls"
 "transformators-own.nls"

 ;parameters
 "identify-neighbourhood.nls" ;CBS en CHIEF
 "set-parameters-grid.nls" ;nu met FlexRapport maar correctie mark moet nog
 "determine-peak.nls" ;nu op 1-uur fijnmazigheid EPEX gemiddelde
 "grow-demand.nls"

;reporters
 "set-values-for-bs.nls"
]

extensions
[ time
  csv
  csv profiler
  table]

breed [transformators transformator]
breed [chargepoints chargepoint]
breed [admins admin]
breed [batteries battery]

to setup
clear-all
  reset-ticks

  resize-world 0 8 0 8 ; dit stukje code heb ik even van online gejat om 9 wijken te maken in patch vorm
  let x 3
  let y 3
  let col 5
  while [y <= 9][
    while [x <= 9][
      create-admins 1 [set color col]
        create-transformators 1[
  set grid_capacity_simple 300
  set shape "house"
  set size 0.5
  set color col
        set battery_enabled false
  ]
      ask patches with [pxcor < x and pxcor >= x - 3 and pycor < y and pycor >= y - 3][
        set pcolor col
      ]
      set x x + 3
      set col col + 10
    ]
    set x 3
    set y y + 3
  ]

    ask transformators [ ; nu alleen nog onzichtbaar als admin bovenop transformator komt; maar heeft geen consequenties voor code
    let _mycolor color
    move-to one-of patches with [pcolor = _mycolor]
    set color blue
  ]
set kk-cp 0
set kk-batt 0
set er-cp 0
set er-batt 0

;Buurt identificeren
identify-neighbourhood

;Maak laadpunten aan obv de info
ask transformators [
    hatch-chargepoints start-value-cp [
     set smart_pos false
     set fast_pos false
     set occupied? false
     set occupancy_len 0 ; komt elke tick 1 bij als hij nog bezet is
     ifelse occupied? = true
      [set soc_veh random-float 85]
      [set soc_veh 0]
     ifelse random-float 100 < 40
      [set v2g_pos true]
      [set v2g_pos false]
      create-link-with myself]
   set number_of_chargepoints count my-links ; telt aantal laadpalen (binnen transformator cluster)
   set available_chargepoints count link-neighbors with [occupied? = false]] ;telt op hoeveel er beschikbaar zijn (binnen transformator cluster)

ask transformators [ ;leest vanuit identify-neighbourhoods in wat de startwaarden zijn.
    ask n-of start-value-flex chargepoints [set smart_pos true]
    ask n-of start-value-fast chargepoints [set fast_pos true]]

  place-admins-with-wijk
end

to decouple-all
   ask chargepoints [
      if occupied? = true
      [set occupied? false]
  ]
end

to place-admins-with-wijk
  ask admins [
    let _mycolor color
    move-to one-of patches with [pcolor = _mycolor]
    identify-neighbourhood
  ]
end

to calculate-per-wijk
   set failed_counter_thisround 0 ;let op nu even hier vanwege de volgorde bij go
  ask transformators [set avg_rfid_dayT (business0to7 + business8 + business9 + business10 + business11 + business12 + business13
    + business14 + business15 + business16 + business17 + business18 + business19 + business20 + business21 + business22)]

   ask admins [
    let _mycolor color
    set number_of_tf count transformators with [pcolor = _mycolor]
    set grid_info (mean[grid_capacity_simple] of transformators with [pcolor = _mycolor])
    set kwh_load2 (sum[kwh_load] of chargepoints with [pcolor = _mycolor])
    set kwh_score (sum[kwh_load] of chargepoints with [pcolor = _mycolor])
    set number_of_cp count chargepoints with [pcolor = _mycolor]
    set resourcesperhousehold (number_of_cp / total_hh)
    ;print "resources per household" print resourcesperhousehold ;nu geen rekening met 2 sockets
    set number_of_batteries count transformators with [pcolor = _mycolor and battery_enabled = true]

    set percentage_nf (not_fuel_cars / total_cars)

    set cp_with_smart count chargepoints with [pcolor = _mycolor and smart_pos = true]
    set cp_with_v2g count chargepoints with [pcolor = _mycolor and v2g_pos = true]
    set cp_with_fast count chargepoints with [pcolor = _mycolor and fast_pos = true]
    set occupied_cp count chargepoints with [pcolor = _mycolor and occupied? = true]
    set occupied_perc (occupied_cp / number_of_cp)
    if occupied_perc = 1 [
      set max_occupied max_occupied + 1 ]
    ; average grid erbij
    ; failed sessions erbij
  ]
end

to update-battery-per-tick
  ask transformators with [battery_enabled = true] [
    if battery_capacity < 100 and peakhour = 0 [
      set battery_capacity battery_capacity + 10]
  ]
end

to decouple-per-tick ; ontkoppelen op basis van state-of-charge en diceroll
   ask chargepoints [
    ;set diceroll random-float
    ifelse (occupied? = true and soc_veh > 80 or occupancy_len > 24)  ;and diceroll < 0)
      [set occupied? false ;ontkoppelen
      set fast_ena? false ;protocollen deactiveren bij ontkoppelen
      set v2g_ena? false
      set smart_ena? false
      set normal_ena? false
      set occupancy_len 0
      set decoupled_this_round decoupled_this_round + 1
      set charged_since_start charged_since_start + 1]
    [set occupancy_len occupancy_len + 1 ; is nu langer dan verwacht met de oplaad parameters. of de monitor klopt niet..
      v2g-question]

   if (v2g_ena? = true and occupancy_len > 10) ;ontkoppelen van v2g sessies obv tijdsboundary
    [set v2g_ena? false ;hier ook bijhouden wie al geweest is -> loop v2g/normaal laden voorkomen.
     set v2g_blacklist? true
     set blacklist_counter 10
    select-protocol]

    if overload_cp = true [
      set overload_cp false
      select-protocol]
  ]
end

to v2g-question ;wordt pas vanaf 2e uur getriggerd -> parameter krijgt die bijhoudt hoeveel er ontladen? -> batterij eruit.
  let _mycolor color
  if (soc_veh > 40 and occupancy_len < 10 and v2g_pos = True and cartype_v2g? = True and blacklist_counter < 1) ;cartype ff er uit
     [  ask link-neighbors [
          if flex_total < 50 [
          let _mycol2 pcolor
          set grid_capacity_simple grid_capacity_simple + CspeedV2G
          ask admins with [pcolor = _mycol2] [set bidir_charged bidir_charged + CspeedV2G set b_charged b_charged + 1]  ;print bidir_charged
                ask myself [
                     set to_be_charged to_be_charged + CspeedV2G
                     set v2g_ena? true
                     set normal_ena? false
                     set fast_ena? false
                     set smart_ena? false ]]]] ;print "v2g"
end

to simple-sessions-per-tick ;nu elke tick een sessie per transformator?
    ask transformators [
    let mycol pcolor
      determine-peak
      repeat business [
      set flex_total grid_capacity_simple + battery_capacity
      ;print self print grid_capacity_simple print battery_capacity print flex_total
      ifelse any? link-neighbors with [occupied? = false]
         [ask one-of link-neighbors with [occupied? = false] [
            set occupied? true
            set batt_veh one-of [15 65 80 100]  ;print batt_veh daadwerkelijke kwh batterij groottes
            set soc_veh one-of  [10 15 20 25 30 35 40 45 50 60 65 70] ;veilige marge 15-20%
            set to_be_charged ((100 - soc_veh) / 100) * batt_veh ;daadwerkelijke kwh die geladen moet worden
            set to_be_charged_perc (to_be_charged / batt_veh)
            set cartype_v2g? one-of [true false]
             select-protocol]] ;bepaalt laadprotocol of grid overload
         ;[print "all chargepoints of" print self print "occupied"
          [ask admins with [pcolor =  mycol] [set spillover_counter spillover_counter + 1 set spillover_total spillover_total + 1]
          ask min-one-of other transformators [ distance myself ]  [
                  ;print self print "is my neighbor"
                  select-alternative-point] ;updaten met vraag dichtstbijzijnde transformator met kortste patch afstand.
  ]]]
end

;self + myself zoeken

to select-protocol
  let laadpaalhier self
  let bezetting count chargepoints with [pcolor = [pcolor] of laadpaalhier and occupied? = true] ;print laadpaalhier print bezetting
  let laadpalen count chargepoints with [pcolor = [pcolor] of laadpaalhier]
  ifelse bezetting < (0.5 * laadpalen) [set CspeedNorm 8.6] [set Cspeednorm 11] ;in ieder geval alle nieuwe connecties bij hoge bezetting 8.6 kW.

  set-parameters-grid
  ask transformators with [pcolor = [pcolor] of laadpaalhier] [
  ifelse (grid_capacity_simple > 100 and [fast_pos] of myself = True and peakhour = 0)
            [set grid_capacity_simple grid_capacity_simple - CspeedFast ask myself [set fast_ena? true set kwh_load kwh_load + CspeedFast] ask admins with [pcolor = [pcolor] of laadpaalhier] [set f_charged f_charged + 1]] ;fast charging
         [ifelse grid_capacity_simple > 24
            [set grid_capacity_simple grid_capacity_simple - CspeedNorm ask myself [set normal_ena? true set kwh_load kwh_load + CspeedNorm] ask admins with [pcolor = [pcolor] of laadpaalhier] [set n_charged n_charged + 1]] ;normal charging
            [ifelse grid_capacity_simple > 11 ;heb je genoeg?
                    [ifelse [smart_pos] of myself = True ; kun je slim laden?
                              [set grid_capacity_simple grid_capacity_simple - CspeedSmart ask myself [set smart_ena? true set kwh_load kwh_load + CspeedSmart] ask admins with [pcolor = [pcolor] of laadpaalhier] [set s_charged s_charged + 1]] ;zo ja, doe het
          [set grid_capacity_simple grid_capacity_simple - CspeedNorm ask myself [set normal_ena? true set kwh_load kwh_load + CspeedNorm] ask admins with [pcolor = [pcolor] of laadpaalhier] [set n_charged n_charged + 1]]] ;zo niet, normaal
                     [ifelse battery_capacity > 11 ;heb je nog batterij buffer?
            [set battery_capacity battery_capacity - CspeedNorm ask myself [set normal_ena? true set kwh_load kwh_load + CspeedNorm] ask admins with [pcolor = [pcolor] of laadpaalhier] [set batt_charged batt_charged + 1]] ;zo ja, normaal (later kijken smart?)
          [ask laadpaalhier [;print laadpaalhier print "grid overload"
            let mycol pcolor
            set grid_overload grid_overload + 1 set overload_cp true ask admins with [pcolor = mycol] [set grid_overload_nb grid_overload_nb + 1 ] ]]] ;zo niet, grid overload er wordt deze tick 0 bijgeladen
  ]]  ]
end



to select-alternative-point
    ifelse any? link-neighbors with [occupied? = false]
         [ask one-of link-neighbors with [occupied? = false] [
             let _mycolor pcolor
             set occupied? true
             set occupancy_len occupancy_len + 1
             set soc_veh random-float 80
             select-protocol
             ;print "alternative chargepoint is" print self
             ask admins with [pcolor = _mycolor] [set spillover_to spillover_to + 1] ]]
         [;print "neighbor occupied too"
             set failed_counter_full failed_counter_full + 1
             set failed_counter_thisround failed_counter_thisround + 1];weer nearest neighbor en dan loop weer beginnen -> dan blijft hij tussen 2 dichtstbijzijnde pingen, dus er moet een history gemaakt worden
end

to calculate-per-round
  ask admins [
    if ticks > 0 [set gridcap_previous (gridcap + gridcap_previous) set gridcap_mean (gridcap_previous / ticks)]
    set gridcap 0
    let _mycolor color
    set occupied_cp count-my-occupied-cps _mycolor
    set total_cp count chargepoints with [pcolor = _mycolor]
    set gridcap mean([grid_capacity_simple]) of transformators with [pcolor = _mycolor]]
end

to update-soc-per-tick ;dit moet met to-be-charged gebeuren
  ask chargepoints with [fast_ena? = true] [set to_be_charged to_be_charged - CspeedFast]
  ask chargepoints with [smart_ena? = true] [set to_be_charged to_be_charged  - CspeedSmart]
  ask chargepoints with [normal_ena? = true] [set to_be_charged to_be_charged - CspeedNorm ] ;print self print soc_veh
  ask chargepoints with [v2g_ena? = true] [set to_be_charged to_be_charged + CspeedV2G]
  update-soc
end

to update-soc
  ask chargepoints with [occupied? = true and batt_veh > 0] [
  ifelse to_be_charged < 1 [set occupied? false]
    [set to_be_charged_perc (to_be_charged / batt_veh)
      set soc_veh 100 * (1 - to_be_charged_perc)]] ;print self print soc_veh waarom soms 15 erbij en soms 11?
end

to go
  calculate-per-wijk ;willen we dit per keer bijhouden want resources veranderen niet, bezetting/gedrag wel. wellicht opsplitsen
  set-parameters-grid
  ask transformators [set grid_capacity_simple (MSRspace * msr-multiplier) ]
  decouple-per-tick  ;kijken of je sessies kunt ontkoppelen op basis van bezetting/SOC
  simple-sessions-per-tick ; nieuwe sessies
  calculate-per-round
  update-battery-per-tick
  update-soc-per-tick
  set average-occu mean [occupancy_len] of chargepoints with [occupancy_len > 0]
  set-values-for-bs
  set failed_counter_thisround 0
  ;print "decoupled" print decoupled_this_round
  set decoupled_this_round 0
  set tick_counter tick_counter + 1
  ask chargepoints [if blacklist_counter > 0 [set blacklist_counter blacklist_counter - 1]] ;print blacklist_counter]
  tick
    if ticks mod 4300 = 0 [ ;elk halfjaar groeien nu 10%
    grow-demand
  ]
  if ticks mod 4300 = 0 [ ;elk halfjaar bijplaatsen ;4300
    ask admins [print self print "bidir" print b_charged print "normal" print n_charged print "smart" print s_charged print "fast" print f_charged print "battery" print batt_charged]
   set resource_cp_counter 5 ;5 wijken kunnen uitgebreid worden -> willen we dit wijder maken over tijd? of alleen resources per wijk of niks?
    if Prioriteitenstrategie = 1 [
    admins-get-chargepoints-demand]
    if Prioriteitenstrategie = 2 [
    admins-get-chargepoints-antici]
    if Prioriteitenstrategie = 3 [
    admins-get-chargepoints-equity]
   admins-get-battery-random
   admins-update-protocol-random
   admins-reset
   set resource_cp_counter 0
  ]
end

to-report count-occupied-cps
  report count chargepoints with [occupied? = true]
end

to-report count-my-occupied-cps [ the-color ]
  report count chargepoints with [pcolor = the-color and occupied? = true]
end

to-report count-my-batteries
  report count batteries
end

;deze kun je aanroepen door profile in de commandline te typen
to profile
  setup                  ;; set up the model
  profiler:start         ;; start profiling
  repeat 20 [ go ]       ;; run something you want to measure
  profiler:stop          ;; stop profiling
  print profiler:report  ;; view the results
  profiler:reset         ;; clear the data
end

;normaliseren van parameters in strategie
to admins-normalize
let _mycolor color
let min-value1 min [max_occupied] of admins
let max-value1 max [max_occupied] of admins
if (min-value1 = max-value1) = true [ask admins [set max_occupied_n 0.5]]
if (min-value1 = max-value1) = false [ask admins [set max_occupied_n ((max_occupied - min-value1) / (max-value1 - min-value1))]
]

  let min-value2 min [kwh_score] of admins
  let max-value2 max [kwh_score] of admins
  ask admins   [
    set kwh_n ((kwh_score - min-value2) / (max-value2 - min-value2))
]
  let min-value3 min [avg_ink] of admins
  let max-value3 max [avg_ink] of admins
  ask admins   [
    set avg_ink_n ((avg_ink - min-value3) / (max-value3 - min-value3))
]
  let min-value4 min [nal_2025] of admins
  let max-value4 max [nal_2025] of admins
  ask admins   [
    set nal_2025_n ((nal_2025 - min-value4) / (max-value4 - min-value4))
  ]
  set investment (number_of_cp / total_hh)
  let min-value5 min [investment] of admins
  let max-value5 max [investment] of admins
    ask admins [
    set investment_n ((investment - min-value5) / (max-value5 - min-value5))
  ]
  let min-value6 min [total_cars] of admins
  let max-value6 max [total_cars] of admins
  ask admins   [
    set total_cars_n ((total_cars - min-value6) / (max-value6 - min-value6))
  ]

  let min-value7 min [spillover_counter] of admins
  let max-value7 max [spillover_counter] of admins
  if (min-value7 = max-value7) = true [ask admins [set spillover_counter_n 0]]
  if (min-value7 = max-value7) = false [ask admins [set spillover_counter_n ((spillover_counter - min-value7) / (max-value7 - min-value7))]
  ]

  let min-value8 min [spillover_to] of admins
  let max-value8 max [spillover_to] of admins
  if (min-value8 = max-value8) = true [ask admins [set spillover_to_n 0]]
  if (min-value8 = max-value8) = false [ask admins[set spillover_to_n ((spillover_to - min-value8) / (max-value8 - min-value8))]
  ]

  ask transformators [
  let _mycol2 pcolor
  ask admins with [pcolor = _mycol2] [set avg_rfid_day [avg_rfid_dayT] of myself]];transformator werkt wel maar admin niet? checken.

  ask admins [set users_per_chargepoint (avg_rfid_day / number_of_cp)]
  let min-value9 min [users_per_chargepoint] of admins
  let max-value9 max [users_per_chargepoint] of admins
  if (min-value9 = max-value9) = true [ask admins [set users_per_chargepoint 0]]
  if (min-value9 = max-value9) = false [ask admins[set users_per_chargepoint_n ((users_per_chargepoint - min-value9) / (max-value9 - min-value9))]
  ]

end

;dit gedeelte altijd (want ondersteuning van de laad infra)
to admins-update-protocol-random
  ask min-n-of 3 admins [gridcap_mean] [ ;minste ruimte (zonder dynamiek)
    let _mycolor color
    ask one-of chargepoints with [pcolor = _mycolor] [
      if smart_pos = false [set smart_pos true ]]
    ask one-of chargepoints with [pcolor = _mycolor] [
      if v2g_pos = false [set v2g_pos true ]] ]
  ask max-n-of 3 admins [gridcap_mean] [ ;meeste ruimte (zonder dynamiek)
    let _mycolor color
    let duurtlang sort-on [occupancy_len] chargepoints with [pcolor = _mycolor]   ;welke laadpaal heeft de langste occupancy?
        ask first duurtlang [
            if fast_pos = false [set fast_pos true ]]]
end

to admins-get-battery-random ;wie krijgt een externe batterij (bij enkele waarden kunnen we ook zonder lijst werken)
  ask min-one-of admins [gridcap_mean] [ ;wie heeft er in principe de minste ruimte (zonder dynamiek)
    if resources_received_batt < 5 [
    set resources_received_batt resources_received_batt + 1
    let _mycolor color
    ask one-of transformators with [pcolor = _mycolor] [
      hatch-batteries 1
      set battery_enabled true
    ]
  ]]
end ; de batterij zelf nog implementeren, loopt bijv. vol op zonuren als er weinig aansluitingen zijn.

to admins-reset
  ask admins [
    ;admins-keep-track
    set max_occupied 0
    set equity_factor 0
    set occupied_perc 0
    set spillover_counter 0
    set spillover_to 0
    set kwh_score 0]
end

to admins-get-chargepoints-demand
  ask admins [
    admins-normalize
    let occupied_year (occupied_perc / tick_counter)
    set eval_number (max_occupied_n  + occupied_year + kwh_n + users_per_chargepoint) ;hoog aantal keren op de max bezetting, hoge bezettingsgraad, hoge kWh-vraag, aantal gebruikers
    let sorted-admins  sort-on [eval_number] admins
    print self print eval_number print "demand"
    let resource_verdeling 5 ;1e krijgt 5, 2e krijgt 4, derde krijgt 3, etc..
    foreach sorted-admins [
      x -> ask x [
        let _mycolor color
        if resource_cp_counter > 0 [ ; als er nog resources over zijn...
        set resource_cp_counter (resource_cp_counter - 1) ;reken ze ervanaf
        set resources_received_cp resources_received_cp + resource_verdeling
        ask one-of transformators with [pcolor = _mycolor] [
          hatch-chargepoints resource_verdeling
          set resource_verdeling resource_verdeling - 1]]]]
  ]
end

to admins-get-chargepoints-antici
ask admins [
    admins-normalize
    set potential (1 - percentage_nf)
    set eval_number (potential + nal_2025_n + avg_ink_n + total_cars_n) ;hoog groeipotentiaal (% nog geen ev), hoge prognose, hoog inkomen, hoog autobezit
    let sorted-admins sort-on [eval_number] admins
    print self print eval_number print "anticipation"
    foreach sorted-admins [
      x -> ask x [
        let _mycolor color
        if resource_cp_counter > 0 [ ; als er nog resources over zijn...
        set resource_cp_counter (resource_cp_counter - 1) ;reken ze ervanaf
        set resources_received_cp resources_received_cp + 3
        ask one-of transformators with [pcolor = _mycolor] [
            hatch-chargepoints 3]]]]
  ]
end

to admins-get-chargepoints-equity
  ask min-one-of admins [number_of_cp] [set equity_factor equity_factor + 0.10] ;kleine bonus voor de wijk met de minste laadpalen
  ask admins [
    admins-normalize
    set eval_number (equity_factor + spillover_counter_n + spillover_to_n - (investment_n)) ;hoge spillover (+ bonus minste CPs), lage investment
    let sorted-admins sort-on [eval_number] admins
    print self print eval_number print "equity"
    foreach sorted-admins [
      x -> ask x [ ;checken of dit ook echt op de juiste volgorde gaat
        let _mycolor color
        if resource_cp_counter > 0 [ ; als er nog resources over zijn...
        set resource_cp_counter (resource_cp_counter - 1) ;reken ze ervanaf
        set resources_received_cp resources_received_cp + 3
        ask one-of transformators with [pcolor = _mycolor] [
            hatch-chargepoints 3]]]]
]
end

;to admins-get-chargepoints-random ;wie krijgen er allemaal een laadpunt bij -> variabelen verzamelen en sorteren in lijst
  ;admins-normalize
  ;ask min-one-of admins [number_of_cp] [
    ;set equity_factor equity_factor + 0.25  print self print "equity factor" print equity_factor ] ;degene met de minste laadpalen krijgt een beetje voorrang
  ;ask admins [
    ;print self print number_of_cp
    ;set occupied_perc (occupied_perc / tick_counter)
    ;set eval_number (max_occupied_n + equity_factor + occupied_perc) ;max_occupied wordt per ronde bijgehouden, kan dus steeds hoger worden.
    ;print self print eval_number
    ;let sorted-admins sort-on [eval_number] admins
  ;print sorted-admins
    ;foreach sorted-admins [
      ;x -> ask x [ ;checken of dit ook echt op de juiste volgorde gaat
        ;let _mycolor color
        ;if resource_cp_counter > 0 [ ; als er nog resources over zijn...
        ;set resource_cp_counter (resource_cp_counter - 1) ;reken ze ervanaf
        ;set resources_received_cp resources_received_cp + 3
        ;ask one-of transformators with [pcolor = _mycolor] [
          ;hatch-chargepoints 3]]]] ;hatch ze erbij (kijken of dit ook over aantal ticks kan?)
    ;let _mycolor color
    ;set number_of_cp count chargepoints with [pcolor = _mycolor]
    ;print self print number_of_cp]
  ;]
;end
@#$#@#$#@
GRAPHICS-WINDOW
210
10
335
136
-1
-1
13.0
1
10
1
1
1
0
1
1
1
0
8
0
8
0
0
1
ticks
30.0

BUTTON
72
72
135
105
setup
setup
NIL
1
T
OBSERVER
NIL
S
NIL
NIL
1

BUTTON
75
125
172
158
decouple-all
decouple-all
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

MONITOR
549
63
674
108
# of charging points
count chargepoints
17
1
11

MONITOR
550
125
747
170
# of transformators
count transformators
17
1
11

MONITOR
681
64
748
109
occupied?
count-occupied-cps
17
1
11

BUTTON
368
29
515
62
go 1
go
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

MONITOR
768
63
941
108
Active fast charging sessions
count chargepoints with [fast_ena? = true]
17
1
11

MONITOR
814
125
996
170
Active smart charging sessions
count chargepoints with [smart_ena? = true]
17
1
11

MONITOR
858
299
974
344
NIL
failed_counter_full
17
1
11

MONITOR
837
357
988
402
NIL
failed_counter_thisround
17
1
11

MONITOR
550
11
735
56
# points that can smart charge
count chargepoints with [smart_pos = True]
17
1
11

MONITOR
768
10
943
55
# points that can fast charge
count chargepoints with [fast_pos = True]
17
1
11

MONITOR
751
125
808
170
Battery
count-my-batteries
17
1
11

MONITOR
682
237
796
282
average flexibility 
mean [grid_capacity_simple] of transformators
17
1
11

MONITOR
686
357
812
402
charged_since_start
charged_since_start
17
1
11

MONITOR
813
238
945
283
grid overload counter
grid_overload
17
1
11

MONITOR
949
10
1067
55
# v2g cps
count chargepoints with [v2g_pos = True]
17
1
11

MONITOR
957
65
1034
110
Active V2G 
count chargepoints with [v2g_ena? = true]
17
1
11

CHOOSER
475
181
653
226
Prioriteitenstrategie
Prioriteitenstrategie
1 2 3 "1 = current demand" "2 = anticipation" "3 = socio-economic"
2

PLOT
462
257
662
407
Mean occupation length (betrouwbaar >16t)
NIL
NIL
0.0
10.0
0.0
10.0
true
false
"" ""
PENS
"default" 1.0 0 -16777216 true "" "plot average-occu"

BUTTON
83
31
173
64
Go foverer
go
T
1
T
OBSERVER
NIL
F
NIL
NIL
1

MONITOR
240
181
397
226
Hour of the Day
tick_counter
17
1
11

MONITOR
684
297
846
342
Piek RFID triggered (peruur)
count transformators with [peak_rfid_triggered = True]
17
1
11

MONITOR
678
181
837
226
EV users per day 
sum [avg_rfid_dayT] of transformators
17
1
11

MONITOR
850
179
1002
224
EV users/neighbourhood
mean [avg_rfid_dayT] of transformators
17
1
11

MONITOR
198
260
394
305
Average spillover (from)
mean [spillover_counter] of admins
17
1
11

MONITOR
324
328
417
373
NIL
spillover_total
17
1
11

@#$#@#$#@
## WHAT IS IT?

The REVCID (Residential Electric Vehicle Charging Infrastructure Development) model is an agent-based model, built in NetLogo 6.3.0. It's goal is to identify strengths and weaknesses of various roll-out strategies, taking into account residential demand, growth projections, equity and grid limitations. 

Parameters from a real case study were used to initialize the model (identify-neighbourhoods.nls)

## HOW IT WORKS

The model can be split into two distinct parts:
1. The exploitation of charging infrastructure  2. The roll-out of new infrastructure and interventions.

For part 1, in each of the 9 neighbourhoods a breed called 'transformator' will receive charging demands and according to the information, available chargepoints, state of charge, grid availability and chargepoint technical ability, a charging speed or intervention is determined. If all the chargepoints in the transformator cluster are taken or there is no more grid availability, the session fails and the request will be moved to the nearest transformator. The transformator breed consists of all middle-voltage spaces within the neighbourhood that connect to a chargepoint. MSRspace determines the grid availability at the start of a tick; the MSR multiplier is used to adjust to the neighbourhood. The space reflects the 'mobility space' that the DSO reserves for charging. Charging behaviours and environment data are based on the aggregation of neighbourhoods as defined by CBS and Municipality of Amsterdam. A number of variables are reported and tracked to use later.

After half a year, the 9 neighbourhoods will come together and will rank themselves based on their charging needs. Currently, the model can explore three strategies for rolling out new charging infrastructure: Demand-based roll-out, Anticipatory roll-out and Equity-based roll-out. Other interventions, such as the addition of external battery buffers, are based on grid availability or other relevant variables.  

## HOW TO USE IT

The business factor (see DETERMINE-PEAK and IDENTIFY-NEIGHBOURHOOD) determines how many requests for charging are made in one round per neighbourhood. There is a growth projection (currently every 6 months, 10%), see GROW-DEMAND.

The strategy can be chosen under Prioriteitenstrategie. option 4-6 do not work, they are simply a label for 1-3.

## THINGS TO NOTICE

Globals, Breeds, Breed Variables, and Neighbourhood Statistics can be found in seperate NLS files.

## THINGS TO TRY

(suggested things for the user to try to do (move sliders, switches, etc.) with the model)

## EXTENDING THE MODEL

To use this model for your case study, please identify the relevant parameters for your case environment using:

- National Household Survey for income, car ownership, and number of households 
- Mobility space that is reserved by the DSO for charging
- Local grid peak hours
- Chargepoint occupancies throughout the day
- Chargepoint specifications (charging speed, is smart charging possible? etc.) 
- Growth predictions (either directly made by researchers/consultants or derived from statistical predictors) 

Ideas to develop the model:
- Considering the generation of renewable energy and try to use/store that as much as possible 


## NETLOGO FEATURES

(interesting or unusual features of NetLogo that the model uses, particularly in the Code tab; or where workarounds were needed for missing features)

## RELATED MODELS

(models in the NetLogo Models Library and elsewhere which are of related interest)

## CREDITS AND REFERENCES

Conceptual model: 
Mylene van der Koogh, Emile Chappin, Renee Heller, Zofia Lukszo,
A conceptual representation of short-term and long-term decision-making in the roll-out and exploitation of public EV charging infrastructure in Dutch neighborhoods,Transportation Research Procedia, Volume 70, 2023, Pages 178-187, ISSN 2352-1465, https://doi.org/10.1016/j.trpro.2023.11.017.

Central Bureau of Statistics Data (income, car ownership, number of citizens):
Centraal Bureau Statistiek 2023
Centraal Bureau Statistiek. (n.d.). Explanation of Key statistics of Neighborhoods. Retrieved May 1, 2023, from https://www.cbs.nl/-/media/_pdf/2022/35/toelichting-variabelen-kwb-2022.pdf
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

dot
false
0
Circle -7500403 true true 90 90 120

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

sheep
false
15
Circle -1 true true 203 65 88
Circle -1 true true 70 65 162
Circle -1 true true 150 105 120
Polygon -7500403 true false 218 120 240 165 255 165 278 120
Circle -7500403 true false 214 72 67
Rectangle -1 true true 164 223 179 298
Polygon -1 true true 45 285 30 285 30 240 15 195 45 210
Circle -1 true true 3 83 150
Rectangle -1 true true 65 221 80 296
Polygon -1 true true 195 285 210 285 210 240 240 210 195 210
Polygon -7500403 true false 276 85 285 105 302 99 294 83
Polygon -7500403 true false 219 85 210 105 193 99 201 83

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

wolf
false
0
Polygon -16777216 true false 253 133 245 131 245 133
Polygon -7500403 true true 2 194 13 197 30 191 38 193 38 205 20 226 20 257 27 265 38 266 40 260 31 253 31 230 60 206 68 198 75 209 66 228 65 243 82 261 84 268 100 267 103 261 77 239 79 231 100 207 98 196 119 201 143 202 160 195 166 210 172 213 173 238 167 251 160 248 154 265 169 264 178 247 186 240 198 260 200 271 217 271 219 262 207 258 195 230 192 198 210 184 227 164 242 144 259 145 284 151 277 141 293 140 299 134 297 127 273 119 270 105
Polygon -7500403 true true -1 195 14 180 36 166 40 153 53 140 82 131 134 133 159 126 188 115 227 108 236 102 238 98 268 86 269 92 281 87 269 103 269 113

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270
@#$#@#$#@
NetLogo 6.4.0
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
<experiments>
  <experiment name="testrun_4_4_output" repetitions="3" runMetricsEveryStep="true">
    <setup>setup</setup>
    <go>go</go>
    <timeLimit steps="86000"/>
    <metric>average-occu</metric>
    <metric>kk-cp</metric>
    <metric>er-cp</metric>
    <metric>ll-cp</metric>
    <metric>rs-cp</metric>
    <metric>lvs-cp</metric>
    <metric>bb-cp</metric>
    <metric>bl-cp</metric>
    <metric>gi-cp</metric>
    <metric>tr-cp</metric>
    <metric>kk-cp</metric>
    <metric>er-cp</metric>
    <metric>ll-cp</metric>
    <metric>rs-cp</metric>
    <metric>lvs-cp</metric>
    <metric>bb-cp</metric>
    <metric>bl-cp</metric>
    <metric>gi-cp</metric>
    <metric>tr-cp</metric>
    <metric>kk-batt</metric>
    <metric>er-batt</metric>
    <metric>ll-batt</metric>
    <metric>rs-batt</metric>
    <metric>lvs-batt</metric>
    <metric>bb-batt</metric>
    <metric>bl-batt</metric>
    <metric>gi-batt</metric>
    <metric>tr-batt</metric>
    <metric>kk-occu-len</metric>
    <metric>er-occu-len</metric>
    <metric>ll-occu-len</metric>
    <metric>rs-occu-len</metric>
    <metric>lvs-occu-len</metric>
    <metric>bb-occu-len</metric>
    <metric>bl-occu-len</metric>
    <metric>gi-occu-len</metric>
    <metric>tr-occu-len</metric>
    <metric>kk-occu-perc</metric>
    <metric>er-occu-perc</metric>
    <metric>ll-occu-perc</metric>
    <metric>rs-occu-perc</metric>
    <metric>lvs-occu-perc</metric>
    <metric>bb-occu-perc</metric>
    <metric>bl-occu-perc</metric>
    <metric>gi-occu-perc</metric>
    <metric>tr-occu-perc</metric>
    <metric>kk-bidir-charged</metric>
    <metric>er-bidir-charged</metric>
    <metric>ll-bidir-charged</metric>
    <metric>rs-bidir-charged</metric>
    <metric>lvs-bidir-charged</metric>
    <metric>bb-bidir-charged</metric>
    <metric>bl-bidir-charged</metric>
    <metric>gi-bidir-charged</metric>
    <metric>tr-bidir-charged</metric>
    <metric>kk-spill-from</metric>
    <metric>er-spill-from</metric>
    <metric>ll-spill-from</metric>
    <metric>rs-spill-from</metric>
    <metric>lvs-spill-from</metric>
    <metric>bb-spill-from</metric>
    <metric>bl-spill-from</metric>
    <metric>gi-spill-from</metric>
    <metric>tr-spill-from</metric>
    <metric>kk-spill-to</metric>
    <metric>er-spill-to</metric>
    <metric>ll-spill-to</metric>
    <metric>rs-spill-to</metric>
    <metric>lvs-spill-to</metric>
    <metric>bb-spill-to</metric>
    <metric>bl-spill-to</metric>
    <metric>gi-spill-to</metric>
    <metric>tr-spill-to</metric>
    <metric>kk-grid-cap</metric>
    <metric>er-grid-cap</metric>
    <metric>ll-grid-cap</metric>
    <metric>rs-grid-cap</metric>
    <metric>lvs-grid-cap</metric>
    <metric>bb-grid-cap</metric>
    <metric>bl-grid-cap</metric>
    <metric>gi-grid-cap</metric>
    <metric>tr-grid-cap</metric>
    <metric>kk-kwh</metric>
    <metric>er-kwh</metric>
    <metric>ll-kwh</metric>
    <metric>rs-kwh</metric>
    <metric>lvs-kwh</metric>
    <metric>bb-kwh</metric>
    <metric>bl-kwh</metric>
    <metric>gi-kwh</metric>
    <metric>tr-kwh</metric>
    <metric>kk-rfid-day</metric>
    <metric>er-rfid-day</metric>
    <metric>ll-rfid-day</metric>
    <metric>rs-rfid-day</metric>
    <metric>lvs-rfid-day</metric>
    <metric>bb-rfid-day</metric>
    <metric>bl-rfid-day</metric>
    <metric>gi-rfid-day</metric>
    <metric>tr-rfid-day</metric>
    <enumeratedValueSet variable="Prioriteitenstrategie">
      <value value="1"/>
      <value value="2"/>
      <value value="3"/>
    </enumeratedValueSet>
  </experiment>
  <experiment name="experiment_anticipatory_24_4_25Runs" repetitions="25" runMetricsEveryStep="false">
    <setup>setup</setup>
    <go>go</go>
    <timeLimit steps="43000"/>
    <metric>average-occu</metric>
    <metric>kk-cp</metric>
    <metric>kk-batt</metric>
    <metric>kk-occu-len</metric>
    <metric>kk-occu-perc</metric>
    <metric>kk-spill-from</metric>
    <metric>kk-spill-to</metric>
    <metric>kk-grid-cap</metric>
    <metric>kk-kwh</metric>
    <metric>kk-bidir-charged</metric>
    <metric>kk-rfid-day</metric>
    <metric>kk-b_charged</metric>
    <metric>kk-batt_charged</metric>
    <metric>kk-s_charged</metric>
    <metric>kk-f_charged</metric>
    <metric>kk-n_charged</metric>
    <metric>kk-grid-overload</metric>
    <metric>er-cp</metric>
    <metric>er-batt</metric>
    <metric>er-occu-len</metric>
    <metric>er-occu-perc</metric>
    <metric>er-spill-from</metric>
    <metric>er-spill-to</metric>
    <metric>er-grid-cap</metric>
    <metric>er-kwh</metric>
    <metric>er-bidir-charged</metric>
    <metric>er-rfid-day</metric>
    <metric>er-b_charged</metric>
    <metric>er-batt_charged</metric>
    <metric>er-s_charged</metric>
    <metric>er-f_charged</metric>
    <metric>er-n_charged</metric>
    <metric>er-grid-overload</metric>
    <metric>ll-cp</metric>
    <metric>ll-batt</metric>
    <metric>ll-occu-len</metric>
    <metric>ll-occu-perc</metric>
    <metric>ll-spill-from</metric>
    <metric>ll-spill-to</metric>
    <metric>ll-grid-cap</metric>
    <metric>ll-kwh</metric>
    <metric>ll-bidir-charged</metric>
    <metric>ll-rfid-day</metric>
    <metric>ll-b_charged</metric>
    <metric>ll-batt_charged</metric>
    <metric>ll-s_charged</metric>
    <metric>ll-f_charged</metric>
    <metric>ll-n_charged</metric>
    <metric>ll-grid-overload</metric>
    <metric>bl-cp</metric>
    <metric>bl-batt</metric>
    <metric>bl-occu-len</metric>
    <metric>bl-occu-perc</metric>
    <metric>bl-spill-from</metric>
    <metric>bl-spill-to</metric>
    <metric>bl-grid-cap</metric>
    <metric>bl-kwh</metric>
    <metric>bl-bidir-charged</metric>
    <metric>bl-rfid-day</metric>
    <metric>bl-b_charged</metric>
    <metric>bl-batt_charged</metric>
    <metric>bl-s_charged</metric>
    <metric>bl-f_charged</metric>
    <metric>bl-n_charged</metric>
    <metric>bl-grid-overload</metric>
    <metric>tr-cp</metric>
    <metric>tr-batt</metric>
    <metric>tr-occu-len</metric>
    <metric>tr-occu-perc</metric>
    <metric>tr-spill-from</metric>
    <metric>tr-spill-to</metric>
    <metric>tr-grid-cap</metric>
    <metric>tr-kwh</metric>
    <metric>tr-bidir-charged</metric>
    <metric>tr-rfid-day</metric>
    <metric>tr-b_charged</metric>
    <metric>tr-batt_charged</metric>
    <metric>tr-s_charged</metric>
    <metric>tr-f_charged</metric>
    <metric>tr-n_charged</metric>
    <metric>tr-grid-overload</metric>
    <metric>lvs-cp</metric>
    <metric>lvs-batt</metric>
    <metric>lvs-occu-len</metric>
    <metric>lvs-occu-perc</metric>
    <metric>lvs-spill-from</metric>
    <metric>lvs-spill-to</metric>
    <metric>lvs-grid-cap</metric>
    <metric>lvs-kwh</metric>
    <metric>lvs-bidir-charged</metric>
    <metric>lvs-rfid-day</metric>
    <metric>lvs-b_charged</metric>
    <metric>lvs-batt_charged</metric>
    <metric>lvs-s_charged</metric>
    <metric>lvs-f_charged</metric>
    <metric>lvs-n_charged</metric>
    <metric>lvs-grid-overload</metric>
    <metric>gi-cp</metric>
    <metric>gi-batt</metric>
    <metric>gi-occu-len</metric>
    <metric>gi-occu-perc</metric>
    <metric>gi-spill-from</metric>
    <metric>gi-spill-to</metric>
    <metric>gi-grid-cap</metric>
    <metric>gi-kwh</metric>
    <metric>gi-bidir-charged</metric>
    <metric>gi-rfid-day</metric>
    <metric>gi-b_charged</metric>
    <metric>gi-batt_charged</metric>
    <metric>gi-s_charged</metric>
    <metric>gi-f_charged</metric>
    <metric>gi-n_charged</metric>
    <metric>gi-grid-overload</metric>
    <metric>rs-cp</metric>
    <metric>rs-batt</metric>
    <metric>rs-occu-len</metric>
    <metric>rs-occu-perc</metric>
    <metric>rs-spill-from</metric>
    <metric>rs-spill-to</metric>
    <metric>rs-grid-cap</metric>
    <metric>rs-kwh</metric>
    <metric>rs-bidir-charged</metric>
    <metric>rs-rfid-day</metric>
    <metric>rs-b_charged</metric>
    <metric>rs-batt_charged</metric>
    <metric>rs-s_charged</metric>
    <metric>rs-f_charged</metric>
    <metric>rs-n_charged</metric>
    <metric>rs-grid-overload</metric>
    <metric>bb-cp</metric>
    <metric>bb-batt</metric>
    <metric>bb-occu-len</metric>
    <metric>bb-occu-perc</metric>
    <metric>bb-spill-from</metric>
    <metric>bb-spill-to</metric>
    <metric>bb-grid-cap</metric>
    <metric>bb-kwh</metric>
    <metric>bb-bidir-charged</metric>
    <metric>bb-rfid-day</metric>
    <metric>bb-b_charged</metric>
    <metric>bb-batt_charged</metric>
    <metric>bb-s_charged</metric>
    <metric>bb-f_charged</metric>
    <metric>bb-n_charged</metric>
    <metric>bb-grid-overload</metric>
    <runMetricsCondition>ticks mod 6 = 0</runMetricsCondition>
    <enumeratedValueSet variable="Prioriteitenstrategie">
      <value value="2"/>
    </enumeratedValueSet>
  </experiment>
  <experiment name="kwh_test" repetitions="1" runMetricsEveryStep="true">
    <setup>setup</setup>
    <go>go</go>
    <timeLimit steps="50"/>
    <metric>average-occu</metric>
    <metric>kk-kwh</metric>
    <metric>er-kwh</metric>
    <metric>ll-kwh</metric>
    <metric>rs-kwh</metric>
    <metric>lvs-kwh</metric>
    <metric>bb-kwh</metric>
    <metric>bl-kwh</metric>
    <metric>gi-kwh</metric>
    <metric>tr-kwh</metric>
    <enumeratedValueSet variable="Prioriteitenstrategie">
      <value value="1"/>
      <value value="2"/>
      <value value="3"/>
    </enumeratedValueSet>
  </experiment>
</experiments>
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 0.0 1.0
0.0 1 1.0 0.0
0.2 0 0.0 1.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180
@#$#@#$#@
0
@#$#@#$#@
