HouseNet (select preprocessed models from BuildingNet 0.1)

Generated for the MSc Thesis 3D Generative Adversarial Networks to Autonomously Generate Building Geometry
Organization: TU Delft, Faculty of Architecture and the Built Environment

HouseNet contains select 'house' and 'villa' models that originated from the BuildingNet v0.1 data set (Pratheba, et al.) which were then preprocessed to remove site geometry and relabeled to only include the 'door', 'roof', 'wall', and 'window' labels since these labels were in all models. For each building in this data set, the following files are included:

1. a modified point cloud file (.ply) which came from the original data set and was modified by removing site geometry and relabeling the points to make the models suited for deep learning for generative design

2. a modified file containing label information (.json) which came from the original data set and was modified to make the models suited for deep learning for generative design

3. a pickle file (.pkl) generated through pre-processing which contains information about the point cloud including the file name, label array, color array, typology, and building type information

Pratheba Selvaraju, Mohamed Nabail, Marios Loizou, Maria Maslioukova, Melinos Averkiou, Andreas Andreou, Siddhartha Chaudhuri, Evangelos Kalogerakis, "BuildingNet: Learning to Label 3D Buildings", Proceedings of the IEEE/CVF International Conference on Computer Vision (ICCV), 2021. https://buildingnet.org/

.ply files can be loaded using Open3D and the .json can be loaded and saved as a numpy array for use with the point cloud files

The pickle file can be loaded as a dictionary and it contains the following:
"name": name of the mesh,
"orig file name": the complete file name,
"scale factor": the scale facture (curently None),
"labels": a numpy array containing the point cloud lables,
"colors": a numpy array containing the point cloud colors based on labels,
"typology": the name of the building typology,
"building type": the name of the building type, 
"conv hull volume": the volume of the building's convex hull,
"bbox volume": the volume of the bounding box around the building geometry,
"bbox length": the length of the bounding box around the building geometry,
"bbox width": the width of the bounding box around the building geometry,
"bbox height": the height of the bounding box around the building geometry

----------------------------------------------
The labels of the HouseNet Data Set:
1:"wall"
2:"window"
4:"roof"
6:"door"

----------------------------------------------
The labels of the origional HouseNet Data Set
0:"undetermined"
1:"wall"
2:"window"
3:"vehicle"
4:"roof"
5:"plant_tree"
6:"door"
7:"tower_steeple"
8:"furniture"
9:"ground_grass"
10:"beam_frame"
11:"stairs"
12:"column"
13:"railing_baluster"
14:"floor"
15:"chimney"
16:"ceiling"
17:"fence"
18:"pond_pool"
19:"corridor_path"
20:"balcony_patio"
21:"garage"
22:"dome"
23:"road"
24:"entrance_gate"
25:"parapet_merlon"
26:"buttress"
27:"dormer"
28:"lantern_lamp"
29:"arch"
30:"awning"
31:"shutters"
