%% Polishing of metal 3D printed parts with complex geometry: visualizing the influence on geometrical features using centrifugal disk finishing 
% Image processing script
% author of the code: Kirsten Lussenburg
% date: 26-10-2022

%% 
clc
clear all
close all

%% Input
% Select the right folder
folder ='folder location';

% Select which file type
files = dir([folder '/*.bmp']);

%% Morphological Operations Images
n=0;
results= [];
for n = 1:1:12;

img = imread("name_"+[n]+".bmp");         % load image
img_raw = img;

% Extract the individual red, green, and blue color channels.
redChannel = img(:, :, 1);
greenChannel = img(:, :, 2);
blueChannel = img(:, :, 3);

treshold = 0.8;
Itrain2 = uint8(cat(3,redChannel, greenChannel, blueChannel));
binaryImage = im2bw(Itrain2,treshold);     %transfer to black-white

fig = figure, imshowpair(img_raw, binaryImage,'montage')

%Calculate statistics (percent coverage)
        %px values: white = 1, black = 0
black_px = sum(sum(binaryImage == 0));
white_px = sum(sum(binaryImage ==1));
total_px = size(binaryImage,1)*size(binaryImage,2);

per_black = black_px / total_px * 100;
results(end+1) = per_black;

end

% Calculate mean & std per group
results_per_group = reshape(results,[3,4]);
M = mean(results_per_group);
S = std(results_per_group);

% Bar graph
X = categorical({'Group 1','Group 2','Group 3','Group 4'});
X = reordercats(X,{'Group 1','Group 2','Group 3','Group 4'});
Y = M;
plot = bar(X,Y);
ylim([0 50])
hold on

er = errorbar(X,Y,-S,S);    
er.Color = [0 0 0];                            
er.LineStyle = 'none';  

hold off




