library(plotly)
library(gmodels)
library(readxl)
library(reshape2)
library(shiny) 
library(rcompanion)
library(olsrr)
library(foreign) #open various data files
library(car) #Package includes Levene's test 
library(tidyr)  # for wide to long format transformation of the data
library(QuantPsyc) #include lm.beta()
library(pander) #for rendering output for pander tables
library(ez) #for ezANOVA
library(psych) # reliability function
library(stringr) #find how many repeated aruguments
library(ggplot2) # plotting & data
library(pastecs) # plotting & data
library(lsr) # effect size
library(tidyverse) # visualize data
library(nlme) # for multilevel
library(lme4) # Non-linear multilevel
library(ggpubr) # plotting
library(rstatix) # for calculating effect size
library(fitdistrplus) # to fit distribution

Dataset <- read_excel('Dataset.xlsx', sheet = 'Sheet0')

RCPreAtt <- data.frame(Dataset$PreAttQ01, Dataset$PreAttQ02, Dataset$PreAttQ03, Dataset$PreAttQ04, Dataset$PreAttQ05, Dataset$PreAttQ06, Dataset$PreAttQ07, Dataset$PreAttQ08, Dataset$PreAttQ09, Dataset$PreAttQ10)
RCPostAtt <- data.frame(Dataset$PostAttQ01, Dataset$PostAttQ02, Dataset$PostAttQ03, Dataset$PostAttQ04, Dataset$PostAttQ05, Dataset$PostAttQ06, Dataset$PostAttQ07, Dataset$PostAttQ08, Dataset$PostAttQ09, Dataset$PostAttQ10)
RCPreWill <- data.frame(Dataset$PreWillQ01, Dataset$PreWillQ02, Dataset$PreWillQ03, Dataset$PreWillQ04, Dataset$PreWillQ05)
RCPostWill <- data.frame(Dataset$PostWillQ01, Dataset$PostWillQ02, Dataset$PostWillQ03, Dataset$PostWillQ04, Dataset$PostWillQ05)

alpha(RCPreAtt, keys = c(1, -1, 1, -1, 1, 1, 1, -1, -1, -1))
alpha(RCPostAtt, keys = c(1, -1, 1, -1, 1, 1, 1, -1, -1, -1))
alpha(RCPreWill)
alpha(RCPostWill)

Dataset$PreAttSum = Dataset$PreAttQ01 + (3 - Dataset$PreAttQ02) + Dataset$PreAttQ03 + (3 - Dataset$PreAttQ04) + Dataset$PreAttQ05 + Dataset$PreAttQ06 + Dataset$PreAttQ07 + (3 - Dataset$PreAttQ08) + (3 - Dataset$PreAttQ09) + (3 - Dataset$PreAttQ10)
Dataset$PostAttSum = Dataset$PostAttQ01 + (3 - Dataset$PostAttQ02) + Dataset$PostAttQ03 + (3 - Dataset$PostAttQ04) + Dataset$PostAttQ05 + Dataset$PostAttQ06 + Dataset$PostAttQ07 + (3 - Dataset$PostAttQ08) + (3 - Dataset$PostAttQ09) + (3 - Dataset$PostAttQ10)
Dataset$PreWillMean = (Dataset$PreWillQ01 + Dataset$PreWillQ02 + Dataset$PreWillQ03 + Dataset$PreWillQ04 + Dataset$PreWillQ05)/5
Dataset$PostWillMean = (Dataset$PostWillQ01 + Dataset$PostWillQ02 + Dataset$PostWillQ03 + Dataset$PostWillQ04 + Dataset$PostWillQ05)/5

Dataset$Group = factor(Dataset$Group, levels = c("Control","Exprmt"))

MtvPre <- data.frame(Dataset$ResponseId, Dataset$Group, '1Pre', Dataset$PreAttSum, Dataset$PreWillMean)
MtvPost <- data.frame(Dataset$ResponseId, Dataset$Group, '2Post', Dataset$PostAttSum, Dataset$PostWillMean)

colnames(MtvPre) <- "ParticipantID"
colnames(MtvPre)[2] <- "Group"
colnames(MtvPre)[3] <- "Session"
colnames(MtvPre)[4] <- "AttScore"
colnames(MtvPre)[5] <- "WillScore"

colnames(MtvPost) <- "ParticipantID"
colnames(MtvPost)[2] <- "Group"
colnames(MtvPost)[3] <- "Session"
colnames(MtvPost)[4] <- "AttScore"
colnames(MtvPost)[5] <- "WillScore"

Mtv <- rbind(MtvPre, MtvPost)

controlMtv = Mtv[Mtv$'Group'=='Control', ]
exprmtMtv = Mtv[Mtv$'Group'=='Exprmt', ]

stem(controlMtv$AttScore)
stem(controlMtv$WillScore)
stem(exprmtMtv$AttScore)
stem(exprmtMtv$WillScore)

ggplot(controlMtv,
aes(AttScore)) + geom_histogram(aes(y=..density..),binwidth = 1,
colour="black", fill="white") + labs(x='Density plot - Control Group Attitude',
y="Density") + stat_function(fun=dnorm,
args=list(mean=mean(controlMtv$AttScore, na.rm=TRUE),
sd=sd(controlMtv$AttScore, na.rm=TRUE)), colour="black", size=1)

ggplot(exprmtMtv,
aes(AttScore)) + geom_histogram(aes(y=..density..),binwidth = 1,
colour="black", fill="white") + labs(x='Density plot - Experimental Group Attitude',
y="Density") + stat_function(fun=dnorm,
args=list(mean=mean(exprmtMtv$AttScore, na.rm=TRUE),
sd=sd(exprmtMtv$AttScore, na.rm=TRUE)), colour="black", size=1)

ggplot(controlMtv,
aes(WillScore)) + geom_histogram(aes(y=..density..),binwidth = 1,
colour="black", fill="white") + labs(x='Density plot - Control Group Willingness',
y="Density") + stat_function(fun=dnorm,
args=list(mean=mean(controlMtv$WillScore, na.rm=TRUE),
sd=sd(controlMtv$WillScore, na.rm=TRUE)), colour="black", size=1)

ggplot(exprmtMtv,
aes(WillScore)) + geom_histogram(aes(y=..density..),binwidth = 1,
colour="black", fill="white") + labs(x='Density plot - Experimental Group Willingness',
y="Density") + stat_function(fun=dnorm,
args=list(mean=mean(exprmtMtv$WillScore, na.rm=TRUE),
sd=sd(exprmtMtv$WillScore, na.rm=TRUE)), colour="black", size=1)

ggplot(Mtv, aes(x=AttScore, fill=Group)) + geom_density(alpha = 0.3)
ggplot(Mtv, aes(x=WillScore, fill=Group)) + geom_density(alpha = 0.3)

ggplot(exprmtMtv, aes(x=AttScore, fill=Session)) + geom_density(alpha = 0.3)
ggplot(controlMtv, aes(x=AttScore, fill=Session)) + geom_density(alpha = 0.3)
ggplot(exprmtMtv, aes(x=WillScore, fill=Session)) + geom_density(alpha = 0.3)
ggplot(controlMtv, aes(x=WillScore, fill=Session)) + geom_density(alpha = 0.3)



#Hypothesis 1
#The test-takers do feel more motivated to contact a helpline for further professional help after taking the mental health self-test 
#in an interactive way than taking the self-test for mental health in a traditional questionnaire way. 

#Attitude questionnaire
ModelH1A0 <- lme(AttScore ~ 1, data=Mtv, random = ~1|ParticipantID, method="ML")  #random intercept
summary(ModelH1A0)

ModelH1A1 <- update(ModelH1A0, .~. + Session)  #random intercept + Session
summary(ModelH1A1)
anova(ModelH1A0, ModelH1A1)

ModelH1A2 <- update(ModelH1A0, .~. + Group) #random intercept + Group
summary(ModelH1A2)
anova(ModelH1A0, ModelH1A2)

ModelH1A3 <- lme(AttScore ~ Session + Group, data=Mtv, random = ~1|ParticipantID, method="ML") #random intercept + Session + Group
summary(ModelH1A3)

ModelH1A4 <- lme(AttScore ~ Session + Group + Session:Group, data=Mtv, random = ~1|ParticipantID, method="ML") #random intercept + Session + Group + S:G Interaction
summary(ModelH1A4)
anova(ModelH1A3, ModelH1A4)


control= Dataset[Dataset$Group=="Control", ]
exprmt = Dataset[Dataset$Group=="Exprmt", ]

path1 = data.frame(x=c(1,1,2,2),y=c(22.2,22.7,22.7,22.2))
y1cA=mean(control$PreAttSum)
y2cA=mean(control$PostAttSum)
y1eA=mean(exprmt$PreAttSum)
y2eA=mean(exprmt$PostAttSum)


by_Att <- Mtv %>% group_by(Group, Session) %>% summarise(AttScore = mean(AttScore))

ggplot(by_Att) + 
  geom_bar(aes(x = Group, y=AttScore, fill = Session), position = position_dodge(preserve = 'single'), stat = 'identity') +  
  coord_cartesian(ylim=c(1.18,24.82)) +  geom_path(data = path1, aes(x = x,y = y))+ annotate("text",x=1.5,y=23,label="**") +
  geom_segment(aes(x = 0.75, y = y1cA, xend = 1.25, yend = y2cA))+ geom_segment(aes(x = 1.75, y = y1eA, xend = 2.25, yend = y2eA))+
  ylab("Attitude Score")+ labs(fill = "Session")


#Willingness Questionnaire
ModelH1W0 <- lme(WillScore ~ 1, data=Mtv, random = ~1|ParticipantID, method="ML") 
summary(ModelH1W0)

ModelH1W1 <- update(ModelH1W0, .~. + Session)  #random intercept + Session
summary(ModelH1W1)
anova(ModelH1W0, ModelH1W1)

ModelH1W2 <- update(ModelH1W0, .~. + Group) #random intercept + Group
summary(ModelH1W2)
anova(ModelH1W0, ModelH1W2)

ModelH1W3 <- lme(WillScore ~ Session + Group, data=Mtv, random = ~1|ParticipantID, method="ML") #random intercept + Session + Group
summary(ModelH1W3)

ModelH1W4 <- lme(WillScore ~ Session + Group + Session:Group, data=Mtv, random = ~1|ParticipantID, method="ML") #random intercept + Session + Group + S:G Interaction
summary(ModelH1W4)
anova(ModelH1W3, ModelH1W4)

path2 = data.frame(x=c(1,1,2,2),y=c(4.7,4.8,4.8,4.7))
y1cW=mean(control$PreWillMean)
y2cW=mean(control$PostWillMean)
y1eW=mean(exprmt$PreWillMean)
y2eW=mean(exprmt$PostWillMean)

by_Will <- Mtv %>% group_by(Group, Session) %>% summarise(WillScore = mean(WillScore))

ggplot(by_Will) + 
  geom_bar(aes(x = Group, y=WillScore, fill = Session), position = position_dodge(preserve = 'single'), stat = 'identity') +  
  coord_cartesian(ylim=c(1.18,4.82)) +  geom_path(data = path2, aes(x = x,y = y))+ annotate("text",x=1.5,y=4.9,label="**") +
  geom_segment(aes(x = 0.75, y = y1cW, xend = 1.25, yend = y2cW))+ geom_segment(aes(x = 1.75, y = y1eW, xend = 2.25, yend = y2eW))+
  ylab("Willingness Score")+ labs(fill = "Session")

#Hypothesis 2
RCFBH <- data.frame(Dataset$FBHQ01, Dataset$FBHQ02, Dataset$FBHQ03, Dataset$FBHQ04, Dataset$FBHQ05, Dataset$FBHQ06, Dataset$FBHQ07)
RCCSQ <- data.frame(Dataset$CSQ01, Dataset$CSQ02, Dataset$CSQ03, Dataset$CSQ04)

alpha(RCFBH)
alpha(RCCSQ)

Dataset$FBHScore = (Dataset$FBHQ01 + Dataset$FBHQ02 + Dataset$FBHQ03 + Dataset$FBHQ04 + Dataset$FBHQ05 + Dataset$FBHQ06 + Dataset$FBHQ07) / 7
Dataset$CSQScore = Dataset$CSQ01 + Dataset$CSQ02 + Dataset$CSQ03 + Dataset$CSQ04

FBH <- data.frame(Dataset$ResponseId, Dataset$Group, Dataset$FBHScore)
CSQ <- data.frame(Dataset$ResponseId, Dataset$Group, Dataset$CSQScore)

colnames(FBH) <- "ParticipantID"
colnames(FBH)[2] <- "Group"
colnames(FBH)[3] <- "FBHScore"

colnames(CSQ) <- "ParticipantID"
colnames(CSQ)[2] <- "Group"
colnames(CSQ)[3] <- "CSQScore"

controlFBH = FBH[FBH$Group == 'Control',]
exprmtFBH = FBH[FBH$Group == 'Exprmt',]

stem(controlFBH$FBHScore)
stem(exprmtFBH$FBHScore)

ggplot(FBH, aes(x=FBHScore, fill=Group)) + geom_density(alpha = 0.3)

ModelH2F0 <- lme(FBHScore ~ 1, data=FBH, random = ~1|ParticipantID, method="ML")
summary(ModelH2F0)

ModelH2F1 <- lme(FBHScore ~ Group, data = FBH, random = ~1|ParticipantID, method="ML")
summary(ModelH2F1)
anova(ModelH2F0, ModelH2F1)

controlCSQ = CSQ[CSQ$Group == 'Control',]
exprmtCSQ = CSQ[CSQ$Group == 'Exprmt',]

stem(controlCSQ$CSQScore)
stem(exprmtCSQ$CSQScore)

ggplot(CSQ, aes(x=CSQScore, fill=Group)) + geom_density(alpha = 0.3)

ModelH2C0 <- lme(CSQScore ~ 1, data=CSQ, random = ~1|ParticipantID, method="ML")

ModelH2C1 <- lme(CSQScore ~ Group, data = CSQ, random = ~1|ParticipantID, method = "ML")
summary(ModelH2C1)
anova(ModelH2C0, ModelH2C1)

#path3 = data.frame(x=c(1,1,2,2),y=c(4.7,4.8,4.8,4.7))
y1cF=mean(controlFBH$FBHScore)
y1eF=mean(exprmtFBH$FBHScore)


by_FBH <- FBH %>% group_by(Group) %>% summarise(FBHScore = mean(FBHScore))


ggplot(by_FBH) + 
  geom_bar(aes(x = Group, y=FBHScore, fill = Group), position = position_dodge(preserve = 'single'), stat = 'identity') +  
  #coord_cartesian(ylim=c(1.18,6.82)) +  #geom_path(data = path3, aes(x = x,y = y))+ annotate("text",x=1.5,y=4.9,label="**") +
  #geom_segment(aes(x = 0.75, y = y1cF, xend = 1.25, yend = y1cF))+ geom_segment(aes(x = 1.75, y = y1eF, xend = 2.25, yend = y1eF))+
  ylab("FBH Score")+ labs(fill = "Group")

#path3 = data.frame(x=c(1,1,2,2),y=c(4.7,4.8,4.8,4.7))
y1cC=mean(controlCSQ$CSQScore)
y1eC=mean(exprmtCSQ$CSQScore)


by_CSQ <- CSQ %>% group_by(Group) %>% summarise(CSQScore = mean(CSQScore))


ggplot(by_CSQ) + 
  geom_bar(aes(x = Group, y=CSQScore, fill = Group), position = position_dodge(preserve = 'single'), stat = 'identity') +  
  #coord_cartesian(ylim=c(1.18,6.82)) +  #geom_path(data = path3, aes(x = x,y = y))+ annotate("text",x=1.5,y=4.9,label="**") +
  geom_segment(aes(x = 1.00, y = y1cC, xend = 2.00, yend = y1eC)) +
  ylab("CSQ Score")+ labs(fill = "Group")


#Hypothesis 3
RCUS <- data.frame(Dataset$USQ01, Dataset$USQ02, Dataset$USQ03, Dataset$USQ04, Dataset$USQ05, Dataset$USQ06)
alpha(RCUS)

Dataset$USScore = Dataset$USQ01 + Dataset$USQ02 + Dataset$USQ03 + Dataset$USQ04 + Dataset$USQ05 + Dataset$USQ06
US <- data.frame(Dataset$ResponseId, Dataset$Group, Dataset$USScore)

colnames(US) <- "ParticipantID"
colnames(US)[2] <- "Group"
colnames(US)[3] <- "USScore"

controlUS = US[US$Group == 'Control',]
exprmtUS = US[US$Group == 'Exprmt',]

stem(controlUS$USScore)
stem(exprmtUS$USScore)

ggplot(US, aes(x=USScore, fill=Group)) + geom_density(alpha = 0.3)

ModelH2U0 <- lme(USScore ~ 1, data=US, random = ~1|ParticipantID, method="ML")

ModelH2U1 <- lme(USScore ~ Group, data = US, random = ~1|ParticipantID, method="ML")
summary(ModelH2U1)
anova(ModelH2U0, ModelH2U1)

#path3 = data.frame(x=c(1,1,2,2),y=c(4.7,4.8,4.8,4.7))
y1cU=mean(controlUS$USScore)
y1eU=mean(exprmtUS$USScore)


by_US <- US %>% group_by(Group) %>% summarise(USScore = mean(USScore))


ggplot(by_US) + 
  geom_bar(aes(x = Group, y=USScore, fill = Group), position = position_dodge(preserve = 'single'), stat = 'identity') +  
  #coord_cartesian(ylim=c(1.18,6.82)) +  #geom_path(data = path3, aes(x = x,y = y))+ annotate("text",x=1.5,y=4.9,label="**") +
  geom_segment(aes(x = 1.00, y = y1cU, xend = 2.00, yend = y1eU)) +
  ylab("US Score")+ labs(fill = "Group")


#Exploratory analysis
#Issue Involvement Level
RCIIC <- data.frame(Dataset$IICQ01, Dataset$IICQ02, Dataset$IICQ03)
alpha(RCIIC)

Dataset$IICMean = (Dataset$IICQ01 + Dataset$IICQ02 + Dataset$IICQ03)/3

control= Dataset[Dataset$Group=="Control", ]
exprmt = Dataset[Dataset$Group=="Exprmt", ]

stem(control$IICMean)
stem(exprmt$IICMean)

cIICMean = mean(control$IICMean)
eIICMean = mean(exprmt$IICMean)

control$IICLevel[control$IICMean < cIICMean] <- 'low'
control$IICLevel[control$IICMean >= cIICMean] <- 'high'
control$IICLevel = factor(control$IICLevel, levels = c("low", "high"))

exprmt$IICLevel[exprmt$IICMean < eIICMean] <- 'low'
exprmt$IICLevel[exprmt$IICMean >= eIICMean] <- 'high'
exprmt$IICLevel = factor(exprmt$IICLevel, levels = c("low", "high"))

controlIICH = control[control$IICLevel == 'high',]
controlIICL = control[control$IICLevel == 'low',]
exprmtIICH = exprmt[exprmt$IICLevel == 'high',]
exprmtIICL = exprmt[exprmt$IICLevel == 'low',]

MtvCPre <- data.frame(control$ResponseId, control$Group, '1Pre', control$PreAttSum, control$PreWillMean, control$IICLevel, control$IICMean)
MtvCPost <- data.frame(control$ResponseId, control$Group, '2Post', control$PostAttSum, control$PostWillMean, control$IICLevel, control$IICMean)

colnames(MtvCPre) <- "ParticipantID"
colnames(MtvCPre)[2] <- "Group"
colnames(MtvCPre)[3] <- "Session"
colnames(MtvCPre)[4] <- "AttScore"
colnames(MtvCPre)[5] <- "WillScore"
colnames(MtvCPre)[6] <- 'IICLevel'
colnames(MtvCPre)[7] <- 'IICScore'

colnames(MtvCPost) <- "ParticipantID"
colnames(MtvCPost)[2] <- "Group"
colnames(MtvCPost)[3] <- "Session"
colnames(MtvCPost)[4] <- "AttScore"
colnames(MtvCPost)[5] <- "WillScore"
colnames(MtvCPost)[6] <- 'IICLevel'
colnames(MtvCPost)[7] <- 'IICScore'

MtvEPre <- data.frame(exprmt$ResponseId, exprmt$Group, '1Pre', exprmt$PreAttSum, exprmt$PreWillMean, exprmt$IICLevel, exprmt$IICMean)
MtvEPost <- data.frame(exprmt$ResponseId, exprmt$Group, '2Post', exprmt$PostAttSum, exprmt$PostWillMean, exprmt$IICLevel, exprmt$IICMean)

colnames(MtvEPre) <- "ParticipantID"
colnames(MtvEPre)[2] <- "Group"
colnames(MtvEPre)[3] <- "Session"
colnames(MtvEPre)[4] <- "AttScore"
colnames(MtvEPre)[5] <- "WillScore"
colnames(MtvEPre)[6] <- 'IICLevel'
colnames(MtvEPre)[7] <- 'IICScore'

colnames(MtvEPost) <- "ParticipantID"
colnames(MtvEPost)[2] <- "Group"
colnames(MtvEPost)[3] <- "Session"
colnames(MtvEPost)[4] <- "AttScore"
colnames(MtvEPost)[5] <- "WillScore"
colnames(MtvEPost)[6] <- 'IICLevel'
colnames(MtvEPost)[7] <- 'IICScore'


MtvIIC <- rbind(MtvCPre, MtvCPost, MtvEPre, MtvEPost)
MtvIICc <- rbind(MtvCPre, MtvCPost)
MtvIICe <- rbind(MtvEPre, MtvEPost)
MtvIICH = MtvIIC[MtvIIC$IICLevel == 'high',]
MtvIICL = MtvIIC[MtvIIC$IICLevel == 'low',]

y1cAH=mean(controlIICH$PreAttSum)
y2cAH=mean(controlIICH$PostAttSum)
y1eAH=mean(exprmtIICH$PreAttSum)
y2eAH=mean(exprmtIICH$PostAttSum)

by_AttH <- MtvIICH %>% group_by(Group, Session) %>% summarise(AttScore = mean(AttScore))

ggplot(by_AttH) + 
  geom_bar(aes(x = Group, y=AttScore, fill = Session), position = position_dodge(preserve = 'single'), stat = 'identity') +  
  coord_cartesian(ylim=c(1.18,24.82))+  
  geom_segment(aes(x = 0.75, y = y1cAH, xend = 1.25, yend = y2cAH))+ geom_segment(aes(x = 1.75, y = y1eAH, xend = 2.25, yend = y2eAH))+
  ylab("Attitute Score with High Involvement Level")+ labs(fill = "Moment of measure")

y1cAL=mean(controlIICL$PreAttSum)
y2cAL=mean(controlIICL$PostAttSum)
y1eAL=mean(exprmtIICL$PreAttSum)
y2eAL=mean(exprmtIICL$PostAttSum)

by_AttL <- MtvIICL %>% group_by(Group, Session) %>% summarise(AttScore = mean(AttScore))

ggplot(by_AttL) + 
  geom_bar(aes(x = Group, y=AttScore, fill = Session), position = position_dodge(preserve = 'single'), stat = 'identity') +  
  coord_cartesian(ylim=c(1.18,24.82))+  
  geom_segment(aes(x = 0.75, y = y1cAL, xend = 1.25, yend = y2cAL))+ geom_segment(aes(x = 1.75, y = y1eAL, xend = 2.25, yend = y2eAL))+
  ylab("Attitute Score with Low Involvement Level")+ labs(fill = "Moment of measure")

y1cWH=mean(controlIICH$PreWillMean)
y2cWH=mean(controlIICH$PostWillMean)
y1eWH=mean(exprmtIICH$PreWillMean)
y2eWH=mean(exprmtIICH$PostWillMean)

by_WillH <- MtvIICH %>% group_by(Group, Session) %>% summarise(WillScore = mean(WillScore))

ggplot(by_WillH) + 
  geom_bar(aes(x = Group, y=WillScore, fill = Session), position = position_dodge(preserve = 'single'), stat = 'identity') +  
  coord_cartesian(ylim=c(1.18,4.82))+  
  geom_segment(aes(x = 0.75, y = y1cWH, xend = 1.25, yend = y2cWH))+ geom_segment(aes(x = 1.75, y = y1eWH, xend = 2.25, yend = y2eWH))+
  ylab("Willingness Score with High Involvement Level")+ labs(fill = "Moment of measure")

y1cWL=mean(controlIICL$PreWillMean)
y2cWL=mean(controlIICL$PostWillMean)
y1eWL=mean(exprmtIICL$PreWillMean)
y2eWL=mean(exprmtIICL$PostWillMean)

by_WillL <- MtvIICL %>% group_by(Group, Session) %>% summarise(WillScore = mean(WillScore))

ggplot(by_WillL) + 
  geom_bar(aes(x = Group, y=WillScore, fill = Session), position = position_dodge(preserve = 'single'), stat = 'identity') +  
  coord_cartesian(ylim=c(1.18,4.82))+  
  geom_segment(aes(x = 0.75, y = y1cWL, xend = 1.25, yend = y2cWL))+ geom_segment(aes(x = 1.75, y = y1eWL, xend = 2.25, yend = y2eWL))+
  ylab("Willingness Score with Low Involvement Level")+ labs(fill = "Moment of measure")

#Moderation Analysis with Issue Involvement Level
#Attitude
ModelE1I1 <- lme(AttScore ~ Session + IICLevel, data=MtvIIC, random = ~1|ParticipantID, method="ML") #random intercept + Session + IICLevel
ModelE1I2 <- lme(AttScore ~ Group + IICLevel, data=MtvIIC, random = ~1|ParticipantID, method="ML") #random intercept + Group + IICLevel
ModelE1I3 <- lme(AttScore ~ Session + Group + Session:Group + IICLevel, data=MtvIIC, random = ~1|ParticipantID, method="ML") #random intercept + Session + Group + IICLevel

anova(ModelE1I1, ModelE1I2, ModelE1I3)
anova(ModelH1A4, ModelE1I3)

ModelE1I4 <- lme(AttScore ~ Session + Group + Session:Group + IICLevel + Session:IICLevel, data=MtvIIC, random = ~1|ParticipantID, method="ML") #random intercept + Session + IICLevel + Session:IICLevel Interaction
ModelE1I5 <- lme(AttScore ~ Session + Group + Session:Group + IICLevel + Group:IICLevel, data=MtvIIC, random = ~1|ParticipantID, method="ML") #random intercept + Group + IICLevel + Group:IICLevel Interaction
ModelE1I6 <- lme(AttScore ~ Session + Group + IICLevel + Session:Group + Session:IICLevel + Group:IICLevel + Session:Group:IICLevel, data=MtvIIC, random = ~1|ParticipantID, method="ML") #random intercept + Session + Group + S:G Interaction + Session:IICLevel + Group:IICLevel


ModelE1I00 <- lme(AttScore ~ Session + Group + Session:Group, data=MtvIIC, random = ~1|ParticipantID, method="ML") #random intercept + Session + IICLevel
ModelE1I01 <- lme(AttScore ~ Session + Group + IICScore + Session:Group, data=MtvIIC, random = ~1|ParticipantID, method="ML") #random intercept + Group + IICScore
ModelE1I02 <- lme(AttScore ~ Session + Group + IICScore + Session:Group + Session:IICScore, data=MtvIIC, random = ~1|ParticipantID, method="ML") #random intercept + Session + Group + IICScore
ModelE1I03 <- lme(AttScore ~ Session + Group + IICScore + Session:Group + Group:IICScore, data=MtvIIC, random = ~1|ParticipantID, method="ML") #random intercept + Session + Group + IICScore
ModelE1I04 <- lme(AttScore ~ Session + Group + IICScore + Session:Group + Session:IICScore + Group:IICScore + Session:Group:IICScore, data=MtvIIC, random = ~1|ParticipantID, method="ML") #random intercept + Session + Group + IICScore

anova(ModelE1I00, ModelE1I01)

summary(ModelE1I04)

#Willingness
ModelE1I1W <- lme(WillScore ~ Session + IICLevel, data=MtvIIC, random = ~1|ParticipantID, method="ML") #random intercept + Session + IICLevel
ModelE1I2W <- lme(WillScore ~ Group + IICLevel, data=MtvIIC, random = ~1|ParticipantID, method="ML") #random intercept + Group + IICLevel
ModelE1I3W <- lme(WillScore ~ Session + Group + IICLevel, data=MtvIIC, random = ~1|ParticipantID, method="ML") #random intercept + Session + Group + IICLevel

anova(ModelE1I1W, ModelE1I2W, ModelE1I3W)

ModelE1I4W <- lme(WillScore ~ Session + IICLevel + Session:IICLevel, data=MtvIIC, random = ~1|ParticipantID, method="ML") #random intercept + Session + IICLevel + Session:IICLevel Interaction
ModelE1I5W <- lme(WillScore ~ Group + IICLevel + Group:IICLevel, data=MtvIIC, random = ~1|ParticipantID, method="ML") #random intercept + Group + IICLevel + Group:IICLevel Interaction
ModelE1I6W <- lme(WillScore ~ Session + Group + IICLevel +Session:Group + Session:IICLevel + Group:IICLevel, data=MtvIIC, random = ~1|ParticipantID, method="ML") #random intercept + Session + Group + S:G Interaction + Session:IICLevel + Group:IICLevel

anova(ModelE1I1W, ModelE1I4W)
anova(ModelE1I2W, ModelE1I5W)
anova(ModelE1I3W, ModelE1I6W)
summary(ModelE1I4W)
summary(ModelE1I5W)
summary(ModelE1I6W)

#Age Group
Dataset$Age = factor(Dataset$Age, levels = c("1","2","3","4","5"))

MTVPre <- data.frame(Dataset$ResponseId, Dataset$Group, Dataset$Age, Dataset$AgeNum, '1Pre', Dataset$PreAttSum, Dataset$PreWillMean)
MTVPost <- data.frame(Dataset$ResponseId, Dataset$Group, Dataset$Age, Dataset$AgeNum, '2Post', Dataset$PostAttSum, Dataset$PostWillMean)

colnames(MTVPre) <- "ParticipantID"
colnames(MTVPre)[2] <- "Group"
colnames(MTVPre)[3] <- "Age"
colnames(MTVPre)[4] <- "AgeNum"
colnames(MTVPre)[5] <- "Session"
colnames(MTVPre)[6] <- "AttScore"
colnames(MTVPre)[7] <- "WillScore"

colnames(MTVPost) <- "ParticipantID"
colnames(MTVPost)[2] <- "Group"
colnames(MTVPost)[3] <- "Age"
colnames(MTVPost)[4] <- "AgeNum"
colnames(MTVPost)[5] <- "Session"
colnames(MTVPost)[6] <- "AttScore"
colnames(MTVPost)[7] <- "WillScore"

MTV <- rbind(MTVPre, MTVPost)

MTVA1 = MTV[MTV$Age == "1", ]
MTVA2 = MTV[MTV$Age == "2", ]
MTVA3 = MTV[MTV$Age == "3", ]
MTVA4 = MTV[MTV$Age == "4", ]
MTVA5 = MTV[MTV$Age == "5", ]
MTVA45 = rbind(MTVA4, MTVA5)

DataA1 = Dataset[Dataset$Age == '1', ]
DataA2 = Dataset[Dataset$Age == '2', ]
DataA3 = Dataset[Dataset$Age == '3', ]
DataA4 = Dataset[Dataset$Age == '4', ]
DataA5 = Dataset[Dataset$Age == '5', ]
DataA45 = rbind(DataA4, DataA5)

controlA1= DataA1[DataA1$Group=="Control", ]
exprmtA1 = DataA1[DataA1$Group=="Exprmt", ]
controlA2= DataA2[DataA2$Group=="Control", ]
exprmtA2 = DataA2[DataA2$Group=="Exprmt", ]
controlA3= DataA3[DataA3$Group=="Control", ]
exprmtA3 = DataA3[DataA3$Group=="Exprmt", ]
controlA4= DataA4[DataA4$Group=="Control", ]
exprmtA4 = DataA4[DataA4$Group=="Exprmt", ]
controlA5= DataA5[DataA5$Group=="Control", ]
exprmtA5 = DataA5[DataA5$Group=="Exprmt", ]
controlA45 = rbind(controlA4, controlA5)
exprmtA45 = rbind(exprmtA4, exprmtA5)

controlA= Dataset[Dataset$Group=="Control", ]
exprmtA = Dataset[Dataset$Group=="Exprmt", ]

MTVPreAc <- data.frame(controlA$ResponseId, controlA$Group, controlA$Age, controlA$AgeNum, '1Pre', controlA$PreAttSum, controlA$PreWillMean)
MTVPostAc <- data.frame(controlA$ResponseId, controlA$Group, controlA$Age, controlA$AgeNum, '2Post', controlA$PostAttSum, controlA$PostWillMean)

colnames(MTVPreAc) <- "ParticipantID"
colnames(MTVPreAc)[2] <- "Group"
colnames(MTVPreAc)[3] <- "Age"
colnames(MTVPreAc)[4] <- "AgeNum"
colnames(MTVPreAc)[5] <- "Session"
colnames(MTVPreAc)[6] <- "AttScore"
colnames(MTVPreAc)[7] <- "WillScore"

colnames(MTVPostAc) <- "ParticipantID"
colnames(MTVPostAc)[2] <- "Group"
colnames(MTVPostAc)[3] <- "Age"
colnames(MTVPostAc)[4] <- "AgeNum"
colnames(MTVPostAc)[5] <- "Session"
colnames(MTVPostAc)[6] <- "AttScore"
colnames(MTVPostAc)[7] <- "WillScore"

MTVAc <- rbind(MTVPreAc, MTVPostAc)

MTVPreAe <- data.frame(exprmtA$ResponseId, exprmtA$Group, exprmtA$Age, exprmtA$AgeNum, '1Pre', exprmtA$PreAttSum, exprmtA$PreWillMean)
MTVPostAe <- data.frame(exprmtA$ResponseId, exprmtA$Group, exprmtA$Age, exprmtA$AgeNum, '2Post', exprmtA$PostAttSum, exprmtA$PostWillMean)

colnames(MTVPreAe) <- "ParticipantID"
colnames(MTVPreAe)[2] <- "Group"
colnames(MTVPreAe)[3] <- "Age"
colnames(MTVPreAe)[4] <- "AgeNum"
colnames(MTVPreAe)[5] <- "Session"
colnames(MTVPreAe)[6] <- "AttScore"
colnames(MTVPreAe)[7] <- "WillScore"

colnames(MTVPostAe) <- "ParticipantID"
colnames(MTVPostAe)[2] <- "Group"
colnames(MTVPostAe)[3] <- "Age"
colnames(MTVPostAe)[4] <- "AgeNum"
colnames(MTVPostAe)[5] <- "Session"
colnames(MTVPostAe)[6] <- "AttScore"
colnames(MTVPostAe)[7] <- "WillScore"

MTVAe <- rbind(MTVPreAe, MTVPostAe)

#Moderation Analysis with Age
#Attitude
ModelE2A1 <- lme(AttScore ~ Session + Age, data=MTV, random = ~1|ParticipantID, method="ML") #random intercept + Session + Age
ModelE2A2 <- lme(AttScore ~ Group + Age, data=MTV, random = ~1|ParticipantID, method="ML") #random intercept + Group + Age
ModelE2A3 <- lme(AttScore ~ Session + Group + Age, data=MTV, random = ~1|ParticipantID, method="ML") #random intercept + Session + Group + Age

anova(ModelE2A1, ModelE2A2, ModelE2A3)

ModelE2A4 <- lme(AttScore ~ Session + Age + Session:Age, data=MTV, random = ~1|ParticipantID, method="ML") #random intercept + Session + Age + Session:Age Interaction
#ModelE2A5 <- lme(AttScore ~ Group + Age + Group:Age, data=MTV, random = ~1|ParticipantID, method="ML") #random intercept + Group + Age + Group:Age Interaction
ModelE2A6 <- lme(AttScore ~ Session + Group + Age + Session:Group + Session:Age, data=MTV, random = ~1|ParticipantID, method="ML") #random intercept + Session + Group + S:G Interaction + Session:Age + Group:Age

anova(ModelE2A1, ModelE2A4)
#anova(ModelE2A2, ModelE2A5)
anova(ModelE2A3, ModelE2A6)
summary(ModelE2A4)
#summary(ModelE2A5)
summary(ModelE2A6)

#Willingness 
ModelE2A1W <- lme(WillScore ~ Session + Age, data=MTV, random = ~1|ParticipantID, method="ML") #random intercept + Session + Age
ModelE2A2W <- lme(WillScore ~ Group + Age, data=MTV, random = ~1|ParticipantID, method="ML") #random intercept + Group + Age
ModelE2A3W <- lme(WillScore ~ Session + Group + Age, data=MTV, random = ~1|ParticipantID, method="ML") #random intercept + Session + Group + Age

anova(ModelE2A1W, ModelE2A2W, ModelE2A3W)

ModelE2A4W <- lme(WillScore ~ Session + Age + Session:Age, data=MTV, random = ~1|ParticipantID, method="ML") #random intercept + Session + Age + Session:Age Interaction
#ModelE2A5W <- lme(WillScore ~ Group + Age + Group:Age, data=MTV, random = ~1|ParticipantID, method="ML") #random intercept + Group + Age + Group:Age Interaction
ModelE2A6W <- lme(WillScore ~ Session + Group + Age +Session:Group + Session:Age, data=MTV, random = ~1|ParticipantID, method="ML") #random intercept + Session + Group + S:G Interaction + Session:Age + Group:Age

anova(ModelE2A1W, ModelE2A4W)
#anova(ModelE2A2W, ModelE2A5W)
anova(ModelE2A3W, ModelE2A6W)
summary(ModelE2A4W)
#summary(ModelE2A5W)
summary(ModelE2A6W)

#Age 1: 18 - 29
y1cA1=mean(controlA1$PreAttSum)
y2cA1=mean(controlA1$PostAttSum)
y1eA1=mean(exprmtA1$PreAttSum)
y2eA1=mean(exprmtA1$PostAttSum)

by_Att1 <- MTVA1 %>% group_by(Group, Session) %>% summarise(AttScore = mean(AttScore))

ggplot(by_Att1) + 
  geom_bar(aes(x = Group, y=AttScore, fill = Session), position = position_dodge(preserve = 'single'), stat = 'identity') +  
  coord_cartesian(ylim=c(1.18,24.82))+  
  geom_segment(aes(x = 0.75, y = y1cA1, xend = 1.25, yend = y2cA1))+ geom_segment(aes(x = 1.75, y = y1eA1, xend = 2.25, yend = y2eA1))+
  ylab("Attitute Score Age 18 - 29")+ labs(fill = "Moment of measure")

#Age 2: 30 - 39
y1cA2=mean(controlA2$PreAttSum)
y2cA2=mean(controlA2$PostAttSum)
y1eA2=mean(exprmtA2$PreAttSum)
y2eA2=mean(exprmtA2$PostAttSum)

by_Att2 <- MTVA2 %>% group_by(Group, Session) %>% summarise(AttScore = mean(AttScore))

ggplot(by_Att2) + 
  geom_bar(aes(x = Group, y=AttScore, fill = Session), position = position_dodge(preserve = 'single'), stat = 'identity') +  
  coord_cartesian(ylim=c(1.18,24.82))+  
  geom_segment(aes(x = 0.75, y = y1cA2, xend = 1.25, yend = y2cA2))+ geom_segment(aes(x = 1.75, y = y1eA2, xend = 2.25, yend = y2eA2))+
  ylab("Attitute Score Age 30 - 39")+ labs(fill = "Moment of measure")

#Age 3: 40 - 49
y1cA3=mean(controlA3$PreAttSum)
y2cA3=mean(controlA3$PostAttSum)
y1eA3=mean(exprmtA3$PreAttSum)
y2eA3=mean(exprmtA3$PostAttSum)

by_Att3 <- MTVA3 %>% group_by(Group, Session) %>% summarise(AttScore = mean(AttScore), .groups = 'drop')

ggplot(by_Att3) + 
  geom_bar(aes(x = Group, y=AttScore, fill = Session), position = position_dodge(preserve = 'single'), stat = 'identity') +  
  coord_cartesian(ylim=c(1.18,24.82))+  
  geom_segment(aes(x = 0.75, y = y1cA3, xend = 1.25, yend = y2cA3))+ geom_segment(aes(x = 1.75, y = y1eA3, xend = 2.25, yend = y2eA3))+
  ylab("Attitute Score Age 40 - 49")+ labs(fill = "Moment of measure")

#Age 4&5: 50 - 69
y1cA45=mean(controlA45$PreAttSum)
y2cA45=mean(controlA45$PostAttSum)
y1eA45=mean(exprmtA45$PreAttSum)
y2eA45=mean(exprmtA45$PostAttSum)

by_Att45 <- MTVA45 %>% group_by(Group, Session) %>% summarise(AttScore = mean(AttScore), .groups = 'drop')

ggplot(by_Att45) + 
  geom_bar(aes(x = Group, y=AttScore, fill = Session), position = position_dodge(preserve = 'single'), stat = 'identity') +  
  coord_cartesian(ylim=c(1.18,25.82))+  
  geom_segment(aes(x = 0.75, y = y1cA45, xend = 1.25, yend = y2cA45))+ geom_segment(aes(x = 1.75, y = y1eA45, xend = 2.25, yend = y2eA45))+
  ylab("Attitute Score Age 50 - 69")+ labs(fill = "Moment of measure")

#Gender Exploratory analysis
Dataset$Gender = factor(Dataset$Gender, levels = c("1","2"))

MTVGPre <- data.frame(Dataset$ResponseId, Dataset$Group, Dataset$Gender, '1Pre', Dataset$PreAttSum, Dataset$PreWillMean)
MTVGPost <- data.frame(Dataset$ResponseId, Dataset$Group, Dataset$Gender, '2Post', Dataset$PostAttSum, Dataset$PostWillMean)

colnames(MTVGPre) <- "ParticipantID"
colnames(MTVGPre)[2] <- "Group"
colnames(MTVGPre)[3] <- "Gender"
colnames(MTVGPre)[4] <- "Session"
colnames(MTVGPre)[5] <- "AttScore"
colnames(MTVGPre)[6] <- "WillScore"

colnames(MTVGPost) <- "ParticipantID"
colnames(MTVGPost)[2] <- "Group"
colnames(MTVGPost)[3] <- "Gender"
colnames(MTVGPost)[4] <- "Session"
colnames(MTVGPost)[5] <- "AttScore"
colnames(MTVGPost)[6] <- "WillScore"

MTVG <- rbind(MTVGPre, MTVGPost)

MTVG1 = MTVG[MTVG$Gender == "1", ]
MTVG2 = MTVG[MTVG$Gender == "2", ]

DataG1 = Dataset[Dataset$Gender == '1', ]
DataG2 = Dataset[Dataset$Gender == '2', ]

controlG1= DataG1[DataG1$Group=="Control", ]
exprmtG1 = DataG1[DataG1$Group=="Exprmt", ]
controlG2= DataG2[DataG2$Group=="Control", ]
exprmtG2 = DataG2[DataG2$Group=="Exprmt", ]

#Gender: Male
y1cG1=mean(controlG1$PreAttSum)
y2cG1=mean(controlG1$PostAttSum)
y1eG1=mean(exprmtG1$PreAttSum)
y2eG1=mean(exprmtG1$PostAttSum)

by_AttG1 <- MTVG1 %>% group_by(Group, Session) %>% summarise(AttScore = mean(AttScore), .groups = 'drop')

ggplot(by_AttG1) + 
  geom_bar(aes(x = Group, y=AttScore, fill = Session), position = position_dodge(preserve = 'single'), stat = 'identity') +  
  coord_cartesian(ylim=c(1.18,24.82))+  
  geom_segment(aes(x = 0.75, y = y1cG1, xend = 1.25, yend = y2cG1))+ geom_segment(aes(x = 1.75, y = y1eG1, xend = 2.25, yend = y2eG1))+
  ylab("Attitute Score Gender Male")+ labs(fill = "Moment of measure")

#Gender: Female
y1cG2=mean(controlG2$PreAttSum)
y2cG2=mean(controlG2$PostAttSum)
y1eG2=mean(exprmtG2$PreAttSum)
y2eG2=mean(exprmtG2$PostAttSum)

by_AttG2 <- MTVG2 %>% group_by(Group, Session) %>% summarise(AttScore = mean(AttScore), .groups = 'drop')

ggplot(by_AttG2) + 
  geom_bar(aes(x = Group, y=AttScore, fill = Session), position = position_dodge(preserve = 'single'), stat = 'identity') +  
  coord_cartesian(ylim=c(1.18,24.82))+  
  geom_segment(aes(x = 0.75, y = y1cG2, xend = 1.25, yend = y2cG2))+ geom_segment(aes(x = 1.75, y = y1eG2, xend = 2.25, yend = y2eG2))+
  ylab("Attitute Score Gender Female")+ labs(fill = "Moment of measure")

#Moderation Analysis with Gender
#Attitude
ModelE3G1 <- lme(AttScore ~ Session + Gender, data=MTVG, random = ~1|ParticipantID, method="ML") #random intercept + Session + Gender
ModelE3G2 <- lme(AttScore ~ Group + Gender, data=MTVG, random = ~1|ParticipantID, method="ML") #random intercept + Group + Gender
ModelE3G3 <- lme(AttScore ~ Session + Group + Gender, data=MTVG, random = ~1|ParticipantID, method="ML") #random intercept + Session + Group + Gender

anova(ModelE3G1, ModelE3G2, ModelE3G3)

ModelE3G4 <- lme(AttScore ~ Session + Gender + Session:Gender, data=MTVG, random = ~1|ParticipantID, method="ML") #random intercept + Session + Gender + Session:Gender Interaction
ModelE3G5 <- lme(AttScore ~ Group + Gender + Group:Gender, data=MTVG, random = ~1|ParticipantID, method="ML") #random intercept + Group + Gender + Group:Gender Interaction
ModelE3G6 <- lme(AttScore ~ Session + Group + Gender + Session:Group + Session:Gender + Group:Gender, data=MTVG, random = ~1|ParticipantID, method="ML") #random intercept + Session + Group + S:G Interaction + Session:Gender + Group:Gender

anova(ModelE3G1, ModelE3G4)
anova(ModelE3G2, ModelE3G5)
anova(ModelE3G3, ModelE3G6)
summary(ModelE3G4)
summary(ModelE3G5)
summary(ModelE3G6)

#Willingness 
ModelE3G1W <- lme(WillScore ~ Session + Gender, data=MTVG, random = ~1|ParticipantID, method="ML") #random intercept + Session + Gender
ModelE3G2W <- lme(WillScore ~ Group + Gender, data=MTVG, random = ~1|ParticipantID, method="ML") #random intercept + Group + Gender
ModelE3G3W <- lme(WillScore ~ Session + Group + Gender, data=MTVG, random = ~1|ParticipantID, method="ML") #random intercept + Session + Group + Gender

anova(ModelE3G1W, ModelE3G2W, ModelE3G3W)

ModelE3G4W <- lme(WillScore ~ Session + Gender + Session:Gender, data=MTVG, random = ~1|ParticipantID, method="ML") #random intercept + Session + Gender + Session:Gender Interaction
ModelE3G5W <- lme(WillScore ~ Group + Gender + Group:Gender, data=MTVG, random = ~1|ParticipantID, method="ML") #random intercept + Group + Gender + Group:Gender Interaction
ModelE3G6W <- lme(WillScore ~ Session + Group + Gender + Session:Group + Session:Gender + Group:Gender, data=MTVG, random = ~1|ParticipantID, method="ML") #random intercept + Session + Group + S:G Interaction + Session:Gender + Group:Gender
ModelE3G7W <- lme(WillScore ~ Session + Group + Session:Group + Session:Gender, data=MTVG, random = ~1|ParticipantID, method="ML") #random intercept + Session + Group + S:G Interaction + Session:Gender + Group:Gender
ModelE3G8W <- lme(WillScore ~ Session + Group + Session:Group + Group:Gender, data=MTVG, random = ~1|ParticipantID, method="ML") #random intercept + Session + Group + S:G Interaction + Session:Gender + Group:Gender
ModelE3G0W <- lme(WillScore ~ Session + Group + Session:Group, data=MTVG, random = ~1|ParticipantID, method="ML") #random intercept + Session + Group + S:G Interaction + Session:Gender + Group:Gender
ModelE3G9W <- lme(WillScore ~ Session + Group + Gender + Session:Group , data=MTVG, random = ~1|ParticipantID, method="ML") #random intercept + Session + Group + S:G Interaction + Session:Gender + Group:Gender

anova(ModelE3G1W, ModelE3G4W)
anova(ModelE3G2W, ModelE3G5W)
anova(ModelE3G3W, ModelE3G6W)
summary(ModelE3G4W)
summary(ModelE3G5W)
summary(ModelE3G6W)

#covariate check
cor(as.numeric(MTV$Age),MTV$AttScore,method = "spearman")
scatterplot(MTV$Age, MTV$AttScore)

cor(as.numeric(MTVG$Gender), MTV$AttScore, method = "spearman")
scatterplot(MTVG$Gender, MTVG$AttScore)

cor.test(as.numeric(MTV$Age), MTV$AttScore,method = "spearman")
cor.test(as.numeric(MTVG$Gender), MTV$AttScore, method = "spearman")
cor.test(MtvIIC$IICScore, MtvIIC$AttScore, method = "pearson")

cor.test(MtvIICc$IICScore, MtvIICc$AttScore, method = "pearson")
cor.test(MtvIICe$IICScore, MtvIICe$AttScore, method = "pearson")

ModelTEST <- lme(AttScore ~ Group:IICScore, data=MtvIIC, random = ~1|ParticipantID, method="ML") #random intercept + Session + Group + IICScore
ModelTEST1 <- lme(AttScore ~ IICScore + Group:IICScore, data=MtvIIC, random = ~1|ParticipantID, method="ML")
ModelTEST11 <- lme(AttScore ~ IICScore + Group:IICScore + Group, data=MtvIIC, random = ~1|ParticipantID, method="ML")

cor.test(as.numeric(MTV$Age), MTV$WillScore,method = "spearman")
cor.test(as.numeric(MTVG$Gender), MTV$WillScore, method = "spearman")
cor.test(MtvIIC$IICScore, MtvIIC$WillScore, method = "pearson")

cor.test(as.numeric(MTVAc$Age), MTVAc$WillScore, method = "spearman")
cor.test(as.numeric(MTVAe$Age), MTVAe$WillScore, method = "spearman")

cor.test(MtvIICc$IICScore, MtvIICc$WillScore, method = "pearson")
cor.test(MtvIICe$IICScore, MtvIICe$WillScore, method = "pearson")

ModelTEST2 <- lme(WillScore ~ Group:IICScore, data=MtvIIC, random = ~1|ParticipantID, method="ML") 
ModelTEST3 <- lme(WillScore ~ IICScore + Group:IICScore, data=MtvIIC, random = ~1|ParticipantID, method="ML")
ModelTEST23 <- lme(WillScore ~ IICScore + Group:IICScore + Group, data=MtvIIC, random = ~1|ParticipantID, method="ML")
summary(ModelTEST2)
summary(ModelTEST3)


Model00 <- lme(WillScore ~ IICScore, data=MtvIIC, random = ~1|ParticipantID, method="ML") 
Model01 <- lme(WillScore ~ IICScore + Session, data=MtvIIC, random = ~1|ParticipantID, method="ML") 
Model02 <- lme(WillScore ~ IICScore + Group, data=MtvIIC, random = ~1|ParticipantID, method="ML") 
Model03 <- lme(WillScore ~ IICScore + Session + Group, data=MtvIIC, random = ~1|ParticipantID, method="ML") 
Model04 <- lme(WillScore ~ IICScore + Session + Group + Session:Group, data=MtvIIC, random = ~1|ParticipantID, method="ML") 

anova(Model00, Model01)
anova(Model00, Model02)
anova(Model00, Model03)
anova(Model03, Model04)
