function [fig_handle, varargout] = New_figure_with_axes(fig_handle_str, ax_logical)


%% Make figure if not there, clear if exist
if nargin==0
    fig_handle = figure;
    ax_logical = false;
    %s_command = sprintf('fig_handle = figure;', fig_handle_str);
    %eval(s_command);

else

    s_command = sprintf('exist(''%s'', ''var'') && ishghandle(%s)', ...
                    fig_handle_str, fig_handle_str);
    fig_exist = evalin('caller', s_command);
    if fig_exist
        s_command   = sprintf('clf(%s);', fig_handle_str);
        evalin('caller', s_command);
        s_command   = sprintf('%s;', fig_handle_str);
        fig_handle  = evalin('caller', s_command);
    else
        fig_handle = figure;
%         s_command = sprintf('fig_handle = figure;', fig_handle_str);
%         eval(s_command);
    end
end

%% Maximize figure
% Inspired by from https://undocumentedmatlab.com/blog/minimize-maximize-figure-window
Old_position    = fig_handle.Position;
drawnow         % wait until figure fully rendered
warning('off','MATLAB:HandleGraphics:ObsoletedProperty:JavaFrame')
jFrame          = get(handle(fig_handle),'JavaFrame');
jFrame.setMaximized(true);
time_spent      = 0;
tic;
% Update figure until position has realy changed
while all(fig_handle.Position == Old_position) && time_spent<=1 % just to make sure ths is not infinite loop
     drawnow
     time_spent = toc;
end

%% Create axes if needed
if ax_logical
    for i = 1 : (nargout-1)
        varargout{i} = axes('Parent', fig_handle);
    end
%     s_command = sprintf('ax_%s = axes(''Parent'', %s);', fig_handle_str, fig_handle_str);
%     evalin('caller', s_command);
else
    varargout = [];
end